/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;

public class TypeSubstitutionEdge
extends DefaultEdge {
    private JPopupMenu menu;

    private void showProperty() {
        this.getTopView().getModel().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public String getName() {
        return this.getTopView().getModel().getName();
    }

    @Override
    public void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TypeSubstitutionEdge.this.deleteModel();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TypeSubstitutionEdge.this.format();
                    }
                });
            }
        }
        return this.menu;
    }

    public void deleteModel() {
        DesignObject designObject = this.getTopView().getModel();
        TVConnector tVConnector = (TVConnector)this.getTopView();
        if (tVConnector.remove(designObject)) {
            ApplicationView.log(MessageFormat.format(Messages.getString("TypeSubstitutionEdge.Delete"), designObject.getObjectTypeName(), designObject.getName()));
        }
    }

    @Override
    public void deleteSelected() {
        this.deleteModel();
    }
}

