/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Set;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.AttributeMap;
import oracle.dbtools.crest.swingui.diagram.graph.CellHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramContext;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.Port;
import oracle.dbtools.crest.swingui.diagram.graph.PortRenderer;

public class PortView
extends AbstractCellView {
    protected static int size = 3;
    public static PortRenderer renderer = new PortRenderer();
    protected transient CellView lastParent;
    public Point2D point = null;
    public Point2D ip = new Point2D.Double(0.0, 0.0);

    public PortView(Object object, AbstractDiagram abstractDiagram, CellMapper cellMapper) {
        super(object, abstractDiagram, cellMapper);
    }

    @Override
    public CellView getParentView() {
        CellView cellView = super.getParentView();
        if (cellView == null) {
            cellView = this.lastParent;
        } else {
            this.lastParent = cellView;
        }
        return cellView;
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D;
        if (this.point != null) {
            Rectangle2D rectangle2D2 = this.getParentView().getBounds();
            this.point.setLocation(rectangle2D2.getX() + this.ip.getX(), rectangle2D2.getY() + this.ip.getY());
            rectangle2D = DiagramConstants.createRect(this.point);
        } else {
            rectangle2D = DiagramConstants.createRect(this.getLocation(null));
        }
        rectangle2D.setFrame(rectangle2D.getX() - (double)size, rectangle2D.getY() - (double)size, rectangle2D.getWidth() + (double)size, rectangle2D.getHeight() + (double)size);
        return rectangle2D;
    }

    @Override
    public CellViewRenderer getRenderer() {
        return renderer;
    }

    @Override
    public CellHandle getHandle(DiagramContext diagramContext) {
        return null;
    }

    public PortView getOtherPortAt(Point2D point2D) {
        CellView cellView = this.getParentView();
        DiagramModel diagramModel = this.getModel();
        for (int i = 0; i < diagramModel.getChildCount(cellView.getCell()); ++i) {
            PortView portView;
            CellView cellView2;
            Object object = diagramModel.getChild(cellView.getCell(), i);
            if (!this.diagram.getDiagramLayoutCache().isVisible(object) || (cellView2 = this.mapper.getMapping(object, false)) == null || !diagramModel.isPort(object) || !(cellView2 instanceof PortView) || (portView = (PortView)cellView2) == null || portView == this || !(point2D.distance(portView.getPoint()) < 10.0)) continue;
            return portView;
        }
        return null;
    }

    public Point2D getLocation(EdgeView edgeView) {
        CellView cellView;
        if (this.isAutoRoute()) {
            CellView cellView2;
            if (this.point != null && (cellView2 = this.getParentView()) != null) {
                Rectangle2D rectangle2D = this.getParentView().getBounds();
                this.point.setLocation(rectangle2D.getX() + this.ip.getX(), rectangle2D.getY() + this.ip.getY());
                this.fixPoint();
                this.setPoint(this.point);
            }
            return this.getAutoLocation(edgeView);
        }
        if (edgeView != null && edgeView.getPointCount() <= 2) {
            CellView cellView3;
            if (this.point != null && (cellView3 = this.getParentView()) != null) {
                Rectangle2D rectangle2D = this.getParentView().getBounds();
                this.point.setLocation(rectangle2D.getX() + this.ip.getX(), rectangle2D.getY() + this.ip.getY());
                this.fixPoint();
                this.setPoint(this.point);
                return this.point;
            }
        } else if (this.point != null && (cellView = this.getParentView()) != null) {
            Rectangle2D rectangle2D = cellView.getBounds();
            this.point.setLocation(rectangle2D.getX() + this.ip.getX(), rectangle2D.getY() + this.ip.getY());
            this.fixPoint();
            this.setPoint(this.point);
        }
        return this.getSimpleLocation(edgeView);
    }

    public boolean isAutoRoute() {
        return ((Diagram)this.diagram).getDesignPartView().isAutoRoute();
    }

    public Point2D getPoint() {
        if (this.point == null) {
            this.getSimpleLocation(null);
        }
        return this.point;
    }

    public void setPoint(Point2D point2D) {
        if (point2D != null) {
            if (this.point == null) {
                this.point = point2D;
            } else {
                this.point.setLocation(point2D);
            }
            CellView cellView = this.getParentView();
            if (cellView != null) {
                Rectangle2D rectangle2D = cellView.getBounds();
                this.ip.setLocation(point2D.getX() - rectangle2D.getX(), point2D.getY() - rectangle2D.getY());
            }
        }
    }

    public void fixPoint() {
        Rectangle2D rectangle2D = this.getParentView().getBounds();
        double d = this.point.getX();
        double d2 = this.point.getY();
        if (d < rectangle2D.getX()) {
            d = rectangle2D.getX();
        } else if (d > rectangle2D.getMaxX()) {
            d = rectangle2D.getMaxX();
        }
        if (d2 < rectangle2D.getY()) {
            d2 = rectangle2D.getY();
        } else if (d2 > rectangle2D.getMaxY()) {
            d2 = rectangle2D.getMaxY();
        }
        if (d > rectangle2D.getX() && d <= rectangle2D.getCenterX() && d2 > rectangle2D.getY() && d2 <= rectangle2D.getCenterY()) {
            if (d - rectangle2D.getX() < d2 - rectangle2D.getY()) {
                d = rectangle2D.getX();
            } else {
                d2 = rectangle2D.getY();
            }
        } else if (d > rectangle2D.getX() && d <= rectangle2D.getCenterX() && d2 < rectangle2D.getMaxY() && d2 > rectangle2D.getCenterY()) {
            if (d - rectangle2D.getX() < rectangle2D.getMaxY() - d2) {
                d = rectangle2D.getX();
            } else {
                d2 = rectangle2D.getMaxY();
            }
        } else if (d < rectangle2D.getMaxX() && d > rectangle2D.getCenterX() && d2 > rectangle2D.getY() && d2 <= rectangle2D.getCenterY()) {
            if (rectangle2D.getMaxX() - d < d2 - rectangle2D.getY()) {
                d = rectangle2D.getMaxX();
            } else {
                d2 = rectangle2D.getY();
            }
        } else if (d < rectangle2D.getMaxX() && d > rectangle2D.getCenterX() && d2 < rectangle2D.getMaxY() && d2 > rectangle2D.getCenterY()) {
            if (rectangle2D.getMaxX() - d < rectangle2D.getMaxY() - d2) {
                d = rectangle2D.getMaxX();
            } else {
                d2 = rectangle2D.getMaxY();
            }
        }
        this.point.setLocation(d, d2);
    }

    public Point2D getSimpleLocation(EdgeView edgeView) {
        Port port = null;
        if (this.cell instanceof Port) {
            port = ((Port)this.cell).getAnchor();
        }
        PortView portView = (PortView)this.mapper.getMapping(port, false);
        Point2D point2D = null;
        boolean bl = DiagramConstants.isAbsolute(this.allAttributes);
        Point2D point2D2 = DiagramConstants.getOffset(this.allAttributes);
        AbstractCellView abstractCellView = (AbstractCellView)this.getParentView();
        if (abstractCellView != null) {
            if (edgeView == null && point2D2 == null) {
                point2D = abstractCellView.getCenterPoint();
            }
            if (point2D2 != null) {
                double d = point2D2.getX();
                double d2 = point2D2.getY();
                Rectangle2D rectangle2D = abstractCellView.getBounds();
                if (!bl) {
                    d = d * (rectangle2D.getWidth() - 1.0) / 1000.0;
                    d2 = d2 * (rectangle2D.getHeight() - 1.0) / 1000.0;
                }
                point2D = portView != null ? portView.getLocation(edgeView) : DiagramConstants.createPoint(rectangle2D.getX(), rectangle2D.getY());
                point2D = DiagramConstants.createPoint(point2D.getX() + d, point2D.getY() + d2);
            } else if (edgeView != null) {
                Point2D point2D3 = this.getNextPoint(edgeView);
                if (point2D3 == null) {
                    return abstractCellView.getCenterPoint();
                }
                point2D = abstractCellView.getPerimeterPoint(point2D, point2D3, edgeView.getPointCount() <= 2);
                if (edgeView.getPointCount() > 2 && DiagramConstants.getRouting(edgeView.getAllAttributes()) == null && point2D3 != null) {
                    Rectangle2D rectangle2D = this.getParentView().getBounds();
                    if (point2D3.getX() >= rectangle2D.getX() && point2D3.getX() <= rectangle2D.getX() + rectangle2D.getWidth()) {
                        point2D.setLocation(point2D3.getX(), point2D.getY());
                    } else if (point2D3.getY() >= rectangle2D.getY() && point2D3.getY() <= rectangle2D.getY() + rectangle2D.getHeight()) {
                        point2D.setLocation(point2D.getX(), point2D3.getY());
                    }
                    if (point2D3.getX() < rectangle2D.getX()) {
                        point2D.setLocation(rectangle2D.getX(), point2D.getY());
                    } else if (point2D3.getX() > rectangle2D.getX() + rectangle2D.getWidth()) {
                        point2D.setLocation(rectangle2D.getX() + rectangle2D.getWidth(), point2D.getY());
                    }
                    if (point2D3.getY() < rectangle2D.getY()) {
                        point2D.setLocation(point2D.getX(), rectangle2D.getY());
                    } else if (point2D3.getY() > rectangle2D.getY() + rectangle2D.getHeight()) {
                        point2D.setLocation(point2D.getX(), rectangle2D.getY() + rectangle2D.getHeight());
                    }
                }
            }
        }
        if (this.point == null && point2D != null) {
            this.point = DiagramConstants.createPoint(point2D);
            this.fixPoint();
            this.setPoint(this.point);
        }
        return point2D;
    }

    public Point2D getAutoLocation(EdgeView edgeView) {
        Cloneable cloneable;
        Cloneable cloneable2;
        Cloneable cloneable3;
        Port port = null;
        if (this.cell instanceof Port) {
            port = ((Port)this.cell).getAnchor();
        }
        PortView portView = (PortView)this.mapper.getMapping(port, false);
        Point2D point2D = null;
        boolean bl = DiagramConstants.isAbsolute(this.allAttributes);
        Point2D point2D2 = DiagramConstants.getOffset(this.allAttributes);
        AbstractCellView abstractCellView = (AbstractCellView)this.getParentView();
        if (abstractCellView != null) {
            if (edgeView == null && point2D2 == null) {
                point2D = abstractCellView.getCenterPoint();
            }
            if (point2D2 != null) {
                double d = point2D2.getX();
                double d2 = point2D2.getY();
                cloneable3 = abstractCellView.getBounds();
                if (!bl) {
                    d = d * (((RectangularShape)cloneable3).getWidth() - 1.0) / 1000.0;
                    d2 = d2 * (((RectangularShape)cloneable3).getHeight() - 1.0) / 1000.0;
                }
                cloneable2 = new AttributeMap();
                point2D = portView != null ? portView.getLocation(edgeView) : ((AttributeMap)cloneable2).createPoint(((RectangularShape)cloneable3).getX(), ((RectangularShape)cloneable3).getY());
                point2D = ((AttributeMap)cloneable2).createPoint(point2D.getX() + d, point2D.getY() + d2);
            } else if (edgeView != null) {
                Point2D point2D3 = this.getNextPoint(edgeView);
                if (point2D3 == null) {
                    return abstractCellView.getCenterPoint();
                }
                point2D = abstractCellView.getPerimeterPoint(point2D, point2D3, edgeView.getPointCount() <= 2);
                if (edgeView.getPointCount() > 2 && DiagramConstants.getRouting(edgeView.getAllAttributes()) == null && point2D3 != null) {
                    cloneable = this.getParentView().getBounds();
                    if (point2D3.getX() > ((RectangularShape)cloneable).getX() && point2D3.getX() < ((RectangularShape)cloneable).getX() + ((RectangularShape)cloneable).getWidth()) {
                        point2D.setLocation(point2D3.getX(), point2D.getY());
                    } else if (point2D3.getY() >= ((RectangularShape)cloneable).getY() && point2D3.getY() < ((RectangularShape)cloneable).getY() + ((RectangularShape)cloneable).getHeight()) {
                        point2D.setLocation(point2D.getX(), point2D3.getY());
                    }
                    if (point2D3.getY() < ((RectangularShape)cloneable).getY()) {
                        point2D.setLocation(point2D.getX(), ((RectangularShape)cloneable).getY());
                    } else if (point2D3.getY() > ((RectangularShape)cloneable).getY() + ((RectangularShape)cloneable).getHeight()) {
                        point2D.setLocation(point2D.getX(), ((RectangularShape)cloneable).getY() + ((RectangularShape)cloneable).getHeight());
                    }
                }
            }
        }
        if (edgeView != null && this.isAutoRoute()) {
            Rectangle2D rectangle2D = abstractCellView.getBounds();
            cloneable = abstractCellView.getCenterPoint();
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
            Point2D.Double double_2 = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight());
            cloneable3 = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
            cloneable2 = new Point2D.Double(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY());
            double d = Math.atan2(((Point2D)cloneable).getY() - ((Point2D)double_).getY(), ((Point2D)double_).getX() - ((Point2D)cloneable).getX());
            double d3 = Math.atan2(((Point2D)cloneable).getY() - ((Point2D)double_2).getY(), ((Point2D)double_2).getX() - ((Point2D)cloneable).getX());
            double d4 = Math.atan2(((Point2D)cloneable).getY() - ((Point2D)cloneable3).getY(), ((Point2D)cloneable3).getX() - ((Point2D)cloneable).getX());
            double d5 = Math.atan2(((Point2D)cloneable).getY() - ((Point2D)cloneable2).getY(), ((Point2D)cloneable2).getX() - ((Point2D)cloneable).getX());
            double d6 = Math.atan2(((Point2D)cloneable).getY() - point2D.getY(), point2D.getX() - ((Point2D)cloneable).getX());
            double d7 = 7.0;
            int n = 2;
            Point2D point2D4 = this.getDXY(d6, d, d3, d4, d5, d7);
            Object[] objectArray = this.getEdges(edgeView);
            if (objectArray != null && !edgeView.isSelfReference()) {
                if (objectArray.length > 1) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object = objectArray[i];
                        if (i == n) {
                            n += 2;
                            point2D4 = this.getDXY(d6, d, d3, d4, d5, d7 += 14.0);
                        }
                        double d8 = 0.0;
                        d8 = point2D4.getY() > 0.0 ? rectangle2D.getHeight() / 2.0 : rectangle2D.getWidth() / 2.0;
                        if (d7 > d8) {
                            d7 = d8;
                            point2D4 = this.getDXY(d6, d, d3, d4, d5, d7);
                        }
                        if (!edgeView.getCell().equals(object)) continue;
                        if (i % 2 == 0) {
                            point2D.setLocation(point2D.getX() - point2D4.getX(), point2D.getY() - point2D4.getY());
                            if (edgeView.getSource().equals(this)) {
                                edgeView.setSourceOffcet(-d7);
                                continue;
                            }
                            edgeView.setTargetOffcet(-d7);
                            continue;
                        }
                        point2D.setLocation(point2D.getX() + point2D4.getX(), point2D.getY() + point2D4.getY());
                        if (edgeView.getSource().equals(this)) {
                            edgeView.setSourceOffcet(d7);
                            continue;
                        }
                        edgeView.setTargetOffcet(d7);
                    }
                } else {
                    edgeView.setSourceOffcet(0.0);
                    edgeView.setTargetOffcet(0.0);
                }
            }
        }
        return point2D;
    }

    private Point2D getDXY(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        if (d >= d4) {
            d8 = 0.0;
            d7 = d6;
        } else if (d >= d5) {
            d8 = d6;
            d7 = 0.0;
        } else if (d >= d2) {
            d8 = 0.0;
            d7 = d6;
        } else if (d >= d3) {
            d8 = d6;
            d7 = 0.0;
        } else {
            d8 = 0.0;
            d7 = d6;
        }
        return new Point2D.Double(d8, d7);
    }

    private Object[] getEdges(EdgeView edgeView) {
        if (edgeView.getSource() == null || edgeView.getTarget() == null || edgeView.getSource().getParentView() == null || edgeView.getTarget().getParentView() == null) {
            return null;
        }
        return PortView.getEdgesBetween(edgeView.getDiagram(), edgeView.getSource().getParentView().getCell(), edgeView.getTarget().getParentView().getCell());
    }

    public static Object[] getEdgesBetween(AbstractDiagram abstractDiagram, Object object, Object object2) {
        return PortView.getEdgesBetween(abstractDiagram, object, object2, false);
    }

    public static Object[] getEdgesBetween(AbstractDiagram abstractDiagram, Object object, Object object2, boolean bl) {
        ArrayList arrayList = new ArrayList();
        Set set = DefaultDiagramModel.getEdges(abstractDiagram.getModel(), new Object[]{object, object2});
        for (Object e : set) {
            if (PortView.isGroup(abstractDiagram, e)) continue;
            Object object3 = PortView.getSourceVertex(abstractDiagram, e);
            Object object4 = PortView.getTargetVertex(abstractDiagram, e);
            if (object3 != object && object4 != object2) continue;
            arrayList.add(e);
        }
        return arrayList.toArray();
    }

    public static Object getSourceVertex(AbstractDiagram abstractDiagram, Object object) {
        return DefaultDiagramModel.getSourceVertex(abstractDiagram.getModel(), object);
    }

    public static Object getTargetVertex(AbstractDiagram abstractDiagram, Object object) {
        return DefaultDiagramModel.getTargetVertex(abstractDiagram.getModel(), object);
    }

    public static boolean isGroup(AbstractDiagram abstractDiagram, Object object) {
        CellView cellView = abstractDiagram.getDiagramLayoutCache().getMapping(object, false);
        if (cellView != null) {
            return !cellView.isLeaf();
        }
        return false;
    }

    protected Point2D getNextPoint(EdgeView edgeView) {
        int n = edgeView.getPointCount();
        if (n > 1) {
            if (edgeView.getSource() == this) {
                return this.getEdgePoint(edgeView, 1);
            }
            if (edgeView.getTarget() == this) {
                return this.getEdgePoint(edgeView, n - 2);
            }
        }
        return null;
    }

    protected Point2D getEdgePoint(EdgeView edgeView, int n) {
        AbstractCellView abstractCellView;
        Object e = edgeView.points.get(n);
        if (e instanceof Point2D) {
            return (Point2D)e;
        }
        if (e instanceof PortView && (abstractCellView = (AbstractCellView)((CellView)e).getParentView()) != null) {
            return abstractCellView.getCenterPoint();
        }
        return null;
    }

    @Override
    public Point2D getCenterPoint() {
        return null;
    }

    @Override
    public Point2D getPerimeterPoint(Point2D point2D, Point2D point2D2, boolean bl) {
        return null;
    }
}

