/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.LegendDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.LegendView;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class LegendRenderer
extends JLabel
implements CellViewRenderer {
    private static final String title = "LEGEND";
    private static final String LB_DIAGRAM = "Diagram:";
    private static final String LB_AUTHOR = "Author:";
    private static final String LB_CREATED_ON = "Created on:";
    private static final String LB_MODIFIED_ON = "Modified on:";
    public static final String LB_CHANGED_BY = "Changed by:";
    private static final String LB_DESIGN = "Design:";
    private static final String LB_MODEL = "Model:";
    protected transient Legend legend;
    protected transient Color defaultForeground = Color.BLACK;
    protected transient Color defaultBackground = Color.WHITE;
    protected transient Color bordercolor;
    protected transient AbstractDiagram diagram;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected CellView view;
    protected transient int borderWidth;

    protected Color getBackgroundColor() {
        if (this.legend.getTopView().useDefaultColor() || this.legend.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.legend.getDesign().getDLSettings().getDefaultFCObject("Legend");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getBackgroundColor();
            }
            return Color.BLACK;
        }
        return this.legend.getTopView().getBackgroundColor();
    }

    public Color getForegroundColor() {
        if (this.legend.getTopView().useDefaultColor() || this.legend.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.legend.getDesign().getDLSettings().getDefaultFCObject("Legend");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.legend.getTopView().getForegroundColor();
    }

    @Override
    public Color getBGColor() {
        return this.getBackgroundColor();
    }

    @Override
    public Color getFGColor() {
        return this.getForegroundColor();
    }

    public Color getBorderColor() {
        return this.getForegroundColor();
    }

    @Override
    public Component getRendererComponent(AbstractDiagram abstractDiagram, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof LegendView) {
            LegendDiagramCell legendDiagramCell = (LegendDiagramCell)cellView.getCell();
            this.legend = legendDiagramCell.getLegend();
            this.diagram = abstractDiagram;
            this.hasFocus = bl2;
            this.selected = bl;
            this.preview = bl3;
            this.setComponentOrientation(abstractDiagram.getComponentOrientation());
            if (cellView.isLeaf()) {
                this.installAttributes(cellView);
            } else {
                this.setBorder(null);
                this.setOpaque(false);
            }
            this.view = cellView;
            return this;
        }
        return null;
    }

    protected void installAttributes(CellView cellView) {
        Color color;
        Map map = cellView.getAllAttributes();
        this.setOpaque(DiagramConstants.isOpaque(map));
        this.setBorder(DiagramConstants.getBorder(map));
        this.bordercolor = DiagramConstants.getBorderColor(map);
        this.borderWidth = Math.max(1, Math.round(DiagramConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground((color = DiagramConstants.getForeground(map)) != null ? color : this.defaultForeground);
        Color color2 = DiagramConstants.getBackground(map);
        this.setBackground(color2 != null ? color2 : this.getBackgroundColor());
        this.setFont(this.diagram.getFont());
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        FontObject fontObject = this.legend.getTextFontObject();
        Color color = fontObject.getColor();
        Font font = fontObject.getFont();
        graphics2D.setFont(font);
        this.setForeground(this.getForegroundColor());
        graphics2D.setPaint(this.getBackgroundColor());
        graphics.fillRect(0, 0, n2 - 1, n3 - 1);
        graphics.setColor(this.getForegroundColor());
        graphics.drawRect(0, 0, n2 - 1, n3 - 1);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        int n5 = (n2 - fontMetrics.stringWidth(title)) / 2;
        if (n5 < 20) {
            n5 = 20;
        }
        int n6 = n / 3;
        BasicStroke basicStroke = new BasicStroke(this.borderWidth);
        int n7 = 10;
        int n8 = fontMetrics.stringWidth(LB_CHANGED_BY) + 30;
        graphics.setColor(color);
        graphics.drawString(LB_DIAGRAM, n7, ++n4);
        graphics.drawString(this.legend.getDiagramName(), n8, n4);
        if (this.legend.showAuthor()) {
            graphics2D.setStroke(basicStroke);
            graphics.setColor(this.getForegroundColor());
            graphics.drawLine(0, n4 += n6 + this.borderWidth, n2 - 2, n4);
            graphics.setColor(color);
            graphics.drawString(LB_AUTHOR, n7, n4 += n);
            graphics.drawString(this.legend.getDiagramAuthor(), n8, n4);
        }
        if (this.legend.showCreatedOn()) {
            graphics2D.setStroke(basicStroke);
            graphics.setColor(this.getForegroundColor());
            graphics.drawLine(0, n4 += n6 + this.borderWidth, n2 - 2, n4);
            graphics.setColor(color);
            graphics.drawString(LB_CREATED_ON, n7, n4 += n);
            graphics.drawString(this.legend.getTimeCreated(), n8, n4);
        }
        if (this.legend.showModifiedOn()) {
            graphics2D.setStroke(basicStroke);
            graphics.setColor(this.getForegroundColor());
            graphics.drawLine(0, n4 += n6 + this.borderWidth, n2 - 2, n4);
            graphics.setColor(color);
            graphics.drawString(LB_MODIFIED_ON, n7, n4 += n);
            graphics.drawString(this.legend.getTimeChanged(), n8, n4);
        }
        if (this.legend.showChangedBy()) {
            graphics2D.setStroke(basicStroke);
            graphics.setColor(this.getForegroundColor());
            graphics.drawLine(0, n4 += n6 + this.borderWidth, n2 - 2, n4);
            graphics.setColor(color);
            graphics.drawString(LB_CHANGED_BY, n7, n4 += n);
            graphics.drawString(this.legend.getModifiedBy(), n8, n4);
        }
        if (this.legend.showDesignName()) {
            graphics2D.setStroke(basicStroke);
            graphics.setColor(this.getForegroundColor());
            graphics.drawLine(0, n4 += n6 + this.borderWidth, n2 - 2, n4);
            graphics.setColor(color);
            graphics.drawString(LB_DESIGN, n7, n4 += n);
            graphics.drawString(this.legend.getDesignName(), n8, n4);
        }
        if (this.legend.showModelName()) {
            graphics2D.setStroke(basicStroke);
            graphics.setColor(this.getForegroundColor());
            graphics.drawLine(0, n4 += n6 + this.borderWidth, n2 - 2, n4);
            graphics.setColor(color);
            graphics.drawString(LB_MODEL, n7, n4 += n);
            graphics.drawString(this.legend.getModelName(), n8, n4);
        }
    }

    public Point2D getPerimeterPoint(LegendView legendView, Point2D point2D, Point2D point2D2, boolean bl) {
        Rectangle2D rectangle2D = legendView.getBounds();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        double d5 = d + d3 / 2.0;
        double d6 = d2 + d4 / 2.0;
        double d7 = point2D2.getX() - d5;
        double d8 = point2D2.getY() - d6;
        double d9 = Math.atan2(d8, d7);
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = Math.PI;
        double d13 = Math.atan2(d4, d3);
        if (d9 < -d12 + d13 || d9 > d12 - d13) {
            d10 = d;
            d11 = d6;
        } else if (d9 < -d13) {
            d11 = d2;
            d10 = d5;
        } else if (d9 < d13) {
            d10 = d + d3;
            d11 = d6;
        } else {
            d11 = d2 + d4;
            d10 = d5;
        }
        return DiagramConstants.createPoint(d10, d11);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    protected DesignPartView getDesignPartView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView().getDesignPartView();
        }
        return null;
    }
}

