/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.LabelDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.LabelView;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class LabelRenderer
extends JTextArea
implements CellViewRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.WHITE;
    public static final Color DEFAULT_BACKGROUND = Color.WHITE;
    public static final Color DEFAULT_BORDER_COLOR = Color.WHITE;
    protected transient Color bordercolor;
    protected transient Color defaultForeground = DEFAULT_FOREGROUND;
    protected transient Color defaultBackground = DEFAULT_BACKGROUND;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient AbstractDiagram diagram;
    protected transient int borderWidth;
    protected transient Label label;

    public LabelRenderer() {
        this.bordercolor = DEFAULT_BORDER_COLOR;
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    @Override
    public Component getRendererComponent(AbstractDiagram abstractDiagram, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof LabelView) {
            LabelDiagramCell labelDiagramCell = (LabelDiagramCell)cellView.getCell();
            this.label = labelDiagramCell.getLabel();
            this.setText(this.label.getText());
            this.diagram = abstractDiagram;
            this.hasFocus = bl2;
            this.selected = bl;
            this.preview = bl3;
            this.setComponentOrientation(abstractDiagram.getComponentOrientation());
        }
        this.installAttributes(cellView);
        return this;
    }

    protected void installAttributes(CellView cellView) {
        Map map = cellView.getAllAttributes();
        this.borderWidth = Math.max(1, Math.round(DiagramConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground(this.getForegroundColor());
        Color color = DiagramConstants.getBackground(map);
        this.setBackground(color != null ? color : this.defaultBackground);
        this.setFont(this.diagram.getFont());
    }

    public Color getBackgroundColor() {
        if (this.label.getTopView().useDefaultColor() || this.label.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.label.getDesign().getDLSettings().getDefaultFCObject("Label");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getBackgroundColor();
            }
            return Color.WHITE;
        }
        return this.label.getTopView().getBackgroundColor();
    }

    public Color getForegroundColor() {
        if (this.label.getTopView().useDefaultColor() || this.label.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.label.getDesign().getDLSettings().getDefaultFCObject("Label");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.label.getTopView().getForegroundColor();
    }

    @Override
    public Color getBGColor() {
        return this.getBackgroundColor();
    }

    @Override
    public Color getFGColor() {
        return this.getForegroundColor();
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.label.isConnectorSelected()) {
            graphics.setXORMode(this.getBackgroundColor().darker());
        }
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        Label label = this.label;
        this.setFont(label.getFontObject(EditableFonts.FO_TEXT).getFont());
        this.setForeground(this.getForegroundColor());
        graphics2D.setPaint(this.getBackgroundColor());
        this.setBorder(null);
        if (this.label.isCenterLabel()) {
            graphics.fillRect(0, 0, n - 1, n2 - 1);
        }
        this.setOpaque(false);
        this.setForeground(label.getFontObject(EditableFonts.FO_TEXT).getColor());
        super.paint(graphics);
    }

    public Point2D getPerimeterPoint(LabelView labelView, Point2D point2D, Point2D point2D2, boolean bl) {
        Rectangle2D rectangle2D = labelView.getBounds();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        double d5 = d + d3 / 2.0;
        double d6 = d2 + d4 / 2.0;
        double d7 = point2D2.getX() - d5;
        double d8 = point2D2.getY() - d6;
        double d9 = Math.atan2(d8, d7);
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = Math.PI;
        double d13 = Math.atan2(d4, d3);
        if (d9 < -d12 + d13 || d9 > d12 - d13) {
            d10 = d;
            d11 = d6;
        } else if (d9 < -d13) {
            d11 = d2;
            d10 = d5;
        } else if (d9 < d13) {
            d10 = d + d3;
            d11 = d6;
        } else {
            d11 = d2 + d4;
            d10 = d5;
        }
        return DiagramConstants.createPoint(d10, d11);
    }
}

