/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramContext;
import oracle.dbtools.crest.swingui.diagram.graph.Edge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.diagram.ui.DiagramUI;
import oracle.dbtools.crest.swingui.diagram.ui.def.DefaultDiagramUI;

public class EdgeView
extends AbstractCellView {
    public static EdgeRenderer renderer = new EdgeRenderer();
    protected List points;
    protected CellView source;
    protected CellView target;
    public Shape beginShape;
    public Shape endShape;
    public Shape lineShape;
    public transient GeneralPath sharedPath = null;
    protected Rectangle2D cachedLabelBounds = null;
    protected Rectangle2D cachedBounds = null;
    private double sourceOffcet = 0.0;
    private double targetOffcet = 0.0;
    private boolean dragging = false;
    private boolean widerLine = false;
    private PortView portView = null;

    public EdgeView(Object object, AbstractDiagram abstractDiagram, CellMapper cellMapper) {
        super(object, abstractDiagram, cellMapper);
        ((DefaultDiagramCell)object).setCellView(this);
    }

    @Override
    public void refresh(boolean bl) {
        super.refresh(bl);
        if (this.points != null) {
            Object object = this.getModel().getSource(this.cell);
            Object object2 = this.getModel().getTarget(this.cell);
            this.setSource(this.mapper.getMapping(object, bl));
            this.setTarget(this.mapper.getMapping(object2, bl));
        }
    }

    public void refreshLabels() {
        TVConnector tVConnector;
        if (this.points != null && (tVConnector = (TVConnector)((DefaultDiagramCell)this.cell).getTopView()) != null && !tVConnector.wait) {
            try {
                if (tVConnector.getLabel(0) != null || tVConnector.getLabel(2) != null) {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    Point2D point2D = ((PortView)this.getSource()).getLocation(this);
                    Point2D point2D2 = ((PortView)this.getTarget()).getLocation(this);
                    Rectangle2D rectangle2D = this.getSource().getParentView().getBounds();
                    Rectangle2D rectangle2D2 = this.getTarget().getParentView().getBounds();
                    Object e = this.points.get(0);
                    Object e2 = this.points.get(this.points.size() - 1);
                    if (this.points.size() > 2) {
                        e = this.points.get(this.points.size() - 2);
                        e2 = this.points.get(1);
                    }
                    Point2D point2D3 = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                    Point2D point2D4 = e2 instanceof PortView ? ((PortView)e2).getPoint() : (Point2D)e2;
                    if (this.points.size() > 2) {
                        if (point2D.getX() < point2D2.getX()) {
                            if (point2D.getX() == point2D4.getX()) {
                                d4 = point2D.getX() + 5.0;
                                d3 = point2D2.getX() + 5.0;
                            } else {
                                d4 = point2D.getX();
                                d3 = point2D2.getX() - 15.0;
                            }
                        } else if (point2D.getX() == point2D4.getX()) {
                            d4 = point2D.getX() + 5.0;
                            d3 = point2D2.getX() + 5.0;
                        } else {
                            d4 = point2D.getX() - 15.0;
                            d3 = point2D2.getX();
                        }
                        if (point2D.getY() < point2D2.getY()) {
                            if (point2D.getY() == point2D4.getY()) {
                                d2 = point2D.getY() + 5.0;
                                d = point2D2.getY() + 5.0;
                            } else {
                                d2 = point2D.getY();
                                d = point2D2.getY() - 15.0;
                            }
                        } else if (point2D.getY() == point2D4.getY()) {
                            d2 = point2D.getY() + 5.0;
                            d = point2D2.getY() + 5.0;
                        } else {
                            d2 = point2D.getY() - 15.0;
                            d = point2D2.getY();
                        }
                    } else if (point2D.getX() != point2D2.getX() && point2D.getY() != point2D2.getY()) {
                        d4 = point2D.getX() + 15.0;
                        d3 = point2D2.getX() + 15.0;
                        d2 = point2D.getY();
                        d = point2D2.getY();
                    } else {
                        if (point2D.getX() < point2D2.getX()) {
                            d4 = point2D.getX() - 15.0;
                            d3 = point2D2.getX();
                        } else if (point2D.getX() > point2D2.getX()) {
                            d4 = point2D.getX();
                            d3 = point2D2.getX() - 15.0;
                        } else {
                            d4 = point2D.getX() + 5.0;
                            d3 = point2D2.getX() + 5.0;
                        }
                        if (point2D.getY() < point2D2.getY()) {
                            d2 = point2D.getY() - 15.0;
                            d = point2D2.getY();
                        } else if (point2D.getY() > point2D2.getY()) {
                            d2 = point2D.getY();
                            d = point2D2.getY() - 15.0;
                        } else {
                            d2 = point2D.getY() + 5.0;
                            d = point2D2.getY() + 5.0;
                        }
                    }
                    Point2D.Double double_ = new Point2D.Double(d4, d2);
                    Point2D.Double double_2 = new Point2D.Double(d3, d);
                    tVConnector.updateLabelPos(double_, point2D4, rectangle2D, 0);
                    tVConnector.updateLabelPos(double_2, point2D3, rectangle2D2, 2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void update() {
        super.update();
        this.points = DiagramConstants.getPoints(this.allAttributes);
        Edge.Routing routing = DiagramConstants.getRouting(this.allAttributes);
        if (routing != null) {
            routing.route(this, this.points);
        }
        if (this.getModel().getSource(this.cell) != null) {
            this.setSource(this.getSource());
        }
        if (this.getModel().getTarget(this.cell) != null) {
            this.setTarget(this.getTarget());
        }
        this.beginShape = null;
        this.endShape = null;
        this.lineShape = null;
        this.sharedPath = null;
        this.cachedBounds = null;
        this.cachedLabelBounds = null;
    }

    void invalidate() {
        this.sharedPath = null;
        this.cachedBounds = null;
        this.cachedLabelBounds = null;
    }

    public Shape getShape() {
        if (this.sharedPath != null) {
            return this.sharedPath;
        }
        this.sharedPath = (GeneralPath)this.getEdgeRenderer().createShape();
        return this.sharedPath;
    }

    public PortView getPortView() {
        return this.portView;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean bl) {
        this.dragging = bl;
    }

    @Override
    public boolean intersects(Graphics graphics, Rectangle2D rectangle2D) {
        Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return this.getEdgeRenderer().intersects(this.diagram, this, rectangle);
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.cachedBounds != null) {
            return this.cachedBounds;
        }
        this.cachedBounds = this.getEdgeRenderer().getBounds(this);
        return this.cachedBounds;
    }

    public EdgeRenderer getEdgeRenderer() {
        return (EdgeRenderer)this.getRenderer();
    }

    @Override
    public CellViewRenderer getRenderer() {
        return renderer;
    }

    @Override
    public CellHandle getHandle(DiagramContext diagramContext) {
        return new EdgeHandle(this, diagramContext);
    }

    public CellView getSource() {
        return this.source;
    }

    public void setSource(CellView cellView) {
        this.source = cellView;
        if (this.source != null) {
            if (this.source instanceof PortView) {
                ((PortView)this.source).setPoint(this.getPoint(0));
            }
            this.points.set(0, this.source);
        } else {
            this.points.set(0, this.getPoint(0));
        }
        this.invalidate();
    }

    public CellView getTarget() {
        return this.target;
    }

    public void setTarget(CellView cellView) {
        this.target = cellView;
        int n = this.points.size() - 1;
        if (this.target != null) {
            if (this.target instanceof PortView) {
                ((PortView)this.target).setPoint(this.getPoint(n));
            }
            this.points.set(n, this.target);
        } else {
            this.points.set(n, this.getPoint(n));
        }
        this.invalidate();
    }

    public List getPoints() {
        return DiagramConstants.getPoints(this.allAttributes);
    }

    public int getPointCount() {
        return this.getPoints().size();
    }

    public Point2D getPoint(int n) {
        try {
            this.portView = null;
            Object e = this.points.get(n);
            if (e instanceof PortView) {
                this.portView = (PortView)e;
                return ((PortView)e).getLocation(this);
            }
            if (e instanceof CellView) {
                Rectangle2D rectangle2D = ((CellView)e).getBounds();
                return DiagramConstants.createPoint(rectangle2D.getX(), rectangle2D.getY());
            }
            if (e instanceof Point2D) {
                return (Point2D)e;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setPoint(int n, Point2D point2D) {
        this.points.set(n, point2D);
        this.updateAllAttributes();
        this.invalidate();
    }

    public void addPoint(int n, Point2D point2D) {
        this.points.add(n, point2D);
        HashMap hashMap = new HashMap();
        DiagramConstants.setPoints(hashMap, this.points);
        this.setAttributes(hashMap);
        this.invalidate();
    }

    public void removePoint(int n) {
        if (n > 0 && n < this.points.size() - 1) {
            this.points.remove(n);
            this.invalidate();
        }
    }

    public void updatePoints() {
        ConnectionSet connectionSet = this.createConnectionSet(this, this.getCell(), false);
        Map map = DiagramConstants.createAttributes(new CellView[]{this}, null);
        this.diagram.getDiagramLayoutCache().edit(map, connectionSet, null, null);
    }

    protected ConnectionSet createConnectionSet(EdgeView edgeView, Object object, boolean bl) {
        ConnectionSet connectionSet = new ConnectionSet();
        Object object2 = null;
        Object object3 = null;
        if (edgeView.getSource() != null) {
            object2 = edgeView.getSource().getCell();
        }
        if (edgeView.getTarget() != null) {
            object3 = edgeView.getTarget().getCell();
        }
        if (bl || object2 != edgeView.getDiagram().getModel().getSource(object)) {
            connectionSet.connect(object, object2, true);
        }
        if (bl || object3 != edgeView.getDiagram().getModel().getTarget(object)) {
            connectionSet.connect(object, object3, false);
        }
        return connectionSet;
    }

    public static double getLength(CellView cellView) {
        double d = 1.0;
        if (cellView instanceof EdgeView) {
            EdgeView edgeView = (EdgeView)cellView;
            Point2D point2D = null;
            Point2D point2D2 = null;
            for (int i = 0; i < edgeView.getPointCount(); ++i) {
                point2D2 = edgeView.getPoint(i);
                if (point2D != null) {
                    d += point2D.distance(point2D2);
                }
                point2D = point2D2;
            }
        }
        return d;
    }

    @Override
    public Point2D getCenterPoint() {
        return null;
    }

    @Override
    public Point2D getPerimeterPoint(Point2D point2D, Point2D point2D2, boolean bl) {
        return null;
    }

    public boolean isSelfReference() {
        return this.source != null && this.target != null && this.source.getParentView() == this.target.getParentView();
    }

    public double getSourceOffcet() {
        return this.sourceOffcet;
    }

    public void setSourceOffcet(double d) {
        this.sourceOffcet = d;
    }

    public double getTargetOffcet() {
        return this.targetOffcet;
    }

    public void setTargetOffcet(double d) {
        this.targetOffcet = d;
    }

    public boolean isWiderLine() {
        return this.widerLine;
    }

    public void setWiderLine(boolean bl) {
        this.widerLine = bl;
    }

    public static class EdgeHandle
    implements CellHandle,
    Serializable {
        protected AbstractDiagram diagram;
        protected EdgeView edge;
        protected EdgeView orig;
        protected boolean label = false;
        protected boolean sourceLabel = false;
        protected boolean targetLabel = false;
        protected boolean source = false;
        protected boolean target = false;
        protected Point2D currentPoint;
        protected PortView currectPort;
        protected transient Rectangle2D[] r;
        protected transient Rectangle2D loc;
        protected transient Rectangle2D sourceLoc;
        protected transient Rectangle2D targetLoc;
        protected boolean firstOverlayCall = true;
        protected boolean isEdgeConnectable = true;
        protected EdgeView relevantEdge = null;

        public EdgeHandle(EdgeView edgeView, DiagramContext diagramContext) {
            this.diagram = diagramContext.getDiagram();
            this.edge = edgeView;
            this.loc = new Rectangle();
            this.sourceLoc = new Rectangle();
            this.targetLoc = new Rectangle();
            this.orig = (EdgeView)this.diagram.getDiagramLayoutCache().getMapping(edgeView.getCell(), false);
            this.reloadPoints(this.orig);
            this.isEdgeConnectable = DiagramConstants.isConnectable(edgeView.getAllAttributes());
        }

        protected void reloadPoints(EdgeView edgeView) {
            this.relevantEdge = edgeView;
            this.r = new Rectangle[edgeView.getPointCount()];
            for (int i = 0; i < this.r.length; ++i) {
                this.r[i] = new Rectangle();
            }
            this.invalidate();
        }

        @Override
        public void paint(Graphics graphics) {
            this.invalidate();
            for (int i = 0; i < this.r.length; ++i) {
                if (this.isEdgeConnectable) {
                    graphics.setColor(this.diagram.getHandleColor());
                } else {
                    graphics.setColor(this.diagram.getLockedHandleColor());
                }
                graphics.fill3DRect((int)this.r[i].getX(), (int)this.r[i].getY(), (int)this.r[i].getWidth(), (int)this.r[i].getHeight(), true);
                CellView cellView = null;
                if (i == 0 && this.edge.getSource() != null) {
                    cellView = this.edge.getSource();
                } else if (i == this.r.length - 1 && this.edge.getTarget() != null) {
                    cellView = this.edge.getTarget();
                }
                if (cellView == null) continue;
                graphics.setColor(this.diagram.getLockedHandleColor());
                Point2D point2D = DiagramConstants.getOffset(cellView.getAllAttributes());
                if (point2D != null) {
                    graphics.drawLine((int)this.r[i].getX() + 1, (int)this.r[i].getY() + 1, (int)(this.r[i].getX() + this.r[i].getWidth()) - 3, (int)(this.r[i].getY() + this.r[i].getHeight()) - 3);
                    graphics.drawLine((int)this.r[i].getX() + 1, (int)(this.r[i].getY() + this.r[i].getHeight()) - 3, (int)(this.r[i].getX() + this.r[i].getWidth()) - 3, (int)this.r[i].getY() + 1);
                    continue;
                }
                graphics.drawRect((int)this.r[i].getX() + 2, (int)this.r[i].getY() + 2, (int)this.r[i].getWidth() - 5, (int)this.r[i].getHeight() - 5);
            }
        }

        @Override
        public void overlay(Graphics graphics) {
            if (this.edge != null && !this.firstOverlayCall) {
                graphics.setColor(this.diagram.getForeground());
                graphics.setXORMode(this.diagram.getBackground().darker());
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.scale(this.diagram.getScale(), this.diagram.getScale());
                this.diagram.getUI().paintCell(graphics, this.edge, this.edge.getBounds(), true);
                graphics2D.setTransform(affineTransform);
                if (this.isSourceEditing() && this.edge.getSource() != null) {
                    this.paintPort(graphics, this.edge.getSource());
                } else if (this.isTargetEditing() && this.edge.getTarget() != null) {
                    this.paintPort(graphics, this.edge.getTarget());
                }
            }
            this.firstOverlayCall = false;
        }

        protected void paintPort(Graphics graphics, CellView cellView) {
            boolean bl = DiagramConstants.getOffset(cellView.getAllAttributes()) != null;
            Rectangle2D rectangle2D = bl ? cellView.getBounds() : cellView.getParentView().getBounds();
            rectangle2D = this.diagram.toScreen(DiagramConstants.createRect(rectangle2D));
            int n = 3;
            rectangle2D.setFrame(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n, rectangle2D.getWidth() + (double)(2 * n), rectangle2D.getHeight() + (double)(2 * n));
            this.diagram.getUI().paintCell(graphics, cellView, rectangle2D, true);
        }

        protected boolean snap(boolean bl, Point2D point2D) {
            CellView cellView;
            boolean bl2 = this.diagram.isConnectable() && this.isEdgeConnectable;
            Object object = this.diagram.getPortForLocation(point2D.getX(), point2D.getY());
            if (object != null && bl2 && DiagramConstants.isConnectable((cellView = this.diagram.getDiagramLayoutCache().getMapping(object, false)).getParentView().getAllAttributes())) {
                Object object2 = this.edge.getCell();
                if (bl && this.edge.getSource() != cellView && this.edge.getDiagram().getModel().acceptsSource(object2, object)) {
                    this.overlay(this.diagram.getGraphics());
                    this.edge.setSource(cellView);
                    this.edge.update();
                    this.overlay(this.diagram.getGraphics());
                } else if (!bl && this.edge.getTarget() != cellView && this.edge.getDiagram().getModel().acceptsTarget(object2, object)) {
                    this.overlay(this.diagram.getGraphics());
                    this.edge.setTarget(cellView);
                    this.edge.update();
                    this.overlay(this.diagram.getGraphics());
                }
                return cellView != null;
            }
            return false;
        }

        public boolean isConstrainedMoveEvent(MouseEvent mouseEvent) {
            DiagramUI diagramUI = this.diagram.getUI();
            if (diagramUI instanceof DefaultDiagramUI) {
                return ((DefaultDiagramUI)diagramUI).isConstrainedMoveEvent(mouseEvent);
            }
            return false;
        }

        public boolean isAddPointEvent(MouseEvent mouseEvent) {
            return mouseEvent.isControlDown() && (SwingUtilities.isLeftMouseButton(mouseEvent) || SwingUtilities.isRightMouseButton(mouseEvent));
        }

        public boolean isRemovePointEvent(MouseEvent mouseEvent) {
            return mouseEvent.isControlDown() && (SwingUtilities.isLeftMouseButton(mouseEvent) || SwingUtilities.isRightMouseButton(mouseEvent));
        }

        protected boolean isSourceEditing() {
            return this.source;
        }

        protected boolean isTargetEditing() {
            return this.target;
        }

        protected boolean isEditing() {
            return this.source || this.target || this.label || this.sourceLabel || this.targetLabel || this.currentPoint != null;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            for (int i = 0; i < this.r.length; ++i) {
                if (!this.r[i].contains(mouseEvent.getPoint())) continue;
                this.diagram.setCursor(new Cursor(1));
                mouseEvent.consume();
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl = this.diagram.isBendable() && DiagramConstants.isBendable(this.edge.getAllAttributes());
            boolean bl2 = this.diagram.isDisconnectable() && DiagramConstants.isDisconnectable(this.orig.getAllAttributes());
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            for (n3 = 0; n3 < this.r.length; ++n3) {
                if (!this.r[n3].contains(n, n2)) continue;
                this.currentPoint = this.edge.getPoint(n3);
                this.currectPort = this.edge.getPortView();
                this.source = n3 == 0 && (this.edge.getSource() == null || bl2 && DiagramConstants.isDisconnectable(this.edge.getSource().getParentView().getAllAttributes()));
                this.target = n3 == this.r.length - 1 && (this.edge.getTarget() == null || bl2 && DiagramConstants.isDisconnectable(this.edge.getTarget().getParentView().getAllAttributes()));
                break;
            }
            if (!this.isEditing() && this.diagram.isMoveable() && DiagramConstants.isMoveable(this.edge.getAllAttributes()) && this.loc != null && this.loc.contains(n, n2) && !this.isAddPointEvent(mouseEvent) && !this.isRemovePointEvent(mouseEvent)) {
                if (mouseEvent.getClickCount() == this.diagram.getEditClickCount()) {
                    this.diagram.startEditingAtCell(this.edge);
                } else {
                    this.label = true;
                }
            } else if (!this.isEditing() && this.diagram.isMoveable() && DiagramConstants.isMoveable(this.edge.getAllAttributes()) && this.sourceLoc != null && this.sourceLoc.contains(n, n2) && !this.isAddPointEvent(mouseEvent) && !this.isRemovePointEvent(mouseEvent)) {
                if (mouseEvent.getClickCount() == this.diagram.getEditClickCount()) {
                    this.diagram.startEditingAtCell(this.edge);
                } else {
                    this.sourceLabel = true;
                }
            } else if (!this.isEditing() && this.diagram.isMoveable() && DiagramConstants.isMoveable(this.edge.getAllAttributes()) && this.targetLoc != null && this.targetLoc.contains(n, n2) && !this.isAddPointEvent(mouseEvent) && !this.isRemovePointEvent(mouseEvent)) {
                if (mouseEvent.getClickCount() == this.diagram.getEditClickCount()) {
                    this.diagram.startEditingAtCell(this.edge);
                } else {
                    this.targetLabel = true;
                }
            }
            if (this.isRemovePointEvent(mouseEvent) && this.currentPoint != null && !this.source && !this.target && bl) {
                this.edge.removePoint(n3);
                this.mouseReleased(mouseEvent);
            } else if (this.isAddPointEvent(mouseEvent) && !this.isEditing() && bl) {
                int n4 = this.diagram.getHandleSize();
                Rectangle2D rectangle2D = this.diagram.fromScreen(new Rectangle(n - n4, n2 - n4, 2 * n4, 2 * n4));
                if (this.edge.intersects(this.diagram.getGraphics(), rectangle2D)) {
                    Point2D point2D = this.diagram.fromScreen(this.diagram.snap(new Point(mouseEvent.getPoint())));
                    double d = Double.MAX_VALUE;
                    double d2 = 0.0;
                    for (int i = 0; i < this.edge.getPointCount() - 1; ++i) {
                        Point2D point2D2;
                        Point2D point2D3 = this.edge.getPoint(i);
                        d2 = new Line2D.Double(point2D3, point2D2 = this.edge.getPoint(i + 1)).ptLineDistSq(point2D);
                        if (!(d2 < d)) continue;
                        d = d2;
                        n3 = i + 1;
                    }
                    this.edge.addPoint(n3, point2D);
                    this.currentPoint = point2D;
                    this.reloadPoints(this.edge);
                    this.paint(this.diagram.getGraphics());
                }
            }
            if (this.isEditing()) {
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.edge.setDragging(true);
            Point2D point2D = this.diagram.fromScreen(new Point(mouseEvent.getPoint()));
            if (!(!this.isEditing() || this.source && this.snap(true, point2D) || this.target && this.snap(false, point2D) || !(this.source && this.edge.getDiagram().getModel().acceptsSource(this.edge.getCell(), null) || this.target && this.edge.getDiagram().getModel().acceptsTarget(this.edge.getCell(), null)) && (this.source || this.target))) {
                this.overlay(this.diagram.getGraphics());
                point2D = this.diagram.fromScreen(this.diagram.snap(new Point(mouseEvent.getPoint())));
                if (this.isConstrainedMoveEvent(mouseEvent)) {
                    EdgeView edgeView = (EdgeView)this.diagram.getDiagramLayoutCache().getMapping(this.edge.getCell(), false);
                    int n = 0;
                    if (this.target) {
                        n = edgeView.getPointCount() - 1;
                    }
                    Point2D point2D2 = edgeView.getPoint(n);
                    double d = point2D.getX() - point2D2.getX();
                    double d2 = point2D.getY() - point2D2.getY();
                    if (Math.abs(d) < Math.abs(d2)) {
                        point2D.setLocation(point2D2.getX(), point2D.getY());
                    } else {
                        point2D.setLocation(point2D.getX(), point2D2.getY());
                    }
                }
                if (!DiagramConstants.NEGATIVE_ALLOWED) {
                    point2D.setLocation(Math.max(0.0, point2D.getX()), Math.max(0.0, point2D.getY()));
                }
                this.currentPoint.setLocation(point2D);
                if (this.currectPort != null) {
                    this.currectPort.fixPoint();
                    this.currectPort.setPoint(this.currentPoint);
                }
                if (this.source) {
                    this.edge.setPoint(0, point2D);
                    this.edge.setSource(null);
                } else if (this.target) {
                    this.edge.setPoint(this.edge.getPointCount() - 1, point2D);
                    this.edge.setTarget(null);
                }
                this.edge.update();
                this.overlay(this.diagram.getGraphics());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.edge.setDragging(false);
            boolean bl = mouseEvent.isControlDown() && this.diagram.isCloneable();
            ConnectionSet connectionSet = this.createConnectionSet(this.edge, this.edge.getCell(), bl);
            Map map = DiagramConstants.createAttributes(new CellView[]{this.edge}, null);
            if (bl) {
                Map map2 = this.diagram.cloneCells(new Object[]{this.edge.getCell()});
                map = DiagramConstants.replaceKeys(map2, map);
                connectionSet = connectionSet.clone(map2);
                this.diagram.getDiagramLayoutCache().insert(map2.values().toArray(), map, connectionSet, null, null);
            } else {
                this.diagram.getDiagramLayoutCache().edit(map, connectionSet, null, null);
            }
            this.edge.updatePoints();
            this.edge.refreshLabels();
            mouseEvent.consume();
            if (this.relevantEdge != null) {
                this.relevantEdge.refresh(false);
            }
        }

        protected ConnectionSet createConnectionSet(EdgeView edgeView, Object object, boolean bl) {
            ConnectionSet connectionSet = new ConnectionSet();
            Object object2 = null;
            Object object3 = null;
            if (edgeView.getSource() != null) {
                object2 = edgeView.getSource().getCell();
            }
            if (edgeView.getTarget() != null) {
                object3 = edgeView.getTarget().getCell();
            }
            if (bl || object2 != edgeView.getDiagram().getModel().getSource(object)) {
                connectionSet.connect(object, object2, true);
            }
            if (bl || object3 != edgeView.getDiagram().getModel().getTarget(object)) {
                connectionSet.connect(object, object3, false);
            }
            return connectionSet;
        }

        protected void invalidate() {
            EdgeView edgeView = this.relevantEdge;
            int n = this.diagram.getHandleSize();
            for (int i = 0; i < this.r.length; ++i) {
                Point2D point2D = this.diagram.toScreen(DiagramConstants.createPoint(edgeView.getPoint(i)));
                this.r[i].setFrame(point2D.getX() - (double)n, point2D.getY() - (double)n, 2 * n, 2 * n);
            }
        }
    }
}

