/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.util.Bezier;
import oracle.dbtools.crest.swingui.diagram.util.Spline2D;
import oracle.dbtools.crest.swingui.logical.DPVLogical;

public class EdgeRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected transient Graphics fontGraphics = new BufferedImage(1, 1, 1).getGraphics();
    protected transient FontMetrics metrics;
    protected transient AbstractDiagram diagram;
    protected transient EdgeView view;
    protected transient int beginDeco;
    protected transient int endDeco;
    protected transient int beginSize;
    protected transient int endSize;
    protected transient int lineStyle;
    protected transient boolean labelBorder;
    protected transient boolean beginFill;
    protected transient boolean endFill;
    protected transient boolean focus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient boolean labelTransformEnabled;
    protected transient boolean transferable;
    protected transient Color borderColor;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color fontColor;
    protected transient float[] lineDash;
    protected Bezier bezier;
    protected Spline2D spline;
    protected boolean beginDashed;
    protected boolean endDashed;

    public void setView(CellView cellView) {
        if (cellView instanceof EdgeView) {
            this.view = (EdgeView)cellView;
            this.installAttributes(this.view);
        } else {
            this.view = null;
        }
    }

    protected int getLineWidth() {
        int n = ((DefaultDiagramCell)this.view.getCell()).getTopView().useDefaultColor() ? ((DefaultDiagramCell)this.view.getCell()).getTopView().getDefaultLineWidth() : ((DefaultDiagramCell)this.view.getCell()).getTopView().getLineWidth();
        if (this.view.isWiderLine()) {
            n += 2;
        }
        return n;
    }

    @Override
    public Color getForeground() {
        if (((DefaultDiagramCell)this.view.getCell()).getTopView().useDefaultColor()) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView().getDefaultLineColor();
        }
        return ((DefaultDiagramCell)this.view.getCell()).getTopView().getBackgroundColor();
    }

    @Override
    public Color getBGColor() {
        return this.getBackground();
    }

    @Override
    public Color getFGColor() {
        return this.getForeground();
    }

    @Override
    public Component getRendererComponent(AbstractDiagram abstractDiagram, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof EdgeView && abstractDiagram != null) {
            this.diagram = abstractDiagram;
            this.focus = bl2;
            this.selected = bl;
            this.preview = bl3;
            this.setView(cellView);
            return this;
        }
        return null;
    }

    private ApplicationView getAppView() {
        return ((Diagram)this.view.getDiagram()).getAppView();
    }

    public boolean intersects(AbstractDiagram abstractDiagram, CellView cellView, Rectangle rectangle) {
        if (cellView instanceof EdgeView && abstractDiagram != null && cellView != null) {
            this.setView(cellView);
            Graphics2D graphics2D = (Graphics2D)abstractDiagram.getGraphics();
            if (this.view.getShape() == null) {
                return false;
            }
            boolean bl = graphics2D.hit(rectangle, this.view.getShape(), true);
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public Rectangle2D getBounds(CellView cellView) {
        try {
            if (cellView instanceof EdgeView && cellView != null) {
                this.setView(cellView);
                Rectangle2D rectangle2D = this.getPaintBounds(this.view);
                int n = (int)Math.ceil(this.getLineWidth());
                rectangle2D.setFrame(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n, rectangle2D.getWidth() + (double)(2 * n), rectangle2D.getHeight() + (double)(2 * n));
                return rectangle2D;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void installAttributes(CellView cellView) {
        Map map = cellView.getAllAttributes();
        this.beginDeco = DiagramConstants.getLineBegin(map);
        this.beginSize = DiagramConstants.getBeginSize(map);
        this.beginFill = DiagramConstants.isBeginFill(map) && this.isFillable(this.beginDeco);
        this.beginDashed = DiagramConstants.isBeginDashed(map);
        this.endDashed = DiagramConstants.isEndDashed(map);
        this.endDeco = DiagramConstants.getLineEnd(map);
        this.endSize = DiagramConstants.getEndSize(map);
        this.endFill = DiagramConstants.isEndFill(map) && this.isFillable(this.endDeco);
        this.lineStyle = DiagramConstants.getLineStyle(map);
        this.lineDash = DiagramConstants.getDashPattern(map);
        this.borderColor = DiagramConstants.getBorderColor(map);
        Color color = DiagramConstants.getLineColor(map);
        this.setForeground(color != null ? color : this.defaultForeground);
        Color color2 = DiagramConstants.getBackground(map);
        this.setBackground(color2 != null ? color2 : this.defaultBackground);
        this.setOpaque(DiagramConstants.isOpaque(map));
        this.setFont(DiagramConstants.getFont(map));
        Color color3 = DiagramConstants.getForeground(map);
        this.fontColor = color3 != null ? color3 : this.getForeground();
        this.fontGraphics.setFont(this.getFont());
        this.metrics = this.fontGraphics.getFontMetrics();
        this.labelTransformEnabled = false;
        this.transferable = DiagramConstants.isTransferable(map);
    }

    protected boolean isFillable(int n) {
        return n != 4 && n != 7 && n != 8;
    }

    public Rectangle2D getPaintBounds(EdgeView edgeView) {
        this.setView(edgeView);
        if (edgeView.getShape() != null) {
            return edgeView.getShape().getBounds();
        }
        return null;
    }

    private void paintBeginDashed(Graphics2D graphics2D, boolean bl) {
        if (bl && this.view.lineShape != null) {
            GeneralPath generalPath = new GeneralPath();
            int n = this.view.getPointCount();
            if (n > 1) {
                Point2D[] point2DArray = new Point2D[n];
                for (int i = 0; i < n; ++i) {
                    point2DArray[i] = this.view.getPoint(i);
                }
                if (n == 2) {
                    generalPath.moveTo((float)point2DArray[0].getX(), (float)point2DArray[0].getY());
                    double d = point2DArray[1].getX() - point2DArray[0].getX();
                    double d2 = point2DArray[1].getY() - point2DArray[0].getY();
                    d = point2DArray[0].getX() + d / 2.0;
                    d2 = point2DArray[0].getY() + d2 / 2.0;
                    generalPath.lineTo((float)d, (float)d2);
                } else {
                    generalPath.moveTo((float)point2DArray[0].getX(), (float)point2DArray[0].getY());
                    generalPath.lineTo((float)point2DArray[1].getX(), (float)point2DArray[1].getY());
                }
            }
            graphics2D.setStroke(new BasicStroke(this.getLineWidth(), 0, 0, 10.0f, DiagramConstants.dash, 0.0f));
            graphics2D.setColor(this.diagram.getBackground());
            graphics2D.draw(generalPath);
        }
    }

    private void paintEndDashed(Graphics2D graphics2D, boolean bl) {
        if (bl && this.view.lineShape != null) {
            GeneralPath generalPath = new GeneralPath();
            int n = this.view.getPointCount();
            if (n > 1) {
                int n2;
                Point2D[] point2DArray = new Point2D[n];
                for (n2 = 0; n2 < n; ++n2) {
                    point2DArray[n2] = this.view.getPoint(n2);
                }
                if (n == 2) {
                    generalPath.moveTo((float)point2DArray[1].getX(), (float)point2DArray[1].getY());
                    double d = point2DArray[0].getX() - point2DArray[1].getX();
                    double d2 = point2DArray[0].getY() - point2DArray[1].getY();
                    d = point2DArray[1].getX() + d / 2.0;
                    d2 = point2DArray[1].getY() + d2 / 2.0;
                    generalPath.lineTo((float)d, (float)d2);
                } else {
                    n2 = point2DArray.length;
                    generalPath.moveTo((float)point2DArray[n2 - 1].getX(), (float)point2DArray[n2 - 1].getY());
                    generalPath.lineTo((float)point2DArray[n2 - 2].getX(), (float)point2DArray[n2 - 2].getY());
                }
            }
            graphics2D.setStroke(new BasicStroke(this.getLineWidth(), 0, 0, 10.0f, DiagramConstants.dash, 0.0f));
            graphics2D.setColor(this.diagram.getBackground());
            graphics2D.draw(generalPath);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        try {
            Shape shape = this.view.getShape();
            if (shape != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                int n = 0;
                int n2 = 0;
                graphics2D.setStroke(new BasicStroke(this.getLineWidth(), n, n2));
                this.translateGraphics(graphics);
                graphics.setColor(this.getForeground());
                graphics.setFont(this.diagram.getFont());
                if (this.lineDash != null) {
                    graphics2D.setStroke(new BasicStroke(this.getLineWidth(), n, n2, 10.0f, this.lineDash, 0.0f));
                }
                int n3 = this.getAppView().getSettings().getNotation();
                DesignPartView designPartView = this.getDesignPartView();
                if (designPartView != null) {
                    n3 = designPartView.getNotation();
                }
                if (designPartView != null && designPartView instanceof DPVLogical) {
                    if (n3 == 1) {
                        if (this.beginDashed && this.endDashed) {
                            graphics2D.setStroke(new BasicStroke(this.getLineWidth(), 0, 0, 10.0f, DiagramConstants.dash, 0.0f));
                            graphics2D.draw(this.view.lineShape);
                        } else {
                            if (this.view.lineShape != null) {
                                graphics2D.draw(this.view.lineShape);
                            }
                            this.paintBeginDashed(graphics2D, this.beginDashed);
                            this.paintEndDashed(graphics2D, this.endDashed);
                        }
                    } else if (this.view.lineShape != null) {
                        graphics2D.draw(this.view.lineShape);
                    }
                } else if (this.view.lineShape != null) {
                    graphics2D.draw(this.view.lineShape);
                }
                graphics2D.setStroke(new BasicStroke(this.getLineWidth(), n, n2));
                graphics.setColor(this.getForeground());
                graphics.setFont(this.diagram.getFont());
                if (this.view.beginShape != null) {
                    if (this.beginFill) {
                        graphics2D.fill(this.view.beginShape);
                    }
                    graphics2D.draw(this.view.beginShape);
                }
                if (this.view.endShape != null) {
                    if (this.endFill) {
                        graphics2D.fill(this.view.endShape);
                    }
                    graphics2D.draw(this.view.endShape);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void translateGraphics(Graphics graphics) {
        graphics.translate(-this.getX(), -this.getY());
    }

    protected Shape createShape() {
        try {
            int n = this.view.getPointCount();
            if (n > 1) {
                Object[] objectArray;
                EdgeView edgeView = this.view;
                Point2D[] point2DArray = new Point2D[n];
                for (int i = 0; i < n; ++i) {
                    point2DArray[i] = DiagramConstants.createPoint(edgeView.getPoint(i));
                }
                if (this.view != edgeView) {
                    this.view = edgeView;
                    this.installAttributes(this.view);
                }
                if (this.view.sharedPath == null) {
                    this.view.sharedPath = new GeneralPath(1);
                } else {
                    this.view.sharedPath.reset();
                }
                this.view.endShape = null;
                this.view.lineShape = null;
                this.view.beginShape = null;
                Point2D point2D = point2DArray[0];
                Point2D point2D2 = point2DArray[n - 1];
                Point2D point2D3 = point2DArray[1];
                Point2D point2D4 = point2DArray[n - 2];
                if (this.lineStyle == 12 && n > 2) {
                    this.bezier = new Bezier(point2DArray);
                    point2D4 = this.bezier.getPoint(this.bezier.getPointCount() - 1);
                } else if (this.lineStyle == 13 && n > 2) {
                    this.spline = new Spline2D(point2DArray);
                    objectArray = this.spline.getPoint(0.9875);
                    double d = point2D2.getX() - (point2D2.getX() - objectArray[0]) * 128.0;
                    double d2 = point2D2.getY() - (point2D2.getY() - objectArray[1]) * 128.0;
                    point2D4.setLocation(d, d2);
                }
                if (this.beginDeco != 0) {
                    this.view.beginShape = this.createLineEnd(this.beginSize, this.beginDeco, point2D3, point2D);
                }
                if (this.endDeco != 0) {
                    this.view.endShape = this.createLineEnd(this.endSize, this.endDeco, point2D4, point2D2);
                }
                this.view.sharedPath.moveTo((float)point2D.getX(), (float)point2D.getY());
                if (this.lineStyle == 12 && n > 2) {
                    objectArray = this.bezier.getPoints();
                    this.view.sharedPath.quadTo((float)objectArray[0].getX(), (float)objectArray[0].getY(), (float)point2D3.getX(), (float)point2D3.getY());
                    for (int i = 2; i < n - 1; ++i) {
                        double d = objectArray[2 * i - 3];
                        double d3 = objectArray[2 * i - 2];
                        this.view.sharedPath.curveTo((float)d.getX(), (float)d.getY(), (float)d3.getX(), (float)d3.getY(), (float)point2DArray[i].getX(), (float)point2DArray[i].getY());
                    }
                    this.view.sharedPath.quadTo((float)objectArray[objectArray.length - 1].getX(), (float)objectArray[objectArray.length - 1].getY(), (float)point2DArray[n - 1].getX(), (float)point2DArray[n - 1].getY());
                } else if (this.lineStyle == 13 && n > 2) {
                    for (double d = 0.0; d <= 1.0; d += 0.0125) {
                        double[] dArray = this.spline.getPoint(d);
                        this.view.sharedPath.lineTo((float)dArray[0], (float)dArray[1]);
                    }
                } else {
                    for (int i = 1; i < n - 1; ++i) {
                        this.view.sharedPath.lineTo((float)point2DArray[i].getX(), (float)point2DArray[i].getY());
                    }
                    this.view.sharedPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
                }
                this.view.sharedPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
                this.view.lineShape = (GeneralPath)this.view.sharedPath.clone();
                if (this.view.endShape != null) {
                    this.view.sharedPath.append(this.view.endShape, true);
                }
                if (this.view.beginShape != null) {
                    this.view.sharedPath.append(this.view.beginShape, true);
                }
                return this.view.sharedPath;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Shape createLineEnd(int n, int n2, Point2D point2D, Point2D point2D2) {
        try {
            if (point2D.getX() == point2D2.getX() - 1.0 || point2D.getX() == point2D2.getX() + 1.0) {
                point2D2.setLocation(point2D.getX(), point2D2.getY());
            }
            if (point2D.getY() == point2D2.getY() - 1.0 || point2D.getY() == point2D2.getY() + 1.0) {
                point2D2.setLocation(point2D2.getX(), point2D.getY());
            }
            int n3 = (int)Math.max(1.0, point2D2.distance(point2D));
            int n4 = (int)(-((double)n * (point2D2.getX() - point2D.getX()) / (double)n3));
            int n5 = (int)(-((double)n * (point2D2.getY() - point2D.getY()) / (double)n3));
            if (n2 == 9) {
                Polygon polygon = new Polygon();
                polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
                polygon.addPoint((int)(point2D2.getX() + (double)(n4 / 2) + (double)(n5 / 3)), (int)(point2D2.getY() + (double)(n5 / 2) - (double)(n4 / 3)));
                Point2D point2D3 = (Point2D)point2D2.clone();
                point2D2.setLocation(point2D2.getX() + (double)n4, point2D2.getY() + (double)n5);
                polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
                polygon.addPoint((int)(point2D3.getX() + (double)(n4 / 2) - (double)(n5 / 3)), (int)(point2D3.getY() + (double)(n5 / 2) + (double)(n4 / 3)));
                return polygon;
            }
            if (n2 == 14) {
                GeneralPath generalPath = new GeneralPath(1, 4);
                generalPath.moveTo((float)(point2D2.getX() + (double)n4 * 1.5 + (double)(n5 / 2)), (float)(point2D2.getY() + (double)n5 * 1.5 - (double)(n4 / 2)));
                generalPath.lineTo((float)(point2D2.getX() + (double)n4 * 1.5 - (double)(n5 / 2)), (float)(point2D2.getY() + (double)n5 * 1.5 + (double)(n4 / 2)));
                Polygon polygon = new Polygon();
                polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
                polygon.addPoint((int)(point2D2.getX() + (double)n4 + (double)(n5 / 2)), (int)(point2D2.getY() + (double)n5 - (double)(n4 / 2)));
                Point2D point2D4 = (Point2D)point2D2.clone();
                point2D2.setLocation((int)(point2D2.getX() + (double)n4), (int)(point2D2.getY() + (double)n5));
                polygon.addPoint((int)(point2D4.getX() + (double)n4 - (double)(n5 / 2)), (int)(point2D4.getY() + (double)n5 + (double)(n4 / 2)));
                generalPath.append(polygon, false);
                return generalPath;
            }
            if (n2 == 2 || n2 == 1) {
                Polygon polygon = new Polygon();
                polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
                polygon.addPoint((int)(point2D2.getX() + (double)n4 + (double)(n5 / 2)), (int)(point2D2.getY() + (double)n5 - (double)(n4 / 2)));
                Point2D point2D5 = (Point2D)point2D2.clone();
                if (n2 == 1) {
                    point2D2.setLocation((int)(point2D2.getX() + (double)(n4 * 2 / 3)), (int)(point2D2.getY() + (double)(n5 * 2 / 3)));
                    polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
                } else if (n2 == 9) {
                    point2D2.setLocation(point2D2.getX() + (double)(2 * n4), point2D2.getY() + (double)(2 * n5));
                    polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
                } else {
                    point2D2.setLocation((int)(point2D2.getX() + (double)n4), (int)(point2D2.getY() + (double)n5));
                }
                polygon.addPoint((int)(point2D5.getX() + (double)n4 - (double)(n5 / 2)), (int)(point2D5.getY() + (double)n5 + (double)(n4 / 2)));
                return polygon;
            }
            if (n2 == 4) {
                GeneralPath generalPath = new GeneralPath(1, 4);
                generalPath.moveTo((float)(point2D2.getX() + (double)n4 + (double)(n5 / 2)), (float)(point2D2.getY() + (double)n5 - (double)(n4 / 2)));
                generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
                generalPath.lineTo((float)(point2D2.getX() + (double)n4 - (double)(n5 / 2)), (float)(point2D2.getY() + (double)n5 + (double)(n4 / 2)));
                return generalPath;
            }
            if (n2 == 5) {
                Ellipse2D.Float float_ = new Ellipse2D.Float((float)(point2D2.getX() + (double)(n4 / 2) - (double)(n / 2)), (float)(point2D2.getY() + (double)(n5 / 2) - (double)(n / 2)), n, n);
                point2D2.setLocation(point2D2.getX() + (double)n4, point2D2.getY() + (double)n5);
                return float_;
            }
            if (n2 == 15) {
                GeneralPath generalPath = new GeneralPath(1, 4);
                generalPath.moveTo((float)(point2D2.getX() + (double)n4 * 1.5 + (double)(n5 / 2)), (float)(point2D2.getY() + (double)n5 * 1.5 - (double)(n4 / 2)));
                generalPath.lineTo((float)(point2D2.getX() + (double)n4 * 1.5 - (double)(n5 / 2)), (float)(point2D2.getY() + (double)n5 * 1.5 + (double)(n4 / 2)));
                Ellipse2D.Float float_ = new Ellipse2D.Float((float)(point2D2.getX() + (double)(n4 / 2) - (double)(n / 2)), (float)(point2D2.getY() + (double)(n5 / 2) - (double)(n / 2)), n, n);
                point2D2.setLocation(point2D2.getX() + (double)n4, point2D2.getY() + (double)n5);
                generalPath.append(float_, false);
                return generalPath;
            }
            if (n2 == 7 || n2 == 8) {
                GeneralPath generalPath = new GeneralPath(1, 4);
                generalPath.moveTo((float)(point2D2.getX() + (double)n4 + (double)n5), (float)(point2D2.getY() + (double)n5 - (double)n4));
                generalPath.lineTo((float)(point2D2.getX() + (double)n4 - (double)n5), (float)(point2D2.getY() + (double)n5 + (double)n4));
                if (n2 == 8) {
                    float f = 1.9f;
                    generalPath.moveTo((float)(point2D2.getX() + (double)((float)n4 * f) + (double)n5), (float)(point2D2.getY() + (double)((float)n5 * f) - (double)n4));
                    generalPath.lineTo((float)(point2D2.getX() + (double)((float)n4 * f) - (double)n5), (float)(point2D2.getY() + (double)((float)n5 * f) + (double)n4));
                    if (!this.transferable) {
                        generalPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
                        generalPath.lineTo((float)(point2D2.getX() + (double)n4 * 2.8), (float)(point2D2.getY() + (double)n5 * 2.8));
                        point2D2.setLocation(point2D2.getX() + (double)n4 * 2.8, point2D2.getY() + (double)n5 * 2.8);
                        Polygon polygon = new Polygon();
                        polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
                        polygon.addPoint((int)(point2D2.getX() + (double)n4 + (double)n5 / 1.5), (int)(point2D2.getY() + (double)n5 - (double)n4 / 1.5));
                        Point2D point2D6 = (Point2D)point2D2.clone();
                        point2D2.setLocation(point2D2.getX() + (double)(n4 * 2), point2D2.getY() + (double)(n5 * 2));
                        polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
                        polygon.addPoint((int)(point2D6.getX() + (double)n4 - (double)n5 / 1.5), (int)(point2D6.getY() + (double)n5 + (double)n4 / 1.5));
                        generalPath.append(polygon, false);
                    }
                }
                return generalPath;
            }
            if (n2 == 16 || n2 == 17) {
                GeneralPath generalPath = new GeneralPath(1, 4);
                generalPath.moveTo((float)point2D2.getX() + (float)n5, (float)(point2D2.getY() - (double)n4));
                generalPath.lineTo((float)(point2D2.getX() + (double)(n4 * 2)), (float)point2D2.getY() + (float)(n5 * 2));
                generalPath.lineTo((float)point2D2.getX() - (float)n5, (float)(point2D2.getY() + (double)n4));
                if (n2 == 17) {
                    float f = 2.1f;
                    generalPath.moveTo((float)(point2D2.getX() + (double)((float)n4 * f) + (double)n5), (float)(point2D2.getY() + (double)((float)n5 * f) - (double)n4));
                    generalPath.lineTo((float)(point2D2.getX() + (double)((float)n4 * f) - (double)n5), (float)(point2D2.getY() + (double)((float)n5 * f) + (double)n4));
                    if (!this.transferable) {
                        f = 3.0f;
                        generalPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
                        generalPath.lineTo((float)(point2D2.getX() + (double)((float)n4 * f)), (float)(point2D2.getY() + (double)((float)n5 * f)));
                        point2D2.setLocation(point2D2.getX() + (double)((float)n4 * f), point2D2.getY() + (double)((float)n5 * f));
                        Polygon polygon = new Polygon();
                        polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
                        polygon.addPoint((int)(point2D2.getX() + (double)n4 + (double)n5 / 1.5), (int)(point2D2.getY() + (double)n5 - (double)n4 / 1.5));
                        Point2D point2D7 = (Point2D)point2D2.clone();
                        point2D2.setLocation(point2D2.getX() + (double)(n4 * 2), point2D2.getY() + (double)(n5 * 2));
                        polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
                        polygon.addPoint((int)(point2D7.getX() + (double)n4 - (double)n5 / 1.5), (int)(point2D7.getY() + (double)n5 + (double)n4 / 1.5));
                        generalPath.append(polygon, false);
                    }
                }
                return generalPath;
            }
            if (n2 == 18) {
                GeneralPath generalPath = new GeneralPath(1, 4);
                float f = 1.0f;
                generalPath.moveTo((float)(point2D2.getX() + (double)((float)n4 / f) + (double)n5), (float)(point2D2.getY() + (double)((float)n5 / f) - (double)n4));
                generalPath.lineTo((float)(point2D2.getX() + (double)((float)n4 / f) - (double)n5), (float)(point2D2.getY() + (double)((float)n5 / f) + (double)n4));
                int n6 = (int)((double)n * 1.8);
                Ellipse2D.Float float_ = new Ellipse2D.Float((float)(point2D2.getX() + (double)n4 * 2.7 - (double)(n6 / 2)), (float)(point2D2.getY() + (double)n5 * 2.7 - (double)(n6 / 2)), n6, n6);
                generalPath.append(float_, false);
                return generalPath;
            }
            if (n2 == 19) {
                GeneralPath generalPath = new GeneralPath(1, 4);
                generalPath.moveTo((float)point2D2.getX() + (float)n5, (float)(point2D2.getY() - (double)n4));
                generalPath.lineTo((double)((float)(point2D2.getX() + (double)n4 * 1.6)), (double)((float)point2D2.getY()) + (double)n5 * 1.6);
                generalPath.lineTo((float)point2D2.getX() - (float)n5, (float)(point2D2.getY() + (double)n4));
                int n7 = (int)((double)n * 1.8);
                Ellipse2D.Float float_ = new Ellipse2D.Float((float)(point2D2.getX() + (double)n4 * 2.8 - (double)(n7 / 2)), (float)(point2D2.getY() + (double)n5 * 2.8 - (double)(n7 / 2)), n7, n7);
                generalPath.append(float_, false);
                return generalPath;
            }
            if (n2 == 20) {
                GeneralPath generalPath = new GeneralPath(1, 4);
                generalPath.moveTo((float)point2D2.getX() + (float)n5, (float)(point2D2.getY() - (double)n4));
                generalPath.lineTo((float)(point2D2.getX() + (double)(n4 * 2)), (float)point2D2.getY() + (float)(n5 * 2));
                generalPath.lineTo((float)point2D2.getX() - (float)n5, (float)(point2D2.getY() + (double)n4));
                generalPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
                generalPath.lineTo((double)((float)(point2D2.getX() + (double)n4 * 2.4)), (double)((float)point2D2.getY()) + (double)n5 * 2.4);
                int n8 = (int)((double)n * 1.8);
                Ellipse2D.Float float_ = new Ellipse2D.Float((float)(point2D2.getX() + (double)n4 * 3.2 - (double)(n8 / 2)), (float)(point2D2.getY() + (double)n5 * 3.2 - (double)(n8 / 2)), n8, n8);
                generalPath.append(float_, false);
                point2D2.setLocation(point2D2.getX() + (double)n4 * 4.1, point2D2.getY() + (double)n5 * 4.1);
                return generalPath;
            }
            if (n2 == 21) {
                GeneralPath generalPath = new GeneralPath(1, 4);
                generalPath.moveTo((float)point2D2.getX() + (float)n5, (float)(point2D2.getY() - (double)n4));
                generalPath.lineTo((float)(point2D2.getX() + (double)(n4 * 2)), (float)point2D2.getY() + (float)(n5 * 2));
                generalPath.lineTo((float)point2D2.getX() - (float)n5, (float)(point2D2.getY() + (double)n4));
                generalPath.moveTo((float)(point2D2.getX() + (double)n4 * 2.5 + (double)n5 / 1.5), (float)(point2D2.getY() + (double)n5 * 2.5 - (double)n4 / 1.5));
                generalPath.lineTo((float)(point2D2.getX() + (double)n4 * 3.5 - (double)n5 / 1.5), (float)(point2D2.getY() + (double)n5 * 3.5 + (double)n4 / 1.5));
                generalPath.moveTo((float)(point2D2.getX() + (double)n4 * 3.5 + (double)n5 / 1.5), (float)(point2D2.getY() + (double)n5 * 3.5 - (double)n4 / 1.5));
                generalPath.lineTo((float)(point2D2.getX() + (double)n4 * 2.5 - (double)n5 / 1.5), (float)(point2D2.getY() + (double)n5 * 2.5 + (double)n4 / 1.5));
                if (!this.transferable) {
                    float f = 4.0f;
                    generalPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
                    generalPath.lineTo((float)(point2D2.getX() + (double)((float)n4 * f)), (float)(point2D2.getY() + (double)((float)n5 * f)));
                    point2D2.setLocation(point2D2.getX() + (double)((float)n4 * f), point2D2.getY() + (double)((float)n5 * f));
                    Polygon polygon = new Polygon();
                    polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
                    polygon.addPoint((int)(point2D2.getX() + (double)n4 + (double)n5 / 1.5), (int)(point2D2.getY() + (double)n5 - (double)n4 / 1.5));
                    Point2D point2D8 = (Point2D)point2D2.clone();
                    point2D2.setLocation(point2D2.getX() + (double)(n4 * 2), point2D2.getY() + (double)(n5 * 2));
                    polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
                    polygon.addPoint((int)(point2D8.getX() + (double)n4 - (double)n5 / 1.5), (int)(point2D8.getY() + (double)n5 + (double)n4 / 1.5));
                    generalPath.append(polygon, false);
                }
                return generalPath;
            }
            if (n2 == 22) {
                GeneralPath generalPath = new GeneralPath(1, 4);
                generalPath.moveTo((float)(point2D2.getX() + (double)n4 + (double)n5), (float)(point2D2.getY() + (double)n5 - (double)n4));
                generalPath.lineTo((float)(point2D2.getX() + (double)n4 - (double)n5), (float)(point2D2.getY() + (double)n5 + (double)n4));
                float f = 1.4f;
                float f2 = 2.4f;
                generalPath.moveTo((float)(point2D2.getX() + (double)((float)n4 * f) + (double)((float)n5 / f)), (float)(point2D2.getY() + (double)((float)n5 * f) - (double)((float)n4 / f)));
                generalPath.lineTo((float)(point2D2.getX() + (double)((float)n4 * f2) - (double)((float)n5 / f)), (float)(point2D2.getY() + (double)((float)n5 * f2) + (double)((float)n4 / f)));
                generalPath.moveTo((float)(point2D2.getX() + (double)((float)n4 * f2) + (double)((float)n5 / f)), (float)(point2D2.getY() + (double)((float)n5 * f2) - (double)((float)n4 / f)));
                generalPath.lineTo((float)(point2D2.getX() + (double)((float)n4 * f) - (double)((float)n5 / f)), (float)(point2D2.getY() + (double)((float)n5 * f) + (double)((float)n4 / f)));
                if (!this.transferable) {
                    generalPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
                    generalPath.lineTo((float)(point2D2.getX() + (double)n4 * 2.8), (float)(point2D2.getY() + (double)n5 * 2.8));
                    point2D2.setLocation(point2D2.getX() + (double)n4 * 2.8, point2D2.getY() + (double)n5 * 2.8);
                    Polygon polygon = new Polygon();
                    polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
                    polygon.addPoint((int)(point2D2.getX() + (double)n4 + (double)n5 / 1.5), (int)(point2D2.getY() + (double)n5 - (double)n4 / 1.5));
                    Point2D point2D9 = (Point2D)point2D2.clone();
                    point2D2.setLocation(point2D2.getX() + (double)(n4 * 2), point2D2.getY() + (double)(n5 * 2));
                    polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
                    polygon.addPoint((int)(point2D9.getX() + (double)n4 - (double)n5 / 1.5), (int)(point2D9.getY() + (double)n5 + (double)n4 / 1.5));
                    generalPath.append(polygon, false);
                }
                return generalPath;
            }
            if (n2 == 23) {
                GeneralPath generalPath = new GeneralPath(1, 4);
                generalPath.moveTo((float)(point2D2.getX() + (double)n4 + (double)n5), (float)(point2D2.getY() + (double)n5 - (double)n4));
                generalPath.lineTo((float)(point2D2.getX() + (double)n4 - (double)n5), (float)(point2D2.getY() + (double)n5 + (double)n4));
                generalPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
                generalPath.lineTo((double)((float)(point2D2.getX() + (double)n4 * 1.6)), (double)((float)point2D2.getY()) + (double)n5 * 1.6);
                int n9 = (int)((double)n * 1.8);
                Ellipse2D.Float float_ = new Ellipse2D.Float((float)(point2D2.getX() + (double)n4 * 2.7 - (double)(n9 / 2)), (float)(point2D2.getY() + (double)n5 * 2.7 - (double)(n9 / 2)), n9, n9);
                generalPath.append(float_, false);
                point2D2.setLocation(point2D2.getX() + (double)n4 * 3.3, point2D2.getY() + (double)n5 * 3.3);
                return generalPath;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
        this.createShape();
        this.update(this.getGraphics());
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if ("text".equals(string)) {
            super.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    private DesignPartView getDesignPartView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView().getDesignPartView();
        }
        return null;
    }
}

