/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewRenderer;

public class DiagramViewDiagramCell
extends DefaultDiagramCell {
    private JPopupMenu menu;
    private DiagramView diagramView;
    private JCheckBoxMenuItem miComposite;
    private JMenu miDisplays;
    private DiagramViewRenderer renderer;
    private JMenuItem miViewDiagram;

    public DiagramViewDiagramCell(DiagramView diagramView) {
        this(diagramView, DiagramConstants.createMap());
    }

    public DiagramViewDiagramCell(DiagramView diagramView, Map map) {
        this.diagramView = diagramView;
        this.setAttributes(map);
        DiagramConstants.setValue(this.getAttributes(), diagramView.getName());
    }

    private void showProperty() {
        this.getDiagramView().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.viewDiagram();
    }

    private void viewDiagram() {
        DesignPartView designPartView = ((Diagram)this.getCellView().getDiagram()).getAppView().getCurrentDPV();
        if (this.diagramView.getDesignPartView() != null && this.diagramView.getDesignPartView().getDesignPart().isLoaded()) {
            DesignPartView designPartView2;
            DesignPartView.NamedTabbedPane namedTabbedPane;
            DesignPartView designPartView3;
            if (designPartView != null) {
                this.diagramView.getDesignPartView().setLastContainerDiagram(designPartView);
            }
            if ((designPartView3 = this.diagramView.getDesignPartView()).isMasterDPV()) {
                namedTabbedPane = designPartView3.getTabbedPane();
                designPartView2 = designPartView3;
            } else {
                namedTabbedPane = designPartView3.getMasterDPV().getTabbedPane();
                designPartView2 = designPartView3.getMasterDPV();
            }
            if (designPartView3.activateEditor()) {
                namedTabbedPane.setSelectedComponent(designPartView3);
            } else if (designPartView2 == designPartView3.getDesignPart().getMainView()) {
                designPartView3.getDesignPart().setMainViewVisible(true);
            } else {
                designPartView2.getPlaceHolder().setVisible(true);
            }
            if (namedTabbedPane.indexOfComponent(designPartView3) > -1 && namedTabbedPane.indexOfComponent(designPartView2) > -1) {
                namedTabbedPane.setSelectedComponent(designPartView2);
                namedTabbedPane.setSelectedComponent(designPartView3);
            }
        }
    }

    @Override
    public void showPopupMenu(Point point) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.diagramView.getDesignPartView() != null) {
            this.miViewDiagram = this.menu.add(new AbstractAction(Messages.getString("DiagramViewDiagramCell.ViewDiagram")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DiagramViewDiagramCell.this.viewDiagram();
                }
            });
            this.menu.addSeparator();
        }
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(DELETE){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DiagramViewDiagramCell.this.deleteDiagramView();
                }
            });
        }
        if (this.diagramView.getDesignPartView() != null) {
            this.menu.addSeparator();
            this.miComposite = new JCheckBoxMenuItem(new AbstractAction(Messages.getString("DiagramViewDiagramCell.CompositeView")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DiagramViewDiagramCell.this.diagramView.setCompositeView(!DiagramViewDiagramCell.this.diagramView.isCompositeView());
                    DiagramViewDiagramCell.this.getDiagram().repaint(DiagramViewDiagramCell.this.getCellView().getBounds().getBounds());
                }
            });
            this.menu.add(this.miComposite);
            this.menu.addSeparator();
            this.miDisplays = new JMenu(Messages.getString("DiagramViewDiagramCell.Displays"));
            this.menu.add(this.miDisplays);
            this.menu.addSeparator();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DiagramViewDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DiagramViewDiagramCell.this.showProperty();
                }
            });
            this.miComposite.setSelected(this.diagramView.isCompositeView());
            this.miComposite.setEnabled(this.diagramView.getDesignPartView().getDesignPart().isLoaded());
            this.miViewDiagram.setEnabled(this.diagramView.getDesignPartView().getDesignPart().isLoaded());
            this.updateDisplaysMenu();
        }
        return this.menu;
    }

    private void updateDisplaysMenu() {
        this.miDisplays.removeAll();
        final DesignPartView designPartView = this.diagramView.getDesignPartView().isMasterDPV() ? this.diagramView.getDesignPartView() : this.diagramView.getDesignPartView().getMasterDPV();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new AbstractAction(Messages.getString("DiagramViewDiagramCell.MainDiagram")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagramViewDiagramCell.this.diagramView.setDesignPartView(designPartView);
                for (TopView topView : DiagramViewDiagramCell.this.diagramView.getAllViewsWithCellViews()) {
                    DiagramViewDiagramCell diagramViewDiagramCell = (DiagramViewDiagramCell)topView.getCellView().getCell();
                    if (diagramViewDiagramCell == null) continue;
                    diagramViewDiagramCell.getRenderer().resetOverviewPanel();
                    diagramViewDiagramCell.getDiagram().repaint(topView.getCellView().getBounds().getBounds());
                }
                DiagramViewDiagramCell.this.getDiagram().repaint(DiagramViewDiagramCell.this.getCellView().getBounds().getBounds());
            }
        });
        this.miDisplays.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.setSelected(this.diagramView.getDesignPartView().isMasterDPV());
        if (designPartView.getSubordinateViews().size() > 0) {
            this.miDisplays.addSeparator();
            for (final DesignPartView designPartView2 : designPartView.getSubordinateViews()) {
                JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(new AbstractAction(designPartView2.getName()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DiagramViewDiagramCell.this.diagramView.setDesignPartView(designPartView2);
                        designPartView2.setVisible(true);
                        for (TopView topView : DiagramViewDiagramCell.this.diagramView.getAllViewsWithCellViews()) {
                            DiagramViewDiagramCell diagramViewDiagramCell = (DiagramViewDiagramCell)topView.getCellView().getCell();
                            if (diagramViewDiagramCell == null) continue;
                            diagramViewDiagramCell.getRenderer().resetOverviewPanel();
                            diagramViewDiagramCell.getDiagram().repaint(topView.getCellView().getBounds().getBounds());
                        }
                    }
                });
                this.miDisplays.add(jCheckBoxMenuItem2);
                jCheckBoxMenuItem2.setSelected(this.diagramView.getDesignPartView() == designPartView2);
            }
        }
    }

    public DiagramView getDiagramView() {
        return this.diagramView;
    }

    public void deleteDiagramView() {
        DiagramView diagramView = this.getDiagramView();
        ApplicationView.log(MessageFormat.format(Messages.getString("DiagramViewDiagramCell.DeleteDiagramView"), diagramView.getName()));
        diagramView.remove();
    }

    @Override
    public void deleteSelected() {
        this.deleteDiagramView();
    }

    public DiagramViewRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(DiagramViewRenderer diagramViewRenderer) {
        this.renderer = diagramViewRenderer;
    }
}

