/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.Stack;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelEvent;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewFactory;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.ParentMap;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;

public class DiagramLayoutCache
extends Observable
implements CellMapper,
Serializable {
    public boolean showAllEdgesForVisibleVertices = true;
    public boolean showEdgesOnShow = true;
    public boolean hideEdgesOnHide = true;
    public boolean hideEdgesOnBecomeInvisible = true;
    public boolean rememberCellViews = true;
    protected DiagramModel diagramModel;
    protected Map mapping = new Hashtable();
    protected CellMapper mapper;
    protected CellViewFactory factory = null;
    protected AbstractDiagram diagram = null;
    protected Set visibleSet = new HashSet();
    protected List roots = new ArrayList();
    protected PortView[] ports;
    protected transient Map hiddenSet = new Hashtable();
    protected boolean ordered = false;
    protected boolean partial = false;
    protected boolean askLocalAttribute = true;
    protected Set localAttributes = new HashSet();

    public DiagramLayoutCache(AbstractDiagram abstractDiagram) {
        this(abstractDiagram, abstractDiagram.getModel(), abstractDiagram, false, false);
    }

    public DiagramLayoutCache(AbstractDiagram abstractDiagram, Set set) {
        this(abstractDiagram, abstractDiagram.getModel(), abstractDiagram, false, false);
        this.setLocalAttributes(set);
    }

    public DiagramLayoutCache(AbstractDiagram abstractDiagram, DiagramModel diagramModel, CellViewFactory cellViewFactory, boolean bl, boolean bl2) {
        this(abstractDiagram, diagramModel, cellViewFactory, bl, bl2, true, true, true, true, true);
    }

    public DiagramLayoutCache(AbstractDiagram abstractDiagram, DiagramModel diagramModel, CellViewFactory cellViewFactory, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        this.diagram = abstractDiagram;
        this.factory = cellViewFactory;
        this.ordered = bl;
        this.partial = bl2;
        this.rememberCellViews = bl3;
        this.showAllEdgesForVisibleVertices = bl4;
        this.showEdgesOnShow = bl5;
        this.hideEdgesOnHide = bl6;
        this.hideEdgesOnBecomeInvisible = bl7;
        this.setModel(diagramModel);
    }

    public AbstractDiagram getDiagram() {
        return this.diagram;
    }

    public void setFactory(CellViewFactory cellViewFactory) {
        this.factory = cellViewFactory;
    }

    public CellViewFactory getFactory() {
        return this.factory;
    }

    public void setModel(DiagramModel diagramModel) {
        this.roots.clear();
        this.mapping.clear();
        this.hiddenSet.clear();
        this.visibleSet.clear();
        this.diagramModel = diagramModel;
        Object[] objectArray = DefaultDiagramModel.getRoots(diagramModel);
        if (!this.isPartial()) {
            this.insertRoots(this.getMapping(objectArray, true));
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.factory.updateAutoSize(this.getDiagram(), this.getMapping(objectArray[i], false));
            }
        }
        this.updatePorts();
    }

    public synchronized void reload() {
        Hashtable hashtable = new Hashtable(this.mapping);
        for (Object k : hashtable.keySet()) {
            CellView cellView = (CellView)hashtable.get(k);
            if (!(cellView instanceof EdgeView)) continue;
            this.mapping.remove(cellView);
            CellView cellView2 = this.getMapping(k, true);
            cellView2.setAttributes(cellView.getAttributes());
            if (this.roots.contains(cellView)) {
                this.roots.remove(cellView);
                this.roots.add(cellView2);
            }
            this.hiddenSet.remove(cellView);
        }
    }

    public DiagramModel getModel() {
        return this.diagramModel;
    }

    public CellView[] getRoots() {
        CellView[] cellViewArray = new CellView[this.roots.size()];
        try {
            this.roots.toArray(cellViewArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cellViewArray;
    }

    public CellView[] getRoots(Rectangle2D rectangle2D) {
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        CellView[] cellViewArray = this.getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            Rectangle2D rectangle2D2 = cellViewArray[i].getBounds();
            if (rectangle2D2 == null || !rectangle2D2.intersects(rectangle2D)) continue;
            arrayList.add(cellViewArray[i]);
        }
        cellViewArray = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray);
        return cellViewArray;
    }

    public PortView[] getPorts() {
        return this.ports;
    }

    protected void updatePorts() {
        Object[] objectArray = DefaultDiagramModel.getRoots(this.diagramModel);
        Set set = DefaultDiagramModel.getDescendants(this.diagramModel, objectArray);
        if (set != null) {
            Object[] objectArray2 = set.toArray();
            ArrayList<CellView> arrayList = new ArrayList<CellView>();
            for (int i = 0; i < objectArray2.length; ++i) {
                CellView cellView;
                if (!this.diagramModel.isPort(objectArray2[i]) || (cellView = this.getMapping(objectArray2[i], false)) == null) continue;
                arrayList.add(cellView);
                cellView.refresh(false);
            }
            this.ports = new PortView[arrayList.size()];
            arrayList.toArray(this.ports);
        }
    }

    public void refresh(CellView[] cellViewArray, boolean bl) {
        if (cellViewArray != null) {
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.refresh(cellViewArray[i], bl);
            }
        }
    }

    public void refresh(CellView cellView, boolean bl) {
        if (cellView != null) {
            cellView.refresh(bl);
            CellView[] cellViewArray = cellView.getChildViews();
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.refresh(cellViewArray[i], bl);
            }
        }
    }

    public void update(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.update(cellViewArray[i]);
            }
        }
    }

    public void update(CellView cellView) {
        if (cellView != null) {
            cellView.update();
            CellView[] cellViewArray = cellView.getChildViews();
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.update(cellViewArray[i]);
            }
        }
    }

    public void diagramChanged(DiagramModelEvent.DiagramModelChange diagramModelChange) {
        Object[] objectArray;
        Object object;
        CellView[] cellViewArray = diagramModelChange.getViews(this);
        if (cellViewArray != null) {
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null) continue;
                this.mapping.put(cellViewArray[i].getCell(), cellViewArray[i]);
            }
            this.setVisibleImpl(this.getCells(cellViewArray), true);
        }
        Object[] objectArray2 = this.order(diagramModelChange.getChanged());
        CellView[] cellViewArray2 = this.getMapping(diagramModelChange.getInserted(), true);
        cellViewArray = this.removeRoots(diagramModelChange.getRemoved());
        diagramModelChange.putViews(this, cellViewArray);
        this.insertRoots(cellViewArray2);
        if (this.isPartial()) {
            this.showCellsForChange(diagramModelChange);
            this.hideCellsForChange(diagramModelChange);
        }
        if (objectArray2 != null && objectArray2.length > 0) {
            if (!this.isOrdered()) {
                this.roots.clear();
                Object[] objectArray3 = DefaultDiagramModel.getRoots(this.diagramModel);
                object = this.getMapping(objectArray3, false);
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    if (object[i] == null) continue;
                    this.roots.add(object[i]);
                }
            }
            for (int i = 0; i < objectArray2.length; ++i) {
                object = this.getMapping(objectArray2[i], false);
                if (object == null) continue;
                object.refresh(true);
                this.update((CellView)object);
                this.factory.updateAutoSize(this.getDiagram(), (CellView)object);
                if (!this.isOrdered()) continue;
                CellView cellView = object.getParentView();
                Object object2 = cellView != null ? cellView.getCell() : null;
                boolean bl = this.roots.contains(object);
                if (object2 == null && !bl) {
                    this.roots.add(object);
                    continue;
                }
                if (object2 == null || !bl) continue;
                this.roots.remove(object);
            }
        }
        if ((objectArray = diagramModelChange.getInserted()) != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.factory.updateAutoSize(this.getDiagram(), this.getMapping(objectArray[i], false));
            }
        }
        this.refresh(this.getMapping(diagramModelChange.getContext(), false), false);
        object = diagramModelChange.getRemoved();
        if (object != null && ((Object[])object).length > 0 || objectArray != null && objectArray.length > 0) {
            this.updatePorts();
        }
    }

    protected void hideCellsForChange(DiagramModelEvent.DiagramModelChange diagramModelChange) {
        Object[] objectArray = diagramModelChange.getRemoved();
        HashSet<Object> hashSet = new HashSet<Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                hashSet.add(objectArray[i]);
            }
        }
        if (this.hideEdgesOnBecomeInvisible) {
            Object[] objectArray2 = diagramModelChange.getChanged();
            for (int i = 0; i < objectArray2.length; ++i) {
                CellView cellView = this.getMapping(objectArray2[i], false);
                if (!(cellView instanceof EdgeView)) continue;
                EdgeView edgeView = (EdgeView)cellView;
                Object object = edgeView.getSource() == null ? null : edgeView.getSource().getCell();
                Object object2 = edgeView.getTarget() == null ? null : edgeView.getTarget().getCell();
                Object object3 = this.diagramModel.getSource(objectArray2[i]);
                Object object4 = this.diagramModel.getTarget(objectArray2[i]);
                if (!hashSet.contains(object) && !hashSet.contains(object2) && (object3 == null || this.isVisible(object3)) && (object4 == null || this.isVisible(object4))) continue;
                this.setVisibleImpl(new Object[]{objectArray2[i]}, false);
            }
        }
    }

    protected void showCellsForChange(DiagramModelEvent.DiagramModelChange diagramModelChange) {
        if (this.showAllEdgesForVisibleVertices) {
            Object[] objectArray;
            Object object;
            Object[] objectArray2 = diagramModelChange.getInserted();
            if (objectArray2 != null) {
                for (int i = 0; i < objectArray2.length; ++i) {
                    if (this.isVisible(objectArray2[i]) || !this.showAllEdgesForVisibleVertices) continue;
                    Object object2 = this.diagramModel.getSource(objectArray2[i]);
                    object = this.diagramModel.getTarget(objectArray2[i]);
                    if (object2 == null && object == null || !this.isVisible(object2) || !this.isVisible(object)) continue;
                    this.setVisible(objectArray2[i], true);
                }
            }
            if ((objectArray = diagramModelChange.getChanged()) != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (this.isVisible(objectArray[i])) continue;
                    object = this.diagramModel.getSource(objectArray[i]);
                    Object object3 = this.diagramModel.getTarget(objectArray[i]);
                    if (object == null && object3 == null || !this.isVisible(object) || !this.isVisible(object3)) continue;
                    this.setVisible(objectArray[i], true);
                }
            }
        }
    }

    public void insertRoots(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            this.refresh(cellViewArray, true);
            for (int i = 0; i < cellViewArray.length; ++i) {
                Object object;
                if (cellViewArray[i] == null || this.getMapping(cellViewArray[i].getCell(), false) == null) continue;
                CellView cellView = cellViewArray[i].getParentView();
                Object object2 = object = cellView != null ? cellView.getCell() : null;
                if (cellViewArray[i] instanceof PortView || this.roots.contains(cellViewArray[i]) || object != null) continue;
                this.roots.add(cellViewArray[i]);
            }
        }
    }

    public CellView[] removeRoots(Object[] objectArray) {
        if (objectArray != null) {
            CellView[] cellViewArray = new CellView[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                cellViewArray[i] = this.removeMapping(objectArray[i]);
                if (cellViewArray[i] == null) continue;
                cellViewArray[i].removeFromParent();
                this.roots.remove(cellViewArray[i]);
            }
            this.setVisibleImpl(objectArray, false);
            return cellViewArray;
        }
        return null;
    }

    public Object[] getCells(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            Object[] objectArray = new Object[cellViewArray.length];
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null) continue;
                objectArray[i] = cellViewArray[i].getCell();
            }
            return objectArray;
        }
        return null;
    }

    @Override
    public CellView getMapping(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        CellView cellView = (CellView)this.mapping.get(object);
        if (cellView == null && bl) {
            cellView = (CellView)this.hiddenSet.get(object);
            if (cellView != null && this.isVisible(object)) {
                this.putMapping(object, cellView);
                this.hiddenSet.remove(object);
            } else {
                cellView = this.factory.createView(this.getDiagram(), this, object);
            }
        }
        return cellView;
    }

    public CellView[] getMapping(Object[] objectArray) {
        return this.getMapping(objectArray, false);
    }

    public CellView[] getMapping(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            CellView[] cellViewArray = new CellView[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                cellViewArray[i] = this.getMapping(objectArray[i], bl);
            }
            return cellViewArray;
        }
        return null;
    }

    @Override
    public void putMapping(Object object, CellView cellView) {
        if (object != null && cellView != null && this.isVisible(object)) {
            this.mapping.put(object, cellView);
        }
    }

    public CellView removeMapping(Object object) {
        if (object != null) {
            CellView cellView = (CellView)this.mapping.remove(object);
            return cellView;
        }
        return null;
    }

    public boolean isVisible(Object object) {
        return !this.isPartial() || this.visibleSet.contains(object) || object == null;
    }

    public Set getVisibleSet() {
        return new HashSet(this.visibleSet);
    }

    public void setVisibleSet(Set set) {
        this.visibleSet = set;
    }

    public void setVisible(Object object, boolean bl) {
        this.setVisible(new Object[]{object}, bl);
    }

    public void setVisible(Object[] objectArray, boolean bl) {
        if (bl) {
            this.setVisible(objectArray, null);
        } else {
            this.setVisible(null, objectArray);
        }
    }

    public void setVisible(Object[] objectArray, Object[] objectArray2) {
        objectArray = this.addVisibleDependencies(objectArray, true);
        objectArray2 = this.addVisibleDependencies(objectArray2, false);
        DiagramViewEdit diagramViewEdit = new DiagramViewEdit(null, objectArray, objectArray2);
        diagramViewEdit.end();
        this.diagramModel.edit(null, null, null, new UndoableEdit[]{diagramViewEdit});
    }

    public Object[] addVisibleDependencies(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            if (bl) {
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int i = 0; i < objectArray.length; ++i) {
                    hashSet.add(objectArray[i]);
                    hashSet.addAll(this.getPorts(objectArray[i]));
                    hashSet.addAll(this.getParentPorts(this.diagramModel.getSource(objectArray[i])));
                    hashSet.addAll(this.getParentPorts(this.diagramModel.getTarget(objectArray[i])));
                }
                if (this.showEdgesOnShow) {
                    Set set = DefaultDiagramModel.getEdges(this.getModel(), objectArray);
                    for (Object e : set) {
                        Object object = this.diagramModel.getSource(e);
                        Object object2 = this.diagramModel.getTarget(e);
                        if (!this.isVisible(object) && !hashSet.contains(object) || !this.isVisible(object2) && !hashSet.contains(object2)) continue;
                        hashSet.add(e);
                    }
                }
                hashSet.removeAll(this.visibleSet);
                return hashSet.toArray();
            }
            if (this.hideEdgesOnHide) {
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int i = 0; i < objectArray.length; ++i) {
                    hashSet.addAll(this.getPorts(objectArray[i]));
                    hashSet.add(objectArray[i]);
                }
                hashSet.addAll(DefaultDiagramModel.getEdges(this.diagramModel, objectArray));
                hashSet.retainAll(this.visibleSet);
                return hashSet.toArray();
            }
        }
        return null;
    }

    public boolean setVisibleImpl(Object[] objectArray, boolean bl) {
        if (objectArray != null && this.isPartial()) {
            int n;
            boolean bl2 = false;
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n] == null) continue;
                if (bl) {
                    this.visibleSet.add(objectArray[n]);
                    continue;
                }
                this.visibleSet.remove(objectArray[n]);
            }
            for (n = 0; n < objectArray.length; ++n) {
                CellView cellView;
                if (objectArray[n] == null) continue;
                if (!bl) {
                    cellView = this.getMapping(objectArray[n], false);
                    if (cellView == null) continue;
                    cellView.removeFromParent();
                    cellView.refresh(false);
                    this.removeMapping(objectArray[n]);
                    this.roots.remove(cellView);
                    if (this.diagramModel.contains(objectArray[n]) && this.rememberCellViews) {
                        this.hiddenSet.put(cellView.getCell(), cellView);
                    }
                    bl2 = true;
                    continue;
                }
                cellView = this.getMapping(objectArray[n], true);
                CellView[] cellViewArray = AbstractCellView.getDescendantViews(new CellView[]{cellView});
                for (int i = 0; i < cellViewArray.length; ++i) {
                    this.roots.remove(cellViewArray[i]);
                }
                cellView.refresh(false);
                this.factory.updateAutoSize(this.getDiagram(), cellView);
                CellView cellView2 = cellView.getParentView();
                if (cellView2 != null) {
                    cellView2.refresh(true);
                } else {
                    this.insertRoots(new CellView[]{cellView});
                }
                bl2 = true;
            }
            return bl2;
        }
        return false;
    }

    protected Collection getParentPorts(Object object) {
        Object object2 = this.diagramModel.getParent(object);
        Collection collection = this.getPorts(object2);
        collection.add(object2);
        return collection;
    }

    protected Collection getPorts(Object object) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < this.diagramModel.getChildCount(object); ++i) {
            Object object2 = this.diagramModel.getChild(object, i);
            if (!this.diagramModel.isPort(object2)) continue;
            linkedList.add(object2);
        }
        return linkedList;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void insert(Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        Serializable serializable;
        Object[] objectArray2 = null;
        if (this.isPartial()) {
            serializable = new HashSet(DefaultDiagramModel.getDescendants(this.diagramModel, objectArray));
            serializable.removeAll(this.visibleSet);
            if (!serializable.isEmpty()) {
                objectArray2 = serializable.toArray();
            }
        }
        serializable = this.createLocalEdit(map, objectArray2, null);
        this.setVisibleImpl(objectArray2, true);
        if (serializable != null) {
            undoableEditArray = this.augment(undoableEditArray, (UndoableEdit)((Object)serializable));
        }
        this.diagramModel.insert(objectArray, map, connectionSet, parentMap, undoableEditArray);
    }

    public void remove(Object[] objectArray) {
        this.diagramModel.remove(objectArray);
    }

    public void edit(Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        this.edit(map, connectionSet, parentMap, undoableEditArray, true);
    }

    public void edit(Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray, boolean bl) {
        Serializable serializable;
        Object[] objectArray = null;
        if (this.isPartial()) {
            serializable = new HashSet(map.keySet());
            serializable.removeAll(this.visibleSet);
            if (!serializable.isEmpty()) {
                objectArray = serializable.toArray();
            }
        }
        if ((serializable = this.createLocalEdit(map, objectArray, null)) != null) {
            undoableEditArray = this.augment(undoableEditArray, (UndoableEdit)((Object)serializable));
        }
        this.diagramModel.edit(map, connectionSet, parentMap, undoableEditArray, bl);
        ((Diagram)this.diagram).getDesignPartView().setDirty(true);
        ((Diagram)this.diagram).getDesignPartView().setZeroLayout();
    }

    protected UndoableEdit[] augment(UndoableEdit[] undoableEditArray, UndoableEdit undoableEdit) {
        if (undoableEdit != null) {
            int n = undoableEditArray != null ? undoableEditArray.length + 1 : 1;
            UndoableEdit[] undoableEditArray2 = new UndoableEdit[n];
            if (undoableEditArray != null) {
                System.arraycopy(undoableEditArray, 0, undoableEditArray2, 0, n - 2);
            }
            undoableEditArray2[n - 1] = undoableEdit;
            return undoableEditArray2;
        }
        return undoableEditArray;
    }

    public void toBack(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            if (this.isOrdered()) {
                Object[] objectArray2 = this.getMapping(objectArray, false);
                DiagramViewLayerEdit diagramViewLayerEdit = new DiagramViewLayerEdit(this, objectArray2, -2);
                this.diagramModel.edit(null, null, null, new UndoableEdit[]{diagramViewLayerEdit});
            } else {
                this.diagramModel.toBack(objectArray);
            }
        }
    }

    public void toFront(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            if (this.isOrdered()) {
                Object[] objectArray2 = this.getMapping(objectArray, false);
                DiagramViewLayerEdit diagramViewLayerEdit = new DiagramViewLayerEdit(this, objectArray2, -1);
                this.diagramModel.edit(null, null, null, new UndoableEdit[]{diagramViewLayerEdit});
            } else {
                this.diagramModel.toFront(objectArray);
            }
        }
    }

    protected DiagramViewEdit createLocalEdit(Map map, Object[] objectArray, Object[] objectArray2) {
        if (map != null && !map.isEmpty() && this.isAskLocalAttribute()) {
            Object object;
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map map2 = DiagramConstants.createMap();
                object = iterator.next();
                Object k = object.getKey();
                Map map3 = (Map)object.getValue();
                CellView cellView = this.getMapping(k, false);
                if (cellView != null) {
                    map3 = DiagramLayoutCache.diffMap(cellView.getAllAttributes(), map3);
                }
                Iterator iterator2 = map3.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry = iterator2.next();
                    Object k2 = entry.getKey();
                    Object v = entry.getValue();
                    boolean bl = this.isControlAttribute(k, k2, v);
                    if (!this.isLocalAttribute(k, k2, v) && !bl) continue;
                    map2.put(k2, v);
                    if (bl) continue;
                    iterator2.remove();
                }
                if (!map2.isEmpty()) {
                    hashtable2.put(k, map2);
                }
                if (map3.isEmpty()) continue;
                hashtable.put(k, map3);
            }
            map.clear();
            map.putAll(hashtable);
            object = new DiagramViewEdit(new Hashtable(hashtable2), objectArray, objectArray2);
            ((CompoundEdit)object).end();
            ((Diagram)this.diagram).getDesignPartView().setDirty(true);
            return object;
        }
        if (objectArray != null || objectArray2 != null) {
            DiagramViewEdit diagramViewEdit = new DiagramViewEdit(null, objectArray, objectArray2);
            diagramViewEdit.end();
            ((Diagram)this.diagram).getDesignPartView().setDirty(true);
            return diagramViewEdit;
        }
        return null;
    }

    public static Map diffMap(Map map, Map map2) {
        Hashtable hashtable = new Hashtable();
        for (Map.Entry entry : map2.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            Object v2 = map.get(k);
            if (v2 != null && v2.equals(v)) continue;
            hashtable.put(k, v);
        }
        return hashtable;
    }

    protected boolean isLocalAttribute(Object object, Object object2, Object object3) {
        return this.localAttributes.contains(object2);
    }

    protected boolean isControlAttribute(Object object, Object object2, Object object3) {
        return "removeAll".equals(object2) || "removeAttributes".equals(object2);
    }

    public Object[] order(Object[] objectArray) {
        if (objectArray != null) {
            if (this.diagramModel != null && this.isOrdered()) {
                Object[] objectArray2;
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int i = 0; i < objectArray.length; ++i) {
                    hashSet.add(objectArray[i]);
                }
                CellView[] cellViewArray = this.getRoots();
                Stack<Object> stack = new Stack<Object>();
                for (int i = 0; i < cellViewArray.length; ++i) {
                    stack.add(cellViewArray[i]);
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (!stack.isEmpty()) {
                    int n;
                    CellView cellView = (CellView)stack.pop();
                    if (hashSet.contains(cellView.getCell())) {
                        arrayList.add(cellView.getCell());
                    }
                    objectArray2 = cellView.getChildViews();
                    for (n = 0; n < objectArray2.length; ++n) {
                        stack.add(objectArray2[n]);
                    }
                    for (n = this.diagramModel.getChildCount(cellView.getCell()) - 1; n >= 0; --n) {
                        CellView cellView2;
                        Object object = this.diagramModel.getChild(cellView.getCell(), n);
                        if (!this.diagramModel.isPort(object) || (cellView2 = this.getMapping(object, false)) == null) continue;
                        stack.add(cellView2);
                    }
                }
                int n = arrayList.size();
                objectArray2 = new Object[n];
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    objectArray2[--n] = iterator.next();
                }
                return objectArray2;
            }
            Object[] objectArray3 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray3[objectArray.length - i - 1] = objectArray[i];
            }
            return objectArray3;
        }
        return objectArray;
    }

    protected Map handleAttributes(Map map) {
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        CellView[] cellViewArray = new CellView[map.size()];
        Iterator iterator = map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            CellView cellView;
            Map.Entry entry = iterator.next();
            cellViewArray[n] = cellView = this.getMapping(entry.getKey(), false);
            ++n;
            if (cellView == null) continue;
            Map map2 = (Map)entry.getValue();
            Map map3 = cellView.setAttributes(map2);
            cellView.refresh(false);
            hashtable.put(cellView.getCell(), map3);
            this.factory.updateAutoSize(this.getDiagram(), cellView);
        }
        this.update(cellViewArray);
        return hashtable;
    }

    public static void translateViews(CellView[] cellViewArray, double d, double d2, AbstractDiagram abstractDiagram) {
        int n;
        cellViewArray = AbstractCellView.getDescendantViews(cellViewArray);
        for (n = 0; n < cellViewArray.length; ++n) {
            Object object;
            if (!cellViewArray[n].isLeaf()) continue;
            if (cellViewArray[n] instanceof EdgeView) {
                object = DiagramConstants.getPoints(cellViewArray[n].getAllAttributes());
                if (object == null) continue;
                for (int i = 0; i < object.size(); ++i) {
                    Object e = object.get(i);
                    if (!(e instanceof Point2D)) continue;
                    Point2D point2D = (Point2D)e;
                    double d3 = point2D.getX() * -1.0;
                    double d4 = point2D.getY() * -1.0;
                    d = Math.max(d, d3);
                    d2 = Math.max(d2, d4);
                }
                continue;
            }
            object = DiagramConstants.getBounds(cellViewArray[n].getAllAttributes());
            double d5 = ((RectangularShape)object).getX() * -1.0;
            double d6 = ((RectangularShape)object).getY() * -1.0;
            d = Math.max(d, d5);
            d2 = Math.max(d2, d6);
        }
        for (n = 0; n < cellViewArray.length; ++n) {
            if (!cellViewArray[n].isLeaf()) continue;
            DiagramConstants.translate(cellViewArray[n].getAllAttributes(), d, d2, abstractDiagram);
        }
    }

    public CellView[] getAllDescendants(CellView[] cellViewArray) {
        CellView[] cellViewArray2;
        Stack<CellView> stack = new Stack<CellView>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (cellViewArray[i] == null) continue;
            stack.add(cellViewArray[i]);
        }
        ArrayList<CellView[]> arrayList = new ArrayList<CellView[]>();
        while (!stack.isEmpty()) {
            int n;
            cellViewArray2 = (CellView[])stack.pop();
            CellView[] cellViewArray3 = cellViewArray2.getChildViews();
            for (n = 0; n < cellViewArray3.length; ++n) {
                stack.add(cellViewArray3[n]);
            }
            arrayList.add(cellViewArray2);
            for (n = 0; n < this.diagramModel.getChildCount(cellViewArray2.getCell()); ++n) {
                CellView cellView;
                Object object = this.diagramModel.getChild(cellViewArray2.getCell(), n);
                if (!this.diagramModel.isPort(object) || (cellView = this.getMapping(object, false)) == null) continue;
                stack.add(cellView);
            }
        }
        cellViewArray2 = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray2);
        return cellViewArray2;
    }

    public Map getHiddenSet() {
        return this.hiddenSet;
    }

    public boolean isHideEdgesOnBecomeInvisible() {
        return this.hideEdgesOnBecomeInvisible;
    }

    public boolean isHideEdgesOnHide() {
        return this.hideEdgesOnHide;
    }

    public boolean isRememberCellViews() {
        return this.rememberCellViews;
    }

    public boolean isShowAllEdgesForVisibleVertices() {
        return this.showAllEdgesForVisibleVertices;
    }

    public boolean isShowEdgesOnShow() {
        return this.showEdgesOnShow;
    }

    public void setHiddenSet(Map map) {
        this.hiddenSet = map;
    }

    public void setHideEdgesOnBecomeInvisible(boolean bl) {
        this.hideEdgesOnBecomeInvisible = bl;
    }

    public void setHideEdgesOnHide(boolean bl) {
        this.hideEdgesOnHide = bl;
    }

    public void setRememberCellViews(boolean bl) {
        this.rememberCellViews = bl;
    }

    public void setShowAllEdgesForVisibleVertices(boolean bl) {
        this.showAllEdgesForVisibleVertices = bl;
    }

    public void setShowEdgesOnShow(boolean bl) {
        this.showEdgesOnShow = bl;
    }

    public Set getLocalAttributes() {
        return this.localAttributes;
    }

    public void setLocalAttributes(Set set) {
        this.localAttributes = set;
    }

    public boolean isAskLocalAttribute() {
        return this.askLocalAttribute;
    }

    public void setAskLocalAttribute(boolean bl) {
        this.askLocalAttribute = bl;
    }

    public static class DiagramViewLayerEdit
    extends AbstractUndoableEdit
    implements DiagramModelEvent.DiagramViewChange,
    DiagramModelEvent.ExecutableDiagramChange {
        public static final int FRONT = -1;
        public static final int BACK = -2;
        protected Object changeSource;
        protected transient Object[] cells;
        protected transient int[] next;
        protected transient int[] prev;
        protected int layer;

        public DiagramViewLayerEdit(Object object, Object[] objectArray, int n) {
            this.changeSource = object;
            this.cells = objectArray;
            this.layer = n;
            this.next = new int[objectArray.length];
            this.prev = new int[objectArray.length];
            this.updateNext();
        }

        protected void updateNext() {
            for (int i = 0; i < this.next.length; ++i) {
                this.next[i] = this.layer;
            }
        }

        @Override
        public Object getSource() {
            return this.changeSource;
        }

        @Override
        public Object[] getChanged() {
            return this.cells;
        }

        @Override
        public Object[] getContext() {
            return null;
        }

        @Override
        public Map getAttributes() {
            return null;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.updateNext();
            this.execute();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        @Override
        public void execute() {
            for (int i = 0; i < this.cells.length; ++i) {
                List list = this.getParentList(this.cells[i]);
                if (list == null) continue;
                this.prev[i] = list.indexOf(this.cells[i]);
                if (this.prev[i] < 0) continue;
                list.remove(this.prev[i]);
                int n = this.next[i];
                if (n == -1) {
                    n = list.size();
                } else if (n == -2) {
                    n = 0;
                }
                list.add(n, this.cells[i]);
                this.next[i] = this.prev[i];
            }
            this.updateListeners();
        }

        protected void updateListeners() {
            ((DiagramLayoutCache)this.changeSource).setChanged();
            ((DiagramLayoutCache)this.changeSource).notifyObservers(this);
        }

        protected List getParentList(Object object) {
            if (object instanceof CellView) {
                CellView cellView = ((CellView)object).getParentView();
                List list = null;
                if (cellView == null) {
                    list = ((DiagramLayoutCache)this.changeSource).roots;
                } else if (cellView instanceof AbstractCellView) {
                    list = ((AbstractCellView)cellView).childViews;
                }
                return list;
            }
            return null;
        }
    }

    public class DiagramViewEdit
    extends CompoundEdit
    implements DiagramModelEvent.DiagramViewChange,
    DiagramModelEvent.ExecutableDiagramChange {
        protected Object[] cells;
        protected CellView[] context;
        protected CellView[] hidden;
        protected Map attributes;
        protected Object[] visible;
        protected Object[] invisible;

        public DiagramViewEdit(Map map) {
            this(map, null, null);
            this.attributes = map;
        }

        public DiagramViewEdit(Map map, Object[] objectArray, Object[] objectArray2) {
            this.attributes = map;
            if (map != null) {
                this.cells = map.keySet().toArray();
                Set set = DefaultDiagramModel.getEdges(DiagramLayoutCache.this.getModel(), this.cells);
                this.context = DiagramLayoutCache.this.getMapping(set.toArray());
            }
            this.visible = objectArray;
            this.invisible = objectArray2;
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public Object getSource() {
            return DiagramLayoutCache.this;
        }

        @Override
        public Object[] getChanged() {
            if (this.attributes != null) {
                return this.attributes.keySet().toArray();
            }
            return null;
        }

        @Override
        public Object[] getContext() {
            return this.context;
        }

        @Override
        public Map getAttributes() {
            return this.attributes;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        @Override
        public void execute() {
            int n;
            if (this.hidden != null) {
                for (n = 0; n < this.hidden.length; ++n) {
                    if (this.hidden[n] == null) continue;
                    DiagramLayoutCache.this.mapping.put(this.hidden[n].getCell(), this.hidden[n]);
                }
            }
            if (!DiagramLayoutCache.this.rememberCellViews) {
                this.hidden = DiagramLayoutCache.this.getMapping(this.invisible);
            }
            n = DiagramLayoutCache.this.setVisibleImpl(this.visible, true) | DiagramLayoutCache.this.setVisibleImpl(this.invisible, false);
            Object[] objectArray = this.visible;
            this.visible = this.invisible;
            this.invisible = objectArray;
            if (this.attributes != null) {
                this.attributes = DiagramLayoutCache.this.handleAttributes(this.attributes);
            }
            if (n != 0) {
                DiagramLayoutCache.this.updatePorts();
            }
            if (this.context != null) {
                for (int i = 0; i < this.context.length; ++i) {
                    if (this.context[i] == null) continue;
                    this.context[i].refresh(false);
                }
            }
            DiagramLayoutCache.this.setChanged();
            DiagramLayoutCache.this.notifyObservers(this);
        }
    }
}

