/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.undo.GroupRemoveEdit;
import oracle.dbtools.crest.model.design.undo.RemoveDO_Edit;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TopViewColorDialog;
import oracle.ide.Ide;

public class DefaultDiagramCell
extends DefaultMutableTreeNode
implements DiagramCell,
Cloneable {
    public static final String FORMAT = Messages.getString("DefaultDiagramCell.Format");
    public static final String PROPERTIES = Messages.getString("DefaultDiagramCell.Properties");
    public static final String CUT = Messages.getString("DefaultDiagramCell.Cut");
    public static final String COPY = Messages.getString("DefaultDiagramCell.Copy");
    public static final String PASTE = Messages.getString("DefaultDiagramCell.Paste");
    public static final String DELETE = Messages.getString("DefaultDiagramCell.Delete");
    public static final String DELETE_FROM_DFD = "Delete from DFD";
    public static final String DELETE_OBJECT = Messages.getString("DefaultDiagramCell.DeleteObject");
    public static final String DELETE_OBJECTS = Messages.getString("DefaultDiagramCell.DeleteObjects");
    public static final String DELETE_VIEW = Messages.getString("DefaultDiagramCell.DeleteView");
    public static final String DELETE_VIEWS = Messages.getString("DefaultDiagramCell.DeleteViews");
    public static final String CREATE_SYNONYM = Messages.getString("DefaultDiagramCell.CreateSynonym");
    public static final String DDL_PREVIEW = Messages.getString("DefaultDiagramCell.DDLPreview");
    public static final String BOX_IN_BOX = Messages.getString("DefaultDiagramCell.BoxInBoxPresentation");
    public static final String CREATE_SUBVIEW_FROM_SELECTED = Messages.getString("DefaultDiagramCell.CreateSubViewFromSelected");
    public static final String SELECT_NEIGHBORS = Messages.getString("DefaultDiagramCell.SelectNeighbors");
    public static final String SEND_TO_BACK = Messages.getString("DefaultDiagramCell.SendToBack");
    public static final String STRAIGHT_LINE = Messages.getString("DefaultDiagramCell.StraightenLines");
    public static final String ADD_BREAKPOINT = Messages.getString("DefaultDiagramCell.AddElbow");
    public static final String REMOVE_BREAKPOINT = Messages.getString("DefaultDiagramCell.RemoveElbow");
    public static final String CHECK_OUT = Messages.getString("DefaultDiagramCell.CheckOut");
    public static final String CHECK_IN = Messages.getString("DefaultDiagramCell.CheckIn");
    public static final String RESIZE_TO_VISIBLE = Messages.getString("DefaultDiagramCell.ResizeToVisible");
    public static final String VERSIONING = Messages.getString("DefaultDiagramCell.Versioning");
    protected Object[] selectedObjects;
    public static final Rectangle defaultBounds = new Rectangle(20, 20, 200, 120);
    private AbstractCellView cellView;
    private TopView topView;
    protected Map attributes = DiagramConstants.createMap();

    public DefaultDiagramCell() {
        this(null);
    }

    public void showPopupMenu(Point point) {
    }

    public void doubleClick() {
    }

    protected boolean isEditable() {
        return this.isEditable(false);
    }

    protected boolean isEditable(boolean bl) {
        if (ApplicationView.IS_VIEWER) {
            if (bl && this.topView != null) {
                return this.topView.getDesignPartView().getDesign().isNewDesign();
            }
            return false;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY && this.topView != null) {
            return this.topView.getDesignPartView() instanceof DPVLogical;
        }
        return true;
    }

    protected void setEnabled(JComponent jComponent, boolean bl) {
        if (jComponent != null) {
            jComponent.setEnabled(bl);
        }
    }

    public DefaultDiagramCell(Object object) {
        this(object, null);
    }

    public DefaultDiagramCell(Object object, MutableTreeNode[] mutableTreeNodeArray) {
        super(object, true);
        this.setUserObject(object);
        if (mutableTreeNodeArray != null) {
            for (int i = 0; i < mutableTreeNodeArray.length; ++i) {
                this.add(mutableTreeNodeArray[i]);
            }
        }
        DiagramConstants.setBounds(this.attributes, defaultBounds);
    }

    public DefaultDiagramCell(Object object, boolean bl) {
        super(object, bl);
    }

    @Override
    public void setUserObject(Object object) {
        if (this.userObject instanceof ValueChangeHandler) {
            ((ValueChangeHandler)this.userObject).valueChanged(object);
        } else {
            super.setUserObject(object);
        }
        object = this.getUserObject();
        if (object == null) {
            DiagramConstants.setValue(this.attributes, "");
        } else {
            DiagramConstants.setValue(this.attributes, object);
        }
    }

    public List getChildren() {
        if (this.children == null) {
            return Collections.EMPTY_LIST;
        }
        return this.children;
    }

    @Override
    public Map getAttributes() {
        return this.attributes;
    }

    @Override
    public Map changeAttributes(Map map) {
        Object object;
        Map map2 = DiagramConstants.applyMap(map, this.attributes);
        Object object2 = DiagramConstants.getValue(this.attributes);
        if (this.userObject != null && object2 == null) {
            DiagramConstants.setValue(this.attributes, this.userObject);
        } else if (this.userObject instanceof ValueChangeHandler) {
            object = ((ValueChangeHandler)this.userObject).valueChanged(object2);
            if (object == null || !object2.toString().equals(object.toString())) {
                DiagramConstants.setValue(map2, object);
            }
            DiagramConstants.setValue(this.attributes, this.userObject);
        } else {
            this.setUserObject(object2);
        }
        object = DiagramConstants.getBounds(this.attributes);
        if (object == null) {
            DiagramConstants.setBounds(this.attributes, defaultBounds);
        }
        return map2;
    }

    @Override
    public void setAttributes(Map map) {
        this.attributes = map;
    }

    @Override
    public Object clone() {
        DefaultDiagramCell defaultDiagramCell = (DefaultDiagramCell)super.clone();
        defaultDiagramCell.attributes = DiagramConstants.createMap();
        defaultDiagramCell.attributes.putAll(this.attributes);
        defaultDiagramCell.userObject = this.cloneUserObject();
        return defaultDiagramCell;
    }

    protected Object cloneUserObject() {
        if (this.userObject instanceof ValueChangeHandler) {
            return ((ValueChangeHandler)this.userObject).clone();
        }
        return this.userObject;
    }

    public AbstractCellView getCellView() {
        return this.cellView;
    }

    public void setCellView(AbstractCellView abstractCellView) {
        this.cellView = abstractCellView;
    }

    public Diagram getDiagram() {
        if (this.cellView != null) {
            return (Diagram)this.cellView.getDiagram();
        }
        return null;
    }

    public TopView getTopView() {
        return this.topView;
    }

    public void format() {
        if (this.topView != null) {
            new TopViewColorDialog(this.topView.getDesignPartView().getSelectedTopViews()).setVisible(true);
            this.getCellView().getDiagram().repaint();
        }
    }

    private ApplicationView getApplicationView() {
        return this.topView.getApplicationView();
    }

    public boolean checkOut() {
        DesignObject designObject = this.topView.getModel();
        AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        boolean bl = false;
        if (abstractRepositoryManager.isConnected()) {
            String string = null;
            try {
                string = abstractRepositoryManager.getCheckoutByUser(designObject);
            }
            catch (SQLException sQLException) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("DefaultDiagramCell.ErrorInCheckout"), sQLException.getMessage()}, Messages.getString("DefaultDiagramCell.CheckoutError"), 0);
                return false;
            }
            if (string != null) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("DefaultDiagramCell.CheckedOut"), designObject.getName(), string), Messages.getString("DefaultDiagramCell.CheckoutError"), 0);
                designObject.setCheckedOut(true);
                designObject.setCheckedOutByMe(false);
                return false;
            }
            bl = abstractRepositoryManager.checkOutObject(designObject);
            if (bl) {
                designObject.setCheckedOutByMe(true);
                this.getApplicationView().getBrowserPanel().getJTree().updateUI();
            }
        }
        return bl;
    }

    public boolean checkIn() {
        DesignObject designObject = this.topView.getModel();
        AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        boolean bl = false;
        if (abstractRepositoryManager.isConnected()) {
            if (designObject.isDirty()) {
                abstractRepositoryManager.writeObject(designObject);
                designObject.setDirty(false);
            }
            if (bl = abstractRepositoryManager.checkInObject(designObject)) {
                designObject.setCheckedOut(false);
                designObject.setCheckedOutByMe(false);
                this.getApplicationView().getBrowserPanel().getJTree().updateUI();
            }
        }
        return bl;
    }

    public boolean canShowCheckOutFor() {
        DesignObject designObject = this.topView.getModel();
        AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        boolean bl = false;
        if (this.isCheckInOutObject() && !designObject.isCheckedOut() && abstractRepositoryManager.isConnected() && this.getApplicationView().getCurrentDesign().isLoadFromDB()) {
            bl = designObject.getRepositoryOID() != null;
        }
        return bl;
    }

    public boolean canShowCheckInFor() {
        DesignObject designObject = this.topView.getModel();
        AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        boolean bl = false;
        if (this.isCheckInOutObject() && designObject.isCheckedOut() && abstractRepositoryManager.isConnected() && this.getApplicationView().getCurrentDesign().isLoadFromDB() && designObject.isCheckedOutByMe()) {
            bl = designObject.getRepositoryOID() != null;
        }
        return bl;
    }

    public boolean isCheckInOutObject() {
        DesignObject designObject = this.topView.getModel();
        return designObject instanceof ContainerObject || designObject instanceof ConnectionInterface || designObject instanceof Domain || designObject instanceof AbstractDTObject || designObject instanceof AbstractMDObject || designObject instanceof AbstractProcessObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteObjects(Object[] objectArray, ApplicationView applicationView) {
        int n = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("DefaultDiagramCell.DeleteSelected"), String.valueOf(objectArray.length)), Messages.getString("DefaultDiagramCell.SelectedWillBeDeleted"), 0, 3, null, new String[]{Messages.getString("DefaultDiagramCell.RemoveObjects"), Messages.getString("DefaultDiagramCell.Cancel")}, Messages.getString("DefaultDiagramCell.RemoveObjects"));
        if (n == 0 && objectArray.length > 0) {
            GroupRemoveEdit groupRemoveEdit = new GroupRemoveEdit((DesignObject)objectArray[0]);
            ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
            ArrayList<DesignObject> arrayList2 = new ArrayList<DesignObject>();
            ArrayList<DesignObject> arrayList3 = new ArrayList<DesignObject>();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof DesignObject)) continue;
                DesignObject designObject = (DesignObject)objectArray[i];
                if (designObject.getTopView() instanceof TVConnector) {
                    arrayList.add(designObject);
                    continue;
                }
                if (designObject instanceof FKArc || designObject instanceof Arc) {
                    arrayList3.add(designObject);
                    continue;
                }
                arrayList2.add(designObject);
            }
            for (DesignObject designObject : arrayList3) {
                RemoveDO_Edit.addUndoableRemoveEditForObject(groupRemoveEdit, designObject);
                designObject.remove();
            }
            for (DesignObject designObject : arrayList) {
                RemoveDO_Edit.addUndoableRemoveEditForObject(groupRemoveEdit, designObject);
                if (designObject instanceof FKIndexAssociation) {
                    FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)designObject;
                    if (arrayList2.contains(fKIndexAssociation.getTable())) {
                        fKIndexAssociation.setSilentRemove(true);
                        try {
                            fKIndexAssociation.remove();
                            continue;
                        }
                        finally {
                            fKIndexAssociation.setSilentRemove(false);
                            continue;
                        }
                    }
                    fKIndexAssociation.remove();
                    continue;
                }
                designObject.remove();
            }
            for (DesignObject designObject : arrayList2) {
                if (designObject instanceof Entity) {
                    if (((Entity)designObject).getRelationConnections().length <= 0) {
                        RemoveDO_Edit.addUndoableRemoveEditForObject(groupRemoveEdit, designObject);
                        ((Entity)designObject).remove(true);
                        continue;
                    }
                    MessageDialogs.showWarningMessage("Delete or remove relations before deleting entity '" + designObject.getName() + "'.");
                    continue;
                }
                RemoveDO_Edit.addUndoableRemoveEditForObject(groupRemoveEdit, designObject);
                designObject.remove();
            }
            groupRemoveEdit.end();
            if (groupRemoveEdit.getNumberOfEdits() > 0) {
                ((DesignObject)objectArray[0]).getDesignPart().postUndoableEdit(groupRemoveEdit);
            }
        }
    }

    public void setTopView(TopView topView) {
        this.topView = topView;
    }

    public void deleteSelected() {
    }

    public boolean canDeleteModelObject() {
        DesignObject designObject;
        TopView topView = this.getTopView();
        if (topView != null && (designObject = topView.getModel()) != null) {
            return designObject.canBedeleted();
        }
        return false;
    }

    public static interface ValueChangeHandler {
        public Object valueChanged(Object var1);

        public Object clone();
    }
}

