/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.relational.DPVRelational;

public class ContainerRenderer
extends JLabel
implements CellViewRenderer {
    public static final String NOT_NULL = "*";
    public static final String ALLOW_NULL = "";
    protected static final Icon KEY_ICON = GUIConfiguration.getInstance().getIcon("KEY_ICON");
    protected static final Icon PKEY_ICON = GUIConfiguration.getInstance().getIcon("PKEY_ICON");
    public static final int TITLE_PADDING = 3;
    public static final int COLUMN_PADDING = 1;
    public static final int COLUMN_LEFT = 25;
    public static final int DATATYPE_LEFT = 40;
    public static final int ALLOW_NULL_LEFT = 16;
    public static final int TYPE_LEFT = 2;
    public static final int ROW_SPACING = 3;
    public static final int MORE_ARROW_PADDING = 4;
    public static final int MORE_ARROW_WIDTH = 8;
    public static final int MORE_ARROW_HEIGHT = 8;
    protected transient AbstractDiagram diagram;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient Color defaultForeground = Color.BLACK;
    protected transient Color defaultBackground = Color.WHITE;
    protected transient Color bordercolor;
    protected transient Color datatypeColor = new Color(0, 128, 0);
    protected transient Color allowNullColor = Color.RED;
    protected transient Color typeColor = Color.BLUE;
    protected transient int borderWidth;
    protected transient ContainerObject container;
    protected String title = "";
    protected String longName = "";
    public static Color SUMMARY_COLOR = new Color(207, 244, 202);
    public static Color TEMP_COLOR = new Color(255, 255, 255);
    public static Color LOGGING_COLOR = new Color(228, 228, 228);
    protected CellView view;

    protected Color getBackgroundColor() {
        return this.defaultBackground;
    }

    protected Color getElementsColor() {
        return Color.BLACK;
    }

    protected Font getElementsFont() {
        return new Font("Dialog", 0, 10);
    }

    protected Font getKeysFont() {
        return ((EditableFonts)((Object)this.container)).getFontObject(EditableFonts.FO_KEY).getFont();
    }

    protected Color getKeyColor() {
        return ((EditableFonts)((Object)this.container)).getFontObject(EditableFonts.FO_KEY).getColor();
    }

    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            return this.getForeground();
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public Color getBGColor() {
        return this.getBackgroundColor();
    }

    @Override
    public Color getFGColor() {
        return this.getForegroundColor();
    }

    public Color getBorderColor() {
        return this.getForegroundColor();
    }

    @Override
    public Component getRendererComponent(AbstractDiagram abstractDiagram, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof ContainerView) {
            ContainerDiagramCell containerDiagramCell = (ContainerDiagramCell)cellView.getCell();
            this.container = containerDiagramCell.getContainer();
            if (containerDiagramCell.getTopView() != null) {
                this.title = containerDiagramCell.getTopView().toString();
            }
            if (this.container.isBST()) {
                this.title = this.title + " (" + this.container.getBasedOnStructuredType().getName() + ")";
            }
            this.longName = containerDiagramCell.getDiagram().getDesignPartView().showSchemaName() && this.container.getSchemaObject() != null ? this.container.getSchemaObject().getName() + "." + this.title : this.title;
            this.diagram = abstractDiagram;
            this.hasFocus = bl2;
            this.selected = bl;
            this.preview = bl3;
            this.setComponentOrientation(abstractDiagram.getComponentOrientation());
            if (cellView.isLeaf()) {
                this.installAttributes(cellView);
            } else {
                this.setBorder(null);
                this.setOpaque(false);
            }
            this.view = cellView;
            return this;
        }
        return null;
    }

    protected String getType() {
        return null;
    }

    protected void installAttributes(CellView cellView) {
        Color color;
        Map map = cellView.getAllAttributes();
        this.setOpaque(DiagramConstants.isOpaque(map));
        this.setBorder(DiagramConstants.getBorder(map));
        this.bordercolor = DiagramConstants.getBorderColor(map);
        this.borderWidth = Math.max(1, Math.round(DiagramConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground((color = DiagramConstants.getForeground(map)) != null ? color : this.defaultForeground);
        Color color2 = DiagramConstants.getBackground(map);
        this.setBackground(color2 != null ? color2 : this.getBackgroundColor());
        this.setFont(this.diagram.getFont());
    }

    protected String getDataType(ContainedObjectWithDomain containedObjectWithDomain) {
        Object object;
        if (this.container instanceof Entity || this.container instanceof Table) {
            object = containedObjectWithDomain.getFormulaDesc();
            if (object != null && ((String)object).length() > 0 && ("Derived".equalsIgnoreCase(containedObjectWithDomain.getSourceType()) || "Aggregate".equalsIgnoreCase(containedObjectWithDomain.getSourceType()) || containedObjectWithDomain instanceof Column && ((Column)containedObjectWithDomain).isComputed().booleanValue())) {
                return object;
            }
            if (containedObjectWithDomain instanceof Attribute) {
                return ((Attribute)containedObjectWithDomain).getLogicalRepresentationName();
            }
            if (containedObjectWithDomain.isReference() && containedObjectWithDomain.getDataType() instanceof StructuredType) {
                return "REF " + containedObjectWithDomain.getDataType().toString();
            }
        }
        if ((object = containedObjectWithDomain.getDataType()) instanceof DistinctType && containedObjectWithDomain instanceof Column) {
            String string = containedObjectWithDomain.getSelectedRDBMSType().toString();
            if (string.startsWith("DB2")) {
                return object.getName();
            }
            object = containedObjectWithDomain.getDataType(string);
        }
        if (object != null) {
            return object.toString();
        }
        return ALLOW_NULL;
    }

    @Override
    public void paint(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        EditableFonts editableFonts = (EditableFonts)((Object)this.container);
        graphics2D.setPaint(this.getBackgroundColor());
        graphics.fillRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(this.getBorderColor());
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        Font font = editableFonts.getFontObject(EditableFonts.FO_TITLE).getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
        int n4 = Math.max(n3, font.getSize());
        int n5 = (n - fontMetrics.stringWidth(this.longName)) / 2;
        if (n5 < 20) {
            n5 = 20;
        }
        BasicStroke basicStroke = new BasicStroke(this.borderWidth);
        BasicStroke basicStroke2 = new BasicStroke(1.0f);
        graphics2D.setStroke(basicStroke2);
        graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_TITLE).getColor());
        String[] stringArray = ContainerRenderer.wrapText(this.longName, ContainerRenderer.getMaxChars(this.longName, fontMetrics, n - 20 - 5));
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            graphics.drawString((String)object, n5, n4);
            n4 += n3;
        }
        n4 -= n3;
        String string = this.getType();
        if (string != null && string.length() > 0) {
            graphics.drawString(string, 5, n4);
        }
        if ((object = this.getDesignPartView()) != null && !((DesignPartView)object).clearDetails() && !((DesignPartView)object).isShowNamesOnly()) {
            int n6;
            int n7;
            Object object2;
            DesignObject designObject;
            Object object3;
            Object object4;
            graphics2D.setStroke(basicStroke);
            graphics.setColor(this.getBorderColor());
            graphics.drawLine(0, n4 += 3 + this.borderWidth, n - 2, n4);
            if (((DesignPartView)object).showAllDetails() || ((DesignPartView)object).showElements() || ((DesignPartView)object).showKeyElements()) {
                int n8;
                Object object5;
                if (this.container.isBST() && this.container.getTypeSubstitution() != null) {
                    object4 = this.container.getTypeSubstitution();
                    object3 = ((TypeSubstitution)object4).getParentContainerObject();
                    if (object3 != null) {
                        // empty if block
                    }
                    if ((designObject = this.container.getBasedOnStructuredType()) != null) {
                        object2 = ((StructuredType)designObject).getElements();
                        object5 = this.getLongestTypeName((TypeElement[])object2);
                        graphics.setFont(this.getElementsFont());
                        fontMetrics = graphics.getFontMetrics();
                        n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
                        for (n7 = 0; n7 < ((TypeElement[])object2).length; ++n7) {
                            TypeElement typeElement = object2[n7];
                            graphics.setColor(this.getElementsColor());
                            graphics.setFont(this.getElementsFont());
                            float f = this.getElementsFont().getSize2D();
                            graphics.drawString(typeElement.getName(), 25, n4 += 3 + fontMetrics.getMaxAscent());
                            fontMetrics = graphics.getFontMetrics();
                            n8 = fontMetrics.stringWidth((String)object5) + 50;
                            graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                            graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getFont().deriveFont(f));
                            graphics.drawString(typeElement.getDataType(), n8, n4);
                            graphics.setColor(this.getForeground());
                        }
                    }
                } else {
                    graphics2D.setStroke(basicStroke2);
                    object4 = this.container.getElements();
                    object3 = this.getLongestName((ContainedObject[])object4);
                    float f = Math.max(this.getElementsFont().getSize2D(), editableFonts.getFontObject(EditableFonts.FO_PK).getFont().getSize2D());
                    f = Math.max(f, editableFonts.getFontObject(EditableFonts.FO_UK).getFont().getSize2D());
                    f = Math.max(f, editableFonts.getFontObject(EditableFonts.FO_FK).getFont().getSize2D());
                    f = Math.max(f, editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getFont().getSize2D());
                    graphics.setFont(this.getElementsFont().deriveFont(f));
                    fontMetrics = graphics.getFontMetrics();
                    n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
                    for (int i = 0; i < ((Object)object4).length; ++i) {
                        object5 = (ContainedObjectWithDomain)object4[i];
                        if (((ContainedObject)object5).isOid() || ((DesignPartView)object).showKeyElements() && !((ContainedObjectWithDomain)object5).isPKElement() && !((ContainedObject)object5).isFKElement() && !((ContainedObjectWithDomain)object5).isUnique()) continue;
                        n4 += 3 + fontMetrics.getMaxAscent();
                        String string2 = " ";
                        graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_PK).getFont().deriveFont(f));
                        if (((ContainedObjectWithDomain)object5).isPKElement()) {
                            string2 = "P";
                            graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_PK).getColor());
                            graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_PK).getFont().deriveFont(f));
                            if (((ContainedObject)object5).isFKElement()) {
                                string2 = string2.concat("F");
                            }
                        } else if (((ContainedObjectWithDomain)object5).isUnique()) {
                            string2 = "U";
                            graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_UK).getColor());
                            graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_UK).getFont().deriveFont(f));
                            if (((ContainedObject)object5).isFKElement()) {
                                string2 = string2.concat("F");
                            }
                        } else if (((ContainedObject)object5).isFKElement()) {
                            string2 = "F";
                            graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_FK).getColor());
                            graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_FK).getFont().deriveFont(f));
                        }
                        graphics.drawString(string2, 2, n4);
                        fontMetrics = graphics.getFontMetrics();
                        int n9 = fontMetrics.stringWidth("KW");
                        graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_NOT_NULL).getColor());
                        graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_NOT_NULL).getFont().deriveFont(f));
                        graphics.drawString(((ContainedObject)object5).getNullsAllowed() ? ALLOW_NULL : NOT_NULL, n9, n4);
                        if (((ContainedObjectWithDomain)object5).isPKElement()) {
                            graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_PK).getColor());
                            graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_PK).getFont().deriveFont(f));
                        } else if (((ContainedObjectWithDomain)object5).isUnique()) {
                            graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_UK).getColor());
                            graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_UK).getFont().deriveFont(f));
                        } else if (((ContainedObject)object5).isFKElement()) {
                            graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_FK).getColor());
                            graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_FK).getFont().deriveFont(f));
                        } else {
                            graphics.setColor(this.getElementsColor());
                            graphics.setFont(this.getElementsFont().deriveFont(f));
                        }
                        boolean bl = false;
                        n8 = 0;
                        if ((ApplicationView.SHOW_MASKED_DATA || ApplicationView.SHOW_SENSITIVE_DATA) && object5 instanceof Column) {
                            Boolean bl2;
                            Column column = (Column)object5;
                            if (ApplicationView.SHOW_SENSITIVE_DATA) {
                                bl2 = column.isContainsSensitiveInformation();
                                boolean bl3 = bl = bl2 != null && bl2 != false;
                            }
                            if (ApplicationView.SHOW_MASKED_DATA) {
                                bl2 = column.isMaskData();
                                int n10 = n8 = bl2 != null && bl2 != false ? 1 : 0;
                            }
                        }
                        if (bl || n8 != 0) {
                            graphics.setColor(Color.RED);
                            if (n8 == 0) {
                                graphics.setFont(graphics.getFont().deriveFont(3));
                            }
                        }
                        fontMetrics = graphics.getFontMetrics();
                        graphics.drawString(((ContainedObject)object5).getName(), n9 += fontMetrics.stringWidth("N") + 3, n4);
                        if (((DesignPartView)object).showAllDetails() || ((DesignPartView)object).showDatatype()) {
                            graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                            graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getFont().deriveFont(f));
                            fontMetrics = graphics.getFontMetrics();
                            n9 += fontMetrics.stringWidth((String)object3) + 20;
                            if (bl && n8 == 0) {
                                graphics.setColor(Color.RED);
                                graphics.setFont(graphics.getFont().deriveFont(3));
                            }
                            graphics.drawString(this.getDataType((ContainedObjectWithDomain)object5), n9, n4);
                        }
                        graphics.setColor(this.getForeground());
                        if (n4 <= n2) continue;
                        graphics.setColor(this.getBorderColor());
                        int n11 = n - 4;
                        int n12 = n11 - 8;
                        n6 = n11 - 4;
                        int n13 = n2 - 4;
                        int n14 = n13 - 8;
                        int[] nArray = new int[]{n6, n12, n11};
                        int[] nArray2 = new int[]{n13, n14, n14};
                        graphics.fillPolygon(nArray, nArray2, 3);
                        break;
                    }
                }
            }
            if ((((DesignPartView)object).showAllDetails() || ((DesignPartView)object).showKeys()) && (object4 = this.getKeys(((ContainerWithKeyObject)this.container).getKeys())).size() > 0) {
                if (((DesignPartView)object).showAllDetails() || ((DesignPartView)object).showElements()) {
                    graphics.setColor(this.getBorderColor());
                    graphics2D.setStroke(basicStroke);
                    n4 += n4 / 14;
                    graphics.drawLine(0, n4, n - 2, n4);
                }
                graphics2D.setStroke(basicStroke2);
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    designObject = (KeyObject)object3.next();
                    if (!((KeyObject)designObject).isPK() && !((KeyObject)designObject).isUnique()) continue;
                    int n15 = 4;
                    if (((KeyObject)designObject).isPK()) {
                        object2 = PKEY_ICON;
                        n15 = 2;
                    } else {
                        object2 = KEY_ICON;
                    }
                    graphics.setColor(this.getKeyColor());
                    graphics.setFont(this.getKeysFont());
                    fontMetrics = graphics.getFontMetrics();
                    n4 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
                    n7 = -(object2.getIconHeight() + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2;
                    try {
                        object2.paintIcon(this, graphics, n15, n4 + n7 + 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String string3 = designObject.getName();
                    if (((DesignPartView)object).showAllDetails() || ((DesignPartView)object).showKeyAndIndexColumns()) {
                        Index index;
                        ContainedObject[] containedObjectArray = ((ContainerObject)designObject).getElements();
                        string3 = string3 + " (";
                        String string4 = null;
                        if (designObject instanceof Index && ALLOW_NULL.equals(string4 = (index = (Index)designObject).getIndexExpression())) {
                            string4 = null;
                        }
                        if (string4 == null) {
                            for (int i = 0; i < containedObjectArray.length; ++i) {
                                ContainedObject containedObject = containedObjectArray[i];
                                String string5 = containedObject.getName();
                                if (i > 0) {
                                    string3 = string3 + ", ";
                                }
                                string3 = string3 + string5;
                            }
                        } else {
                            string3 = string3 + string4;
                        }
                        string3 = string3 + ")";
                    }
                    graphics.drawString(string3, PKEY_ICON.getIconWidth() + 6, n4);
                    if (n4 <= n2) continue;
                    graphics.setColor(this.getBorderColor());
                    int n16 = n - 4;
                    int n17 = n16 - 8;
                    int n18 = n16 - 4;
                    int n19 = n2 - 4;
                    n6 = n19 - 8;
                    int[] nArray = new int[]{n18, n17, n16};
                    int[] nArray3 = new int[]{n19, n6, n6};
                    graphics.fillPolygon(nArray, nArray3, 3);
                    break;
                }
            }
            if (object instanceof DPVRelational && (((DesignPartView)object).showAllDetails() || ((DesignPartView)object).showIndexes()) && (object4 = this.getIndexes(((ContainerWithKeyObject)this.container).getKeys())).size() > 0) {
                if (((DesignPartView)object).showAllDetails() || ((DesignPartView)object).showElements() || ((DesignPartView)object).showKeys()) {
                    graphics.setColor(this.getBorderColor());
                    graphics2D.setStroke(basicStroke);
                    n4 += n4 / 14;
                    graphics.drawLine(0, n4, n - 2, n4);
                }
                graphics2D.setStroke(basicStroke2);
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    designObject = (KeyObject)object3.next();
                    if (((KeyObject)designObject).isFK() || ((KeyObject)designObject).isPK() || ((KeyObject)designObject).isUnique()) continue;
                    int n20 = 4;
                    object2 = KEY_ICON;
                    graphics.setColor(this.getKeyColor());
                    graphics.setFont(this.getKeysFont());
                    fontMetrics = graphics.getFontMetrics();
                    n7 = -(object2.getIconHeight() + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2;
                    object2.paintIcon(this, graphics, n20, (n4 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent()) + n7 + 1);
                    String string6 = designObject.getName();
                    if ((((DesignPartView)object).showAllDetails() || ((DesignPartView)object).showKeyAndIndexColumns()) && (((DesignPartView)object).showAllDetails() || ((DesignPartView)object).showKeyAndIndexColumns())) {
                        Index index;
                        ContainedObject[] containedObjectArray = ((ContainerObject)designObject).getElements();
                        string6 = string6 + " (";
                        String string7 = null;
                        if (designObject instanceof Index && ALLOW_NULL.equals(string7 = (index = (Index)designObject).getIndexExpression())) {
                            string7 = null;
                        }
                        if (string7 == null) {
                            for (int i = 0; i < containedObjectArray.length; ++i) {
                                ContainedObject containedObject = containedObjectArray[i];
                                String string8 = containedObject.getName();
                                if (i > 0) {
                                    string6 = string6 + ", ";
                                }
                                string6 = string6 + string8;
                            }
                        } else {
                            string6 = string6 + string7;
                        }
                        string6 = string6 + ")";
                    }
                    graphics.drawString(string6, PKEY_ICON.getIconWidth() + 6, n4);
                    if (n4 <= n2) continue;
                    graphics.setColor(this.getBorderColor());
                    int n21 = n - 4;
                    int n22 = n21 - 8;
                    int n23 = n21 - 4;
                    int n24 = n2 - 4;
                    n6 = n24 - 8;
                    int[] nArray = new int[]{n23, n22, n21};
                    int[] nArray4 = new int[]{n24, n6, n6};
                    graphics.fillPolygon(nArray, nArray4, 3);
                    break;
                }
            }
        }
    }

    protected String getLongestName(ContainedObject[] containedObjectArray) {
        String string = ALLOW_NULL;
        for (int i = 0; i < containedObjectArray.length; ++i) {
            String string2 = containedObjectArray[i].getName();
            if (string2.length() <= string.length()) continue;
            string = string2;
        }
        return string;
    }

    protected String getLongestTypeName(TypeElement[] typeElementArray) {
        String string = ALLOW_NULL;
        for (int i = 0; i < typeElementArray.length; ++i) {
            String string2 = typeElementArray[i].getName();
            if (string2.length() <= string.length()) continue;
            string = string2;
        }
        return string;
    }

    protected boolean allKeysAreFK(KeyObject[] keyObjectArray) {
        boolean bl = true;
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (keyObjectArray[i].isFK()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected List getKeys(KeyObject[] keyObjectArray) {
        ArrayList<KeyObject> arrayList = new ArrayList<KeyObject>();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (!keyObjectArray[i].isPK() && !keyObjectArray[i].isUnique()) continue;
            arrayList.add(keyObjectArray[i]);
        }
        return arrayList;
    }

    protected List getIndexes(KeyObject[] keyObjectArray) {
        ArrayList<KeyObject> arrayList = new ArrayList<KeyObject>();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (keyObjectArray[i].isFK() || keyObjectArray[i].isPK() || keyObjectArray[i].isUnique()) continue;
            arrayList.add(keyObjectArray[i]);
        }
        return arrayList;
    }

    public Point2D getPerimeterPoint(ContainerView containerView, Point2D point2D, Point2D point2D2, boolean bl) {
        Rectangle2D rectangle2D = containerView.getBounds();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        double d5 = d + d3 / 2.0;
        double d6 = d2 + d4 / 2.0;
        double d7 = point2D2.getX() - d5;
        double d8 = point2D2.getY() - d6;
        double d9 = Math.atan2(d8, d7);
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = Math.PI;
        double d13 = Math.atan2(d4, d3);
        if (d9 < -d12 + d13 || d9 > d12 - d13) {
            d10 = d;
            d11 = d6;
        } else if (d9 < -d13) {
            d11 = d2;
            d10 = d5;
        } else if (d9 < d13) {
            d10 = d + d3;
            d11 = d6;
        } else {
            d11 = d2 + d4;
            d10 = d5;
        }
        return DiagramConstants.createPoint(d10, d11);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    protected DesignPartView getDesignPartView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView().getDesignPartView();
        }
        return null;
    }

    protected TopView getTopView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView();
        }
        if (this.container != null) {
            return this.container.getTopView();
        }
        return null;
    }

    public static String[] wrapText(String string, int n) {
        if (n > 0) {
            Pattern pattern = Pattern.compile("([\\S\\S&&[^\\p{Punct}]]{" + n + ",}|.{1," + n + "})(\\p{Punct}+|\\s+|$)");
            LinkedList<String> linkedList = new LinkedList<String>();
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                linkedList.add(matcher.group());
            }
            return linkedList.toArray(new String[linkedList.size()]);
        }
        return new String[]{string};
    }

    public static int getMaxChars(String string, FontMetrics fontMetrics, int n) {
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(0, i);
            int n2 = fontMetrics.stringWidth(string2);
            if (n2 <= n) continue;
            return i;
        }
        return string.length();
    }
}

