/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.datatypes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.datatypes.DTDRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class StructuredTypeRenderer
extends DTDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(140, 250, 220);
    public static final int MORE_ARROW_PADDING = 4;
    public static final int MORE_ARROW_WIDTH = 8;
    public static final int MORE_ARROW_HEIGHT = 8;
    public static final int TYPE_LEFT = 2;
    public static final int ELEMENT_LEFT = 13;
    public static final int DATATYPE_LEFT = 28;
    private transient Color datatypeColor;

    public StructuredTypeRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
        this.datatypeColor = new Color(0, 0, 160);
    }

    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.getDTObject().getDesign().getDLSettings().getDefaultFCObject("Structured Type");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor defaultFontAndColor = this.getDTObject().getDesign().getDLSettings().getDefaultFCObject("Structured Type");
            if (defaultFontAndColor != null) {
                return defaultFontAndColor.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    public Color getBorderColor() {
        return this.getForegroundColor();
    }

    @Override
    public void paint(Graphics graphics) {
        Object object;
        Object object2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        EditableFonts editableFonts = (EditableFonts)((Object)this.getDTObject());
        graphics2D.setPaint(this.getBackgroundColor());
        graphics.fillRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(this.getForegroundColor());
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        Font font = editableFonts.getFontObject(EditableFonts.FO_TITLE).getFont();
        float f = font.getSize2D();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
        int n4 = Math.max(n3, font.getSize());
        int n5 = (n - fontMetrics.stringWidth(this.title)) / 2;
        if (n5 < 20) {
            n5 = 20;
        }
        if (!((StructuredType)this.getDTObject()).isInstantiable()) {
            graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_NOT_INSTANTIABLE).getFont().deriveFont(f));
            graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_NOT_INSTANTIABLE).getColor());
            object2 = "NI";
            graphics.drawString((String)object2, 2, n4);
            int n6 = 2 + fontMetrics.stringWidth((String)object2);
            if (n5 <= n6) {
                n5 = n6 + 1;
            }
            graphics.setColor(this.getForeground());
        }
        object2 = new BasicStroke(1.0f);
        graphics2D.setStroke((Stroke)object2);
        graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_TITLE).getColor());
        graphics.setFont(font);
        String[] stringArray = ContainerRenderer.wrapText(this.title, ContainerRenderer.getMaxChars(this.title, fontMetrics, n - 20 - 5));
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            graphics.drawString((String)object, n5, n4);
            n4 += n3;
        }
        n4 -= n3;
        DesignPartView designPartView = this.getDesignPartView();
        if (designPartView != null && !designPartView.clearDetails() && !designPartView.isShowNamesOnly()) {
            int n7;
            DesignObject[] designObjectArray;
            object = new BasicStroke(this.borderWidth);
            graphics2D.setStroke((Stroke)object);
            graphics.setColor(this.getBorderColor());
            graphics.drawLine(0, n4 += 3 + this.borderWidth, n - 2, n4);
            graphics.setColor(this.getForeground());
            graphics2D.setStroke((Stroke)object2);
            if (designPartView.showAllDetails() || designPartView.showElements()) {
                designObjectArray = ((StructuredType)this.getDTObject()).getElements();
                String string = this.getLongestName((TypeElement[])designObjectArray);
                f = editableFonts.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().getSize2D();
                f = Math.max(f, editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getFont().getSize2D());
                graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().deriveFont(f));
                fontMetrics = graphics.getFontMetrics();
                n3 = fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() + 3;
                for (n7 = 0; n7 < designObjectArray.length; ++n7) {
                    DesignObject designObject = designObjectArray[n7];
                    n4 += 3 + fontMetrics.getMaxAscent();
                    graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_MANDATORY).getFont().deriveFont(f));
                    graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_MANDATORY).getColor());
                    String string2 = " ";
                    if (((TypeElement)designObject).isMandatory()) {
                        string2 = "M";
                    }
                    fontMetrics = graphics.getFontMetrics();
                    int n8 = fontMetrics.stringWidth("M") + 3;
                    graphics.drawString(string2, 2, n4);
                    graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont().deriveFont(f));
                    graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_ATTRIBUTE).getColor());
                    graphics.drawString(designObject.getName(), n8, n4);
                    graphics.setColor(this.datatypeColor);
                    if (!designPartView.showAllDetails() && !designPartView.showDatatype()) continue;
                    fontMetrics = graphics.getFontMetrics();
                    graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getFont().deriveFont(f));
                    graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                    graphics.drawString(((TypeElement)designObject).getDataType(), n8 += fontMetrics.stringWidth(string) + 20, n4);
                    graphics.setColor(this.getForeground());
                }
            }
            if ((designPartView.showAllDetails() || designPartView.showKeys()) && (designObjectArray = ((StructuredType)this.getDTObject()).getMethods()).length > 0) {
                if ((designPartView.showAllDetails() || designPartView.showElements()) && ((StructuredType)this.getDTObject()).getElements().length > 0) {
                    graphics.setColor(this.getBorderColor());
                    graphics2D.setStroke((Stroke)object);
                    n4 += n4 / 14;
                    graphics.drawLine(0, n4, n - 2, n4);
                }
                for (int i = 0; i < designObjectArray.length; ++i) {
                    graphics.setFont(editableFonts.getFontObject(EditableFonts.FO_METHOD).getFont());
                    graphics.setColor(editableFonts.getFontObject(EditableFonts.FO_METHOD).getColor());
                    fontMetrics = graphics.getFontMetrics();
                    DesignObject designObject = designObjectArray[i];
                    graphics.drawString(designObject.getName(), 13, n4 += fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent());
                }
            }
            if (n4 > n2) {
                graphics.setColor(this.getForegroundColor());
                int n9 = n - 4;
                int n10 = n9 - 8;
                n7 = n9 - 4;
                int n11 = n2 - 4;
                int n12 = n11 - 8;
                int[] nArray = new int[]{n7, n10, n9};
                int[] nArray2 = new int[]{n11, n12, n12};
                graphics.fillPolygon(nArray, nArray2, 3);
            }
        }
    }

    protected DesignPartView getDesignPartView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView().getDesignPartView();
        }
        return null;
    }

    private String getLongestName(TypeElement[] typeElementArray) {
        String string = "";
        for (int i = 0; i < typeElementArray.length; ++i) {
            String string2 = typeElementArray[i].getName();
            if (string2.length() <= string.length()) continue;
            string = string2;
        }
        return string;
    }
}

