/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.datatypes;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;

public class ReferenceEdge
extends DefaultEdge {
    private JPopupMenu menu;
    private boolean hasSourceLabel = false;
    private String mand_sourceLabel = "1..*";
    private String nm_sourceLabel = "0..*";
    private JMenuItem miStraightLine = null;
    private JMenuItem miAddBP = null;
    private JMenuItem miRemoveBP = null;
    private Point point = new Point();

    private void showProperty() {
        this.getReference().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point point) {
        this.point.setLocation(point);
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.show(this.getDiagram(), point.x, point.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            DTReference dTReference = this.getReference();
            TypeElement typeElement = dTReference.getTypeElement();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ReferenceEdge.this.deleteReference();
                    }
                });
                this.menu.addSeparator();
                this.miStraightLine = this.menu.add(new AbstractAction(STRAIGHT_LINE){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ReferenceEdge.this.straightenLine();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ReferenceEdge.this.format();
                    }
                });
                this.menu.addSeparator();
                this.miAddBP = this.menu.add(new AbstractAction(ADD_BREAKPOINT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ReferenceEdge.this.addBreakpoint(ReferenceEdge.this.point);
                    }
                });
                this.miRemoveBP = this.menu.add(new AbstractAction(REMOVE_BREAKPOINT){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ReferenceEdge.this.removeBreakpoint(ReferenceEdge.this.point);
                    }
                });
            }
            if (typeElement != null) {
                if (this.isEditable()) {
                    this.menu.addSeparator();
                }
                this.menu.add(new TEAction(MessageFormat.format(Messages.getString("ReferenceEdge.PropertiesOf"), typeElement.getName()), typeElement));
            }
        }
        if (this.miStraightLine != null) {
            this.miStraightLine.setEnabled(!this.getTopView().getDesignPartView().isAutoRoute() && this.onlyEdgesAreSelected());
        }
        if (this.miAddBP != null && this.miRemoveBP != null) {
            if (this.getTopView().getDesignPartView().isAutoRoute()) {
                this.miAddBP.setEnabled(false);
                this.miRemoveBP.setEnabled(false);
            } else {
                boolean bl = this.hasBreakpointAt(this.point);
                this.miAddBP.setEnabled(!bl);
                this.miRemoveBP.setEnabled(bl);
            }
        }
        return this.menu;
    }

    public DTReference getReference() {
        return (DTReference)this.getTopView().getModel();
    }

    public void deleteReference() {
        DTReference dTReference = this.getReference();
        TVConnector tVConnector = (TVConnector)this.getTopView();
        if (tVConnector.remove(dTReference)) {
            ApplicationView.log(MessageFormat.format(Messages.getString("ReferenceEdge.RemoveReference"), dTReference.getName()));
        }
    }

    @Override
    public void deleteSelected() {
        this.deleteReference();
    }

    public boolean isHasSourceLabel() {
        return this.hasSourceLabel;
    }

    public void setHasSourceLabel(boolean bl) {
        this.hasSourceLabel = bl;
    }

    public String getSourceLabel() {
        TypeElement typeElement;
        DTReference dTReference = this.getReference();
        if (dTReference != null && (typeElement = dTReference.getTypeElement()) != null && typeElement.isMandatory()) {
            return this.mand_sourceLabel;
        }
        return this.nm_sourceLabel;
    }

    public void setSourceLabel(String string) {
        this.mand_sourceLabel = string;
    }

    class TEAction
    extends AbstractAction {
        private TypeElement te;

        TEAction(String string, TypeElement typeElement) {
            super(string);
            this.te = typeElement;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.te.showPropertyDialog();
        }
    }
}

