/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.tree.MutableTreeNode;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.OverviewPanel;
import oracle.dbtools.crest.swingui.diagram.datatypes.DTDiagramCell;
import oracle.dbtools.crest.swingui.diagram.datatypes.InheritanceEdge;
import oracle.dbtools.crest.swingui.diagram.datatypes.ReferenceEdge;
import oracle.dbtools.crest.swingui.diagram.datatypes.StructuredTypeDiagramCell;
import oracle.dbtools.crest.swingui.diagram.datatypes.StructuredTypeView;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionListener;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.AttributeMap;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultPort;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewView;
import oracle.dbtools.crest.swingui.diagram.graph.Edge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.LabelDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.LabelView;
import oracle.dbtools.crest.swingui.diagram.graph.LegendDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.LegendView;
import oracle.dbtools.crest.swingui.diagram.graph.MarqueeHandler;
import oracle.dbtools.crest.swingui.diagram.graph.NoteDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.NoteView;
import oracle.dbtools.crest.swingui.diagram.graph.Port;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.diagram.graph.TypeSubstitutionEdge;
import oracle.dbtools.crest.swingui.diagram.logical.ArcDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.ArcView;
import oracle.dbtools.crest.swingui.diagram.logical.EntityDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityView;
import oracle.dbtools.crest.swingui.diagram.logical.EntityViewDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityViewView;
import oracle.dbtools.crest.swingui.diagram.logical.RelationEdge;
import oracle.dbtools.crest.swingui.diagram.multidimensional.CubeDiagramCell;
import oracle.dbtools.crest.swingui.diagram.multidimensional.CubeView;
import oracle.dbtools.crest.swingui.diagram.multidimensional.DimensionDiagramCell;
import oracle.dbtools.crest.swingui.diagram.multidimensional.DimensionView;
import oracle.dbtools.crest.swingui.diagram.multidimensional.LevelDiagramCell;
import oracle.dbtools.crest.swingui.diagram.multidimensional.LevelView;
import oracle.dbtools.crest.swingui.diagram.multidimensional.LinkEdge;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDiagramCell;
import oracle.dbtools.crest.swingui.diagram.multidimensional.RaggedHLinkEdge;
import oracle.dbtools.crest.swingui.diagram.process.AgentDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.AgentView;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.FlowEdge;
import oracle.dbtools.crest.swingui.diagram.process.InOutParamsDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.InOutParamsView;
import oracle.dbtools.crest.swingui.diagram.process.ProcessDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.ProcessView;
import oracle.dbtools.crest.swingui.diagram.process.StoreDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.StoreView;
import oracle.dbtools.crest.swingui.diagram.process.TransformationDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.TransformationView;
import oracle.dbtools.crest.swingui.diagram.relational.FKArcDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.FKArcView;
import oracle.dbtools.crest.swingui.diagram.relational.FKEdge;
import oracle.dbtools.crest.swingui.diagram.relational.TableDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.TableView;
import oracle.dbtools.crest.swingui.diagram.relational.TableViewDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.TableViewView;
import oracle.dbtools.crest.swingui.logical.DPVLogical;

public class Diagram
extends AbstractDiagram {
    public static final int DEFAULT_CONTAINER_WIDTH = 170;
    public static final int DEFAULT_CONTAINER_HEIGHT = 110;
    public static final int DEFAULT_NOTE_WIDTH = 95;
    public static final int DEFAULT_NOTE_HEIGHT = 40;
    public static final int DEFAULT_PROCESS_WIDTH = 130;
    public static final int DEFAULT_PROCESS_HEIGHT = 90;
    public static final int DEFAULT_AGENT_WIDTH = 80;
    public static final int DEFAULT_AGENT_HEIGHT = 80;
    public static final int DEFAULT_STORE_WIDTH = 140;
    public static final int DEFAULT_STORE_HEIGHT = 30;
    public static final int DEFAULT_CUBE_SIZE = 80;
    public static final int DEFAULT_LEVEL_WIDTH = 80;
    public static final int DEFAULT_LEVEL_HEIGHT = 30;
    public static final int DEFAULT_DIMENSION_WIDTH = 80;
    public static final int DEFAULT_DIMENSION_HEIGHT = 30;
    public static final int DEFAULT_STRUCTURED_TYPE_WIDTH = 170;
    public static final int DEFAULT_STRUCTURED_TYPE_HEIGHT = 110;
    public static final Color DEFAULT_BORDER_COLOR = Color.BLUE;
    public static final int DEFAULT_DIAGRAM_VIEW_WIDTH = 140;
    public static final int DEFAULT_DIAGRAM_VIEW_HEIGHT = 100;
    public static final double ZOOM_FACTOR = 1.3;
    public static final Font DEFAULT_FONT = new Font("Dialog", 0, 10);
    public static final Cursor DELETE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(GUIConfiguration.getInstance().getImage("CR_DELETE"), new Point(1, 1), "DELETE_CURSOR");
    public static final Cursor LINE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(GUIConfiguration.getInstance().getImage("CR_LINE"), new Point(1, 1), "LINE_CURSOR");
    public static final Cursor MERGE_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(GUIConfiguration.getInstance().getImage("CR_MERGE"), new Point(1, 1), "MERGE_CURSOR");
    public static final Cursor DRAG_YES_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(GUIConfiguration.getInstance().getImage("CR_DRAG_YES"), new Point(1, 1), "DRAG_YES_CURSOR");
    public static final Cursor DRAG_NO_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(GUIConfiguration.getInstance().getImage("CR_DRAG_NO"), new Point(1, 1), "DRAG_NO_CURSOR");
    public static final int DRAWN_OBJECT_NONE = -1;
    public static final int DRAWN_OBJECT_ENTITY = 0;
    public static final int DRAWN_OBJECT_RELATION = 1;
    public static final int DRAWN_OBJECT_TABLE = 2;
    public static final int DRAWN_OBJECT_FK = 3;
    public static final int DRAWN_OBJECT_VIEW = 4;
    public static final int DRAWN_OBJECT_TEXT = 5;
    public static final int DELETE_OBJECT = 6;
    public static final int DRAWN_OBJECT_PROCESS = 7;
    public static final int DRAWN_OBJECT_AGENT = 8;
    public static final int DRAWN_OBJECT_STORE = 9;
    public static final int DRAWN_OBJECT_FLOW = 10;
    public static final int DRAWN_OBJECT_CUBE = 11;
    public static final int DRAWN_OBJECT_LEVEL = 12;
    public static final int DRAWN_OBJECT_DIMENSION = 13;
    public static final int DRAWN_OBJECT_LINK = 14;
    public static final int DRAWN_OBJECT_TRANSFORMATION = 15;
    public static final int DRAWN_OBJECT_RAGEDH_LINK = 16;
    public static final int DRAWN_OBJECT_STRUCTURED_TYPE = 17;
    public static final int DRAWN_OBJECT_TYPE_SUBSTITUTION = 18;
    public static final int DRAWN_OBJECT_ENTIY_VIEW = 19;
    public static final int DRAWN_OBJECT_UDCLASS = 20;
    public static final int DRAWN_OBJECT_UDCOMPOSITION = 21;
    public static final int DRAWN_OBJECT_UDASSOCIATION = 22;
    public static final int DRAWN_OBJECT_PDCLASS = 23;
    public static final int DRAWN_OBJECT_ARC = 24;
    public static final int BACHMAN_NOTATION = 0;
    public static final int BARKER_NOTATION = 1;
    public static final int IE_NOTATION = 2;
    private JScrollPane scrollPane;
    private String name;
    private JPanel overview;
    private ApplicationView appView;
    private int drawnObjectID = -1;
    private MDBAction currentAction;
    private DesignPartView dpv;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_TOP = 1;
    public static final int EQUAL_WIDTH = 3;
    public static final int EQUAL_HEIGHT = 4;

    public Diagram(ApplicationView applicationView, DesignPartView designPartView) {
        super(new DefaultDiagramModel());
        this.appView = applicationView;
        this.dpv = designPartView;
        this.setMarqueeHandler(new MarqueeHandler(this));
        this.setGridEnabled(true);
        this.setGridVisible(designPartView.showGrid());
        this.setGridSize(applicationView.getSettings().getGridSize());
        if (applicationView != null) {
            this.setBackground(designPartView.getDiagramColor());
        }
        this.setHandleColor(Color.BLUE);
        this.setEditable(false);
        this.setAntiAliased(true);
        this.setGridColor(Color.GRAY);
        if (this.isRestricted()) {
            this.setMoveable(false);
            this.setSizeable(false);
        }
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setFont(DEFAULT_FONT);
        this.createOverview();
        this.setCursor(Cursor.getPredefinedCursor(0));
        if ((designPartView.getDesignPart() instanceof RelationalDesign || designPartView.getDesignPart() instanceof DataTypesDesign) && applicationView != null && applicationView.getDropTargetListener() != null) {
            this.setDropTarget(new DropTarget(this, 0x40000003, applicationView.getDropTargetListener(), true));
        }
    }

    public static Object[] getNotations() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Bachman");
        arrayList.add("Barker");
        return arrayList.toArray();
    }

    public void updateReadOnlyStatus() {
        this.setMoveable(!this.isRestricted());
        this.setSizeable(!this.isRestricted());
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        if (this.dpv != null) {
            this.dpv.getGlassPane().setCursor(cursor);
        }
    }

    public boolean canAlign() {
        int n = 0;
        Object[] objectArray = this.getSelectionCells();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof DefaultDiagramCell) || object instanceof DefaultEdge) continue;
            ++n;
        }
        return n > 1;
    }

    public void alignSelected(int n) {
        Object[] objectArray = this.getSelectionCells();
        int n2 = -1;
        block6: for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof DefaultDiagramCell) || object instanceof DefaultEdge) continue;
            switch (n) {
                case 0: {
                    if (n2 == -1) {
                        n2 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().x;
                        continue block6;
                    }
                    int n3 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().y;
                    int n4 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().width;
                    int n5 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().height;
                    ((DefaultDiagramCell)object).getCellView().setNewBounds(new Rectangle(n2, n3, n4, n5));
                    continue block6;
                }
                case 1: {
                    if (n2 == -1) {
                        n2 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().y;
                        continue block6;
                    }
                    int n3 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().x;
                    int n4 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().width;
                    int n5 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().height;
                    ((DefaultDiagramCell)object).getCellView().setNewBounds(new Rectangle(n3, n2, n4, n5));
                    continue block6;
                }
                case 3: {
                    if (n2 == -1) {
                        n2 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().width;
                        continue block6;
                    }
                    int n3 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().x;
                    int n4 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().y;
                    int n5 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().height;
                    ((DefaultDiagramCell)object).getCellView().setNewBounds(new Rectangle(n3, n4, n2, n5));
                    continue block6;
                }
                case 4: {
                    if (n2 == -1) {
                        n2 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().height;
                        continue block6;
                    }
                    int n3 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().x;
                    int n4 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().y;
                    int n5 = ((DefaultDiagramCell)object).getCellView().getBounds().getBounds().width;
                    ((DefaultDiagramCell)object).getCellView().setNewBounds(new Rectangle(n3, n4, n5, n2));
                }
            }
        }
    }

    private boolean isRestricted() {
        if (this.dpv != null && this.dpv.isReadOnly()) {
            return true;
        }
        if (ApplicationView.IS_VIEWER && !this.dpv.getDesign().isNewDesign()) {
            return true;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            return !(this.dpv instanceof DPVLogical);
        }
        return false;
    }

    public void deleteSelected() {
        if (!this.isRestricted()) {
            Object[] objectArray = this.getSelectionCells();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof DefaultDiagramCell)) continue;
                ((DefaultDiagramCell)object).deleteSelected();
            }
        } else if (ApplicationView.LOGICAL_MODEL_ONLY) {
            // empty if block
        }
    }

    public void deleteAllSelected() {
        if (!this.isRestricted()) {
            Object[] objectArray = this.getDesignPartView().getSelectedObjects();
            if (objectArray.length == 1) {
                this.deleteSelected();
            } else if (objectArray.length > 1) {
                DefaultDiagramCell.deleteObjects(objectArray, this.getAppView());
            }
        }
    }

    public void SendAllLinesToBack() {
        this.getDiagramLayoutCache().toBack(this.getEdges());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSettings() {
        TVConnector.updateSettings = true;
        boolean bl = false;
        try {
            Cloneable cloneable;
            AttributeMap attributeMap;
            Object[] objectArray = this.getEdges();
            if (this.dpv != null) {
                this.setGridVisible(this.dpv.showGrid());
                this.setGridSize(this.appView.getSettings().getGridSize());
                this.setBackground(this.dpv.getDiagramColor());
                bl = this.dpv.isAutoRoute();
            }
            if (bl) {
                attributeMap = new AttributeMap();
                DiagramConstants.setRouting(attributeMap, DiagramConstants.ROUTING_SIMPLE);
                DiagramConstants.setRemoveAttributes(attributeMap, new Object[]{"points"});
                this.setSelectionAttributes(attributeMap, this.getEdges());
            } else {
                List list;
                attributeMap = new AttributeMap();
                cloneable = new HashMap<DefaultEdge, List>();
                for (int i = 0; i < objectArray.length; ++i) {
                    DefaultEdge defaultEdge = (DefaultEdge)objectArray[i];
                    list = ((EdgeView)defaultEdge.getTopView().getCellView()).getPoints();
                    list = this.clonePoints(list);
                    cloneable.put(defaultEdge, list);
                }
                DiagramConstants.setRemoveAttributes(attributeMap, new Object[]{"routing", "points"});
                this.setSelectionAttributes(attributeMap, objectArray);
                for (DefaultEdge defaultEdge : cloneable.keySet()) {
                    list = (List)cloneable.get(defaultEdge);
                    this.addPoints(defaultEdge, list, true);
                    defaultEdge.getCellView().update();
                    if (!this.dpv.showLabels()) continue;
                    ((EdgeView)defaultEdge.getTopView().getCellView()).refreshLabels();
                }
            }
            this.getDiagramLayoutCache().reload();
            this.getDiagramLayoutCache().toBack(objectArray);
            if (this.dpv != null && this.dpv.getDesignPart() instanceof LogicalDesign) {
                ((LogicalDesign)this.dpv.getDesignPart()).fixBoxInBox(this.dpv);
            }
            this.repaint();
            for (int i = 0; i < objectArray.length; ++i) {
                cloneable = (DefaultEdge)objectArray[i];
                ((EdgeView)((DefaultDiagramCell)cloneable).getCellView()).update();
            }
        }
        finally {
            TVConnector.updateSettings = false;
        }
    }

    private List clonePoints(List list) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        for (Object e : list) {
            Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
            Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
            arrayList.add(double_);
        }
        return arrayList;
    }

    public Object[] getEdges() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            Object object = cellViewArray[i].getCell();
            if (!(object instanceof DefaultEdge) || ((EdgeView)((DefaultEdge)object).getCellView()).isSelfReference()) continue;
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    public Object[] getEdgesUnder(Rectangle2D rectangle2D) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            Object object = cellViewArray[i].getCell();
            if (!(object instanceof DefaultEdge) && !(object instanceof FKArcDiagramCell) && !(object instanceof ArcDiagramCell) || !rectangle2D.intersects(((DefaultDiagramCell)object).getCellView().getBounds())) continue;
            arrayList.add(object);
        }
        return arrayList.toArray();
    }

    public void setSelectionAttributes(Map hashtable, Object[] objectArray) {
        hashtable = new Hashtable(hashtable);
        hashtable.remove("bounds");
        hashtable.remove("points");
        this.editCells(this, objectArray, hashtable);
    }

    public void editCells(AbstractDiagram abstractDiagram, Object[] objectArray, Map map) {
        if (abstractDiagram != null && map != null && objectArray != null && objectArray.length > 0) {
            Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
            for (int i = 0; i < objectArray.length; ++i) {
                hashtable.put(objectArray[i], map);
            }
            abstractDiagram.getDiagramLayoutCache().edit(hashtable, null, null, null);
        }
    }

    @Override
    protected AbstractCellView createVertexView(AbstractDiagram abstractDiagram, CellMapper cellMapper, Object object) {
        if (object instanceof EntityDiagramCell) {
            return new EntityView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof EntityViewDiagramCell) {
            return new EntityViewView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof TableDiagramCell) {
            return new TableView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof TableViewDiagramCell) {
            return new TableViewView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof NoteDiagramCell) {
            return new NoteView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof LegendDiagramCell) {
            return new LegendView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof LabelDiagramCell) {
            return new LabelView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof ProcessDiagramCell) {
            return new ProcessView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof TransformationDiagramCell) {
            return new TransformationView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof AgentDiagramCell) {
            return new AgentView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof StoreDiagramCell) {
            return new StoreView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof InOutParamsDiagramCell) {
            return new InOutParamsView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof CubeDiagramCell) {
            return new CubeView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof LevelDiagramCell) {
            return new LevelView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof DimensionDiagramCell) {
            return new DimensionView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof StructuredTypeDiagramCell) {
            return new StructuredTypeView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof ArcDiagramCell) {
            return new ArcView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof FKArcDiagramCell) {
            return new FKArcView(object, abstractDiagram, cellMapper);
        }
        if (object instanceof DiagramViewDiagramCell) {
            return new DiagramViewView(object, abstractDiagram, cellMapper);
        }
        return new ContainerView(object, abstractDiagram, cellMapper);
    }

    private void createOverview() {
        this.overview = OverviewPanel.createOverviewPanel(this, this.getScrollPane().getViewport());
    }

    public JPanel getNavigatorPanel() {
        return this.overview;
    }

    public DefaultDiagramCell addEntity(Entity entity, Rectangle rectangle) {
        EntityDiagramCell entityDiagramCell = new EntityDiagramCell(entity);
        this.addContainer(entityDiagramCell, rectangle);
        return entityDiagramCell;
    }

    public DefaultDiagramCell addArc(Arc arc, Rectangle rectangle) {
        ArcDiagramCell arcDiagramCell = new ArcDiagramCell(arc);
        this.addContainer(arcDiagramCell, rectangle);
        this.getDiagramLayoutCache().toBack(new Object[]{arcDiagramCell});
        return arcDiagramCell;
    }

    public DefaultDiagramCell addFKArc(FKArc fKArc, Rectangle rectangle) {
        FKArcDiagramCell fKArcDiagramCell = new FKArcDiagramCell(fKArc);
        this.addContainer(fKArcDiagramCell, rectangle);
        this.getDiagramLayoutCache().toBack(new Object[]{fKArcDiagramCell});
        return fKArcDiagramCell;
    }

    public DefaultDiagramCell addTable(Table table, Rectangle rectangle) {
        TableDiagramCell tableDiagramCell = new TableDiagramCell(table);
        this.addContainer(tableDiagramCell, rectangle);
        return tableDiagramCell;
    }

    public DefaultDiagramCell addTableView(oracle.dbtools.crest.model.design.relational.TableView tableView, Rectangle rectangle) {
        TableViewDiagramCell tableViewDiagramCell = new TableViewDiagramCell(tableView);
        this.addContainer(tableViewDiagramCell, rectangle);
        return tableViewDiagramCell;
    }

    public DefaultDiagramCell addEntityView(oracle.dbtools.crest.model.design.logical.EntityView entityView, Rectangle rectangle) {
        EntityViewDiagramCell entityViewDiagramCell = new EntityViewDiagramCell(entityView);
        this.addContainer(entityViewDiagramCell, rectangle);
        return entityViewDiagramCell;
    }

    public DefaultDiagramCell addNote(Note note, Rectangle rectangle) {
        NoteDiagramCell noteDiagramCell = new NoteDiagramCell(note);
        if (rectangle.width == 0) {
            rectangle.width = 95;
        }
        if (rectangle.height == 0) {
            rectangle.height = 40;
        }
        this.addContainer(noteDiagramCell, rectangle);
        return noteDiagramCell;
    }

    public DefaultDiagramCell addLegend(Legend legend, Rectangle rectangle) {
        LegendDiagramCell legendDiagramCell = new LegendDiagramCell(legend);
        if (rectangle.width == 0) {
            rectangle.width = 170;
        }
        if (rectangle.height == 0) {
            rectangle.height = 110;
        }
        this.addContainer(legendDiagramCell, rectangle);
        return legendDiagramCell;
    }

    public DefaultDiagramCell addLabel(Label label, Rectangle rectangle) {
        LabelDiagramCell labelDiagramCell = new LabelDiagramCell(label);
        if (rectangle.width == 0) {
            rectangle.width = 95;
        }
        if (rectangle.height == 0) {
            rectangle.height = 40;
        }
        this.addContainer(labelDiagramCell, rectangle);
        return labelDiagramCell;
    }

    public DefaultDiagramCell addDiagramView(DiagramView diagramView, Rectangle rectangle) {
        DiagramViewDiagramCell diagramViewDiagramCell = new DiagramViewDiagramCell(diagramView);
        if (rectangle.width == 0) {
            rectangle.width = 140;
        }
        if (rectangle.height == 0) {
            rectangle.height = 100;
        }
        this.addContainer(diagramViewDiagramCell, rectangle);
        return diagramViewDiagramCell;
    }

    public DefaultDiagramCell addProcess(Process process, Rectangle rectangle) {
        ProcessDiagramCell processDiagramCell = new ProcessDiagramCell(process);
        this.addContainer(processDiagramCell, rectangle);
        return processDiagramCell;
    }

    public DefaultDiagramCell addTransformation(Transformation transformation, Rectangle rectangle) {
        TransformationDiagramCell transformationDiagramCell = new TransformationDiagramCell(transformation);
        this.addContainer(transformationDiagramCell, rectangle);
        return transformationDiagramCell;
    }

    public DefaultDiagramCell addAgent(ExternalAgent externalAgent, Rectangle rectangle) {
        AgentDiagramCell agentDiagramCell = new AgentDiagramCell(externalAgent);
        this.addContainer(agentDiagramCell, rectangle);
        return agentDiagramCell;
    }

    public DefaultDiagramCell addStore(InfoStore infoStore, Rectangle rectangle) {
        StoreDiagramCell storeDiagramCell = new StoreDiagramCell(infoStore);
        this.addContainer(storeDiagramCell, rectangle);
        return storeDiagramCell;
    }

    public DefaultDiagramCell addInOutParams(InOutParams inOutParams, Rectangle rectangle) {
        InOutParamsDiagramCell inOutParamsDiagramCell = new InOutParamsDiagramCell(inOutParams);
        this.addContainer(inOutParamsDiagramCell, rectangle);
        return inOutParamsDiagramCell;
    }

    public DefaultDiagramCell addCube(Cube cube, Rectangle rectangle) {
        CubeDiagramCell cubeDiagramCell = new CubeDiagramCell(cube);
        this.addContainer(cubeDiagramCell, rectangle);
        return cubeDiagramCell;
    }

    public DefaultDiagramCell addLevel(Level level, Rectangle rectangle) {
        LevelDiagramCell levelDiagramCell = new LevelDiagramCell(level);
        this.addContainer(levelDiagramCell, rectangle);
        return levelDiagramCell;
    }

    public DefaultDiagramCell addDimension(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension, Rectangle rectangle) {
        DimensionDiagramCell dimensionDiagramCell = new DimensionDiagramCell(dimension);
        this.addContainer(dimensionDiagramCell, rectangle);
        return dimensionDiagramCell;
    }

    public DefaultDiagramCell addStructuredType(StructuredType structuredType, Rectangle rectangle) {
        StructuredTypeDiagramCell structuredTypeDiagramCell = new StructuredTypeDiagramCell(structuredType);
        this.addContainer(structuredTypeDiagramCell, rectangle);
        return structuredTypeDiagramCell;
    }

    public void addContainer(DefaultDiagramCell defaultDiagramCell, Rectangle rectangle) {
        if (rectangle.width == 0) {
            rectangle.width = 170;
        }
        if (rectangle.height == 0) {
            rectangle.height = 110;
        }
        Hashtable<DefaultDiagramCell, Map> hashtable = new Hashtable<DefaultDiagramCell, Map>();
        Map map = DiagramConstants.createMap();
        hashtable.put(defaultDiagramCell, map);
        DiagramConstants.setBounds(map, rectangle);
        DiagramConstants.setOpaque(map, true);
        DiagramConstants.setBorderColor(map, DEFAULT_BORDER_COLOR);
        Object[] objectArray = new Object[]{defaultDiagramCell};
        this.getModel().insert(objectArray, hashtable, null, null, null);
    }

    public void removeContainer(ContainerObject containerObject) {
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            ContainerDiagramCell containerDiagramCell;
            Object object = cellViewArray[i].getCell();
            if (!(object instanceof ContainerDiagramCell) || !containerObject.equals((containerDiagramCell = (ContainerDiagramCell)object).getContainer())) continue;
            Object[] objectArray = new Object[]{containerDiagramCell};
            this.removeCells(objectArray);
        }
    }

    public void alignDiagram() {
        int n;
        int n2;
        AbstractCellView abstractCellView;
        int n3;
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        for (n3 = 0; n3 < cellViewArray.length; ++n3) {
            abstractCellView = (AbstractCellView)cellViewArray[n3];
            if (abstractCellView instanceof EdgeView) continue;
            n2 = abstractCellView.getBounds().getBounds().x;
            n = abstractCellView.getBounds().getBounds().y;
            n4 = Math.min(n4, n2);
            n5 = Math.min(n5, n);
        }
        for (n3 = 0; n3 < cellViewArray.length; ++n3) {
            abstractCellView = (AbstractCellView)cellViewArray[n3];
            if (abstractCellView instanceof EdgeView) continue;
            n2 = abstractCellView.getBounds().getBounds().x - n4 + 20;
            n = abstractCellView.getBounds().getBounds().y - n5 + 20;
            int n6 = abstractCellView.getBounds().getBounds().width;
            int n7 = abstractCellView.getBounds().getBounds().height;
            abstractCellView.setNewBounds(new Rectangle(n2, n, n6, n7));
        }
    }

    public Rectangle2D getDiagramBounds() {
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        if (cellViewArray != null && cellViewArray.length > 0) {
            Rectangle2D rectangle2D = cellViewArray[0].getBounds();
            Rectangle2D.Double double_ = rectangle2D != null ? new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()) : new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            for (int i = 1; i < cellViewArray.length; ++i) {
                Rectangle2D rectangle2D2 = cellViewArray[i].getBounds();
                if (rectangle2D2 == null) continue;
                Rectangle2D.union(double_, rectangle2D2, double_);
            }
            return double_;
        }
        return null;
    }

    public void selectAll() {
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            Object object = cellViewArray[i].getCell();
            arrayList.add(object);
        }
        this.setSelectionCells(arrayList.toArray());
    }

    public void removeProcessObject(AbstractProcessObject abstractProcessObject) {
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            DFDiagramCell dFDiagramCell;
            Object object = cellViewArray[i].getCell();
            if (!(object instanceof DFDiagramCell) || !abstractProcessObject.equals((dFDiagramCell = (DFDiagramCell)object).getProcessObject())) continue;
            Object[] objectArray = new Object[]{dFDiagramCell};
            this.removeCells(objectArray);
        }
    }

    public void removeMDObject(AbstractMDObject abstractMDObject) {
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            MDDiagramCell mDDiagramCell;
            Object object = cellViewArray[i].getCell();
            if (!(object instanceof MDDiagramCell) || !abstractMDObject.equals((mDDiagramCell = (MDDiagramCell)object).getMDObject())) continue;
            Object[] objectArray = new Object[]{mDDiagramCell};
            this.removeCells(objectArray);
        }
    }

    public void removeDTObject(AbstractDTObject abstractDTObject) {
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            DTDiagramCell dTDiagramCell;
            Object object = cellViewArray[i].getCell();
            if (!(object instanceof DTDiagramCell) || !abstractDTObject.equals((dTDiagramCell = (DTDiagramCell)object).getDTObject())) continue;
            Object[] objectArray = new Object[]{dTDiagramCell};
            this.removeCells(objectArray);
        }
    }

    public void removeArc(Arc arc) {
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            ArcDiagramCell arcDiagramCell;
            Object object = cellViewArray[i].getCell();
            if (!(object instanceof ArcDiagramCell) || !arc.equals((arcDiagramCell = (ArcDiagramCell)object).getArc())) continue;
            Object[] objectArray = new Object[]{arcDiagramCell};
            this.removeCells(objectArray);
        }
    }

    public void removeFKArc(FKArc fKArc) {
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            FKArcDiagramCell fKArcDiagramCell;
            Object object = cellViewArray[i].getCell();
            if (!(object instanceof FKArcDiagramCell) || !fKArc.equals((fKArcDiagramCell = (FKArcDiagramCell)object).getArc())) continue;
            Object[] objectArray = new Object[]{fKArcDiagramCell};
            this.removeCells(objectArray);
        }
    }

    public void removeCells(Object[] objectArray) {
        objectArray = this.getDescendants(objectArray);
        this.getModel().remove(objectArray);
    }

    public void removeNote(Note note) {
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            NoteDiagramCell noteDiagramCell;
            Object object = cellViewArray[i].getCell();
            if (!(object instanceof NoteDiagramCell) || !note.equals((noteDiagramCell = (NoteDiagramCell)object).getNote())) continue;
            Object[] objectArray = new Object[]{noteDiagramCell};
            objectArray = this.getDescendants(objectArray);
            this.getModel().remove(objectArray);
            break;
        }
    }

    public void removeLegend(Legend legend) {
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            LegendDiagramCell legendDiagramCell;
            Object object = cellViewArray[i].getCell();
            if (!(object instanceof LegendDiagramCell) || !legend.equals((legendDiagramCell = (LegendDiagramCell)object).getLegend())) continue;
            Object[] objectArray = new Object[]{legendDiagramCell};
            objectArray = this.getDescendants(objectArray);
            this.getModel().remove(objectArray);
            break;
        }
    }

    public void removeLabel(Label label) {
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            LabelDiagramCell labelDiagramCell;
            Object object = cellViewArray[i].getCell();
            if (!(object instanceof LabelDiagramCell) || !label.equals((labelDiagramCell = (LabelDiagramCell)object).getLabel())) continue;
            Object[] objectArray = new Object[]{labelDiagramCell};
            objectArray = this.getDescendants(objectArray);
            this.getModel().remove(objectArray);
            break;
        }
    }

    public void LabelsToFront() {
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            Object object = cellViewArray[i].getCell();
            if (!(object instanceof LabelDiagramCell)) continue;
            arrayList.add(object);
        }
        this.getDiagramLayoutCache().toFront(arrayList.toArray());
    }

    public void removeDiagramView(DiagramView diagramView) {
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            DiagramViewDiagramCell diagramViewDiagramCell;
            Object object = cellViewArray[i].getCell();
            if (!(object instanceof DiagramViewDiagramCell) || !diagramView.equals((diagramViewDiagramCell = (DiagramViewDiagramCell)object).getDiagramView())) continue;
            Object[] objectArray = new Object[]{diagramViewDiagramCell};
            objectArray = this.getDescendants(objectArray);
            this.getModel().remove(objectArray);
            break;
        }
    }

    public void sendToBack(Object object) {
        this.getDiagramLayoutCache().toBack(new Object[]{object});
        Rectangle2D rectangle2D = ((DefaultDiagramCell)object).getCellView().getBounds();
        Object[] objectArray = this.getEdgesUnder(rectangle2D);
        if (objectArray.length > 0) {
            this.getDiagramLayoutCache().toBack(objectArray);
        }
    }

    public void removeConnection(DesignObject designObject) {
        CellView[] cellViewArray = this.getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            DefaultEdge defaultEdge;
            Object object = cellViewArray[i].getCell();
            if (!(object instanceof DefaultEdge) || (defaultEdge = (DefaultEdge)object).getTopView() != null && !designObject.equals(defaultEdge.getTopView().getModel())) continue;
            if (defaultEdge.getTopView() != null) {
                ((TVConnector)defaultEdge.getTopView()).clearLabels();
            }
            Object[] objectArray = new Object[]{defaultEdge};
            objectArray = this.getDescendants(objectArray);
            this.getModel().remove(objectArray);
        }
    }

    public DefaultEdge addConnection(DefaultDiagramCell defaultDiagramCell, DefaultDiagramCell defaultDiagramCell2, Color color) {
        Object object;
        Hashtable<RelationEdge, Map> hashtable = new Hashtable<RelationEdge, Map>();
        DefaultEdge defaultEdge = defaultDiagramCell instanceof EntityDiagramCell && defaultDiagramCell2 instanceof EntityDiagramCell ? new RelationEdge() : (defaultDiagramCell instanceof TableDiagramCell && defaultDiagramCell2 instanceof TableDiagramCell ? new FKEdge() : (defaultDiagramCell instanceof DFDiagramCell && defaultDiagramCell2 instanceof DFDiagramCell ? new FlowEdge() : (defaultDiagramCell instanceof MDDiagramCell && defaultDiagramCell2 instanceof MDDiagramCell ? new LinkEdge() : new DefaultEdge())));
        Map map = DiagramConstants.createMap();
        hashtable.put((RelationEdge)defaultEdge, map);
        DiagramConstants.setLineStyle(map, 11);
        if (defaultDiagramCell instanceof EntityDiagramCell && defaultDiagramCell2 instanceof EntityDiagramCell) {
            Entity entity = (Entity)((EntityDiagramCell)defaultDiagramCell).getContainer();
            object = (Entity)((EntityDiagramCell)defaultDiagramCell2).getContainer();
            if (((Entity)object).getHierarchicalParent() == entity) {
                DiagramConstants.setLineBegin(map, 4);
            }
        } else {
            if (defaultEdge instanceof FlowEdge) {
                DiagramConstants.setLineEnd(map, 1);
            } else if (defaultEdge instanceof LinkEdge) {
                DiagramConstants.setLineEnd(map, 1);
            } else if (defaultEdge instanceof FKEdge) {
                DiagramConstants.setLineBegin(map, 2);
            } else {
                DiagramConstants.setLineEnd(map, 2);
            }
            DiagramConstants.setBeginSize(map, 4);
            DiagramConstants.setBeginFill(map, true);
            if (defaultEdge instanceof LinkEdge) {
                if (!(defaultDiagramCell instanceof DimensionDiagramCell)) {
                    DiagramConstants.setLineBegin(map, 8);
                }
            } else if (defaultEdge instanceof FKEdge) {
                DiagramConstants.setLineEnd(map, 5);
                DiagramConstants.setBeginSize(map, 8);
                DiagramConstants.setEndSize(map, 4);
            } else {
                DiagramConstants.setLineBegin(map, 5);
            }
            DiagramConstants.setEndFill(map, true);
        }
        DiagramConstants.setDisconnectable(map, false);
        boolean bl = false;
        if (this.dpv != null) {
            bl = this.dpv.isAutoRoute();
        }
        if (bl || defaultDiagramCell == defaultDiagramCell2) {
            DiagramConstants.setRouting(map, DiagramConstants.ROUTING_SIMPLE);
        }
        DiagramConstants.setLineColor(map, color);
        DiagramConstants.setTransferable(map, true);
        object = new DefaultPort();
        defaultDiagramCell.add((MutableTreeNode)object);
        DefaultPort defaultPort = new DefaultPort();
        defaultDiagramCell2.add(defaultPort);
        ConnectionSet connectionSet = new ConnectionSet((Edge)defaultEdge, (Port)object, defaultPort);
        Object[] objectArray = new Object[]{defaultEdge};
        this.getModel().insert(objectArray, hashtable, connectionSet, null, null);
        this.getDiagramLayoutCache().toBack(objectArray);
        return defaultEdge;
    }

    public DefaultEdge addConnection(DefaultDiagramCell defaultDiagramCell, DefaultDiagramCell defaultDiagramCell2, Color color, Object object) {
        Hashtable<RelationEdge, Map> hashtable = new Hashtable<RelationEdge, Map>();
        DefaultEdge defaultEdge = object instanceof Relation ? new RelationEdge() : (object instanceof FKIndexAssociation ? new FKEdge() : (object instanceof TypeSubstitution ? new TypeSubstitutionEdge() : (object instanceof Flow ? new FlowEdge() : (object instanceof Link ? new LinkEdge() : (object instanceof RaggedHLink ? new RaggedHLinkEdge() : (object instanceof DTReference ? new ReferenceEdge() : (object instanceof DTInheritance ? new InheritanceEdge() : new DefaultEdge())))))));
        Map map = DiagramConstants.createMap();
        hashtable.put((RelationEdge)defaultEdge, map);
        DiagramConstants.setLineStyle(map, 11);
        if (defaultDiagramCell instanceof EntityDiagramCell && defaultDiagramCell2 instanceof EntityDiagramCell) {
            if (defaultEdge instanceof TypeSubstitutionEdge) {
                DiagramConstants.setLineBegin(map, 2);
                DiagramConstants.setEndFill(map, false);
                DiagramConstants.setBeginFill(map, false);
                DiagramConstants.setLineEnd(map, 5);
                DiagramConstants.setBeginSize(map, 8);
                DiagramConstants.setEndSize(map, 4);
            }
        } else if (defaultEdge instanceof InheritanceEdge) {
            if (defaultDiagramCell == defaultDiagramCell2) {
                DiagramConstants.setLineEnd(map, 2);
                DiagramConstants.setBeginSize(map, 10);
            } else {
                DiagramConstants.setLineBegin(map, 2);
                DiagramConstants.setBeginSize(map, 10);
                DiagramConstants.setLineEnd(map, 5);
                DiagramConstants.setEndSize(map, 4);
            }
        } else if (defaultEdge instanceof ReferenceEdge) {
            if (defaultDiagramCell == defaultDiagramCell2) {
                DiagramConstants.setLineEnd(map, 1);
            } else {
                DiagramConstants.setLineBegin(map, 1);
                DiagramConstants.setLineEnd(map, 9);
                DiagramConstants.setEndSize(map, 10);
            }
        } else {
            if (defaultEdge instanceof FlowEdge) {
                DiagramConstants.setLineEnd(map, 1);
            } else if (defaultEdge instanceof LinkEdge) {
                DiagramConstants.setLineEnd(map, 1);
            } else if (defaultEdge instanceof RaggedHLinkEdge) {
                float[] fArray = new float[]{10.0f, 4.0f, 4.0f, 4.0f};
                DiagramConstants.setDashPattern(map, fArray);
                DiagramConstants.setLineEnd(map, 1);
            } else if (defaultEdge instanceof FKEdge) {
                DiagramConstants.setLineBegin(map, 2);
            } else if (defaultEdge instanceof TypeSubstitutionEdge) {
                DiagramConstants.setLineBegin(map, 2);
                DiagramConstants.setEndFill(map, false);
                DiagramConstants.setBeginFill(map, false);
            } else {
                DiagramConstants.setLineEnd(map, 2);
            }
            DiagramConstants.setBeginSize(map, 4);
            DiagramConstants.setBeginFill(map, true);
            if (defaultEdge instanceof LinkEdge) {
                if (!(defaultDiagramCell instanceof DimensionDiagramCell)) {
                    DiagramConstants.setLineBegin(map, 8);
                }
            } else if (defaultEdge instanceof FKEdge) {
                DiagramConstants.setLineEnd(map, 5);
                DiagramConstants.setBeginSize(map, 8);
                DiagramConstants.setEndSize(map, 4);
                if (object instanceof FKIndexAssociation && !((FKIndexAssociation)object).isMandatory()) {
                    DiagramConstants.setDashPattern(map, FKIndexAssociation.dashpattern);
                }
            } else if (defaultEdge instanceof TypeSubstitutionEdge) {
                DiagramConstants.setLineEnd(map, 5);
                DiagramConstants.setBeginSize(map, 8);
                DiagramConstants.setEndSize(map, 4);
            } else {
                DiagramConstants.setLineBegin(map, 5);
            }
            if (!(defaultEdge instanceof TypeSubstitutionEdge)) {
                DiagramConstants.setEndFill(map, true);
            } else {
                DiagramConstants.setEndFill(map, false);
                DiagramConstants.setBeginFill(map, false);
            }
        }
        DiagramConstants.setDisconnectable(map, false);
        boolean bl = false;
        if (this.dpv != null) {
            bl = this.dpv.isAutoRoute();
        }
        if (bl || defaultDiagramCell == defaultDiagramCell2) {
            DiagramConstants.setRouting(map, DiagramConstants.ROUTING_SIMPLE);
        }
        DiagramConstants.setLineColor(map, color);
        DiagramConstants.setTransferable(map, true);
        DefaultPort defaultPort = new DefaultPort();
        defaultDiagramCell.add(defaultPort);
        DefaultPort defaultPort2 = new DefaultPort();
        defaultDiagramCell2.add(defaultPort2);
        ConnectionSet connectionSet = new ConnectionSet((Edge)defaultEdge, (Port)defaultPort, defaultPort2);
        Object[] objectArray = new Object[]{defaultEdge};
        this.getModel().insert(objectArray, hashtable, connectionSet, null, null);
        this.getDiagramLayoutCache().toBack(objectArray);
        return defaultEdge;
    }

    public void restoreConnection(DefaultEdge defaultEdge, DefaultPort defaultPort, DefaultPort defaultPort2, Map map) {
        Map map2 = DiagramConstants.createMap();
        map2.put(defaultEdge, map);
        ConnectionSet connectionSet = new ConnectionSet((Edge)defaultEdge, (Port)defaultPort, defaultPort2);
        Object[] objectArray = new Object[]{defaultEdge};
        this.getModel().insert(objectArray, map2, connectionSet, null, null);
        this.getDiagramLayoutCache().toBack(objectArray);
    }

    public void actualSize() {
        this.setScale(1.0);
    }

    public void zoomIn() {
        if (this.getScale() < 8.0) {
            this.setScale(this.getScale() * 1.3);
        }
    }

    public void zoomOut() {
        this.setScale(this.getScale() / 1.3);
    }

    public void fitScreen() {
        Rectangle rectangle;
        Rectangle2D rectangle2D = this.getCellBounds(this.getRoots());
        if (rectangle2D != null && (rectangle = rectangle2D.getBounds()) != null) {
            double d;
            Dimension dimension = this.getScrollPane().getViewport().getExtentSize();
            double d2 = 1.0;
            double d3 = dimension.getWidth() / ((double)rectangle.x + rectangle.getWidth());
            d2 = d3 < (d = dimension.getHeight() / ((double)rectangle.y + rectangle.getHeight())) ? Math.max(Math.min(d3, 16.0), 0.01) : Math.max(Math.min(d, 16.0), 0.01);
            this.setScale(d2);
        }
    }

    public JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this);
        }
        return this.scrollPane;
    }

    public AbstractController getController() {
        return null;
    }

    public void addPoints(DefaultEdge defaultEdge, List list) {
        this.addPoints(defaultEdge, list, false);
    }

    public void addPoints(DefaultEdge defaultEdge, List list, boolean bl) {
        EdgeView edgeView = (EdgeView)this.getDiagramLayoutCache().getMapping(defaultEdge, false);
        Hashtable hashtable = new Hashtable();
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        if (bl && this.getDesignPartView().getDesign().getLoadedVersion() >= 2.3f) {
            CellView cellView = edgeView.getSource();
            CellView cellView2 = edgeView.getTarget();
            if (cellView != null && cellView2 != null && cellView != cellView2) {
                Object object;
                PortView portView = (PortView)cellView;
                PortView portView2 = (PortView)cellView2;
                if (list.size() > 1) {
                    Object e = list.get(0);
                    if (e instanceof PortView) {
                        portView.setPoint(((PortView)e).getPoint());
                    } else {
                        portView.setPoint((Point2D)e);
                    }
                    object = list.get(list.size() - 1);
                    if (object instanceof PortView) {
                        portView2.setPoint(((PortView)object).getPoint());
                    } else {
                        portView2.setPoint((Point2D)object);
                    }
                }
                arrayList.add(portView.getPoint());
                for (int i = 1; i < list.size() - 1; ++i) {
                    object = (Point2D)list.get(i);
                    arrayList.add((Point2D)object);
                }
                arrayList.add(portView2.getPoint());
            } else {
                Point2D point2D = edgeView.getPoint(0);
                Point2D point2D2 = edgeView.getPoint(1);
                arrayList.add(point2D);
                if (list.size() > 0) {
                    for (int i = 0; i < list.size(); ++i) {
                        Point2D point2D3 = (Point2D)list.get(i);
                        arrayList.add(point2D3);
                    }
                }
                arrayList.add(point2D2);
            }
        } else {
            Point2D point2D = edgeView.getPoint(0);
            Point2D point2D4 = edgeView.getPoint(1);
            arrayList.add(point2D);
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (!(e instanceof Point2D)) continue;
                    arrayList.add((Point2D)e);
                }
            }
            arrayList.add(point2D4);
        }
        DiagramConstants.setPoints(hashtable, arrayList);
        defaultEdge.changeAttributes(hashtable);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public ApplicationView getAppView() {
        return this.appView;
    }

    public int getDrawnObjectID() {
        return this.drawnObjectID;
    }

    public void setDrawnObjectID(int n) {
        this.drawnObjectID = n;
    }

    public void showPopupMenu(Point point) {
        this.dpv.pt = point;
        JPopupMenu jPopupMenu = this.dpv.getPopupMenu();
        jPopupMenu.show(this, point.x, point.y);
    }

    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    public MDBAction getCurrentAction() {
        return this.currentAction;
    }

    public void setCurrentAction(MDBAction mDBAction) {
        this.currentAction = mDBAction;
    }

    public void setDPVtoNull() {
        this.dpv = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DiagramSelectionListener.class || !(objectArray[i + 1] instanceof DiagramSelectionListener)) continue;
            this.listenerList.remove(DiagramSelectionListener.class, (DiagramSelectionListener)objectArray[i + 1]);
        }
        this.scrollPane = null;
        this.overview = null;
        this.diagramModel = null;
        this.selectionModel = null;
    }
}

