/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.designrules.DRTemporary;
import oracle.dbtools.crest.swingui.designrules.DesignRuleSet;
import oracle.dbtools.crest.swingui.designrules.DesignRuleView;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.OSEnvironment;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DesignRuleSetPropertiesDialog
extends CustomDialog {
    private static final long serialVersionUID = -8255158459996467257L;
    private static final String NA = "N/A";
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    private JDialog dialog;
    private int result = 0;
    private JPanel mainPanel;
    private JTable allDesignRulesTable;
    private JTable selDesignRulesTable;
    private List<DesignRule> allDesignRulesList;
    private List<DesignRule> selDesignRulesList;
    private DesignRuleView parent;
    private JButton buttonRuleAdd;
    private JButton buttonRuleRemove;
    private DesignRule currentRule;
    private JPanel btnPanel;
    private DesignRuleSet drs;
    private ArrayList<DesignRule> allRules = new ArrayList();

    public DesignRuleSetPropertiesDialog(ApplicationView applicationView, DesignRuleSet designRuleSet, DesignRuleView designRuleView) {
        super(applicationView);
        this.parent = designRuleView;
        this.drs = designRuleSet;
        this.init();
        this.add((Component)this.mainPanel, "Center");
    }

    private void init() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.allDesignRulesList = new ArrayList<DesignRule>();
        this.selDesignRulesList = new ArrayList<DesignRule>();
        this.allDesignRulesTable = new JTable(new AllRulesTableModel());
        this.selDesignRulesTable = new JTable(new SelRulesTableModel());
        this.allDesignRulesTable.setAutoResizeMode(0);
        this.selDesignRulesTable.setAutoResizeMode(0);
        this.selDesignRulesTable.setDefaultRenderer(Object.class, new SelectedDRRenderer());
        this.allDesignRulesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (DesignRuleSetPropertiesDialog.this.allDesignRulesTable.getSelectedRow() == -1) {
                    DesignRuleSetPropertiesDialog.this.buttonRuleAdd.setEnabled(false);
                } else {
                    DesignRuleSetPropertiesDialog.this.buttonRuleAdd.setEnabled(true);
                }
            }
        });
        this.selDesignRulesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (DesignRuleSetPropertiesDialog.this.selDesignRulesTable.getSelectedRow() == -1 || DesignRuleSetPropertiesDialog.this.selDesignRulesTable.getValueAt(DesignRuleSetPropertiesDialog.this.selDesignRulesTable.getSelectedRow(), 2).equals(DesignRuleSetPropertiesDialog.NA)) {
                    DesignRuleSetPropertiesDialog.this.buttonRuleRemove.setEnabled(false);
                } else {
                    DesignRuleSetPropertiesDialog.this.buttonRuleRemove.setEnabled(true);
                }
            }
        });
        TableColumn tableColumn = this.allDesignRulesTable.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(30);
        tableColumn.setMaxWidth(30);
        TableColumn tableColumn2 = this.allDesignRulesTable.getColumnModel().getColumn(1);
        tableColumn2.setMinWidth(120);
        TableColumn tableColumn3 = this.allDesignRulesTable.getColumnModel().getColumn(2);
        tableColumn3.setMinWidth(120);
        TableColumn tableColumn4 = this.allDesignRulesTable.getColumnModel().getColumn(3);
        tableColumn4.setMinWidth(370);
        tableColumn = this.selDesignRulesTable.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(30);
        tableColumn.setMaxWidth(30);
        tableColumn2 = this.selDesignRulesTable.getColumnModel().getColumn(1);
        tableColumn2.setMinWidth(120);
        tableColumn3 = this.selDesignRulesTable.getColumnModel().getColumn(2);
        tableColumn3.setMinWidth(120);
        tableColumn4 = this.selDesignRulesTable.getColumnModel().getColumn(3);
        tableColumn4.setMinWidth(370);
        JScrollPane jScrollPane = new JScrollPane(this.allDesignRulesTable);
        JScrollPane jScrollPane2 = new JScrollPane(this.selDesignRulesTable);
        jScrollPane.setPreferredSize(new Dimension(600, 300));
        jScrollPane2.setPreferredSize(new Dimension(600, 300));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignRuleView.AllRules")));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignRuleView.SelectedRules")));
        jPanel2.add((Component)jScrollPane2, "West");
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        JPanel jPanel4 = new JPanel();
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JPanel jPanel5 = new JPanel(new BorderLayout());
        this.buttonRuleAdd = new JButton(gUIConfiguration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonRuleAdd.addActionListener(new AddRuleActionListener());
        this.buttonRuleAdd.setEnabled(false);
        this.buttonRuleAdd.setToolTipText(Messages.getString("DesignRuleView.AddRule"));
        this.buttonRuleRemove = new JButton(gUIConfiguration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonRuleRemove.setEnabled(false);
        this.buttonRuleRemove.addActionListener(new RemoveRuleActionListener());
        this.buttonRuleRemove.setToolTipText(Messages.getString("DesignRuleView.RemoveRule"));
        this.buttonRuleAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonRuleRemove.setPreferredSize(this.buttonRuleAdd.getPreferredSize());
        jPanel5.add((Component)this.buttonRuleAdd, "North");
        jPanel5.add((Component)this.buttonRuleRemove, "Center");
        jPanel4.add(jPanel5);
        jPanel3.add(new JPanel());
        jPanel3.add(jPanel4);
        jPanel3.add(new JPanel());
        jPanel.add((Component)jScrollPane, "West");
        this.mainPanel.add((Component)jPanel3, "Center");
        this.mainPanel.add((Component)jPanel, "West");
        this.mainPanel.add((Component)jPanel2, "East");
        JPanel jPanel6 = this.getButtonPanel();
        this.mainPanel.add((Component)jPanel6, "South");
        this.initRules();
    }

    public String getCaption() {
        return Messages.getString("DesignRuleView.RuleSetProperties");
    }

    protected int getMinimumWidth() {
        return OSEnvironment.isMacOS() ? 680 : 630;
    }

    protected int getMinimumHeight() {
        return OSEnvironment.isMacOS() ? 560 : 500;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("DesignRuleView.RuleSetProperties"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "RULESET_PROPERRTIES_DIALOG";
    }

    public int showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    private void initRules() {
        this.allDesignRulesList.clear();
        this.selDesignRulesList.clear();
        this.allRules.clear();
        this.allDesignRulesList.addAll(this.parent.getAllDesignRules());
        this.selDesignRulesList.addAll(this.drs.getDesignRules());
        this.selDesignRulesList.addAll(this.drs.getDesignRulesMissing());
        this.allRules.addAll(this.allDesignRulesList);
        for (DesignRule designRule : this.selDesignRulesList) {
            for (DesignRule designRule2 : this.allRules) {
                if (!designRule.getRuleId().equals(designRule2.getRuleId())) continue;
                this.allDesignRulesList.remove(designRule2);
            }
        }
        this.sort(this.allDesignRulesList);
        this.sort(this.selDesignRulesList);
        this.allDesignRulesTable.updateUI();
        this.selDesignRulesTable.updateUI();
    }

    protected JPanel getButtonPanel() {
        if (this.btnPanel == null) {
            this.btnPanel = new JPanel();
            JButton jButton = new JButton(Messages.getString("DesignRuleView.OK"));
            jButton.setMnemonic(79);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DesignRuleSetPropertiesDialog.this.applyRulesToRuleset();
                    ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.bnSaveRuleSets.setEnabled(true);
                    ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.ruleSetsSaved = false;
                    DesignRuleSetPropertiesDialog.this.result = 1;
                    DesignRuleSetPropertiesDialog.this.close();
                }
            });
            JButton jButton2 = new JButton(Messages.getString("DesignRuleView.Cancel"));
            jButton2.setMnemonic(67);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DesignRuleSetPropertiesDialog.this.result = 0;
                    ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.bnSaveRuleSets.setEnabled(false);
                    ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.ruleSetsSaved = true;
                    DesignRuleSetPropertiesDialog.this.close();
                }
            });
            JButton jButton3 = new JButton(this.getHelpAction());
            jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnPanel.add(jButton);
            this.btnPanel.add(jButton2);
            this.btnPanel.add(jButton3);
        }
        return this.btnPanel;
    }

    private void applyRulesToRuleset() {
        this.drs.getDesignRules().clear();
        int n = this.selDesignRulesList.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (this.selDesignRulesTable.getValueAt(i, 2).equals(NA)) continue;
                DesignRule designRule = this.selDesignRulesList.get(i);
                this.drs.addRule(designRule);
            }
        }
    }

    public void sort(List list) {
        Collections.sort(list, new DRComparator());
    }

    class DRComparator
    implements Comparator {
        DRComparator() {
        }

        public int compare(Object object, Object object2) {
            DesignRule designRule = (DesignRule)object;
            DesignRule designRule2 = (DesignRule)object2;
            if (!(designRule instanceof DRTemporary) && !(designRule2 instanceof DRTemporary)) {
                String string = "";
                string = designRule.getRuleHandler() != null ? designRule.getContextString() + designRule.getRuleHandler().getLabel() + designRule.getName() : designRule.getContextString() + "" + designRule.getName();
                String string2 = "";
                string2 = designRule2.getRuleHandler() != null ? designRule2.getContextString() + designRule2.getRuleHandler().getLabel() + designRule2.getName() : designRule2.getContextString() + "" + designRule2.getName();
                return string.compareTo(string2);
            }
            return 0;
        }
    }

    public class SelectedDRRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 3947219013441913836L;
        Color color = new Color(204, 255, 255);

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Color color = null;
            if (jTable.getValueAt(n, 2).equals(DesignRuleSetPropertiesDialog.NA)) {
                color = Color.RED;
            }
            component.setForeground(color);
            return component;
        }
    }

    private class RemoveRuleActionListener
    implements ActionListener {
        private RemoveRuleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = DesignRuleSetPropertiesDialog.this.selDesignRulesTable.getSelectedRows();
            ArrayList<DesignRule> arrayList = new ArrayList<DesignRule>();
            for (int i = 0; i < nArray.length; ++i) {
                DesignRuleSetPropertiesDialog.this.currentRule = (DesignRule)DesignRuleSetPropertiesDialog.this.selDesignRulesList.get(nArray[i]);
                if (DesignRuleSetPropertiesDialog.this.allDesignRulesList.contains(DesignRuleSetPropertiesDialog.this.currentRule)) continue;
                arrayList.add(DesignRuleSetPropertiesDialog.this.currentRule);
                DesignRuleSetPropertiesDialog.this.allDesignRulesList.add(DesignRuleSetPropertiesDialog.this.currentRule);
            }
            DesignRuleSetPropertiesDialog.this.selDesignRulesList.removeAll(arrayList);
            DesignRuleSetPropertiesDialog.this.sort(DesignRuleSetPropertiesDialog.this.allDesignRulesList);
            DesignRuleSetPropertiesDialog.this.allDesignRulesTable.updateUI();
            DesignRuleSetPropertiesDialog.this.selDesignRulesTable.updateUI();
            DesignRuleSetPropertiesDialog.this.selDesignRulesTable.getSelectionModel().setSelectionInterval(0, 0);
            DesignRuleSetPropertiesDialog.this.buttonRuleRemove.setEnabled(DesignRuleSetPropertiesDialog.this.selDesignRulesList.size() > 0);
            ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.bnSaveRuleSets.setEnabled(true);
            ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.ruleSetsSaved = false;
        }
    }

    private class AddRuleActionListener
    implements ActionListener {
        private AddRuleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = DesignRuleSetPropertiesDialog.this.allDesignRulesTable.getSelectedRows();
            ArrayList<DesignRule> arrayList = new ArrayList<DesignRule>();
            for (int i = 0; i < nArray.length; ++i) {
                DesignRuleSetPropertiesDialog.this.currentRule = (DesignRule)DesignRuleSetPropertiesDialog.this.allDesignRulesList.get(nArray[i]);
                if (DesignRuleSetPropertiesDialog.this.selDesignRulesList.contains(DesignRuleSetPropertiesDialog.this.currentRule)) continue;
                arrayList.add(DesignRuleSetPropertiesDialog.this.currentRule);
                DesignRuleSetPropertiesDialog.this.selDesignRulesList.add(DesignRuleSetPropertiesDialog.this.currentRule);
            }
            DesignRuleSetPropertiesDialog.this.allDesignRulesList.removeAll(arrayList);
            DesignRuleSetPropertiesDialog.this.sort(DesignRuleSetPropertiesDialog.this.selDesignRulesList);
            DesignRuleSetPropertiesDialog.this.allDesignRulesTable.updateUI();
            DesignRuleSetPropertiesDialog.this.selDesignRulesTable.updateUI();
            DesignRuleSetPropertiesDialog.this.allDesignRulesTable.getSelectionModel().setSelectionInterval(0, 0);
            DesignRuleSetPropertiesDialog.this.buttonRuleAdd.setEnabled(DesignRuleSetPropertiesDialog.this.allDesignRulesList.size() > 0);
            ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.bnSaveRuleSets.setEnabled(true);
            ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.ruleSetsSaved = false;
        }
    }

    private class SelRulesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5686761803148703793L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.ModelType"), Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.Object"), Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.Name")};

        private SelRulesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return DesignRuleSetPropertiesDialog.this.selDesignRulesList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignRule designRule = (DesignRule)DesignRuleSetPropertiesDialog.this.selDesignRulesList.get(n);
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1) {
                if (designRule.getRuleHandler() != null) {
                    return designRule.getContextString();
                }
                return DesignRuleSetPropertiesDialog.NA;
            }
            if (n2 == 2) {
                if (designRule.getRuleHandler() != null) {
                    return designRule.getRuleHandler().getLabel();
                }
                return DesignRuleSetPropertiesDialog.NA;
            }
            if (n2 == 3) {
                return designRule.getName();
            }
            return n + 1;
        }
    }

    private class AllRulesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5587454722645897967L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.ModelType"), Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.Object"), Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.Name")};

        private AllRulesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return DesignRuleSetPropertiesDialog.this.allDesignRulesList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DesignRule designRule = (DesignRule)DesignRuleSetPropertiesDialog.this.allDesignRulesList.get(n);
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1) {
                return designRule.getContextString();
            }
            if (n2 == 2) {
                return designRule.getRuleHandler().getLabel();
            }
            if (n2 == 3) {
                return designRule.getName();
            }
            return n + 1;
        }
    }
}

