/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.designrules.DesignRuleManager;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.util.gui.swing.JSelectableLabel;

public class DRMCellRenderer
extends DefaultTreeCellRenderer {
    private static final String ICON_WARNING = "ICON_WARNING";
    private static final String ICON_ERROR = "ICON_ERROR";
    private static final String ICON_INFO = "ICON_INFO";
    private static Map icons;
    private static Icon defaultIcon;
    private static Icon openIcon;
    private JSelectableLabel component = new JSelectableLabel();
    static Border selectedBorder;
    static Border emptyBorder;
    static final String PROTOTYPE_TEXT = "XXXXXXXXXX";

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.component.setSelected(bl);
        this.component.setHasFocus(bl4);
        if (object instanceof DesignRuleManager) {
            this.configureDesignRuleManager(this.component, jTree, object, bl, bl2, bl3, n, bl4);
        } else if (object instanceof DesignRule) {
            this.configureDesignRule(this.component, jTree, object, bl, bl2, bl3, n, bl4);
        } else if (object instanceof RuleHandler) {
            this.configureRuleHandler(this.component, jTree, object, bl, bl2, bl3, n, bl4);
        } else {
            this.component.setText(object.toString());
        }
        return this.component;
    }

    protected void configureDesignRuleManager(JLabel jLabel, JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        jLabel.setText(Messages.getString("DRMCellRenderer.Rules"));
    }

    protected void configureDesignRule(JLabel jLabel, JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        DesignRule designRule = (DesignRule)object;
        jLabel.setText(designRule.getName());
        jLabel.setToolTipText(designRule.getDescription());
        ImageIcon imageIcon = null;
        if (designRule != null) {
            imageIcon = designRule.getType() == 2 ? (ImageIcon)icons.get(ICON_INFO) : (designRule.getType() == 1 ? (ImageIcon)icons.get(ICON_WARNING) : (ImageIcon)icons.get(ICON_ERROR));
        }
        if (imageIcon != null) {
            jLabel.setIcon(imageIcon);
        }
    }

    protected void configureRuleHandler(JLabel jLabel, JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        RuleHandler ruleHandler = (RuleHandler)object;
        jLabel.setText(ruleHandler.getLabel());
        if (bl2) {
            jLabel.setIcon(openIcon);
        } else {
            jLabel.setIcon(defaultIcon);
        }
    }

    static {
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        int n = 16;
        icons = new HashMap();
        icons.put(ICON_ERROR, gUIConfiguration.getIcon("ERROR_ICON", n));
        icons.put(ICON_WARNING, gUIConfiguration.getIcon("WARNING_ICON", n));
        icons.put(ICON_INFO, gUIConfiguration.getIcon("INFO_ICON", n));
        defaultIcon = gUIConfiguration.getIcon("BROWSER_CLOSED_ICON", n);
        openIcon = gUIConfiguration.getIcon("BROWSER_OPEN_ICON", n);
        selectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLineBorder(Color.lightGray, 1));
        emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    }
}

