/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomLibrariesManager
extends CustomDialog {
    private static final long serialVersionUID = 1284535107187895237L;
    private final String LIB_NAME = "Lib";
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private JDialog dialog;
    private JSplitPane mainPanel;
    public List<DRLibrary> customLibrariesContainerList;
    public ArrayList<String> methodsList;
    private JTable librariesTable;
    private JTable methodsTable;
    private JButton btnAddLib;
    private JButton btnRemoveLib;
    private JButton btnAddMethod;
    private JButton btnRemoveMethod;
    private int cgCounter = 0;
    private JTextArea scriptEditor;
    private ApplicationView appView;
    private JButton bnSave;
    private JButton bnClose;
    private JButton bnImport;
    private JButton bnExport;
    private DRLibrary currentLibrary;
    private boolean saved = true;
    private File file;
    private JComboBox engCombo;
    private boolean noRowSelectedState;
    private JPanel np;
    private JPanel sp;
    private ArrayList allEngines;
    private static File lastImpFolder = null;
    private static File lastExpFolder = null;
    ArrayList<DRLibrary> allLibraries;
    private static final Logger LOGGER = new Logger(CustomLibrariesManager.class);

    public CustomLibrariesManager(ApplicationView applicationView) {
        super(applicationView);
        this.appView = applicationView;
        this.allEngines = applicationView.getScriptEngines();
        this.allLibraries = applicationView.getCustomLibraries();
        this.init();
        this.loadLibraries();
    }

    private void init() {
        this.np = new JPanel(new BorderLayout());
        this.sp = new JPanel(new BorderLayout());
        this.mainPanel = new JSplitPane(0, this.np, this.sp);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mainPanel.setDividerLocation(200);
        this.initNorthPanel();
        this.initSouthPanel();
        this.initButtonsPanel();
    }

    private void initNorthPanel() {
        this.customLibrariesContainerList = new ArrayList<DRLibrary>();
        this.librariesTable = new JTable(new CustomRuleModel());
        this.librariesTable.setSelectionMode(0);
        this.librariesTable.setDefaultRenderer(Object.class, new SelectedDRRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.librariesTable);
        jScrollPane.setPreferredSize(new Dimension(300, 100));
        TableColumn tableColumn = this.librariesTable.getColumnModel().getColumn(0);
        tableColumn.setWidth(30);
        tableColumn.setMaxWidth(30);
        JTextField jTextField = new JTextField();
        TableColumn tableColumn2 = this.librariesTable.getColumnModel().getColumn(1);
        tableColumn2.setWidth(220);
        tableColumn2.setMaxWidth(1000);
        tableColumn2.setCellEditor(new TFCellEditor(jTextField));
        this.engCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.allEngines.toArray()));
        TableColumn tableColumn3 = this.librariesTable.getColumnModel().getColumn(2);
        tableColumn3.setWidth(120);
        tableColumn3.setMaxWidth(120);
        tableColumn3.setCellEditor(new DefaultCellEditor(this.engCombo));
        TableColumn tableColumn4 = this.librariesTable.getColumnModel().getColumn(3);
        this.librariesTable.getColumnModel().removeColumn(tableColumn4);
        jTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                CustomLibrariesManager.this.saved = false;
                CustomLibrariesManager.this.bnSave.setEnabled(true);
            }
        });
        this.engCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)CustomLibrariesManager.this.librariesTable.getValueAt(CustomLibrariesManager.this.librariesTable.getSelectedRow(), 2);
                String string2 = (String)CustomLibrariesManager.this.engCombo.getSelectedItem();
                if (string != null && string2 != null && !string.equals(string2)) {
                    CustomLibrariesManager.this.bnSave.setEnabled(true);
                    CustomLibrariesManager.this.saved = false;
                }
            }
        });
        this.librariesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = CustomLibrariesManager.this.librariesTable.getSelectedRow();
                if (n == -1) {
                    CustomLibrariesManager.this.btnRemoveLib.setEnabled(false);
                    CustomLibrariesManager.this.btnAddMethod.setEnabled(false);
                    CustomLibrariesManager.this.btnRemoveMethod.setEnabled(false);
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        CustomLibrariesManager.this.stopCellediting();
                        CustomLibrariesManager.this.methodsList.clear();
                        CustomLibrariesManager.this.methodsTable.updateUI();
                        CustomLibrariesManager.this.noRowSelectedState = true;
                    }
                } else {
                    CustomLibrariesManager.this.btnRemoveLib.setEnabled(true);
                    CustomLibrariesManager.this.btnAddMethod.setEnabled(true);
                    if (CustomLibrariesManager.this.currentLibrary != null && !CustomLibrariesManager.this.noRowSelectedState) {
                        CustomLibrariesManager.this.stopCellediting();
                    }
                    CustomLibrariesManager.this.currentLibrary = ((CustomRuleModel)CustomLibrariesManager.this.librariesTable.getModel()).getCustomRulesContainerList().get(n);
                    CustomLibrariesManager.this.methodsList.clear();
                    CustomLibrariesManager.this.methodsList.addAll(CustomLibrariesManager.this.currentLibrary.getFunctions());
                    CustomLibrariesManager.this.methodsTable.getSelectionModel().setSelectionInterval(0, 0);
                    CustomLibrariesManager.this.btnRemoveMethod.setEnabled(CustomLibrariesManager.this.methodsList.size() > 0);
                    CustomLibrariesManager.this.methodsTable.updateUI();
                    CustomLibrariesManager.this.scriptEditor.setText("");
                    CustomLibrariesManager.this.scriptEditor.setText(CustomLibrariesManager.this.customLibrariesContainerList.get(n).getScript());
                    CustomLibrariesManager.this.scriptEditor.setEnabled(true);
                    CustomLibrariesManager.this.noRowSelectedState = false;
                }
            }
        });
        this.np.add((Component)this.createScriptToolbarPanel(), "North");
        this.np.add((Component)jScrollPane, "Center");
    }

    private void initSouthPanel() {
        this.scriptEditor = new JTextArea();
        this.scriptEditor.setLineWrap(true);
        this.scriptEditor.setWrapStyleWord(true);
        this.scriptEditor.setEnabled(false);
        this.scriptEditor.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                CustomLibrariesManager.this.bnSave.setEnabled(true);
                CustomLibrariesManager.this.saved = false;
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.scriptEditor);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomLibrariesManager.Script")));
        jScrollPane.setPreferredSize(new Dimension(300, 620));
        this.sp.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomLibrariesManager.Functions")));
        this.methodsList = new ArrayList();
        this.methodsTable = new JTable(new FunctionModel());
        this.methodsTable.setSelectionMode(2);
        JScrollPane jScrollPane2 = new JScrollPane(this.methodsTable);
        jScrollPane2.setPreferredSize(new Dimension(80, 100));
        TableColumn tableColumn = this.methodsTable.getColumnModel().getColumn(0);
        tableColumn.setWidth(30);
        tableColumn.setMaxWidth(30);
        JTextField jTextField = new JTextField();
        TableColumn tableColumn2 = this.methodsTable.getColumnModel().getColumn(1);
        tableColumn2.setWidth(50);
        tableColumn2.setMaxWidth(1000);
        tableColumn2.setCellEditor(new TFCellEditor(jTextField));
        jTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                CustomLibrariesManager.this.saved = false;
                CustomLibrariesManager.this.bnSave.setEnabled(true);
            }
        });
        this.methodsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = CustomLibrariesManager.this.methodsTable.getSelectedRow();
                if (n == -1) {
                    CustomLibrariesManager.this.btnRemoveMethod.setEnabled(false);
                } else {
                    CustomLibrariesManager.this.btnRemoveMethod.setEnabled(true);
                }
            }
        });
        jPanel.add((Component)this.createFunctionsToolbarPanel(), "North");
        jPanel.add((Component)jScrollPane2, "Center");
        this.sp.add((Component)jPanel, "West");
    }

    private void initButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.bnSave = new JButton(Messages.getString("CustomLibrariesManager.Save"));
        this.bnSave.setToolTipText(Messages.getString("CustomLibrariesManager.SaveTooltip"));
        this.bnSave.setEnabled(false);
        this.bnSave.addActionListener(new SaveAction());
        this.bnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnSave.setMnemonic(83);
        jPanel.add(this.bnSave);
        this.bnImport = new JButton(this.createImportButton());
        this.bnImport.setToolTipText(Messages.getString("CustomLibrariesManager.ImportTooltip"));
        this.bnImport.setMnemonic(73);
        this.bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(this.bnImport);
        this.bnExport = new JButton(this.createExportButton());
        this.bnExport.setToolTipText(Messages.getString("CustomLibrariesManager.ExportTooltip"));
        this.bnExport.setMnemonic(69);
        this.bnExport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(this.bnExport);
        this.bnClose = new JButton(this.closeAction());
        this.bnClose.setToolTipText(Messages.getString("CustomLibrariesManager.CloseDialogTooltip"));
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.setMnemonic(67);
        jPanel.add(this.bnClose);
        JButton jButton = new JButton(this.getHelpAction());
        jButton.setToolTipText(Messages.getString("CustomLibrariesManager.HelpTooltip"));
        jButton.setMnemonic(72);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        this.sp.add((Component)jPanel, "South");
    }

    protected JPanel createScriptToolbarPanel() {
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        this.btnAddLib = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        this.btnAddLib.setToolTipText(Messages.getString("CustomLibrariesManager.AddLibrary"));
        this.btnAddLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DRLibrary dRLibrary = new DRLibrary(CustomLibrariesManager.this.generateLibraryName(), null);
                dRLibrary.setScriptEngineManager(CustomLibrariesManager.this.appView.getScriptEngineManager());
                dRLibrary.setFunctions(new ArrayList<String>());
                CustomLibrariesManager.this.customLibrariesContainerList.add(dRLibrary);
                CustomLibrariesManager.this.librariesTable.updateUI();
                CustomLibrariesManager.this.librariesTable.getSelectionModel().setSelectionInterval(CustomLibrariesManager.this.librariesTable.getRowCount() - 1, CustomLibrariesManager.this.librariesTable.getRowCount() - 1);
                CustomLibrariesManager.this.librariesTable.scrollRectToVisible(new Rectangle(CustomLibrariesManager.this.librariesTable.getColumnModel().getColumn(1).getWidth() * CustomLibrariesManager.this.librariesTable.getSelectedColumn(), CustomLibrariesManager.this.librariesTable.getRowHeight() * CustomLibrariesManager.this.librariesTable.getSelectedRow(), CustomLibrariesManager.this.librariesTable.getColumnModel().getColumn(1).getWidth(), CustomLibrariesManager.this.librariesTable.getRowHeight()));
                CustomLibrariesManager.this.btnRemoveLib.setEnabled(true);
                CustomLibrariesManager.this.btnAddMethod.setEnabled(true);
                CustomLibrariesManager.this.scriptEditor.setEnabled(true);
                CustomLibrariesManager.this.bnSave.setEnabled(true);
                CustomLibrariesManager.this.saved = false;
            }
        });
        this.btnRemoveLib = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemoveLib.setToolTipText(Messages.getString("CustomLibrariesManager.RemoveLibrary"));
        this.btnRemoveLib.setEnabled(false);
        this.btnRemoveLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CustomLibrariesManager.this.librariesTable.getSelectedRow();
                CustomLibrariesManager.this.customLibrariesContainerList.remove(n);
                CustomLibrariesManager.this.librariesTable.getSelectionModel().setSelectionInterval(0, 0);
                CustomLibrariesManager.this.librariesTable.scrollRectToVisible(new Rectangle(CustomLibrariesManager.this.librariesTable.getColumnModel().getColumn(1).getWidth() * CustomLibrariesManager.this.librariesTable.getSelectedColumn(), CustomLibrariesManager.this.librariesTable.getRowHeight() * CustomLibrariesManager.this.librariesTable.getSelectedRow(), CustomLibrariesManager.this.librariesTable.getColumnModel().getColumn(1).getWidth(), CustomLibrariesManager.this.librariesTable.getRowHeight()));
                CustomLibrariesManager.this.librariesTable.updateUI();
                CustomLibrariesManager.this.btnRemoveLib.setEnabled(CustomLibrariesManager.this.customLibrariesContainerList.size() > 0);
                if (CustomLibrariesManager.this.customLibrariesContainerList.size() == 0) {
                    CustomLibrariesManager.this.scriptEditor.setText("");
                    CustomLibrariesManager.this.methodsList.clear();
                    CustomLibrariesManager.this.methodsTable.updateUI();
                    CustomLibrariesManager.this.btnAddMethod.setEnabled(false);
                    CustomLibrariesManager.this.btnRemoveMethod.setEnabled(false);
                } else if (CustomLibrariesManager.this.customLibrariesContainerList.size() > 0) {
                    CustomLibrariesManager.this.currentLibrary = ((CustomRuleModel)CustomLibrariesManager.this.librariesTable.getModel()).getCustomRulesContainerList().get(CustomLibrariesManager.this.librariesTable.getSelectedRow());
                    CustomLibrariesManager.this.scriptEditor.setText("");
                    CustomLibrariesManager.this.scriptEditor.setText(CustomLibrariesManager.this.currentLibrary.getScript());
                    CustomLibrariesManager.this.methodsList.clear();
                    CustomLibrariesManager.this.methodsList.addAll(CustomLibrariesManager.this.currentLibrary.getFunctions());
                    CustomLibrariesManager.this.methodsTable.updateUI();
                }
                CustomLibrariesManager.this.bnSave.setEnabled(true);
                CustomLibrariesManager.this.saved = false;
            }
        });
        jToolBar.add(this.btnAddLib);
        jToolBar.add(this.btnRemoveLib);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        jPanel.add(jToolBar);
        return jPanel;
    }

    protected JPanel createFunctionsToolbarPanel() {
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        this.btnAddMethod = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        this.btnAddMethod.setEnabled(false);
        this.btnAddMethod.setToolTipText(Messages.getString("CustomLibrariesManager.AddFunction"));
        this.btnAddMethod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomLibrariesManager.this.methodsList.add("");
                CustomLibrariesManager.this.methodsTable.getSelectionModel().setSelectionInterval(CustomLibrariesManager.this.methodsTable.getRowCount() - 1, CustomLibrariesManager.this.methodsTable.getRowCount() - 1);
                CustomLibrariesManager.this.methodsTable.scrollRectToVisible(new Rectangle(CustomLibrariesManager.this.methodsTable.getColumnModel().getColumn(1).getWidth() * CustomLibrariesManager.this.methodsTable.getSelectedColumn(), CustomLibrariesManager.this.methodsTable.getRowHeight() * CustomLibrariesManager.this.methodsTable.getSelectedRow(), CustomLibrariesManager.this.methodsTable.getColumnModel().getColumn(1).getWidth(), CustomLibrariesManager.this.methodsTable.getRowHeight()));
                CustomLibrariesManager.this.methodsTable.updateUI();
                CustomLibrariesManager.this.btnRemoveMethod.setEnabled(true);
                CustomLibrariesManager.this.bnSave.setEnabled(true);
                CustomLibrariesManager.this.saved = false;
            }
        });
        this.btnRemoveMethod = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemoveMethod.setToolTipText(Messages.getString("CustomLibrariesManager.RemoveFunction"));
        this.btnRemoveMethod.setEnabled(false);
        this.btnRemoveMethod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = "";
                int[] nArray = CustomLibrariesManager.this.methodsTable.getSelectedRows();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < nArray.length; ++i) {
                    string = CustomLibrariesManager.this.methodsList.get(nArray[i]);
                    arrayList.add(string);
                }
                CustomLibrariesManager.this.methodsList.removeAll(arrayList);
                CustomLibrariesManager.this.btnRemoveMethod.setEnabled(CustomLibrariesManager.this.methodsList.size() > 0);
                CustomLibrariesManager.this.methodsTable.getSelectionModel().setSelectionInterval(0, 0);
                CustomLibrariesManager.this.methodsTable.updateUI();
                CustomLibrariesManager.this.bnSave.setEnabled(true);
                CustomLibrariesManager.this.saved = false;
            }
        });
        jToolBar.add(this.btnAddMethod);
        jToolBar.add(this.btnRemoveMethod);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.setPreferredSize(new Dimension(325, 35));
        jPanel.add(jToolBar);
        return jPanel;
    }

    protected String generateLibraryName() {
        String string = "Lib";
        int n = 0;
        int n2 = this.customLibrariesContainerList.size();
        if (n2 != 0) {
            n = this.cgCounter = n2 + 1;
        } else {
            ++this.cgCounter;
            n = this.cgCounter;
        }
        String string2 = string.concat("_").concat(Integer.toString(n));
        while (this.xists(string2)) {
            n = ++this.cgCounter;
            string2 = string.concat("_").concat(Integer.toString(n));
        }
        return string2;
    }

    private boolean xists(String string) {
        for (int i = 0; i < this.customLibrariesContainerList.size(); ++i) {
            DRLibrary dRLibrary = this.customLibrariesContainerList.get(i);
            if (!string.equalsIgnoreCase(dRLibrary.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("CustomLibrariesManager.Libraries"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.setSize(800, 600);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.getContentPane().add(this.mainPanel);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "CUSTOM_LIBRARIES_DIALOG";
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public Action closeAction() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("CustomLibrariesManager.Close")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomLibrariesManager.this.canClose()) {
                    CustomLibrariesManager.this.close();
                }
            }
        };
        return abstractAction;
    }

    protected boolean canSave() {
        if (this.customLibrariesContainerList.size() > 0) {
            if (this.librariesTable.getModel().getValueAt(this.librariesTable.getSelectedRow(), 2) == null) {
                JOptionPane.showMessageDialog(null, Messages.getString("CustomLibrariesManager.NoEngineChosen"), Messages.getString("CustomLibrariesManager.Warning"), 2);
                return false;
            }
            if (this.scriptEditor.getText().trim().length() == 0 || this.scriptEditor.getText() == null) {
                JOptionPane.showMessageDialog(null, Messages.getString("CustomLibrariesManager.NoScript"), Messages.getString("CustomLibrariesManager.Warning"), 2);
                return false;
            }
            for (String object : this.methodsList) {
                if (object != null && object.length() != 0) continue;
                JOptionPane.showMessageDialog(null, Messages.getString("CustomLibrariesManager.NoFunctionName"), Messages.getString("CustomLibrariesManager.Warning"), 2);
                return false;
            }
            for (DRLibrary dRLibrary : this.customLibrariesContainerList) {
                boolean bl = false;
                for (String string : dRLibrary.getFunctions()) {
                    if (string != null && string.length() != 0) continue;
                    bl = true;
                }
                if (dRLibrary.getEngine() != null && dRLibrary.getScript().trim().length() != 0 && !bl) continue;
                JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("CustomLibrariesManager.NoEngineScriptFN"), dRLibrary.getName()), Messages.getString("CustomLibrariesManager.NoScript"), 2);
                return false;
            }
        }
        return true;
    }

    private void loadLibraries() {
        Iterator<DRLibrary> iterator = this.allLibraries.iterator();
        this.customLibrariesContainerList.clear();
        while (iterator.hasNext()) {
            DRLibrary dRLibrary = iterator.next().copy();
            this.customLibrariesContainerList.add(dRLibrary);
        }
        if (this.customLibrariesContainerList.size() > 0) {
            this.librariesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.librariesTable.updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < CustomLibrariesManager.this.librariesTable.getRowCount(); ++i) {
                    if (!CustomLibrariesManager.this.librariesTable.getModel().getValueAt(i, 3).equals("err")) continue;
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomLibrariesManager.MissingEngine"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    break;
                }
            }
        });
    }

    @Override
    protected boolean canClose() {
        if (!this.saved) {
            String string = Messages.getString("CustomLibrariesManager.Yes");
            String string2 = Messages.getString("CustomLibrariesManager.No");
            Object[] objectArray = new Object[]{string, string2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("CustomLibrariesManager.NotSaved"), Messages.getString("CustomLibrariesManager.CloseConfirmation"), 0, 3, null, objectArray, string);
            return n == 0;
        }
        return true;
    }

    private void stopCellediting() {
        TableCellEditor tableCellEditor;
        this.currentLibrary.setScript(this.scriptEditor.getText());
        TableCellEditor tableCellEditor2 = this.librariesTable.getCellEditor();
        if (tableCellEditor2 != null) {
            this.librariesTable.getCellEditor().stopCellEditing();
        }
        if ((tableCellEditor = this.methodsTable.getCellEditor()) != null) {
            this.methodsTable.getCellEditor().stopCellEditing();
        }
        this.currentLibrary.getFunctions().clear();
        Iterator<String> iterator = this.methodsList.iterator();
        while (iterator.hasNext()) {
            this.currentLibrary.getFunctions().add(iterator.next());
        }
    }

    public Action createImportButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("CustomLibrariesManager.Import")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Serializable serializable;
                URLFilter uRLFilter = new URLFilter(){

                    public boolean accept(URL uRL) {
                        File file = new File(uRL.getPath());
                        return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                    }

                    public String toString() {
                        return Messages.getString("CustomLibrariesManager.XMLFiles");
                    }
                };
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setSelectionScope(0);
                uRLChooser.setSelectionMode(0);
                uRLChooser.setShowJarsAsDirs(false);
                uRLChooser.setURLFilter(uRLFilter);
                if (lastImpFolder != null) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastImpFolder));
                } else {
                    String string = CustomLibrariesManager.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (string != null && string.length() > 0) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                    } else {
                        serializable = CustomLibrariesManager.this.getApplicationView().getUserHomeDirectory();
                        if (serializable != null) {
                            uRLChooser.setSelectedURL((URL)serializable);
                        }
                    }
                }
                int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("CustomLibrariesManager.ImportLibraries"));
                if (n == 0) {
                    CustomLibrariesManager.this.file = new File(uRLChooser.getSelectedURL().getPath());
                    if (CustomLibrariesManager.this.file != null) {
                        lastImpFolder = CustomLibrariesManager.this.file.getParentFile();
                        try {
                            int n2;
                            serializable = new StringBuffer();
                            FileInputStream fileInputStream = new FileInputStream(CustomLibrariesManager.this.file);
                            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                            while ((n2 = ((Reader)bufferedReader).read()) > -1) {
                                ((StringBuffer)serializable).append((char)n2);
                            }
                            ((Reader)bufferedReader).close();
                            CustomLibrariesManager.this.importLib(((StringBuffer)serializable).toString());
                        }
                        catch (Exception exception) {
                            LOGGER.error("Unable to load libraries from imported file: ", exception);
                        }
                    }
                }
            }
        };
        return abstractAction;
    }

    public void importLib(String string) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n;
            StringReader stringReader = new StringReader(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(stringReader);
            Document document = documentBuilder.parse(inputSource);
            ArrayList<DRLibrary> arrayList = new ArrayList<DRLibrary>();
            NodeList nodeList = document.getElementsByTagName("lib");
            int n2 = nodeList.getLength();
            for (n = 0; n < n2; ++n) {
                object4 = (Element)nodeList.item(n);
                DRLibrary dRLibrary = new DRLibrary(object4.getAttribute(StringUtilities.decodeAttributeValue("name")), object4.getAttribute("id"));
                dRLibrary.setEngine(object4.getAttribute("engine"));
                dRLibrary.setFunctions(new ArrayList<String>());
                dRLibrary.setScriptEngineManager(this.appView.getScriptEngineManager());
                object3 = new StringTokenizer(StringUtilities.decodeAttributeValue(object4.getAttribute("methods")), ",");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    dRLibrary.getFunctions().add(((StringTokenizer)object3).nextToken());
                }
                object2 = object4.getChildNodes();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < object2.getLength(); ++i) {
                    object = object2.item(i);
                    stringBuffer.append(object.getTextContent());
                }
                dRLibrary.setScript(stringBuffer.toString().trim());
                arrayList.add(dRLibrary);
            }
            n = 0;
            object4 = arrayList.iterator();
            while (object4.hasNext()) {
                boolean bl = false;
                object3 = (DRLibrary)object4.next();
                object2 = ((DRLibrary)object3).getLibraryId();
                for (DRLibrary dRLibrary : this.allLibraries) {
                    object = dRLibrary.getLibraryId();
                    if (!((String)object2).equals(object)) {
                        bl = false;
                        continue;
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.allLibraries.add((DRLibrary)object3);
                this.customLibrariesContainerList.add((DRLibrary)object3);
                n = 1;
            }
            if (n != 0) {
                this.appView.saveCustomDRScripts();
            }
            this.librariesTable.updateUI();
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("Unable to export libraries: ", runtimeException);
        }
        catch (Exception exception) {
            LOGGER.error("Unable to import custom libraries: ", exception);
        }
    }

    public Action createExportButton() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("CustomLibrariesManager.Export")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomLibrariesManager.this.saved) {
                    Object object;
                    URLFilter uRLFilter = new URLFilter(){

                        public boolean accept(URL uRL) {
                            File file = new File(uRL.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("CustomLibrariesManager.XMLFiles");
                        }
                    };
                    URLChooser uRLChooser = DialogUtil.newURLChooser();
                    uRLChooser.clearChooseableURLFilters();
                    uRLChooser.setSelectionScope(0);
                    uRLChooser.setSelectionMode(0);
                    uRLChooser.setShowJarsAsDirs(false);
                    uRLChooser.setURLFilter(uRLFilter);
                    if (lastExpFolder != null) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastExpFolder));
                    } else {
                        String string = CustomLibrariesManager.this.getApplicationView().getSettings().getDefaultSavePath();
                        if (string != null && string.length() > 0) {
                            uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                        } else {
                            object = CustomLibrariesManager.this.getApplicationView().getUserHomeDirectory();
                            if (object != null) {
                                uRLChooser.setSelectedURL((URL)object);
                            }
                        }
                    }
                    int n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("CustomLibrariesManager.ExportLibraries"));
                    if (n == 0) {
                        object = uRLChooser.getSelectedURL().getPath();
                        int n2 = ((String)object).lastIndexOf(".");
                        if (n2 > -1) {
                            CustomLibrariesManager.this.file = new File(((String)object).substring(0, n2) + ".xml");
                        } else {
                            CustomLibrariesManager.this.file = new File((String)object + ".xml");
                        }
                        if (CustomLibrariesManager.this.file != null) {
                            lastExpFolder = CustomLibrariesManager.this.file.getParentFile();
                            CustomLibrariesManager.this.exportLib();
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(null, Messages.getString("CustomLibrariesManager.NotSavedBeforeExport"), Messages.getString("CustomLibrariesManager.Error"), 0);
                }
            }
        };
        return abstractAction;
    }

    public void exportLib() {
        boolean bl = true;
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
            stringBuffer.append("\n");
            stringBuffer.append("<!-- File contains Custom Libraries Scripts -->");
            stringBuffer.append("\n");
            stringBuffer.append("<").append("custom_libraries").append(">");
            for (DRLibrary dRLibrary : this.customLibrariesContainerList) {
                stringBuffer.append("\n");
                stringBuffer.append("\t").append("<").append("lib").append(' ');
                stringBuffer.append("id=\"").append(dRLibrary.getLibraryId()).append("\"").append(' ');
                stringBuffer.append("name=\"").append(StringUtilities.encodeAttributeValue(dRLibrary.getName())).append("\"").append(' ');
                stringBuffer.append("engine=\"").append(dRLibrary.getEngine()).append("\"").append(' ');
                Iterator<String> iterator = dRLibrary.getFunctions().iterator();
                StringBuffer stringBuffer2 = new StringBuffer();
                while (iterator.hasNext()) {
                    stringBuffer2.append("," + iterator.next());
                }
                stringBuffer.append("methods=\"").append(StringUtilities.encodeAttributeValue(stringBuffer2.toString()).replaceFirst(",", "")).append("\"").append(' ');
                stringBuffer.append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("<").append("script").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t\t").append("<![CDATA[").append(dRLibrary.getScript()).append("]]>");
                stringBuffer.append("\n");
                stringBuffer.append("\t\t").append("</").append("script").append(">");
                stringBuffer.append("\n");
                stringBuffer.append("\t").append("</").append("lib").append(">");
            }
            stringBuffer.append("\n");
            stringBuffer.append("</").append("custom_libraries").append(">");
            if (this.file.exists() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("CustomLibrariesManager.FileExists"), this.file), Messages.getString("CustomLibrariesManager.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                bl = false;
            }
            if (bl) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                outputStreamWriter.write(stringBuffer.toString());
                outputStreamWriter.close();
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("Unable to export libraries: ", runtimeException);
        }
        catch (Exception exception) {
            LOGGER.error("Unable to export libraries: ", exception);
        }
    }

    public class SelectedDRRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -3166272761720379941L;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Color color = null;
            if (jTable.getModel().getValueAt(n, 3).equals("err")) {
                color = Color.RED;
            }
            component.setForeground(color);
            return component;
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CustomLibrariesManager.this.stopCellediting();
            if (CustomLibrariesManager.this.canSave()) {
                for (DRLibrary dRLibrary : CustomLibrariesManager.this.customLibrariesContainerList) {
                    String string = dRLibrary.getLibraryId();
                    for (DRCustomScript dRCustomScript : CustomLibrariesManager.this.appView.getCustomDesignRules()) {
                        if (dRCustomScript.getLibrary() == null || !dRCustomScript.getLibrary().getLibraryId().equalsIgnoreCase(string)) continue;
                        dRCustomScript.setLibrary(dRLibrary);
                    }
                }
                CustomLibrariesManager.this.allLibraries.clear();
                CustomLibrariesManager.this.allLibraries.addAll(CustomLibrariesManager.this.customLibrariesContainerList);
                CustomLibrariesManager.this.bnSave.setEnabled(false);
                CustomLibrariesManager.this.saved = true;
                CustomLibrariesManager.this.appView.saveCustomDRScripts();
            }
        }
    }

    class TFCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        private static final long serialVersionUID = 5665190670341352527L;
        private JTextField tf;
        private String val;
        private JTable tab;

        public TFCellEditor(JTextField jTextField) {
            super(jTextField);
            this.tf = jTextField;
            jTextField.addFocusListener(this);
            super.setClickCountToStart(1);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.tf.setText(object.toString());
            this.tf.selectAll();
            this.tf.setBorder(null);
            this.val = this.tf.getText();
            this.tab = jTable;
            return this.tf;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.tf.selectAll();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public boolean stopCellEditing() {
            JTextField jTextField = (JTextField)this.getComponent();
            String string = jTextField.getText().trim();
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(null, Messages.getString("DesignRuleView.NameEmpty"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                jTextField.setText(this.val);
                jTextField.setBorder(new LineBorder(Color.black));
                jTextField.requestFocusInWindow();
                return false;
            }
            int n = 0;
            TableModel tableModel = this.tab.getModel();
            if (tableModel instanceof CustomRuleModel) {
                for (DRLibrary dRLibrary : ((CustomRuleModel)tableModel).getCustomRulesContainerList()) {
                    if (!dRLibrary.getName().equals(string) || string.equals(this.val)) continue;
                    ++n;
                    JOptionPane.showMessageDialog(null, Messages.getString("DesignRuleView.NameExists"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    jTextField.setText(this.val);
                    jTextField.setBorder(new LineBorder(Color.black));
                    jTextField.requestFocusInWindow();
                    return false;
                }
            } else if (tableModel instanceof FunctionModel) {
                for (String string2 : ((FunctionModel)tableModel).getFunctionsContainerList()) {
                    if (!string2.equals(string) || string.equals(this.val)) continue;
                    ++n;
                    JOptionPane.showMessageDialog(null, Messages.getString("DesignRuleView.NameExists"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    jTextField.setText(this.val);
                    jTextField.setBorder(new LineBorder(Color.black));
                    jTextField.requestFocusInWindow();
                    return false;
                }
            }
            CustomLibrariesManager.this.currentLibrary.setScript(CustomLibrariesManager.this.scriptEditor.getText());
            return super.stopCellEditing();
        }
    }

    private class FunctionModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5810038160110518939L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("CustomDesignRulesManager.Name")};

        private FunctionModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return CustomLibrariesManager.this.methodsList.size();
        }

        public List<String> getFunctionsContainerList() {
            return CustomLibrariesManager.this.methodsList;
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = CustomLibrariesManager.this.methodsList.get(n);
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1) {
                return string;
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                CustomLibrariesManager.this.methodsList.set(n, (String)object);
            }
        }
    }

    private class CustomRuleModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5810038160110518939L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("CustomDesignRulesManager.Name"), Messages.getString("CustomDesignRulesManager.Engine"), "state"};

        private CustomRuleModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return CustomLibrariesManager.this.customLibrariesContainerList.size();
        }

        public List<DRLibrary> getCustomRulesContainerList() {
            return CustomLibrariesManager.this.customLibrariesContainerList;
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return false;
            }
            return n2 != 2 || !this.getValueAt(n, 3).equals("err");
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DRLibrary dRLibrary = CustomLibrariesManager.this.customLibrariesContainerList.get(n);
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1) {
                return dRLibrary.getName();
            }
            if (n2 == 2) {
                return dRLibrary.getEngine();
            }
            if (n2 == 3) {
                if (dRLibrary.getEngine() != null) {
                    for (String string : CustomLibrariesManager.this.allEngines) {
                        if (!string.equals(dRLibrary.getEngine())) continue;
                        return "ok";
                    }
                    return "err";
                }
                return "ok";
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            DRLibrary dRLibrary = CustomLibrariesManager.this.customLibrariesContainerList.get(n);
            if (n2 == 1) {
                dRLibrary.setName(object.toString());
            } else if (n2 == 2) {
                dRLibrary.setEngine((String)object);
            }
        }
    }
}

