/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRCustomValidationScript;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomDesignRulesPersistence {
    public static final String DRCS_FILE_NAME = "dr_custom_scripts.xml";
    private ApplicationView appView;
    private static final Logger LOGGER = new Logger(XMLPersistenceManager.class);

    public CustomDesignRulesPersistence(ApplicationView applicationView) {
        this.appView = applicationView;
    }

    public void saveCustomDRScripts() {
        Object object;
        Iterator<DRCustomScript> iterator = this.appView.getCustomDesignRules().iterator();
        StringBuffer stringBuffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
        stringBuffer.append("\n");
        stringBuffer.append("<").append("dr_custom_scripts").append(">");
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuffer.append("\n");
            stringBuffer.append("\t").append("<").append("scr").append(' ');
            stringBuffer.append("id=\"").append(((DRCustomScript)object).getRuleId()).append("\"").append(' ');
            stringBuffer.append("name=\"").append(StringUtilities.encodeAttributeValue(((DRCustomScript)object).getName())).append("\"").append(' ');
            stringBuffer.append("object=\"").append(((DRCustomScript)object).getObject()).append("\"").append(' ');
            stringBuffer.append("engine=\"").append(((DRCustomScript)object).getEngineName()).append("\"").append(' ');
            stringBuffer.append("type=\"").append(((DRCustomScript)object).getResultType() != null ? ((DRCustomScript)object).getResultType() : "").append("\"").append(' ');
            stringBuffer.append("var=\"").append(((DRCustomScript)object).getVariable()).append("\"").append(' ');
            stringBuffer.append("library=\"").append(StringUtilities.encodeAttributeValue(((DRCustomScript)object).getLibrary() != null ? ((DRCustomScript)object).getLibrary().getName() : "")).append("\"").append(' ');
            stringBuffer.append("method=\"").append(StringUtilities.encodeAttributeValue(((DRCustomScript)object).getFunction() != null ? ((DRCustomScript)object).getFunction() : "")).append("\"").append(' ');
            stringBuffer.append("purpose=\"").append(StringUtilities.encodeAttributeValue(((DRCustomScript)object).getPurpose())).append("\"").append(' ');
            stringBuffer.append(">");
            stringBuffer.append("\n");
            stringBuffer.append("\t\t").append("<").append("script").append(">");
            stringBuffer.append("\n");
            stringBuffer.append("\t\t\t").append("<![CDATA[").append(((DRCustomScript)object).getScript() != null ? ((DRCustomScript)object).getScript() : "").append("]]>");
            stringBuffer.append("\n");
            stringBuffer.append("\t\t").append("</").append("script").append(">");
            stringBuffer.append("\n");
            stringBuffer.append("\t").append("</").append("scr").append(">");
        }
        object = this.appView.getCustomLibraries().iterator();
        stringBuffer.append("\n");
        while (object.hasNext()) {
            DRLibrary dRLibrary = (DRLibrary)object.next();
            stringBuffer.append("\n");
            stringBuffer.append("\t").append("<").append("lib").append(' ');
            stringBuffer.append("id=\"").append(dRLibrary.getLibraryId()).append("\"").append(' ');
            stringBuffer.append("name=\"").append(StringUtilities.encodeAttributeValue(dRLibrary.getName())).append("\"").append(' ');
            stringBuffer.append("engine=\"").append(dRLibrary.getEngine()).append("\"").append(' ');
            Iterator<String> iterator2 = dRLibrary.getFunctions().iterator();
            StringBuffer stringBuffer2 = new StringBuffer();
            while (iterator2.hasNext()) {
                stringBuffer2.append("," + iterator2.next());
            }
            stringBuffer.append("methods=\"").append(StringUtilities.encodeAttributeValue(stringBuffer2.toString()).replaceFirst(",", "")).append("\"").append(' ');
            stringBuffer.append(">");
            stringBuffer.append("\n");
            stringBuffer.append("\t\t").append("<").append("script").append(">");
            stringBuffer.append("\n");
            stringBuffer.append("\t\t\t").append("<![CDATA[").append(dRLibrary.getScript()).append("]]>");
            stringBuffer.append("\n");
            stringBuffer.append("\t\t").append("</").append("script").append(">");
            stringBuffer.append("\n");
            stringBuffer.append("\t").append("</").append("lib").append(">");
        }
        stringBuffer.append("\n");
        stringBuffer.append("</").append("dr_custom_scripts").append(">");
        this.saveData(stringBuffer);
    }

    private void saveData(StringBuffer stringBuffer) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(XMLTransformationManager.getDefaultSystemTypesPath(), DRCS_FILE_NAME));
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            outputStreamWriter.write(stringBuffer.toString());
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            LOGGER.error("Unable to save Design Rule Custom Scripts: ", exception);
        }
    }

    public void loadCustomDRScripts(Settings settings) {
        try {
            File file = new File(XMLTransformationManager.getDefaultSystemTypesPath(settings), DRCS_FILE_NAME);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                InputSource inputSource = new InputSource(inputStreamReader);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputSource);
                this.loadData(document);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Unable to load Design Rule Custom Scripts: ", exception);
        }
    }

    private void loadData(Document document) {
        CharSequence charSequence;
        Object object;
        Object object2;
        ArrayList<DRLibrary> arrayList = new ArrayList<DRLibrary>();
        NodeList nodeList = document.getElementsByTagName("lib");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            object2 = (Element)nodeList.item(i);
            DRLibrary dRLibrary = new DRLibrary(object2.getAttribute(StringUtilities.decodeAttributeValue("name")), object2.getAttribute("id"));
            dRLibrary.setEngine(object2.getAttribute("engine"));
            dRLibrary.setFunctions(new ArrayList<String>());
            dRLibrary.setScriptEngineManager(this.appView.getScriptEngineManager());
            StringTokenizer stringTokenizer = new StringTokenizer(StringUtilities.decodeAttributeValue(object2.getAttribute("methods")), ",");
            while (stringTokenizer.hasMoreTokens()) {
                dRLibrary.getFunctions().add(stringTokenizer.nextToken());
            }
            object = object2.getChildNodes();
            charSequence = new StringBuffer();
            for (int j = 0; j < object.getLength(); ++j) {
                Iterator<DRLibrary> iterator = object.item(j);
                ((StringBuffer)charSequence).append(iterator.getTextContent());
            }
            dRLibrary.setScript(((StringBuffer)charSequence).toString().trim());
            arrayList.add(dRLibrary);
        }
        this.appView.getCustomLibraries().clear();
        this.appView.getCustomLibraries().addAll(arrayList);
        ArrayList<DRCustomScript> arrayList2 = new ArrayList<DRCustomScript>();
        object2 = document.getElementsByTagName("scr");
        int n2 = object2.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node;
            int n3;
            StringBuffer stringBuffer;
            DRCustomScript dRCustomScript;
            object = (Element)object2.item(i);
            charSequence = object.getAttribute("purpose");
            if (((String)charSequence).equals("transformation")) {
                dRCustomScript = new DRCustomScript(object.getAttribute(StringUtilities.decodeAttributeValue("name")), object.getAttribute("id"), object.getAttribute("purpose"));
                dRCustomScript.setObject(object.getAttribute("object"));
                dRCustomScript.setEngineName(object.getAttribute("engine"));
                dRCustomScript.setResultType(object.getAttribute("type"));
                dRCustomScript.setVariable(object.getAttribute("var"));
                for (DRLibrary dRLibrary : this.appView.getCustomLibraries()) {
                    if (!dRLibrary.getName().equals(StringUtilities.decodeAttributeValue(object.getAttribute("library")))) continue;
                    dRCustomScript.setLibrary(dRLibrary);
                    break;
                }
                dRCustomScript.setFunction(StringUtilities.decodeAttributeValue(object.getAttribute("method")));
                dRCustomScript.setScriptEngineManager(this.appView.getScriptEngineManager());
                NodeList nodeList2 = object.getChildNodes();
                stringBuffer = new StringBuffer();
                for (n3 = 0; n3 < nodeList2.getLength(); ++n3) {
                    node = nodeList2.item(n3);
                    stringBuffer.append(node.getTextContent());
                }
                dRCustomScript.setScript(stringBuffer.toString().trim());
                arrayList2.add(dRCustomScript);
                continue;
            }
            if (!((String)charSequence).equals("validation")) continue;
            dRCustomScript = new DRCustomValidationScript(object.getAttribute(StringUtilities.decodeAttributeValue("name")), object.getAttribute("id"), object.getAttribute("purpose"));
            dRCustomScript.setObject(object.getAttribute("object"));
            dRCustomScript.setEngineName(object.getAttribute("engine"));
            dRCustomScript.setResultType(object.getAttribute("type"));
            dRCustomScript.setVariable(object.getAttribute("var"));
            for (DRLibrary dRLibrary : this.appView.getCustomLibraries()) {
                if (!dRLibrary.getName().equals(StringUtilities.decodeAttributeValue(object.getAttribute("library")))) continue;
                dRCustomScript.setLibrary(dRLibrary);
                break;
            }
            dRCustomScript.setFunction(StringUtilities.decodeAttributeValue(object.getAttribute("method")));
            dRCustomScript.setScriptEngineManager(this.appView.getScriptEngineManager());
            NodeList nodeList3 = object.getChildNodes();
            stringBuffer = new StringBuffer();
            for (n3 = 0; n3 < nodeList3.getLength(); ++n3) {
                node = nodeList3.item(n3);
                stringBuffer.append(node.getTextContent());
            }
            dRCustomScript.setScript(stringBuffer.toString().trim());
            arrayList2.add(dRCustomScript);
        }
        this.appView.getCustomDesignRules().clear();
        this.appView.getCustomDesignRules().addAll(arrayList2);
    }

    public Element getFirstElementByTagName(String string, Element element) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            return element2;
        }
        return null;
    }
}

