/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.SequenceUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.StagingTableUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionUDBv71;

public class DDLSelectionUDBv81
extends DDLSelectionUDBv71 {
    private static final String SEQUENCES = Messages.getString("DDLSelectionUDBv81.Sequences");
    private static final String STAGING_TABLES = Messages.getString("DDLSelectionUDBv81.StagingTables");
    private List sequenceList;

    public DDLSelectionUDBv81(StorageDesign storageDesign) {
        super(storageDesign);
    }

    public DDLSelectionUDBv81(StorageDesign storageDesign, DesignPartView designPartView) {
        super(storageDesign, designPartView);
    }

    @Override
    protected void addSchemaDetails(SchemaUDB schemaUDB, ModelIdObjectSelection modelIdObjectSelection) {
        super.addSchemaDetails(schemaUDB, modelIdObjectSelection);
        if (this.getSequenceForSchema(schemaUDB).size() > 0) {
            this.addContainerObjects(SEQUENCES, modelIdObjectSelection, this.getSequenceForSchema(schemaUDB), this.getSequenceList());
        }
    }

    @Override
    protected void addNotAssignedToSchema(String string, ModelIdObjectSelection modelIdObjectSelection) {
        super.addNotAssignedToSchema(string, modelIdObjectSelection);
        for (ModelIdObjectSelection modelIdObjectSelection2 : modelIdObjectSelection.getChilds()) {
            if (!modelIdObjectSelection2.getName().equalsIgnoreCase(string)) continue;
            this.addContainerObjects(SEQUENCES, modelIdObjectSelection2, this.getSequenceWithoutSchema(), this.getSequenceList());
            modelIdObjectSelection2.sort();
        }
    }

    private List getSequenceForSchema(SchemaUDB schemaUDB) {
        ArrayList<SequenceUDB> arrayList = new ArrayList<SequenceUDB>();
        Iterator iterator = ((StorageDesignUDBv81)this.getStorageDesign()).getSequenceSet().iterator();
        while (iterator.hasNext()) {
            SequenceUDB sequenceUDB = (SequenceUDB)iterator.next();
            if (sequenceUDB.getSchema() == null || !sequenceUDB.getSchema().getObjectID().equalsIgnoreCase(schemaUDB.getObjectID())) continue;
            arrayList.add(sequenceUDB);
        }
        return arrayList;
    }

    private List getSequenceWithoutSchema() {
        ArrayList<SequenceUDB> arrayList = new ArrayList<SequenceUDB>();
        Iterator iterator = ((StorageDesignUDBv81)this.getStorageDesign()).getSequenceSet().iterator();
        while (iterator.hasNext()) {
            SequenceUDB sequenceUDB = (SequenceUDB)iterator.next();
            if (sequenceUDB.getSchema() != null) continue;
            arrayList.add(sequenceUDB);
        }
        return arrayList;
    }

    @Override
    protected void addTableProxyDetails(TableProxyUDB tableProxyUDB, ModelIdObjectSelection modelIdObjectSelection) {
        super.addTableProxyDetails(tableProxyUDB, modelIdObjectSelection);
        if (this.getStagingTablesForTable(tableProxyUDB).size() > 0) {
            this.addObjects(STAGING_TABLES, modelIdObjectSelection, this.getStagingTablesForTable(tableProxyUDB));
        }
    }

    private List getStagingTablesForTable(TableProxyUDB tableProxyUDB) {
        ArrayList<StagingTableUDBv81> arrayList = new ArrayList<StagingTableUDBv81>();
        Iterator iterator = ((StorageDesignUDBv81)this.getStorageDesign()).getStagingTableSet().iterator();
        while (iterator.hasNext()) {
            StagingTableUDBv81 stagingTableUDBv81 = (StagingTableUDBv81)iterator.next();
            if (stagingTableUDBv81.getTable() == null || !stagingTableUDBv81.getTable().getObjectID().equalsIgnoreCase(tableProxyUDB.getObjectID())) continue;
            arrayList.add(stagingTableUDBv81);
        }
        return arrayList;
    }

    public List getSequenceList() {
        if (this.sequenceList == null) {
            this.sequenceList = new ArrayList();
        }
        return this.sequenceList;
    }
}

