/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerSetDB2;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.AliasUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.NodeGroupUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.ContainerUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionLists;

public class DDLSelectionUDBv71
extends ModelIdObjectSelection
implements DDLSelectionLists {
    private static final String ALIASES = Messages.getString("DDLSelectionUDBv71.Aliases");
    private static final String DATABASES = Messages.getString("DDLSelectionUDBv71.Databases");
    private static final String NODEGROUPS = Messages.getString("DDLSelectionUDBv71.Nodegroups");
    private static final String ASSIGNED_TO_SCHEMAS = Messages.getString("DDLSelectionRelational.AssignedToSchemas");
    private static final String NOT_ASSIGNED_TO_SCHEMAS = Messages.getString("DDLSelectionRelational.NotAssignedToSchemas");
    private static final String SCHEMAS = Messages.getString("DDLSelectionUDBv71.Schemas");
    private static final String BUFFERPOOLS = Messages.getString("DDLSelectionUDBv71.BufferPools");
    private static final String STORED_PROCEDURES = Messages.getString("DDLSelectionUDBv71.StoredProcedures");
    private static final String STRUCTURED_TYPES = Messages.getString("DDLSelectionUDBv71.StructuredTypes");
    private static final String TABLES = Messages.getString("DDLSelectionUDBv71.Tables");
    private static final String TABLESPACES = Messages.getString("DDLSelectionUDBv71.Tablespaces");
    private static final String VIEWS = Messages.getString("DDLSelectionUDBv71.Views");
    private static final String DBPARTITIONS = Messages.getString("DDLSelectionUDBv71.DBPartitions");
    private static final String CONSTRAINTS = Messages.getString("DDLSelectionUDBv71.PKUKConstraints");
    private static final String INDEXES = Messages.getString("DDLSelectionUDBv71.Indexes");
    private static final String FOREIGN_KEYS = Messages.getString("DDLSelectionUDBv71.ForeignKeys");
    private static final String TRIGGERS = Messages.getString("DDLSelectionUDBv71.Triggers");
    private StorageDesign design;
    private RelationalDesign phdes;
    private List triggerList;
    private List aliasList;
    private List storedProcedureList;
    private List typeList;
    private DesignPartView selectedSubView = null;

    public DDLSelectionUDBv71(StorageDesign storageDesign) {
        super(storageDesign.getName());
        this.design = storageDesign;
        this.phdes = storageDesign.getPhysicalDesign();
        if (storageDesign.isOpen()) {
            this.setElementDescriptor(storageDesign.getClass());
            this.addFromStorageDesign();
        } else {
            this.setName(this.phdes.getName());
            this.addCommonObjectsFromRelationalModel(this.phdes, this.selectedSubView);
            this.addSpecificObjectsFromRelationalModel();
        }
    }

    public DDLSelectionUDBv71(StorageDesign storageDesign, DesignPartView designPartView) {
        super(storageDesign.getName());
        this.design = storageDesign;
        this.selectedSubView = designPartView;
        this.phdes = storageDesign.getPhysicalDesign();
        if (storageDesign.isOpen()) {
            this.setElementDescriptor(storageDesign.getClass());
            this.addFromStorageDesign();
        } else if (designPartView != null) {
            this.setName(designPartView.getName());
            this.addCommonObjectsFromRelationalModel(this.phdes, designPartView);
            this.addSpecificObjectsFromRelationalModel();
        }
    }

    private void addFromStorageDesign() {
        this.addObjects(DATABASES, this, this.getStorageDesign().getDataBaseSet().getElementsList());
        this.addObjects(TABLESPACES, this, this.getStorageDesign().getTableSpaceSet().getElementsList());
        this.addNotNulObjects(BUFFERPOOLS, this, this.getStorageDesign().getBufferPoolSet().getElementsList());
        if (this.getStorageDesign() instanceof StorageDesignUDBv71) {
            this.addNotNulObjects(NODEGROUPS, this, this.getStorageDesign().getNodeGroupSet().getElementsList());
        } else if (this.getStorageDesign() instanceof StorageDesignUDBv81) {
            this.addNotNulObjects(DBPARTITIONS, this, this.getStorageDesign().getNodeGroupSet().getElementsList());
        }
        this.addNotNulObjects(SCHEMAS, this, this.getStorageDesign().getSchemaSet().getElementsList());
        this.addAssignedToSchema(ASSIGNED_TO_SCHEMAS, this, this.getStorageDesign().getSchemaSet().getElementsList());
        this.addNotAssignedToSchema(NOT_ASSIGNED_TO_SCHEMAS, this);
        this.sort();
    }

    protected void addObjects(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        if (list.size() > 0) {
            this.putNodeIcon(modelIdObjectSelection2, string);
            for (Object e : list) {
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection((ModelIDObject)e);
                modelIdObjectSelection2.setElementDescriptor(e.getClass());
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    private void addNotNulObjects(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        if (list.size() > 0) {
            this.putNodeIcon(modelIdObjectSelection2, string);
            for (StorageObject storageObject : list) {
                if (storageObject.isNullInstance()) continue;
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(storageObject);
                modelIdObjectSelection2.setElementDescriptor(storageObject.getClass());
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            }
            if (modelIdObjectSelection2.getChilds().size() > 0) {
                modelIdObjectSelection.addChild(modelIdObjectSelection2);
            }
        }
    }

    private void addAssignedToSchema(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        Iterator iterator;
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(SchemaUDB.class);
        if (list.size() > 0 && (iterator = list.iterator()).hasNext()) {
            while (iterator.hasNext()) {
                SchemaUDB schemaUDB = (SchemaUDB)iterator.next();
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(schemaUDB.getName());
                this.addSchemaDetails(schemaUDB, modelIdObjectSelection3);
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    protected void addSchemaDetails(SchemaUDB schemaUDB, ModelIdObjectSelection modelIdObjectSelection) {
        if (this.getAliasForSchema(schemaUDB).size() > 0) {
            this.addContainerObjects(ALIASES, modelIdObjectSelection, this.getAliasForSchema(schemaUDB), this.getAliasList());
        }
        if (this.getStoredProcedureForSchema(schemaUDB).size() > 0) {
            this.addContainerObjects(STORED_PROCEDURES, modelIdObjectSelection, this.getStoredProcedureForSchema(schemaUDB), this.getStoredProcedureList());
        }
        if (this.getTypeForSchema(schemaUDB).size() > 0) {
            this.addStructuredType(STRUCTURED_TYPES, modelIdObjectSelection, this.getTypeForSchema(schemaUDB), this.getTypeList());
        }
        if (this.getTableForSchema(schemaUDB).size() > 0) {
            this.addTable(TABLES, modelIdObjectSelection, this.getTableForSchema(schemaUDB));
        }
        if (this.getViewForSchema(schemaUDB).size() > 0) {
            this.addView(VIEWS, modelIdObjectSelection, this.getViewForSchema(schemaUDB));
        }
    }

    protected void addContainerObjects(String string, ModelIdObjectSelection modelIdObjectSelection, List list, List list2) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        if (list.size() > 0) {
            this.putNodeIcon(modelIdObjectSelection2, string);
            for (Object e : list) {
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection((ModelIDObject)e);
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
                list2.add(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    protected void addNotAssignedToSchema(String string, ModelIdObjectSelection modelIdObjectSelection) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(SchemaSetUDB.class);
        this.addContainerObjects(ALIASES, modelIdObjectSelection2, this.getAliasWithoutSchema(), this.getAliasList());
        this.addContainerObjects(STORED_PROCEDURES, modelIdObjectSelection2, this.getStoredProcedureWithoutSchema(), this.getStoredProcedureList());
        this.addStructuredType(STRUCTURED_TYPES, modelIdObjectSelection2, this.getTypeWithoutSchema(), this.getTypeList());
        this.addTable(TABLES, modelIdObjectSelection2, this.getTableWithoutSchema());
        this.addView(VIEWS, modelIdObjectSelection2, this.getViewWithoutSchema());
        modelIdObjectSelection2.sort();
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    private void addStructuredType(String string, ModelIdObjectSelection modelIdObjectSelection, List list, List list2) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        if (list.size() > 0) {
            modelIdObjectSelection2.setElementDescriptor(StructuredTypeProxyUDB.class);
            for (StructuredTypeProxyUDB structuredTypeProxyUDB : list) {
                if (structuredTypeProxyUDB.getStructuredType().isPredefined()) continue;
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(structuredTypeProxyUDB);
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
                list2.add(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    private void addTable(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        if (list.size() > 0) {
            modelIdObjectSelection2.setElementDescriptor(TableSet.class);
            for (TableProxyUDB tableProxyUDB : list) {
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(tableProxyUDB);
                this.addTableProxyDetails(tableProxyUDB, modelIdObjectSelection3);
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
                this.getTableList().add(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    private void addView(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        if (list.size() > 0) {
            modelIdObjectSelection2.setElementDescriptor(TableViewSet.class);
            for (TableViewProxyUDB tableViewProxyUDB : list) {
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(tableViewProxyUDB);
                if (this.getStorageDesign() instanceof StorageDesignUDBv81) {
                    this.addContainerObjects(TRIGGERS, modelIdObjectSelection3, this.getTriggerForView(tableViewProxyUDB), this.getTriggerList());
                }
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
                this.getViewList().add(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    protected void addTableProxyDetails(TableProxyUDB tableProxyUDB, ModelIdObjectSelection modelIdObjectSelection) {
        List list = null;
        if (((Table)tableProxyUDB.getObject()).getPKandUKConstraints().size() > 0) {
            this.addContainerObjects(CONSTRAINTS, modelIdObjectSelection, ((Table)tableProxyUDB.getObject()).getPKandUKConstraints(), this.getConstraintList());
        }
        if (tableProxyUDB.getIndexes().size() > 0) {
            this.addContainerObjects(INDEXES, modelIdObjectSelection, tableProxyUDB.getIndexes().getElementsList(), this.getIndexList());
        }
        StorageObject storageObject = null;
        list = this.getObjectForTable(tableProxyUDB, this.getStorageDesign().getFKProxySet().getElements(), storageObject);
        if (list.size() > 0) {
            this.addContainerObjects(FOREIGN_KEYS, modelIdObjectSelection, list, this.getFkList());
        }
        StorageObject storageObject2 = null;
        list = this.getObjectForTable(tableProxyUDB, this.getStorageDesign().getTriggerSet().getElementsList(), storageObject2);
        if (list.size() > 0) {
            this.addContainerObjects(TRIGGERS, modelIdObjectSelection, list, this.getTriggerList());
        }
    }

    private List getObjectForTable(TableProxyUDB tableProxyUDB, List list, StorageObject storageObject2) {
        ArrayList<StorageObject> arrayList = new ArrayList<StorageObject>();
        for (StorageObject storageObject2 : list) {
            Object object = null;
            if (storageObject2.getParent() instanceof StorageObjectCollection) {
                object = ((StorageObjectCollection)storageObject2.getParent()).getParent();
            }
            if (storageObject2.getParent() instanceof StorageObjectSet) {
                object = ((StorageObjectSet)storageObject2.getParent()).getParent();
            }
            if (object == null || !(object instanceof TableProxyUDB) || !((TableProxyUDB)object).getObjectID().equalsIgnoreCase(tableProxyUDB.getObjectID())) continue;
            arrayList.add(storageObject2);
        }
        return arrayList;
    }

    private List getTriggerForView(TableViewProxyUDB tableViewProxyUDB) {
        ArrayList<TriggerUDBv81> arrayList = new ArrayList<TriggerUDBv81>();
        Iterator iterator = this.getStorageDesign().getTriggerSet().iterator();
        while (iterator.hasNext()) {
            TriggerUDBv81 triggerUDBv81 = (TriggerUDBv81)iterator.next();
            if (triggerUDBv81.getView() == null || !triggerUDBv81.getView().getObjectID().equalsIgnoreCase(tableViewProxyUDB.getObjectID())) continue;
            arrayList.add(triggerUDBv81);
        }
        return arrayList;
    }

    private List getAliasForSchema(SchemaUDB schemaUDB) {
        ArrayList<AliasUDB> arrayList = new ArrayList<AliasUDB>();
        Iterator iterator = this.getStorageDesign().getAliasSet().iterator();
        while (iterator.hasNext()) {
            AliasUDB aliasUDB = (AliasUDB)iterator.next();
            if (aliasUDB.getSchema() == null || !aliasUDB.getSchema().getObjectID().equalsIgnoreCase(schemaUDB.getObjectID())) continue;
            arrayList.add(aliasUDB);
        }
        return arrayList;
    }

    private List getAliasWithoutSchema() {
        ArrayList<AliasUDB> arrayList = new ArrayList<AliasUDB>();
        Iterator iterator = this.getStorageDesign().getAliasSet().iterator();
        while (iterator.hasNext()) {
            AliasUDB aliasUDB = (AliasUDB)iterator.next();
            if (aliasUDB.getSchema() != null) continue;
            arrayList.add(aliasUDB);
        }
        return arrayList;
    }

    private List getStoredProcedureForSchema(SchemaUDB schemaUDB) {
        ArrayList<StoredProcedureUDB> arrayList = new ArrayList<StoredProcedureUDB>();
        Iterator iterator = this.getStorageDesign().getStoredProcedureSet().iterator();
        while (iterator.hasNext()) {
            StoredProcedureUDB storedProcedureUDB = (StoredProcedureUDB)iterator.next();
            if (storedProcedureUDB.getSchema() == null || !storedProcedureUDB.getSchema().getObjectID().equalsIgnoreCase(schemaUDB.getObjectID())) continue;
            arrayList.add(storedProcedureUDB);
        }
        return arrayList;
    }

    private List getStoredProcedureWithoutSchema() {
        ArrayList<StoredProcedureUDB> arrayList = new ArrayList<StoredProcedureUDB>();
        Iterator iterator = this.getStorageDesign().getStoredProcedureSet().iterator();
        while (iterator.hasNext()) {
            StoredProcedureUDB storedProcedureUDB = (StoredProcedureUDB)iterator.next();
            if (storedProcedureUDB.getSchema() != null) continue;
            arrayList.add(storedProcedureUDB);
        }
        return arrayList;
    }

    private List getTypeForSchema(SchemaUDB schemaUDB) {
        ArrayList<StructuredTypeProxyUDB> arrayList = new ArrayList<StructuredTypeProxyUDB>();
        Iterator iterator = this.getStorageDesign().getStructuredTypeProxySet().iterator();
        while (iterator.hasNext()) {
            StructuredTypeProxyUDB structuredTypeProxyUDB = (StructuredTypeProxyUDB)iterator.next();
            if (structuredTypeProxyUDB.getSchema() == null || !structuredTypeProxyUDB.getSchema().getObjectID().equalsIgnoreCase(schemaUDB.getObjectID())) continue;
            arrayList.add(structuredTypeProxyUDB);
        }
        return arrayList;
    }

    private List getTypeWithoutSchema() {
        ArrayList<StructuredTypeProxyUDB> arrayList = new ArrayList<StructuredTypeProxyUDB>();
        Iterator iterator = this.getStorageDesign().getStructuredTypeProxySet().iterator();
        while (iterator.hasNext()) {
            StructuredTypeProxyUDB structuredTypeProxyUDB = (StructuredTypeProxyUDB)iterator.next();
            if (structuredTypeProxyUDB.getSchema() != null) continue;
            arrayList.add(structuredTypeProxyUDB);
        }
        return arrayList;
    }

    private List getTableForSchema(SchemaUDB schemaUDB) {
        ArrayList<TableProxyUDB> arrayList = new ArrayList<TableProxyUDB>();
        Iterator iterator = this.selectedSubView != null ? this.getStorageDesign().getSubViewTableProxySet().iterator() : this.getStorageDesign().getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxyUDB tableProxyUDB = (TableProxyUDB)iterator.next();
            if (tableProxyUDB.getSchema() == null || !tableProxyUDB.getSchema().getObjectID().equalsIgnoreCase(schemaUDB.getObjectID())) continue;
            arrayList.add(tableProxyUDB);
        }
        return arrayList;
    }

    private List getTableWithoutSchema() {
        ArrayList<TableProxyUDB> arrayList = new ArrayList<TableProxyUDB>();
        Iterator iterator = this.selectedSubView != null ? this.getStorageDesign().getSubViewTableProxySet().iterator() : this.getStorageDesign().getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxyUDB tableProxyUDB = (TableProxyUDB)iterator.next();
            if (tableProxyUDB.getSchema() != null) continue;
            arrayList.add(tableProxyUDB);
        }
        return arrayList;
    }

    private List getViewForSchema(SchemaUDB schemaUDB) {
        ArrayList<TableViewProxyUDB> arrayList = new ArrayList<TableViewProxyUDB>();
        Iterator iterator = this.selectedSubView != null ? this.getStorageDesign().getSubViewTableViewProxySet().iterator() : this.getStorageDesign().getTableViewProxySet().iterator();
        while (iterator.hasNext()) {
            TableViewProxyUDB tableViewProxyUDB = (TableViewProxyUDB)iterator.next();
            if (tableViewProxyUDB.getSchema() == null || !tableViewProxyUDB.getSchema().getObjectID().equalsIgnoreCase(schemaUDB.getObjectID())) continue;
            arrayList.add(tableViewProxyUDB);
        }
        return arrayList;
    }

    private List getViewWithoutSchema() {
        ArrayList<TableViewProxyUDB> arrayList = new ArrayList<TableViewProxyUDB>();
        Iterator iterator = this.selectedSubView != null ? this.getStorageDesign().getSubViewTableViewProxySet().iterator() : this.getStorageDesign().getTableViewProxySet().iterator();
        while (iterator.hasNext()) {
            TableViewProxyUDB tableViewProxyUDB = (TableViewProxyUDB)iterator.next();
            if (tableViewProxyUDB.getSchema() != null) continue;
            arrayList.add(tableViewProxyUDB);
        }
        return arrayList;
    }

    public List getTriggerList() {
        if (this.triggerList == null) {
            this.triggerList = new ArrayList();
        }
        return this.triggerList;
    }

    public List getAliasList() {
        if (this.aliasList == null) {
            this.aliasList = new ArrayList();
        }
        return this.aliasList;
    }

    public List getStoredProcedureList() {
        if (this.storedProcedureList == null) {
            this.storedProcedureList = new ArrayList();
        }
        return this.storedProcedureList;
    }

    public List getTypeList() {
        if (this.typeList == null) {
            this.typeList = new ArrayList();
        }
        return this.typeList;
    }

    protected StorageDesignUDB getStorageDesign() {
        return (StorageDesignUDB)this.design;
    }

    private void addSpecificObjectsFromRelationalModel() {
        Iterator iterator = ((StorageDesignUDB)this.design).getStructuredTypeProxySet().iterator();
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("DDLSelectionUDBv71.StructuredTypes"));
        modelIdObjectSelection.setElementDescriptor(StructuredTypeProxyOracle.class);
        while (iterator.hasNext()) {
            StructuredTypeProxyUDB structuredTypeProxyUDB = (StructuredTypeProxyUDB)iterator.next();
            if (((StructuredType)structuredTypeProxyUDB.getObject()).isPredefined()) continue;
            ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(structuredTypeProxyUDB);
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
        this.addChild(modelIdObjectSelection);
    }

    private void putNodeIcon(ModelIdObjectSelection modelIdObjectSelection, String string) {
        DDLTreeNodeName dDLTreeNodeName = DDLTreeNodeName.fromString(string);
        if (dDLTreeNodeName != null) {
            switch (DDLTreeNodeName.fromString(string)) {
                case NN_STORED_PROCEDURES: {
                    modelIdObjectSelection.setElementDescriptor(StoredProcedureSetDB2.class);
                    break;
                }
                case NN_INDEXES: {
                    modelIdObjectSelection.setElementDescriptor(IndexSet.class);
                    break;
                }
                case NN_FOREIGN_KEYS: {
                    modelIdObjectSelection.setElementDescriptor(FKIndexAssociationSet.class);
                    break;
                }
                case NN_TRIGGERS: {
                    modelIdObjectSelection.setElementDescriptor(TriggerSetDB2.class);
                    break;
                }
                case NN_TABLESPACES: {
                    modelIdObjectSelection.setElementDescriptor(TableSpaceDB2.class);
                    break;
                }
                case NN_SCHEMAS: {
                    modelIdObjectSelection.setElementDescriptor(SchemaSetSqlServerv2k5.class);
                    break;
                }
                case NN_BUFFERPOOLS: {
                    modelIdObjectSelection.setElementDescriptor(ContainerUDBv81.class);
                    break;
                }
                case NN_NODEGROUPS: {
                    modelIdObjectSelection.setElementDescriptor(NodeGroupUDBv71.class);
                    break;
                }
                case NN_DBPARTITIONS: {
                    modelIdObjectSelection.setElementDescriptor(PartitionDB2.class);
                    break;
                }
                case NN_DATABASES: {
                    modelIdObjectSelection.setElementDescriptor(StorageDesignUDBv71.class);
                    break;
                }
                case NN_ALIASES: {
                    modelIdObjectSelection.setElementDescriptor(AliasDB2.class);
                    break;
                }
                case NN_STOREDPROCEDURES: {
                    modelIdObjectSelection.setElementDescriptor(StoredProcedureSetDB2.class);
                    break;
                }
                case NN_CONSTRAINTS: {
                    modelIdObjectSelection.setElementDescriptor(Constraint.class);
                    break;
                }
            }
        }
    }

    static /* synthetic */ String access$000() {
        return TABLESPACES;
    }

    static /* synthetic */ String access$100() {
        return STORED_PROCEDURES;
    }

    static /* synthetic */ String access$200() {
        return INDEXES;
    }

    static /* synthetic */ String access$300() {
        return FOREIGN_KEYS;
    }

    static /* synthetic */ String access$400() {
        return TRIGGERS;
    }

    static /* synthetic */ String access$500() {
        return BUFFERPOOLS;
    }

    static /* synthetic */ String access$600() {
        return NODEGROUPS;
    }

    static /* synthetic */ String access$700() {
        return DBPARTITIONS;
    }

    static /* synthetic */ String access$800() {
        return SCHEMAS;
    }

    static /* synthetic */ String access$900() {
        return DATABASES;
    }

    static /* synthetic */ String access$1000() {
        return ALIASES;
    }

    static /* synthetic */ String access$1100() {
        return CONSTRAINTS;
    }

    private static enum DDLTreeNodeName {
        NN_TABLESPACES(DDLSelectionUDBv71.access$000()),
        NN_STORED_PROCEDURES(DDLSelectionUDBv71.access$100()),
        NN_INDEXES(DDLSelectionUDBv71.access$200()),
        NN_FOREIGN_KEYS(DDLSelectionUDBv71.access$300()),
        NN_TRIGGERS(DDLSelectionUDBv71.access$400()),
        NN_BUFFERPOOLS(DDLSelectionUDBv71.access$500()),
        NN_NODEGROUPS(DDLSelectionUDBv71.access$600()),
        NN_DBPARTITIONS(DDLSelectionUDBv71.access$700()),
        NN_SCHEMAS(DDLSelectionUDBv71.access$800()),
        NN_DATABASES(DDLSelectionUDBv71.access$900()),
        NN_ALIASES(DDLSelectionUDBv71.access$1000()),
        NN_STOREDPROCEDURES(DDLSelectionUDBv71.access$100()),
        NN_CONSTRAINTS(DDLSelectionUDBv71.access$1100());

        private String name;

        private DDLTreeNodeName(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public static DDLTreeNodeName fromString(String string) {
            if (string != null) {
                for (DDLTreeNodeName dDLTreeNodeName : DDLTreeNodeName.values()) {
                    if (!string.equals(dDLTreeNodeName.name)) continue;
                    return dDLTreeNodeName;
                }
            }
            return null;
        }
    }
}

