/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DistinctTypeProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SynonymSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UsedUserDefinedData;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.XMLSchemaCollectionSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.SchemaSetUDB;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionSqlServerv2k;

public class DDLSelectionSqlServerv2k5
extends DDLSelectionSqlServerv2k {
    private static final String UDDT_DISTINCT_TYPES = Messages.getString("DDLSelectionSqlServerv2k5.UDDTDistinctTypes");
    private static final String UDDT_DOMAINS = Messages.getString("DDLSelectionSqlServerv2k5.UDDTDomains");
    private static final String ASSIGNED_TO_SCHEMA = Messages.getString("DDLSelectionSqlServerv2k5.AssignedToSchema");
    private static final String NOT_ASSIGNED_TO_SCHEMA = Messages.getString("DDLSelectionSqlServerv2k5.NotAssignedToSchema");
    private static final String XML_SCHEMA_COLLECTION = Messages.getString("DDLSelectionSqlServerv2k5.XMLSchemaCollection");
    private static final String SYNONYMS = Messages.getString("DDLSelectionSqlServerv2k5.Synonyms");
    private StorageDesign storageDesign;
    private List distTypeList;
    private List domainTypeList;
    private List collTypeList;
    private List synonymList;
    private DesignPartView selectedSubView = null;

    public DDLSelectionSqlServerv2k5(StorageDesign storageDesign) {
        super(storageDesign);
        this.storageDesign = storageDesign;
    }

    public DDLSelectionSqlServerv2k5(StorageDesign storageDesign, DesignPartView designPartView) {
        super(storageDesign, designPartView);
        this.storageDesign = storageDesign;
        this.selectedSubView = designPartView;
    }

    @Override
    protected void addFromStorageDesign() {
        this.addAssignedToDatabase(ASSIGNED_TO_DATABASE, this);
        this.addLogins(LOGINS, this, this.getStorageDesign().getLoginSet().getElementsList());
        this.addUddtDistinctType(UDDT_DISTINCT_TYPES, this, this.getStorageDesign().getDistinctTypeProxySet().getElements());
        this.addUddtDomain(UDDT_DOMAINS, this, this.getStorageDesign().getUserDefinedTypeSet().getElementsList());
    }

    protected void addAssignedToDatabase(String string, ModelIdObjectSelection modelIdObjectSelection) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(DataBaseSqlServer.class);
        Iterator iterator = this.getStorageDesign().getDataBaseSet().iterator();
        while (iterator.hasNext()) {
            DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)iterator.next();
            ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(dataBaseSqlServer);
            modelIdObjectSelection3.setElementDescriptor(DataBaseSqlServer.class);
            ModelIdObjectSelection modelIdObjectSelection4 = new ModelIdObjectSelection(dataBaseSqlServer.getName());
            modelIdObjectSelection4.setElementDescriptor(DataBaseSqlServer.class);
            if (this.getSchemasForDatabase(dataBaseSqlServer).size() > 0) {
                this.addAssignedToSchema(ASSIGNED_TO_SCHEMA, modelIdObjectSelection4, this.getSchemasForDatabase(dataBaseSqlServer));
            }
            this.addNotAssignedToSchema(NOT_ASSIGNED_TO_SCHEMA, modelIdObjectSelection4, dataBaseSqlServer);
            this.getDatabaseList().add(modelIdObjectSelection3);
            modelIdObjectSelection2.addChild(modelIdObjectSelection4);
        }
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    @Override
    protected void addNotAssignedToDatabase(String string, ModelIdObjectSelection modelIdObjectSelection) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        Iterator iterator = this.getStorageDesign().getDataBaseSet().iterator();
        while (iterator.hasNext()) {
            DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)iterator.next();
            if (!dataBaseSqlServer.isNullInstance()) continue;
            if (this.getSchemasWithNullDatabase().size() > 0) {
                this.addSchemasWithNullDatabase(ASSIGNED_TO_SCHEMA, modelIdObjectSelection2, this.getSchemasWithNullDatabase());
            }
            this.addNotAssignedToSchema(NOT_ASSIGNED_TO_SCHEMA, modelIdObjectSelection2, dataBaseSqlServer);
        }
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    private void addAllWithNullSchema(ModelIdObjectSelection modelIdObjectSelection, DataBaseSqlServer dataBaseSqlServer) {
        this.addTables(TABLES, modelIdObjectSelection, this.getTablesWithNullSchema(dataBaseSqlServer));
        this.addViews(VIEWS, modelIdObjectSelection, this.getViewsWithNullSchema(dataBaseSqlServer));
        this.addContainerObjects(DEFAULTS, modelIdObjectSelection, this.getDefaultsWithNullSchema(dataBaseSqlServer), this.getDefaultList());
        this.addProcedureObjects(STORED_PROCEDURES, modelIdObjectSelection, this.getProceduresWithNullSchema(dataBaseSqlServer), this.getProcedureList());
        this.addContainerObjects(RULES, modelIdObjectSelection, this.getRulesWithNullSchema(dataBaseSqlServer), this.getRuleList());
        this.addContainerObjects(ROLES, modelIdObjectSelection, this.getRoles(dataBaseSqlServer), this.getRoleList());
        this.addContainerObjects(UDDT_DISTINCT_TYPES, modelIdObjectSelection, this.getDistinctTypesWithNullSchema(dataBaseSqlServer), this.getDistTypeList());
        this.addContainerObjects(UDDT_DOMAINS, modelIdObjectSelection, this.getDomainsWithNullSchema(dataBaseSqlServer), this.getDomainTypeList());
        this.addContainerObjects(XML_SCHEMA_COLLECTION, modelIdObjectSelection, this.getXMLCollectionsWithNullSchema(dataBaseSqlServer), this.getCollTypeList());
        this.sort();
    }

    private void addUddtDistinctType(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(StructuredTypeProxy.class);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                DistinctTypeProxySqlServer distinctTypeProxySqlServer = (DistinctTypeProxySqlServer)iterator.next();
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(distinctTypeProxySqlServer);
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    private void addUddtDomain(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(Domain.class);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                UserDefinedTypeSqlServer userDefinedTypeSqlServer = (UserDefinedTypeSqlServer)iterator.next();
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(userDefinedTypeSqlServer);
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    private void addAssignedToSchema(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        for (SchemaSqlServer schemaSqlServer : list) {
            ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(schemaSqlServer.getName());
            ModelIdObjectSelection modelIdObjectSelection4 = new ModelIdObjectSelection(schemaSqlServer);
            this.addSchemaDetails(schemaSqlServer, modelIdObjectSelection3);
            this.getUserList().add(modelIdObjectSelection4);
            modelIdObjectSelection2.addChild(modelIdObjectSelection3);
        }
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    private void addNotAssignedToSchema(String string, ModelIdObjectSelection modelIdObjectSelection, DataBaseSqlServer dataBaseSqlServer) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(SchemaSetUDB.class);
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
        this.addAllWithNullSchema(modelIdObjectSelection2, dataBaseSqlServer);
    }

    private void addSchemasWithNullDatabase(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(SchemaSetSqlServerv2k5.class);
        for (SchemaSqlServer schemaSqlServer : list) {
            ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(schemaSqlServer.getName());
            ModelIdObjectSelection modelIdObjectSelection4 = new ModelIdObjectSelection(schemaSqlServer);
            this.addSchemaDetails(schemaSqlServer, modelIdObjectSelection3);
            this.getUserList().add(modelIdObjectSelection4);
            modelIdObjectSelection2.addChild(modelIdObjectSelection3);
        }
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    protected void addSchemaDetails(SchemaSqlServer schemaSqlServer, ModelIdObjectSelection modelIdObjectSelection) {
        this.addTables(TABLES, modelIdObjectSelection, this.getTablesForSchema(schemaSqlServer));
        this.addViews(VIEWS, modelIdObjectSelection, this.getViewsForSchema(schemaSqlServer));
        this.addContainerObjects(DEFAULTS, modelIdObjectSelection, this.getDefaultsForSchema(schemaSqlServer), this.getDefaultList());
        this.addProcedureObjects(STORED_PROCEDURES, modelIdObjectSelection, this.getProceduresForSchema(schemaSqlServer), this.getProcedureList());
        this.addContainerObjects(RULES, modelIdObjectSelection, this.getRulesForSchema(schemaSqlServer), this.getRuleList());
        this.addContainerObjects(UDDT_DISTINCT_TYPES, modelIdObjectSelection, this.getDistinctTypesForSchema(schemaSqlServer), this.getDistTypeList());
        this.addContainerObjects(UDDT_DOMAINS, modelIdObjectSelection, this.getDomainsForSchema(schemaSqlServer), this.getDomainTypeList());
        this.addContainerObjects(XML_SCHEMA_COLLECTION, modelIdObjectSelection, this.getXMLCollectionsForSchema(schemaSqlServer), this.getCollTypeList());
        this.sort();
    }

    @Override
    protected void addTableProxyDetails(TableProxySqlServer tableProxySqlServer, ModelIdObjectSelection modelIdObjectSelection) {
        super.addTableProxyDetails(tableProxySqlServer, modelIdObjectSelection);
        if (this.getSynonymsForTable(tableProxySqlServer).size() > 0) {
            this.addContainerObjects(SYNONYMS, modelIdObjectSelection, this.getSynonymsForTable(tableProxySqlServer), this.getSynonymList());
        }
    }

    @Override
    protected void addViewProxyDetails(TableViewProxySqlServer tableViewProxySqlServer, ModelIdObjectSelection modelIdObjectSelection) {
        super.addViewProxyDetails(tableViewProxySqlServer, modelIdObjectSelection);
        if (this.getSynonymsForView(tableViewProxySqlServer).size() > 0) {
            this.addContainerObjects(SYNONYMS, modelIdObjectSelection, this.getSynonymsForView(tableViewProxySqlServer), this.getSynonymList());
        }
    }

    private void addProcedureObjects(String string, ModelIdObjectSelection modelIdObjectSelection, List list, List list2) {
        if (!list.isEmpty()) {
            ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
            for (ModelIDObject modelIDObject : list) {
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(modelIDObject);
                modelIdObjectSelection3.setElementDescriptor(modelIDObject.getClass());
                this.getSynonymsForProcedure((StoredProcedureSqlServer)modelIDObject);
                list2.add(modelIdObjectSelection3);
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    private List getSchemasForDatabase(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<SchemaSqlServer> arrayList = new ArrayList<SchemaSqlServer>();
        Iterator iterator = this.getStorageDesign().getSchemaSet().iterator();
        while (iterator.hasNext()) {
            SchemaSqlServer schemaSqlServer = (SchemaSqlServer)iterator.next();
            if (schemaSqlServer.getDatabase() == null || !schemaSqlServer.getDatabase().getObjectID().equalsIgnoreCase(dataBaseSqlServer.getObjectID())) continue;
            arrayList.add(schemaSqlServer);
        }
        return arrayList;
    }

    private List getSchemasWithNullDatabase() {
        ArrayList<SchemaSqlServer> arrayList = new ArrayList<SchemaSqlServer>();
        Iterator iterator = this.getStorageDesign().getSchemaSet().iterator();
        while (iterator.hasNext()) {
            SchemaSqlServer schemaSqlServer = (SchemaSqlServer)iterator.next();
            if (!schemaSqlServer.getDatabase().isNullInstance()) continue;
            arrayList.add(schemaSqlServer);
        }
        return arrayList;
    }

    private List getTablesWithNullSchema(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<TableProxySqlServer> arrayList = new ArrayList<TableProxySqlServer>();
        Iterator iterator = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableProxySet().iterator() : this.getStorageDesign().getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)iterator.next();
            if (tableProxySqlServer.getSchema() != null || !dataBaseSqlServer.equals(tableProxySqlServer.getDatabase())) continue;
            arrayList.add(tableProxySqlServer);
        }
        return arrayList;
    }

    private List getTablesForSchema(SchemaSqlServer schemaSqlServer) {
        ArrayList<TableProxySqlServer> arrayList = new ArrayList<TableProxySqlServer>();
        Iterator iterator = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableProxySet().iterator() : this.getStorageDesign().getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)iterator.next();
            if (tableProxySqlServer.getSchema() == null || !tableProxySqlServer.getSchema().getObjectID().equalsIgnoreCase(schemaSqlServer.getObjectID())) continue;
            arrayList.add(tableProxySqlServer);
        }
        return arrayList;
    }

    private List getViewsWithNullSchema(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<TableViewProxySqlServer> arrayList = new ArrayList<TableViewProxySqlServer>();
        Iterator iterator = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableViewProxySet().iterator() : this.getStorageDesign().getTableViewProxySet().iterator();
        while (iterator.hasNext()) {
            TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)iterator.next();
            if (tableViewProxySqlServer.getSchema() != null || !dataBaseSqlServer.equals(tableViewProxySqlServer.getDataBase())) continue;
            arrayList.add(tableViewProxySqlServer);
        }
        return arrayList;
    }

    private List getViewsForSchema(SchemaSqlServer schemaSqlServer) {
        ArrayList<TableViewProxySqlServer> arrayList = new ArrayList<TableViewProxySqlServer>();
        Iterator iterator = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableViewProxySet().iterator() : this.getStorageDesign().getTableViewProxySet().iterator();
        while (iterator.hasNext()) {
            TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)iterator.next();
            if ((schemaSqlServer == null || tableViewProxySqlServer.getSchema() == null || !tableViewProxySqlServer.getSchema().getObjectID().equalsIgnoreCase(schemaSqlServer.getObjectID())) && (schemaSqlServer != null || tableViewProxySqlServer.getSchema() != null)) continue;
            arrayList.add(tableViewProxySqlServer);
        }
        return arrayList;
    }

    private List getDefaultsWithNullSchema(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<DefaultSqlServer> arrayList = new ArrayList<DefaultSqlServer>();
        Iterator iterator = this.getStorageDesign().getDefaultSet().iterator();
        while (iterator.hasNext()) {
            DefaultSqlServer defaultSqlServer = (DefaultSqlServer)iterator.next();
            if (defaultSqlServer.getSchema() != null || !dataBaseSqlServer.equals(defaultSqlServer.getDataBase())) continue;
            arrayList.add(defaultSqlServer);
        }
        return arrayList;
    }

    private List getDefaultsForSchema(SchemaSqlServer schemaSqlServer) {
        ArrayList<DefaultSqlServer> arrayList = new ArrayList<DefaultSqlServer>();
        Iterator iterator = this.getStorageDesign().getDefaultSet().iterator();
        while (iterator.hasNext()) {
            DefaultSqlServer defaultSqlServer = (DefaultSqlServer)iterator.next();
            if ((schemaSqlServer == null || defaultSqlServer.getSchema() == null || !defaultSqlServer.getSchema().getObjectID().equalsIgnoreCase(schemaSqlServer.getObjectID())) && (schemaSqlServer != null || defaultSqlServer.getSchema() != null)) continue;
            arrayList.add(defaultSqlServer);
        }
        return arrayList;
    }

    private List getProceduresWithNullSchema(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<StoredProcedureSqlServer> arrayList = new ArrayList<StoredProcedureSqlServer>();
        Iterator iterator = this.getStorageDesign().getStoredProcedureSet().iterator();
        while (iterator.hasNext()) {
            StoredProcedureSqlServer storedProcedureSqlServer = (StoredProcedureSqlServer)iterator.next();
            if (storedProcedureSqlServer.getSchema() != null || !dataBaseSqlServer.equals(storedProcedureSqlServer.getDatabase())) continue;
            arrayList.add(storedProcedureSqlServer);
        }
        return arrayList;
    }

    private List getProceduresForSchema(SchemaSqlServer schemaSqlServer) {
        ArrayList<StoredProcedureSqlServer> arrayList = new ArrayList<StoredProcedureSqlServer>();
        Iterator iterator = this.getStorageDesign().getStoredProcedureSet().iterator();
        while (iterator.hasNext()) {
            StoredProcedureSqlServer storedProcedureSqlServer = (StoredProcedureSqlServer)iterator.next();
            if ((schemaSqlServer == null || storedProcedureSqlServer.getSchema() == null || !storedProcedureSqlServer.getSchema().getObjectID().equalsIgnoreCase(schemaSqlServer.getObjectID())) && (schemaSqlServer != null || storedProcedureSqlServer.getSchema() != null)) continue;
            arrayList.add(storedProcedureSqlServer);
        }
        return arrayList;
    }

    private List getRulesWithNullSchema(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<RuleSqlServer> arrayList = new ArrayList<RuleSqlServer>();
        Iterator iterator = this.getStorageDesign().getRuleSet().iterator();
        while (iterator.hasNext()) {
            RuleSqlServer ruleSqlServer = (RuleSqlServer)iterator.next();
            if (ruleSqlServer.getSchema() != null || !dataBaseSqlServer.equals(ruleSqlServer.getDatabase())) continue;
            arrayList.add(ruleSqlServer);
        }
        return arrayList;
    }

    private List getRulesForSchema(SchemaSqlServer schemaSqlServer) {
        ArrayList<RuleSqlServer> arrayList = new ArrayList<RuleSqlServer>();
        Iterator iterator = this.getStorageDesign().getRuleSet().iterator();
        while (iterator.hasNext()) {
            RuleSqlServer ruleSqlServer = (RuleSqlServer)iterator.next();
            if ((schemaSqlServer == null || ruleSqlServer.getSchema() == null || !ruleSqlServer.getSchema().getObjectID().equalsIgnoreCase(schemaSqlServer.getObjectID())) && (schemaSqlServer != null || ruleSqlServer.getSchema() != null)) continue;
            arrayList.add(ruleSqlServer);
        }
        return arrayList;
    }

    private List getRoles(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<RoleSqlServer> arrayList = new ArrayList<RoleSqlServer>();
        Iterator iterator = this.getStorageDesign().getRoleSet().iterator();
        while (iterator.hasNext()) {
            RoleSqlServer roleSqlServer = (RoleSqlServer)iterator.next();
            if (!dataBaseSqlServer.equals(roleSqlServer.getDatabase()) || roleSqlServer.isNullInstance()) continue;
            arrayList.add(roleSqlServer);
        }
        return arrayList;
    }

    private List getDistinctTypesWithNullSchema(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<UsedUserDefinedData> arrayList = new ArrayList<UsedUserDefinedData>();
        Iterator iterator = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getUsedUserDefinedDataSet().iterator();
        while (iterator.hasNext()) {
            UsedUserDefinedData usedUserDefinedData = (UsedUserDefinedData)iterator.next();
            if (usedUserDefinedData.getSchema() != null || !dataBaseSqlServer.equals(usedUserDefinedData.getDatabase())) continue;
            arrayList.add(usedUserDefinedData);
        }
        return arrayList;
    }

    private List getDistinctTypesForSchema(SchemaSqlServer schemaSqlServer) {
        ArrayList<UsedUserDefinedData> arrayList = new ArrayList<UsedUserDefinedData>();
        Iterator iterator = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getUsedUserDefinedDataSet().iterator();
        while (iterator.hasNext()) {
            UsedUserDefinedData usedUserDefinedData = (UsedUserDefinedData)iterator.next();
            if ((schemaSqlServer == null || !usedUserDefinedData.isBaseOnDistinctType() || usedUserDefinedData.getSchema() == null || !usedUserDefinedData.getSchema().getObjectID().equalsIgnoreCase(schemaSqlServer.getObjectID())) && (schemaSqlServer != null || usedUserDefinedData.getSchema() != null)) continue;
            arrayList.add(usedUserDefinedData);
        }
        return arrayList;
    }

    private List getDomainsWithNullSchema(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<UsedUserDefinedData> arrayList = new ArrayList<UsedUserDefinedData>();
        Iterator iterator = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getUsedUserDefinedDataSet().iterator();
        while (iterator.hasNext()) {
            UsedUserDefinedData usedUserDefinedData = (UsedUserDefinedData)iterator.next();
            if (usedUserDefinedData.isBaseOnDistinctType() || usedUserDefinedData.getSchema() != null || !dataBaseSqlServer.equals(usedUserDefinedData.getDatabase())) continue;
            arrayList.add(usedUserDefinedData);
        }
        return arrayList;
    }

    private List getDomainsForSchema(SchemaSqlServer schemaSqlServer) {
        ArrayList<UsedUserDefinedData> arrayList = new ArrayList<UsedUserDefinedData>();
        Iterator iterator = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getUsedUserDefinedDataSet().iterator();
        while (iterator.hasNext()) {
            UsedUserDefinedData usedUserDefinedData = (UsedUserDefinedData)iterator.next();
            if (usedUserDefinedData.isBaseOnDistinctType() || (schemaSqlServer == null || usedUserDefinedData.getSchema() == null || !usedUserDefinedData.getSchema().getObjectID().equalsIgnoreCase(schemaSqlServer.getObjectID())) && (schemaSqlServer != null || usedUserDefinedData.getSchema() != null)) continue;
            arrayList.add(usedUserDefinedData);
        }
        return arrayList;
    }

    private List getXMLCollectionsWithNullSchema(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<XMLSchemaCollectionSqlServer> arrayList = new ArrayList<XMLSchemaCollectionSqlServer>();
        Iterator iterator = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getXmlSchemaCollectionSet().iterator();
        while (iterator.hasNext()) {
            XMLSchemaCollectionSqlServer xMLSchemaCollectionSqlServer = (XMLSchemaCollectionSqlServer)iterator.next();
            if (xMLSchemaCollectionSqlServer.getSchema() != null || !dataBaseSqlServer.equals(xMLSchemaCollectionSqlServer.getDatabase())) continue;
            arrayList.add(xMLSchemaCollectionSqlServer);
        }
        return arrayList;
    }

    private List getXMLCollectionsForSchema(SchemaSqlServer schemaSqlServer) {
        ArrayList<XMLSchemaCollectionSqlServer> arrayList = new ArrayList<XMLSchemaCollectionSqlServer>();
        Iterator iterator = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getXmlSchemaCollectionSet().iterator();
        while (iterator.hasNext()) {
            XMLSchemaCollectionSqlServer xMLSchemaCollectionSqlServer = (XMLSchemaCollectionSqlServer)iterator.next();
            if ((schemaSqlServer == null || xMLSchemaCollectionSqlServer.getSchema() == null || !xMLSchemaCollectionSqlServer.getSchema().getObjectID().equalsIgnoreCase(schemaSqlServer.getObjectID())) && (schemaSqlServer != null || xMLSchemaCollectionSqlServer.getSchema() != null)) continue;
            arrayList.add(xMLSchemaCollectionSqlServer);
        }
        return arrayList;
    }

    private List getSynonymsForProcedure(StoredProcedureSqlServer storedProcedureSqlServer) {
        ArrayList<SynonymSqlServer> arrayList = new ArrayList<SynonymSqlServer>();
        Iterator iterator = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getSynonymSet().iterator();
        while (iterator.hasNext()) {
            SynonymSqlServer synonymSqlServer = (SynonymSqlServer)iterator.next();
            if (synonymSqlServer.getProcedure() == null || !synonymSqlServer.getProcedure().getObjectID().equalsIgnoreCase(storedProcedureSqlServer.getObjectID())) continue;
            this.getSynonymList().add(new ModelIdObjectSelection(synonymSqlServer));
            arrayList.add(synonymSqlServer);
        }
        return arrayList;
    }

    private List getSynonymsForTable(TableProxySqlServer tableProxySqlServer) {
        ArrayList<SynonymSqlServer> arrayList = new ArrayList<SynonymSqlServer>();
        Iterator iterator = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getSynonymSet().iterator();
        while (iterator.hasNext()) {
            SynonymSqlServer synonymSqlServer = (SynonymSqlServer)iterator.next();
            if (synonymSqlServer.getTable() == null || !synonymSqlServer.getTable().getObjectID().equalsIgnoreCase(tableProxySqlServer.getObjectID())) continue;
            arrayList.add(synonymSqlServer);
        }
        return arrayList;
    }

    private List getSynonymsForView(TableViewProxySqlServer tableViewProxySqlServer) {
        ArrayList<SynonymSqlServer> arrayList = new ArrayList<SynonymSqlServer>();
        Iterator iterator = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getSynonymSet().iterator();
        while (iterator.hasNext()) {
            SynonymSqlServer synonymSqlServer = (SynonymSqlServer)iterator.next();
            if (synonymSqlServer.getView() == null || !synonymSqlServer.getView().getObjectID().equalsIgnoreCase(tableViewProxySqlServer.getObjectID())) continue;
            arrayList.add(synonymSqlServer);
        }
        return arrayList;
    }

    public List getDistTypeList() {
        if (this.distTypeList == null) {
            this.distTypeList = new ArrayList();
        }
        return this.distTypeList;
    }

    public List getDomainTypeList() {
        if (this.domainTypeList == null) {
            this.domainTypeList = new ArrayList();
        }
        return this.domainTypeList;
    }

    public List getCollTypeList() {
        if (this.collTypeList == null) {
            this.collTypeList = new ArrayList();
        }
        return this.collTypeList;
    }

    public List getSynonymList() {
        if (this.synonymList == null) {
            this.synonymList = new ArrayList();
        }
        return this.synonymList;
    }
}

