/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.process.RoleSet;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.RuleSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DefaultSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.SchemaSetUDB;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionLists;

public class DDLSelectionSqlServerv2k
extends ModelIdObjectSelection
implements DDLSelectionLists {
    protected static final String ASSIGNED_TO_DATABASE = Messages.getString("DDLSelectionSqlServerv2k.AssignedToDatabase");
    protected static final String NOT_ASSIGNED_TO_DATABASE = Messages.getString("DDLSelectionSqlServerv2k.NotAssignedToDatabase");
    protected static final String TABLES = Messages.getString("DDLSelectionSqlServerv2k.Tables");
    protected static final String VIEWS = Messages.getString("DDLSelectionSqlServerv2k.Views");
    protected static final String LOGINS = Messages.getString("DDLSelectionSqlServerv2k.Logins");
    private static final String USER_DEFINED_TYPES = Messages.getString("DDLSelectionSqlServerv2k.UserDefinedTypes");
    protected static final String DEFAULTS = Messages.getString("DDLSelectionSqlServerv2k.Defaults");
    protected static final String STORED_PROCEDURES = Messages.getString("DDLSelectionSqlServerv2k.StoredProcedures");
    protected static final String RULES = Messages.getString("DDLSelectionSqlServerv2k.Rules");
    private static final String CONSTRAINTS = Messages.getString("DDLSelectionSqlServerv2k.PKUKConstraints");
    private static final String INDEXES = Messages.getString("DDLSelectionSqlServerv2k.Indexes");
    private static final String FOREIGN_KEYS = Messages.getString("DDLSelectionSqlServerv2k.ForeignKeys");
    private static final String TRIGGERS = Messages.getString("DDLSelectionSqlServerv2k.Triggers");
    private static final String ASSIGNED_TO_USER = Messages.getString("DDLSelectionSqlServerv2k.AssignedToUser");
    private static final String NOT_ASSIGNED_TO_USER = Messages.getString("DDLSelectionSqlServerv2k.NotAssignedToUser");
    protected static final String ROLES = Messages.getString("DDLSelectionSqlServerv2k.Roles");
    private StorageDesign storageDesign;
    private List constraintList;
    private List fkList;
    private List indexList;
    private List tableList;
    private List viewList;
    private List databaseList;
    private List triggerList;
    private List userList;
    private List defaultList;
    private List roleList;
    private List ruleList;
    private List procedureList;
    private List typeList;
    private List schemaList;
    private DesignPartView selectedSubView = null;

    public DDLSelectionSqlServerv2k(StorageDesign storageDesign) {
        super(storageDesign.getName());
        this.storageDesign = storageDesign;
        if (this.storageDesign.isOpen()) {
            this.setElementDescriptor(storageDesign.getClass());
            this.addFromStorageDesign();
        }
    }

    public DDLSelectionSqlServerv2k(StorageDesign storageDesign, DesignPartView designPartView) {
        super(storageDesign.getName());
        this.storageDesign = storageDesign;
        this.selectedSubView = designPartView;
        if (this.storageDesign.isOpen()) {
            this.setElementDescriptor(storageDesign.getClass());
            this.addFromStorageDesign();
        }
    }

    protected void addFromStorageDesign() {
        this.setElementDescriptor(DataBaseSqlServer.class);
        this.addAssignedToDatabase(ASSIGNED_TO_DATABASE, this);
        this.addLogins(LOGINS, this, this.getStorageDesign().getLoginSet().getElementsList());
    }

    private void addAssignedToDatabase(String string, ModelIdObjectSelection modelIdObjectSelection) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(DataBaseSqlServer.class);
        Iterator iterator = this.getStorageDesign().getDataBaseSet().iterator();
        while (iterator.hasNext()) {
            DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)iterator.next();
            ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(dataBaseSqlServer);
            ModelIdObjectSelection modelIdObjectSelection4 = new ModelIdObjectSelection(dataBaseSqlServer.getName());
            if (this.getUsersForDatabase(dataBaseSqlServer).size() > 0) {
                this.addAssignedToUser(ASSIGNED_TO_USER, modelIdObjectSelection4, this.getUsersForDatabase(dataBaseSqlServer));
            }
            this.addNotAssignedToUser(NOT_ASSIGNED_TO_USER, modelIdObjectSelection4, dataBaseSqlServer);
            this.getDatabaseList().add(modelIdObjectSelection3);
            modelIdObjectSelection2.addChild(modelIdObjectSelection4);
        }
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    private void addAssignedToUser(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(SchemaSetSqlServerv2k5.class);
        for (UserSqlServer userSqlServer : list) {
            ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(userSqlServer.getName());
            ModelIdObjectSelection modelIdObjectSelection4 = new ModelIdObjectSelection(userSqlServer);
            this.addUserDetails(userSqlServer, modelIdObjectSelection3);
            this.getUserList().add(modelIdObjectSelection4);
            modelIdObjectSelection2.addChild(modelIdObjectSelection3);
        }
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    private void addNotAssignedToUser(String string, ModelIdObjectSelection modelIdObjectSelection, DataBaseSqlServer dataBaseSqlServer) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(SchemaSetUDB.class);
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
        this.addAllWithNullUser(modelIdObjectSelection2, dataBaseSqlServer);
    }

    protected void addNotAssignedToDatabase(String string, ModelIdObjectSelection modelIdObjectSelection) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        Iterator iterator = this.getStorageDesign().getDataBaseSet().iterator();
        while (iterator.hasNext()) {
            DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)iterator.next();
            if (!dataBaseSqlServer.isNullInstance()) continue;
            if (this.getUsersWithNullDatabase().size() > 0) {
                this.addUsersWithNullDatabase(ASSIGNED_TO_USER, modelIdObjectSelection2, this.getUsersWithNullDatabase());
            }
            this.addNotAssignedToUser(NOT_ASSIGNED_TO_USER, modelIdObjectSelection2, dataBaseSqlServer);
        }
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    private void addAllWithNullUser(ModelIdObjectSelection modelIdObjectSelection, DataBaseSqlServer dataBaseSqlServer) {
        this.addTables(TABLES, modelIdObjectSelection, this.getTablesWithNullUser(dataBaseSqlServer));
        this.addViews(VIEWS, modelIdObjectSelection, this.getViewsWithNullUser(dataBaseSqlServer));
        this.addContainerObjects(USER_DEFINED_TYPES, modelIdObjectSelection, this.getUserTypesWithNullUser(dataBaseSqlServer), this.getTypeList());
        this.addContainerObjects(DEFAULTS, modelIdObjectSelection, this.getDefaultsWithNullUser(dataBaseSqlServer), this.getDefaultList());
        this.addContainerObjects(STORED_PROCEDURES, modelIdObjectSelection, this.getProceduresWithNullUser(dataBaseSqlServer), this.getProcedureList());
        this.addContainerObjects(RULES, modelIdObjectSelection, this.getRulesWithNullUser(dataBaseSqlServer), this.getRuleList());
        this.addContainerObjects(ROLES, modelIdObjectSelection, this.getRolesWithNullUser(dataBaseSqlServer), this.getRoleList());
        this.sort();
    }

    private void addUsersWithNullDatabase(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        for (UserSqlServer userSqlServer : list) {
            ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(userSqlServer.getName());
            ModelIdObjectSelection modelIdObjectSelection4 = new ModelIdObjectSelection(userSqlServer);
            this.addUserDetails(userSqlServer, modelIdObjectSelection3);
            this.getUserList().add(modelIdObjectSelection4);
            modelIdObjectSelection2.addChild(modelIdObjectSelection3);
        }
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    protected void addLogins(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(LoginSqlServer.class);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                LoginSqlServer loginSqlServer = (LoginSqlServer)iterator.next();
                if (loginSqlServer.isNullInstance()) continue;
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(loginSqlServer);
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            }
            if (modelIdObjectSelection2.getChilds().size() > 0) {
                modelIdObjectSelection.addChild(modelIdObjectSelection2);
            }
        }
    }

    protected void addUserDetails(UserSqlServer userSqlServer, ModelIdObjectSelection modelIdObjectSelection) {
        this.addTables(TABLES, modelIdObjectSelection, this.getTablesForUser(userSqlServer));
        this.addViews(VIEWS, modelIdObjectSelection, this.getViewsForUser(userSqlServer));
        this.addContainerObjects(USER_DEFINED_TYPES, modelIdObjectSelection, this.getUserTypesForUser(userSqlServer), this.getTypeList());
        this.addContainerObjects(DEFAULTS, modelIdObjectSelection, this.getDefaultsForUser(userSqlServer), this.getDefaultList());
        this.addContainerObjects(STORED_PROCEDURES, modelIdObjectSelection, this.getProceduresForUser(userSqlServer), this.getProcedureList());
        this.addContainerObjects(RULES, modelIdObjectSelection, this.getRulesForUser(userSqlServer), this.getRuleList());
        this.addContainerObjects(ROLES, modelIdObjectSelection, this.getRolesForUser(userSqlServer), this.getRoleList());
        this.sort();
    }

    protected void addTables(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        if (!list.isEmpty()) {
            ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
            modelIdObjectSelection2.setElementDescriptor(TableSet.class);
            for (TableProxySqlServer tableProxySqlServer : list) {
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(tableProxySqlServer);
                this.addTableProxyDetails(tableProxySqlServer, modelIdObjectSelection3);
                this.getTableList().add(modelIdObjectSelection3);
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    protected void addTableProxyDetails(TableProxySqlServer tableProxySqlServer, ModelIdObjectSelection modelIdObjectSelection) {
        if (tableProxySqlServer.getPkeys().size() > 0 || tableProxySqlServer.getUkeys().size() > 0) {
            ModelIdObjectSelection modelIdObjectSelection2;
            IndexProxy indexProxy;
            ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(CONSTRAINTS);
            modelIdObjectSelection3.setElementDescriptor(PKProxySetSqlServer.class);
            Iterator iterator = tableProxySqlServer.getPkeys().iterator();
            while (iterator.hasNext()) {
                indexProxy = (PKProxySqlServer)iterator.next();
                modelIdObjectSelection2 = new ModelIdObjectSelection(indexProxy);
                modelIdObjectSelection2.setName("(PK) " + indexProxy.getName());
                this.getConstraintList().add(modelIdObjectSelection2);
                modelIdObjectSelection3.addChild(modelIdObjectSelection2);
            }
            iterator = tableProxySqlServer.getUkeys().iterator();
            while (iterator.hasNext()) {
                indexProxy = (UniqueProxySqlServer)iterator.next();
                modelIdObjectSelection2 = new ModelIdObjectSelection(indexProxy);
                this.getConstraintList().add(modelIdObjectSelection2);
                modelIdObjectSelection3.addChild(modelIdObjectSelection2);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection3);
        }
        if (tableProxySqlServer.getIndexes().size() > 0) {
            this.addContainerObjects(INDEXES, modelIdObjectSelection, tableProxySqlServer.getIndexes().getElementsList(), this.getIndexList());
        }
        if (tableProxySqlServer.getFkeys().size() > 0) {
            this.addContainerObjects(FOREIGN_KEYS, modelIdObjectSelection, tableProxySqlServer.getFkeys().getElementsList(), this.getFkList());
        }
        if (tableProxySqlServer.getTriggers().size() > 0) {
            this.addContainerObjects(TRIGGERS, modelIdObjectSelection, tableProxySqlServer.getTriggers().getElementsList(), this.getTriggerList());
        }
    }

    protected void addViews(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        if (!list.isEmpty()) {
            ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
            modelIdObjectSelection2.setElementDescriptor(TableViewSet.class);
            for (TableViewProxySqlServer tableViewProxySqlServer : list) {
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(tableViewProxySqlServer);
                this.addViewProxyDetails(tableViewProxySqlServer, modelIdObjectSelection3);
                this.getViewList().add(modelIdObjectSelection3);
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    protected void addViewProxyDetails(TableViewProxySqlServer tableViewProxySqlServer, ModelIdObjectSelection modelIdObjectSelection) {
        if (tableViewProxySqlServer.getIndexesOnView().size() > 0) {
            this.addContainerObjects(INDEXES, modelIdObjectSelection, tableViewProxySqlServer.getIndexesOnView().getElementsList(), this.getIndexList());
        }
        if (tableViewProxySqlServer.getTriggers().size() > 0) {
            this.addContainerObjects(TRIGGERS, modelIdObjectSelection, tableViewProxySqlServer.getTriggers().getElementsList(), this.getTriggerList());
        }
    }

    protected void addContainerObjects(String string, ModelIdObjectSelection modelIdObjectSelection, List list, List list2) {
        if (!list.isEmpty()) {
            ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
            this.putNodeIcon(modelIdObjectSelection2, string);
            for (ModelIDObject modelIDObject : list) {
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(modelIDObject);
                modelIdObjectSelection3.setElementDescriptor(modelIDObject.getClass());
                list2.add(modelIdObjectSelection3);
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    private List getTablesWithNullUser(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<TableProxySqlServer> arrayList = new ArrayList<TableProxySqlServer>();
        Iterator iterator = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableProxySet().iterator() : this.getStorageDesign().getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)iterator.next();
            if (tableProxySqlServer.getUser() != null || !dataBaseSqlServer.equals(tableProxySqlServer.getDatabase())) continue;
            arrayList.add(tableProxySqlServer);
        }
        return arrayList;
    }

    private List getTablesForUser(UserSqlServer userSqlServer) {
        ArrayList<TableProxySqlServer> arrayList = new ArrayList<TableProxySqlServer>();
        Iterator iterator = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableProxySet().iterator() : this.getStorageDesign().getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)iterator.next();
            if (tableProxySqlServer.getUser() != null && tableProxySqlServer.getUser().getObjectID().equalsIgnoreCase(userSqlServer.getObjectID())) {
                arrayList.add(tableProxySqlServer);
                continue;
            }
            if (tableProxySqlServer.getUser() == null || !tableProxySqlServer.getUser().getObjectID().equalsIgnoreCase(userSqlServer.getObjectID())) continue;
            arrayList.add(tableProxySqlServer);
        }
        return arrayList;
    }

    private List getViewsWithNullUser(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<TableViewProxySqlServer> arrayList = new ArrayList<TableViewProxySqlServer>();
        Iterator iterator = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableViewProxySet().iterator() : this.getStorageDesign().getTableViewProxySet().iterator();
        while (iterator.hasNext()) {
            TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)iterator.next();
            if (tableViewProxySqlServer.getUser() != null || !dataBaseSqlServer.equals(tableViewProxySqlServer.getDataBase())) continue;
            arrayList.add(tableViewProxySqlServer);
        }
        return arrayList;
    }

    private List getViewsForUser(UserSqlServer userSqlServer) {
        ArrayList<TableViewProxySqlServer> arrayList = new ArrayList<TableViewProxySqlServer>();
        Iterator iterator = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableViewProxySet().iterator() : this.getStorageDesign().getTableViewProxySet().iterator();
        while (iterator.hasNext()) {
            TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)iterator.next();
            if (tableViewProxySqlServer.getUser() != null && tableViewProxySqlServer.getUser().getObjectID().equalsIgnoreCase(userSqlServer.getObjectID())) {
                arrayList.add(tableViewProxySqlServer);
                continue;
            }
            if (tableViewProxySqlServer.getUser() == null || !tableViewProxySqlServer.getUser().getObjectID().equalsIgnoreCase(userSqlServer.getObjectID())) continue;
            arrayList.add(tableViewProxySqlServer);
        }
        return arrayList;
    }

    private List getUserTypesWithNullUser(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<UserDefinedTypeSqlServer> arrayList = new ArrayList<UserDefinedTypeSqlServer>();
        Iterator iterator = this.getStorageDesign().getUserDefinedTypeSet().iterator();
        while (iterator.hasNext()) {
            UserDefinedTypeSqlServer userDefinedTypeSqlServer = (UserDefinedTypeSqlServer)iterator.next();
            if (userDefinedTypeSqlServer.getOwner() != null || !dataBaseSqlServer.equals(userDefinedTypeSqlServer.getOwner())) continue;
            arrayList.add(userDefinedTypeSqlServer);
        }
        return arrayList;
    }

    private List getUserTypesForUser(UserSqlServer userSqlServer) {
        ArrayList<UserDefinedTypeSqlServer> arrayList = new ArrayList<UserDefinedTypeSqlServer>();
        Iterator iterator = this.getStorageDesign().getUserDefinedTypeSet().iterator();
        while (iterator.hasNext()) {
            UserDefinedTypeSqlServer userDefinedTypeSqlServer = (UserDefinedTypeSqlServer)iterator.next();
            if (userDefinedTypeSqlServer.getOwner() != null && userDefinedTypeSqlServer.getOwner().getObjectID().equalsIgnoreCase(userSqlServer.getObjectID())) {
                arrayList.add(userDefinedTypeSqlServer);
                continue;
            }
            if (userDefinedTypeSqlServer.getOwner() == null || !userDefinedTypeSqlServer.getOwner().getObjectID().equalsIgnoreCase(userSqlServer.getObjectID())) continue;
            arrayList.add(userDefinedTypeSqlServer);
        }
        return arrayList;
    }

    private List getDefaultsWithNullUser(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<DefaultSqlServer> arrayList = new ArrayList<DefaultSqlServer>();
        Iterator iterator = this.getStorageDesign().getDefaultSet().iterator();
        while (iterator.hasNext()) {
            DefaultSqlServer defaultSqlServer = (DefaultSqlServer)iterator.next();
            if (defaultSqlServer.getOwner() != null || !dataBaseSqlServer.equals(defaultSqlServer.getOwner())) continue;
            arrayList.add(defaultSqlServer);
        }
        return arrayList;
    }

    private List getDefaultsForUser(UserSqlServer userSqlServer) {
        ArrayList<DefaultSqlServer> arrayList = new ArrayList<DefaultSqlServer>();
        Iterator iterator = this.getStorageDesign().getDefaultSet().iterator();
        while (iterator.hasNext()) {
            DefaultSqlServer defaultSqlServer = (DefaultSqlServer)iterator.next();
            if (defaultSqlServer.getOwner() != null && defaultSqlServer.getOwner().getObjectID().equalsIgnoreCase(userSqlServer.getObjectID())) {
                arrayList.add(defaultSqlServer);
                continue;
            }
            if (defaultSqlServer.getOwner() == null || !defaultSqlServer.getOwner().getObjectID().equalsIgnoreCase(userSqlServer.getObjectID())) continue;
            arrayList.add(defaultSqlServer);
        }
        return arrayList;
    }

    private List getProceduresWithNullUser(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<StoredProcedureSqlServer> arrayList = new ArrayList<StoredProcedureSqlServer>();
        Iterator iterator = this.getStorageDesign().getStoredProcedureSet().iterator();
        while (iterator.hasNext()) {
            StoredProcedureSqlServer storedProcedureSqlServer = (StoredProcedureSqlServer)iterator.next();
            if (storedProcedureSqlServer.getOwner() != null || !dataBaseSqlServer.equals(storedProcedureSqlServer.getOwner())) continue;
            arrayList.add(storedProcedureSqlServer);
        }
        return arrayList;
    }

    private List getProceduresForUser(UserSqlServer userSqlServer) {
        ArrayList<StoredProcedureSqlServer> arrayList = new ArrayList<StoredProcedureSqlServer>();
        Iterator iterator = this.getStorageDesign().getStoredProcedureSet().iterator();
        while (iterator.hasNext()) {
            StoredProcedureSqlServer storedProcedureSqlServer = (StoredProcedureSqlServer)iterator.next();
            if (storedProcedureSqlServer.getOwner() != null && storedProcedureSqlServer.getOwner().getObjectID().equalsIgnoreCase(userSqlServer.getObjectID())) {
                arrayList.add(storedProcedureSqlServer);
                continue;
            }
            if (storedProcedureSqlServer.getOwner() == null || !storedProcedureSqlServer.getOwner().getObjectID().equalsIgnoreCase(userSqlServer.getObjectID())) continue;
            arrayList.add(storedProcedureSqlServer);
        }
        return arrayList;
    }

    private List getRulesWithNullUser(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<RuleSqlServer> arrayList = new ArrayList<RuleSqlServer>();
        Iterator iterator = this.getStorageDesign().getRuleSet().iterator();
        while (iterator.hasNext()) {
            RuleSqlServer ruleSqlServer = (RuleSqlServer)iterator.next();
            if (ruleSqlServer.getOwner() != null || !dataBaseSqlServer.equals(ruleSqlServer.getDatabase())) continue;
            arrayList.add(ruleSqlServer);
        }
        return arrayList;
    }

    private List getRulesForUser(UserSqlServer userSqlServer) {
        ArrayList<RuleSqlServer> arrayList = new ArrayList<RuleSqlServer>();
        Iterator iterator = this.getStorageDesign().getRuleSet().iterator();
        while (iterator.hasNext()) {
            RuleSqlServer ruleSqlServer = (RuleSqlServer)iterator.next();
            if (ruleSqlServer.getOwner() != null && ruleSqlServer.getOwner().getObjectID().equalsIgnoreCase(userSqlServer.getObjectID())) {
                arrayList.add(ruleSqlServer);
                continue;
            }
            if (ruleSqlServer.getOwner() == null || !ruleSqlServer.getOwner().getObjectID().equalsIgnoreCase(userSqlServer.getObjectID())) continue;
            arrayList.add(ruleSqlServer);
        }
        return arrayList;
    }

    private List getUsersForDatabase(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<UserSqlServer> arrayList = new ArrayList<UserSqlServer>();
        Iterator iterator = this.getStorageDesign().getUserSet().iterator();
        while (iterator.hasNext()) {
            UserSqlServer userSqlServer = (UserSqlServer)iterator.next();
            if (userSqlServer.getDatabase() == null || !userSqlServer.getDatabase().getObjectID().equalsIgnoreCase(dataBaseSqlServer.getObjectID())) continue;
            arrayList.add(userSqlServer);
        }
        return arrayList;
    }

    private List getUsersWithNullDatabase() {
        ArrayList<UserSqlServer> arrayList = new ArrayList<UserSqlServer>();
        Iterator iterator = this.getStorageDesign().getUserSet().iterator();
        while (iterator.hasNext()) {
            UserSqlServer userSqlServer = (UserSqlServer)iterator.next();
            if (!userSqlServer.getDatabase().isNullInstance()) continue;
            arrayList.add(userSqlServer);
        }
        return arrayList;
    }

    private List getRolesWithNullUser(DataBaseSqlServer dataBaseSqlServer) {
        ArrayList<RoleSqlServer> arrayList = new ArrayList<RoleSqlServer>();
        Iterator iterator = this.getStorageDesign().getRoleSet().iterator();
        while (iterator.hasNext()) {
            RoleSqlServer roleSqlServer = (RoleSqlServer)iterator.next();
            if (roleSqlServer.getOwner() != null || !dataBaseSqlServer.equals(roleSqlServer.getDatabase()) || roleSqlServer.isNullInstance()) continue;
            arrayList.add(roleSqlServer);
        }
        return arrayList;
    }

    private List getRolesForUser(UserSqlServer userSqlServer) {
        ArrayList<RoleSqlServer> arrayList = new ArrayList<RoleSqlServer>();
        Iterator iterator = this.getStorageDesign().getRoleSet().iterator();
        while (iterator.hasNext()) {
            RoleSqlServer roleSqlServer = (RoleSqlServer)iterator.next();
            if (roleSqlServer.getOwner() == null || !roleSqlServer.getOwner().getObjectID().equalsIgnoreCase(userSqlServer.getObjectID()) || roleSqlServer.isNullInstance()) continue;
            arrayList.add(roleSqlServer);
        }
        return arrayList;
    }

    public StorageDesignSqlServer getStorageDesign() {
        return (StorageDesignSqlServer)this.storageDesign;
    }

    @Override
    public List getConstraintList() {
        if (this.constraintList == null) {
            this.constraintList = new ArrayList();
        }
        return this.constraintList;
    }

    @Override
    public List getFkList() {
        if (this.fkList == null) {
            this.fkList = new ArrayList();
        }
        return this.fkList;
    }

    @Override
    public List getIndexList() {
        if (this.indexList == null) {
            this.indexList = new ArrayList();
        }
        return this.indexList;
    }

    @Override
    public List getTableList() {
        if (this.tableList == null) {
            this.tableList = new ArrayList();
        }
        return this.tableList;
    }

    @Override
    public List getViewList() {
        if (this.viewList == null) {
            this.viewList = new ArrayList();
        }
        return this.viewList;
    }

    public List getDatabaseList() {
        if (this.databaseList == null) {
            this.databaseList = new ArrayList();
        }
        return this.databaseList;
    }

    public List getTriggerList() {
        if (this.triggerList == null) {
            this.triggerList = new ArrayList();
        }
        return this.triggerList;
    }

    public List getUserList() {
        if (this.userList == null) {
            this.userList = new ArrayList();
        }
        return this.userList;
    }

    public List getDefaultList() {
        if (this.defaultList == null) {
            this.defaultList = new ArrayList();
        }
        return this.defaultList;
    }

    public List getRoleList() {
        if (this.roleList == null) {
            this.roleList = new ArrayList();
        }
        return this.roleList;
    }

    public List getRuleList() {
        if (this.ruleList == null) {
            this.ruleList = new ArrayList();
        }
        return this.ruleList;
    }

    public List getProcedureList() {
        if (this.procedureList == null) {
            this.procedureList = new ArrayList();
        }
        return this.procedureList;
    }

    public List getTypeList() {
        if (this.typeList == null) {
            this.typeList = new ArrayList();
        }
        return this.typeList;
    }

    @Override
    public List getSchemaList() {
        if (this.schemaList == null) {
            this.schemaList = new ArrayList();
        }
        return this.schemaList;
    }

    private void putNodeIcon(ModelIdObjectSelection modelIdObjectSelection, String string) {
        DDLTreeNodeName dDLTreeNodeName = DDLTreeNodeName.fromString(string);
        if (dDLTreeNodeName != null) {
            switch (DDLTreeNodeName.fromString(string)) {
                case NN_ROLES: {
                    modelIdObjectSelection.setElementDescriptor(RoleSet.class);
                    break;
                }
                case NN_INDEXES: {
                    modelIdObjectSelection.setElementDescriptor(IndexSet.class);
                    break;
                }
                case NN_FOREIGN_KEYS: {
                    modelIdObjectSelection.setElementDescriptor(FKIndexAssociationSet.class);
                    break;
                }
                case NN_TRIGGERS: {
                    modelIdObjectSelection.setElementDescriptor(TriggerSetSqlServer.class);
                    break;
                }
                case NN_STORED_PROCEDURES: {
                    modelIdObjectSelection.setElementDescriptor(StoredProcedureSqlServer.class);
                    break;
                }
                case NN_USER_DEFINED_TYPES: {
                    modelIdObjectSelection.setElementDescriptor(StructuredTypeProxyOracle.class);
                    break;
                }
                case NN_DEFAULTS: {
                    modelIdObjectSelection.setElementDescriptor(DefaultSqlServerv2k5.class);
                    break;
                }
                case NN_RULES: {
                    modelIdObjectSelection.setElementDescriptor(RuleSqlServerv2k.class);
                    break;
                }
            }
        }
    }

    static /* synthetic */ String access$000() {
        return INDEXES;
    }

    static /* synthetic */ String access$100() {
        return FOREIGN_KEYS;
    }

    static /* synthetic */ String access$200() {
        return TRIGGERS;
    }

    static /* synthetic */ String access$300() {
        return USER_DEFINED_TYPES;
    }

    private static enum DDLTreeNodeName {
        NN_ROLES(ROLES),
        NN_STORED_PROCEDURES(STORED_PROCEDURES),
        NN_INDEXES(DDLSelectionSqlServerv2k.access$000()),
        NN_FOREIGN_KEYS(DDLSelectionSqlServerv2k.access$100()),
        NN_TRIGGERS(DDLSelectionSqlServerv2k.access$200()),
        NN_USER_DEFINED_TYPES(DDLSelectionSqlServerv2k.access$300()),
        NN_DEFAULTS(DEFAULTS),
        NN_RULES(RULES);

        private String name;

        private DDLTreeNodeName(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public static DDLTreeNodeName fromString(String string) {
            if (string != null) {
                for (DDLTreeNodeName dDLTreeNodeName : DDLTreeNodeName.values()) {
                    if (!string.equals(dDLTreeNodeName.name)) continue;
                    return dDLTreeNodeName;
                }
            }
            return null;
        }
    }
}

