/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.process.RoleSet;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageBodyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SequenceSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StoredProcedureSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SynonymSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TriggerSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ContextOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.SchemaSetUDB;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionLists;

public class DDLSelectionOraclev8i
extends ModelIdObjectSelection
implements DDLSelectionLists {
    private static final String CLUSTERS = Messages.getString("DDLSelectionOraclev8i.Clusters");
    private static final String CONTEXTS = Messages.getString("DDLSelectionOraclev8i.Contexts");
    private static final String DIMENSIONS = Messages.getString("DDLSelectionOraclev8i.Dimensions");
    private static final String DIRECTORIES = Messages.getString("DDLSelectionOraclev8i.Directories");
    private static final String ROLES = Messages.getString("DDLSelectionOraclev8i.Roles");
    private static final String ROLLBACK_SEGMENTS = Messages.getString("DDLSelectionOraclev8i.RollbackSegments");
    private static final String SEQUENCES = Messages.getString("DDLSelectionOraclev8i.Sequences");
    private static final String SNAPSHOTS = Messages.getString("DDLSelectionOraclev8i.Snapshots");
    private static final String PACKAGES = Messages.getString("DDLSelectionOraclev8i.Packages");
    private static final String STORED_PROCEDURES = Messages.getString("DDLSelectionOraclev8i.StoredProcedures");
    private static final String FUNCTIONS = Messages.getString("DDLSelectionOraclev8i.Functions");
    private static final String PACKAGE_BODIES = Messages.getString("DDLSelectionOraclev8i.PackageBodies");
    private static final String STRUCTURED_TYPES = Messages.getString("DDLSelectionOraclev8i.StructuredTypes");
    private static final String TABLES = Messages.getString("DDLSelectionOraclev8i.Tables");
    private static final String SYNONYMS = Messages.getString("DDLSelectionOraclev8i.Synonyms");
    private static final String TABLESPACES = Messages.getString("DDLSelectionOraclev8i.Tablespaces");
    private static final String TEMP_TABLESPACES = Messages.getString("DDLSelectionOraclev8i.TempTablespaces");
    private static final String ASSIGNED_TO_USERS = Messages.getString("DDLSelectionOraclev8i.AssignedToUsers");
    private static final String NOT_ASSIGNED_TO_USERS = Messages.getString("DDLSelectionOraclev8i.NotAssignedToUsers");
    private static final String USERS = Messages.getString("DDLSelectionOraclev8i.UsersSchemas");
    private static final String VIEWS = Messages.getString("DDLSelectionOraclev8i.Views");
    private static final String CONSTRAINTS = Messages.getString("DDLSelectionOraclev8i.PKUKConstraints");
    private static final String INDEXES = Messages.getString("DDLSelectionOraclev8i.Indexes");
    private static final String FOREIGN_KEYS = Messages.getString("DDLSelectionOraclev8i.ForeignKeys");
    private static final String TRIGGERS = Messages.getString("DDLSelectionOraclev8i.Triggers");
    private StorageDesign stdes;
    private RelationalDesign phdes;
    private List triggerList;
    private List clusterList;
    private List dimensionList;
    private List sequenceList;
    private List snapshotList;
    private List packagesList;
    private List packageBodiesList;
    private List storedProceduresList;
    private List functionsList;
    private List synonymList;
    private List typeList;
    private List bjList;
    private List extTableList;
    private List collTypeList;
    private DesignPartView selectedSubView = null;

    public DDLSelectionOraclev8i(StorageDesign storageDesign) {
        super(storageDesign.getName());
        this.stdes = storageDesign;
        this.phdes = this.stdes.getPhysicalDesign();
        if (storageDesign.isOpen()) {
            this.setElementDescriptor(storageDesign.getClass());
            this.addFromStorageDesign();
        } else {
            this.setName(this.phdes.getName());
            this.addCommonObjectsFromRelationalModel(this.phdes, this.selectedSubView);
            this.addSpecificObjectsFromRelationalModel();
        }
    }

    public DDLSelectionOraclev8i(StorageDesign storageDesign, DesignPartView designPartView) {
        super(storageDesign.getName());
        this.stdes = storageDesign;
        this.phdes = this.stdes.getPhysicalDesign();
        this.selectedSubView = designPartView;
        if (storageDesign.isOpen()) {
            this.setElementDescriptor(storageDesign.getClass());
            this.addFromStorageDesign();
        } else if (designPartView != null) {
            this.setName(designPartView.getName());
            this.addCommonObjectsFromRelationalModel(this.phdes, designPartView);
            this.addSpecificObjectsFromRelationalModel();
        }
    }

    protected void addFromStorageDesign() {
        this.addObjects(CONTEXTS, this, this.getStorageDesign().getContextSet().getElementsList());
        this.addObjects(DIRECTORIES, this, this.getStorageDesign().getDirectorySet().getElementsList());
        this.addObjects(ROLES, this, this.getStorageDesign().getRoleSet().getElementsList());
        this.addObjects(ROLLBACK_SEGMENTS, this, this.getStorageDesign().getRollbackSegmentSet().getElementsList());
        this.addObjects(TABLESPACES, this, this.getStorageDesign().getTableSpaceSet().getElementsList());
        this.addObjects(TEMP_TABLESPACES, this, this.getStorageDesign().getTemporaryTablespaceSet().getElementsList());
        this.addUsers(USERS, this, this.getStorageDesign().getUserSet().getElementsList());
        this.addObjectsAssignedToUsers(ASSIGNED_TO_USERS, this, this.getStorageDesign().getUserSet().getElementsList());
        this.addObjectsNotAssignedToUsers(NOT_ASSIGNED_TO_USERS, this);
        this.sort();
    }

    protected void addUsers(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(SchemaSetSqlServerv2k5.class);
        for (UserOracle userOracle : list) {
            ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(userOracle);
            modelIdObjectSelection2.addChild(modelIdObjectSelection3);
        }
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    protected void addObjectsAssignedToUsers(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(SchemaObjectSet.class);
        for (UserOracle userOracle : list) {
            ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(userOracle.getName());
            modelIdObjectSelection3.setElementDescriptor(SchemaObject.class);
            this.addUserDetails(userOracle, modelIdObjectSelection3);
            modelIdObjectSelection2.addChild(modelIdObjectSelection3);
        }
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    protected void addObjectsNotAssignedToUsers(String string, ModelIdObjectSelection modelIdObjectSelection) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(SchemaSetUDB.class);
        this.addContainerObjects(CLUSTERS, modelIdObjectSelection2, this.getClustersWithoutUser(), this.getClusterList());
        this.addContainerObjects(DIMENSIONS, modelIdObjectSelection2, this.getDimensionsWithoutUser(), this.getDimensionList());
        this.addContainerObjects(SEQUENCES, modelIdObjectSelection2, this.getSequencesWithoutUser(), this.getSequenceList());
        this.addContainerObjects(SNAPSHOTS, modelIdObjectSelection2, this.getSnapshotsWithoutUser(), this.getSnapshotList());
        this.addPackages(modelIdObjectSelection2);
        this.addContainerObjects(STORED_PROCEDURES, modelIdObjectSelection2, this.getProcWithoutUser(), this.getStoredProceduresList());
        this.addContainerObjects(FUNCTIONS, modelIdObjectSelection2, this.getFunctionsWithoutUser(), this.getFunctionsList());
        this.addStructuredTypes(STRUCTURED_TYPES, modelIdObjectSelection2, this.getStrTypeWithoutUser(), this.getTypeList());
        this.addContainerObjects(SYNONYMS, modelIdObjectSelection2, this.getSynonymsWithoutUser(), this.getSynonymList());
        this.addTables(TABLES, modelIdObjectSelection2, this.getTableWithoutUser());
        this.addViews(VIEWS, modelIdObjectSelection2, this.getViewWithoutUser());
        modelIdObjectSelection2.sort();
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    protected void addObjects(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection((ModelIDObject)e, true);
                modelIdObjectSelection2.setElementDescriptor(e.getClass());
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    protected void addStructuredTypes(String string, ModelIdObjectSelection modelIdObjectSelection, List list, List list2) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(StructuredTypeProxyOracle.class);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                StructuredTypeProxyOracle structuredTypeProxyOracle = (StructuredTypeProxyOracle)iterator.next();
                if (((StructuredType)structuredTypeProxyOracle.getObject()).isPredefined()) continue;
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(structuredTypeProxyOracle, true);
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
                list2.add(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    protected void addTables(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(TableSet.class);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                TableProxyOracle tableProxyOracle = (TableProxyOracle)iterator.next();
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(tableProxyOracle, true);
                this.addTableProxyDetails(tableProxyOracle, modelIdObjectSelection3);
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
                this.getTableList().add(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    protected void addViews(String string, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        modelIdObjectSelection2.setElementDescriptor(TableViewSet.class);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                TableViewProxy tableViewProxy = (TableViewProxy)iterator.next();
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(tableViewProxy, true);
                this.addViewProxyDetails(tableViewProxy, modelIdObjectSelection3);
                modelIdObjectSelection2.addChild(modelIdObjectSelection3);
                this.getViewList().add(modelIdObjectSelection3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    protected void addPackages(ModelIdObjectSelection modelIdObjectSelection) {
        List<ModelIdObjectSelection> list = this.addContainerObjects(PACKAGES, modelIdObjectSelection, this.getPackagesWithoutUser(), this.getPackagesList());
        for (ModelIdObjectSelection modelIdObjectSelection2 : list) {
            List list2 = this.getPackageBodiesList();
            PackageBodyOracle packageBodyOracle = ((PackageOracle)modelIdObjectSelection2.getObject()).getBody();
            if (packageBodyOracle == null) continue;
            this.addContainerObject(modelIdObjectSelection2, packageBodyOracle, list2);
        }
    }

    protected void addTableProxyDetails(TableProxyOracle tableProxyOracle, ModelIdObjectSelection modelIdObjectSelection) {
        Object object;
        if (tableProxyOracle.getPrimaryKeys().size() > 0 || tableProxyOracle.getUniqueKeys().size() > 0) {
            ModelIdObjectSelection modelIdObjectSelection2;
            IndexProxy indexProxy;
            object = new ModelIdObjectSelection(CONSTRAINTS);
            Iterator iterator = tableProxyOracle.getPrimaryKeys().iterator();
            while (iterator.hasNext()) {
                indexProxy = (IndexProxy)iterator.next();
                modelIdObjectSelection2 = new ModelIdObjectSelection(indexProxy, true);
                modelIdObjectSelection2.setName("(PK) " + indexProxy.getName());
                ((ModelIdObjectSelection)object).addChild(modelIdObjectSelection2);
                this.getConstraintList().add(modelIdObjectSelection2);
            }
            iterator = tableProxyOracle.getUniqueKeys().iterator();
            while (iterator.hasNext()) {
                indexProxy = (IndexProxy)iterator.next();
                modelIdObjectSelection2 = new ModelIdObjectSelection(indexProxy, true);
                ((ModelIdObjectSelection)object).addChild(modelIdObjectSelection2);
                this.getConstraintList().add(modelIdObjectSelection2);
            }
            modelIdObjectSelection.addChild((ModelIdObjectSelection)object);
        }
        if (tableProxyOracle.getIndexes().size() > 0) {
            this.addContainerObjects(INDEXES, modelIdObjectSelection, tableProxyOracle.getIndexes().getElementsList(), this.getIndexList());
        }
        if (tableProxyOracle.getFKeys().size() > 0) {
            this.addContainerObjects(FOREIGN_KEYS, modelIdObjectSelection, tableProxyOracle.getFKeys().getElementsList(), this.getFkList());
        }
        if ((object = this.getTriggersForTable(this.getStorageDesign(), tableProxyOracle)).size() > 0) {
            this.addContainerObjects(TRIGGERS, modelIdObjectSelection, (List)object, this.getTriggerList());
        }
    }

    protected List<ModelIdObjectSelection> addContainerObjects(String string, ModelIdObjectSelection modelIdObjectSelection, List list, List list2) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(string);
        List<ModelIdObjectSelection> list3 = this.addContainerObjects(modelIdObjectSelection2, list);
        if (list3.size() > 0) {
            this.putNodeIcon(modelIdObjectSelection2, string);
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
            list2.addAll(list3);
        }
        return list3;
    }

    protected List<ModelIdObjectSelection> addContainerObjects(ModelIdObjectSelection modelIdObjectSelection, List list) {
        ArrayList<ModelIdObjectSelection> arrayList = new ArrayList<ModelIdObjectSelection>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addContainerObject(modelIdObjectSelection, (ModelIDObject)iterator.next(), arrayList);
        }
        return arrayList;
    }

    protected void addContainerObject(ModelIdObjectSelection modelIdObjectSelection, ModelIDObject modelIDObject, List<ModelIdObjectSelection> list) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(modelIDObject);
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
        list.add(modelIdObjectSelection2);
    }

    protected void addViewProxyDetails(TableViewProxy tableViewProxy, ModelIdObjectSelection modelIdObjectSelection) {
        List list = this.getTriggersForView(this.getStorageDesign(), tableViewProxy);
        if (list.size() > 0) {
            this.addContainerObjects(TRIGGERS, modelIdObjectSelection, list, this.getTriggerList());
        }
    }

    protected void addUserDetails(UserOracle userOracle, ModelIdObjectSelection modelIdObjectSelection) {
        List<PlSqlSourceStorageObjectOracle> list = this.getClustersForUser(userOracle);
        if (list.size() > 0) {
            this.addContainerObjects(CLUSTERS, modelIdObjectSelection, list, this.getClusterList());
        }
        if ((list = this.getDimensionsForUser(userOracle)).size() > 0) {
            this.addContainerObjects(DIMENSIONS, modelIdObjectSelection, list, this.getDimensionList());
        }
        if ((list = this.getSequencesForUser(userOracle)).size() > 0) {
            this.addContainerObjects(SEQUENCES, modelIdObjectSelection, list, this.getSequenceList());
        }
        if ((list = this.getSnapshotsForUser(userOracle)).size() > 0) {
            this.addContainerObjects(SNAPSHOTS, modelIdObjectSelection, list, this.getSnapshotList());
        }
        if ((list = this.getPackagesForUser(userOracle)).size() > 0) {
            this.addContainerObjects(PACKAGES, modelIdObjectSelection, list, this.getPackagesList());
        }
        if ((list = this.getPackageBodiesForUser(userOracle)).size() > 0) {
            this.addContainerObjects(PACKAGE_BODIES, modelIdObjectSelection, list, this.getPackageBodiesList());
        }
        if ((list = this.getProcForUser(userOracle)).size() > 0) {
            this.addContainerObjects(STORED_PROCEDURES, modelIdObjectSelection, list, this.getStoredProceduresList());
        }
        if ((list = this.getFunctionsForUser(userOracle)).size() > 0) {
            this.addContainerObjects(FUNCTIONS, modelIdObjectSelection, list, this.getFunctionsList());
        }
        if ((list = this.getSynonymsForUser(userOracle)).size() > 0) {
            this.addContainerObjects(SYNONYMS, modelIdObjectSelection, list, this.getSynonymList());
        }
        if ((list = this.getStrTypeForUser(userOracle)).size() > 0) {
            this.addStructuredTypes(STRUCTURED_TYPES, modelIdObjectSelection, list, this.getTypeList());
        }
        if ((list = this.getTableForUser(userOracle)).size() > 0) {
            this.addTables(TABLES, modelIdObjectSelection, list);
        }
        if ((list = this.getViewForUser(userOracle)).size() > 0) {
            this.addViews(VIEWS, modelIdObjectSelection, list);
        }
        modelIdObjectSelection.sort();
    }

    private List getClustersForUser(UserOracle userOracle) {
        ArrayList<ClusterOracle> arrayList = new ArrayList<ClusterOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getClusterSet().iterator();
        while (iterator.hasNext()) {
            ClusterOracle clusterOracle = (ClusterOracle)iterator.next();
            if (clusterOracle.getUser() == null || !clusterOracle.getUser().getObjectID().equalsIgnoreCase(userOracle.getObjectID())) continue;
            arrayList.add(clusterOracle);
        }
        return arrayList;
    }

    private List getClustersWithoutUser() {
        ArrayList<ClusterOracle> arrayList = new ArrayList<ClusterOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getClusterSet().iterator();
        while (iterator.hasNext()) {
            ClusterOracle clusterOracle = (ClusterOracle)iterator.next();
            if (clusterOracle.getUser() != null) continue;
            arrayList.add(clusterOracle);
        }
        return arrayList;
    }

    private List getDimensionsForUser(UserOracle userOracle) {
        ArrayList<DimensionOracle> arrayList = new ArrayList<DimensionOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getDimensionSet().iterator();
        while (iterator.hasNext()) {
            DimensionOracle dimensionOracle = (DimensionOracle)iterator.next();
            if (dimensionOracle.getUser() == null || !dimensionOracle.getUser().getObjectID().equalsIgnoreCase(userOracle.getObjectID())) continue;
            arrayList.add(dimensionOracle);
        }
        return arrayList;
    }

    private List getDimensionsWithoutUser() {
        ArrayList<DimensionOracle> arrayList = new ArrayList<DimensionOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getDimensionSet().iterator();
        while (iterator.hasNext()) {
            DimensionOracle dimensionOracle = (DimensionOracle)iterator.next();
            if (dimensionOracle.getUser() != null) continue;
            arrayList.add(dimensionOracle);
        }
        return arrayList;
    }

    private List getSequencesForUser(UserOracle userOracle) {
        ArrayList<SequenceOracle> arrayList = new ArrayList<SequenceOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getSequenceSet().iterator();
        while (iterator.hasNext()) {
            SequenceOracle sequenceOracle = (SequenceOracle)iterator.next();
            if (sequenceOracle.getUser() == null || !sequenceOracle.getUser().getObjectID().equalsIgnoreCase(userOracle.getObjectID())) continue;
            arrayList.add(sequenceOracle);
        }
        return arrayList;
    }

    private List getSequencesWithoutUser() {
        ArrayList<SequenceOracle> arrayList = new ArrayList<SequenceOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getSequenceSet().iterator();
        while (iterator.hasNext()) {
            SequenceOracle sequenceOracle = (SequenceOracle)iterator.next();
            if (sequenceOracle.getUser() != null) continue;
            arrayList.add(sequenceOracle);
        }
        return arrayList;
    }

    private List getSnapshotsForUser(UserOracle userOracle) {
        ArrayList<SnapshotOracle> arrayList = new ArrayList<SnapshotOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getSnapshotSet().iterator();
        while (iterator.hasNext()) {
            SnapshotOracle snapshotOracle = (SnapshotOracle)iterator.next();
            if (snapshotOracle.getUser() == null || !snapshotOracle.getUser().getObjectID().equalsIgnoreCase(userOracle.getObjectID())) continue;
            arrayList.add(snapshotOracle);
        }
        return arrayList;
    }

    private List getSnapshotsWithoutUser() {
        ArrayList<SnapshotOracle> arrayList = new ArrayList<SnapshotOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getSnapshotSet().iterator();
        while (iterator.hasNext()) {
            SnapshotOracle snapshotOracle = (SnapshotOracle)iterator.next();
            if (snapshotOracle.getUser() != null) continue;
            arrayList.add(snapshotOracle);
        }
        return arrayList;
    }

    private List<PackageOracle> getPackagesForUser(UserOracle userOracle) {
        ArrayList<PackageOracle> arrayList = new ArrayList<PackageOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getPackageSet().iterator();
        while (iterator.hasNext()) {
            PackageOracle packageOracle = (PackageOracle)iterator.next();
            UserOracle userOracle2 = packageOracle.getOwner();
            if (userOracle2 == null || !userOracle2.getObjectID().equalsIgnoreCase(userOracle.getObjectID())) continue;
            arrayList.add(packageOracle);
        }
        return arrayList;
    }

    private List<PackageOracle> getPackagesWithoutUser() {
        ArrayList<PackageOracle> arrayList = new ArrayList<PackageOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getPackageSet().iterator();
        while (iterator.hasNext()) {
            PackageOracle packageOracle = (PackageOracle)iterator.next();
            if (packageOracle.getOwner() != null) continue;
            arrayList.add(packageOracle);
        }
        return arrayList;
    }

    private List getProcForUser(UserOracle userOracle) {
        ArrayList<StoredProcedureOracle> arrayList = new ArrayList<StoredProcedureOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getStoredProcedureSet().iterator();
        while (iterator.hasNext()) {
            StoredProcedureOracle storedProcedureOracle = (StoredProcedureOracle)iterator.next();
            if (storedProcedureOracle.getOwner() == null || !storedProcedureOracle.getOwner().getObjectID().equalsIgnoreCase(userOracle.getObjectID())) continue;
            arrayList.add(storedProcedureOracle);
        }
        return arrayList;
    }

    private List getProcWithoutUser() {
        ArrayList<StoredProcedureOracle> arrayList = new ArrayList<StoredProcedureOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getStoredProcedureSet().iterator();
        while (iterator.hasNext()) {
            StoredProcedureOracle storedProcedureOracle = (StoredProcedureOracle)iterator.next();
            if (storedProcedureOracle.getOwner() != null) continue;
            arrayList.add(storedProcedureOracle);
        }
        return arrayList;
    }

    private List<FunctionOracle> getFunctionsForUser(UserOracle userOracle) {
        ArrayList<FunctionOracle> arrayList = new ArrayList<FunctionOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getFunctionSet().iterator();
        while (iterator.hasNext()) {
            FunctionOracle functionOracle = (FunctionOracle)iterator.next();
            UserOracle userOracle2 = functionOracle.getOwner();
            if (userOracle2 == null || !userOracle2.getObjectID().equalsIgnoreCase(userOracle.getObjectID())) continue;
            arrayList.add(functionOracle);
        }
        return arrayList;
    }

    private List<FunctionOracle> getFunctionsWithoutUser() {
        ArrayList<FunctionOracle> arrayList = new ArrayList<FunctionOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getFunctionSet().iterator();
        while (iterator.hasNext()) {
            FunctionOracle functionOracle = (FunctionOracle)iterator.next();
            if (functionOracle.getOwner() != null) continue;
            arrayList.add(functionOracle);
        }
        return arrayList;
    }

    private List<PackageBodyOracle> getPackageBodiesForUser(UserOracle userOracle) {
        ArrayList<PackageBodyOracle> arrayList = new ArrayList<PackageBodyOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getPackageSet().iterator();
        while (iterator.hasNext()) {
            PackageBodyOracle packageBodyOracle;
            PackageOracle packageOracle = (PackageOracle)iterator.next();
            UserOracle userOracle2 = packageOracle.getOwner();
            if (userOracle2 == null || !userOracle2.getObjectID().equalsIgnoreCase(userOracle.getObjectID()) || (packageBodyOracle = packageOracle.getBody()) == null) continue;
            arrayList.add(packageBodyOracle);
        }
        return arrayList;
    }

    private List getSynonymsForUser(UserOracle userOracle) {
        ArrayList<SynonymOracle> arrayList = new ArrayList<SynonymOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getSynonymSet().iterator();
        while (iterator.hasNext()) {
            SynonymOracle synonymOracle = (SynonymOracle)iterator.next();
            if (synonymOracle.getUser() == null || !synonymOracle.getUser().getObjectID().equalsIgnoreCase(userOracle.getObjectID())) continue;
            arrayList.add(synonymOracle);
        }
        return arrayList;
    }

    private List getSynonymsWithoutUser() {
        ArrayList<SynonymOracle> arrayList = new ArrayList<SynonymOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getSynonymSet().iterator();
        while (iterator.hasNext()) {
            SynonymOracle synonymOracle = (SynonymOracle)iterator.next();
            if (synonymOracle.getUser() != null) continue;
            arrayList.add(synonymOracle);
        }
        return arrayList;
    }

    private List getStrTypeForUser(UserOracle userOracle) {
        ArrayList<StructuredTypeProxyOracle> arrayList = new ArrayList<StructuredTypeProxyOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getStructuredTypeProxySet().iterator();
        while (iterator.hasNext()) {
            StructuredTypeProxyOracle structuredTypeProxyOracle = (StructuredTypeProxyOracle)iterator.next();
            if (structuredTypeProxyOracle.getOwner() == null || !structuredTypeProxyOracle.getOwner().getObjectID().equalsIgnoreCase(userOracle.getObjectID())) continue;
            arrayList.add(structuredTypeProxyOracle);
        }
        return arrayList;
    }

    private List getStrTypeWithoutUser() {
        ArrayList<StructuredTypeProxyOracle> arrayList = new ArrayList<StructuredTypeProxyOracle>();
        Iterator iterator = ((StorageDesignOracle)this.stdes).getStructuredTypeProxySet().iterator();
        while (iterator.hasNext()) {
            StructuredTypeProxyOracle structuredTypeProxyOracle = (StructuredTypeProxyOracle)iterator.next();
            if (structuredTypeProxyOracle.getOwner() != null) continue;
            arrayList.add(structuredTypeProxyOracle);
        }
        return arrayList;
    }

    private List getTableForUser(UserOracle userOracle) {
        ArrayList<TableProxyOracle> arrayList = new ArrayList<TableProxyOracle>();
        Iterator iterator = this.selectedSubView != null ? ((StorageDesignOracle)this.stdes).getSubViewTableProxySet().iterator() : ((StorageDesignOracle)this.stdes).getTableProxySet().iterator();
        while (iterator.hasNext()) {
            Table table;
            TableProxyOracle tableProxyOracle = (TableProxyOracle)iterator.next();
            if (tableProxyOracle.getUser() != null && tableProxyOracle.getUser().getObjectID().equalsIgnoreCase(userOracle.getObjectID())) {
                arrayList.add(tableProxyOracle);
                continue;
            }
            if (tableProxyOracle.getUser() != null || (table = (Table)tableProxyOracle.getObject()).getSchemaObject() == null || table.getSchemaObject() != userOracle.getSchemaObject()) continue;
            arrayList.add(tableProxyOracle);
        }
        return arrayList;
    }

    private List getTableWithoutUser() {
        ArrayList<TableProxyOracle> arrayList = new ArrayList<TableProxyOracle>();
        Iterator iterator = this.selectedSubView != null ? ((StorageDesignOracle)this.stdes).getSubViewTableProxySet().iterator() : ((StorageDesignOracle)this.stdes).getTableProxySet().iterator();
        while (iterator.hasNext()) {
            Table table;
            TableProxyOracle tableProxyOracle = (TableProxyOracle)iterator.next();
            if (tableProxyOracle.getUser() != null || (table = (Table)tableProxyOracle.getObject()).getSchemaObject() != null && tableProxyOracle.getStorageDesign().getUserSchemaSet().getBySchemaObject(table.getSchemaObject()) != null) continue;
            arrayList.add(tableProxyOracle);
        }
        return arrayList;
    }

    private List getViewForUser(UserOracle userOracle) {
        ArrayList<TableViewProxyOracle> arrayList = new ArrayList<TableViewProxyOracle>();
        Iterator iterator = this.selectedSubView != null ? ((StorageDesignOracle)this.stdes).getSubViewTableViewProxySet().iterator() : ((StorageDesignOracle)this.stdes).getTableViewProxySet().iterator();
        while (iterator.hasNext()) {
            TableView tableView;
            TableViewProxyOracle tableViewProxyOracle = (TableViewProxyOracle)iterator.next();
            if (tableViewProxyOracle.getUser() != null && tableViewProxyOracle.getUser().getObjectID().equalsIgnoreCase(userOracle.getObjectID())) {
                arrayList.add(tableViewProxyOracle);
                continue;
            }
            if (tableViewProxyOracle.getUser() != null || (tableView = (TableView)tableViewProxyOracle.getObject()).getSchemaObject() == null || tableView.getSchemaObject() != userOracle.getSchemaObject()) continue;
            arrayList.add(tableViewProxyOracle);
        }
        return arrayList;
    }

    private List getViewWithoutUser() {
        ArrayList<TableViewProxyOracle> arrayList = new ArrayList<TableViewProxyOracle>();
        Iterator iterator = this.selectedSubView != null ? ((StorageDesignOracle)this.stdes).getSubViewTableViewProxySet().iterator() : ((StorageDesignOracle)this.stdes).getTableViewProxySet().iterator();
        while (iterator.hasNext()) {
            TableView tableView;
            TableViewProxyOracle tableViewProxyOracle = (TableViewProxyOracle)iterator.next();
            if (tableViewProxyOracle.getUser() != null || (tableView = (TableView)tableViewProxyOracle.getObject()).getSchemaObject() != null && tableViewProxyOracle.getStorageDesign().getUserSchemaSet().getBySchemaObject(tableView.getSchemaObject()) != null) continue;
            arrayList.add(tableViewProxyOracle);
        }
        return arrayList;
    }

    public List getTriggerList() {
        if (this.triggerList == null) {
            this.triggerList = new ArrayList();
        }
        return this.triggerList;
    }

    public List getClusterList() {
        if (this.clusterList == null) {
            this.clusterList = new ArrayList();
        }
        return this.clusterList;
    }

    public List getDimensionList() {
        if (this.dimensionList == null) {
            this.dimensionList = new ArrayList();
        }
        return this.dimensionList;
    }

    public List getSequenceList() {
        if (this.sequenceList == null) {
            this.sequenceList = new ArrayList();
        }
        return this.sequenceList;
    }

    public List getSnapshotList() {
        if (this.snapshotList == null) {
            this.snapshotList = new ArrayList();
        }
        return this.snapshotList;
    }

    public List getPackagesList() {
        if (this.packagesList == null) {
            this.packagesList = new ArrayList();
        }
        return this.packagesList;
    }

    public List getPackageBodiesList() {
        if (this.packageBodiesList == null) {
            this.packageBodiesList = new ArrayList();
        }
        return this.packageBodiesList;
    }

    public List getStoredProceduresList() {
        if (this.storedProceduresList == null) {
            this.storedProceduresList = new ArrayList();
        }
        return this.storedProceduresList;
    }

    public List getFunctionsList() {
        if (this.functionsList == null) {
            this.functionsList = new ArrayList();
        }
        return this.functionsList;
    }

    public List getSynonymList() {
        if (this.synonymList == null) {
            this.synonymList = new ArrayList();
        }
        return this.synonymList;
    }

    public List getTypeList() {
        if (this.typeList == null) {
            this.typeList = new ArrayList();
        }
        return this.typeList;
    }

    protected StorageDesignOracle getStorageDesign() {
        return (StorageDesignOracle)this.stdes;
    }

    private List getTriggersForTable(StorageDesignOracle storageDesignOracle, TableProxy tableProxy) {
        ArrayList<TriggerOracle> arrayList = new ArrayList<TriggerOracle>();
        if (storageDesignOracle.getTriggerSet().size() > 0) {
            Iterator iterator = storageDesignOracle.getTriggerSet().iterator();
            while (iterator.hasNext()) {
                TriggerOracle triggerOracle = (TriggerOracle)iterator.next();
                if (triggerOracle.getTable() == null || !triggerOracle.getTable().equals(tableProxy)) continue;
                arrayList.add(triggerOracle);
            }
        }
        return arrayList;
    }

    private List getTriggersForView(StorageDesignOracle storageDesignOracle, TableViewProxy tableViewProxy) {
        ArrayList<TriggerOracle> arrayList = new ArrayList<TriggerOracle>();
        if (storageDesignOracle.getTriggerSet().size() > 0) {
            Iterator iterator = storageDesignOracle.getTriggerSet().iterator();
            while (iterator.hasNext()) {
                TriggerOracle triggerOracle = (TriggerOracle)iterator.next();
                if (triggerOracle.getView() == null || !triggerOracle.getView().equals(tableViewProxy)) continue;
                arrayList.add(triggerOracle);
            }
        }
        return arrayList;
    }

    private void addSpecificObjectsFromRelationalModel() {
        ModelObject modelObject;
        ModelObject modelObject2;
        Iterator iterator = ((StorageDesignOracle)this.stdes).getStructuredTypeProxySet().iterator();
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("DDLSelectionOraclev8i.StructuredTypes"));
        modelIdObjectSelection.setElementDescriptor(StructuredTypeProxyOracle.class);
        while (iterator.hasNext()) {
            modelObject2 = (StructuredTypeProxyOracle)iterator.next();
            if (((StructuredType)((RelationalObjectProxy)modelObject2).getObject()).isPredefined()) continue;
            modelObject = new ModelIdObjectSelection((ModelIDObject)modelObject2);
            modelIdObjectSelection.addChild((ModelIdObjectSelection)modelObject);
        }
        this.addChild(modelIdObjectSelection);
        if (this.stdes instanceof StorageDesignOraclev9i || this.stdes instanceof StorageDesignOraclev10g) {
            iterator = ((StorageDesignOracle)this.stdes).getCollectionTypeProxySet().iterator();
            modelObject2 = new ModelIdObjectSelection(Messages.getString("DDLSelectionOraclev8i.CollectionTypes"));
            ((ModelIdObjectSelection)modelObject2).setElementDescriptor(StructuredTypeProxyOracle.class);
            while (iterator.hasNext()) {
                modelObject = (CollectionTypeProxyOracle)iterator.next();
                ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection((ModelIDObject)modelObject);
                ((ModelIdObjectSelection)modelObject2).addChild(modelIdObjectSelection2);
            }
            this.addChild((ModelIdObjectSelection)modelObject2);
        }
    }

    public void setSelectedSubView(DesignPartView designPartView) {
        this.selectedSubView = designPartView;
    }

    private void addTableDetails(Table table, ModelIdObjectSelection modelIdObjectSelection) {
        ModelIdObjectSelection modelIdObjectSelection2;
        Object object;
        ModelObject modelObject;
        Object object2;
        if (table.getPKandUKConstraints().size() > 0) {
            object2 = new ModelIdObjectSelection(Messages.getString("DDLSelectionOraclev8i.PKUKConstraints"));
            for (DesignObject designObject : table.getPKandUKConstraints()) {
                modelObject = new ModelIdObjectSelection(designObject);
                if (((KeyObject)designObject).isPK()) {
                    modelObject.setName("(PK) " + designObject.getName());
                }
                ((ModelIdObjectSelection)object2).addChild((ModelIdObjectSelection)modelObject);
                this.getConstraintList().add(modelObject);
            }
            modelIdObjectSelection.addChild((ModelIdObjectSelection)object2);
        }
        if (table.getIndexes().size() > 0) {
            object2 = new ModelIdObjectSelection(Messages.getString("DDLSelectionOraclev8i.Indexes"));
            object = table.getIndexes().iterator();
            while (object.hasNext()) {
                DesignObject designObject;
                designObject = (ContainerObjectPlaceHolder)object.next();
                modelObject = (Index)((DesignObjectPlaceHolder)designObject).getDesignObject();
                modelIdObjectSelection2 = new ModelIdObjectSelection((ModelIDObject)modelObject);
                ((ModelIdObjectSelection)object2).addChild(modelIdObjectSelection2);
                this.getIndexList().add(modelIdObjectSelection2);
            }
            modelIdObjectSelection.addChild((ModelIdObjectSelection)object2);
        }
        if (((FKIndexAssociation[])(object2 = table.getFKAssociations())).length > 0) {
            object = new ModelIdObjectSelection(Messages.getString("DDLSelectionOraclev8i.ForeignKeys"));
            for (int i = 0; i < ((FKIndexAssociation[])object2).length; ++i) {
                modelObject = object2[i];
                modelIdObjectSelection2 = new ModelIdObjectSelection((ModelIDObject)modelObject);
                ((ModelIdObjectSelection)object).addChild(modelIdObjectSelection2);
                this.getFkList().add(modelIdObjectSelection2);
            }
            modelIdObjectSelection.addChild((ModelIdObjectSelection)object);
        }
    }

    public List getBjList() {
        if (this.bjList == null) {
            this.bjList = new ArrayList();
        }
        return this.bjList;
    }

    public List getExtTableList() {
        if (this.extTableList == null) {
            this.extTableList = new ArrayList();
        }
        return this.extTableList;
    }

    public List getCollTypeList() {
        if (this.collTypeList == null) {
            this.collTypeList = new ArrayList();
        }
        return this.collTypeList;
    }

    private void putNodeIcon(ModelIdObjectSelection modelIdObjectSelection, String string) {
        DDLTreeNodeName dDLTreeNodeName = DDLTreeNodeName.fromString(string);
        if (dDLTreeNodeName != null) {
            switch (DDLTreeNodeName.fromString(string)) {
                case NN_CONTEXTS: {
                    modelIdObjectSelection.setElementDescriptor(ContextOraclev9i.class);
                    break;
                }
                case NN_ROLES: {
                    modelIdObjectSelection.setElementDescriptor(RoleSet.class);
                    break;
                }
                case NN_ROLLBACK_SEGMENTS: {
                    modelIdObjectSelection.setElementDescriptor(SegmentOraclev9i.class);
                    break;
                }
                case NN_TABLESPACES: 
                case NN_TEMP_TABLESPACES: {
                    modelIdObjectSelection.setElementDescriptor(TableSpaceOraclev9i.class);
                    break;
                }
                case NN_SNAPSHOTS: {
                    modelIdObjectSelection.setElementDescriptor(SnapshotSetOracle.class);
                    break;
                }
                case NN_FUNCTIONS: {
                    modelIdObjectSelection.setElementDescriptor(FunctionSetOracle.class);
                    break;
                }
                case NN_CLUSTERS: {
                    modelIdObjectSelection.setElementDescriptor(ClusterOraclev9i.class);
                    break;
                }
                case NN_DIMENSIONS: {
                    modelIdObjectSelection.setElementDescriptor(Dimension.class);
                    break;
                }
                case NN_SEQUENCES: {
                    modelIdObjectSelection.setElementDescriptor(SequenceSetOraclev10g.class);
                    break;
                }
                case NN_STORED_PROCEDURES: {
                    modelIdObjectSelection.setElementDescriptor(StoredProcedureSetOraclev10g.class);
                    break;
                }
                case NN_SYNONYMS: {
                    modelIdObjectSelection.setElementDescriptor(SynonymSetOraclev10g.class);
                    break;
                }
                case NN_PACKAGES: 
                case NN_PACKAGE_BODIES: {
                    modelIdObjectSelection.setElementDescriptor(PackageSetOracle.class);
                    break;
                }
                case NN_INDEXES: {
                    modelIdObjectSelection.setElementDescriptor(IndexSet.class);
                    break;
                }
                case NN_FOREIGN_KEYS: {
                    modelIdObjectSelection.setElementDescriptor(FKIndexAssociationSet.class);
                    break;
                }
                case NN_TRIGGERS: {
                    modelIdObjectSelection.setElementDescriptor(TriggerSetOraclev10g.class);
                    break;
                }
            }
        }
    }

    static /* synthetic */ String access$000() {
        return CONTEXTS;
    }

    static /* synthetic */ String access$100() {
        return DIRECTORIES;
    }

    static /* synthetic */ String access$200() {
        return ROLES;
    }

    static /* synthetic */ String access$300() {
        return ROLLBACK_SEGMENTS;
    }

    static /* synthetic */ String access$400() {
        return TABLESPACES;
    }

    static /* synthetic */ String access$500() {
        return TEMP_TABLESPACES;
    }

    static /* synthetic */ String access$600() {
        return SNAPSHOTS;
    }

    static /* synthetic */ String access$700() {
        return FUNCTIONS;
    }

    static /* synthetic */ String access$800() {
        return CLUSTERS;
    }

    static /* synthetic */ String access$900() {
        return DIMENSIONS;
    }

    static /* synthetic */ String access$1000() {
        return SEQUENCES;
    }

    static /* synthetic */ String access$1100() {
        return STORED_PROCEDURES;
    }

    static /* synthetic */ String access$1200() {
        return SYNONYMS;
    }

    static /* synthetic */ String access$1300() {
        return PACKAGES;
    }

    static /* synthetic */ String access$1400() {
        return INDEXES;
    }

    static /* synthetic */ String access$1500() {
        return FOREIGN_KEYS;
    }

    static /* synthetic */ String access$1600() {
        return TRIGGERS;
    }

    static /* synthetic */ String access$1700() {
        return PACKAGE_BODIES;
    }

    private static enum DDLTreeNodeName {
        NN_CONTEXTS(DDLSelectionOraclev8i.access$000()),
        NN_DIRECTORIES(DDLSelectionOraclev8i.access$100()),
        NN_ROLES(DDLSelectionOraclev8i.access$200()),
        NN_ROLLBACK_SEGMENTS(DDLSelectionOraclev8i.access$300()),
        NN_TABLESPACES(DDLSelectionOraclev8i.access$400()),
        NN_TEMP_TABLESPACES(DDLSelectionOraclev8i.access$500()),
        NN_SNAPSHOTS(DDLSelectionOraclev8i.access$600()),
        NN_FUNCTIONS(DDLSelectionOraclev8i.access$700()),
        NN_CLUSTERS(DDLSelectionOraclev8i.access$800()),
        NN_DIMENSIONS(DDLSelectionOraclev8i.access$900()),
        NN_SEQUENCES(DDLSelectionOraclev8i.access$1000()),
        NN_STORED_PROCEDURES(DDLSelectionOraclev8i.access$1100()),
        NN_SYNONYMS(DDLSelectionOraclev8i.access$1200()),
        NN_PACKAGES(DDLSelectionOraclev8i.access$1300()),
        NN_INDEXES(DDLSelectionOraclev8i.access$1400()),
        NN_FOREIGN_KEYS(DDLSelectionOraclev8i.access$1500()),
        NN_TRIGGERS(DDLSelectionOraclev8i.access$1600()),
        NN_PACKAGE_BODIES(DDLSelectionOraclev8i.access$1700());

        private String name;

        private DDLTreeNodeName(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public static DDLTreeNodeName fromString(String string) {
            if (string != null) {
                for (DDLTreeNodeName dDLTreeNodeName : DDLTreeNodeName.values()) {
                    if (!string.equals(dDLTreeNodeName.name)) continue;
                    return dDLTreeNodeName;
                }
            }
            return null;
        }
    }
}

