/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SequenceDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.SynonymSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.udb.SchemaSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceSetUDB;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionLists;

public class DDLSelectionDB2
extends ModelIdObjectSelection
implements DDLSelectionLists {
    private StorageDesign stordes;
    private RelationalDesign phdes;
    private List tableList;
    private List constraintList;
    private List indexList;
    private List fkList;
    private List viewList;
    private List aliasList;
    private List auxTableList;
    private List storedProcedureList;
    private DesignPartView selectedSubView = null;

    public DDLSelectionDB2(StorageDesign storageDesign) {
        super(storageDesign.getName());
        this.stordes = storageDesign;
        this.phdes = this.stordes.getPhysicalDesign();
        if (this.stordes.isOpen()) {
            this.setElementDescriptor(storageDesign.getClass());
            this.addFromStorageDesign();
        } else {
            this.setName(this.phdes.getName());
            this.addFromRelationalModel();
        }
    }

    public DDLSelectionDB2(StorageDesign storageDesign, DesignPartView designPartView) {
        super(storageDesign.getName());
        this.stordes = storageDesign;
        this.selectedSubView = designPartView;
        this.phdes = this.stordes.getPhysicalDesign();
        if (this.stordes.isOpen()) {
            this.setElementDescriptor(storageDesign.getClass());
            this.addFromStorageDesign();
        } else if (designPartView != null) {
            this.setName(designPartView.getName());
            this.addFromSelectedSubView();
        }
    }

    private void addFromStorageDesign() {
        this.addDatabases();
        this.addSchemaDependent();
        this.addDistinctTypes();
        this.addStorageGroups();
    }

    private void addFromRelationalModel() {
        ModelObject modelObject;
        ModelObject modelObject2;
        Iterator iterator = this.phdes.getTableSet().iterator();
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Tables"));
        while (iterator.hasNext()) {
            modelObject2 = (Table)iterator.next();
            modelObject = new ModelIdObjectSelection((ModelIDObject)modelObject2);
            this.addTableDetails((Table)modelObject2, (ModelIdObjectSelection)modelObject);
            modelIdObjectSelection.addChild((ModelIdObjectSelection)modelObject);
            this.getTableList().add(modelObject);
        }
        this.addChild(modelIdObjectSelection);
        iterator = this.phdes.getTableViewSet().iterator();
        modelObject2 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Views"));
        ((ModelIdObjectSelection)modelObject2).setElementDescriptor(TableViewSet.class);
        while (iterator.hasNext()) {
            modelObject = (TableView)iterator.next();
            ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection((ModelIDObject)modelObject);
            ((ModelIdObjectSelection)modelObject2).addChild(modelIdObjectSelection2);
            this.getViewList().add(modelIdObjectSelection2);
        }
        this.addChild((ModelIdObjectSelection)modelObject2);
    }

    private void addFromSelectedSubView() {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Tables"));
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Views"));
        if (this.selectedSubView != null) {
            for (int i = 0; i < this.selectedSubView.getComponentCount(); ++i) {
                String string = this.selectedSubView.getChild(i).getName();
                DesignObjectCollection designObjectCollection = (DesignObjectCollection)this.selectedSubView.getChild(i);
                for (Object e : designObjectCollection.getElementsList()) {
                    ModelIdObjectSelection modelIdObjectSelection3;
                    ContainerObject containerObject;
                    if (string.equals(Messages.getString("DDLSelectionDB2.Tables"))) {
                        containerObject = (Table)((DesignObjectPlaceHolder)e).getDesignObject();
                        modelIdObjectSelection3 = new ModelIdObjectSelection(containerObject);
                        this.addTableDetails((Table)containerObject, modelIdObjectSelection3);
                        modelIdObjectSelection.addChild(modelIdObjectSelection3);
                        this.getTableList().add(modelIdObjectSelection3);
                    }
                    if (!string.equals(Messages.getString("DDLSelectionDB2.Views"))) continue;
                    containerObject = (TableView)((DesignObjectPlaceHolder)e).getDesignObject();
                    modelIdObjectSelection3 = new ModelIdObjectSelection(containerObject);
                    modelIdObjectSelection2.addChild(modelIdObjectSelection3);
                    this.getViewList().add(modelIdObjectSelection3);
                }
            }
            this.addChild(modelIdObjectSelection);
            this.addChild(modelIdObjectSelection2);
        }
    }

    private void addTableDetails(Table table, ModelIdObjectSelection modelIdObjectSelection) {
        ModelIdObjectSelection modelIdObjectSelection2;
        Object object;
        Object object2;
        Object object3;
        if (table.getIndexes().size() > 0) {
            object3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Indexes"));
            ((ModelIdObjectSelection)object3).setElementDescriptor(IndexSet.class);
            object2 = table.getIndexes().iterator();
            while (object2.hasNext()) {
                ContainerObjectPlaceHolder containerObjectPlaceHolder = (ContainerObjectPlaceHolder)object2.next();
                object = (Index)containerObjectPlaceHolder.getDesignObject();
                modelIdObjectSelection2 = new ModelIdObjectSelection((ModelIDObject)object);
                ((ModelIdObjectSelection)object3).addChild(modelIdObjectSelection2);
                this.getIndexList().add(modelIdObjectSelection2);
            }
            modelIdObjectSelection.addChild((ModelIdObjectSelection)object3);
        }
        if (((FKIndexAssociation[])(object3 = table.getFKAssociations())).length > 0) {
            object2 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.ForeignKeys"));
            ((ModelIdObjectSelection)object2).setElementDescriptor(FKIndexAssociationSet.class);
            for (int i = 0; i < ((Object)object3).length; ++i) {
                object = object3[i];
                modelIdObjectSelection2 = new ModelIdObjectSelection((ModelIDObject)object);
                ((ModelIdObjectSelection)object2).addChild(modelIdObjectSelection2);
                this.getFkList().add(modelIdObjectSelection2);
            }
            modelIdObjectSelection.addChild((ModelIdObjectSelection)object2);
        }
    }

    private void addTableProxyDetails(TableProxyDB2 tableProxyDB2, ModelIdObjectSelection modelIdObjectSelection) {
        Object object;
        IndexProxy indexProxy;
        Object object2;
        Object object3;
        Table table = (Table)tableProxyDB2.getObject();
        if (tableProxyDB2.getIntIndexes().size() > 0) {
            object3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.IntegrityIndexes"));
            ((ModelIdObjectSelection)object3).setElementDescriptor(IndexSet.class);
            object2 = tableProxyDB2.getIntIndexes().iterator();
            while (object2.hasNext()) {
                indexProxy = (IndexProxy)object2.next();
                object = new ModelIdObjectSelection(indexProxy);
                ((ModelIdObjectSelection)object3).addChild((ModelIdObjectSelection)object);
                this.getConstraintList().add(object);
            }
            modelIdObjectSelection.addChild((ModelIdObjectSelection)object3);
        }
        if (tableProxyDB2.getIndexes().size() > 0) {
            object3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Indexes"));
            ((ModelIdObjectSelection)object3).setElementDescriptor(IndexSet.class);
            object2 = tableProxyDB2.getIndexes().iterator();
            while (object2.hasNext()) {
                indexProxy = (IndexProxy)object2.next();
                object = new ModelIdObjectSelection(indexProxy);
                ((ModelIdObjectSelection)object3).addChild((ModelIdObjectSelection)object);
                this.getIndexList().add(object);
            }
            modelIdObjectSelection.addChild((ModelIdObjectSelection)object3);
        }
        if (table != null && !(this.stordes instanceof StorageDesignDB2v80)) {
            object3 = table.getFKAssociations();
            if (((FKIndexAssociation[])object3).length > 0) {
                object2 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.ForeignKeys"));
                ((ModelIdObjectSelection)object2).setElementDescriptor(FKIndexAssociationSet.class);
                for (int i = 0; i < ((Object)object3).length; ++i) {
                    object = object3[i];
                    ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection((ModelIDObject)object);
                    ((ModelIdObjectSelection)object2).addChild(modelIdObjectSelection2);
                    this.getFkList().add(modelIdObjectSelection2);
                }
                modelIdObjectSelection.addChild((ModelIdObjectSelection)object2);
            }
        } else if (((TableProxyDB2v80)tableProxyDB2).getFkeys().size() > 0) {
            object3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.ForeignKeys"));
            ((ModelIdObjectSelection)object3).setElementDescriptor(FKIndexAssociationSet.class);
            object2 = ((TableProxyDB2v80)tableProxyDB2).getFkeys().iterator();
            while (object2.hasNext()) {
                indexProxy = (IndexProxy)object2.next();
                object = new ModelIdObjectSelection(indexProxy);
                ((ModelIdObjectSelection)object3).addChild((ModelIdObjectSelection)object);
                this.getFkList().add(object);
            }
            modelIdObjectSelection.addChild((ModelIdObjectSelection)object3);
        }
        if (tableProxyDB2.getSynonyms().size() > 0) {
            object3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Synonyms"));
            ((ModelIdObjectSelection)object3).setElementDescriptor(SynonymSetDB2.class);
            object2 = tableProxyDB2.getSynonyms().iterator();
            while (object2.hasNext()) {
                SynonymDB2 synonymDB2 = (SynonymDB2)object2.next();
                object = new ModelIdObjectSelection(synonymDB2);
                ((ModelIdObjectSelection)object3).addChild((ModelIdObjectSelection)object);
            }
            modelIdObjectSelection.addChild((ModelIdObjectSelection)object3);
        }
        if (tableProxyDB2.getTriggers().size() > 0) {
            object3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Triggers"));
            ((ModelIdObjectSelection)object3).setElementDescriptor(TriggerSetDB2.class);
            object2 = tableProxyDB2.getTriggers().iterator();
            while (object2.hasNext()) {
                Trigger trigger = (Trigger)object2.next();
                object = new ModelIdObjectSelection(trigger);
                ((ModelIdObjectSelection)object3).addChild((ModelIdObjectSelection)object);
            }
            modelIdObjectSelection.addChild((ModelIdObjectSelection)object3);
        }
    }

    private void addDistinctTypes() {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.DistinctTypes"));
        modelIdObjectSelection.setElementDescriptor(DistinctTypeDB2.class);
        Iterator iterator = ((AbstractStorageDesignDB2)this.stordes).getDistinctTypeSet().iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                DistinctTypeDB2 distinctTypeDB2 = (DistinctTypeDB2)iterator.next();
                ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(distinctTypeDB2);
                modelIdObjectSelection.addChild(modelIdObjectSelection2);
            }
            this.addChild(modelIdObjectSelection);
        }
    }

    private void addStorageGroups() {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.StorageGroups"));
        modelIdObjectSelection.setElementDescriptor(StorageGroupDB2.class);
        Iterator iterator = ((AbstractStorageDesignDB2)this.stordes).getStorageGroupSet().iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                StorageGroupDB2 storageGroupDB2 = (StorageGroupDB2)iterator.next();
                ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(storageGroupDB2);
                modelIdObjectSelection.addChild(modelIdObjectSelection2);
            }
            this.addChild(modelIdObjectSelection);
        }
    }

    private void addSchemaDependent() {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.SchemaDependent"));
        modelIdObjectSelection.setElementDescriptor(SchemaObjectSet.class);
        Iterator iterator = this.getSchemasWithObjects().iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                Owner owner = (Owner)iterator.next();
                this.addObjectsForSchema(owner, modelIdObjectSelection);
            }
            this.addChild(modelIdObjectSelection);
        }
        this.addObjectsWithoutSchema(modelIdObjectSelection);
    }

    private void addObjectsForSchema(Owner owner, ModelIdObjectSelection modelIdObjectSelection) {
        ModelIdObjectSelection modelIdObjectSelection2;
        ModelIdObjectSelection modelIdObjectSelection3;
        ModelIdObjectSelection modelIdObjectSelection4 = new ModelIdObjectSelection(owner);
        List list = this.getAliasesFor(owner);
        if (list.size() > 0) {
            modelIdObjectSelection3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Aliases"));
            modelIdObjectSelection3.setElementDescriptor(AliasDB2.class);
            for (StorageObject storageObject : list) {
                modelIdObjectSelection2 = new ModelIdObjectSelection(storageObject);
                modelIdObjectSelection3.addChild(modelIdObjectSelection2);
                this.getAliasList().add(modelIdObjectSelection2);
            }
            modelIdObjectSelection4.addChild(modelIdObjectSelection3);
        }
        if ((list = this.getViewsFor(owner)).size() > 0) {
            modelIdObjectSelection3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Views"));
            modelIdObjectSelection3.setElementDescriptor(TableViewSet.class);
            for (StorageObject storageObject : list) {
                modelIdObjectSelection2 = new ModelIdObjectSelection(storageObject);
                modelIdObjectSelection3.addChild(modelIdObjectSelection2);
                this.getViewList().add(modelIdObjectSelection2);
            }
            modelIdObjectSelection4.addChild(modelIdObjectSelection3);
        }
        if ((list = this.getStoredProceduresFor(owner)).size() > 0) {
            modelIdObjectSelection3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.StoredProcedures"));
            modelIdObjectSelection3.setElementDescriptor(StoredProcedureSetDB2.class);
            for (StorageObject storageObject : list) {
                modelIdObjectSelection2 = new ModelIdObjectSelection(storageObject);
                this.getStoredProcedureList().add(modelIdObjectSelection2);
                modelIdObjectSelection3.addChild(modelIdObjectSelection2);
            }
            modelIdObjectSelection4.addChild(modelIdObjectSelection3);
        }
        if (this.stordes instanceof StorageDesignDB2v80 && (list = this.getSequencesFor(owner)).size() > 0) {
            modelIdObjectSelection3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Sequences"));
            modelIdObjectSelection3.setElementDescriptor(SequenceDB2.class);
            for (StorageObject storageObject : list) {
                modelIdObjectSelection2 = new ModelIdObjectSelection(storageObject);
                modelIdObjectSelection3.addChild(modelIdObjectSelection2);
            }
            modelIdObjectSelection4.addChild(modelIdObjectSelection3);
        }
        if (modelIdObjectSelection4.getChilds().size() > 0) {
            modelIdObjectSelection.addChild(modelIdObjectSelection4);
        }
    }

    private void addObjectsWithoutSchema(ModelIdObjectSelection modelIdObjectSelection) {
        ModelIdObjectSelection modelIdObjectSelection2;
        ModelIdObjectSelection modelIdObjectSelection3;
        ModelIdObjectSelection modelIdObjectSelection4 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.NotAssignedToSchema"));
        modelIdObjectSelection4.setElementDescriptor(SchemaSetUDB.class);
        List list = this.getAliasesWithoutOwner();
        if (list.size() > 0) {
            modelIdObjectSelection3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Aliases"));
            modelIdObjectSelection3.setElementDescriptor(AliasDB2.class);
            for (StorageObject storageObject : list) {
                modelIdObjectSelection2 = new ModelIdObjectSelection(storageObject);
                modelIdObjectSelection3.addChild(modelIdObjectSelection2);
                this.getAliasList().add(modelIdObjectSelection2);
            }
            modelIdObjectSelection4.addChild(modelIdObjectSelection3);
        }
        if ((list = this.getViewsWithoutOwner()).size() > 0) {
            modelIdObjectSelection3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Views"));
            modelIdObjectSelection3.setElementDescriptor(TableViewSet.class);
            for (StorageObject storageObject : list) {
                modelIdObjectSelection2 = new ModelIdObjectSelection(storageObject);
                modelIdObjectSelection3.addChild(modelIdObjectSelection2);
                this.getViewList().add(modelIdObjectSelection2);
            }
            modelIdObjectSelection4.addChild(modelIdObjectSelection3);
        }
        if ((list = this.getStoredProceduresWithoutOwner()).size() > 0) {
            modelIdObjectSelection3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.StoredProcedures"));
            modelIdObjectSelection3.setElementDescriptor(StoredProcedureSetDB2.class);
            for (StorageObject storageObject : list) {
                modelIdObjectSelection2 = new ModelIdObjectSelection(storageObject);
                this.getStoredProcedureList().add(modelIdObjectSelection2);
                modelIdObjectSelection3.addChild(modelIdObjectSelection2);
            }
            modelIdObjectSelection4.addChild(modelIdObjectSelection3);
        }
        if (this.stordes instanceof StorageDesignDB2v80 && (list = this.getSequencesWithoutOwner()).size() > 0) {
            modelIdObjectSelection3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Sequences"));
            modelIdObjectSelection3.setElementDescriptor(SequenceDB2.class);
            for (StorageObject storageObject : list) {
                modelIdObjectSelection2 = new ModelIdObjectSelection(storageObject);
                modelIdObjectSelection3.addChild(modelIdObjectSelection2);
            }
            modelIdObjectSelection4.addChild(modelIdObjectSelection3);
        }
        if (modelIdObjectSelection4.getChilds().size() > 0) {
            modelIdObjectSelection.addChild(modelIdObjectSelection4);
        }
    }

    private void addDatabases() {
        Object object;
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.DatabaseDependent"));
        modelIdObjectSelection.setElementDescriptor(DataBaseDB2.class);
        Iterator iterator = this.getDatabaseSet().iterator();
        while (iterator.hasNext()) {
            object = (DataBaseDB2)iterator.next();
            this.addDatabase(modelIdObjectSelection, (DataBaseDB2)object);
        }
        object = this.getTablesWithoutDB();
        List list = this.getAuxTablesWithoutDB();
        List list2 = this.getTablespacesWithoutDB();
        if (object.size() > 0 || list.size() > 0 || list2.size() > 0) {
            ModelObject modelObject;
            Object object22;
            Object object3;
            ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.NotAssignedToDatabase"));
            modelIdObjectSelection2.setElementDescriptor(TableSpaceSetUDB.WithoutDatabase.class);
            if (object.size() > 0) {
                object3 = this.getOwners((List)object);
                object22 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Tables"));
                ((ModelIdObjectSelection)object22).setElementDescriptor(TableSet.class);
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    modelObject = (Owner)iterator.next();
                    this.addTables((Owner)modelObject, (ModelIdObjectSelection)object22, (List)object);
                }
                this.addTablesWithoutOwner((ModelIdObjectSelection)object22, (List)object);
                modelIdObjectSelection2.addChild((ModelIdObjectSelection)object22);
            }
            if (list.size() > 0) {
                object3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.AUXTables"));
                ((ModelIdObjectSelection)object3).setElementDescriptor(TableSet.class);
                object22 = this.getOwnersForAuxTables(list);
                iterator = object22.iterator();
                while (iterator.hasNext()) {
                    modelObject = (Owner)iterator.next();
                    this.addAUXTables((Owner)modelObject, (ModelIdObjectSelection)object3, list);
                }
                this.addAUXTablesWithoutOwner((ModelIdObjectSelection)object3, list);
                modelIdObjectSelection2.addChild((ModelIdObjectSelection)object3);
            }
            if (list2.size() > 0) {
                object3 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Tablespaces"));
                ((ModelIdObjectSelection)object3).setElementDescriptor(TableSpaceDB2.class);
                for (Object object22 : list2) {
                    modelObject = new ModelIdObjectSelection((ModelIDObject)object22);
                    ((ModelIdObjectSelection)object3).addChild((ModelIdObjectSelection)modelObject);
                }
                modelIdObjectSelection2.addChild((ModelIdObjectSelection)object3);
            }
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
        if (modelIdObjectSelection.getChilds().size() > 0) {
            this.addChild(modelIdObjectSelection);
        }
    }

    private void addDatabase(ModelIdObjectSelection modelIdObjectSelection, DataBaseDB2 dataBaseDB2) {
        StorageObject storageObject;
        Iterator iterator;
        Object object;
        Object object2;
        List list = this.getTablesFor(dataBaseDB2);
        List list2 = this.getAuxTablesFor(dataBaseDB2);
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(dataBaseDB2);
        if (list.size() > 0) {
            object2 = this.getOwners(list);
            object = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Tables"));
            ((ModelIdObjectSelection)object).setElementDescriptor(TableSet.class);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                storageObject = (Owner)iterator.next();
                this.addTables((Owner)storageObject, (ModelIdObjectSelection)object, list);
            }
            this.addTablesWithoutOwner((ModelIdObjectSelection)object, list);
            modelIdObjectSelection2.addChild((ModelIdObjectSelection)object);
        }
        if (list2.size() > 0) {
            object2 = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.AUXTables"));
            ((ModelIdObjectSelection)object2).setElementDescriptor(TableSet.class);
            object = this.getOwnersForAuxTables(list2);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                storageObject = (Owner)iterator.next();
                this.addAUXTables((Owner)storageObject, (ModelIdObjectSelection)object2, list2);
            }
            this.addAUXTablesWithoutOwner((ModelIdObjectSelection)object2, list2);
            modelIdObjectSelection2.addChild((ModelIdObjectSelection)object2);
        }
        if ((object2 = this.getTablespacesFor(dataBaseDB2)).size() > 0) {
            object = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.Tablespaces"));
            ((ModelIdObjectSelection)object).setElementDescriptor(TableSpaceDB2.class);
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                storageObject = (TableSpaceDB2)iterator.next();
                ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(storageObject);
                ((ModelIdObjectSelection)object).addChild(modelIdObjectSelection3);
            }
            modelIdObjectSelection2.addChild((ModelIdObjectSelection)object);
        }
        if (modelIdObjectSelection2.getChilds().size() > 0) {
            modelIdObjectSelection.addChild(modelIdObjectSelection2);
        }
    }

    private void addTables(Owner owner, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        for (ModelObject modelObject : list) {
            if (((TableProxyDB2)modelObject).getOwner() != owner) continue;
            arrayList.add(modelObject);
        }
        if (arrayList.size() > 0) {
            ModelObject modelObject;
            modelObject = new ModelIdObjectSelection(owner);
            ((ModelIdObjectSelection)modelObject).setElementDescriptor(Owner.class);
            this.addTables((ModelIdObjectSelection)modelObject, arrayList);
            modelIdObjectSelection.addChild((ModelIdObjectSelection)modelObject);
        }
    }

    private void addAUXTables(Owner owner, ModelIdObjectSelection modelIdObjectSelection, List list) {
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        for (ModelObject modelObject : list) {
            if (((AUXTableDB2)modelObject).getOwner() != owner) continue;
            arrayList.add(modelObject);
        }
        if (arrayList.size() > 0) {
            ModelObject modelObject;
            modelObject = new ModelIdObjectSelection(owner);
            ((ModelIdObjectSelection)modelObject).setElementDescriptor(Owner.class);
            this.addAUXTables((ModelIdObjectSelection)modelObject, arrayList);
            modelIdObjectSelection.addChild((ModelIdObjectSelection)modelObject);
        }
    }

    private void addTables(ModelIdObjectSelection modelIdObjectSelection, List list) {
        for (TableProxyDB2 tableProxyDB2 : list) {
            this.addTable(modelIdObjectSelection, tableProxyDB2);
        }
    }

    private void addAUXTables(ModelIdObjectSelection modelIdObjectSelection, List list) {
        for (AUXTableDB2 aUXTableDB2 : list) {
            this.addAUXTable(modelIdObjectSelection, aUXTableDB2);
        }
    }

    private void addTable(ModelIdObjectSelection modelIdObjectSelection, TableProxyDB2 tableProxyDB2) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(tableProxyDB2);
        this.addTableProxyDetails(tableProxyDB2, modelIdObjectSelection2);
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
        this.getTableList().add(modelIdObjectSelection2);
    }

    private void addAUXTable(ModelIdObjectSelection modelIdObjectSelection, AUXTableDB2 aUXTableDB2) {
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(aUXTableDB2);
        this.getAuxTableList().add(modelIdObjectSelection2);
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
    }

    private void addTablesWithoutOwner(ModelIdObjectSelection modelIdObjectSelection, List list) {
        ArrayList<TableProxyDB2> arrayList = new ArrayList<TableProxyDB2>();
        for (ModelObject modelObject : list) {
            if (((TableProxyDB2)modelObject).getOwner() != null) continue;
            arrayList.add((TableProxyDB2)modelObject);
        }
        if (arrayList.size() > 0) {
            ModelObject modelObject;
            modelObject = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.NotAssignedToSchema"));
            ((ModelIdObjectSelection)modelObject).setElementDescriptor(SchemaSetUDB.class);
            this.addTables((ModelIdObjectSelection)modelObject, arrayList);
            if (((ModelIdObjectSelection)modelObject).getChilds().size() > 0) {
                modelIdObjectSelection.addChild((ModelIdObjectSelection)modelObject);
            }
        }
    }

    private void addAUXTablesWithoutOwner(ModelIdObjectSelection modelIdObjectSelection, List list) {
        ArrayList<AUXTableDB2> arrayList = new ArrayList<AUXTableDB2>();
        for (ModelObject modelObject : list) {
            if (modelObject.getOwner() != null) continue;
            arrayList.add((AUXTableDB2)modelObject);
        }
        if (arrayList.size() > 0) {
            ModelObject modelObject;
            modelObject = new ModelIdObjectSelection(Messages.getString("DDLSelectionDB2.NotAssignedToSchema"));
            this.addAUXTables((ModelIdObjectSelection)modelObject, arrayList);
            modelIdObjectSelection.addChild((ModelIdObjectSelection)modelObject);
        }
    }

    private List getOwners(List list) {
        ArrayList<Owner> arrayList = new ArrayList<Owner>();
        for (TableProxyDB2 tableProxyDB2 : list) {
            if (tableProxyDB2.getOwner() == null || arrayList.contains(tableProxyDB2.getOwner())) continue;
            arrayList.add(tableProxyDB2.getOwner());
        }
        return arrayList;
    }

    private List getOwnersForAuxTables(List list) {
        ArrayList<Owner> arrayList = new ArrayList<Owner>();
        for (AUXTableDB2 aUXTableDB2 : list) {
            if (aUXTableDB2.getOwner() == null || arrayList.contains(aUXTableDB2.getOwner())) continue;
            arrayList.add(aUXTableDB2.getOwner());
        }
        return arrayList;
    }

    private List getTablesWithoutDB() {
        ArrayList<TableProxyDB2> arrayList = new ArrayList<TableProxyDB2>();
        Iterator iterator = this.selectedSubView != null ? this.stordes.getSubViewTableProxySet().iterator() : this.stordes.getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxyDB2 tableProxyDB2 = (TableProxyDB2)iterator.next();
            if (tableProxyDB2.getTableSpace() == null) {
                arrayList.add(tableProxyDB2);
                continue;
            }
            if (tableProxyDB2.getTableSpace() == null || tableProxyDB2.getTableSpace().getDataBase() != null) continue;
            arrayList.add(tableProxyDB2);
        }
        return arrayList;
    }

    private List getTablesFor(DataBaseDB2 dataBaseDB2) {
        ArrayList<TableProxyDB2> arrayList = new ArrayList<TableProxyDB2>();
        Iterator iterator = this.selectedSubView != null ? this.stordes.getSubViewTableProxySet().iterator() : this.stordes.getTableProxySet().iterator();
        while (iterator.hasNext()) {
            TableProxyDB2 tableProxyDB2 = (TableProxyDB2)iterator.next();
            if (tableProxyDB2.getTableSpace() == null || tableProxyDB2.getTableSpace().getDataBase() != dataBaseDB2) continue;
            arrayList.add(tableProxyDB2);
        }
        return arrayList;
    }

    private List getTablespacesFor(DataBaseDB2 dataBaseDB2) {
        ArrayList<TableSpaceDB2> arrayList = new ArrayList<TableSpaceDB2>();
        Iterator iterator = ((AbstractStorageDesignDB2)this.stordes).getTableSpaceSet().iterator();
        while (iterator.hasNext()) {
            TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)iterator.next();
            if (tableSpaceDB2.getDataBase() != dataBaseDB2) continue;
            arrayList.add(tableSpaceDB2);
        }
        return arrayList;
    }

    private List getTablespacesWithoutDB() {
        ArrayList<TableSpaceDB2> arrayList = new ArrayList<TableSpaceDB2>();
        Iterator iterator = ((AbstractStorageDesignDB2)this.stordes).getTableSpaceSet().iterator();
        while (iterator.hasNext()) {
            TableSpaceDB2 tableSpaceDB2 = (TableSpaceDB2)iterator.next();
            if (tableSpaceDB2.getDataBase() != null) continue;
            arrayList.add(tableSpaceDB2);
        }
        return arrayList;
    }

    private List getAuxTablesFor(DataBaseDB2 dataBaseDB2) {
        ArrayList<AUXTableDB2> arrayList = new ArrayList<AUXTableDB2>();
        Iterator iterator = ((AbstractStorageDesignDB2)this.stordes).getAUXTableSet().iterator();
        while (iterator.hasNext()) {
            AUXTableDB2 aUXTableDB2 = (AUXTableDB2)iterator.next();
            if (aUXTableDB2.getTableSpace() == null || aUXTableDB2.getTableSpace().getDataBase() != dataBaseDB2) continue;
            arrayList.add(aUXTableDB2);
        }
        return arrayList;
    }

    private List getAuxTablesWithoutDB() {
        ArrayList<AUXTableDB2> arrayList = new ArrayList<AUXTableDB2>();
        Iterator iterator = ((AbstractStorageDesignDB2)this.stordes).getAUXTableSet().iterator();
        while (iterator.hasNext()) {
            AUXTableDB2 aUXTableDB2 = (AUXTableDB2)iterator.next();
            if (aUXTableDB2.getTableSpace() == null) {
                arrayList.add(aUXTableDB2);
                continue;
            }
            if (aUXTableDB2.getTableSpace() == null || aUXTableDB2.getTableSpace().getDataBase() != null) continue;
            arrayList.add(aUXTableDB2);
        }
        return arrayList;
    }

    private DataBaseSetDB2 getDatabaseSet() {
        return ((AbstractStorageDesignDB2)this.stordes).getDataBaseSet();
    }

    private List getSchemasWithObjects() {
        Owner owner;
        StorageObject storageObject;
        ArrayList<Owner> arrayList = new ArrayList<Owner>();
        Iterator iterator = ((AbstractStorageDesignDB2)this.stordes).getAliasSet().iterator();
        while (iterator.hasNext()) {
            storageObject = (AliasDB2)iterator.next();
            owner = ((AliasDB2)storageObject).getOwner();
            if (owner == null || arrayList.contains(owner)) continue;
            arrayList.add(owner);
        }
        iterator = ((AbstractStorageDesignDB2)this.stordes).getTableViewProxySet().iterator();
        while (iterator.hasNext()) {
            storageObject = (TableViewProxyDB2)iterator.next();
            owner = ((TableViewProxyDB2)storageObject).getOwner();
            if (owner == null || arrayList.contains(owner)) continue;
            arrayList.add(owner);
        }
        iterator = ((AbstractStorageDesignDB2)this.stordes).getStoredProcedureSet().iterator();
        while (iterator.hasNext()) {
            storageObject = (StoredProcedureDB2)iterator.next();
            owner = ((StoredProcedureDB2)storageObject).getOwner();
            if (owner == null || arrayList.contains(owner)) continue;
            arrayList.add(owner);
        }
        if (this.stordes instanceof StorageDesignDB2v80) {
            iterator = ((StorageDesignDB2v80)this.stordes).getSequenceSet().iterator();
            while (iterator.hasNext()) {
                storageObject = (SequenceDB2)iterator.next();
                owner = ((SequenceDB2)storageObject).getOwner();
                if (owner == null || arrayList.contains(owner)) continue;
                arrayList.add(owner);
            }
        }
        return arrayList;
    }

    private List getAliasesFor(Owner owner) {
        ArrayList<AliasDB2> arrayList = new ArrayList<AliasDB2>();
        Iterator iterator = ((AbstractStorageDesignDB2)this.stordes).getAliasSet().iterator();
        while (iterator.hasNext()) {
            AliasDB2 aliasDB2 = (AliasDB2)iterator.next();
            if (aliasDB2.getOwner() != owner) continue;
            arrayList.add(aliasDB2);
        }
        return arrayList;
    }

    private List getAliasesWithoutOwner() {
        ArrayList<AliasDB2> arrayList = new ArrayList<AliasDB2>();
        Iterator iterator = ((AbstractStorageDesignDB2)this.stordes).getAliasSet().iterator();
        while (iterator.hasNext()) {
            AliasDB2 aliasDB2 = (AliasDB2)iterator.next();
            if (aliasDB2.getOwner() != null) continue;
            arrayList.add(aliasDB2);
        }
        return arrayList;
    }

    private List getViewsFor(Owner owner) {
        ArrayList<TableViewProxyDB2> arrayList = new ArrayList<TableViewProxyDB2>();
        Iterator iterator = this.selectedSubView != null ? ((AbstractStorageDesignDB2)this.stordes).getSubViewTableViewProxySet().iterator() : ((AbstractStorageDesignDB2)this.stordes).getTableViewProxySet().iterator();
        while (iterator.hasNext()) {
            TableViewProxyDB2 tableViewProxyDB2 = (TableViewProxyDB2)iterator.next();
            if (tableViewProxyDB2.getOwner() != owner) continue;
            arrayList.add(tableViewProxyDB2);
        }
        return arrayList;
    }

    private List getViewsWithoutOwner() {
        ArrayList<TableViewProxyDB2> arrayList = new ArrayList<TableViewProxyDB2>();
        Iterator iterator = this.selectedSubView != null ? ((AbstractStorageDesignDB2)this.stordes).getSubViewTableViewProxySet().iterator() : ((AbstractStorageDesignDB2)this.stordes).getTableViewProxySet().iterator();
        while (iterator.hasNext()) {
            TableViewProxyDB2 tableViewProxyDB2 = (TableViewProxyDB2)iterator.next();
            if (tableViewProxyDB2.getOwner() != null) continue;
            arrayList.add(tableViewProxyDB2);
        }
        return arrayList;
    }

    private List getStoredProceduresFor(Owner owner) {
        ArrayList<StoredProcedureDB2> arrayList = new ArrayList<StoredProcedureDB2>();
        Iterator iterator = ((AbstractStorageDesignDB2)this.stordes).getStoredProcedureSet().iterator();
        while (iterator.hasNext()) {
            StoredProcedureDB2 storedProcedureDB2 = (StoredProcedureDB2)iterator.next();
            if (storedProcedureDB2.getOwner() != owner) continue;
            arrayList.add(storedProcedureDB2);
        }
        return arrayList;
    }

    private List getStoredProceduresWithoutOwner() {
        ArrayList<StoredProcedureDB2> arrayList = new ArrayList<StoredProcedureDB2>();
        Iterator iterator = ((AbstractStorageDesignDB2)this.stordes).getStoredProcedureSet().iterator();
        while (iterator.hasNext()) {
            StoredProcedureDB2 storedProcedureDB2 = (StoredProcedureDB2)iterator.next();
            if (storedProcedureDB2.getOwner() != null) continue;
            arrayList.add(storedProcedureDB2);
        }
        return arrayList;
    }

    private List getSequencesFor(Owner owner) {
        ArrayList<SequenceDB2> arrayList = new ArrayList<SequenceDB2>();
        if (this.stordes instanceof StorageDesignDB2v80) {
            Iterator iterator = ((StorageDesignDB2v80)this.stordes).getSequenceSet().iterator();
            while (iterator.hasNext()) {
                SequenceDB2 sequenceDB2 = (SequenceDB2)iterator.next();
                if (sequenceDB2.getOwner() != owner) continue;
                arrayList.add(sequenceDB2);
            }
        }
        return arrayList;
    }

    private List getSequencesWithoutOwner() {
        ArrayList<SequenceDB2> arrayList = new ArrayList<SequenceDB2>();
        if (this.stordes instanceof StorageDesignDB2v80) {
            Iterator iterator = ((StorageDesignDB2v80)this.stordes).getSequenceSet().iterator();
            while (iterator.hasNext()) {
                SequenceDB2 sequenceDB2 = (SequenceDB2)iterator.next();
                if (sequenceDB2.getOwner() != null) continue;
                arrayList.add(sequenceDB2);
            }
        }
        return arrayList;
    }

    @Override
    public List getTableList() {
        if (this.tableList == null) {
            this.tableList = new ArrayList();
        }
        return this.tableList;
    }

    @Override
    public List getConstraintList() {
        if (this.constraintList == null) {
            this.constraintList = new ArrayList();
        }
        return this.constraintList;
    }

    @Override
    public List getIndexList() {
        if (this.indexList == null) {
            this.indexList = new ArrayList();
        }
        return this.indexList;
    }

    @Override
    public List getFkList() {
        if (this.fkList == null) {
            this.fkList = new ArrayList();
        }
        return this.fkList;
    }

    @Override
    public List getViewList() {
        if (this.viewList == null) {
            this.viewList = new ArrayList();
        }
        return this.viewList;
    }

    public List getAliasList() {
        if (this.aliasList == null) {
            this.aliasList = new ArrayList();
        }
        return this.aliasList;
    }

    public List getAuxTableList() {
        if (this.auxTableList == null) {
            this.auxTableList = new ArrayList();
        }
        return this.auxTableList;
    }

    public List getStoredProcedureList() {
        if (this.storedProcedureList == null) {
            this.storedProcedureList = new ArrayList();
        }
        return this.storedProcedureList;
    }
}

