/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl;

import java.awt.Color;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.swingui.ddl.SyntaxConstants;

public class SyntaxDocument
extends DefaultStyledDocument
implements SyntaxConstants {
    private DefaultStyledDocument doc = this;
    private Element rootElement = this.doc.getDefaultRootElement();
    private boolean multiLineComment;
    private MutableAttributeSet normal;
    private MutableAttributeSet keyword;
    private MutableAttributeSet comment;
    private MutableAttributeSet quote;
    private MutableAttributeSet number;
    private Hashtable keywords;
    private static final Pattern NUM_PATTERN = Pattern.compile("[+-]?\\d+(?:\\.\\d+)? *(?:e[+-]?\\d+)?");

    public SyntaxDocument() {
        this.putProperty("__EndOfLine__", "\n");
        this.normal = new SimpleAttributeSet();
        StyleConstants.setForeground(this.normal, Color.black);
        this.comment = new SimpleAttributeSet();
        StyleConstants.setForeground(this.comment, Color.gray);
        StyleConstants.setItalic(this.comment, true);
        this.keyword = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyword, Color.blue);
        StyleConstants.setBold(this.keyword, true);
        this.quote = new SimpleAttributeSet();
        StyleConstants.setForeground(this.quote, new Color(128, 0, 0));
        this.number = new SimpleAttributeSet();
        StyleConstants.setForeground(this.number, new Color(0, 128, 0));
        Object object = new Object();
        int n = (int)((double)KEYWORDS.length / 0.75) + 1;
        this.keywords = new Hashtable(n);
        for (int i = 0; i < KEYWORDS.length; ++i) {
            this.keywords.put(KEYWORDS[i], object);
        }
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string.equals("{")) {
            string = this.addMatchingBrace(n);
        }
        super.insertString(n, string, attributeSet);
        this.processChangedLines(n, string.length());
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        super.remove(n, n2);
        this.processChangedLines(n, 0);
    }

    private void processChangedLines(int n, int n2) throws BadLocationException {
        String string = this.doc.getText(0, this.doc.getLength());
        int n3 = this.rootElement.getElementIndex(n);
        int n4 = this.rootElement.getElementIndex(n + n2);
        this.setMultiLineComment(this.commentLinesBefore(string, n3));
        for (int i = n3; i <= n4; ++i) {
            this.applyHighlighting(string, i);
        }
        if (this.isMultiLineComment()) {
            this.commentLinesAfter(string, n4);
        } else {
            this.highlightLinesAfter(string, n4);
        }
    }

    private boolean commentLinesBefore(String string, int n) {
        int n2 = this.rootElement.getElement(n).getStartOffset();
        int n3 = this.lastIndexOf(string, this.getStartDelimiter(), n2 - 2);
        if (n3 < 0) {
            return false;
        }
        int n4 = this.indexOf(string, this.getEndDelimiter(), n3);
        if (n4 < n2 & n4 != -1) {
            return false;
        }
        this.doc.setCharacterAttributes(n3, n2 - n3 + 1, this.comment, false);
        return true;
    }

    private void commentLinesAfter(String string, int n) {
        int n2 = this.rootElement.getElement(n).getEndOffset();
        int n3 = this.indexOf(string, this.getEndDelimiter(), n2);
        if (n3 < 0) {
            return;
        }
        int n4 = this.lastIndexOf(string, this.getStartDelimiter(), n3);
        if (n4 < 0 || n4 <= n2) {
            this.doc.setCharacterAttributes(n2, n3 - n2 + 1, this.comment, false);
        }
    }

    private void highlightLinesAfter(String string, int n) {
        int n2;
        int n3 = this.rootElement.getElement(n).getEndOffset();
        int n4 = this.indexOf(string, this.getStartDelimiter(), n3);
        int n5 = this.indexOf(string, this.getEndDelimiter(), n3);
        if (n4 < 0) {
            n4 = string.length();
        }
        if (n5 < 0) {
            n5 = string.length();
        }
        if ((n2 = Math.min(n4, n5)) < n3) {
            return;
        }
        int n6 = this.rootElement.getElementIndex(n2);
        for (int i = n + 1; i < n6; ++i) {
            Element element = this.rootElement.getElement(i);
            Element element2 = this.doc.getCharacterElement(element.getStartOffset());
            AttributeSet attributeSet = element2.getAttributes();
            if (!attributeSet.isEqual(this.comment)) continue;
            this.applyHighlighting(string, i);
        }
    }

    private void applyHighlighting(String string, int n) {
        int n2 = this.rootElement.getElement(n).getStartOffset();
        int n3 = this.rootElement.getElement(n).getEndOffset() - 1;
        int n4 = n3 - n2;
        int n5 = string.length();
        if (n3 >= n5) {
            n3 = n5 - 1;
        }
        if (this.endingMultiLineComment(string, n2, n3) || this.isMultiLineComment() || this.startingMultiLineComment(string, n2, n3)) {
            this.doc.setCharacterAttributes(n2, n3 - n2 + 1, this.comment, false);
            return;
        }
        this.doc.setCharacterAttributes(n2, n4, this.normal, true);
        int n6 = string.indexOf(this.getSingleLineDelimiter(), n2);
        if (n6 > -1 && n6 < n3) {
            this.doc.setCharacterAttributes(n6, n3 - n6 + 1, this.comment, false);
            n3 = n6 - 1;
        }
        this.checkForTokens(string, n2, n3);
    }

    private boolean startingMultiLineComment(String string, int n, int n2) {
        String string2;
        String string3;
        if (n2 >= n && ((string3 = string.substring(n, n2).trim()).startsWith(string2 = this.getStartDelimiter()) || string3.endsWith(string2))) {
            this.setMultiLineComment(true);
            return true;
        }
        return false;
    }

    private boolean endingMultiLineComment(String string, int n, int n2) {
        String string2;
        String string3;
        if (n2 >= n && ((string3 = string.substring(n, n2).trim()).startsWith(string2 = this.getEndDelimiter()) || string3.endsWith(string2))) {
            this.setMultiLineComment(false);
            return true;
        }
        return false;
    }

    private boolean isMultiLineComment() {
        return this.multiLineComment;
    }

    private void setMultiLineComment(boolean bl) {
        this.multiLineComment = bl;
    }

    private void checkForTokens(String string, int n, int n2) {
        while (n <= n2) {
            while (this.isDelimiter(string.substring(n, n + 1))) {
                if (n < n2) {
                    ++n;
                    continue;
                }
                return;
            }
            if (this.isQuoteDelimiter(string.substring(n, n + 1))) {
                n = this.getQuoteToken(string, n, n2);
                continue;
            }
            n = this.getOtherToken(string, n, n2);
        }
    }

    private int getQuoteToken(String string, int n, int n2) {
        String string2 = string.substring(n, n + 1);
        String string3 = this.getEscapeString(string2);
        int n3 = n;
        int n4 = string.indexOf(string3, n3 + 1);
        while (n4 > -1 && n4 < n2) {
            n3 = n4 + 1;
            n4 = string.indexOf(string3, n3);
        }
        n4 = string.indexOf(string2, n3 + 1);
        n3 = n4 < 0 || n4 > n2 ? n2 : n4;
        this.doc.setCharacterAttributes(n, n3 - n + 1, this.quote, false);
        return n3 + 1;
    }

    private int getOtherToken(String string, int n, int n2) {
        int n3;
        for (n3 = n + 1; n3 <= n2 && !this.isDelimiter(string.substring(n3, n3 + 1)); ++n3) {
        }
        String string2 = string.substring(n, n3);
        if (string2.endsWith(",")) {
            string2 = string2.substring(0, string2.length() - 1);
            --n3;
        }
        if (this.isKeyword(string2)) {
            this.doc.setCharacterAttributes(n, n3 - n, this.keyword, false);
        } else if (this.isNumber(string2)) {
            this.doc.setCharacterAttributes(n, n3 - n, this.number, false);
        }
        return n3 + 1;
    }

    private int indexOf(String string, String string2, int n) {
        String string3;
        int n2;
        while ((n2 = string.indexOf(string2, n)) != -1 && !(string3 = this.getLine(string, n2).trim()).startsWith(string2) && !string3.endsWith(string2)) {
            n = n2 + 1;
        }
        return n2;
    }

    private int lastIndexOf(String string, String string2, int n) {
        String string3;
        int n2;
        while ((n2 = string.lastIndexOf(string2, n)) != -1 && !(string3 = this.getLine(string, n2).trim()).startsWith(string2) && !string3.endsWith(string2)) {
            n = n2 - 1;
        }
        return n2;
    }

    private String getLine(String string, int n) {
        int n2 = this.rootElement.getElementIndex(n);
        Element element = this.rootElement.getElement(n2);
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset();
        return string.substring(n3, n4 - 1);
    }

    protected boolean isDelimiter(String string) {
        String string2 = ";:{}()[]+-/%<=>!&|^~*";
        return Character.isWhitespace(string.charAt(0)) || string2.indexOf(string) != -1;
    }

    protected boolean isQuoteDelimiter(String string) {
        String string2 = "\"'";
        return string2.indexOf(string) >= 0;
    }

    protected boolean isKeyword(String string) {
        Object v = this.keywords.get(String.valueOf(string).toUpperCase());
        return v != null;
    }

    protected boolean isNumber(String string) {
        Matcher matcher = NUM_PATTERN.matcher(string);
        return matcher.matches();
    }

    protected String getStartDelimiter() {
        return "/*";
    }

    protected String getEndDelimiter() {
        return "*/";
    }

    protected String getSingleLineDelimiter() {
        return "--";
    }

    protected String getEscapeString(String string) {
        return "\\" + string;
    }

    protected String addMatchingBrace(int n) throws BadLocationException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.rootElement.getElementIndex(n);
        int n3 = this.rootElement.getElement(n2).getStartOffset();
        while ((string = this.doc.getText(n3, 1)).equals(" ") || string.equals("\t")) {
            stringBuffer.append(string);
            ++n3;
        }
        return "{\n" + stringBuffer.toString() + "\t\n" + stringBuffer.toString() + "}";
    }
}

