/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class FindDialog
extends JDialog
implements ActionListener {
    private static final int TEXT_FIELD_SIZE = 20;
    private static final int COMPONENT_GAP = 10;
    private static final Border EMPTY_BORDER = new EmptyBorder(5, 5, 5, 5);
    private JLabel findLabel;
    private JTextField findData;
    private JCheckBox matchCase;
    private JCheckBox matchWord;
    private JRadioButton searchUp;
    private JRadioButton searchDown;
    private JButton findNextButton;
    private JButton closeButton;
    private JPanel findPanel;
    private JPanel optionPanel;
    private JPanel commandPanel;
    private JTextComponent textComponent;
    private Position searchStartPosition;
    private boolean searchWrap;

    public FindDialog(Frame frame) {
        super(frame);
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        this.findData = new JTextField(20);
        this.findData.setMaximumSize(this.findData.getPreferredSize());
        this.findLabel = new JLabel(Messages.getString("FindDialog.FindWhat"));
        this.findLabel.setDisplayedMnemonic('N');
        this.findLabel.setLabelFor(this.findData);
        this.findPanel = new JPanel();
        this.findPanel.setBorder(EMPTY_BORDER);
        this.findPanel.setLayout(new BoxLayout(this.findPanel, 0));
        this.findPanel.add(this.findLabel);
        this.findPanel.add(Box.createHorizontalGlue());
        this.findPanel.add(Box.createHorizontalStrut(10));
        this.findPanel.add(this.findData);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        this.matchCase = new JCheckBox(Messages.getString("FindDialog.MatchCase"));
        this.matchCase.setMnemonic('C');
        this.matchWord = new JCheckBox(Messages.getString("FindDialog.MatchWord"));
        this.matchWord.setMnemonic('W');
        jPanel.add(this.matchCase);
        jPanel.add(this.matchWord);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        this.searchDown = new JRadioButton(Messages.getString("FindDialog.SearchDown"));
        this.searchDown.setMnemonic('D');
        this.searchDown.setSelected(true);
        this.searchUp = new JRadioButton(Messages.getString("FindDialog.SearchUp"));
        this.searchUp.setMnemonic('U');
        jPanel2.add(this.searchDown);
        jPanel2.add(this.searchUp);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.searchDown);
        buttonGroup.add(this.searchUp);
        this.optionPanel = new JPanel();
        this.optionPanel.setLayout(new GridLayout(1, 2));
        this.optionPanel.setBorder(new TitledBorder(Messages.getString("FindDialog.Options")));
        this.optionPanel.add(jPanel);
        this.optionPanel.add(jPanel2);
        this.commandPanel = new JPanel();
        this.findNextButton = this.createButton(this.commandPanel, Messages.getString("FindDialog.Find"), 'F');
        this.closeButton = this.createButton(this.commandPanel, Messages.getString("FindDialog.Close"), 'C');
        this.closeButton.setEnabled(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(EMPTY_BORDER);
        jPanel3.add(this.findPanel);
        jPanel3.add(this.optionPanel);
        jPanel3.add(this.commandPanel);
        this.setContentPane(jPanel3);
        this.getRootPane().setDefaultButton(this.findNextButton);
        this.findData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 10) {
                    boolean bl = FindDialog.this.findData.getDocument().getLength() > 0;
                    FindDialog.this.findNextButton.setEnabled(bl);
                    FindDialog.this.resetSearchVariables();
                }
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindDialog.this.processClose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    public void showFind(JTextComponent jTextComponent) {
        this.setTitle(Messages.getString("FindDialog.Find"));
        this.setTextComponent(jTextComponent);
        this.pack();
        this.setVisible(true);
        CommonUtil.centerOnScreen(this);
        this.findData.requestFocus();
        this.resetSearchVariables();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.findNextButton) {
            this.processFindNext();
        }
        if (object == this.closeButton) {
            this.processClose();
        }
    }

    private JButton createButton(JPanel jPanel, String string, char c) {
        JButton jButton = new JButton(string);
        jButton.setMnemonic(c);
        jButton.setEnabled(false);
        jButton.addActionListener(this);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(jButton);
        return jButton;
    }

    private boolean processFindNext() {
        int n;
        this.textComponent.requestFocus();
        String string = this.findData.getText();
        String string2 = this.textComponent.getText();
        int n2 = this.textComponent.getSelectionStart();
        String string3 = this.textComponent.getSelectedText();
        this.textComponent.setSelectionEnd(n2);
        if (!this.matchCase.isSelected()) {
            string2 = string2.toLowerCase();
            string = string.toLowerCase();
        }
        if (string3 != null && string.equalsIgnoreCase(string3)) {
            n2 = this.searchDown() ? ++n2 : --n2;
        }
        if ((n = this.searchFor(string, string2, n2)) == -1) {
            JOptionPane.showMessageDialog(this, Messages.getString("FindDialog.FinishedSearching"), Messages.getString("FindDialog.Find"), 1);
            this.resetSearchVariables();
            this.findData.requestFocus();
            return false;
        }
        this.textComponent.setSelectionStart(n);
        this.textComponent.setSelectionEnd(n + string.length());
        this.findData.requestFocus();
        return true;
    }

    private boolean searchDown() {
        return this.searchDown.isSelected();
    }

    private int searchFor(String string, String string2, int n) {
        int n2;
        int n3;
        if (this.searchDown()) {
            n3 = 0;
            n2 = string2.indexOf(string, n);
        } else {
            n3 = string2.length();
            n2 = string2.lastIndexOf(string, n);
        }
        if (n2 == -1) {
            if (this.searchWrap) {
                return n2;
            }
            this.searchWrap = true;
            return this.searchFor(string, string2, n3);
        }
        int n4 = this.searchDown() ? n2 - this.searchStartPosition.getOffset() : this.searchStartPosition.getOffset() - n2 - 1;
        if (this.searchWrap && n4 >= 0) {
            return -1;
        }
        if (this.matchWord.isSelected() && !this.isWord(string2, n2, string.length())) {
            if (this.searchDown()) {
                return this.searchFor(string, string2, n2 + 1);
            }
            return this.searchFor(string, string2, n2 - 1);
        }
        return n2;
    }

    private boolean isWord(String string, int n, int n2) {
        int n3 = n - 1;
        int n4 = n + n2;
        return this.isDelimiter(string, n3) && this.isDelimiter(string, n4);
    }

    private boolean isDelimiter(String string, int n) {
        if (n < 0 || n > string.length()) {
            return true;
        }
        return !Character.isLetterOrDigit(string.charAt(n));
    }

    private void processClose() {
        this.setVisible(false);
    }

    private void setTextComponent(JTextComponent jTextComponent) {
        if (this.textComponent != jTextComponent) {
            this.textComponent = jTextComponent;
            this.resetSearchVariables();
        }
    }

    private void resetSearchVariables() {
        try {
            this.searchWrap = false;
            this.searchStartPosition = this.textComponent.getDocument().createPosition(this.textComponent.getSelectionStart());
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }
}

