/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.MessageDialogs;

public class DDLFileMaker
extends ModelObject {
    private StorageDesign storageDesign;
    private StringBuffer contentBuffer;
    private StatusBarOwner statusBarOwner = new StatusBarOwner.NullStatusBarOwner();
    private String content;
    private static int createDatabase = 0;
    private static int createTable = 0;
    private static int createIndex = 0;
    private static int createTablespace = 0;
    private static int createView = 0;
    private static int alterTable = 0;
    private static int createTrigger = 0;
    private static int alterTrigger = 0;
    private static int createPackage = 0;
    private static int createPackageBody = 0;
    private static int createProc = 0;
    private static int createFunction = 0;
    private static int createAlias = 0;
    private static int createAuxTable = 0;
    private static int createDistinctType = 0;
    private static int createStructuredType = 0;
    private static int createStoGroup = 0;
    private static int createSynomym = 0;
    private static int createCluster = 0;
    private static int createContext = 0;
    private static int createDimension = 0;
    private static int createDirectory = 0;
    private static int createRole = 0;
    private static int createRollbackSegment = 0;
    private static int createSequence = 0;
    private static int createSnapshot = 0;
    private static int createDiskgroup = 0;
    private static int createUser = 0;
    private static int createDefault = 0;
    private static int createRule = 0;
    private static int createIndexOnView = 0;
    private static int createInstance = 0;
    private static int createNodeGroup = 0;
    private static int createDbPartitionGroup = 0;
    private static int createBufferPool = 0;
    private static int createSchema = 0;
    private static int dropDatabase = 0;
    private static int dropTablespace = 0;
    private static int dropAlias = 0;
    private static int dropTriggers = 0;
    private static int dropProcedures = 0;
    private static int dropStogroup = 0;
    private static int dropSynonym = 0;
    private static int dropDistinctType = 0;
    private static int dropSequence = 0;
    private static int errors = 0;
    private static int warnings = 0;
    private static int createCollectionType = 0;
    private static int createPartitionFunction = 0;
    private static int createPartitionScheme = 0;
    private static int advancedStep = 10;
    private static final char INTERVAL = ' ';
    private static DDLAdvancedGenerator ddlAdvancedGenenerator = null;

    public DDLFileMaker(Design design) {
        this.setDesign(design);
    }

    public void setStorageDesign(Object object) {
        if (object instanceof StorageDesign) {
            this.setStorageDesign((StorageDesign)object);
        } else if (object instanceof RDBMSSite) {
            StorageDesign storageDesign = this.getAppView().getCurrentDesign().getStorageDesign((RDBMSSite)object);
            this.setStorageDesign(storageDesign);
        }
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public void setStatusBarOwner(StatusBarOwner statusBarOwner) {
        this.statusBarOwner = statusBarOwner != null ? statusBarOwner : new StatusBarOwner.NullStatusBarOwner();
    }

    public StringBuffer buffer() {
        if (this.contentBuffer == null) {
            this.contentBuffer = new StringBuffer();
        }
        return this.contentBuffer;
    }

    private int getIteratorSize(Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    public int getTextSize() {
        return this.buffer().length();
    }

    public void generateDDLContent(ProgressDialog progressDialog) {
        int n = this.getIteratorSize(this.getStorageDesign().ddlObjects());
        progressDialog.setMaximum(n + 10);
        RDBMSSite rDBMSSite = this.getAppView().getCurrentDesign().getSelectedRDBMSSite();
        this.getAppView().getCurrentDesign().setSelectedRDBMSSite(this.getStorageDesign().getRDBMSSite());
        progressDialog.setNote(Messages.getString("DDLFileMaker.ClearContent"));
        progressDialog.setProgress(0);
        this.clearContent();
        this.buffer().append(Messages.getString("DDLFileMaker.GeneratedBy")).append(Extension.getExtensionVersion()).append(this.newline());
        this.buffer().append(Messages.getString("DDLFileMaker.At")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(this.newline());
        if (this.getStorageDesign() != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            this.buffer().append(Messages.getString("DDLFileMaker.Site")).append(this.getStorageDesign().getName()).append(this.newline());
            this.buffer().append(Messages.getString("DDLFileMaker.Type")).append(this.getStorageDesign().getRDBMSType()).append(this.newline());
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            int n2 = 0;
            int n3 = 0;
            DDLFileMaker.resetCounters();
            DDLFileMaker.setddlAdvancedGenenerator(null);
            DDLAdvancedGenerator dDLAdvancedGenerator = this.getStorageDesign().createDDLAdvancedGenerator();
            if (DDLGenerationOptions.getDDLType() > 0 && dDLAdvancedGenerator != null) {
                DDLFileMaker.setddlAdvancedGenenerator(dDLAdvancedGenerator);
                dDLAdvancedGenerator.setDDLExceptionList(this.getAppView().getDDLExceptionList());
                dDLAdvancedGenerator.addAdvanceHeader(this.buffer());
            }
            DDLGenerator dDLGenerator = this.getStorageDesign().getDDLDropGenerator();
            dDLGenerator.clearTemporaryObjects();
            Iterator iterator = this.getStorageDesign().ddlDropObjects();
            progressDialog.setNote(Messages.getString("DDLFileMaker.GenerateDropStatements"));
            progressDialog.setProgress(5);
            while (iterator.hasNext()) {
                object9 = (ModelObject)iterator.next();
                dDLGenerator.appendDDLFor(this.buffer(), object9);
            }
            progressDialog.setProgress(10);
            object9 = this.getStorageDesign().getDDLUserGenerator();
            iterator = this.getStorageDesign().ddlUserObjects();
            progressDialog.setNote(Messages.getString("DDLFileMaker.DDLFileMaker.GenerateUserDefinitions"));
            progressDialog.setProgress(12);
            while (iterator.hasNext()) {
                object8 = (ModelObject)iterator.next();
                ((DDLGenerator)object9).appendDDLFor(this.buffer(), object8);
            }
            progressDialog.setProgress(14);
            object8 = this.getStorageDesign().getDDLIncompleteTypeGenerator();
            iterator = this.getStorageDesign().ddlIncompleteTypeObjects();
            progressDialog.setNote(Messages.getString("DDLFileMaker.GenerateIncompleteTypeDefinitions"));
            progressDialog.setProgress(16);
            while (iterator.hasNext()) {
                object7 = (ModelObject)iterator.next();
                ((DDLGenerator)object8).appendDDLFor(this.buffer(), object7);
            }
            progressDialog.setProgress(18);
            object7 = this.getStorageDesign().getDDLCollectionTypeGenerator();
            iterator = this.getStorageDesign().ddlCollectionTypeObjects();
            progressDialog.setNote(Messages.getString("DDLFileMaker.GenerateCollectionTypeDefinitions"));
            progressDialog.setProgress(12);
            while (iterator.hasNext()) {
                object6 = (ModelObject)iterator.next();
                ((DDLGenerator)object7).appendDDLFor(this.buffer(), object6);
            }
            progressDialog.setProgress(18);
            object6 = this.getStorageDesign().getDDLTypeGenerator();
            iterator = this.getStorageDesign().ddlTypeObjects();
            progressDialog.setNote(Messages.getString("DDLFileMaker.GenerateTypeDefinitions"));
            progressDialog.setProgress(20);
            while (iterator.hasNext()) {
                object5 = (ModelObject)iterator.next();
                ((DDLGenerator)object6).appendDDLFor(this.buffer(), object5);
            }
            progressDialog.setProgress(22);
            object5 = this.getStorageDesign().getDDLCompileTypeGenerator();
            iterator = this.getStorageDesign().ddlCompileTypeObjects();
            progressDialog.setNote(Messages.getString("DDLFileMaker.GenerateCompileTypeDefinitions"));
            progressDialog.setProgress(25);
            while (iterator.hasNext()) {
                object4 = (ModelObject)iterator.next();
                ((DDLGenerator)object5).appendDDLFor(this.buffer(), object4);
            }
            progressDialog.setProgress(30);
            object4 = this.getStorageDesign().getDDLGenerator();
            iterator = this.getStorageDesign().ddlObjects();
            while (iterator.hasNext()) {
                object3 = (ModelObject)iterator.next();
                progressDialog.setNote(MessageFormat.format(Messages.getString("DDLFileMaker.AppendDDLInfoFor"), ((ModelObject)object3).getName()));
                progressDialog.setProgress(++n3);
                ((DDLGenerator)object4).appendDDLFor(this.buffer(), object3);
                ++n2;
            }
            object3 = this.getStorageDesign().getDDLScopeGenerator();
            iterator = this.getStorageDesign().ddlScopeObjects();
            while (iterator.hasNext()) {
                object2 = (ModelObject)iterator.next();
                progressDialog.setNote(MessageFormat.format(Messages.getString("DDLFileMaker.AlterTableAddScopeFor"), ((ModelObject)object2).getName()));
                progressDialog.setProgress(++n3);
                ((DDLGenerator)object3).appendDDLFor(this.buffer(), object2);
                ++n2;
            }
            object2 = this.getStorageDesign().getDDLTriggerGenerator();
            iterator = this.getStorageDesign().ddlTriggersCausingObjects();
            while (iterator.hasNext()) {
                object = iterator.next();
                ((DDLGenerator)object2).appendDDLFor(this.buffer(), object);
            }
            object = this.getStorageDesign().getDDLAutoIncrementColumnGenerator();
            iterator = this.getStorageDesign().ddlAutoIncrementColumnObjects();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                ((DDLGenerator)object).appendDDLFor(this.buffer(), e);
            }
            for (DDLGenerator dDLGenerator2 : this.getStorageDesign().getDDLEndScriptGenerators()) {
                iterator = this.getStorageDesign().ddlEndScriptObjects();
                while (iterator.hasNext()) {
                    ModelObject modelObject = (ModelObject)iterator.next();
                    progressDialog.setNote(MessageFormat.format(Messages.getString("DDLFileMaker.EndScriptFor"), modelObject.getName()));
                    progressDialog.setProgress(++n3);
                    dDLGenerator2.appendDDLFor(this.buffer(), modelObject);
                    ++n2;
                }
            }
            if (DDLGenerationOptions.getDDLType() > 0 && dDLAdvancedGenerator != null) {
                dDLAdvancedGenerator.addStatementFinisher(this.buffer());
            }
            progressDialog.setNote(Messages.getString("DDLFileMaker.FinishingGeneration"));
            progressDialog.setProgress(97);
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            this.appendCounters(this.buffer(), this.getStorageDesign().getRDBMSType());
        } else {
            progressDialog.setProgress(100);
            this.buffer().append(Messages.getString("DDLFileMaker.NoStorageDesignAvailable"));
        }
        this.getAppView().getCurrentDesign().setSelectedRDBMSSite(rDBMSSite);
    }

    private void appendCounters(StringBuffer stringBuffer, RDBMSType rDBMSType) {
        stringBuffer.append(Messages.getString("DDLFileMaker.SummaryReport"));
        stringBuffer.append(this.newline());
        stringBuffer.append("-- ");
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- CREATE TABLE", createTable);
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- CREATE INDEX", createIndex);
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- ALTER TABLE", alterTable);
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- CREATE VIEW", createView);
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- CREATE PACKAGE", createPackage);
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- CREATE PACKAGE BODY", createPackageBody);
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- CREATE PROCEDURE", createProc);
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- CREATE FUNCTION", createFunction);
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- CREATE TRIGGER", createTrigger);
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- ALTER TRIGGER", alterTrigger);
        if (rDBMSType == StorageDesignDB2v70.RDBMS_TYPE) {
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE ALIAS", createAlias);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE AUX TABLE", createAuxTable);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DATABASE", createDatabase);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE STOGROUP", createStoGroup);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE SYNONYM", createSynomym);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE TABLESPACE", createTablespace);
            stringBuffer.append(this.newline());
            stringBuffer.append("-- ");
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP TABLESPACE", dropTablespace);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP DATABASE", dropDatabase);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP ALIAS", dropAlias);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP SYNONYM", dropSynonym);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP STOGROUP", dropStogroup);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP DISTINCT TYPE", dropDistinctType);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP PROCEDURES", dropProcedures);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP TRIGGERS", dropTriggers);
            stringBuffer.append(this.newline());
        } else if (rDBMSType == StorageDesignDB2v80.RDBMS_TYPE) {
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE ALIAS", createAlias);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE AUX TABLE", createAuxTable);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DATABASE", createDatabase);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE STOGROUP", createStoGroup);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE SYNONYM", createSynomym);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE TABLESPACE", createTablespace);
            stringBuffer.append(this.newline());
            stringBuffer.append("-- ");
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP TABLESPACE", dropTablespace);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP DATABASE", dropDatabase);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP ALIAS", dropAlias);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP SYNONYM", dropSynonym);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP STOGROUP", dropStogroup);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP DISTINCT TYPE", dropDistinctType);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP PROCEDURES", dropProcedures);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP TRIGGERS", dropTriggers);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP SEQUENCE", dropSequence);
            stringBuffer.append(this.newline());
        } else if (rDBMSType == StorageDesignUDBv71.RDBMS_TYPE) {
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE ALIAS", createAlias);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE BUFFERPOOL", createBufferPool);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DATABASE", createDatabase);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE INSTANCE", createInstance);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE NODE GROUP", createNodeGroup);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE TABLESPACE", createTablespace);
            stringBuffer.append(this.newline());
            stringBuffer.append("-- ");
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP TABLESPACE", dropTablespace);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP DATABASE", dropDatabase);
            stringBuffer.append(this.newline());
        } else if (rDBMSType == StorageDesignUDBv81.RDBMS_TYPE) {
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE ALIAS", createAlias);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE BUFFERPOOL", createBufferPool);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DATABASE", createDatabase);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE INSTANCE", createInstance);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DATABASE PARTITION GROUP", createDbPartitionGroup);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE SCHEMA", createSchema);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE SEQUENCE", createSequence);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE TABLESPACE", createTablespace);
            stringBuffer.append(this.newline());
            stringBuffer.append("-- ");
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP TABLESPACE", dropTablespace);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP DATABASE", dropDatabase);
            stringBuffer.append(this.newline());
        } else if (rDBMSType == StorageDesignOraclev9i.RDBMS_TYPE) {
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE COLLECTION TYPE", createCollectionType);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE CLUSTER", createCluster);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE CONTEXT", createContext);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DATABASE", createDatabase);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DIMENSION", createDimension);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DIRECTORY", createDirectory);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE ROLE", createRole);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE SEQUENCE", createSequence);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE MATERIALIZED VIEW", createSnapshot);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE SYNONYM", createSynomym);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE TABLESPACE", createTablespace);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE USER", createUser);
            stringBuffer.append(this.newline());
            stringBuffer.append("-- ");
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP TABLESPACE", dropTablespace);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP DATABASE", dropDatabase);
            stringBuffer.append(this.newline());
        } else if (rDBMSType == StorageDesignOraclev10g.RDBMS_TYPE) {
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE COLLECTION TYPE", createCollectionType);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE CLUSTER", createCluster);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE CONTEXT", createContext);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DATABASE", createDatabase);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DIMENSION", createDimension);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DIRECTORY", createDirectory);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DISK GROUP", createDiskgroup);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE ROLE", createRole);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE SEQUENCE", createSequence);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE MATERIALIZED VIEW", createSnapshot);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE SYNONYM", createSynomym);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE TABLESPACE", createTablespace);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE USER", createUser);
            stringBuffer.append(this.newline());
            stringBuffer.append("-- ");
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP TABLESPACE", dropTablespace);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP DATABASE", dropDatabase);
            stringBuffer.append(this.newline());
        } else if (rDBMSType == StorageDesignOraclev11g.RDBMS_TYPE) {
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE COLLECTION TYPE", createCollectionType);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE CLUSTER", createCluster);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE CONTEXT", createContext);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DATABASE", createDatabase);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DIMENSION", createDimension);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DIRECTORY", createDirectory);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DISK GROUP", createDiskgroup);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE ROLE", createRole);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE SEQUENCE", createSequence);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE MATERIALIZED VIEW", createSnapshot);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE SYNONYM", createSynomym);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE TABLESPACE", createTablespace);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE USER", createUser);
            stringBuffer.append(this.newline());
            stringBuffer.append("-- ");
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP TABLESPACE", dropTablespace);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP DATABASE", dropDatabase);
            stringBuffer.append(this.newline());
        } else if (rDBMSType == StorageDesignSqlServerv2k.RDBMS_TYPE) {
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DATABASE", createDatabase);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DEFAULT", createDefault);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE INDEX ON VIEW", createIndexOnView);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE ROLE", createRole);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE RULE", createRule);
            stringBuffer.append(this.newline());
            stringBuffer.append("-- ");
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP DATABASE", dropDatabase);
            stringBuffer.append(this.newline());
        } else if (rDBMSType == StorageDesignSqlServerv2k5.RDBMS_TYPE) {
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DATABASE", createDatabase);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE DEFAULT", createDefault);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE INDEX ON VIEW", createIndexOnView);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE ROLE", createRole);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE RULE", createRule);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE PARTITION FUNCTION", createPartitionFunction);
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- CREATE PARTITION SCHEME", createPartitionScheme);
            stringBuffer.append(this.newline());
            stringBuffer.append("-- ");
            stringBuffer.append(this.newline());
            this.appendFormattedString(stringBuffer, "-- DROP DATABASE", dropDatabase);
            stringBuffer.append(this.newline());
        }
        stringBuffer.append("-- ");
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- ERRORS", errors);
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- WARNINGS", warnings);
        stringBuffer.append(this.newline());
    }

    private void appendFormattedString(StringBuffer stringBuffer, String string, int n) {
        int n2 = Integer.valueOf(n).toString().length();
        stringBuffer.append(string);
        for (int i = 0; i < 45 - string.length() - n2; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(n);
    }

    public static void incrementCreateDatabase() {
        ++createDatabase;
    }

    public static void incrementCreateTable() {
        ++createTable;
    }

    public static int getCreateTable() {
        return createTable;
    }

    public static void incrementCreateIndex() {
        ++createIndex;
    }

    public static int getCreateIndex() {
        return createIndex;
    }

    public static void incrementCreateTablespace() {
        ++createTablespace;
    }

    public static void incrementCreateView() {
        ++createView;
    }

    public static int getCreateView() {
        return createView;
    }

    public static void incrementAlterTable() {
        ++alterTable;
    }

    public static int getAlterTable() {
        return alterTable;
    }

    public static void incrementCreateTrigger() {
        ++createTrigger;
    }

    public static int getCreateTrigger() {
        return createTrigger;
    }

    public static void incrementAlterTrigger() {
        ++alterTrigger;
    }

    public static int getAlterTrigger() {
        return alterTrigger;
    }

    public static void incrementCreatePackage() {
        ++createPackage;
    }

    public static void incrementCreateProc() {
        ++createProc;
    }

    public static void incrementCreateFunction() {
        ++createFunction;
    }

    public static void incrementCreatePackageBody() {
        ++createPackageBody;
    }

    public static void incrementCreateAlias() {
        ++createAlias;
    }

    public static void incrementCreateAuxTable() {
        ++createAuxTable;
    }

    public static void incrementCreateDistinctType() {
        ++createDistinctType;
    }

    public static void incrementCreateStructuredType() {
        ++createStructuredType;
    }

    public static void incrementCreateCollectionType() {
        ++createCollectionType;
    }

    public static void incrementCreateStoGroup() {
        ++createStoGroup;
    }

    public static void incrementCreateSynomym() {
        ++createSynomym;
    }

    public static void incrementCreateCluster() {
        ++createCluster;
    }

    public static void incrementCreateContext() {
        ++createContext;
    }

    public static void incrementCreateDimension() {
        ++createDimension;
    }

    public static void incrementCreateDirectory() {
        ++createDirectory;
    }

    public static void incrementCreateRole() {
        ++createRole;
    }

    public static void incrementCreateRollbackSegment() {
        ++createRollbackSegment;
    }

    public static void incrementCreateSequence() {
        ++createSequence;
    }

    public static int getCreateSequence() {
        return createSequence;
    }

    public static void incrementCreateSnapshot() {
        ++createSnapshot;
    }

    public static int getCreateSnapshot() {
        return createSnapshot;
    }

    public static void incrementCreateDiskgroup() {
        ++createDiskgroup;
    }

    public static void incrementCreateUser() {
        ++createUser;
    }

    public static void incrementCreateDefault() {
        ++createDefault;
    }

    public static void incrementCreateRule() {
        ++createRule;
    }

    public static void incrementCreateIndexOnView() {
        ++createIndexOnView;
    }

    public static void incrementCreateInstance() {
        ++createInstance;
    }

    public static void incrementCreateNodeGroup() {
        ++createNodeGroup;
    }

    public static void incrementCreateDbPartitionGroup() {
        ++createDbPartitionGroup;
    }

    public static void incrementCreateBufferPool() {
        ++createBufferPool;
    }

    public static void incrementCreateSchema() {
        ++createSchema;
    }

    public static void incrementDropAlias() {
        ++dropAlias;
    }

    public static void incrementDropTriggers() {
        ++dropTriggers;
    }

    public static void incrementDropProcedures() {
        ++dropProcedures;
    }

    public static void incrementDropSynonym() {
        ++dropSynonym;
    }

    public static void incrementDropStogroup() {
        ++dropStogroup;
    }

    public static void incrementDropDistinctType() {
        ++dropDistinctType;
    }

    public static void incrementDropSequence() {
        ++dropSequence;
    }

    public static void incrementDropDatabase() {
        ++dropDatabase;
    }

    public static void incrementDropTablespace() {
        ++dropTablespace;
    }

    public static void incrementErrors() {
        ++errors;
    }

    public static int getErrors() {
        return errors;
    }

    public static void incrementWarnings() {
        ++warnings;
    }

    public static int getWarnings() {
        return warnings;
    }

    public static void incrementPartitionFunction() {
        ++createPartitionFunction;
    }

    public static void incrementPartitionSheme() {
        ++createPartitionScheme;
    }

    public static void incrementAdvancedStep() {
        advancedStep += 10;
    }

    public static void resetCounters() {
        createDatabase = 0;
        createTable = 0;
        createIndex = 0;
        createTablespace = 0;
        createView = 0;
        alterTable = 0;
        createTrigger = 0;
        alterTrigger = 0;
        createPackage = 0;
        createPackageBody = 0;
        createProc = 0;
        createFunction = 0;
        createAlias = 0;
        createAuxTable = 0;
        createDistinctType = 0;
        createStructuredType = 0;
        createCollectionType = 0;
        createStoGroup = 0;
        createSynomym = 0;
        createCluster = 0;
        createContext = 0;
        createDimension = 0;
        createDirectory = 0;
        createRole = 0;
        createRollbackSegment = 0;
        createSequence = 0;
        createSnapshot = 0;
        createDiskgroup = 0;
        createUser = 0;
        createDefault = 0;
        createRule = 0;
        createIndexOnView = 0;
        createInstance = 0;
        createNodeGroup = 0;
        createDbPartitionGroup = 0;
        createBufferPool = 0;
        createSchema = 0;
        createPartitionFunction = 0;
        createPartitionScheme = 0;
        dropDatabase = 0;
        dropTablespace = 0;
        dropAlias = 0;
        dropSynonym = 0;
        dropStogroup = 0;
        dropSequence = 0;
        dropDistinctType = 0;
        dropProcedures = 0;
        dropTriggers = 0;
        errors = 0;
        warnings = 0;
        advancedStep = 10;
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public void clearContent() {
        this.buffer().setLength(0);
        this.content = null;
    }

    public String getContent() {
        if (this.content == null) {
            this.content = this.buffer().toString();
        }
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void saveContentDDLFile() {
        this.getAppView().getPersistenceManager().write(this);
    }

    public void statusMessage(String string, Object object) {
        this.statusMessage(string + object);
    }

    public void statusMessage(String string) {
        this.statusBarOwner.setTempStatusMessage(string, 5000);
    }

    public void checkErrors(Component component) {
        if (errors > 0) {
            String string = errors == 1 ? Messages.getString("DDLFileMaker.OneError") : MessageFormat.format(Messages.getString("DDLFileMaker.MultipleErrors"), errors);
            MessageDialogs.showMessage(component, MessageFormat.format(Messages.getString("DDLFileMaker.CheckDesignRules"), string));
        }
    }

    public static int getAdvancedStep() {
        return advancedStep;
    }

    public static DDLAdvancedGenerator getddlAdvancedGenenerator() {
        return ddlAdvancedGenenerator;
    }

    public static void setddlAdvancedGenenerator(DDLAdvancedGenerator dDLAdvancedGenerator) {
        ddlAdvancedGenenerator = dDLAdvancedGenerator;
    }
}

