/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.compare.ddl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.DefaultCaret;
import javax.swing.text.StyledEditorKit;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.compare.Messages;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.FindDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class CDDLFileMakerEditor
extends CustomDialog {
    private JScrollPane scrollPane;
    private JTextPane editor;
    private JPanel bottomPanel;
    private JButton saveButton;
    private JFrame dialog;
    private CDDLFileMaker fileMaker;
    private CompareObjectSelection merger;
    private JButton findButton;
    private FindDialog findDialog;
    private static File lastFolder = null;
    private static final Logger LOGGER = new Logger(CDDLFileMakerEditor.class);

    public CDDLFileMakerEditor(ApplicationView applicationView) {
        super(applicationView);
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.getEditorPane());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.getBottomPanel(), "South");
    }

    public CDDLFileMakerEditor(ApplicationView applicationView, CompareObjectSelection compareObjectSelection) {
        this(applicationView);
        this.merger = compareObjectSelection;
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JFrame(Messages.getString("CDDLFileMakerEditor.DDLFileEditor"));
            this.dialog.setContentPane(this);
            this.dialog.setSize(750, 600);
            this.dialog.setIconImage(this.getApplicationView().getFrame().getIconImage());
            this.setDefaultActions(this, true);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "CDDL_FILE_EDITOR_DIALOG";
    }

    public JEditorPane getEditorPane() {
        if (this.editor == null) {
            this.editor = new JTextPane();
            this.editor.setContentType("text/plain");
            this.editor.setEditorKit(new StyledEditorKit());
            this.editor.setFont(new Font("Courier New", 0, 12));
        }
        return this.editor;
    }

    public JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new FlowLayout(2));
            this.bottomPanel.add(this.getSaveButton());
            this.bottomPanel.add(this.getFindButton());
            JButton jButton = new JButton(Messages.getString("CDDLFileMakerEditor.Close"));
            jButton.setMnemonic(67);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CDDLFileMakerEditor.this.close();
                }
            });
            this.bottomPanel.add(jButton);
            JButton jButton2 = new JButton(this.getHelpAction());
            jButton2.setMnemonic(72);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.bottomPanel.add(jButton2);
        }
        return this.bottomPanel;
    }

    public JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton(Messages.getString("CDDLFileMakerEditor.Save"));
            this.saveButton.setMnemonic(83);
            this.saveButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CDDLFileMakerEditor.this.saveLocalCopy();
                }
            });
            this.saveButton.setToolTipText(Messages.getString("CDDLFileMakerEditor.SaveDDLContent"));
        }
        return this.saveButton;
    }

    public void saveLocalCopy() {
        try {
            Serializable serializable;
            URLFilter uRLFilter = new URLFilter(){

                public boolean accept(URL uRL) {
                    File file = new File(uRL.getPath());
                    return file.getName().toLowerCase().endsWith(".sql") || file.getName().toLowerCase().endsWith(".ddl") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("CDDLFileMakerEditor.DDLFiles");
                }
            };
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setSelectionScope(0);
            uRLChooser.setSelectionMode(0);
            uRLChooser.setShowJarsAsDirs(false);
            uRLChooser.setURLFilter(uRLFilter);
            if (lastFolder != null) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String string = this.getApplicationView().getSettings().getDefaultSavePath();
                if (string != null && string.length() > 0) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                } else {
                    serializable = this.getApplicationView().getUserHomeDirectory();
                    if (serializable != null) {
                        uRLChooser.setSelectedURL((URL)serializable);
                    }
                }
            }
            int n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("CDDLFileMakerEditor.SaveDDLLocally"));
            if (n == 0 && (serializable = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                lastFolder = ((File)serializable).getParentFile();
                this.saveLocalCopy((File)serializable);
            }
        }
        catch (IOException iOException) {
            LOGGER.error("", iOException);
            JOptionPane.showMessageDialog(this.getDialog(), new Object[]{Messages.getString("CDDLFileMakerEditor.CanNotWrite"), iOException.getMessage()}, Messages.getString("CDDLFileMakerEditor.WriteError"), 0);
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(this.getDialog(), new Object[]{Messages.getString("CDDLFileMakerEditor.UnexpectedError"), throwable.getMessage()}, Messages.getString("CDDLFileMakerEditor.WriteError"), 0);
        }
    }

    protected void saveLocalCopy(File file) throws IOException {
        int n;
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this.getDialog(), MessageFormat.format(Messages.getString("CDDLFileMakerEditor.FileExist"), file.getAbsolutePath()), Messages.getString("CDDLFileMakerEditor.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return;
        }
        String string = this.getEditorPane().getText();
        file.getParentFile().mkdirs();
        file.createNewFile();
        EnvironOptions environOptions = (EnvironOptions)Ide.getSettings().getData("environment-options");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, environOptions.getEncoding());
        outputStreamWriter.write(string);
        outputStreamWriter.close();
    }

    public CDDLFileMaker getDDLFileMaker() {
        if (this.fileMaker == null) {
            this.fileMaker = new CDDLFileMaker();
            this.fileMaker.setDesign(this.getApplicationView().getCurrentDesign());
            this.fileMaker.setMerger(this.getMerger());
            this.fileMaker.setStatusBarOwner(this.getApplicationView());
        }
        return this.fileMaker;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setStorageDesignSelection(Object object) {
        this.getDDLFileMaker().setStorageDesign(object);
        ((JFrame)this.getDialog()).setTitle(new StringBuffer(Messages.getString("CDDLFileMakerEditor.DDLFileEditorS")).append(String.valueOf(object)).toString());
        this.repaint();
    }

    public CompareObjectSelection getMerger() {
        return this.merger;
    }

    public JButton getFindButton() {
        if (this.findButton == null) {
            this.findButton = new JButton(Messages.getString("CDDLFileMakerEditor.Find"));
            this.findButton.setMnemonic(70);
            this.findButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.findButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CDDLFileMakerEditor.this.getFindDialog().showFind(CDDLFileMakerEditor.this.getEditorPane());
                }
            });
            this.findButton.setToolTipText("Find");
        }
        return this.findButton;
    }

    private FindDialog getFindDialog() {
        if (this.findDialog == null) {
            this.findDialog = new FindDialog((Frame)this.getDialog());
            DefaultCaret defaultCaret = new DefaultCaret(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    this.setVisible(false);
                }
            };
            defaultCaret.setBlinkRate(this.editor.getCaret().getBlinkRate());
            this.editor.setCaret(defaultCaret);
        }
        this.editor.getDocument().putProperty("__EndOfLine__", "\n");
        return this.findDialog;
    }
}

