/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.compare.ddl;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.compare.CompareModelsDialog;
import oracle.dbtools.crest.swingui.compare.Messages;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.MessageDialogs;

public class CDDLFileMaker
extends ModelObject {
    private StorageDesign storageDesign;
    private StringBuffer contentBuffer;
    private StatusBarOwner statusBarOwner = new StatusBarOwner.NullStatusBarOwner();
    private String content;
    private CompareObjectSelection merger;
    private static int alterIndex = 0;
    private static int dropTable = 0;
    private static int dropIndex = 0;
    private static int dropTableView = 0;
    private static DDLAdvancedGenerator ddlAdvancedGenenerator = null;
    private static int replaceOption;
    private static final char INTERVAL = ' ';

    public void setStorageDesign(Object object) {
        if (object instanceof StorageDesign) {
            this.setStorageDesign((StorageDesign)object);
        } else if (object instanceof RDBMSSite) {
            StorageDesign storageDesign = this.getDesign().getStorageDesign((RDBMSSite)object);
            this.setStorageDesign(storageDesign);
        }
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public void setStatusBarOwner(StatusBarOwner statusBarOwner) {
        this.statusBarOwner = statusBarOwner != null ? statusBarOwner : new StatusBarOwner.NullStatusBarOwner();
    }

    public StringBuffer buffer() {
        if (this.contentBuffer == null) {
            this.contentBuffer = new StringBuffer();
        }
        return this.contentBuffer;
    }

    private int getIteratorSize(Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    public int getTextSize() {
        return this.buffer().length();
    }

    public void generateDDLContent(ProgressDialog progressDialog) {
        int n = this.getIteratorSize(this.getMerger().ddlObjects());
        progressDialog.setMaximum(n + 10);
        RDBMSSite rDBMSSite = this.getDesign().getSelectedRDBMSSite();
        this.getDesign().setSelectedRDBMSSite(this.getStorageDesign().getRDBMSSite());
        progressDialog.setNote(Messages.getString("CDDLFileMaker.ClearContent"));
        progressDialog.setProgress(0);
        this.clearContent();
        this.buffer().append(Messages.getString("CDDLFileMaker.GeneratedBy")).append(Extension.getExtensionVersion()).append(this.newline());
        this.buffer().append(Messages.getString("CDDLFileMaker.At")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(this.newline());
        if (this.getMerger() != null) {
            Object object;
            this.buffer().append(Messages.getString("CDDLFileMaker.Site")).append(this.getStorageDesign().getName()).append(this.newline());
            this.buffer().append(Messages.getString("CDDLFileMaker.Type")).append(this.getStorageDesign().getRDBMSType()).append(this.newline());
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            int n2 = 0;
            int n3 = 0;
            this.resetCounters();
            CDDLFileMaker.setddlAdvancedGenenerator(null);
            DDLAdvancedGenerator dDLAdvancedGenerator = this.getStorageDesign().createDDLAdvancedGenerator();
            if (DDLGenerationOptions.getDDLType() > 0 && dDLAdvancedGenerator != null) {
                CDDLFileMaker.setddlAdvancedGenenerator(dDLAdvancedGenerator);
                CDDLFileMaker.setReplaceOption(CompareModelsDialog.getReplaceOption());
                dDLAdvancedGenerator.setDDLExceptionList(this.getDesign().getAppView().getDDLExceptionList());
                dDLAdvancedGenerator.addAdvanceHeader(this.buffer());
                if (CompareModelsDialog.getUnloadStatement()) {
                    dDLAdvancedGenerator.unloadStatement(this.buffer());
                }
            }
            DDLGenerator dDLGenerator = this.getMerger().getDDLDropGenerator();
            Iterator iterator = this.getMerger().ddlDropObjects();
            progressDialog.setNote(Messages.getString("CDDLFileMaker.GenerateDropStatements"));
            progressDialog.setProgress(5);
            while (iterator.hasNext()) {
                object = (ModelObject)iterator.next();
                dDLGenerator.appendDDLFor(this.buffer(), object);
            }
            progressDialog.setProgress(10);
            object = this.getMerger().getDDLGenerator();
            iterator = this.getMerger().ddlCreateObjects();
            while (iterator.hasNext()) {
                ModelObject modelObject = (ModelObject)iterator.next();
                progressDialog.setNote(Messages.getString("CDDLFileMaker.AppendDDLInfoFor") + modelObject.getName());
                progressDialog.setProgress(++n3);
                ((DDLGenerator)object).appendDDLFor(this.buffer(), modelObject);
                ++n2;
            }
            if (DDLGenerationOptions.getDDLType() > 0 && dDLAdvancedGenerator != null) {
                dDLAdvancedGenerator.addStatementFinisher(this.buffer());
            }
            progressDialog.setNote(Messages.getString("CDDLFileMaker.FinishingGeneration"));
            progressDialog.setProgress(97);
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            this.getMerger().removeDDLObjects();
            this.appendCounters(this.buffer(), this.getStorageDesign().getRDBMSType());
        } else {
            progressDialog.setProgress(100);
            this.buffer().append(Messages.getString("CDDLFileMaker.NoStorageDesignAvailable"));
        }
        this.getDesign().setSelectedRDBMSSite(rDBMSSite);
    }

    private void appendCounters(StringBuffer stringBuffer, RDBMSType rDBMSType) {
        stringBuffer.append(Messages.getString("CDDLFileMaker.SummaryReport"));
        stringBuffer.append(this.newline());
        stringBuffer.append("-- ");
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- CREATE TABLE", CDDLFileMaker.getCreateTable());
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- CREATE INDEX", CDDLFileMaker.getCreateIndex());
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- CREATE VIEW", CDDLFileMaker.getCreateView());
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- ALTER TABLE", CDDLFileMaker.getAlterTable());
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- ALTER INDEX", alterIndex);
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- DROP TABLE", dropTable);
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- DROP INDEX", dropIndex);
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- CREATE TRIGGER", CDDLFileMaker.getCreateTrigger());
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- ALTER TRIGGER", CDDLFileMaker.getAlterTrigger());
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- CREATE SEQUENCE", CDDLFileMaker.getCreateSequence());
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- CREATE MATERIALIZED VIEW", CDDLFileMaker.getCreateSnapshot());
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- DROP VIEW", dropTableView);
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
        stringBuffer.append("-- ");
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- ERRORS", CDDLFileMaker.getErrors());
        stringBuffer.append(this.newline());
        this.appendFormattedString(stringBuffer, "-- WARNINGS", CDDLFileMaker.getWarnings());
        stringBuffer.append(this.newline());
    }

    private void appendFormattedString(StringBuffer stringBuffer, String string, int n) {
        int n2 = new Integer(n).toString().length();
        stringBuffer.append(string);
        for (int i = 0; i < 45 - string.length() - n2; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(n);
    }

    public static void incrementCreateTable() {
        DDLFileMaker.incrementCreateTable();
    }

    public static int getCreateTable() {
        return DDLFileMaker.getCreateTable();
    }

    public static void incrementCreateIndex() {
        DDLFileMaker.incrementCreateIndex();
    }

    public static int getCreateIndex() {
        return DDLFileMaker.getCreateIndex();
    }

    public static void incrementCreateView() {
        DDLFileMaker.incrementCreateView();
    }

    public static int getCreateView() {
        return DDLFileMaker.getCreateView();
    }

    public static void incrementAlterTable() {
        DDLFileMaker.incrementAlterTable();
    }

    public static int getAlterTable() {
        return DDLFileMaker.getAlterTable();
    }

    public static void incrementAlterIndex() {
        ++alterIndex;
    }

    public static int getCreateTrigger() {
        return DDLFileMaker.getCreateTrigger();
    }

    public static int getAlterTrigger() {
        return DDLFileMaker.getAlterTrigger();
    }

    public static void incrementCreateSequence() {
        DDLFileMaker.incrementCreateSequence();
    }

    public static int getCreateSequence() {
        return DDLFileMaker.getCreateSequence();
    }

    public static void incrementCreateSnapshot() {
        DDLFileMaker.incrementCreateSnapshot();
    }

    public static int getCreateSnapshot() {
        return DDLFileMaker.getCreateSnapshot();
    }

    public static void incrementErrors() {
        DDLFileMaker.incrementErrors();
    }

    public static int getErrors() {
        return DDLFileMaker.getErrors();
    }

    public static void incrementWarnings() {
        DDLFileMaker.incrementWarnings();
    }

    public static int getWarnings() {
        return DDLFileMaker.getWarnings();
    }

    private void resetCounters() {
        DDLFileMaker.resetCounters();
        alterIndex = 0;
        dropTable = 0;
        dropIndex = 0;
        dropTableView = 0;
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public void clearContent() {
        this.buffer().setLength(0);
        this.content = null;
    }

    public String getContent() {
        if (this.content == null) {
            this.content = this.buffer().toString();
        }
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void saveContentDDLFile() {
        this.getAppView().getPersistenceManager().write(this);
    }

    public void statusMessage(String string, Object object) {
        this.statusMessage(string + object);
    }

    public void statusMessage(String string) {
        this.statusBarOwner.setTempStatusMessage(string, 5000);
    }

    public void checkErrors(Component component) {
        int n = CDDLFileMaker.getErrors();
        if (n > 0) {
            String string = n == 1 ? Messages.getString("CDDLFileMaker.OneError") : MessageFormat.format(Messages.getString("CDDLFileMaker.ManyErrors"), n);
            MessageDialogs.showMessage(component, MessageFormat.format(Messages.getString("CDDLFileMaker.CheckDesignRules"), string));
        }
    }

    public CompareObjectSelection getMerger() {
        return this.merger;
    }

    public void setMerger(CompareObjectSelection compareObjectSelection) {
        this.merger = compareObjectSelection;
    }

    public static void incrementDropTable() {
        ++dropTable;
    }

    public static void incrementDropIndex() {
        ++dropIndex;
    }

    public static void incrementDropView() {
        ++dropTableView;
    }

    public static void incrementAdvancedStep() {
        DDLFileMaker.incrementAdvancedStep();
    }

    public static int getAdvancedStep() {
        return DDLFileMaker.getAdvancedStep();
    }

    public static DDLAdvancedGenerator getddlAdvancedGenenerator() {
        return ddlAdvancedGenenerator;
    }

    public static void setddlAdvancedGenenerator(DDLAdvancedGenerator dDLAdvancedGenerator) {
        ddlAdvancedGenenerator = dDLAdvancedGenerator;
    }

    public static int getReplaceOption() {
        return replaceOption;
    }

    private static void setReplaceOption(int n) {
        replaceOption = n;
    }
}

