/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.compare.cwddesign;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.browser.NavigationTreeRenderer;
import oracle.dbtools.crest.util.gui.swing.JSelectableLabel;

public class CompareCWDTreeRenderer
implements TreeCellRenderer {
    private JSelectableLabel component = new JSelectableLabel();
    private JPanel panel = new JPanel(new BorderLayout());
    protected JCheckBox cbox = new JCheckBox();
    private static Map icons = NavigationTreeRenderer.icons;
    private static Icon defaultIcon;
    private static Icon openIcon;
    static GUIConfiguration conf;
    static int iconSize;
    protected CompareCWDDesigns node;
    private boolean showCheckbox = true;

    public CompareCWDTreeRenderer(boolean bl) {
        this.showCheckbox = bl;
        this.panel.setLayout(new BorderLayout());
        this.cbox.setMargin(new Insets(0, 0, 0, 0));
        this.cbox.setBorderPaintedFlat(true);
        this.cbox.setOpaque(false);
        if (bl) {
            this.panel.add((Component)this.cbox, "West");
        }
        this.panel.add((Component)this.component, "Center");
    }

    private Icon getIconForstate(int n, Icon icon) {
        if (n == ModelIdObjectSelection.STATE_UNCHANGED) {
            return icon;
        }
        if (n == ModelIdObjectSelection.STATE_MODIFIED) {
            return conf.getObjectModifiedIcon(icon);
        }
        if (n == ModelIdObjectSelection.STATE_DELETED) {
            return conf.getObjectDeletedIcon(icon);
        }
        if (n == ModelIdObjectSelection.STATE_NEW) {
            return conf.getObjectAddedIcon(icon);
        }
        return null;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = "";
        this.node = (CompareCWDDesigns)object;
        ModelIDObject modelIDObject = this.node.getObject();
        string = this.node.getName();
        this.panel.setOpaque(false);
        this.cbox.setOpaque(false);
        this.component.setSelected(bl);
        this.component.setHasFocus(bl4);
        ImageIcon imageIcon = null;
        if (modelIDObject instanceof DesignObjectCollection) {
            imageIcon = (ImageIcon)icons.get(((DesignObjectCollection)((Object)modelIDObject)).getElementDescriptor());
        } else if (modelIDObject != null) {
            imageIcon = (ImageIcon)icons.get(modelIDObject.getClass());
        }
        if (imageIcon == null) {
            imageIcon = (ImageIcon)icons.get(this.node.getElementDescriptor());
        }
        if (imageIcon == null) {
            if (bl2) {
                imageIcon = (ImageIcon)openIcon;
                this.component.setIcon(openIcon);
            } else {
                imageIcon = (ImageIcon)defaultIcon;
                this.component.setIcon(defaultIcon);
            }
        }
        if (imageIcon != null) {
            imageIcon = (ImageIcon)this.getIconForstate(this.node.getStatus(), imageIcon);
            this.component.setIcon(imageIcon);
        }
        this.component.setText(string);
        FontRenderContext fontRenderContext = new FontRenderContext(this.component.getFont().getTransform(), false, false);
        int n2 = this.component.getFont().getStringBounds((String)string, (FontRenderContext)fontRenderContext).getBounds().width;
        this.component.setPreferredSize(new Dimension(n2 + 30, this.component.getPreferredSize().height));
        if (object instanceof ModelIdObjectSelection) {
            if (this.showCheckbox) {
                CompareCWDDesigns compareCWDDesigns = (CompareCWDDesigns)object;
                this.panel.remove(this.component);
                this.panel.remove(this.cbox);
                if (this.node.isEditable()) {
                    this.cbox.setSelected(compareCWDDesigns.isSelected());
                    this.panel.add((Component)this.cbox, "West");
                }
                this.panel.add((Component)this.component, "Center");
                return this.panel;
            }
            return this.panel;
        }
        this.panel.remove(this.component);
        return this.component;
    }

    public boolean isShowCheckbox() {
        return this.showCheckbox;
    }

    public void setShowCheckbox(boolean bl) {
        this.showCheckbox = bl;
    }

    static {
        conf = GUIConfiguration.getInstance();
        iconSize = 16;
        defaultIcon = conf.getIcon("BROWSER_CLOSED_ICON", iconSize);
        openIcon = conf.getIcon("BROWSER_OPEN_ICON", iconSize);
    }
}

