/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.compare.cwddesign;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDFilter;
import oracle.dbtools.crest.model.design.compare.cwddesign.CWDFilteredSelection;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.compare.cwddesign.DesignHandler;
import oracle.dbtools.crest.model.design.engineering.EngFilter;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.compare.Messages;
import oracle.dbtools.crest.swingui.compare.cwddesign.CompareCWDCheckEditor;
import oracle.dbtools.crest.swingui.compare.cwddesign.CompareCWDTreeRenderer;
import oracle.dbtools.crest.swingui.editor.TextCompareDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class CompareCWDDesignsDialog
extends CustomDialog
implements TreeSelectionListener,
TreeExpansionListener,
AdjustmentListener {
    private DesignHandler designHandler;
    private JPanel leftTreePanel;
    private JPanel rightTreePanel;
    private JDialog dialog;
    private JPanel buttonPanel;
    private JTabbedPane tabbedPane;
    private JScrollPane detailsSP;
    private JTable compareTable;
    private JButton button;
    private JCheckBoxMenuItem item;
    private JCheckBoxMenuItem item1;
    private JCheckBoxMenuItem item2;
    private JCheckBoxMenuItem item3;
    private JPopupMenu menu;
    private MyJTree leftTree;
    private MyJTree rightTree;
    private CompareTreeNavigationDesign leftNavDesign;
    private CompareTreeNavigationDesign rightNavDesign;
    private CompareCWDDesigns leftEngineer = null;
    private Map comparatorsMap;
    private Map objectsMap;
    JScrollBar leftSB;
    JScrollBar rightSB;
    private CompareCWDDesigns leftRoot;
    private MyJTree startTree = null;
    private boolean started = false;
    private boolean sel_started = false;
    private boolean sb_started = false;
    private SelectedCellRenderer selRenderer;
    private ModifiableCellRenderer propertyNameRenderer;
    private boolean result = false;

    public CompareCWDDesignsDialog(ApplicationView applicationView, DesignHandler designHandler, ProgressDialog progressDialog) {
        super(applicationView);
        CompareCWDDesigns compareCWDDesigns;
        this.designHandler = designHandler;
        this.tabbedPane = new JTabbedPane();
        this.selRenderer = new SelectedCellRenderer();
        this.propertyNameRenderer = new ModifiableCellRenderer();
        this.leftEngineer = compareCWDDesigns = new CompareCWDDesigns(designHandler);
        this.comparatorsMap = compareCWDDesigns.getComparatorsMap();
        this.objectsMap = compareCWDDesigns.getObjectsMap();
        this.initLeftTreePanel(compareCWDDesigns.getRoot());
        this.initRightTreePanel(compareCWDDesigns.getRightRoot());
        this.resetLeftTree(compareCWDDesigns.getRoot());
        this.resetRightTree(compareCWDDesigns.getRightRoot());
        this.leftTreePanel.setPreferredSize(new Dimension(350, 430));
        this.rightTreePanel.setPreferredSize(new Dimension(350, 430));
        this.leftTreePanel.setMinimumSize(new Dimension(300, 300));
        this.rightTreePanel.setMinimumSize(new Dimension(300, 300));
        this.tabbedPane.setPreferredSize(new Dimension(750, 200));
        this.tabbedPane.setMinimumSize(new Dimension(720, 190));
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(this.leftTreePanel);
        jSplitPane.setRightComponent(this.rightTreePanel);
        jSplitPane.setDividerLocation(-1);
        jSplitPane.setResizeWeight(0.5);
        this.compareTable = new JTable();
        this.detailsSP = new JScrollPane(this.compareTable);
        this.compareTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && ((n = CompareCWDDesignsDialog.this.compareTable.getSelectedColumn()) == 2 || n == 3)) {
                    int n2 = CompareCWDDesignsDialog.this.compareTable.getSelectedRow();
                    String string = (String)CompareCWDDesignsDialog.this.compareTable.getModel().getValueAt(n2, 0);
                    Object object = CompareCWDDesignsDialog.this.compareTable.getModel().getValueAt(n2, 2);
                    Object object2 = CompareCWDDesignsDialog.this.compareTable.getModel().getValueAt(n2, 3);
                    if (object instanceof String && object2 instanceof String && (!"".equalsIgnoreCase((String)object) || !"".equalsIgnoreCase((String)object2))) {
                        TextCompareDialog textCompareDialog = new TextCompareDialog(CompareCWDDesignsDialog.this.getApplicationView(), (String)object, (String)object2);
                        textCompareDialog.setTitle(string);
                        textCompareDialog.showDialog();
                    }
                }
            }
        });
        this.detailsSP.setPreferredSize(new Dimension(750, 200));
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, this.tabbedPane);
        this.initToolbar();
        this.add((Component)jSplitPane2, "Center");
        this.tabbedPane.add(Messages.getString("CompareCWDDesignsDialog.Details"), this.detailsSP);
        this.add((Component)this.getButtonPanel(), "South");
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            JButton jButton = new JButton(Messages.getString("CompareCWDDesignsDialog.Apply"));
            jButton.setMnemonic(69);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CompareCWDDesignsDialog.this.apply();
                    CompareCWDDesignsDialog.this.result = true;
                    CompareCWDDesignsDialog.this.close();
                }
            });
            JButton jButton2 = new JButton(Messages.getString("CompareCWDDesignsDialog.Cancel"));
            jButton2.setMnemonic(67);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CompareCWDDesignsDialog.this.result = false;
                    CompareCWDDesignsDialog.this.removeNewRelationalModels();
                    CompareCWDDesignsDialog.this.close();
                }
            });
            JButton jButton3 = new JButton(this.getHelpAction());
            jButton3.setMnemonic(72);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(jButton);
            this.buttonPanel.add(jButton2);
            this.buttonPanel.add(jButton3);
        }
        return this.buttonPanel;
    }

    private void removeNewRelationalModels() {
        Design design = this.designHandler.getTargetDesign();
        for (RelationalDesign relationalDesign : this.designHandler.getModelsToDeleteOnCancel()) {
            relationalDesign.setIsDeleting(true);
            design.removeRelationalDesign(relationalDesign);
        }
    }

    private JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            this.item = new JCheckBoxMenuItem(Messages.getString("CompareCWDDesignsDialog.ShowAllObjects"));
            this.item1 = new JCheckBoxMenuItem(Messages.getString("CompareCWDDesignsDialog.ShowNewObjects"));
            this.item2 = new JCheckBoxMenuItem(Messages.getString("CompareCWDDesignsDialog.ShowDeletedObjects"));
            this.item3 = new JCheckBoxMenuItem(Messages.getString("CompareCWDDesignsDialog.ShowModifiedObjects"));
            this.item.addActionListener(new ShowAllListener());
            this.item.setSelected(true);
            this.item.setEnabled(false);
            PopupMenuListener popupMenuListener = new PopupMenuListener();
            this.item1.addActionListener(popupMenuListener);
            this.item2.addActionListener(popupMenuListener);
            this.item3.addActionListener(popupMenuListener);
            this.menu.add(this.item);
            this.menu.add(this.item1);
            this.menu.add(this.item2);
            this.menu.add(this.item3);
        }
        return this.menu;
    }

    private void setFilter(JTree jTree, CWDFilter cWDFilter) {
        CompareCWDDesigns compareCWDDesigns = (CompareCWDDesigns)jTree.getModel().getRoot();
        int n = compareCWDDesigns.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            ((CWDFilteredSelection)compareCWDDesigns.getChild(i)).setFilter(cWDFilter);
        }
    }

    private void initToolbar() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.button = new JButton(Messages.getString("CompareCWDDesignsDialog.Filter"));
        this.button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = CompareCWDDesignsDialog.this.getPopupMenu();
                jPopupMenu.show(CompareCWDDesignsDialog.this.button, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            }
        });
        jPanel.add(this.button);
        this.add((Component)jPanel, "North");
    }

    private void initLeftTreePanel(ModelIdObjectSelection modelIdObjectSelection) {
        this.leftTreePanel = new JPanel(new BorderLayout());
        this.leftTree = new MyJTree();
        this.leftTree.setEditable(true);
        CompareCWDTreeRenderer compareCWDTreeRenderer = new CompareCWDTreeRenderer(true);
        this.leftTree.setCellRenderer(compareCWDTreeRenderer);
        CompareCWDCheckEditor compareCWDCheckEditor = new CompareCWDCheckEditor(true);
        this.leftTree.setCellEditor(compareCWDCheckEditor);
        JScrollPane jScrollPane = new JScrollPane(this.leftTree);
        this.leftTreePanel.add((Component)jScrollPane, "Center");
        this.leftTree.addTreeSelectionListener(this);
        this.leftTree.addTreeExpansionListener(this);
        this.leftSB = jScrollPane.getVerticalScrollBar();
        this.leftSB.addAdjustmentListener(this);
    }

    private void initRightTreePanel(ModelIdObjectSelection modelIdObjectSelection) {
        this.rightTreePanel = new JPanel(new BorderLayout());
        this.rightTree = new MyJTree();
        CompareCWDTreeRenderer compareCWDTreeRenderer = new CompareCWDTreeRenderer(false);
        compareCWDTreeRenderer.setShowCheckbox(false);
        this.rightTree.setCellRenderer(compareCWDTreeRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.rightTree);
        this.rightTreePanel.add((Component)jScrollPane, "Center");
        this.rightTree.addTreeSelectionListener(this);
        this.rightTree.addTreeExpansionListener(this);
        this.rightSB = jScrollPane.getVerticalScrollBar();
        this.rightSB.addAdjustmentListener(this);
    }

    private void resetLeftTree(CompareCWDDesigns compareCWDDesigns) {
        this.leftRoot = compareCWDDesigns;
        compareCWDDesigns.resetModifiedStatus();
        this.leftNavDesign = new CompareTreeNavigationDesign(compareCWDDesigns);
        this.leftTree.setModel(this.leftNavDesign);
    }

    private void resetRightTree(CompareCWDDesigns compareCWDDesigns) {
        compareCWDDesigns.resetModifiedStatus();
        this.rightNavDesign = new CompareTreeNavigationDesign(compareCWDDesigns);
        this.rightTree.setModel(this.rightNavDesign);
    }

    private void apply() {
        this.deleteSelected(this.getDeletedMappings());
        this.leftRoot.applySelectionTo();
        this.unregisterListeners();
    }

    private List getDeletedMappings() {
        if (this.leftEngineer != null) {
            return this.leftEngineer.getDeletedMappings();
        }
        return new ArrayList();
    }

    private void deleteSelected(List list) {
        for (CompareCWDDesigns compareCWDDesigns : list) {
            ModelIDObject modelIDObject;
            CompareCWDDesigns compareCWDDesigns2;
            if (!compareCWDDesigns.isSelected() || (compareCWDDesigns2 = compareCWDDesigns.getCorrespondentNode()) == null || compareCWDDesigns2.getObject() == null) continue;
            if (compareCWDDesigns2.getObject() instanceof DesignObject) {
                modelIDObject = (DesignObject)compareCWDDesigns2.getObject();
                if (modelIDObject == null) continue;
                ((DesignObject)modelIDObject).remove();
                continue;
            }
            if (!(compareCWDDesigns2.getObject() instanceof StorageObject) || (modelIDObject = (StorageObject)compareCWDDesigns2.getObject()) == null) continue;
            ((StorageObject)modelIDObject).remove();
        }
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("CompareCWDDesignsDialog.CompareModelingDesigns"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.addWindowListener(new ClosingListener());
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n = CompareCWDDesignsDialog.this.dialog.getWidth();
                    int n2 = CompareCWDDesignsDialog.this.dialog.getHeight();
                    n = Math.max(720, n);
                    n2 = Math.max(600, n2);
                    CompareCWDDesignsDialog.this.dialog.setSize(n, n2);
                }
            });
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    private void unregisterListeners() {
        this.leftNavDesign.unregisterAsListener();
        this.rightNavDesign.unregisterAsListener();
    }

    @Override
    protected String getHelpIndex() {
        return "COMPARE_CWD4ALL_DESIGNS_DIALOG";
    }

    MyJTree getOtherTree(JTree jTree) {
        if (jTree == this.leftTree) {
            return this.rightTree;
        }
        return this.leftTree;
    }

    private void synchroizeSelection(TreeSelectionEvent treeSelectionEvent) {
        Object object = treeSelectionEvent.getSource();
        if (object instanceof JTree && !this.sel_started) {
            this.startTree = (MyJTree)object;
            this.sel_started = true;
            TreePath treePath = treeSelectionEvent.getPath();
            CompareCWDDesigns compareCWDDesigns = (CompareCWDDesigns)treePath.getLastPathComponent();
            MyJTree myJTree = this.getOtherTree(this.startTree);
            myJTree.setSelectionPath(new TreePath(compareCWDDesigns.getCorrespondentNode().getPath()));
            this.sel_started = false;
        }
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().show();
        return this.result;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.synchroizeSelection(treeSelectionEvent);
        TreePath treePath = treeSelectionEvent.getPath();
        Object object = treePath.getLastPathComponent();
        if (object instanceof CompareCWDDesigns) {
            int[] nArray = new int[]{0, 0, 0, 0};
            boolean bl = this.compareTable.getColumnModel() != null;
            int n = 4;
            if (bl) {
                n = this.compareTable.getColumnModel().getColumnCount();
                for (int i = 0; i < n; ++i) {
                    nArray[i] = this.compareTable.getColumnModel().getColumn(i).getWidth();
                }
            }
            PropertiesComparator propertiesComparator = ((CompareCWDDesigns)object).getPropertiesComparator();
            this.compareTable.setModel(new CompareModel(propertiesComparator));
            this.compareTable.getColumnModel().getColumn(1);
            TableColumn tableColumn = this.compareTable.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(60);
            tableColumn.setWidth(60);
            tableColumn.setMaxWidth(70);
            tableColumn.setCellRenderer(this.selRenderer);
            tableColumn = this.compareTable.getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(this.propertyNameRenderer);
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    this.compareTable.getColumnModel().getColumn(i).setWidth(nArray[i]);
                    this.compareTable.getColumnModel().getColumn(i).setPreferredWidth(nArray[i]);
                }
            }
            this.compareTable.updateUI();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.processExpEvent(treeExpansionEvent, false);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.processExpEvent(treeExpansionEvent, true);
    }

    void processExpEvent(TreeExpansionEvent treeExpansionEvent, boolean bl) {
        Object object = treeExpansionEvent.getSource();
        if (object instanceof JTree && !this.started) {
            this.startTree = (MyJTree)object;
            this.started = true;
            TreePath treePath = treeExpansionEvent.getPath();
            CompareCWDDesigns compareCWDDesigns = (CompareCWDDesigns)treePath.getLastPathComponent();
            MyJTree myJTree = this.getOtherTree(this.startTree);
            myJTree.setExpandedState(new TreePath(compareCWDDesigns.getCorrespondentNode().getPath()), bl);
            this.started = false;
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object instanceof JScrollBar && !this.sb_started) {
            JScrollBar jScrollBar = (JScrollBar)object;
            if (jScrollBar == this.leftSB) {
                this.sb_started = true;
                this.rightSB.setValue(this.leftSB.getValue());
                this.sb_started = false;
            } else if (jScrollBar == this.rightSB) {
                this.sb_started = true;
                this.leftSB.setValue(this.rightSB.getValue());
                this.sb_started = false;
            }
        }
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    public Map getObjectsMap() {
        return this.objectsMap;
    }

    class ModifiableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ModifiableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable.getModel() instanceof CompareModel) {
                CompareModel compareModel = (CompareModel)jTable.getModel();
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)compareModel.getPropertiesList().get(n);
                this.setOpaque(true);
                this.setText(engPropertyHolder.getName());
                if (engPropertyHolder.isModified()) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(jTable.getForeground());
                }
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                    if (!engPropertyHolder.isModified()) {
                        this.setForeground(jTable.getSelectionForeground());
                    }
                } else {
                    this.setBackground(jTable.getBackground());
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    class SelectedCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        SelectedCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = (Boolean)object;
            if (jTable.getModel() instanceof CompareModel) {
                CompareModel compareModel = (CompareModel)jTable.getModel();
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)compareModel.getPropertiesList().get(n);
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
                this.setSelected(bl3);
                if (engPropertyHolder.isModified()) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setBackground(jTable.getBackground());
                }
            }
            return this;
        }
    }

    public class CompareModel
    extends AbstractTableModel {
        private PropertiesComparator comp;

        CompareModel(PropertiesComparator propertiesComparator) {
            this.comp = propertiesComparator;
        }

        public List getPropertiesList() {
            return this.comp.getPropertiesList();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.comp.getPropertiesList().size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CompareCWDDesignsDialog.Property");
            }
            if (n == 1) {
                return Messages.getString("CompareCWDDesignsDialog.Selected");
            }
            if (n == 2) {
                return this.comp.getLeftName();
            }
            if (n == 3) {
                return this.comp.getRightName();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)this.comp.getPropertiesList().get(n);
                return engPropertyHolder.isEditable();
            }
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            EngPropertyHolder engPropertyHolder = (EngPropertyHolder)this.comp.getPropertiesList().get(n);
            if (n2 == 0) {
                return engPropertyHolder.getName();
            }
            if (n2 == 1) {
                return new Boolean(engPropertyHolder.isSelected());
            }
            if (n2 == 2) {
                return engPropertyHolder.getLeftValue();
            }
            if (n2 == 3) {
                return engPropertyHolder.getRightValue();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)this.comp.getPropertiesList().get(n);
                engPropertyHolder.setSelected((Boolean)object);
            }
        }
    }

    class ClosingListener
    extends WindowAdapter {
        ClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            CompareCWDDesignsDialog.this.unregisterListeners();
        }
    }

    class MyJTree
    extends JTree {
        public MyJTree(TreeModel treeModel) {
            super(treeModel);
        }

        public MyJTree() {
        }

        @Override
        protected void setExpandedState(TreePath treePath, boolean bl) {
            super.setExpandedState(treePath, bl);
        }
    }

    class PopupMenuListener
    implements ActionListener {
        PopupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CWDFilter cWDFilter = new CWDFilter();
            if (CompareCWDDesignsDialog.this.item1.isSelected() || CompareCWDDesignsDialog.this.item2.isSelected() || CompareCWDDesignsDialog.this.item3.isSelected()) {
                CompareCWDDesignsDialog.this.item.setSelected(false);
            }
            if (CompareCWDDesignsDialog.this.item1.isSelected()) {
                cWDFilter.addFilter(EngFilter.STATE_NEW_FILTER);
            }
            if (CompareCWDDesignsDialog.this.item2.isSelected()) {
                cWDFilter.addFilter(EngFilter.STATE_DELETED_FILTER);
            }
            if (CompareCWDDesignsDialog.this.item3.isSelected()) {
                cWDFilter.addFilter(EngFilter.STATE_MODIFIED_FILTER);
            }
            CompareCWDDesignsDialog.this.item.setEnabled(true);
            if (!(CompareCWDDesignsDialog.this.item1.isSelected() || CompareCWDDesignsDialog.this.item2.isSelected() || CompareCWDDesignsDialog.this.item3.isSelected())) {
                cWDFilter.addFilter(EngFilter.NO_FILTER);
                CompareCWDDesignsDialog.this.item.setSelected(true);
                CompareCWDDesignsDialog.this.item.setEnabled(false);
            }
            CompareCWDDesignsDialog.this.setFilter(CompareCWDDesignsDialog.this.leftTree, cWDFilter);
            CompareCWDDesignsDialog.this.setFilter(CompareCWDDesignsDialog.this.rightTree, cWDFilter);
            CompareCWDDesignsDialog.this.leftTree.updateUI();
            CompareCWDDesignsDialog.this.rightTree.updateUI();
        }
    }

    class ShowAllListener
    implements ActionListener {
        ShowAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (CompareCWDDesignsDialog.this.item.isSelected()) {
                CompareCWDDesignsDialog.this.item.setEnabled(false);
                CompareCWDDesignsDialog.this.item1.setSelected(false);
                CompareCWDDesignsDialog.this.item2.setSelected(false);
                CompareCWDDesignsDialog.this.item3.setSelected(false);
                CWDFilter cWDFilter = new CWDFilter();
                cWDFilter.addFilter(EngFilter.NO_FILTER);
                CompareCWDDesignsDialog.this.setFilter(CompareCWDDesignsDialog.this.leftTree, cWDFilter);
                CompareCWDDesignsDialog.this.setFilter(CompareCWDDesignsDialog.this.rightTree, cWDFilter);
                CompareCWDDesignsDialog.this.leftTree.updateUI();
                CompareCWDDesignsDialog.this.rightTree.updateUI();
            } else {
                CompareCWDDesignsDialog.this.item.setEnabled(true);
            }
            CompareCWDDesignsDialog.this.item.setSelected(true);
        }
    }
}

