/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.compare;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.exports.ddl.DDLException;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.AbstractMerging;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.compare.Filter;
import oracle.dbtools.crest.model.design.compare.FilteredSelection;
import oracle.dbtools.crest.model.design.compare.IndexComparator;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableSelection;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.engineering.EngFilter;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.compare.CompareCheckEditor;
import oracle.dbtools.crest.swingui.compare.CompareTreeRenderer;
import oracle.dbtools.crest.swingui.compare.Messages;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMakerEditor;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.swingui.ddl.SyntaxDocument;
import oracle.dbtools.crest.swingui.ddl.SyntaxOffDocument;
import oracle.dbtools.crest.swingui.editor.DDLExceptionPropertyDialog;
import oracle.dbtools.crest.swingui.editor.SelectObjectDialog;
import oracle.dbtools.crest.swingui.editor.TextCompareDialog;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.OSEnvironment;
import oracle.dbtools.crest.util.compare.CompareMappingObject;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;

public class CompareModelsDialog
extends CustomDialog
implements TreeSelectionListener,
TreeExpansionListener,
AdjustmentListener {
    private RelationalDesign sourceDesign;
    private RelationalDesign targetDesign;
    private JPanel leftTreePanel;
    private JPanel rightTreePanel;
    private CompareTreeNavigationDesign leftNavDesign;
    private CompareTreeNavigationDesign rightNavDesign;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel optionsTab;
    private JTable recreateTab = new JTable(new RecreateTablesdModel());
    private JTable dataTypeTab;
    private JScrollPane detailsSP;
    private MyJTree leftTree;
    private MyJTree rightTree;
    private JTable compareTable = new JTable();
    private SelectedCellRenderer selRenderer = new SelectedCellRenderer();
    private ModifiableCellRenderer propertyNamerenderer = new ModifiableCellRenderer();
    private CompareObjectSelection leftRoot;
    private Map comparatorsMap;
    private List recreateTables = new ArrayList();
    private List columns = new ArrayList();
    private JDialog dialog;
    private JPanel buttonPanel;
    private Map objectsMap;
    private Settings settings;
    private JCheckBox chUseDataTypeKind = new JCheckBox(Messages.getString("CompareModelsDialog.UseDataTypeKindProperty"));
    private JCheckBox chUseSchemaProperty = new JCheckBox(Messages.getString("CompareModelsDialog.UseSchemaProperty"));
    private JCheckBox chUseColumnsOrderProperty = new JCheckBox(Messages.getString("CompareModelsDialog.UseColumnsOrderProperty"));
    private JCheckBox chCaseSensitiveNames = new JCheckBox(Messages.getString("CompareModelsDialog.CaseSensitiveNames"));
    private JCheckBox chUseGenInDDL = new JCheckBox(Messages.getString("CompareModelsDialog.UseGenerateInDDLSettings"));
    private JTabbedPane optionsPanel = new JTabbedPane();
    private JComboBox cbDDLType = new JComboBox<Object>(DDLGenerationOptions.DDL_TYPES);
    private JCheckBox chIncludeComments = new JCheckBox(Messages.getString("CompareModelsDialog.IncludeComments"));
    private JLabel lbUnloadDirectory = new JLabel(Messages.getString("CompareModelsDialog.UnloadDirectoryLabel"));
    private JTextField tfUnloadDirectory = new JTextField();
    private JTextField tfDateFormat = new JTextField();
    private JTextField tfTimestampFormat = new JTextField();
    private JTextField tfTimestampTZFormat = new JTextField();
    private List eList;
    private JTable eTable;
    private int counter = 0;
    private static boolean includeComments = false;
    private static boolean backupOption = false;
    private static boolean unloadStrategy;
    private static int replaceOption;
    private boolean disableDDLPreview;
    private JCheckBox chReplaceOption = new JCheckBox(Messages.getString("CompareModelsDialog.ReplaceExistingFiles"));
    private JButton button;
    JCheckBoxMenuItem item = new JCheckBoxMenuItem(Messages.getString("CompareModelsDialog.ShowAllObjects"));
    JCheckBoxMenuItem item1 = new JCheckBoxMenuItem(Messages.getString("CompareModelsDialog.ShowNewObjects"));
    JCheckBoxMenuItem item2 = new JCheckBoxMenuItem(Messages.getString("CompareModelsDialog.ShowDeletedObjects"));
    JCheckBoxMenuItem item3 = new JCheckBoxMenuItem(Messages.getString("CompareModelsDialog.ShowModifiedObjects"));
    private JPopupMenu menu;
    private JButton bnSynchronize;
    private JButton bnMerge;
    private JButton bnDDLPreview;
    private boolean isNewModel;
    private boolean modelsSwapped;
    private List oldStorageDesigns = null;
    private boolean importing = false;
    private CompareModelToModel leftEngineer = null;
    private boolean ddlOnly = false;
    private Map selectedIDs;
    private static final Logger LOGGER;
    JScrollBar leftSB;
    JScrollBar rightSB;
    MyJTree startTree = null;
    boolean started = false;
    boolean sb_started = false;
    boolean sel_started = false;
    private CDDLFileMakerEditor fileMakerEditor;
    List list = new ArrayList();
    private JPopupMenu popupMenuMapToColumn = new JPopupMenu();
    private JMenuItem mapColumn = new JMenuItem(Messages.getString("CompareModelsDialog.MapToExistingColumn"));
    private CompareObjectSelection selectedNode;

    public CompareModelsDialog(ApplicationView applicationView, RelationalDesign relationalDesign, RelationalDesign relationalDesign2, boolean bl) {
        this(applicationView, relationalDesign, relationalDesign2, bl, false, false, false, null, null);
    }

    public CompareModelsDialog(ApplicationView applicationView, RelationalDesign relationalDesign, RelationalDesign relationalDesign2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Map map) {
        this(applicationView, relationalDesign, relationalDesign2, bl, bl2, bl3, bl4, map, null);
    }

    public CompareModelsDialog(ApplicationView applicationView, RelationalDesign relationalDesign, RelationalDesign relationalDesign2, boolean bl, boolean bl2, boolean bl3, List list) {
        this(applicationView, relationalDesign, relationalDesign2, bl, bl2, bl3, false, null, list);
    }

    public CompareModelsDialog(ApplicationView applicationView, RelationalDesign relationalDesign, RelationalDesign relationalDesign2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Map map, List list) {
        super(applicationView);
        ModelObject modelObject;
        this.ddlOnly = PropertiesComparator.DDL_ONLY;
        this.settings = applicationView.getSettings();
        this.sourceDesign = relationalDesign;
        this.targetDesign = relationalDesign2;
        this.disableDDLPreview = bl;
        this.isNewModel = bl2;
        this.modelsSwapped = bl3;
        this.oldStorageDesigns = list;
        this.selectedIDs = map;
        this.initLeftTreePanel();
        this.initRightTreePanel();
        this.leftTreePanel.setPreferredSize(new Dimension(350, 400));
        this.rightTreePanel.setPreferredSize(new Dimension(350, 400));
        this.leftTreePanel.setMinimumSize(new Dimension(350, 200));
        this.rightTreePanel.setMinimumSize(new Dimension(350, 200));
        this.tabbedPane.setPreferredSize(new Dimension(700, 200));
        this.detailsSP = new JScrollPane(this.compareTable);
        this.compareTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && ((n = CompareModelsDialog.this.compareTable.getSelectedColumn()) == 2 || n == 3)) {
                    int n2 = CompareModelsDialog.this.compareTable.getSelectedRow();
                    String string = (String)CompareModelsDialog.this.compareTable.getModel().getValueAt(n2, 0);
                    Object object = CompareModelsDialog.this.compareTable.getModel().getValueAt(n2, 2);
                    Object object2 = CompareModelsDialog.this.compareTable.getModel().getValueAt(n2, 3);
                    if (object instanceof String && object2 instanceof String && (!"".equalsIgnoreCase((String)object) || !"".equalsIgnoreCase((String)object2))) {
                        TextCompareDialog textCompareDialog = new TextCompareDialog(CompareModelsDialog.this.getApplicationView(), (String)object, (String)object2);
                        textCompareDialog.setTitle(string);
                        textCompareDialog.showDialog();
                    }
                }
            }
        });
        this.detailsSP.setPreferredSize(new Dimension(700, 200));
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(this.leftTreePanel);
        jSplitPane.setRightComponent(this.rightTreePanel);
        jSplitPane.setDividerLocation(-1);
        jSplitPane.setResizeWeight(0.5);
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, this.tabbedPane);
        this.initToolbar();
        this.add((Component)jSplitPane2, "Center");
        this.tabbedPane.add(Messages.getString("CompareModelsDialog.Details"), this.detailsSP);
        this.add((Component)this.getButtonPanel(), "South");
        if (!bl) {
            this.addTabs();
            modelObject = applicationView.getCurrentDesign();
            this.tfDateFormat.setText(((Design)modelObject).getEngDateFormat());
            this.tfTimestampFormat.setText(((Design)modelObject).getEngTimestampFormat());
            this.tfTimestampTZFormat.setText(((Design)modelObject).getEngTimestampWTZFormat());
        }
        this.popupMenuMapToColumn.add(this.mapColumn);
        this.mapColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CompareModelsDialog.this.selectedNode != null) {
                    CompareModelsDialog.this.mapColumn(CompareModelsDialog.this.selectedNode);
                }
            }
        });
        this.initToolbar();
        this.cbDDLType.setSelectedIndex(DDLGenerationOptions.getDDLType());
        modelObject = new CompareModelToModel(relationalDesign, relationalDesign2, bl3, this.chUseGenInDDL.isSelected(), map);
        this.leftEngineer = modelObject;
        this.comparatorsMap = ((CompareModelToModel)modelObject).getComparatorsMap();
        this.objectsMap = ((CompareModelToModel)modelObject).getObjectsMap();
        this.initTrees();
        if (bl3 && bl4) {
            this.bnSynchronize.setVisible(true);
            if (!this.leftEngineer.getNewMappings().isEmpty() && this.bnDDLPreview.isEnabled()) {
                this.bnSynchronize.setEnabled(true);
            } else {
                this.bnSynchronize.setEnabled(false);
            }
        } else {
            this.bnSynchronize.setVisible(false);
            this.bnSynchronize.setEnabled(false);
        }
        this.bnMerge.setEnabled(!bl3);
    }

    private void initTrees() {
        this.recreateTables.clear();
        if (this.sourceDesign.isLoaded()) {
            this.resetLeftTree(this.leftEngineer.getRelationalRoot());
            this.resetRightTree(this.leftEngineer.getRightRelationalRoot());
        }
        this.recreateTables.addAll(this.leftEngineer.getTablesToRecreate());
        this.columns.addAll(this.leftEngineer.getColumnsWithChangedDataType());
        if (!this.disableDDLPreview) {
            this.fileMakerEditor = new CDDLFileMakerEditor(this.getApplicationView(), this.leftEngineer);
            this.getApplicationView().initLineTerminator();
            this.fileMakerEditor.setStorageDesignSelection(this.sourceDesign.getSelectedRDBMSSite());
        }
        this.recreateTab.updateUI();
    }

    public String getCaption() {
        return Messages.getString("CompareModelsDialog.CompareModels");
    }

    private void initToolbar() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.button = new JButton(Messages.getString("CompareModelsDialog.Filter"));
        this.button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = CompareModelsDialog.this.getPopupMenu();
                jPopupMenu.show(CompareModelsDialog.this.button, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            }
        });
        this.button.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jPanel.add(this.button);
        this.add((Component)jPanel, "North");
    }

    private JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            this.item.addActionListener(new ShowAllListener());
            this.item.setSelected(true);
            this.item.setEnabled(false);
            PopupMenuListener popupMenuListener = new PopupMenuListener();
            this.item1.addActionListener(popupMenuListener);
            this.item2.addActionListener(popupMenuListener);
            this.item3.addActionListener(popupMenuListener);
            this.menu.add(this.item);
            this.menu.add(this.item1);
            this.menu.add(this.item2);
            this.menu.add(this.item3);
        }
        return this.menu;
    }

    private void initOptions() {
        this.optionsTab.setBorder(new TitledBorder(new EtchedBorder(0), ""));
        this.optionsTab.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tfUnloadDirectory.setPreferredSize(new Dimension(250, 20));
        this.tfUnloadDirectory.setToolTipText(Messages.getString("CompareModelsDialog.ServerSideDirectory"));
        this.tfUnloadDirectory.setText(this.getDesign().getUnloadDirectory());
        jPanel.add((Component)this.lbUnloadDirectory, "West");
        jPanel.add(this.tfUnloadDirectory);
        this.optionsTab.add((Component)this.chIncludeComments, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 12, 0, 22), 10, 0));
        this.optionsTab.add((Component)this.cbDDLType, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 82), 20, 0));
        this.optionsTab.add((Component)this.chReplaceOption, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 82), 20, 0));
        this.optionsTab.add((Component)jPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 39), 3, 0));
        this.chIncludeComments.setSelected(false);
        this.chReplaceOption.setSelected(false);
        this.cbDDLType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareModelsDialog.this.tabbedPane.setEnabledAt(CompareModelsDialog.this.tabbedPane.getTabCount() - 1, CompareModelsDialog.this.cbDDLType.getSelectedIndex() > 0);
                DDLGenerationOptions.setDDLType(CompareModelsDialog.this.cbDDLType.getSelectedIndex());
                int n = CompareModelsDialog.this.recreateTab.getEditingColumn();
                int n2 = CompareModelsDialog.this.recreateTab.getEditingRow();
                if (n > -1 && n2 > -1) {
                    CompareModelsDialog.this.recreateTab.getCellEditor(n2, n).stopCellEditing();
                }
                if (CompareModelsDialog.this.cbDDLType.getSelectedIndex() <= 0 && CompareModelsDialog.this.isUnloadSelected()) {
                    Object[] objectArray = new Object[]{Messages.getString("CompareModelsDialog.Continue"), Messages.getString("CompareModelsDialog.Cancel")};
                    int n3 = JOptionPane.showOptionDialog(CompareModelsDialog.this, Messages.getString("CompareModelsDialog.BackupStrategyReset"), Messages.getString("CompareModelsDialog.Warning"), -1, 2, null, objectArray, objectArray[0]);
                    if (n3 != 0) {
                        CompareModelsDialog.this.cbDDLType.setSelectedIndex(1);
                    } else {
                        for (TableSelection tableSelection : CompareModelsDialog.this.recreateTables) {
                            if (!tableSelection.getBackupOption().equals(TableSelection.BACKUP_UNLOAD) && !tableSelection.getBackupOption().equals(TableSelection.BACKUP_UNLOAD_PARTITION)) continue;
                            tableSelection.setBackupOption(TableSelection.BACKUP_RENAME);
                        }
                    }
                }
            }
        });
    }

    private void setFilter(JTree jTree, Filter filter) {
        CompareObjectSelection compareObjectSelection = (CompareObjectSelection)jTree.getModel().getRoot();
        int n = compareObjectSelection.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            ((FilteredSelection)compareObjectSelection.getChild(i)).setFilter(filter);
        }
    }

    private void initLeftTreePanel() {
        this.leftTreePanel = new JPanel(new BorderLayout());
        this.leftTree = new MyJTree();
        this.leftTree.setEditable(true);
        CompareTreeRenderer compareTreeRenderer = new CompareTreeRenderer(true);
        this.leftTree.setCellRenderer(compareTreeRenderer);
        CompareCheckEditor compareCheckEditor = new CompareCheckEditor(true);
        this.leftTree.setCellEditor(compareCheckEditor);
        JScrollPane jScrollPane = new JScrollPane(this.leftTree);
        this.leftTreePanel.add((Component)jScrollPane, "Center");
        this.leftTree.addTreeSelectionListener(this);
        this.leftTree.addTreeExpansionListener(this);
        this.leftSB = jScrollPane.getVerticalScrollBar();
        this.leftSB.addAdjustmentListener(this);
        this.leftTree.addMouseListener(new PopupListener());
    }

    private void resetLeftTree(CompareObjectSelection compareObjectSelection) {
        this.leftRoot = compareObjectSelection;
        compareObjectSelection.resetModifiedStatus();
        this.leftNavDesign = new CompareTreeNavigationDesign(compareObjectSelection);
        this.leftTree.setModel(this.leftNavDesign);
        this.leftTree.addMouseListener(new PopupListener());
    }

    private void initRightTreePanel() {
        this.rightTreePanel = new JPanel(new BorderLayout());
        this.rightTree = new MyJTree();
        CompareTreeRenderer compareTreeRenderer = new CompareTreeRenderer(false);
        compareTreeRenderer.setShowCheckbox(false);
        this.rightTree.setCellRenderer(compareTreeRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.rightTree);
        this.rightTreePanel.add((Component)jScrollPane, "Center");
        this.rightTree.addTreeSelectionListener(this);
        this.rightTree.addTreeExpansionListener(this);
        this.rightSB = jScrollPane.getVerticalScrollBar();
        this.rightSB.addAdjustmentListener(this);
    }

    private void resetRightTree(CompareObjectSelection compareObjectSelection) {
        compareObjectSelection.resetModifiedStatus();
        this.rightNavDesign = new CompareTreeNavigationDesign(compareObjectSelection);
        this.rightTree.setModel(this.rightNavDesign);
    }

    private void unregisterListeners() {
        this.leftNavDesign.unregisterAsListener();
        this.rightNavDesign.unregisterAsListener();
    }

    private void addTabs() {
        this.addOptionsTab();
        this.initOptions();
        this.addRecreatedTab();
        this.addDataTypeTab();
        this.addDateTimeTab();
        this.addDDLExceptionsTab();
    }

    private void addDDLExceptionsTab() {
        Component component = this.tabbedPane.add(Messages.getString("CompareModelsDialog.OracleErrorsToMask"), this.initDDLExceptionsPanel());
        component.setEnabled(this.cbDDLType.getSelectedIndex() > 0);
    }

    private void addOptionsTab() {
        this.tabbedPane.add(Messages.getString("CompareModelsDialog.Options"), this.optionsPanel);
        this.optionsTab = new JPanel();
        this.optionsPanel.add(Messages.getString("CompareModelsDialog.DDLOptions"), this.optionsTab);
        JButton jButton = new JButton(Messages.getString("CompareModelsDialog.RefreshTrees"));
        jButton.setMnemonic(82);
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE_200);
        jButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = PropertiesComparator.DDL_ONLY;
                if (CompareModelsDialog.this.ddlOnly) {
                    PropertiesComparator.DDL_ONLY = true;
                }
                try {
                    CompareModelToModel compareModelToModel = new CompareModelToModel(CompareModelsDialog.this.sourceDesign, CompareModelsDialog.this.targetDesign, CompareModelsDialog.this.modelsSwapped, CompareModelsDialog.this.chUseGenInDDL.isSelected(), CompareModelsDialog.this.selectedIDs);
                    CompareModelsDialog.this.leftEngineer = compareModelToModel;
                    CompareModelsDialog.this.comparatorsMap = compareModelToModel.getComparatorsMap();
                    CompareModelsDialog.this.objectsMap = compareModelToModel.getObjectsMap();
                    CompareModelsDialog.this.initTrees();
                }
                finally {
                    PropertiesComparator.DDL_ONLY = bl;
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(new EtchedBorder(0), ""));
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.chUseGenInDDL, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 22), 10, 0));
        jPanel.add((Component)this.chUseDataTypeKind, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 22), 10, 0));
        jPanel.add((Component)this.chUseSchemaProperty, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 22), 10, 0));
        jPanel.add((Component)this.chUseColumnsOrderProperty, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 22), 10, 0));
        jPanel.add((Component)this.chCaseSensitiveNames, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 22), 10, 0));
        this.chUseGenInDDL.setToolTipText(Messages.getString("CompareModelsDialog.UseGenInDDLToolTip"));
        this.chUseGenInDDL.setEnabled(PropertiesComparator.DDL_ONLY);
        if (PropertiesComparator.DDL_ONLY) {
            this.chUseGenInDDL.setSelected(this.settings.isUseGenInDDLInCompare());
        }
        this.chUseDataTypeKind.setSelected(this.settings.isUseDataTypeKindInCompare());
        this.chUseSchemaProperty.setSelected(this.settings.isUseSchemaPropertyInCompare());
        this.chUseColumnsOrderProperty.setSelected(this.settings.isUseColumnsOrderPropertyInCompare());
        this.chCaseSensitiveNames.setSelected(this.settings.isCaseSensitiveNamesInCompare());
        this.chUseGenInDDL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareModelsDialog.this.settings.setUseGenInDDLInCompare(CompareModelsDialog.this.chUseGenInDDL.isSelected());
            }
        });
        this.chUseDataTypeKind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareModelsDialog.this.settings.setUseDataTypeKindInCompare(CompareModelsDialog.this.chUseDataTypeKind.isSelected());
            }
        });
        this.chUseSchemaProperty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareModelsDialog.this.settings.setUseSchemaPropertyInCompare(CompareModelsDialog.this.chUseSchemaProperty.isSelected());
            }
        });
        this.chUseColumnsOrderProperty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareModelsDialog.this.settings.setUseColumnsOrderPropertyInCompare(CompareModelsDialog.this.chUseColumnsOrderProperty.isSelected());
            }
        });
        this.chCaseSensitiveNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareModelsDialog.this.settings.setCaseSensitiveNamesInCompare(CompareModelsDialog.this.chCaseSensitiveNames.isSelected());
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(16, 12, 0, 10), 4, 25));
        jPanel2.add((Component)jButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 14, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.optionsPanel.add(Messages.getString("CompareModelsDialog.CompareOptions"), jPanel2);
    }

    protected void setObjectConstraints(SpringLayout springLayout, Component component, int n, int n2) {
        SpringLayout.Constraints constraints = springLayout.getConstraints(component);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge() {
        boolean bl = this.targetDesign.getMainView().isAutoRoute();
        if (bl) {
            this.targetDesign.getMainView().setAutoRoute(false);
            this.targetDesign.getMainView().getWorkSpace().updateSettings();
        }
        try {
            this.getDesign().setUnloadDirectory(this.tfUnloadDirectory.getText());
            this.getDesign().setRelationalDesign(this.targetDesign);
            this.getDesign().setEngDateFormat(this.tfDateFormat.getText());
            this.getDesign().setEngTimestampFormat(this.tfTimestampFormat.getText());
            this.getDesign().setEngTimestampWTZFormat(this.tfTimestampTZFormat.getText());
            ApplicationView.log(Messages.getString("CompareModelsDialog.MergeModels"));
            this.deleteSelected(this.getDeletedMappings());
            this.leftRoot.applySelectionToEngineering();
            boolean bl2 = this.targetDesign.getTableSet().isEmpty() && this.targetDesign.getTableViewSet().isEmpty();
            this.getDesign().executeMerging(this.sourceDesign, this.comparatorsMap, this.objectsMap);
            if (this.getDesign().getName().startsWith("Untitled") && this.isImporting()) {
                this.getDesign().setFileName(this.sourceDesign.getDesign().getFileName());
            }
            this.getDesign().resetDesignForDomains();
            this.getDesign().getRelationalDesign().setMainViewVisible(true);
            if (bl2 && this.importing) {
                ((DPVRelational)this.getDesign().getRelationalDesign().getMainView()).rearrangeNewDiagram();
                Iterator iterator = this.getDesign().getRelationalDesign().getMainView().getDisplays().iterator();
                while (iterator.hasNext()) {
                    DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
                    ((DPVRelational)designPartViewPlaceHolder.getDesignPartView()).rearrangeNewDiagram();
                }
            }
        }
        finally {
            if (bl) {
                this.targetDesign.getMainView().setAutoRoute(true);
                this.targetDesign.getMainView().getWorkSpace().updateSettings();
            }
        }
        if (((JDialog)this.getDialog()).isModal()) {
            this.unregisterListeners();
        }
    }

    private void deleteSelected(List list) {
        for (CompareObjectSelection compareObjectSelection : list) {
            ModelIDObject modelIDObject;
            CompareObjectSelection compareObjectSelection2;
            if (!compareObjectSelection.isSelected() || (compareObjectSelection2 = compareObjectSelection.getCorrespondentNode()) == null || compareObjectSelection2.getObject() == null) continue;
            if (compareObjectSelection2.getObject() instanceof DesignObject) {
                modelIDObject = (DesignObject)compareObjectSelection2.getObject();
                if (modelIDObject == null) continue;
                ((DesignObject)modelIDObject).remove();
                continue;
            }
            if (!(compareObjectSelection2.getObject() instanceof StorageObject) || (modelIDObject = (StorageObject)compareObjectSelection2.getObject()) == null) continue;
            ((StorageObject)modelIDObject).remove();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.synchroizeSelection(treeSelectionEvent);
        TreePath treePath = treeSelectionEvent.getPath();
        Object object = treePath.getLastPathComponent();
        if (object instanceof CompareObjectSelection) {
            int[] nArray = new int[]{0, 0, 0, 0};
            boolean bl = this.compareTable.getColumnModel() != null;
            int n = 4;
            if (bl) {
                n = this.compareTable.getColumnModel().getColumnCount();
                for (int i = 0; i < n; ++i) {
                    nArray[i] = this.compareTable.getColumnModel().getColumn(i).getWidth();
                }
            }
            PropertiesComparator propertiesComparator = ((CompareObjectSelection)object).getPropertiesComparator();
            this.compareTable.setModel(new CompareModel(propertiesComparator));
            this.compareTable.getColumnModel().getColumn(1);
            TableColumn tableColumn = this.compareTable.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(60);
            tableColumn.setWidth(60);
            tableColumn.setMaxWidth(70);
            tableColumn.setCellRenderer(this.selRenderer);
            tableColumn = this.compareTable.getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(this.propertyNamerenderer);
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    this.compareTable.getColumnModel().getColumn(i).setWidth(nArray[i]);
                    this.compareTable.getColumnModel().getColumn(i).setPreferredWidth(nArray[i]);
                }
            }
            this.compareTable.updateUI();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.processExpEvent(treeExpansionEvent, false);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.processExpEvent(treeExpansionEvent, true);
    }

    void processExpEvent(TreeExpansionEvent treeExpansionEvent, boolean bl) {
        Object object = treeExpansionEvent.getSource();
        if (object instanceof JTree && !this.started) {
            this.startTree = (MyJTree)object;
            this.started = true;
            TreePath treePath = treeExpansionEvent.getPath();
            CompareObjectSelection compareObjectSelection = (CompareObjectSelection)treePath.getLastPathComponent();
            MyJTree myJTree = this.getOtherTree(this.startTree);
            myJTree.setExpandedState(new TreePath(compareObjectSelection.getCorrespondentNode().getPath()), bl);
            this.started = false;
        }
    }

    MyJTree getOtherTree(JTree jTree) {
        if (jTree == this.leftTree) {
            return this.rightTree;
        }
        return this.leftTree;
    }

    private List getDeletedMappings() {
        if (this.leftEngineer != null) {
            return this.leftEngineer.getDeletedMappings();
        }
        return new ArrayList();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object instanceof JScrollBar && !this.sb_started) {
            JScrollBar jScrollBar = (JScrollBar)object;
            if (jScrollBar == this.leftSB) {
                this.sb_started = true;
                this.rightSB.setValue(this.leftSB.getValue());
                this.sb_started = false;
            } else if (jScrollBar == this.rightSB) {
                this.sb_started = true;
                this.leftSB.setValue(this.rightSB.getValue());
                this.sb_started = false;
            }
        }
    }

    private void synchroizeSelection(TreeSelectionEvent treeSelectionEvent) {
        Object object = treeSelectionEvent.getSource();
        if (object instanceof JTree && !this.sel_started) {
            this.startTree = (MyJTree)object;
            this.sel_started = true;
            TreePath treePath = treeSelectionEvent.getPath();
            CompareObjectSelection compareObjectSelection = (CompareObjectSelection)treePath.getLastPathComponent();
            MyJTree myJTree = this.getOtherTree(this.startTree);
            myJTree.setSelectionPath(new TreePath(compareObjectSelection.getCorrespondentNode().getPath()));
            this.sel_started = false;
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.getCaption());
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.addWindowListener(new ClosingListener());
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n = CompareModelsDialog.this.dialog.getWidth();
                    int n2 = CompareModelsDialog.this.dialog.getHeight();
                    n = Math.max(720, n);
                    n2 = Math.max(600, n2);
                    CompareModelsDialog.this.dialog.setSize(n, n2);
                }
            });
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "COMPARE_DIALOG";
    }

    public void setModal(boolean bl) {
        ((JDialog)this.getDialog()).setModal(bl);
    }

    @Override
    public void show() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            this.bnSynchronize = new JButton(Messages.getString("CompareModelsDialog.SyncNewObjects"));
            this.bnSynchronize.setToolTipText(Messages.getString("CompareModelsDialog.SyncNewObjectsToolTip"));
            this.bnSynchronize.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = false;
                    for (CompareObjectSelection compareObjectSelection : CompareModelsDialog.this.leftEngineer.getNewMappings()) {
                        ModelIDObject modelIDObject;
                        if (!compareObjectSelection.isSelected() || !"".equals((modelIDObject = compareObjectSelection.getObject()).getSourceConnName())) continue;
                        String string = "";
                        if (modelIDObject instanceof Column) {
                            string = ((Column)modelIDObject).getContainer().getName();
                        } else if (modelIDObject instanceof Index) {
                            string = ((Index)modelIDObject).getContainerObject().getSchema();
                        } else if (modelIDObject instanceof FKIndexAssociation) {
                            string = ((FKIndexAssociation)modelIDObject).getContainerWithKeyObject().getSchema();
                        } else if (modelIDObject instanceof CheckConstraint) {
                            string = ((Column)((CheckConstraint)((Object)modelIDObject)).getParent()).getContainer().getName();
                        } else if (modelIDObject instanceof TableLevelConstraint) {
                            string = ((TableLevelConstraint)modelIDObject).getTable().getSchema();
                        } else if (modelIDObject instanceof DesignObject) {
                            string = ((DesignObject)modelIDObject).getSchema();
                        }
                        this.stampModelObject(modelIDObject, string, modelIDObject.getName());
                        if (modelIDObject instanceof ModelIDObject) {
                            modelIDObject.setDirty(true);
                        }
                        bl = true;
                    }
                    if (bl) {
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CompareModelsDialog.SyncNewObjectsOk"));
                    }
                }

                private void stampModelObject(ModelObject modelObject, String string, String string2) {
                    RelationalDesign relationalDesign = modelObject.getDesign().getRelationalDesign();
                    if (!relationalDesign.getImportConnectionStamps().isEmpty() && relationalDesign.getImportConnectionStampIndex() > -1) {
                        int n = relationalDesign.getImportConnectionStampIndex();
                        DBConnectionStamp dBConnectionStamp = relationalDesign.getImportConnectionStamp(n);
                        modelObject.setSourceConnName(dBConnectionStamp.getConnName());
                        if (!"".equals(string)) {
                            modelObject.setSourceObjSchema(string);
                        } else {
                            modelObject.setSourceObjSchema(dBConnectionStamp.getConnUser());
                        }
                        modelObject.setSourceObjName(string2);
                    }
                }
            });
            this.bnMerge = new JButton(Messages.getString("CompareModelsDialog.Merge"));
            this.bnMerge.setMnemonic(77);
            this.bnMerge.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CompareModelsDialog.this.getApplicationView().setMerging(true);
                    boolean bl = PropertiesComparator.DDL_ONLY;
                    if (CompareModelsDialog.this.ddlOnly) {
                        PropertiesComparator.DDL_ONLY = true;
                    }
                    try {
                        CompareModelsDialog.this.merge();
                    }
                    finally {
                        PropertiesComparator.DDL_ONLY = bl;
                    }
                    CompareModelsDialog.this.close();
                }
            });
            JButton jButton = new JButton(Messages.getString("CompareModelsDialog.Close"));
            jButton.setMnemonic(67);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (CompareModelsDialog.this.isNewModel && !CompareModelsDialog.this.modelsSwapped) {
                        CompareModelsDialog.this.targetDesign.setIsDeleting(true);
                        CompareModelsDialog.this.targetDesign.getDesign().removeRelationalDesign(CompareModelsDialog.this.targetDesign);
                    } else if (CompareModelsDialog.this.oldStorageDesigns != null) {
                        StorageDesign[] storageDesignArray = CompareModelsDialog.this.modelsSwapped ? CompareModelsDialog.this.sourceDesign.getStorageDesignFactory().getOpenStorageDesigns() : CompareModelsDialog.this.targetDesign.getStorageDesignFactory().getOpenStorageDesigns();
                        for (int i = storageDesignArray.length - 1; i >= 0; --i) {
                            StorageDesign storageDesign = storageDesignArray[i];
                            if (CompareModelsDialog.this.oldStorageDesigns.contains(storageDesign)) continue;
                            storageDesign.delete(false);
                        }
                    }
                    CompareModelsDialog.this.close();
                }
            });
            this.bnDDLPreview = new JButton(Messages.getString("CompareModelsDialog.DDLPreview"));
            this.bnDDLPreview.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = CompareModelsDialog.this.recreateTab.getEditingColumn();
                    int n2 = CompareModelsDialog.this.recreateTab.getEditingRow();
                    if (n > -1 && n2 > -1) {
                        CompareModelsDialog.this.recreateTab.getCellEditor(n2, n).stopCellEditing();
                    }
                    n = CompareModelsDialog.this.dataTypeTab.getEditingColumn();
                    n2 = CompareModelsDialog.this.dataTypeTab.getEditingRow();
                    if (n > -1 && n2 > -1) {
                        CompareModelsDialog.this.dataTypeTab.getCellEditor(n2, n).stopCellEditing();
                    }
                    CompareModelsDialog.this.leftEngineer.applySelectionToEngineering();
                    Iterator iterator = CompareModelsDialog.this.recreateTables.iterator();
                    boolean bl = false;
                    boolean bl2 = true;
                    if (CompareModelsDialog.this.recreateTables.size() > 0) {
                        while (iterator.hasNext()) {
                            TableSelection tableSelection = (TableSelection)iterator.next();
                            if (!tableSelection.getBackupOption().equals(TableSelection.BACKUP_UNLOAD) && !tableSelection.getBackupOption().equals(TableSelection.BACKUP_UNLOAD_PARTITION)) continue;
                            bl = true;
                            if (CompareModelsDialog.this.isCorrectUnloadDir(tableSelection)) continue;
                            bl2 = false;
                            break;
                        }
                        if (bl && !bl2) {
                            JOptionPane.showMessageDialog(CompareModelsDialog.this.getDialog(), Messages.getString("CompareModelsDialog.NoUnloadDir"), Messages.getString("CompareModelsDialog.ErrGenerateDDL"), 0);
                            return;
                        }
                    }
                    if (bl) {
                        CompareModelsDialog.setUnloadStatement(true);
                    } else {
                        CompareModelsDialog.setUnloadStatement(false);
                    }
                    CompareModelsDialog.this.ddlPreview();
                }
            });
            int n = this.targetDesign.getSelectedRDBMSSite().getType().getType();
            this.bnDDLPreview.setEnabled(!this.disableDDLPreview && n >= 7 && n < 10);
            JButton jButton2 = new JButton(this.getHelpAction());
            jButton2.setMnemonic(72);
            this.bnSynchronize.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            this.bnMerge.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.bnDDLPreview.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(this.bnSynchronize);
            this.buttonPanel.add(this.bnMerge);
            this.buttonPanel.add(this.bnDDLPreview);
            this.buttonPanel.add(jButton);
            this.buttonPanel.add(jButton2);
        }
        return this.buttonPanel;
    }

    protected void ddlPreview() {
        this.sourceDesign.getDesign().setUnloadDirectory(this.tfUnloadDirectory.getText());
        this.sourceDesign.getDesign().setEngDateFormat(this.tfDateFormat.getText());
        this.sourceDesign.getDesign().setEngTimestampFormat(this.tfTimestampFormat.getText());
        this.sourceDesign.getDesign().setEngTimestampWTZFormat(this.tfTimestampTZFormat.getText());
        this.targetDesign.getDesign().setUnloadDirectory(this.tfUnloadDirectory.getText());
        this.targetDesign.getDesign().setEngDateFormat(this.tfDateFormat.getText());
        this.targetDesign.getDesign().setEngTimestampFormat(this.tfTimestampFormat.getText());
        this.targetDesign.getDesign().setEngTimestampWTZFormat(this.tfTimestampTZFormat.getText());
        CompareModelsDialog.setIncludeComments(this.chIncludeComments.isSelected());
        if (this.chReplaceOption.isSelected()) {
            CompareModelsDialog.setReplaceOption(1);
        } else {
            CompareModelsDialog.setReplaceOption(2);
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompareModelsDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    ProgressDialog progressDialog = new ProgressDialog(CompareModelsDialog.this.getDesign().getAppView(), "", 0, 100);
                    progressDialog.setParentComponent(CompareModelsDialog.this.getDialog());
                    try {
                        int n;
                        CompareModelsDialog.this.fileMakerEditor.getEditorPane().setText("");
                        CompareModelsDialog.this.fileMakerEditor.getDDLFileMaker().generateDDLContent(progressDialog);
                        CompareModelsDialog.this.fileMakerEditor.getScrollPane().setVisible(false);
                        int n2 = CompareModelsDialog.this.fileMakerEditor.getDDLFileMaker().getTextSize();
                        boolean bl = false;
                        if (n2 > 1000000 && (n = JOptionPane.showConfirmDialog(CompareModelsDialog.this, Messages.getString("CompareModelsDialog.LongDDLText"), Messages.getString("CompareModelsDialog.SelectAnOption"), 0)) == 0) {
                            bl = true;
                        }
                        JTextPane jTextPane = (JTextPane)CompareModelsDialog.this.fileMakerEditor.getEditorPane();
                        DefaultStyledDocument defaultStyledDocument = bl ? new SyntaxOffDocument() : new SyntaxDocument();
                        try {
                            defaultStyledDocument.insertString(0, CompareModelsDialog.this.fileMakerEditor.getDDLFileMaker().getContent(), jTextPane.getLogicalStyle());
                            jTextPane.setDocument(defaultStyledDocument);
                        }
                        catch (BadLocationException badLocationException) {
                            LOGGER.error("CompareModelsDialog.OKAction", badLocationException);
                        }
                        CompareModelsDialog.this.fileMakerEditor.getScrollPane().setVisible(true);
                    }
                    finally {
                        progressDialog.close();
                        CompareModelsDialog.this.fileMakerEditor.getDDLFileMaker().checkErrors(CompareModelsDialog.this.fileMakerEditor);
                    }
                }
                finally {
                    CompareModelsDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    CompareModelsDialog.this.fileMakerEditor.getDialog().setVisible(true);
                }
            }
        };
        thread.start();
    }

    private JPanel initDDLExceptionsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.eList = new ArrayList<DDLException>(this.getApplicationView().getDDLExceptionList().getDDLExceptions());
        this.eTable = new JTable(new DDLExceptionsModel());
        this.eTable.setSelectionMode(0);
        TableColumn tableColumn = this.eTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(5);
        tableColumn = this.eTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(200);
        this.eTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = CompareModelsDialog.this.eTable.getSelectedRow()) != -1 && CompareModelsDialog.this.eList.size() > 0 && n < CompareModelsDialog.this.eList.size()) {
                    DDLException dDLException = (DDLException)CompareModelsDialog.this.eList.get(n);
                    DDLExceptionPropertyDialog dDLExceptionPropertyDialog = new DDLExceptionPropertyDialog(CompareModelsDialog.this.getApplicationView(), dDLException, (JDialog)CompareModelsDialog.this.getDialog());
                    dDLExceptionPropertyDialog.initProperties();
                    dDLExceptionPropertyDialog.showDialog();
                    CompareModelsDialog.this.eTable.updateUI();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.eTable);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
        JButton jButton = new JButton(gUIConfiguration.getIcon("EDIT_ICON", 16));
        jButton.setToolTipText(Messages.getString("CompareModelsDialog.ViewProperties"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CompareModelsDialog.this.eTable.getSelectedRow();
                if (n != -1 && CompareModelsDialog.this.eList.size() > 0 && n < CompareModelsDialog.this.eList.size()) {
                    DDLException dDLException = (DDLException)CompareModelsDialog.this.eList.get(n);
                    DDLExceptionPropertyDialog dDLExceptionPropertyDialog = new DDLExceptionPropertyDialog(CompareModelsDialog.this.getApplicationView(), dDLException, (JDialog)CompareModelsDialog.this.getDialog());
                    dDLExceptionPropertyDialog.initProperties();
                    dDLExceptionPropertyDialog.showDialog();
                    CompareModelsDialog.this.eTable.updateUI();
                }
            }
        });
        JButton jButton2 = new JButton(gUIConfiguration.getIcon("ADD_ICON", 16));
        jButton2.setToolTipText(Messages.getString("CompareModelsDialog.AddDDLException"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DDLException dDLException = new DDLException(CompareModelsDialog.this.generateNumber(), "");
                if (CompareModelsDialog.this.getApplicationView().getDDLExceptionList().addDDLException(dDLException)) {
                    CompareModelsDialog.this.eList.add(dDLException);
                    CompareModelsDialog.this.eTable.updateUI();
                }
            }
        });
        JButton jButton3 = new JButton(gUIConfiguration.getIcon("REMOVE_ICON", 16));
        jButton3.setToolTipText(Messages.getString("CompareModelsDialog.RemoveDDLException"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = CompareModelsDialog.this.eTable.getSelectedRow();
                if (n != -1 && CompareModelsDialog.this.eList.size() > 0 && n < CompareModelsDialog.this.eList.size()) {
                    DDLException dDLException = (DDLException)CompareModelsDialog.this.eList.get(n);
                    CompareModelsDialog.this.eList.remove(dDLException);
                    CompareModelsDialog.this.getApplicationView().getDDLExceptionList().removeDDLException(dDLException);
                    CompareModelsDialog.this.eTable.updateUI();
                }
            }
        });
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton2);
        jToolBar.add(jButton3);
        jPanel2.add(jToolBar);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add(jScrollPane);
        jPanel.add(jPanel3);
        return jPanel;
    }

    protected int generateNumber() {
        int n = 0;
        int n2 = this.eList.size();
        if (n2 != 0) {
            n = this.counter = n2 + 1;
        } else {
            ++this.counter;
            n = this.counter;
        }
        while (this.numberExists(n)) {
            n = ++this.counter;
        }
        return n;
    }

    private boolean numberExists(int n) {
        for (int i = 0; i < this.eList.size(); ++i) {
            DDLException dDLException = (DDLException)this.eList.get(i);
            if (n != dDLException.getNumber()) continue;
            return true;
        }
        return false;
    }

    public static void setIncludeComments(boolean bl) {
        includeComments = bl;
    }

    public static boolean isIncludeComments() {
        return includeComments;
    }

    public static void setBackup(boolean bl) {
        backupOption = bl;
    }

    public static boolean isBackup() {
        return backupOption;
    }

    private void mapColumn(CompareObjectSelection compareObjectSelection) {
        CompareObjectSelection compareObjectSelection2 = compareObjectSelection.getCorrespondentNode();
        List list = this.getDropColumnNodes((CompareObjectSelection)compareObjectSelection2.getParent());
        if (list.size() > 0) {
            SelectObjectDialog selectObjectDialog = new SelectObjectDialog(this.getApplicationView().getFrame(), Messages.getString("CompareModelsDialog.SelectColumn"), list);
            selectObjectDialog.setVisible(true);
            CompareObjectSelection compareObjectSelection3 = (CompareObjectSelection)selectObjectDialog.getSelectedObject();
            if (compareObjectSelection3 != null) {
                this.resetNodes(compareObjectSelection, compareObjectSelection3);
                this.addToCompareMapping(compareObjectSelection, compareObjectSelection3);
            }
        }
    }

    private void addToCompareMapping(CompareObjectSelection compareObjectSelection, CompareObjectSelection compareObjectSelection2) {
        CompareObjectSelection compareObjectSelection3 = compareObjectSelection.getTableNode();
        CompareObjectSelection compareObjectSelection4 = compareObjectSelection2.getTableNode();
        if (compareObjectSelection3 != null && compareObjectSelection4 != null) {
            String string = compareObjectSelection3.getObject().getName();
            String string2 = compareObjectSelection4.getObject().getName();
            String string3 = compareObjectSelection.getObject().getName();
            String string4 = compareObjectSelection2.getObject().getName();
            CompareMappingObject compareMappingObject = new CompareMappingObject(string, string3, string2, string4);
            this.getApplicationView().getCurrentDesign().getDLSettings().getCompareMapping().addCompareMappingObject(compareMappingObject);
        }
    }

    private void resetNodes(CompareObjectSelection compareObjectSelection, CompareObjectSelection compareObjectSelection2) {
        CompareObjectSelection compareObjectSelection3 = compareObjectSelection.getCorrespondentNode();
        Column column = (Column)compareObjectSelection2.getObject();
        if (column != null) {
            this.comparatorsMap.remove(compareObjectSelection.getPropertiesComparator().getID());
            compareObjectSelection3.setObject(column);
            compareObjectSelection3.setName(null);
            compareObjectSelection3.presetStatus(ModelIdObjectSelection.STATE_MODIFIED);
            compareObjectSelection.presetStatus(ModelIdObjectSelection.STATE_MODIFIED);
            compareObjectSelection.setSelected(true);
            ColumnComparator columnComparator = new ColumnComparator((Column)compareObjectSelection.getObject(), column);
            compareObjectSelection3.setPropertiesComparator(columnComparator);
            compareObjectSelection.setPropertiesComparator(columnComparator);
            this.comparatorsMap.put(columnComparator.getID(), columnComparator);
            if (columnComparator.isDataTypeChanged() && !this.columns.contains(compareObjectSelection3)) {
                this.columns.add(compareObjectSelection3);
                Collections.sort(this.columns, ModelObjectSet.LONG_NAME_COMPARATOR);
                this.dataTypeTab.updateUI();
            }
            this.comparatorsMap.remove(compareObjectSelection2.getPropertiesComparator().getID());
            CompareObjectSelection compareObjectSelection4 = (CompareObjectSelection)compareObjectSelection2.getParent();
            compareObjectSelection4.removeChild(compareObjectSelection2);
            CompareObjectSelection compareObjectSelection5 = (CompareObjectSelection)compareObjectSelection2.getCorrespondentNode().getParent();
            compareObjectSelection5.removeChild(compareObjectSelection2.getCorrespondentNode());
            AbstractMerging.getObjectsMap().put(compareObjectSelection.getObject().getObjectID(), compareObjectSelection2.getObject());
            TableSelection tableSelection = (TableSelection)compareObjectSelection5.getParent();
            if (tableSelection != null) {
                TableComparator tableComparator = (TableComparator)tableSelection.getPropertiesComparator();
                tableComparator.presetColumnsOrder();
                ArrayList arrayList = new ArrayList();
                this.getIndexNodes(arrayList, tableSelection);
                for (int i = 0; i < arrayList.size(); ++i) {
                    CompareObjectSelection compareObjectSelection6 = (CompareObjectSelection)arrayList.get(i);
                    ((IndexComparator)compareObjectSelection6.getPropertiesComparator()).presetColumnsOrder();
                    if (compareObjectSelection6.isModified()) continue;
                    compareObjectSelection6.presetStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                    compareObjectSelection6.setSelected(false);
                    compareObjectSelection6.setEditable(false);
                    CompareObjectSelection compareObjectSelection7 = compareObjectSelection6.getCorrespondentNode();
                    compareObjectSelection7.presetStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                    compareObjectSelection7.setSelected(false);
                    compareObjectSelection7.setEditable(false);
                }
                if (!(tableSelection = (TableSelection)tableSelection.getCorrespondentNode()).isRecreateTable()) {
                    this.recreateTables.remove(tableSelection);
                    this.recreateTab.updateUI();
                }
            }
        }
    }

    private void getIndexNodes(List list, CompareObjectSelection compareObjectSelection) {
        int n = compareObjectSelection.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            CompareObjectSelection compareObjectSelection2 = (CompareObjectSelection)compareObjectSelection.getChild(i);
            if (compareObjectSelection2.getObject() instanceof Index) {
                list.add(compareObjectSelection2);
                continue;
            }
            this.getIndexNodes(list, compareObjectSelection2);
        }
    }

    private List getDropColumnNodes(CompareObjectSelection compareObjectSelection) {
        ArrayList<CompareObjectSelection> arrayList = new ArrayList<CompareObjectSelection>();
        int n = compareObjectSelection.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            CompareObjectSelection compareObjectSelection2 = (CompareObjectSelection)compareObjectSelection.getChild(i);
            if (compareObjectSelection2.getStatus() != ModelIdObjectSelection.STATE_DELETED) continue;
            arrayList.add(compareObjectSelection2);
        }
        return arrayList;
    }

    private void addRecreatedTab() {
        JComboBox<String> jComboBox = new JComboBox<String>(TableSelection.getRestoreOptions());
        JComboBox<String> jComboBox2 = new JComboBox<String>(TableSelection.getScriptExecuteOptions());
        TableColumn tableColumn = this.recreateTab.getColumnModel().getColumn(1);
        DefaultCellEditor defaultCellEditor = new BackupStrategyCellEditor();
        tableColumn.setCellEditor(defaultCellEditor);
        tableColumn = this.recreateTab.getColumnModel().getColumn(2);
        defaultCellEditor = new DefaultCellEditor(jComboBox);
        tableColumn.setCellEditor(defaultCellEditor);
        tableColumn = this.recreateTab.getColumnModel().getColumn(3);
        defaultCellEditor = new DefaultCellEditor(jComboBox2);
        tableColumn.setCellEditor(defaultCellEditor);
        this.recreateTab.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    // empty if block
                }
            }
        });
        this.tabbedPane.add(Messages.getString("CompareModelsDialog.TablesRecreated"), new JScrollPane(this.recreateTab));
    }

    private void addDataTypeTab() {
        this.dataTypeTab = new JTable(new DataTypeTransformModel());
        this.tabbedPane.add(Messages.getString("CompareModelsDialog.DataTypeConversion"), new JScrollPane(this.dataTypeTab));
    }

    private void addDateTimeTab() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.optionsPanel.add(Messages.getString("CompareModelsDialog.DateTimeFormat"), jPanel);
        jPanel.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(0), ""));
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(16, 12, 0, 10), 4, 25));
        jPanel2.add((Component)this.createRow(Messages.getString("CompareModelsDialog.DateFormat"), this.getDesign().getEngDateFormat(), this.tfDateFormat), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 39), 3, 0));
        jPanel2.add((Component)this.createRow(Messages.getString("CompareModelsDialog.TimestampFormat"), this.getDesign().getEngTimestampFormat(), this.tfTimestampFormat), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 39), 3, 0));
        jPanel2.add((Component)this.createRow(Messages.getString("CompareModelsDialog.TimestampTZFormat"), this.getDesign().getEngTimestampWTZFormat(), this.tfTimestampTZFormat), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 39), 3, 0));
    }

    protected JPanel createRow(String string, String string2, JTextField jTextField) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(240, 20));
        jTextField.setPreferredSize(new Dimension(250, 20));
        jTextField.setText(string2);
        jPanel.add((Component)jLabel, "West");
        jPanel.add(jTextField);
        return jPanel;
    }

    public static void setUnloadStatement(boolean bl) {
        unloadStrategy = bl;
    }

    public static boolean getUnloadStatement() {
        return unloadStrategy;
    }

    private boolean isCorrectUnloadDir(TableSelection tableSelection) {
        return !this.tfUnloadDirectory.getText().trim().equals("") || !tableSelection.getUnloadDirectory().trim().equals("");
    }

    private boolean isUnloadSelected() {
        for (TableSelection tableSelection : this.recreateTables) {
            if (!tableSelection.getBackupOption().equals(TableSelection.BACKUP_UNLOAD) && !tableSelection.getBackupOption().equals(TableSelection.BACKUP_UNLOAD_PARTITION)) continue;
            return true;
        }
        return false;
    }

    public static int getReplaceOption() {
        return replaceOption;
    }

    public static void setReplaceOption(int n) {
        replaceOption = n;
    }

    public boolean isImporting() {
        return this.importing;
    }

    public void setImporting(boolean bl) {
        this.importing = bl;
    }

    static {
        replaceOption = 2;
        LOGGER = new Logger(CompareModelsDialog.class);
    }

    class ShowAllListener
    implements ActionListener {
        ShowAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (CompareModelsDialog.this.item.isSelected()) {
                CompareModelsDialog.this.item.setEnabled(false);
                CompareModelsDialog.this.item1.setSelected(false);
                CompareModelsDialog.this.item2.setSelected(false);
                CompareModelsDialog.this.item3.setSelected(false);
                Filter filter = new Filter();
                filter.addFilter(EngFilter.NO_FILTER);
                CompareModelsDialog.this.setFilter(CompareModelsDialog.this.leftTree, filter);
                CompareModelsDialog.this.setFilter(CompareModelsDialog.this.rightTree, filter);
                CompareModelsDialog.this.leftTree.updateUI();
                CompareModelsDialog.this.rightTree.updateUI();
            } else {
                CompareModelsDialog.this.item.setEnabled(true);
            }
            CompareModelsDialog.this.item.setSelected(true);
        }
    }

    class PopupMenuListener
    implements ActionListener {
        PopupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Filter filter = new Filter();
            if (CompareModelsDialog.this.item1.isSelected() || CompareModelsDialog.this.item2.isSelected() || CompareModelsDialog.this.item3.isSelected()) {
                CompareModelsDialog.this.item.setSelected(false);
            }
            if (CompareModelsDialog.this.item1.isSelected()) {
                filter.addFilter(EngFilter.STATE_NEW_FILTER);
            }
            if (CompareModelsDialog.this.item2.isSelected()) {
                filter.addFilter(EngFilter.STATE_DELETED_FILTER);
            }
            if (CompareModelsDialog.this.item3.isSelected()) {
                filter.addFilter(EngFilter.STATE_MODIFIED_FILTER);
            }
            CompareModelsDialog.this.item.setEnabled(true);
            if (!(CompareModelsDialog.this.item1.isSelected() || CompareModelsDialog.this.item2.isSelected() || CompareModelsDialog.this.item3.isSelected())) {
                filter.addFilter(EngFilter.NO_FILTER);
                CompareModelsDialog.this.item.setSelected(true);
                CompareModelsDialog.this.item.setEnabled(false);
            }
            CompareModelsDialog.this.setFilter(CompareModelsDialog.this.leftTree, filter);
            CompareModelsDialog.this.setFilter(CompareModelsDialog.this.rightTree, filter);
            CompareModelsDialog.this.leftTree.updateUI();
            CompareModelsDialog.this.rightTree.updateUI();
        }
    }

    class BackupStrategyCellEditor
    extends DefaultCellEditor {
        JComboBox cbox;

        BackupStrategyCellEditor() {
            super(new JComboBox());
            this.cbox = (JComboBox)this.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            TableSelection tableSelection = (TableSelection)CompareModelsDialog.this.recreateTables.get(n);
            TableComparator tableComparator = (TableComparator)tableSelection.getPropertiesComparator();
            TableProxy tableProxy = tableComparator.getTargetTableProxy();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (tableProxy != null) {
                arrayList.add(TableSelection.BACKUP_RENAME);
                if (CompareModelsDialog.this.cbDDLType.getSelectedIndex() > 0 && tableProxy.isUnload()) {
                    arrayList.add(TableSelection.BACKUP_UNLOAD);
                    if (tableProxy.isUnloadPerPartition()) {
                        arrayList.add(TableSelection.BACKUP_UNLOAD_PARTITION);
                    }
                }
                arrayList.add(TableSelection.NONE);
            }
            this.cbox.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
            return this.cbox;
        }
    }

    class PopupListener
    extends MouseAdapter {
        private TreePath treePath;

        PopupListener() {
        }

        private void showPopupMenu(MouseEvent mouseEvent, Object object) {
            Object object2;
            JTree jTree = (JTree)object;
            this.treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (this.treePath != null && (object2 = this.treePath.getLastPathComponent()) instanceof CompareObjectSelection) {
                CompareObjectSelection compareObjectSelection = (CompareObjectSelection)object2;
                CompareModelsDialog.this.selectedNode = compareObjectSelection;
                if (this.shouldProcess(compareObjectSelection)) {
                    CompareModelsDialog.this.mapColumn.setEnabled(true);
                } else {
                    CompareModelsDialog.this.mapColumn.setEnabled(false);
                }
                CompareModelsDialog.this.popupMenuMapToColumn.show(jTree, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!OSEnvironment.isWindows()) {
                Object object = mouseEvent.getSource();
                if (mouseEvent.isPopupTrigger() && object instanceof JTree) {
                    this.showPopupMenu(mouseEvent, object);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (OSEnvironment.isWindows()) {
                Object object = mouseEvent.getSource();
                if (mouseEvent.isPopupTrigger() && object instanceof JTree) {
                    this.showPopupMenu(mouseEvent, object);
                }
            }
        }

        private boolean shouldProcess(CompareObjectSelection compareObjectSelection) {
            CompareObjectSelection compareObjectSelection2;
            List list;
            return compareObjectSelection.getStatus() == ModelIdObjectSelection.STATE_NEW && compareObjectSelection.getObject() instanceof Column && (list = CompareModelsDialog.this.getDropColumnNodes((CompareObjectSelection)(compareObjectSelection2 = compareObjectSelection.getCorrespondentNode()).getParent())).size() > 0;
        }
    }

    public class DDLExceptionsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return CompareModelsDialog.this.eList.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CompareModelsDialog.Selected");
            }
            if (n == 1) {
                return Messages.getString("CompareModelsDialog.Type");
            }
            if (n == 2) {
                return Messages.getString("CompareModelsDialog.Description");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DDLException dDLException = (DDLException)CompareModelsDialog.this.eList.get(n);
            if (n2 == 0) {
                return dDLException.isSelected();
            }
            if (n2 == 1) {
                return String.valueOf(dDLException.getNumber());
            }
            if (n2 == 2) {
                return dDLException.getDescription();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            DDLException dDLException = (DDLException)CompareModelsDialog.this.eList.get(n);
            if (n2 == 0) {
                dDLException.setSelected((Boolean)object);
            }
        }
    }

    class ModifiableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ModifiableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable.getModel() instanceof CompareModel) {
                CompareModel compareModel = (CompareModel)jTable.getModel();
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)compareModel.getPropertiesList().get(n);
                this.setOpaque(true);
                this.setText(engPropertyHolder.getName());
                if (engPropertyHolder.isModified()) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(jTable.getForeground());
                }
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                    if (!engPropertyHolder.isModified()) {
                        this.setForeground(jTable.getSelectionForeground());
                    }
                } else {
                    this.setBackground(jTable.getBackground());
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    class SelectedCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        SelectedCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = (Boolean)object;
            if (jTable.getModel() instanceof CompareModel) {
                CompareModel compareModel = (CompareModel)jTable.getModel();
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)compareModel.getPropertiesList().get(n);
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
                this.setSelected(bl3);
                if (engPropertyHolder.isModified()) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setBackground(jTable.getBackground());
                }
            }
            return this;
        }
    }

    public class DataTypeTransformModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return CompareModelsDialog.this.columns.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CompareModelsDialog.Column");
            }
            if (n == 1) {
                return Messages.getString("CompareModelsDialog.CurrentDataType");
            }
            if (n == 2) {
                return Messages.getString("CompareModelsDialog.NewDataType");
            }
            if (n == 3) {
                return Messages.getString("CompareModelsDialog.RecreateTable");
            }
            if (n == 4) {
                return Messages.getString("CompareModelsDialog.ConversionExpression");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 >= 3;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        private String getName(CompareObjectSelection compareObjectSelection) {
            if (compareObjectSelection.getObject() != null) {
                if (compareObjectSelection.getObject() instanceof TableProxy) {
                    return ((TableProxy)compareObjectSelection.getObject()).getUserSchema() + compareObjectSelection.getObject().getName();
                }
                if (compareObjectSelection.getObject() instanceof Table) {
                    return compareObjectSelection.getObject().getName();
                }
                return compareObjectSelection.getObject().getLongName();
            }
            return compareObjectSelection.getName();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CompareObjectSelection compareObjectSelection = (CompareObjectSelection)CompareModelsDialog.this.columns.get(n);
            if (n2 == 0) {
                return this.getName(compareObjectSelection);
            }
            if (n2 == 3) {
                ColumnComparator columnComparator = (ColumnComparator)compareObjectSelection.getPropertiesComparator();
                return columnComparator.isTableShouldBeRecreated();
            }
            if (n2 == 4) {
                return compareObjectSelection.getDataTypeConversion();
            }
            if (n2 == 1) {
                ColumnComparator columnComparator = (ColumnComparator)compareObjectSelection.getPropertiesComparator();
                return columnComparator.getPropertyHolderByName(PropertiesComparator.DATA_TYPE).getRightValue();
            }
            if (n2 == 2) {
                ColumnComparator columnComparator = (ColumnComparator)compareObjectSelection.getPropertiesComparator();
                return columnComparator.getPropertyHolderByName(PropertiesComparator.DATA_TYPE).getLeftValue();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            CompareObjectSelection compareObjectSelection = (CompareObjectSelection)CompareModelsDialog.this.columns.get(n);
            if (n2 == 3) {
                boolean bl = (Boolean)object;
                this.resetRecreateFlag(compareObjectSelection, bl);
                this.updateTableList(compareObjectSelection, bl);
            } else if (n2 == 4) {
                compareObjectSelection.setDataTypeConversion((String)object);
            }
        }

        private void resetRecreateFlag(CompareObjectSelection compareObjectSelection, boolean bl) {
            Table table = (Table)((Column)compareObjectSelection.getObject()).getContainerWithKeyObject();
            for (CompareObjectSelection compareObjectSelection2 : CompareModelsDialog.this.columns) {
                Table table2 = (Table)((Column)compareObjectSelection2.getObject()).getContainerWithKeyObject();
                if (table2 != table) continue;
                ColumnComparator columnComparator = (ColumnComparator)compareObjectSelection2.getPropertiesComparator();
                columnComparator.setTableShouldBeRecreated(bl);
            }
            this.fireTableDataChanged();
        }

        private void updateTableList(CompareObjectSelection compareObjectSelection, boolean bl) {
            TableSelection tableSelection = (TableSelection)((CompareObjectSelection)compareObjectSelection.getParent()).getParent();
            if (bl) {
                if (!CompareModelsDialog.this.recreateTables.contains(tableSelection)) {
                    CompareModelsDialog.this.recreateTables.add(tableSelection);
                    CompareModelsDialog.this.recreateTab.updateUI();
                }
            } else if (!tableSelection.isRecreateTable()) {
                CompareModelsDialog.this.recreateTables.remove(tableSelection);
                CompareModelsDialog.this.recreateTab.updateUI();
            }
        }
    }

    public class RecreateTablesdModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return CompareModelsDialog.this.recreateTables.size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CompareModelsDialog.Table");
            }
            if (n == 1) {
                return Messages.getString("CompareModelsDialog.BackupStrategy");
            }
            if (n == 2) {
                return Messages.getString("CompareModelsDialog.DataRestore");
            }
            if (n == 3) {
                return Messages.getString("CompareModelsDialog.ScriptExecution");
            }
            if (n == 4) {
                return Messages.getString("CompareModelsDialog.UnloadDirectory");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return false;
            }
            if (n2 == 3) {
                return CompareModelsDialog.this.cbDDLType.getSelectedIndex() > 0;
            }
            return true;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        private String getName(CompareObjectSelection compareObjectSelection) {
            if (compareObjectSelection.getObject() != null) {
                if (compareObjectSelection.getObject() instanceof TableProxy) {
                    return ((TableProxy)compareObjectSelection.getObject()).getUserSchema() + compareObjectSelection.getObject().getName();
                }
                if (compareObjectSelection.getObject() instanceof Table) {
                    return compareObjectSelection.getObject().getName();
                }
                return compareObjectSelection.getObject().getLongName();
            }
            return compareObjectSelection.getName();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TableSelection tableSelection = (TableSelection)CompareModelsDialog.this.recreateTables.get(n);
            if (n2 == 0) {
                return this.getName(tableSelection);
            }
            if (n2 == 1) {
                return tableSelection.getBackupOption();
            }
            if (n2 == 2) {
                return tableSelection.getRestoreOption();
            }
            if (n2 == 3) {
                return tableSelection.getScriptExecuteOption();
            }
            if (n2 == 4) {
                return tableSelection.getUnloadDirectory();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            TableSelection tableSelection = (TableSelection)CompareModelsDialog.this.recreateTables.get(n);
            if (n2 == 1) {
                tableSelection.setBackupOption((String)object);
            } else if (n2 == 2) {
                tableSelection.setRestoreOption((String)object);
            } else if (n2 == 3) {
                tableSelection.setScriptExecuteOption((String)object);
            } else if (n2 == 4) {
                tableSelection.setUnloadDirectory((String)object);
            }
        }
    }

    public class CompareModel
    extends AbstractTableModel {
        private PropertiesComparator comp;

        CompareModel(PropertiesComparator propertiesComparator) {
            this.comp = propertiesComparator;
        }

        public List getPropertiesList() {
            return this.comp.getPropertiesList();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.comp.getPropertiesList().size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("CompareModelsDialog.Property");
            }
            if (n == 1) {
                return Messages.getString("CompareModelsDialog.Selected");
            }
            if (n == 2) {
                return this.comp.getLeftName();
            }
            if (n == 3) {
                return this.comp.getRightName();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)this.comp.getPropertiesList().get(n);
                return engPropertyHolder.isEditable();
            }
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            EngPropertyHolder engPropertyHolder = (EngPropertyHolder)this.comp.getPropertiesList().get(n);
            if (n2 == 0) {
                return engPropertyHolder.getName();
            }
            if (n2 == 1) {
                return engPropertyHolder.isSelected();
            }
            if (n2 == 2) {
                return engPropertyHolder.getLeftValue();
            }
            if (n2 == 3) {
                return engPropertyHolder.getRightValue();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)this.comp.getPropertiesList().get(n);
                engPropertyHolder.setSelected((Boolean)object);
            }
        }
    }

    class MyJTree
    extends JTree {
        public MyJTree(TreeModel treeModel) {
            super(treeModel);
        }

        public MyJTree() {
        }

        @Override
        protected void setExpandedState(TreePath treePath, boolean bl) {
            super.setExpandedState(treePath, bl);
        }
    }

    class ClosingListener
    extends WindowAdapter {
        ClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            CompareModelsDialog.this.unregisterListeners();
        }
    }
}

