/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.domains;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ValueListEditorEx
extends JDialog {
    private JDialog dialog;
    private JTable editorPanel;
    private JPanel buttonPanel;
    private JButton bnAddValue;
    private JButton bnRemoveValue;
    private ConstraintEnumeration values;
    private ConstrainedObject object;
    private boolean readOnly = false;
    private JPanel mainPanel;
    private Dialog parent;
    private JButton bnCancel;
    KeyListener escKey = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\u001b') {
                ValueListEditorEx.this.bnCancel.doClick();
            }
        }
    };

    public ValueListEditorEx(Dialog dialog) {
        this.parent = dialog;
    }

    public ValueListEditorEx(Dialog dialog, boolean bl) {
        this.parent = dialog;
        this.readOnly = bl;
    }

    public void configureEditComponentFor(ConstraintEnumeration constraintEnumeration) {
        this.values = constraintEnumeration;
    }

    public void doEditing(ConstrainedObject constrainedObject) {
        this.object = constrainedObject;
        JDialog jDialog = this.getDialog();
        jDialog.setTitle(MessageFormat.format(Messages.getString("ValueListEditorEx.ValueListTitle"), constrainedObject.getName()));
        jDialog.setVisible(true);
    }

    protected JDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.parent, Messages.getString("ValueListEditorEx.ValueList"));
            this.dialog.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.dialog.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.dialog.setSize(new Dimension(450, 350));
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n = ValueListEditorEx.this.dialog.getWidth();
                    int n2 = ValueListEditorEx.this.dialog.getHeight();
                    n = Math.max(350, n);
                    n2 = Math.max(250, n2);
                    ValueListEditorEx.this.dialog.setSize(n, n2);
                }
            });
        }
        this.initData();
        CommonUtil.centerOnScreen(this.dialog);
        return this.dialog;
    }

    private void initData() {
        int n = this.editorPanel.getRowCount();
        for (int i = 0; i < n; ++i) {
            ((ValueTableModel)this.editorPanel.getModel()).removeRow(0);
        }
        Iterator iterator = this.object instanceof ContainedObjectWithDomain ? ((ContainedObjectWithDomain)((Object)this.object)).getValueIterator() : ((Domain)this.object).getValueIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object v = this.values.getValuesDescriptionMap().get(e);
            ((ValueTableModel)this.editorPanel.getModel()).addRow(new Object[]{e, v});
        }
        this.editorPanel.setEnabled(!this.readOnly);
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            this.mainPanel.add((Component)new JScrollPane(this.getEditorPane()), "Center");
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 5, 5));
            this.bnRemoveValue = new JButton(Messages.getString("ValueListEditorEx.Remove"));
            this.bnRemoveValue.setMnemonic(82);
            this.bnRemoveValue.setEnabled(!this.readOnly);
            this.bnRemoveValue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ValueListEditorEx.this.editorPanel.getSelectedRowCount() > -1) {
                        int n = ValueListEditorEx.this.editorPanel.getSelectedRowCount();
                        for (int i = 0; i < n; ++i) {
                            ((DefaultTableModel)ValueListEditorEx.this.editorPanel.getModel()).removeRow(ValueListEditorEx.this.editorPanel.getSelectedRows()[0]);
                        }
                        ValueListEditorEx.this.bnRemoveValue.setEnabled(false);
                    }
                }
            });
            this.bnRemoveValue.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            this.bnRemoveValue.setEnabled(false);
            this.bnRemoveValue.addKeyListener(this.escKey);
            this.bnAddValue = new JButton(Messages.getString("ValueListEditorEx.Add"));
            this.bnAddValue.setMnemonic(65);
            this.bnAddValue.setEnabled(!this.readOnly);
            this.bnAddValue.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            this.bnAddValue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((DefaultTableModel)ValueListEditorEx.this.editorPanel.getModel()).addRow(new Object[]{"", ""});
                    ValueListEditorEx.this.editorPanel.updateUI();
                    int n = ((DefaultTableModel)ValueListEditorEx.this.editorPanel.getModel()).getRowCount() - 1;
                    ValueListEditorEx.this.editorPanel.changeSelection(n, 0, false, false);
                    ValueListEditorEx.this.editorPanel.editCellAt(n, 0);
                    ValueListEditorEx.this.editorPanel.requestFocus();
                    ValueListEditorEx.this.bnRemoveValue.setEnabled(false);
                }
            });
            this.bnAddValue.addKeyListener(this.escKey);
            jPanel2.add(this.bnAddValue);
            jPanel2.add(this.bnRemoveValue);
            jPanel.add((Component)jPanel2, "North");
            this.mainPanel.add((Component)jPanel, "East");
        }
        return this.mainPanel;
    }

    protected JTable getEditorPane() {
        if (this.editorPanel == null) {
            this.editorPanel = new JTable(new ValueTableModel());
            ListSelectionModel listSelectionModel = this.editorPanel.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!ValueListEditorEx.this.readOnly) {
                        ValueListEditorEx.this.bnRemoveValue.setEnabled(true);
                    }
                }
            });
            this.editorPanel.addKeyListener(this.escKey);
        }
        return this.editorPanel;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            String string = this.readOnly ? Messages.getString("ValueListEditorEx.Close") : Messages.getString("ValueListEditorEx.Cancel");
            this.bnCancel = new JButton(string);
            this.bnCancel.setMnemonic(67);
            this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.bnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ValueListEditorEx.this.editorPanel.getEditingColumn();
                    int n2 = ValueListEditorEx.this.editorPanel.getEditingRow();
                    if (n > -1 && n2 > -1) {
                        ValueListEditorEx.this.editorPanel.getCellEditor(n2, n).stopCellEditing();
                    }
                    ValueListEditorEx.this.getDialog().setVisible(false);
                }
            });
            if (!this.readOnly) {
                JButton jButton = new JButton(Messages.getString("ValueListEditorEx.OK"));
                jButton.setMnemonic(79);
                jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = ValueListEditorEx.this.editorPanel.getEditingColumn();
                        int n2 = ValueListEditorEx.this.editorPanel.getEditingRow();
                        if (n > -1 && n2 > -1) {
                            ValueListEditorEx.this.editorPanel.getCellEditor(n2, n).stopCellEditing();
                        }
                        ValueListEditorEx.this.setProperties();
                        ValueListEditorEx.this.object.setValueList(ValueListEditorEx.this.values);
                        ValueListEditorEx.this.getDialog().setVisible(false);
                    }
                });
                this.buttonPanel.add(jButton);
            }
            this.buttonPanel.add(this.bnCancel);
        }
        return this.buttonPanel;
    }

    protected void setProperties() {
        if (this.object instanceof ContainedObject) {
            ((ContainedObject)((Object)this.object)).setUseDomainConstraints(false);
        }
        this.values.getValuesDescriptionMap().clear();
        for (int i = 0; i < this.editorPanel.getRowCount(); ++i) {
            String string = (String)this.editorPanel.getValueAt(i, 0);
            if (!string.equals(string.trim())) {
                string = "'" + string + "'";
            }
            String string2 = (String)this.editorPanel.getValueAt(i, 1);
            this.values.add(string, string2);
        }
    }

    class ValueTableModel
    extends DefaultTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("ValueListEditorEx.Value"), Messages.getString("ValueListEditorEx.Description")};

        ValueTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }
    }
}

