/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.domains;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class AVTEditor
extends JDialog {
    private static final String[] TYPES_NUMBER = new String[]{"DECIMAL", "INTEGER", "REAL", "SMALLINT", "NUMERIC", "DOUBLE", "FLOAT", "TINYINT", "BIGINT"};
    private JDialog dialog;
    private JTable editorPane;
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private ConstrainedObject object;
    private JButton bnAddAVT;
    private JButton bnModifyAVT;
    private JButton bnRemoveAVT;
    private boolean readOnly = false;
    private JTextField tfBeginValue;
    private JTextField tfEndValue;
    private JTextField tfDesc;
    private JRadioButton rbAsc;
    private JRadioButton rbDesc;
    private List avtList;
    private LogicalDatatype logicalDataType;
    private Dialog parent;
    private JButton bnCancel;
    KeyListener escKey = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\u001b') {
                AVTEditor.this.bnCancel.doClick();
            }
        }
    };

    public AVTEditor(Dialog dialog) {
        this.parent = dialog;
    }

    public AVTEditor(Dialog dialog, boolean bl) {
        this.parent = dialog;
        this.readOnly = bl;
    }

    public void configureEditComponentFor(ConstrainedObject constrainedObject, LogicalDatatype logicalDatatype) {
        this.object = constrainedObject;
        this.logicalDataType = logicalDatatype;
    }

    public void doEditing(ConstrainedObject constrainedObject) {
        this.dialog = this.getDialog();
        this.dialog.setTitle(MessageFormat.format(Messages.getString("AVTEditor.AVTTitle"), constrainedObject.getName()));
        this.dialog.setVisible(true);
    }

    protected JDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.parent, Messages.getString("AVTEditor.AVT"));
            this.dialog.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.dialog.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.dialog.setSize(new Dimension(680, 350));
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n = AVTEditor.this.dialog.getWidth();
                    int n2 = AVTEditor.this.dialog.getHeight();
                    n = Math.max(680, n);
                    n2 = Math.max(350, n2);
                    AVTEditor.this.dialog.setSize(n, n2);
                }
            });
            this.initData();
        }
        CommonUtil.centerOnScreen(this.dialog);
        return this.dialog;
    }

    private void initData() {
        this.avtList.clear();
        for (AVT aVT : this.object.getAVTs()) {
            AVT aVT2 = new AVT();
            aVT.copyTo(aVT2);
            this.avtList.add(aVT2);
        }
        if (this.object.getAVTSortOrder() == 0) {
            this.rbAsc.setSelected(true);
        } else {
            this.rbDesc.setSelected(true);
        }
        this.sortList();
        this.editorPane.updateUI();
        this.editorPane.setEnabled(!this.readOnly);
        this.rbAsc.setEnabled(!this.readOnly);
        this.rbDesc.setEnabled(!this.readOnly);
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            JPanel jPanel = new JPanel(new FlowLayout(0));
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(Messages.getString("AVTEditor.BeginValueS"));
            this.tfBeginValue = new JTextField(14);
            this.tfBeginValue.setEnabled(!this.readOnly);
            this.tfBeginValue.addKeyListener(this.escKey);
            jPanel2.add((Component)jLabel, "North");
            jPanel2.add((Component)this.tfBeginValue, "Center");
            JPanel jPanel3 = new JPanel(new BorderLayout());
            JLabel jLabel2 = new JLabel(Messages.getString("AVTEditor.EndValueS"));
            this.tfEndValue = new JTextField(14);
            this.tfEndValue.setEnabled(!this.readOnly);
            this.tfEndValue.addKeyListener(this.escKey);
            jPanel3.add((Component)jLabel2, "North");
            jPanel3.add((Component)this.tfEndValue, "Center");
            JPanel jPanel4 = new JPanel(new BorderLayout());
            JLabel jLabel3 = new JLabel(Messages.getString("AVTEditor.DescriptionS"));
            this.tfDesc = new JTextField(30);
            this.tfDesc.setEnabled(!this.readOnly);
            this.tfDesc.addKeyListener(this.escKey);
            jPanel4.add((Component)jLabel3, "North");
            jPanel4.add((Component)this.tfDesc, "Center");
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            jPanel.add(jPanel4);
            JPanel jPanel5 = new JPanel(new BorderLayout());
            jPanel5.add((Component)jPanel, "North");
            jPanel5.add((Component)new JScrollPane(this.getEditorPane()), "Center");
            this.mainPanel.add((Component)jPanel5, "Center");
            JPanel jPanel6 = new JPanel(new BorderLayout());
            jPanel6.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel jPanel7 = new JPanel(new GridLayout(0, 1, 5, 5));
            this.bnRemoveAVT = new JButton(Messages.getString("AVTEditor.Remove"));
            this.bnRemoveAVT.setMnemonic(82);
            this.bnRemoveAVT.setEnabled(!this.readOnly);
            this.bnRemoveAVT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AVTEditor.this.editorPane.getSelectedRow();
                    if (n > -1 && AVTEditor.this.avtList.size() > 0) {
                        AVTEditor.this.avtList.remove(n);
                        AVTEditor.this.editorPane.updateUI();
                        if (AVTEditor.this.avtList.size() > 0) {
                            AVTEditor.this.editorPane.removeRowSelectionInterval(0, AVTEditor.this.avtList.size() - 1);
                        }
                        AVTEditor.this.tfBeginValue.setText("");
                        AVTEditor.this.tfBeginValue.requestFocus();
                        AVTEditor.this.tfEndValue.setText("");
                        AVTEditor.this.tfDesc.setText("");
                        AVTEditor.this.bnRemoveAVT.setEnabled(false);
                        AVTEditor.this.bnModifyAVT.setEnabled(false);
                    }
                }
            });
            this.bnRemoveAVT.addKeyListener(this.escKey);
            this.bnRemoveAVT.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            this.bnRemoveAVT.setEnabled(false);
            this.bnModifyAVT = new JButton(Messages.getString("AVTEditor.Modify"));
            this.bnModifyAVT.setMnemonic(77);
            this.bnModifyAVT.setEnabled(!this.readOnly);
            this.bnModifyAVT.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            this.bnModifyAVT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    if (AVTEditor.this.canAdd() && (n = AVTEditor.this.editorPane.getSelectedRow()) > -1) {
                        AVT aVT = (AVT)AVTEditor.this.avtList.get(n);
                        aVT.setBeginValue(AVTEditor.this.tfBeginValue.getText());
                        aVT.setEndValue(AVTEditor.this.tfEndValue.getText());
                        aVT.setDescription(AVTEditor.this.tfDesc.getText());
                        AVTEditor.this.sortList();
                        AVTEditor.this.editorPane.updateUI();
                    }
                }
            });
            this.bnModifyAVT.setEnabled(false);
            this.bnModifyAVT.addKeyListener(this.escKey);
            this.bnAddAVT = new JButton(Messages.getString("AVTEditor.Add"));
            this.bnAddAVT.setMnemonic(65);
            this.bnAddAVT.setEnabled(!this.readOnly);
            this.bnAddAVT.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            this.bnAddAVT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AVTEditor.this.canAdd()) {
                        AVT aVT = new AVT(AVTEditor.this.tfBeginValue.getText(), AVTEditor.this.tfEndValue.getText(), AVTEditor.this.tfDesc.getText());
                        AVTEditor.this.avtList.add(aVT);
                        AVTEditor.this.sortList();
                        AVTEditor.this.editorPane.updateUI();
                        AVTEditor.this.tfBeginValue.setText("");
                        AVTEditor.this.tfBeginValue.requestFocus();
                        AVTEditor.this.tfEndValue.setText("");
                        AVTEditor.this.tfDesc.setText("");
                        AVTEditor.this.editorPane.removeRowSelectionInterval(0, AVTEditor.this.avtList.size() - 1);
                        AVTEditor.this.bnRemoveAVT.setEnabled(false);
                        AVTEditor.this.bnModifyAVT.setEnabled(false);
                    }
                }
            });
            this.bnAddAVT.addKeyListener(this.escKey);
            jPanel7.add(this.bnAddAVT);
            jPanel7.add(this.bnModifyAVT);
            jPanel7.add(this.bnRemoveAVT);
            jPanel7.add(new JPanel());
            this.rbAsc = new JRadioButton(Messages.getString("AVTEditor.Ascending"));
            this.rbAsc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AVTEditor.this.sortList();
                    AVTEditor.this.editorPane.updateUI();
                }
            });
            this.rbAsc.addKeyListener(this.escKey);
            this.rbDesc = new JRadioButton(Messages.getString("AVTEditor.Descending"));
            this.rbDesc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AVTEditor.this.sortList();
                    AVTEditor.this.editorPane.updateUI();
                }
            });
            this.rbDesc.addKeyListener(this.escKey);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbAsc);
            buttonGroup.add(this.rbDesc);
            JPanel jPanel8 = new JPanel(new GridLayout(0, 1));
            jPanel8.setBorder(BorderFactory.createTitledBorder(Messages.getString("AVTEditor.SortOrder")));
            jPanel8.add(this.rbAsc);
            jPanel8.add(this.rbDesc);
            JPanel jPanel9 = new JPanel(new BorderLayout());
            jPanel9.add((Component)jPanel7, "North");
            jPanel9.add((Component)jPanel8, "Center");
            jPanel6.add((Component)jPanel9, "North");
            this.mainPanel.add((Component)jPanel6, "East");
        }
        return this.mainPanel;
    }

    protected JTable getEditorPane() {
        if (this.editorPane == null) {
            this.avtList = new ArrayList();
            this.editorPane = new JTable(new AVTTableModel());
            this.editorPane.setSelectionMode(0);
            ListSelectionModel listSelectionModel = this.editorPane.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!AVTEditor.this.readOnly) {
                        try {
                            AVTEditor.this.bnRemoveAVT.setEnabled(true);
                            AVTEditor.this.bnModifyAVT.setEnabled(true);
                            int n = AVTEditor.this.editorPane.getSelectedRow();
                            if (n > -1 && AVTEditor.this.avtList.size() > 0) {
                                AVT aVT = (AVT)AVTEditor.this.avtList.get(n);
                                AVTEditor.this.tfBeginValue.setText(aVT.getBeginValue());
                                AVTEditor.this.tfEndValue.setText(aVT.getEndValue());
                                AVTEditor.this.tfDesc.setText(aVT.getDescription());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.editorPane.addKeyListener(this.escKey);
        }
        return this.editorPane;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            Object object;
            this.buttonPanel = new JPanel();
            if (!this.readOnly) {
                object = new JButton(Messages.getString("AVTEditor.OK"));
                ((AbstractButton)object).setMnemonic(79);
                ((JComponent)object).setPreferredSize(MessageDialogs.BUTTON_SIZE);
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        AVTEditor.this.setProperties();
                        AVTEditor.this.getDialog().setVisible(false);
                    }
                });
                this.buttonPanel.add((Component)object);
            }
            object = this.readOnly ? Messages.getString("AVTEditor.Close") : Messages.getString("AVTEditor.Cancel");
            this.bnCancel = new JButton((String)object);
            this.bnCancel.setMnemonic(67);
            this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.bnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AVTEditor.this.getDialog().setVisible(false);
                }
            });
            this.buttonPanel.add(this.bnCancel);
        }
        return this.buttonPanel;
    }

    private void setProperties() {
        this.object.clearAVTs();
        if (this.object instanceof Column) {
            ((Column)this.object).setUseDomainConstraints(false);
        }
        for (AVT aVT : this.avtList) {
            AVT aVT2 = new AVT();
            aVT.copyTo(aVT2);
            this.object.addAVT(aVT2);
        }
        if (this.rbAsc.isSelected()) {
            this.object.setAVTSortOrder(0);
        } else {
            this.object.setAVTSortOrder(1);
        }
    }

    private boolean canAdd() {
        if ("".equalsIgnoreCase(this.tfBeginValue.getText())) {
            MessageDialogs.showWarningMessage(Messages.getString("AVTEditor.BeginValueCanNotBeEmpty"));
            return false;
        }
        if (this.isNumber()) {
            String string = this.tfBeginValue.getText();
            try {
                Double.parseDouble(string);
            }
            catch (Exception exception) {
                MessageDialogs.showWarningMessage(MessageFormat.format(Messages.getString("AVTEditor.BeginValueCanNotBeConverted"), this.logicalDataType.toString()));
                return false;
            }
            String string2 = this.tfEndValue.getText();
            try {
                Double.parseDouble(string2);
            }
            catch (Exception exception) {
                MessageDialogs.showWarningMessage(MessageFormat.format(Messages.getString("AVTEditor.EndValueCanNotBeConverted"), this.logicalDataType.toString()));
                return false;
            }
        }
        return true;
    }

    private String getNativeDataType() {
        int n;
        Map map = this.logicalDataType.getToPhysical();
        String string = (String)map.get(StorageDesignDB2v70.RDBMS_TYPE.getTypeName());
        if (string == null) {
            string = this.logicalDataType.toString();
        }
        if ((n = string.indexOf(44)) > -1) {
            string = string.substring(0, n).trim();
        }
        return string;
    }

    private boolean isNumber() {
        String string = this.getNativeDataType();
        for (int i = 0; i < TYPES_NUMBER.length; ++i) {
            if (!TYPES_NUMBER[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void sortList() {
        if (this.isNumber()) {
            Collections.sort(this.avtList, new AVTNumberComparator(this.rbAsc.isSelected()));
        } else {
            Collections.sort(this.avtList, new AVTStringComparator(this.rbAsc.isSelected()));
        }
    }

    private class AVTNumberComparator
    implements Comparator {
        boolean asc;

        public AVTNumberComparator(boolean bl) {
            this.asc = bl;
        }

        public int compare(Object object, Object object2) {
            double d;
            double d2;
            String string = ((AVT)object).getBeginValue();
            String string2 = ((AVT)object2).getBeginValue();
            try {
                d2 = Double.parseDouble(string);
            }
            catch (Exception exception) {
                d2 = 0.0;
            }
            try {
                d = Double.parseDouble(string2);
            }
            catch (Exception exception) {
                d = 0.0;
            }
            if (d2 > d) {
                if (this.asc) {
                    return 1;
                }
                return -1;
            }
            if (d > d2) {
                if (this.asc) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    private class AVTStringComparator
    implements Comparator {
        boolean asc;

        public AVTStringComparator(boolean bl) {
            this.asc = bl;
        }

        public int compare(Object object, Object object2) {
            if (this.asc) {
                return ((AVT)object).getBeginValue().compareTo(((AVT)object2).getBeginValue());
            }
            return ((AVT)object2).getBeginValue().compareTo(((AVT)object).getBeginValue());
        }
    }

    class AVTTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("AVTEditor.BeginValue"), Messages.getString("AVTEditor.EndValue"), Messages.getString("AVTEditor.Description")};

        AVTTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return AVTEditor.this.avtList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.COL_NAMES[n];
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AVT aVT = (AVT)AVTEditor.this.avtList.get(n);
            if (n2 == 0) {
                return aVT.getBeginValue();
            }
            if (n2 == 1) {
                return aVT.getEndValue();
            }
            if (n2 == 2) {
                return aVT.getDescription();
            }
            return new Integer(n * n2);
        }
    }
}

