/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.ide.Ide;

public abstract class TVConnector
extends TopView {
    public static final int SITE_SOURCE = 0;
    public static final int SITE_CENTER = 1;
    public static final int SITE_TARGET = 2;
    public static boolean updateSettings = false;
    protected List edgePoints = new ArrayList();
    protected DefaultEdge edge;
    protected Rectangle labelBounds;
    protected Rectangle sourceLabelBounds = new Rectangle(-1, -1, -1, -1);
    protected Rectangle targetLabelBounds;
    public boolean wait = false;
    private Label sourceLabel = null;
    private Label centerLabel = null;
    private Label targetLabel = null;
    private Label tempSourceLabel;
    private Label tempCenterLabel;
    private Label tempTargetLabel;

    public TVConnector(ApplicationView applicationView, DesignPartView designPartView) {
        super(applicationView, designPartView);
        this.labelBounds = new Rectangle(-1, -1, -1, -1);
        this.targetLabelBounds = new Rectangle(-1, -1, -1, -1);
    }

    public List getEdgePoints() {
        return this.edgePoints;
    }

    public List getEdgeViewPoints() {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        if (this.getEdge() != null) {
            EdgeView edgeView = (EdgeView)this.getEdge().getCellView();
            int n = edgeView.getPoints().size();
            for (int i = 0; i < n; ++i) {
                Point2D point2D = edgeView.getPoint(i);
                arrayList.add(point2D);
            }
        }
        return arrayList;
    }

    public DefaultEdge getEdge() {
        return this.edge;
    }

    public boolean remove(DesignObject designObject) {
        if (this.canRemove()) {
            int n = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TVConnector.HasMoreThan1GraphicalRepresentation"), this.getModel().getName()), Messages.getString("TVConnector.WhatWouldYouLikeToDo"), 1, 3, null, new String[]{Messages.getString("TVConnector.RemoveObject"), Messages.getString("TVConnector.RemoveView"), Messages.getString("TVConnector.Cancel")}, Messages.getString("TVConnector.RemoveView"));
            if (n == 0) {
                this.getModel().getDesignPart().postUndoableRemoveEditForObject(this.getModel());
                designObject.remove();
                return true;
            }
            if (n == 1) {
                DesignPartView designPartView = this.getDesignPartView();
                designPartView.unregisterFromTreemodel(this);
                if (this.getCellView() != null) {
                    Object[] objectArray = new Object[]{this.getCellView().getCell()};
                    this.getDesignPartView().getWorkSpace().removeCells(objectArray);
                    this.getDesignPartView().setDirty(true);
                }
                this.doPrivateActions();
                this.getDesignPartView().removeView(this);
                this.getDesignPartView().getWorkSpace().repaint();
                return true;
            }
        } else {
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TVConnector.SureYouWantToDelete"), this.getModel().getName()), Messages.getString("TVConnector.ConfirmObjectDelete"), 0);
            if (n == 0) {
                this.getModel().getDesignPart().postUndoableRemoveEditForObject(this.getModel());
                designObject.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canRemove() {
        DesignPartView designPartView = this.getDesignPartView();
        int n = this.getModel().getViewsCountForDPV(designPartView);
        if (n > 1) {
            return true;
        }
        DesignPartView designPartView2 = designPartView.getMasterDPV();
        if (designPartView2 == null) {
            designPartView2 = designPartView;
        }
        return designPartView2 != this.getModel().getDesignPart().getMainView();
    }

    protected void doPrivateActions() {
    }

    public void removeConnection() {
        this.getDesignPartView().getWorkSpace().removeConnection(this.getModel());
        this.edge = null;
        this.setCellView(null);
    }

    public void clearLabels() {
        this.removeLabel(0);
        this.removeLabel(1);
        this.removeLabel(2);
    }

    public Rectangle getLabelBounds() {
        return this.labelBounds;
    }

    public void setLabelBounds(Rectangle rectangle) {
        this.labelBounds = rectangle;
    }

    public Rectangle getSourceLabelBounds() {
        return this.sourceLabelBounds;
    }

    public void setSourceLabelBounds(Rectangle rectangle) {
        this.sourceLabelBounds = rectangle;
    }

    public Rectangle getTargetLabelBounds() {
        return this.targetLabelBounds;
    }

    public void setTargetLabelBounds(Rectangle rectangle) {
        this.targetLabelBounds = rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLabelPos(Point2D point2D, Point2D point2D2, Rectangle2D rectangle2D, int n) {
        Label label;
        if (!this.wait && point2D != null && (label = this.getLabel(n)) != null) {
            Object object;
            double d;
            double d2;
            Point2D point2D3 = label.getLastPos();
            if (n == 0) {
                d2 = this.getSourceLabelBounds().getX();
                d = this.getSourceLabelBounds().getY();
            } else if (n == 2) {
                d2 = this.getTargetLabelBounds().getX();
                d = this.getTargetLabelBounds().getY();
            } else {
                d2 = this.getLabelBounds().getX();
                d = this.getLabelBounds().getY();
            }
            if ((d2 < 0.0 || d < 0.0) && (object = this.getDefaultLabelPosition(this.getEdgeView(), n)) != null) {
                d2 = ((Point2D)object).getX();
                d = ((Point2D)object).getY();
            }
            if ((object = label.getFirstViewForDPV(this.dpv)) != null && ((TopView)object).getCellView() != null) {
                this.wait = true;
                try {
                    Rectangle2D rectangle2D2 = ((TopView)object).getCellView().getBounds();
                    Point2D.Double double_ = new Point2D.Double(d2 + (point2D.getX() - point2D3.getX()), d + (point2D.getY() - point2D3.getY()));
                    double d3 = this.getMiddle(point2D.getX(), point2D2.getX(), 2);
                    double d4 = this.getMiddle(point2D.getY(), point2D2.getY(), 2);
                    ((Point2D)double_).setLocation(d3, d4);
                    ((TopView)object).getCellView().setNewBounds(new Rectangle(new Point((int)d3, (int)d4), new Dimension((int)rectangle2D2.getWidth(), (int)rectangle2D2.getHeight())), false);
                    label.setLastPos(point2D);
                }
                finally {
                    this.wait = false;
                }
            }
        }
    }

    private double getMiddle(double d, double d2, int n) {
        double d3 = d2;
        for (int i = 0; i < n; ++i) {
            d3 = (d + d3) / 2.0;
        }
        return d3;
    }

    public Point2D getDefaultLabelPosition(EdgeView edgeView, int n) {
        if (1 != n) {
            try {
                Point2D point2D;
                Point2D point2D2;
                edgeView.getEdgeRenderer().setView(edgeView);
                Rectangle2D rectangle2D = null;
                if (edgeView.getShape() != null) {
                    rectangle2D = edgeView.getShape().getBounds2D();
                }
                int n2 = 1;
                if (n == 0) {
                    point2D2 = edgeView.getPoint(0);
                    point2D = edgeView.getPoint(edgeView.getPointCount() - 1);
                } else {
                    point2D2 = edgeView.getPoint(edgeView.getPointCount() - 1);
                    point2D = edgeView.getPoint(0);
                }
                if (rectangle2D != null) {
                    double d = rectangle2D.getX() + (double)n2;
                    int n3 = n2 - 40;
                    if (point2D2.getX() > point2D.getX()) {
                        d += rectangle2D.getWidth();
                        n3 = -n2;
                    }
                    double d2 = rectangle2D.getY();
                    int n4 = 30;
                    if (point2D2.getY() > point2D.getY()) {
                        d2 += rectangle2D.getHeight();
                        n4 = -20;
                    }
                    double d3 = d + (double)n3;
                    double d4 = d2 + (double)n4;
                    return DiagramConstants.createPoint(d3, d4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Point2D getCenterPoint(EdgeView edgeView) {
        Point2D.Double double_ = new Point2D.Double();
        edgeView.getEdgeRenderer().setView(edgeView);
        Point2D point2D = edgeView.getPoint(0);
        Point2D point2D2 = edgeView.getPoint(edgeView.getPointCount() - 1);
        double d = point2D.getX() <= point2D2.getX() ? point2D2.getX() - point2D.getX() : point2D.getX() - point2D2.getX();
        double d2 = point2D.getY() <= point2D2.getY() ? point2D2.getY() - point2D.getY() : point2D.getY() - point2D2.getY();
        ((Point2D)double_).setLocation(d, d2);
        return double_;
    }

    public Point2D getCenterLabelPosition(EdgeView edgeView) {
        edgeView.getEdgeRenderer().setView(edgeView);
        Rectangle2D rectangle2D = null;
        if (edgeView.getShape() != null) {
            rectangle2D = edgeView.getShape().getBounds2D();
        }
        int n = 1000;
        Point2D.Double double_ = new Point2D.Double(500.0, 500.0);
        Point2D point2D = edgeView.getPoint(0);
        Point2D point2D2 = edgeView.getPoint(edgeView.getPointCount() - 1);
        if (double_ != null && rectangle2D != null) {
            double d = rectangle2D.getX();
            int n2 = 1;
            if (point2D.getX() > point2D2.getX()) {
                d += rectangle2D.getWidth();
                n2 = -1;
            }
            double d2 = rectangle2D.getY();
            int n3 = 1;
            if (point2D.getY() > point2D2.getY()) {
                d2 += rectangle2D.getHeight();
                n3 = -1;
            }
            double d3 = d + (double)n2 * (rectangle2D.getWidth() * ((Point2D)double_).getX() / (double)n);
            double d4 = d2 + (double)n3 * (rectangle2D.getHeight() * ((Point2D)double_).getY() / (double)n);
            return new Point2D.Double(d3, d4);
        }
        return null;
    }

    public void removeLabel(int n) {
        Label label = this.getLabel(n);
        if (label != null) {
            this.getDesignPartView().getWorkSpace().removeLabel(label);
            label.remove();
            switch (n) {
                case 0: {
                    this.sourceLabel = null;
                    break;
                }
                case 1: {
                    this.centerLabel = null;
                    break;
                }
                case 2: {
                    this.targetLabel = null;
                }
            }
        }
    }

    public Label getLabel(int n) {
        switch (n) {
            case 0: {
                return this.sourceLabel;
            }
            case 1: {
                return this.centerLabel;
            }
            case 2: {
                return this.targetLabel;
            }
        }
        return null;
    }

    public Label getCenterLabel() {
        return this.getLabel(1);
    }

    public Label getSourceLabel() {
        return this.getLabel(0);
    }

    public Label getTargetLabel() {
        return this.getLabel(2);
    }

    public void clearCenterLabel() {
        this.centerLabel = null;
    }

    public void clearSourceLabel() {
        this.sourceLabel = null;
    }

    public void clearTargetLabel() {
        this.targetLabel = null;
    }

    private Label getOrCreateLabel(int n, Rectangle rectangle, String string) {
        Label label = this.getLabel(n);
        if (label == null) {
            Serializable serializable;
            Serializable serializable2;
            Point2D.Double double_;
            label = this.getDesignPartView().getDesignPart().createLabel();
            label.setTVConnector(this);
            label.setSite(n);
            TopView topView = label.getFirstViewForDPV(this.getDesignPartView());
            if (topView == null) {
                topView = this.getDesignPartView().createTopViewFor(label);
            }
            if (((Point2D)(double_ = new Point2D.Double(rectangle.getX(), rectangle.getY()))).getX() == -1.0 && ((Point2D)double_).getY() == -1.0) {
                Point2D point2D = this.getDefaultLabelPosition(this.getEdgeView(), n);
                if (point2D == null) {
                    double_.setLocation(new Point2D.Double(rectangle.getX(), rectangle.getY()));
                } else {
                    double_.setLocation(point2D);
                }
            }
            int n2 = (int)rectangle.getWidth();
            int n3 = (int)rectangle.getHeight();
            DefaultFontAndColor defaultFontAndColor = label.getDesign().getAppView().getSettings().getDefaultFCObject("Label");
            if (defaultFontAndColor != null) {
                serializable2 = defaultFontAndColor.getFontObject(EditableFonts.FO_TEXT).getFont();
                serializable = this.getEdgeView().getDiagram().getFontMetrics((Font)serializable2);
                if (n2 == -1) {
                    n2 = ((FontMetrics)serializable).stringWidth(string) + 10;
                }
                if (n3 == -1) {
                    n3 = ((Font)serializable2).getSize() * 2;
                }
            }
            serializable2 = 1 == n ? (rectangle.getX() < 0.0 || rectangle.getY() < 0.0 || rectangle.getWidth() < 0.0 || rectangle.getHeight() < 0.0 ? new Rectangle((int)((Point2D)double_).getX() - n2 / 2, (int)((Point2D)double_).getY() - n3 / 2, n2, n3) : new Rectangle(rectangle)) : new Rectangle((int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), n2, n3);
            serializable = this.getDesignPartView().getWorkSpace().addLabel(label, (Rectangle)serializable2);
            if (serializable != null) {
                ((DefaultDiagramCell)serializable).setTopView(topView);
                topView.setCellView(((DefaultDiagramCell)serializable).getCellView());
            }
            switch (n) {
                case 0: {
                    this.sourceLabel = label;
                    this.sourceLabelBounds = serializable2;
                    this.readProps(this.sourceLabel, this.tempSourceLabel);
                    break;
                }
                case 1: {
                    this.centerLabel = label;
                    this.labelBounds = serializable2;
                    this.readProps(this.centerLabel, this.tempCenterLabel);
                    break;
                }
                case 2: {
                    this.targetLabel = label;
                    this.targetLabelBounds = serializable2;
                    this.readProps(this.targetLabel, this.tempTargetLabel);
                }
            }
        }
        return label;
    }

    private void readProps(Label label, Label label2) {
        if (label2 != null) {
            label.setUseDefaultColor(label2.useDefaultColor());
            label.setBackgroundColor(label2.getBackgroundColor());
            label.setForegroundColor(label2.getForegroundColor());
            label.getEditableFonts().clear();
            for (FontObject fontObject : label2.getEditableFonts()) {
                label.getEditableFonts().add(fontObject.copy());
            }
            label2.remove();
        }
    }

    protected void displayLabel(String string, Rectangle rectangle, int n) {
        Label label = this.getOrCreateLabel(n, rectangle, string);
        if (label != null) {
            AbstractCellView abstractCellView;
            label.setText(string);
            TopView topView = label.getFirstViewForDPV(this.getDesignPartView());
            if (topView != null && (abstractCellView = topView.getCellView()) != null && rectangle.getX() != -1.0 && rectangle.getY() != -1.0) {
                Rectangle2D rectangle2D = abstractCellView.getBounds();
                rectangle2D.setFrame(rectangle.getX(), rectangle.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                topView.getCellView().setNewBounds(rectangle2D.getBounds(), false);
            }
        }
    }

    public EdgeView getEdgeView() {
        return (EdgeView)this.getCellView();
    }

    public void displayLabels() {
    }

    @Override
    public SelectableObject getSelectableObject() {
        return null;
    }

    public void connectLabels() {
        Label label = this.getLabel(0);
        if (label != null) {
            label.setConnectorSelected(true);
        }
        if ((label = this.getLabel(1)) != null) {
            label.setConnectorSelected(true);
        }
        if ((label = this.getLabel(2)) != null) {
            label.setConnectorSelected(true);
        }
    }

    public void disconnectLabels() {
        Label label = this.getLabel(0);
        if (label != null) {
            label.setConnectorSelected(false);
        }
        if ((label = this.getLabel(1)) != null) {
            label.setConnectorSelected(false);
        }
        if ((label = this.getLabel(2)) != null) {
            label.setConnectorSelected(false);
        }
    }

    public Label getTempCenterLabel() {
        if (this.tempCenterLabel == null) {
            this.tempCenterLabel = this.getDesignPartView().getDesignPart().createLabel();
            this.tempCenterLabel.setTVConnector(this);
        }
        return this.tempCenterLabel;
    }

    public Label getTempSourceLabel() {
        if (this.tempSourceLabel == null) {
            this.tempSourceLabel = this.getDesignPartView().getDesignPart().createLabel();
            this.tempSourceLabel.setTVConnector(this);
        }
        return this.tempSourceLabel;
    }

    public Label getTempTargetLabel() {
        if (this.tempTargetLabel == null) {
            this.tempTargetLabel = this.getDesignPartView().getDesignPart().createLabel();
            this.tempTargetLabel.setTVConnector(this);
        }
        return this.tempTargetLabel;
    }

    @Override
    public void setCellView(AbstractCellView abstractCellView) {
        super.setCellView(abstractCellView);
        this.edge = abstractCellView != null && abstractCellView.getCell() instanceof DefaultEdge ? (DefaultEdge)abstractCellView.getCell() : null;
    }

    public TopView getSourceTopView() {
        return ((ConnectionInterface)((Object)this.getModel())).getSourceTopView(this.getDesignPartView());
    }

    public TopView getTargetTopView() {
        return ((ConnectionInterface)((Object)this.getModel())).getTargetTopView(this.getDesignPartView());
    }

    public List getLabels() {
        ArrayList<Label> arrayList = new ArrayList<Label>();
        if (this.sourceLabel != null) {
            arrayList.add(this.sourceLabel);
        }
        if (this.targetLabel != null) {
            arrayList.add(this.targetLabel);
        }
        if (this.centerLabel != null) {
            arrayList.add(this.centerLabel);
        }
        return arrayList;
    }

    public Rectangle getLabelBoundsFor(int n) {
        switch (n) {
            case 0: {
                return this.getSourceLabelBounds();
            }
            case 1: {
                return this.getLabelBounds();
            }
            case 2: {
                return this.getTargetLabelBounds();
            }
        }
        return new Rectangle(-1, -1, -1, -1);
    }

    public void setLabelBoundsFor(Rectangle rectangle, int n) {
        switch (n) {
            case 0: {
                this.setSourceLabelBounds(rectangle);
                break;
            }
            case 1: {
                this.setLabelBounds(rectangle);
                break;
            }
            case 2: {
                this.setTargetLabelBounds(rectangle);
            }
        }
    }

    public void setLabel(Label label, int n) {
        switch (n) {
            case 0: {
                this.sourceLabel = label;
                break;
            }
            case 1: {
                this.centerLabel = label;
                break;
            }
            case 2: {
                this.targetLabel = label;
            }
        }
    }

    public List getActualPoints() {
        ArrayList<Point2D> arrayList = null;
        if (this.getEdge() != null && this.getEdge().getCellView() != null) {
            List list = ((EdgeView)this.getEdge().getCellView()).getPoints();
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(point2D);
            }
        } else {
            List list = this.getEdgePoints();
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                Point2D point2D = e instanceof PortView ? ((PortView)e).getPoint() : (Point2D)e;
                if (arrayList == null) {
                    arrayList = new ArrayList<Point2D>();
                }
                arrayList.add(point2D);
            }
        }
        if (arrayList == null) {
            return Collections.EMPTY_LIST;
        }
        return arrayList;
    }

    public void applyEdgePointsToCellView() {
        if (this.getEdge() != null && this.getEdge().getCellView() != null) {
            Hashtable hashtable = new Hashtable();
            DiagramConstants.setPoints(hashtable, this.edgePoints);
            this.getEdge().changeAttributes(hashtable);
            this.getEdge().getCellView().update();
        }
    }

    public Rectangle getLineBounds() {
        List list = this.getActualPoints();
        if (list.size() > 0) {
            Point2D point2D = (Point2D)list.get(0);
            Rectangle rectangle = new Rectangle((int)point2D.getX(), (int)point2D.getY());
            for (int i = 1; i < list.size(); ++i) {
                point2D = (Point2D)list.get(i);
                Rectangle rectangle2 = new Rectangle((int)point2D.getX(), (int)point2D.getY());
                rectangle.union(rectangle2);
            }
            return rectangle;
        }
        return null;
    }

    public void resetEdgeParams() {
    }
}

