/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectedObjectChangeListener;
import oracle.dbtools.crest.swingui.SelectionSource;

public class SelectionSourceImpl
implements SelectionSource {
    private SelectableObject currentSelection = null;
    private Set selectionChangeListeners = new HashSet();

    @Override
    public void setCurrentSelection(SelectableObject selectableObject) {
        this.currentSelection = selectableObject;
        this.fireSelectionChanged();
    }

    @Override
    public SelectableObject getCurrentSelection() {
        return this.currentSelection;
    }

    @Override
    public void addSelectedObjectChangeListener(SelectedObjectChangeListener selectedObjectChangeListener) {
        this.selectionChangeListeners.add(selectedObjectChangeListener);
    }

    @Override
    public void removeSelectedObjectChangeListener(SelectedObjectChangeListener selectedObjectChangeListener) {
        this.selectionChangeListeners.remove(selectedObjectChangeListener);
    }

    @Override
    public void fireSelectionChanged() {
        this.fireSelectionChanged(this.getCurrentSelection());
    }

    @Override
    public void fireSelectionChanged(SelectableObject selectableObject) {
        Iterator iterator = this.selectionChangeListeners.iterator();
        while (iterator.hasNext()) {
            ((SelectedObjectChangeListener)iterator.next()).selectionChanged(selectableObject);
        }
    }
}

