/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class SelectNeighborsDialog
extends CustomDialog {
    private JDialog dialog;
    private JPanel general;
    private JPanel buttonPanel;
    private int zones = -1;
    private JCheckBox chbAll;
    private JIntegerField ifZones;
    private int type = 0;
    private boolean isRelational = false;
    private JComboBox cbType = null;

    public SelectNeighborsDialog(ApplicationView applicationView, boolean bl) {
        super(applicationView);
        this.isRelational = bl;
        this.initGeneral();
        this.add((Component)this.general, "Center");
        this.initButtonsPanel();
        this.add((Component)this.buttonPanel, "South");
    }

    public SelectNeighborsDialog(ApplicationView applicationView) {
        this(applicationView, false);
    }

    private void initGeneral() {
        JPanel jPanel;
        JComponent jComponent;
        this.general = new JPanel(new GridLayout(0, 1));
        this.general.setBorder(BorderFactory.createEtchedBorder());
        if (this.isRelational) {
            jComponent = new JLabel(Messages.getString("SelectNeighborsDialog.Direction"));
            this.cbType = new JComboBox<Object>(new Object[]{Messages.getString("SelectNeighborsDialog.All"), Messages.getString("SelectNeighborsDialog.Parent"), Messages.getString("SelectNeighborsDialog.Child")});
            jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(jComponent);
            jPanel.add(this.cbType);
            this.general.add(jPanel);
        }
        this.chbAll = new JCheckBox(Messages.getString("SelectNeighborsDialog.AllZones"));
        jComponent = new JPanel(new FlowLayout(0));
        jComponent.add(this.chbAll);
        this.general.add(jComponent);
        jPanel = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(Messages.getString("SelectNeighborsDialog.NumberOfZones"));
        this.ifZones = new JIntegerField(1, 5);
        jPanel.add(jLabel);
        jPanel.add(this.ifZones);
        this.general.add(jPanel);
    }

    protected void initButtonsPanel() {
        this.buttonPanel = new JPanel();
        JButton jButton = new JButton(Messages.getString("SelectNeighborsDialog.OK"));
        jButton.setMnemonic(79);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SelectNeighborsDialog.this.chbAll.isSelected()) {
                    SelectNeighborsDialog.this.zones = 0;
                } else {
                    SelectNeighborsDialog.this.zones = SelectNeighborsDialog.this.ifZones.getIntValue();
                }
                if (SelectNeighborsDialog.this.cbType != null) {
                    SelectNeighborsDialog.this.type = SelectNeighborsDialog.this.cbType.getSelectedIndex();
                }
                SelectNeighborsDialog.this.close();
            }
        });
        JButton jButton2 = new JButton(Messages.getString("SelectNeighborsDialog.Cancel"));
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectNeighborsDialog.this.zones = -1;
                SelectNeighborsDialog.this.close();
            }
        });
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonPanel.add(jButton);
        this.buttonPanel.add(jButton2);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectNeighborsDialog.SelectNeighbors"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.ifZones.requestFocus();
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    public int getZones() {
        return this.zones;
    }

    public int getType() {
        return this.type;
    }
}

