/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;

public class ProgressDialog {
    private ProgressDialog root;
    private JWindow dialog;
    private ProgressOptionPane pane;
    private JProgressBar myBar;
    private JLabel noteLabel;
    private Component parentComponent;
    private String note;
    private long to;
    private int millisToDecideToPopup = 0;
    private int millisToPopup = 0;
    private int min;
    private int max;
    private int lastDisp;
    private int reportDelta;
    private ApplicationView view;
    private boolean indeterminateMode = false;
    private static final Logger LOGGER = new Logger(ProgressDialog.class);

    public ProgressDialog(ApplicationView applicationView, String string, int n, int n2) {
        this(applicationView, string, n, n2, false);
    }

    public ProgressDialog(ApplicationView applicationView, String string, int n, int n2, boolean bl) {
        this(applicationView.getFrame(), string, n, n2, null);
        this.view = applicationView;
        this.indeterminateMode = bl;
    }

    private ProgressDialog(Component component, String string, int n, int n2, ProgressDialog progressDialog) {
        this.min = n;
        this.max = n2;
        this.parentComponent = component;
        this.reportDelta = (n2 - n) / 100;
        if (this.reportDelta < 1) {
            this.reportDelta = 1;
        }
        this.note = string;
        if (progressDialog != null) {
            this.root = progressDialog.root != null ? progressDialog.root : progressDialog;
            this.to = this.root.to;
            this.dialog = this.root.dialog;
        } else {
            this.to = System.currentTimeMillis();
        }
    }

    public void increaseProgress(int n) {
        this.setProgress(this.lastDisp + n);
    }

    public void setProgress(int n) {
        try {
            if (n < this.max && n >= this.lastDisp + this.reportDelta) {
                this.lastDisp = n;
                if (this.myBar != null) {
                    this.myBar.setValue(n);
                } else {
                    int n2;
                    long l = System.currentTimeMillis();
                    long l2 = (int)(l - this.to);
                    if (l2 >= (long)this.millisToDecideToPopup && (n2 = n > this.min ? (int)(l2 * (long)(this.max - this.min) / (long)(n - this.min)) : this.millisToPopup) >= this.millisToPopup) {
                        this.myBar = new JProgressBar();
                        this.myBar.setPreferredSize(new Dimension(250, 18));
                        this.myBar.setMinimum(this.min);
                        this.myBar.setForeground(new Color(64, 140, 245));
                        this.myBar.setMaximum(this.max);
                        this.myBar.setValue(n);
                        this.myBar.setIndeterminate(this.indeterminateMode);
                        if (this.note != null) {
                            this.noteLabel = new JLabel(this.note);
                            this.noteLabel.setHorizontalAlignment(0);
                            this.noteLabel.setVerticalAlignment(0);
                        }
                        this.pane = new ProgressOptionPane(this.noteLabel, this.myBar);
                        this.dialog = this.pane.createDialog(this.parentComponent);
                        this.dialog.setVisible(true);
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error updating ProgressMonitor!", exception);
        }
    }

    public void close() {
        try {
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                this.dialog.dispose();
                this.dialog = null;
                this.pane = null;
                this.myBar = null;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error closing ProgressMonitor!", exception);
        }
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int n) {
        this.min = n;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int n) {
        this.max = n;
    }

    public void setMillisToDecideToPopup(int n) {
        this.millisToDecideToPopup = n;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public void setMillisToPopup(int n) {
        this.millisToPopup = n;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setNote(String string) {
        this.note = string;
        if (this.noteLabel != null) {
            this.noteLabel.setText(string);
        }
    }

    public String getNote() {
        return this.note;
    }

    public void setParentComponent(Component component) {
        this.parentComponent = component;
    }

    public JWindow getDialog() {
        return this.dialog;
    }

    private class ProgressOptionPane {
        private JLabel label;
        private JProgressBar bar;
        private Icon icon;

        ProgressOptionPane(JLabel jLabel, JProgressBar jProgressBar) {
            this.icon = ProgressDialog.this.view.getConfiguration().getIcon("PROGRESS_ICON");
            this.label = jLabel;
            this.bar = jProgressBar;
        }

        public JWindow createDialog(Component component) {
            Frame frame = JOptionPane.getFrameForComponent(component);
            JWindow jWindow = new JWindow(frame);
            Container container = jWindow.getContentPane();
            container.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createBevelBorder(0));
            JPanel jPanel2 = new JPanel();
            jPanel2.add(new JLabel(this.icon));
            jPanel.add((Component)jPanel2, "Center");
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.add(this.label);
            jPanel3.add(jPanel4);
            JPanel jPanel5 = new JPanel();
            jPanel5.add(this.bar);
            jPanel3.add(jPanel5);
            jPanel.add((Component)jPanel3, "After");
            container.add((Component)jPanel, "Center");
            jWindow.pack();
            jWindow.setLocationRelativeTo(component);
            return jWindow;
        }
    }
}

