/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class MenuPath {
    public static final Object[] MENUPATH_ARRAY = new MenuPath[0];
    private String name;
    private int level;
    private Map children = new TreeMap();
    private MenuPath parent;
    private int mnemonic;

    private MenuPath(String string, int n, MenuPath menuPath) {
        int n2;
        this.name = string;
        this.level = n;
        this.parent = menuPath;
        if (string != null && (n2 = string.indexOf(38)) > -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.deleteCharAt(n2);
            this.mnemonic = stringBuffer.toString().charAt(n2);
        }
    }

    protected void addChild(String[] stringArray) {
        String string = stringArray[this.level + 1];
        this.children.put(string, new MenuPath(string, this.level + 1, this));
    }

    protected boolean isInPath(String[] stringArray) {
        return stringArray[this.level].equals(this.name);
    }

    protected MenuPath getOrCreateChild(String[] stringArray) {
        if (!this.children.containsKey(stringArray[this.level + 1])) {
            this.addChild(stringArray);
        }
        return (MenuPath)this.children.get(stringArray[this.level + 1]);
    }

    public MenuPath[] getChildren() {
        return (MenuPath[])this.children.values().toArray(MENUPATH_ARRAY);
    }

    protected Iterator childIterator() {
        return this.children.values().iterator();
    }

    public String getLastNodeName() {
        int n = this.name.indexOf(38);
        if (n > -1) {
            StringBuffer stringBuffer = new StringBuffer(this.name);
            stringBuffer.deleteCharAt(n);
            return stringBuffer.toString();
        }
        return this.name;
    }

    public MenuPath getLastNodeIn(String[] stringArray) {
        if (this.isInPath(stringArray)) {
            if (stringArray.length - 1 == this.level) {
                return this;
            }
            return this.getOrCreateChild(stringArray).getLastNodeIn(stringArray);
        }
        throw new RuntimeException("wrong path");
    }

    public MenuPath getFirstNodeIn(String[] stringArray) {
        return (MenuPath)this.children.get(stringArray[0]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendTo(stringBuffer);
        return stringBuffer.toString();
    }

    public MenuPath getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isRoot() {
        return false;
    }

    public void appendTo(StringBuffer stringBuffer) {
        Iterator iterator = this.children.values().iterator();
        stringBuffer.append('[');
        stringBuffer.append(this.name);
        stringBuffer.append(':');
        while (iterator.hasNext()) {
            ((MenuPath)iterator.next()).appendTo(stringBuffer);
        }
        stringBuffer.append(']');
    }

    public static MenuPath createRoot() {
        return new RootNode();
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    protected static class RootNode
    extends MenuPath {
        private RootNode() {
            super(null, -1, null);
        }

        protected boolean isInPath() {
            return true;
        }

        @Override
        public MenuPath getLastNodeIn(String[] stringArray) {
            return super.getOrCreateChild(stringArray).getLastNodeIn(stringArray);
        }

        @Override
        public void appendTo(StringBuffer stringBuffer) {
            Iterator iterator = this.childIterator();
            while (iterator.hasNext()) {
                ((MenuPath)iterator.next()).appendTo(stringBuffer);
            }
        }

        @Override
        public boolean isRoot() {
            return true;
        }
    }
}

