/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.StyledEditorKit;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class LogReport
extends CustomDialog {
    private JDialog dialog;
    private JEditorPane editor;
    private JPanel footerPanel;
    private JButton saveButton;
    private JButton closeButton;
    private String name = Messages.getString("LogReport.ViewLog");
    private static final Logger LOGGER;
    private static File lastFolder;

    public LogReport(ApplicationView applicationView) {
        super(applicationView);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.getEditorPane()), "Center");
        this.add((Component)this.getFooterPanel(), "South");
    }

    protected JEditorPane getEditorPane() {
        if (this.editor == null) {
            this.editor = new JEditorPane();
            this.editor.setEditorKit(new StyledEditorKit());
        }
        return this.editor;
    }

    @Override
    protected void close() {
        this.dialog.dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.name);
            this.dialog.setContentPane(this);
            Dimension dimension = this.getApplicationView().getFrame().getSize();
            this.dialog.setSize(dimension.width - 20, dimension.height - 40);
            this.setDefaultActions(this.dialog, false);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().show();
    }

    public void showDialog(Dimension dimension) {
        this.getDialog().setSize(dimension);
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().show();
    }

    public void showModalDialog(Dimension dimension) {
        this.getDialog().setSize(dimension);
        ((JDialog)this.getDialog()).setModal(true);
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().show();
    }

    public JPanel getFooterPanel() {
        if (this.footerPanel == null) {
            this.footerPanel = new JPanel();
            this.footerPanel.add(this.getSaveButton());
            this.footerPanel.add(this.getCloseButton());
        }
        return this.footerPanel;
    }

    public JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton(Messages.getString("LogReport.Save"));
            this.saveButton.setMnemonic(83);
            this.saveButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogReport.this.saveLocalCopy();
                }
            });
            this.saveButton.setToolTipText(Messages.getString("LogReport.SaveLog"));
        }
        return this.saveButton;
    }

    public JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton(Messages.getString("LogReport.Close"));
            this.closeButton.setMnemonic(67);
            this.closeButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LogReport.this.close();
                }
            });
            this.closeButton.setToolTipText(Messages.getString("LogReport.Close"));
        }
        return this.closeButton;
    }

    public void setLog(String string) {
        this.getEditorPane().setText(string);
    }

    public void saveLocalCopy() {
        try {
            Serializable serializable;
            URLFilter uRLFilter = new URLFilter(){

                public boolean accept(URL uRL) {
                    File file = new File(uRL.getPath());
                    return file.getName().toLowerCase().endsWith(".log") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("LogReport.LogFiles");
                }
            };
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setSelectionScope(0);
            uRLChooser.setSelectionMode(0);
            uRLChooser.setShowJarsAsDirs(false);
            uRLChooser.setURLFilter(uRLFilter);
            if (lastFolder != null) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String string = this.getApplicationView().getSettings().getDefaultSavePath();
                if (string != null && string.length() > 0) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                } else {
                    serializable = this.getApplicationView().getUserHomeDirectory();
                    if (serializable != null) {
                        uRLChooser.setSelectedURL((URL)serializable);
                    }
                }
            }
            uRLChooser.setFileNameURL(this.getApplicationView().getDesignName() + ".log");
            int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("LogReport.SaveLog"));
            if (n == 0 && (serializable = new File(uRLChooser.getSelectedURL().getPath())) != null) {
                lastFolder = ((File)serializable).getParentFile();
                this.saveLocalCopy((File)serializable);
            }
            ApplicationView.log(Messages.getString("LogReport.SaveLogCanceled"));
        }
        catch (IOException iOException) {
            LOGGER.error("", iOException);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("LogReport.CanNotWriteToFile"), iOException.getMessage()}, Messages.getString("LogReport.WriteError"), 0);
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("LogReport.UnexpectedError"), throwable.getMessage()}, Messages.getString("LogReport.WriteError"), 0);
        }
    }

    protected void saveLocalCopy(File file) throws IOException {
        int n;
        if (file.exists() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("LogReport.FileExists"), file.getAbsolutePath()), Messages.getString("LogReport.Warning"), 0, 3, null)) == 1) {
            return;
        }
        String string = this.getEditorPane().getText();
        file.getParentFile().mkdirs();
        ApplicationView.log(MessageFormat.format(Messages.getString("LogReport.SavingLogFile"), file));
        file.createNewFile();
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));
        printWriter.print(string);
        printWriter.flush();
        printWriter.close();
    }

    @Override
    public void setName(String string) {
        this.name = string;
        ((JDialog)this.getDialog()).setTitle(string);
    }

    static {
        lastFolder = null;
        LOGGER = new Logger(LogReport.class);
    }
}

