/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;

public class GlassComponent
extends JComponent {
    private static final Point[] POINT_ARRAY_PROTO = new Point[0];
    private MultiplePointsAdapter multiPointListener = new MultiplePointsAdapter();
    private SinglePointAdapter singlePointListener = new SinglePointAdapter();
    private RectangleDragAdapter rectangleListener = new RectangleDragAdapter();
    private PredeterminedMultiplePointsAdapter predeterminedListener = new PredeterminedMultiplePointsAdapter();
    private StatusBarOwner statusBar = null;
    private List activeListeners = new ArrayList();

    public GlassComponent() {
        this.setVisible(false);
    }

    public void setStatusBarOwner(StatusBarOwner statusBarOwner) {
        this.statusBar = statusBarOwner;
    }

    public void getSinglePoint(PointsEnteredCallback pointsEnteredCallback) {
        this.singlePointListener.start(pointsEnteredCallback);
    }

    public void getPointsUntilDoubleClick(PointsEnteredCallback pointsEnteredCallback) {
        this.multiPointListener.start(pointsEnteredCallback);
    }

    public void getPoints(PointsEnteredCallback pointsEnteredCallback, int n) {
        this.predeterminedListener.setRequestedNumber(n);
        this.predeterminedListener.start(pointsEnteredCallback);
    }

    public void getRectangle(PointsEnteredCallback pointsEnteredCallback) {
        this.rectangleListener.start(pointsEnteredCallback);
    }

    protected void clearStatusMessage() {
        if (this.statusBar != null) {
            this.statusBar.clearStatusMessage();
        }
    }

    public void stopAll() {
        while (!this.activeListeners.isEmpty()) {
            GPMouseInputAdapter gPMouseInputAdapter = (GPMouseInputAdapter)this.activeListeners.remove(0);
            gPMouseInputAdapter.doStop();
        }
        this.setVisible(false);
    }

    class PredeterminedMultiplePointsAdapter
    extends MultiplePointsAdapter {
        Point sPoint;
        Point ePoint;
        boolean drawing;
        private int requestedNumber;

        PredeterminedMultiplePointsAdapter() {
            this.sPoint = new Point(-1, -1);
            this.ePoint = new Point(-1, -1);
            this.drawing = false;
            this.requestedNumber = 2;
        }

        public void setRequestedNumber(int n) {
            this.requestedNumber = n;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl = this.drawing = !this.drawing;
            if (this.drawing) {
                this.sPoint.setLocation(mouseEvent.getX(), mouseEvent.getY());
                this.ePoint.setLocation(mouseEvent.getX(), mouseEvent.getY());
            } else {
                Graphics graphics = GlassComponent.this.getGraphics();
                graphics.setXORMode(GlassComponent.this.getBackground());
                graphics.drawLine(this.sPoint.x, this.sPoint.y, this.ePoint.x, this.ePoint.y);
                graphics.dispose();
                GlassComponent.this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.drawing) {
                Graphics graphics = GlassComponent.this.getGraphics();
                graphics.setXORMode(GlassComponent.this.getBackground());
                graphics.drawLine(this.sPoint.x, this.sPoint.y, this.ePoint.x, this.ePoint.y);
                this.ePoint.setLocation(mouseEvent.getX(), mouseEvent.getY());
                graphics.drawLine(this.sPoint.x, this.sPoint.y, this.ePoint.x, this.ePoint.y);
                graphics.dispose();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.drawing && !this.sPoint.equals(this.ePoint)) {
                GlassComponent.this.repaint();
            }
            this.getPointsCollection().add(mouseEvent.getPoint());
            if (this.getPointsCollection().size() >= this.requestedNumber) {
                this.sPoint = new Point(-1, -1);
                this.ePoint = new Point(-1, -1);
                this.drawing = false;
                this.sendPoints();
            }
        }
    }

    class SinglePointAdapter
    extends GPMouseInputAdapter {
        private PointsEnteredCallback callback;

        SinglePointAdapter() {
            this.callback = null;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.callback.pointSelected(SwingUtilities.convertPoint(GlassComponent.this, mouseEvent.getPoint(), this.callback.getTargetCoordinateSpace()));
            this.stop();
        }

        @Override
        protected void doStart(PointsEnteredCallback pointsEnteredCallback) {
            this.callback = pointsEnteredCallback;
            GlassComponent.this.addMouseListener(this);
        }

        @Override
        protected void doStop() {
            GlassComponent.this.removeMouseListener(this);
        }
    }

    class MultiplePointsAdapter
    extends GPMouseInputAdapter {
        private PointsEnteredCallback callback;
        private List points;

        MultiplePointsAdapter() {
            this.callback = null;
            this.points = new ArrayList();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.getPointsCollection().add(mouseEvent.getPoint());
            if (mouseEvent.getClickCount() >= 2) {
                this.sendPoints();
            }
        }

        protected Collection getPointsCollection() {
            return this.points;
        }

        @Override
        protected void doStart(PointsEnteredCallback pointsEnteredCallback) {
            this.callback = pointsEnteredCallback;
            this.getPointsCollection().clear();
            GlassComponent.this.addMouseListener(this);
            GlassComponent.this.addMouseMotionListener(this);
        }

        protected void sendPoints() {
            this.stop();
            for (int i = 0; i < this.points.size(); ++i) {
                Point point = (Point)this.points.remove(i);
                point = SwingUtilities.convertPoint(GlassComponent.this, point, this.callback.getTargetCoordinateSpace());
                this.points.add(i, point);
            }
            if (this.points.size() == 1) {
                this.callback.pointSelected((Point)this.points.get(0));
            } else {
                this.callback.pointsSelected(this.points.toArray(POINT_ARRAY_PROTO));
            }
        }

        @Override
        protected void doStop() {
            GlassComponent.this.removeMouseListener(this);
            GlassComponent.this.removeMouseMotionListener(this);
        }
    }

    class RectangleDragAdapter
    extends GPMouseInputAdapter {
        private Point dragStart;
        private Point lastDragPoint;
        private PointsEnteredCallback callback;
        private List points;

        RectangleDragAdapter() {
            this.dragStart = null;
            this.lastDragPoint = null;
            this.callback = null;
            this.points = new ArrayList();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.dragStart == null) {
                this.dragStart = mouseEvent.getPoint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.lastDragPoint = mouseEvent.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.points.add(this.dragStart);
            if (this.lastDragPoint != null) {
                this.points.add(this.lastDragPoint);
                this.sendRectangle();
                this.stop();
            }
        }

        @Override
        protected void doStart(PointsEnteredCallback pointsEnteredCallback) {
            this.callback = pointsEnteredCallback;
            this.points.clear();
            GlassComponent.this.addMouseListener(this);
            GlassComponent.this.addMouseMotionListener(this);
        }

        private void sendRectangle() {
            Rectangle rectangle = new Rectangle((Point)this.points.get(0));
            rectangle.add((Point)this.points.get(1));
            this.callback.rectangleSelected(SwingUtilities.convertRectangle(GlassComponent.this, rectangle, this.callback.getTargetCoordinateSpace()));
            GlassComponent.this.setVisible(false);
        }

        @Override
        protected void doStop() {
            GlassComponent.this.removeMouseListener(this);
            GlassComponent.this.removeMouseMotionListener(this);
            this.dragStart = null;
            this.lastDragPoint = null;
            this.callback = null;
        }
    }

    abstract class GPMouseInputAdapter
    extends MouseInputAdapter {
        GPMouseInputAdapter() {
        }

        protected final void start(PointsEnteredCallback pointsEnteredCallback) {
            GlassComponent.this.activeListeners.add(this);
            GlassComponent.this.setVisible(true);
            this.doStart(pointsEnteredCallback);
        }

        protected abstract void doStart(PointsEnteredCallback var1);

        protected abstract void doStop();

        protected final void stop() {
            GlassComponent.this.activeListeners.remove(this);
            this.doStop();
            GlassComponent.this.stopAll();
        }
    }
}

