/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.crest.fcp.DMDiagramEditor;
import oracle.dbtools.crest.fcp.FindEditorRunner;
import oracle.dbtools.crest.imports.SyncUtils;
import oracle.dbtools.crest.model.MDUserFactory;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignEvent;
import oracle.dbtools.crest.model.design.DesignListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DesignPartListener;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.DiagramViewListener;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.LegendSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.undo.DP_UndoManager;
import oracle.dbtools.crest.model.design.undo.DesignObjectEdit;
import oracle.dbtools.crest.model.design.undo.GroupRemoveEdit;
import oracle.dbtools.crest.model.design.undo.TopViewRemoveEdit;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.swingui.AbstractApplicationPanel;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.GlassComponent;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectedObjectChangeListener;
import oracle.dbtools.crest.swingui.SelectionSourceImpl;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.TVLegend;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.TVDTRelation;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramSelectionListener;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.LabelDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.NoteDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.TVArc;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.swingui.relational.TVFKArc;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.ColorChooserDialog;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.gui.swing.CloseListener;
import oracle.dbtools.crest.util.gui.swing.JSelectedTabbedPane;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;

public abstract class DesignPartView
extends AbstractApplicationPanel
implements DesignPartListener,
DesignListener,
CloseListener,
DiagramSelectionListener,
RepositoryObject,
StorableObject,
ID_ObjectPropertyTranslator {
    private static final Logger LOGGER = new Logger(DesignPartView.class);
    public static final String MI_ATTRIBUTES = Messages.getString("DesignPartView.Attributes");
    public static final String MI_COLUMNS = Messages.getString("DesignPartView.Columns");
    public static final String MI_DETAILS = Messages.getString("DesignPartView.ViewDetails");
    public static final String MI_SHOW = Messages.getString("DesignPartView.Show");
    public static final String MI_AUTO_ROUTE = Messages.getString("DesignPartView.AutoRoute");
    public static final String MI_SHOW_GRID = Messages.getString("DesignPartView.ShowGrid");
    public static final String MI_SHOW_LEGEND = Messages.getString("DesignPartView.ShowLegend");
    public static final String MI_SHOW_LABELS = Messages.getString("DesignPartView.ShowLabels");
    public static final String MI_PROPERTIES = Messages.getString("DesignPartView.ModelProperties");
    public static final String MI_ALL_DETAILS = Messages.getString("DesignPartView.AllDetails");
    public static final String MI_SCHEMA_NAME = Messages.getString("DesignPartView.SchemaName");
    public static final String MI_METHODS = Messages.getString("DesignPartView.Methods");
    public static final String MI_NAMES_ONLY = Messages.getString("DesignPartView.NamesOnly");
    public static final String MI_KEYS = Messages.getString("DesignPartView.Keys");
    public static final String MI_INDEXES = Messages.getString("DesignPartView.Indexes");
    public static final String MI_KEY_AND_INDEX_COLUMNS = Messages.getString("DesignPartView.KeyAndIndexColumns");
    public static final String MI_DATATYPE = Messages.getString("DesignPartView.Datatype");
    public static final String MI_ELEMENTS = Messages.getString("DesignPartView.Elements");
    public static final String MI_ENTITIES = Messages.getString("DesignPartView.Entities");
    public static final String MI_PASTE = Messages.getString("DesignPartView.Paste");
    public static final String MI_AUTO_LAYOUT = Messages.getString("DesignPartView.AutoLayout");
    public static final String MI_RESIZE_OBJECTS_TO_VISIBLE = Messages.getString("DesignPartView.ResizeObjectsToVisible");
    public static final String MI_DIAGRAM_COLOR = Messages.getString("DesignPartView.DiagramColor");
    public static final String MI_CREATE_SUBVIEW = Messages.getString("DesignPartView.CreateSubView");
    public static final String MI_DELETE_SUBVIEW = Messages.getString("DesignPartView.DeleteSubView");
    public static final String MI_CREATE_DISPLAY = Messages.getString("DesignPartView.CreateDisplay");
    public static final String MI_DELETE_DISPLAY = Messages.getString("DesignPartView.DeleteDisplay");
    public static final String MI_GO_TO_PARENT = Messages.getString("DesignPartView.GoToParent");
    public static final String MI_VALIDATE_ALL_VIEWS = Messages.getString("DesignPartView.ValidateAllViews");
    public static final String MI_PARSE_OLDER_STYLE_VIEWS = Messages.getString("DesignPartView.ParseOlderStyleViews");
    public static final Comparator DPV_NAME_COMPARATOR = new DesignPartViewNameComparator();
    public static final Comparator TOP_VIEW_OBJ_ID_COMPARATOR = new TopViewObIDComparator();
    public static final String MI_SYNC_SUBVIEW_WITH_DATA_DICTIONARY = Messages.getString("DesignPartView.SyncSubViewWithDataDictionary");
    public static final String MI_SYNC_DATA_DICTIONARY_WITH_SUBVIEW = Messages.getString("DesignPartView.SyncDataDictionaryWithSubView");
    public static final String MI_SYNC_WITH_DATA_DICTIONARY = Messages.getString("DesignPartView.SyncWithDataDictionary");
    public static final String MI_SYNC_DATA_DICTIONARY = Messages.getString("DesignPartView.SyncDataDictionary");
    private Diagram workSpace;
    private GlassComponent glasspane;
    protected Map modelToView = new HashMap();
    private int count = 0;
    private boolean mustBeVisible = false;
    private SelectionSourceImpl selectDelegate = new SelectionSourceImpl();
    private TopView selectedView = null;
    private boolean addViewAfterUserInput = false;
    protected boolean isMainDiagram = true;
    private Context context = null;
    private SchemaObject schemaObject;
    private TopViewInitializer activeTopViewInitializer = null;
    private String name = "";
    private DesignPart designPart;
    private PlaceHolder host;
    private String dpvId;
    private String generatorId;
    private NamedTabbedPane tabbedPane;
    private DesignPartView masterSubview;
    private List subordinateViews = new ArrayList();
    protected List topViews = new ArrayList();
    private SubViewObjectSet displays;
    private boolean autoRoute = false;
    private int notation = 0;
    private boolean showNamesOnly = false;
    private boolean showElements = false;
    private boolean showKeyElements = false;
    private boolean showDatatype = false;
    private boolean showKeys = false;
    private boolean showIndexes = false;
    private boolean showKeyAndIndexColumns = false;
    private boolean showAllDetails = true;
    private boolean showLabels = false;
    private boolean showLabelsChanging = false;
    private boolean showSchemaName = true;
    public Point pt;
    private boolean boxInBox = false;
    private String importedId;
    private DP_UndoManager undoManager = new DP_UndoManager();
    private boolean commandInProgress = false;
    private String repositoryOID = null;
    private String repositoryOVID = null;
    private boolean checkedOut = false;
    private String checkedOutBy = "";
    private boolean checkedOutByMe = false;
    private boolean dirty = false;
    private boolean inLayoutEdit = false;
    private AutoLayoutEdit autoLayoutEdit;
    private RepositoryObject pac_Element;
    private UndoAdapter undoAdapter = new UndoAdapter();
    private boolean display = false;
    private String filePath;
    private Legend legend = null;
    private boolean showLegend;
    private int legendPosX = 10;
    private int legendPosY = 10;
    private LegendSet legendSet;
    private boolean showGrid;
    private Color diagramColor = Color.WHITE;
    private int legendAttributes = 126;
    private Set dvListeners = new HashSet();
    private DesignPartView lastContainerDiagram;
    static String GO_TO_MENU = Messages.getString("DesignPartView.GoToDiagram");
    private Map backLinksMap = new HashMap();

    public DesignPartView(ApplicationView applicationView, DesignPart designPart) {
        super(applicationView);
        this.designPart = designPart;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setLayout(new OverlayLayout(this));
        jPanel.add((Component)this.getWorkSpace().getScrollPane(), "Center");
        this.getDesignPart().addDesignPartListener(this);
        this.addSelectedObjectChangeListener(applicationView);
        this.add(this.getGlassPane());
        this.add(jPanel);
        this.setBackground(Color.white);
        this.displays = new SubViewObjectSet(designPart, Messages.getString("DesignPartView.Displays"), true);
        this.displays.setParent(designPart);
        this.displays.setElementDescriptor("DISPLAY_TYPE");
        if (applicationView != null) {
            this.notation = applicationView.getSettings().getNotation();
            this.boxInBox = applicationView.getSettings().isBoxInBox();
        }
        this.getWorkSpace().addDiagramSelectionListener(this);
        this.designPart.addUndoableEditListener(this.undoAdapter);
        this.getDesign().addDesignListener(this);
    }

    public Diagram getWorkSpace() {
        if (this.workSpace == null) {
            this.workSpace = new Diagram(this.getApplicationView(), this);
            this.workSpace.getModel().addUndoableEditListener(this.undoAdapter);
        }
        this.workSpace.setName(this.getName());
        return this.workSpace;
    }

    public void sortCollections() {
    }

    public Dimension getWorkSpaceUsedSize() {
        return this.getWorkSpace().getPreferredScrollableViewportSize();
    }

    public GlassComponent getGlassPane() {
        if (this.glasspane == null) {
            this.glasspane = new GlassComponent();
            this.glasspane.setStatusBarOwner(this.getApplicationView());
        }
        return this.glasspane;
    }

    public TopView addViewFor(DesignObject designObject) {
        if (!ApplicationView.loading && this.getViewFor(designObject) != null) {
            return null;
        }
        TopView topView = this.createViewFor(designObject);
        if (topView == null) {
            return null;
        }
        if (designObject != null && designObject.isVisible() && this.getApplicationView() != null && (this.isCurrentDPV() || this.isMainDiagram()) && !ApplicationView.loading) {
            this.modelToView.put(designObject, topView);
            this.add(topView);
        }
        return topView;
    }

    public TopView addViewFor(DesignObject designObject, boolean bl) {
        if (this.getViewFor(designObject) != null) {
            return null;
        }
        TopView topView = this.createViewFor(designObject);
        if (topView == null) {
            if (bl) {
                topView = this.createTopViewFor(designObject);
            } else {
                return null;
            }
        }
        if (designObject != null && designObject.isVisible() && this.getApplicationView() != null && ((this.isCurrentDPV() || this.isMainDiagram()) && !ApplicationView.loading || bl)) {
            this.modelToView.put(designObject, topView);
            this.add(topView);
        }
        return topView;
    }

    public void showView(TopView topView) {
        if (this.getApplicationView() != null && (this.isVisible() || this.isMainDiagram()) && !ApplicationView.loading) {
            this.modelToView.put(topView.getModel(), topView);
            this.add(topView);
        }
    }

    public TopView openViewFor(DesignObject designObject) {
        TopView topView = this.getViewFor(designObject);
        if (topView == null) {
            this.addViewFor(designObject);
            topView = this.getViewFor(designObject);
        }
        this.setLocationVisible(topView);
        return topView;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        if (!this.name.equals(string)) {
            int n;
            this.name = string;
            this.getTabbedPane().setName(string);
            if (this.isMasterDPV()) {
                if (this.context != null) {
                    RenameMessage.fireObjectRenamed((Node)this.getContext().getNode(), (URL)this.getContext().getNode().getURL(), (Node)this.getContext().getNode(), (Context)this.context);
                    n = this.getTabbedPane().indexOfComponent(this);
                    if (n > -1) {
                        this.getTabbedPane().setTitleAt(n, string);
                    }
                }
            } else if (this.getMasterDPV() != null && (n = this.getMasterDPV().getTabbedPane().indexOfComponent(this)) > -1) {
                this.getMasterDPV().getTabbedPane().setTitleAt(n, string);
            }
            try {
                TopView topView;
                if (this.legend != null && (topView = this.legend.getFirstViewForDPV(this)) != null && topView.getCellView() != null) {
                    this.updateLegendPosition();
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.legendPosX, this.legendPosY), this.legend.getSize()), false);
                }
            }
            catch (Exception exception) {
                LOGGER.warn(exception.getMessage(), exception);
            }
        }
    }

    public void setPlaceHolder(PlaceHolder placeHolder) {
        this.host = placeHolder;
    }

    public PlaceHolder getPlaceHolder() {
        return this.host;
    }

    public void setLocationVisible(TopView topView) {
        if (topView instanceof TVRelation || topView instanceof TVFKRelation) {
            return;
        }
        Dimension dimension = topView.getSize();
        topView.setSize(this.insureMinimal(dimension));
        Dimension dimension2 = this.getWorkSpace().getSize();
        Point point = topView.getLocation();
        if (point.x < 0) {
            point.x = 5;
        } else if (point.x + dimension.width > dimension2.width) {
            point.x = dimension2.width - dimension.width - 5;
        }
        if (point.y < 0) {
            point.y = 5;
        } else if (point.y + dimension.height > dimension2.height) {
            point.y = dimension2.height - dimension.height - 5;
        }
        topView.setLocation(point);
    }

    public void removeView(TopView topView) {
        this.unregisterFromTreemodel(topView);
        DesignObject designObject = topView.getModel();
        designObject.removeViewSynonim(topView);
        if (designObject.getViewsCountForDPV(this) == 0) {
            this.modelToView.remove(designObject);
            this.cascadeRemoveSynonymToDisplays(topView);
        }
        this.setDirty(true);
    }

    public void removeViewNoneCascade(TopView topView) {
        this.unregisterFromTreemodel(topView);
        DesignObject designObject = topView.getModel();
        designObject.removeViewSynonim(topView);
        if (designObject.getViewsCountForDPV(this) == 0) {
            this.modelToView.remove(designObject);
        }
    }

    public void removeViewFor(DesignObject designObject) {
        TopView topView = this.getViewFor(designObject);
        if (topView == null) {
            return;
        }
        if (topView.isConnection() && topView instanceof TVConnector) {
            this.unregisterFromTreemodel(topView);
            this.modelToView.remove(designObject);
            ((TVConnector)topView).removeConnection();
        } else {
            TopViewCollection topViewCollection = designObject.getViewsForDPV(this);
            for (int i = topViewCollection.size() - 1; i >= 0; --i) {
                TopView topView2 = (TopView)topViewCollection.get(i);
                this.unregisterFromTreemodel(topView2);
                this.modelToView.remove(designObject);
            }
        }
    }

    public void centerDesign() {
        double d = GUIConfiguration.getInstance().getWorkSpaceSize().getWidth();
        double d2 = 0.0;
        double d3 = GUIConfiguration.getInstance().getWorkSpaceSize().getHeight();
        double d4 = 0.0;
        List list = this.getTopviewsList();
        if (list.size() > 0) {
            for (TopView topView : list) {
                double d5 = topView.getLocation().getX();
                double d6 = d5 + topView.getBounds().getWidth();
                double d7 = topView.getLocation().getY();
                double d8 = d7 + topView.getBounds().getHeight();
                if (d5 < d) {
                    d = d5;
                }
                if (d6 > d2) {
                    d2 = d6;
                }
                if (d7 < d3) {
                    d3 = d7;
                }
                if (!(d8 > d4)) continue;
                d4 = d8;
            }
            if (d < 0.0) {
                d = 0.0;
            }
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            int n = (int)(d2 - d);
            int n2 = (int)(d4 - d3);
            Rectangle rectangle = new Rectangle((int)d, (int)d3, n, n2);
            this.scrollTo(rectangle);
        }
    }

    private void scrollTo(Rectangle rectangle) {
        int n;
        Rectangle rectangle2 = this.getWorkSpace().getVisibleRect();
        Point point = new Point();
        point.x = rectangle.x + rectangle.width / 4;
        point.y = rectangle.y + rectangle.height / 4;
        int n2 = point.x - rectangle2.width / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = point.y - rectangle2.height / 2) < 0) {
            n = 0;
        }
        rectangle2.x = n2;
        rectangle2.y = n;
        this.getWorkSpace().scrollRectToVisible(rectangle2);
    }

    public void removeAllViews() {
        this.modelToView.clear();
        this.workSpace.removeCells(this.workSpace.getRoots());
    }

    public TopView getViewFor(DesignObject designObject) {
        TopView topView = (TopView)this.modelToView.get(designObject);
        if (topView == null && (topView = this.getFirstViewFor(designObject)) != null) {
            this.modelToView.put(designObject, topView);
        }
        return topView;
    }

    public void add(TopView topView) {
        this.modelToView.put(topView.getModel(), topView);
        if (this.activeTopViewInitializer != null && !this.activeTopViewInitializer.isDone()) {
            this.activeTopViewInitializer.addAnyWay();
            this.activeTopViewInitializer = null;
        }
        if (this.getAddViewAfterUserInput()) {
            this.addAfterUserInput(topView);
        } else {
            this.addDefaultLocation(topView);
        }
    }

    public void addDefaultLocation(TopView topView) {
        int n;
        int n2;
        if (this.getWorkSpace().getWidth() == 0 || this.getWorkSpace().getHeight() == 0) {
            n2 = GUIConfiguration.getInstance().getWorkSpaceSize().height;
            n = GUIConfiguration.getInstance().getWorkSpaceSize().width;
        } else {
            n2 = this.getWorkSpace().getHeight();
            n = this.getWorkSpace().getWidth();
        }
        this.add(topView, new Rectangle(50 + 10 * this.count % n, 50 + 20 * this.count++ % n2, 170, 110));
    }

    public void addAfterUserInput(TopView topView) {
        this.addDefaultLocation(topView);
        this.activeTopViewInitializer = new TopViewInitializer(topView);
    }

    public void setAddViewAfterUserInput(boolean bl) {
        this.addViewAfterUserInput = bl;
    }

    public boolean getAddViewAfterUserInput() {
        return this.addViewAfterUserInput;
    }

    public void add(TopView topView, Rectangle rectangle) {
        this.add(topView, rectangle, topView.getLayerConstraint());
    }

    public void add(TopView topView, Rectangle rectangle, Object object) {
        if (topView.getApplicationView().isImporting()) {
            return;
        }
        if (topView.getCellView() == null) {
            DefaultDiagramCell defaultDiagramCell = null;
            DesignObject designObject = topView.getModel();
            if (designObject instanceof Entity) {
                defaultDiagramCell = this.getWorkSpace().addEntity((Entity)designObject, rectangle);
            } else if (designObject instanceof EntityView) {
                defaultDiagramCell = this.getWorkSpace().addEntityView((EntityView)designObject, rectangle);
            } else if (designObject instanceof Table) {
                defaultDiagramCell = this.getWorkSpace().addTable((Table)designObject, rectangle);
            } else if (designObject instanceof TableView) {
                defaultDiagramCell = this.getWorkSpace().addTableView((TableView)designObject, rectangle);
            } else if (designObject instanceof Note) {
                defaultDiagramCell = this.getWorkSpace().addNote((Note)designObject, rectangle);
            } else if (designObject instanceof Legend) {
                defaultDiagramCell = this.getWorkSpace().addLegend((Legend)designObject, new Rectangle(new Point(this.legendPosX, this.legendPosY), ((Legend)designObject).getSize()));
            } else if (designObject instanceof DiagramView) {
                defaultDiagramCell = this.getWorkSpace().addDiagramView((DiagramView)designObject, rectangle);
            } else if (designObject instanceof InheritanceRelation) {
                InheritanceRelation inheritanceRelation = (InheritanceRelation)designObject;
                if (inheritanceRelation.getSourceTV(this) != null && inheritanceRelation.getTargetTV(this) != null && inheritanceRelation.getSourceTV(this).getCellView() != null && inheritanceRelation.getTargetTV(this).getCellView() != null) {
                    ((TVRelation)topView).addConnection();
                    DefaultEdge defaultEdge = ((TVRelation)topView).getEdge();
                    if (defaultEdge != null) {
                        this.getWorkSpace().addPoints(defaultEdge, ((TVRelation)topView).getEdgePoints(), true);
                        defaultEdge.getCellView().update();
                    }
                    defaultDiagramCell = defaultEdge;
                }
            } else if (designObject instanceof Relation) {
                Relation relation = (Relation)designObject;
                if (relation.getSourceTV(this) != null && relation.getTargetTV(this) != null && relation.getSourceTV(this).getCellView() != null && relation.getTargetTV(this).getCellView() != null) {
                    ((TVRelation)topView).addConnection();
                    DefaultEdge defaultEdge = ((TVRelation)topView).getEdge();
                    if (defaultEdge != null) {
                        this.getWorkSpace().addPoints(defaultEdge, ((TVRelation)topView).getEdgePoints(), true);
                        defaultEdge.getCellView().update();
                        defaultDiagramCell = defaultEdge;
                    }
                }
            } else if (designObject instanceof FKIndexAssociation) {
                FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)designObject;
                if (fKIndexAssociation.getSourceTV(this) != null && fKIndexAssociation.getTargetTV(this) != null) {
                    ((TVFKRelation)topView).addConnection();
                    DefaultEdge defaultEdge = ((TVFKRelation)topView).getEdge();
                    if (defaultEdge != null) {
                        this.getWorkSpace().addPoints(defaultEdge, ((TVFKRelation)topView).getEdgePoints(), true);
                        defaultEdge.getCellView().update();
                        defaultDiagramCell = defaultEdge;
                    }
                }
            } else if (designObject instanceof TypeSubstitution) {
                TypeSubstitution typeSubstitution = (TypeSubstitution)designObject;
                if (typeSubstitution.getChildCV(this) != null && typeSubstitution.getParentCV(this) != null) {
                    ((TVTypeSubstitution)topView).addConnection();
                    DefaultEdge defaultEdge = ((TVTypeSubstitution)topView).getEdge();
                    this.getWorkSpace().addPoints(defaultEdge, ((TVTypeSubstitution)topView).getEdgePoints(), true);
                    defaultEdge.getCellView().update();
                    defaultDiagramCell = defaultEdge;
                }
            } else if (designObject instanceof Process) {
                defaultDiagramCell = this.getWorkSpace().addProcess((Process)designObject, rectangle);
            } else if (designObject instanceof Transformation) {
                defaultDiagramCell = this.getWorkSpace().addTransformation((Transformation)designObject, rectangle);
            } else if (designObject instanceof ExternalAgent) {
                defaultDiagramCell = this.getWorkSpace().addAgent((ExternalAgent)designObject, rectangle);
            } else if (designObject instanceof InfoStore) {
                defaultDiagramCell = this.getWorkSpace().addStore((InfoStore)designObject, rectangle);
            } else if (designObject instanceof InOutParams) {
                defaultDiagramCell = this.getWorkSpace().addInOutParams((InOutParams)designObject, rectangle);
            } else if (designObject instanceof Flow) {
                Flow flow = (Flow)designObject;
                if (flow.getSourceTV(this) != null && flow.getTargetTV(this) != null && flow.getSourceTV(this).getCellView() != null && flow.getTargetTV(this).getCellView() != null) {
                    DFDiagramCell dFDiagramCell = (DFDiagramCell)flow.getSourceTV(this).getCellView().getCell();
                    DFDiagramCell dFDiagramCell2 = (DFDiagramCell)flow.getTargetTV(this).getCellView().getCell();
                    if (dFDiagramCell != null && dFDiagramCell2 != null) {
                        DefaultEdge defaultEdge = ((TVFlow)topView).addConnection();
                        this.getWorkSpace().addPoints(defaultEdge, ((TVFlow)topView).getEdgePoints(), true);
                        defaultEdge.getCellView().update();
                        defaultDiagramCell = defaultEdge;
                    }
                }
            } else if (designObject instanceof Cube) {
                defaultDiagramCell = this.getWorkSpace().addCube((Cube)designObject, rectangle);
            } else if (designObject instanceof Level) {
                if (topView.getSize().height > 0) {
                    rectangle.height = topView.getSize().height;
                }
                if (topView.getSize().width > 0) {
                    rectangle.width = topView.getSize().width;
                }
                defaultDiagramCell = this.getWorkSpace().addLevel((Level)designObject, rectangle);
            } else if (designObject instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
                if (topView.getSize().height > 0) {
                    rectangle.height = topView.getSize().height;
                }
                if (topView.getSize().width > 0) {
                    rectangle.width = topView.getSize().width;
                }
                defaultDiagramCell = this.getWorkSpace().addDimension((oracle.dbtools.crest.model.design.multidimensional.Dimension)designObject, rectangle);
            } else if (designObject instanceof Link) {
                Link link = (Link)designObject;
                if (link.getSourceTV(this) != null && link.getTargetTV(this) != null && link.getSourceTV(this).getCellView() != null && link.getTargetTV(this).getCellView() != null) {
                    MDDiagramCell mDDiagramCell = (MDDiagramCell)link.getSourceTV(this).getCellView().getCell();
                    MDDiagramCell mDDiagramCell2 = (MDDiagramCell)link.getTargetTV(this).getCellView().getCell();
                    if (mDDiagramCell != null && mDDiagramCell2 != null) {
                        DefaultEdge defaultEdge = ((TVLink)topView).addConnection();
                        this.getWorkSpace().addPoints(defaultEdge, ((TVLink)topView).getEdgePoints(), true);
                        defaultEdge.getCellView().update();
                        defaultDiagramCell = defaultEdge;
                    }
                }
                link.addRollupLink();
            } else if (designObject instanceof RaggedHLink) {
                RaggedHLink raggedHLink = (RaggedHLink)designObject;
                if (raggedHLink.getSourceTV(this) != null && raggedHLink.getTargetTV(this) != null && raggedHLink.getSourceTV(this).getCellView() != null && raggedHLink.getTargetTV(this).getCellView() != null) {
                    MDDiagramCell mDDiagramCell = (MDDiagramCell)raggedHLink.getSourceTV(this).getCellView().getCell();
                    MDDiagramCell mDDiagramCell3 = (MDDiagramCell)raggedHLink.getTargetTV(this).getCellView().getCell();
                    if (mDDiagramCell != null && mDDiagramCell3 != null) {
                        DefaultEdge defaultEdge = ((TVRaggedHLink)topView).addConnection();
                        this.getWorkSpace().addPoints(defaultEdge, ((TVRaggedHLink)topView).getEdgePoints(), true);
                        defaultEdge.getCellView().update();
                        defaultDiagramCell = defaultEdge;
                    }
                }
            } else if (designObject instanceof DTRelation) {
                DTRelation dTRelation = (DTRelation)designObject;
                if (dTRelation.getSourceTV(this) != null && dTRelation.getTargetTV(this) != null && dTRelation.getSourceTV(this).getCellView() != null && dTRelation.getTargetTV(this).getCellView() != null) {
                    DefaultEdge defaultEdge = ((TVDTRelation)topView).addConnection();
                    this.getWorkSpace().addPoints(defaultEdge, ((TVDTRelation)topView).getEdgePoints(), true);
                    defaultEdge.getCellView().update();
                    defaultDiagramCell = defaultEdge;
                }
            } else if (designObject instanceof StructuredType) {
                if (topView.getSize().height > 0) {
                    rectangle.height = topView.getSize().height;
                }
                if (topView.getSize().width > 0) {
                    rectangle.width = topView.getSize().width;
                }
                defaultDiagramCell = this.getWorkSpace().addStructuredType((StructuredType)designObject, rectangle);
            } else if (designObject instanceof Arc) {
                defaultDiagramCell = this.getWorkSpace().addArc((Arc)designObject, rectangle);
            } else if (designObject instanceof FKArc) {
                defaultDiagramCell = this.getWorkSpace().addFKArc((FKArc)designObject, rectangle);
            }
            if (defaultDiagramCell != null) {
                defaultDiagramCell.setTopView(topView);
                topView.setCellView(defaultDiagramCell.getCellView());
                if (!topView.getDesign().isLoading()) {
                    topView.makeSelected();
                }
            }
        }
    }

    public void setCurrentSelection(SelectableObject selectableObject) {
        if (!ApplicationView.loading) {
            this.selectDelegate.setCurrentSelection(selectableObject);
        }
    }

    public void setCurrentSelection(SelectableObject selectableObject, TopView topView) {
        try {
            if (topView != null && selectableObject != null) {
                this.setSelectedTopView(topView);
                this.selectDelegate.setCurrentSelection(selectableObject);
                if (topView.getCellView() != null) {
                    this.getWorkSpace().setSelectionCell(topView.getCellView().getCell());
                    Rectangle rectangle = topView.getCellView().getBounds().getBounds();
                    this.getWorkSpace().scrollCellToVisible(topView.getCellView().getCell());
                    topView.getCellView().setNewBounds(rectangle);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn(exception.getMessage(), exception);
        }
    }

    public void setSelectedTopView(TopView topView) {
        this.selectedView = topView;
    }

    public TopView getSelectedTopView() {
        return this.selectedView;
    }

    public SelectableObject getCurrentSelection() {
        return this.selectDelegate.getCurrentSelection();
    }

    public void addSelectedObjectChangeListener(SelectedObjectChangeListener selectedObjectChangeListener) {
        this.selectDelegate.addSelectedObjectChangeListener(selectedObjectChangeListener);
    }

    public void removeSelectedObjectChangeListener(SelectedObjectChangeListener selectedObjectChangeListener) {
        this.selectDelegate.removeSelectedObjectChangeListener(selectedObjectChangeListener);
    }

    public abstract TopView createViewFor(DesignObject var1);

    public void createSubViewFromSelected() {
    }

    public void selectNeighbors(ContainerObject containerObject) {
    }

    public void resizeSelectedObjects() {
    }

    public abstract AbstractController getController();

    public DesignPart getDesignPart() {
        return this.designPart;
    }

    public void showAllTopViews() {
        Collection collection = this.getDesignPart().getAllTopLevelObjects();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.openViewFor((DesignObject)iterator.next());
        }
    }

    private boolean notAmongProcessed(DesignObject designObject) {
        if (designObject instanceof Column || designObject instanceof Attribute) {
            return true;
        }
        if (designObject instanceof ColumnView || designObject instanceof AttributeView) {
            return true;
        }
        if (designObject instanceof Index || designObject instanceof CandidateKey) {
            return true;
        }
        return designObject instanceof TypeElement || designObject instanceof Method || designObject instanceof MethodParam;
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject designObject) {
        if (DesignObjectEdit.UNDOABLE_ADD) {
            return;
        }
        if (this.getApplicationView() == null) {
            return;
        }
        if (!ApplicationView.loading && (designObject instanceof Note || designObject instanceof Label || designObject instanceof DiagramView || designObject instanceof Legend) && !this.isCurrentDPV()) {
            return;
        }
        if (designObject instanceof Legend && ((Legend)designObject).getDesignPartView() != this) {
            return;
        }
        if (this.notAmongProcessed(designObject)) {
            return;
        }
        if (!ApplicationView.loading) {
            TopView topView = this.getViewFor(designObject);
            if (topView == null) {
                topView = this.addViewFor(designObject);
            }
        } else {
            this.addViewFor(designObject);
        }
    }

    @Override
    public void objectRemoved(DesignPart designPart, DesignObject designObject) {
        if (!this.getDesign().isClosing() && !this.notAmongProcessed(designObject)) {
            boolean bl = false;
            TopView topView = designObject.getFirstViewForDPV(this);
            if (topView != null) {
                bl = this.getTopviewsList().contains(topView);
            }
            this.unregisterViewsForObject(designObject);
            if (designObject instanceof Arc) {
                this.getWorkSpace().removeArc((Arc)designObject);
            } else if (designObject instanceof FKArc) {
                this.getWorkSpace().removeFKArc((FKArc)designObject);
            } else if (designObject instanceof ContainerObject) {
                this.getWorkSpace().removeContainer((ContainerObject)designObject);
            } else if (designObject instanceof Relation) {
                this.getWorkSpace().removeConnection(designObject);
            } else if (designObject instanceof TypeSubstitution) {
                this.getWorkSpace().removeConnection(designObject);
            } else if (designObject instanceof FKIndexAssociation) {
                this.getWorkSpace().removeConnection(designObject);
            } else if (designObject instanceof Note) {
                this.getWorkSpace().removeNote((Note)designObject);
            } else if (designObject instanceof Legend) {
                this.getWorkSpace().removeLegend((Legend)designObject);
            } else if (designObject instanceof Label) {
                this.getWorkSpace().removeLabel((Label)designObject);
            } else if (designObject instanceof DiagramView) {
                this.getWorkSpace().removeDiagramView((DiagramView)designObject);
            } else if (designObject instanceof AbstractProcessObject) {
                this.getWorkSpace().removeProcessObject((AbstractProcessObject)designObject);
            } else if (designObject instanceof AbstractMDObject) {
                this.getWorkSpace().removeMDObject((AbstractMDObject)designObject);
            } else if (designObject instanceof DTRelation) {
                this.getWorkSpace().removeConnection(designObject);
            } else if (designObject instanceof AbstractDTObject) {
                this.getWorkSpace().removeDTObject((AbstractDTObject)designObject);
            }
            this.removeViewFor(designObject);
            if (this.selectDelegate.getCurrentSelection() != null && designObject == this.selectDelegate.getCurrentSelection().getSelectedDesignObject()) {
                this.selectDelegate.setCurrentSelection(null);
            }
            if (bl) {
                this.setDirty(true);
            }
        }
    }

    private void unregisterViewsForObject(DesignObject designObject) {
        if (designObject instanceof ConnectionInterface) {
            TopView topView = ((ConnectionInterface)((Object)designObject)).getViewFor(this);
            this.unregisterTopView(topView);
            this.unregisterFromTreemodel(topView);
        } else {
            TopViewCollection topViewCollection = designObject.getViewsForDPV(this);
            for (TopView topView : topViewCollection) {
                this.unregisterTopView(topView);
                this.unregisterFromTreemodel(topView);
            }
        }
    }

    public void zoomIn() {
        this.getWorkSpace().zoomIn();
        Object[] objectArray = this.getWorkSpace().getSelectionCells();
        if (objectArray.length > 0) {
            this.getWorkSpace().scrollCellToVisible(objectArray[0]);
        }
    }

    public void zoomOut() {
        this.getWorkSpace().zoomOut();
        Object[] objectArray = this.getWorkSpace().getSelectionCells();
        if (objectArray.length > 0) {
            this.getWorkSpace().scrollCellToVisible(objectArray[0]);
        }
    }

    public void actualSize() {
        this.getWorkSpace().actualSize();
        Object[] objectArray = this.getWorkSpace().getSelectionCells();
        if (objectArray.length > 0) {
            this.getWorkSpace().scrollCellToVisible(objectArray[0]);
        }
    }

    public void fitScreen() {
        this.getWorkSpace().fitScreen();
    }

    public Object[] getSelectedObjects() {
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        if (this.getWorkSpace().getSelectionCount() > 0) {
            Object[] objectArray = this.getWorkSpace().getSelectionCells();
            for (int i = 0; i < objectArray.length; ++i) {
                DesignObject designObject;
                TopView topView;
                Object object = objectArray[i];
                if (!(object instanceof DefaultDiagramCell) || (topView = ((DefaultDiagramCell)object).getTopView()) == null || (designObject = topView.getModel()) == null || arrayList.contains(designObject)) continue;
                arrayList.add(designObject);
            }
        }
        return arrayList.toArray();
    }

    public Object[] getSelectedTVConnectors() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        if (this.getWorkSpace().getSelectionCount() > 0) {
            Object[] objectArray = this.getWorkSpace().getSelectionCells();
            for (int i = 0; i < objectArray.length; ++i) {
                TopView topView;
                Object object = objectArray[i];
                if (!(object instanceof DefaultEdge) || (topView = ((DefaultEdge)object).getTopView()) == null) continue;
                arrayList.add(topView);
            }
        }
        return arrayList.toArray();
    }

    public Object[] getSelectedTopViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        if (this.getWorkSpace().getSelectionCount() > 0) {
            Object[] objectArray = this.getWorkSpace().getSelectionCells();
            for (int i = 0; i < objectArray.length; ++i) {
                TopView topView;
                Object object = objectArray[i];
                if (!(object instanceof DefaultDiagramCell) || (topView = ((DefaultDiagramCell)object).getTopView()) == null) continue;
                arrayList.add(topView);
            }
        }
        return arrayList.toArray();
    }

    public void fireSelectionChanged() {
    }

    public JPanel getNavigatorPanel() {
        return this.getWorkSpace().getNavigatorPanel();
    }

    public int getNumberOfChildren() {
        return 0;
    }

    public ModelObject getChild(int n) {
        return null;
    }

    public int getIndexForChild(ModelObject modelObject) {
        return -1;
    }

    public boolean isLeaf() {
        return true;
    }

    public Dimension insureMinimal(Dimension dimension) {
        if (dimension.height < 20) {
            dimension.height = 20;
        }
        if (dimension.width < 20) {
            dimension.width = 20;
        }
        return dimension;
    }

    public List getTopViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        CellView[] cellViewArray = this.getWorkSpace().getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            TopView topView;
            DefaultDiagramCell defaultDiagramCell = (DefaultDiagramCell)cellViewArray[i].getCell();
            if (defaultDiagramCell instanceof ContainerDiagramCell) {
                topView = ((ContainerDiagramCell)defaultDiagramCell).getContainer().getTopView();
                arrayList.add(topView);
                continue;
            }
            if (defaultDiagramCell instanceof NoteDiagramCell) {
                topView = ((NoteDiagramCell)defaultDiagramCell).getNote().getTopView();
                arrayList.add(topView);
                continue;
            }
            if (defaultDiagramCell instanceof LabelDiagramCell) {
                topView = ((LabelDiagramCell)defaultDiagramCell).getLabel().getTopView();
                arrayList.add(topView);
                continue;
            }
            if (!(defaultDiagramCell instanceof DiagramViewDiagramCell)) continue;
            topView = ((DiagramViewDiagramCell)defaultDiagramCell).getDiagramView().getTopView();
            arrayList.add(topView);
        }
        return arrayList;
    }

    public List getTopviewsList() {
        return Collections.unmodifiableList(this.topViews);
    }

    public List getTVShapes() {
        ArrayList<TopView> arrayList = null;
        for (TopView topView : this.topViews) {
            if (!(topView instanceof ContainerView) || topView instanceof TVArc || topView instanceof TVFKArc || topView instanceof TVDiagramView || topView instanceof TVLegend) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<TopView>();
            }
            arrayList.add(topView);
        }
        if (arrayList != null) {
            Collections.sort(arrayList, TOP_VIEW_OBJ_ID_COMPARATOR);
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public List getTVArcs() {
        ArrayList<TopView> arrayList = null;
        for (TopView topView : this.topViews) {
            if (!(topView instanceof TVArc) && !(topView instanceof TVFKArc)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<TopView>();
            }
            arrayList.add(topView);
        }
        if (arrayList != null) {
            Collections.sort(arrayList, TOP_VIEW_OBJ_ID_COMPARATOR);
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public List getTVDiagramViews() {
        ArrayList<TopView> arrayList = null;
        for (TopView topView : this.topViews) {
            if (!(topView instanceof TVDiagramView)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<TopView>();
            }
            arrayList.add(topView);
        }
        if (arrayList != null) {
            Collections.sort(arrayList, TOP_VIEW_OBJ_ID_COMPARATOR);
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public List getTVConnectors() {
        ArrayList<TopView> arrayList = null;
        for (TopView topView : this.topViews) {
            if (!(topView instanceof TVConnector)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<TopView>();
            }
            arrayList.add(topView);
        }
        if (arrayList != null) {
            Collections.sort(arrayList, TOP_VIEW_OBJ_ID_COMPARATOR);
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean isMainDiagram() {
        return true;
    }

    public void registerForTreemodel(TopView topView) {
    }

    public void unregisterFromTreemodel(TopView topView) {
        this.unregisterTopView(topView);
    }

    public String getDPVId() {
        return this.dpvId;
    }

    public void setDPVId(String string) {
        Design design = this.getDesign();
        if (this.dpvId != null && !"".equals(this.dpvId)) {
            design.removeDesignPartView(this);
        }
        this.dpvId = string;
        if (design != null) {
            design.addDesignPartView(this);
        }
    }

    public String getGeneratorId() {
        return this.generatorId;
    }

    public void setGeneratorId(String string) {
        this.generatorId = string;
    }

    public boolean mustBeVisible() {
        return this.mustBeVisible;
    }

    public void setMustBeVisible(boolean bl) {
        this.mustBeVisible = bl;
    }

    public NamedTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new NamedTabbedPane(3);
            this.tabbedPane.setTabPlacement(3);
            this.tabbedPane.setDesignPartView(this);
            this.tabbedPane.setName(this.getName());
        }
        return this.tabbedPane;
    }

    @Override
    public void closeOperation(MouseEvent mouseEvent) {
    }

    public void updateInheritances(boolean bl) {
    }

    public DesignPartView getMasterDPV() {
        return this.masterSubview;
    }

    public void setMasterDPV(DesignPartView designPartView) {
        this.masterSubview = designPartView;
    }

    public boolean isMasterDPV() {
        return this.masterSubview == null;
    }

    public List getSubordinateViews() {
        return Collections.unmodifiableList(this.subordinateViews);
    }

    public abstract DesignPartView createSubordinateView(ApplicationView var1, DesignPart var2);

    private String createSubordinateViewName() {
        int n = this.subordinateViews.size() + 1;
        String string = "Display_" + n;
        DesignPartView designPartView = this.getDisplayByName(string);
        while (designPartView != null) {
            string = "Display_" + ++n;
            designPartView = this.getDisplayByName(string);
        }
        return string;
    }

    public DesignPartView addSubordinateView() {
        DesignPartView designPartView = this.createSubordinateView(this.getApplicationView(), this.getDesignPart());
        designPartView.setName(this.createSubordinateViewName());
        this.subordinateViews.add(designPartView);
        designPartView.setMasterDPV(this);
        this.getTabbedPane().add(designPartView);
        this.getTabbedPane().setSelectedComponent(designPartView);
        DesignPartViewPlaceHolder designPartViewPlaceHolder = new DesignPartViewPlaceHolder(this.getDesignPart(), designPartView);
        if (!this.displays.containsObject(designPartView)) {
            this.displays.add(designPartViewPlaceHolder);
            designPartViewPlaceHolder.setParent(this.displays);
        }
        designPartView.setDPVId(this.getDesign().getAppView().getIDGenerator().createNewID());
        designPartView.setDisplay(true);
        this.setDirty(true);
        return designPartView;
    }

    public void moveSubordinateView(DesignPartView designPartView, int n) {
        int n2 = this.getTabbedPane().indexOfComponent(designPartView);
        if (n2 == n) {
            this.moveInListSubordinateDPV(designPartView, n);
            return;
        }
        n2 = this.getTabbedPane().indexOfComponent(this);
        int n3 = n;
        if (n2 > -1) {
            n3 = n + 1;
        }
        if (designPartView.getMasterDPV() == this && n3 != 0) {
            this.getTabbedPane().remove(designPartView);
            this.getTabbedPane().add((Component)designPartView, n3);
            this.moveInListSubordinateDPV(designPartView, n);
        }
    }

    private void moveInListSubordinateDPV(DesignPartView designPartView, int n) {
        int n2 = this.subordinateViews.indexOf(designPartView);
        if (n2 == n) {
            return;
        }
        if (n2 > -1) {
            this.subordinateViews.remove(designPartView);
        }
        this.subordinateViews.add(n, designPartView);
    }

    public boolean isCurrentDPV() {
        Iterator iterator;
        DesignPartView designPartView = this.getApplicationView().getCurrentDPV();
        if (designPartView == this) {
            return true;
        }
        if (this.isMasterDPV()) {
            iterator = this.subordinateViews.iterator();
        } else {
            if (designPartView == this.getMasterDPV()) {
                return true;
            }
            iterator = this.getMasterDPV().getSubordinateViews().iterator();
        }
        while (iterator.hasNext()) {
            DesignPartView designPartView2 = (DesignPartView)iterator.next();
            if (designPartView2 != designPartView) continue;
            return true;
        }
        return false;
    }

    public void synchronizeSynonymWithDisplays(TopView topView) {
        DesignObject designObject = topView.getModel();
        ArrayList<DesignPartView> arrayList = new ArrayList<DesignPartView>();
        if (this.isMasterDPV()) {
            arrayList.addAll(this.getSubordinateViews());
        } else {
            arrayList.add(this.getMasterDPV());
            arrayList.addAll(this.getMasterDPV().getSubordinateViews());
        }
        for (DesignPartView designPartView : arrayList) {
            Rectangle rectangle;
            if (designPartView == this) continue;
            ContainerView containerView = (ContainerView)designObject.getFirstViewForDPV(designPartView);
            if (containerView == null || containerView != null && containerView.getCellView() == null) {
                if (containerView == null) {
                    containerView = (ContainerView)designPartView.createViewFor(designObject);
                    rectangle = topView.getCellView() != null ? topView.getCellView().getBounds().getBounds() : topView.getBounds();
                    containerView.setModel(designObject);
                    designPartView.registerForTreemodel(containerView);
                } else {
                    rectangle = topView.getCellView() != null ? topView.getCellView().getBounds().getBounds() : topView.getBounds();
                }
                containerView.setBounds(rectangle);
                designPartView.add(containerView, rectangle, null);
                if (containerView instanceof TVEntity) {
                    ((TVEntity)containerView).addTVRelations();
                    containerView.addTVTypeSubstitutions();
                    continue;
                }
                if (containerView instanceof TVTable) {
                    ((TVTable)containerView).addTVFKRelations();
                    continue;
                }
                if (!(containerView instanceof TVStructuredType)) continue;
                ((TVStructuredType)containerView).addTVRelations();
                ((TVStructuredType)containerView).addTVInheritances();
                continue;
            }
            if (containerView == null || containerView.getCellView() == null) continue;
            rectangle = topView.getCellView() != null ? topView.getCellView().getBounds().getBounds() : topView.getBounds();
            containerView.setBounds(rectangle);
        }
    }

    public void cascadeRemoveSynonymToDisplays(TopView topView) {
        DesignObject designObject = topView.getModel();
        ArrayList<DesignPartView> arrayList = new ArrayList<DesignPartView>();
        if (this.isMasterDPV()) {
            arrayList.addAll(this.getSubordinateViews());
        } else {
            arrayList.add(this.getMasterDPV());
            arrayList.addAll(this.getMasterDPV().getSubordinateViews());
        }
        for (DesignPartView designPartView : arrayList) {
            if (designPartView == this) continue;
            Object[] objectArray = designObject instanceof MultiShapedDesignObject ? ((MultiShapedDesignObject)designObject).getAllViews(designPartView).toArray() : ((AbstractDTObject)designObject).getAllViews(designPartView).toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ContainerView containerView = (ContainerView)objectArray[i];
                containerView.removeNoneCascade(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToDPV(DesignPartView designPartView) {
        try {
            designPartView.getUndoManager().setLocked(true);
            this.copyToDPV(designPartView, true);
        }
        finally {
            designPartView.getUndoManager().setLocked(false);
        }
    }

    public void copyToDPV(DesignPartView designPartView, boolean bl) {
        TopView topView;
        Object object;
        TopView topView2;
        int n;
        boolean bl2;
        designPartView.setAutoRoute(this.isAutoRoute());
        designPartView.setNotation(this.getNotation());
        designPartView.setBoxInBox(this.isBoxInBox());
        designPartView.setShowNamesOnly(this.isShowNamesOnly());
        designPartView.setShowElements(this.showElements());
        designPartView.setShowKeyElements(this.showKeyElements());
        designPartView.setShowDatatype(this.showDatatype());
        designPartView.setShowAllDetails(this.showAllDetails());
        designPartView.setShowKeys(this.showKeys());
        designPartView.setLegendPosX(this.getLegendPosX());
        designPartView.setLegendPosY(this.getLegendPosY());
        designPartView.setLegendAttributes(this.getLegendAttributes());
        boolean bl3 = bl2 = bl && !this.isAutoRoute();
        if (this.getDesignPart() != designPartView.getDesignPart()) {
            throw new RuntimeException(Messages.getString("DesignPartView.TargetDPVBelongsToDifferentesignPart"));
        }
        TreeMap<String, TopView> treeMap = new TreeMap<String, TopView>();
        Object[] objectArray = this.getTopviewsList().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            topView2 = (TopView)objectArray[n];
            if (topView2 instanceof TVLegend) {
                designPartView.setShowLegend(true);
                continue;
            }
            if (!(topView2 instanceof ContainerView)) continue;
            object = (ContainerView)topView2;
            topView = ((ContainerView)object).createViewSynonim(designPartView, false);
            this.getApplicationView().setGraphicalPropsFor(topView, this.getApplicationView().getGraphicalPropsFor((TopView)object));
            treeMap.put(((TopView)object).getViewID(), topView);
        }
        for (n = 0; n < objectArray.length; ++n) {
            Object object2;
            int n2;
            List list;
            List list2;
            topView2 = (TopView)objectArray[n];
            if (!topView2.isConnection() || !(topView2.getModel() instanceof ConnectionInterface)) continue;
            object = (ConnectionInterface)((Object)topView2.getModel());
            topView = object.getSourceTopView(this);
            TopView topView3 = object.getTargetTopView(this);
            TopView topView4 = (TopView)treeMap.get(topView.getViewID());
            TopView topView5 = (TopView)treeMap.get(topView3.getViewID());
            if (topView4 == null || topView5 == null) continue;
            object.setSourceTopView(topView4);
            object.setTargetTopView(topView5);
            object.getTargetTopView(designPartView);
            object.getSourceTopView(designPartView);
            if (!bl2) continue;
            TVConnector tVConnector = (TVConnector)topView2;
            TVConnector tVConnector2 = (TVConnector)object.getViewFor(designPartView);
            if (tVConnector2 == null) continue;
            EdgeView edgeView = null;
            if (tVConnector.getEdge() != null) {
                edgeView = (EdgeView)tVConnector.getEdge().getCellView();
            }
            if (edgeView != null) {
                list2 = edgeView.getPoints();
                list = tVConnector2.getEdgePoints();
                list.clear();
                for (n2 = 0; n2 < list2.size(); ++n2) {
                    object2 = list2.get(n2);
                    Point2D point2D = null;
                    if (object2 instanceof Point2D) {
                        point2D = (Point2D)object2;
                    } else if (object2 instanceof PortView) {
                        point2D = ((PortView)object2).getPoint();
                    }
                    if (point2D == null) continue;
                    list.add(DiagramConstants.createPoint(point2D.getX(), point2D.getY()));
                }
                if (tVConnector2.getEdge() == null || tVConnector2.getEdge().getCellView() == null) continue;
                Hashtable hashtable = new Hashtable();
                DiagramConstants.setPoints(hashtable, list);
                tVConnector2.getEdge().changeAttributes(hashtable);
                tVConnector2.getEdge().getCellView().update();
                if (list.size() != 2) continue;
                tVConnector2.getEdge().straightLine(false);
                continue;
            }
            list2 = tVConnector.getEdgePoints();
            list = tVConnector2.getEdgePoints();
            list.clear();
            for (n2 = 0; n2 < list2.size(); ++n2) {
                object2 = (Point2D)list2.get(n2);
                list.add(DiagramConstants.createPoint(((Point2D)object2).getX(), ((Point2D)object2).getY()));
            }
        }
        designPartView.setCurrentSelection(null);
    }

    public void registerTopView(TopView topView) {
        if (topView != null && !(topView instanceof TVLabel) && !this.topViews.contains(topView)) {
            this.topViews.add(topView);
        }
    }

    public void unregisterTopView(TopView topView) {
        if (topView != null) {
            this.topViews.remove(topView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean bl) {
        boolean bl2 = this.getUndoManager().isLocked();
        super.setVisible(bl);
        if (bl && !this.getDesign().isLoading() && !this.getDesign().isClosing()) {
            this.getUndoManager().setLocked(true);
            try {
                boolean bl3 = this.isDirty();
                boolean bl4 = false;
                ArrayList<TopView> arrayList = new ArrayList<TopView>();
                for (TopView topView : this.topViews) {
                    if (topView != null && topView instanceof TVConnector) {
                        arrayList.add(topView);
                        continue;
                    }
                    if (topView == null || (!this.isMainDiagram() || !topView.getModel().isVisible()) && this.isMainDiagram() || topView.getCellView() != null) continue;
                    this.add(topView, topView.getBounds());
                    bl4 = true;
                }
                for (TopView topView : arrayList) {
                    if ((!this.isMainDiagram() || !topView.getModel().isVisible()) && this.isMainDiagram() || topView.getCellView() != null) continue;
                    this.add(topView, topView.getBounds());
                    if (topView instanceof TVConnector) {
                        ((TVConnector)topView).resetEdgeParams();
                    }
                    bl4 = true;
                }
                if (bl4 && this.isAutoRoute()) {
                    this.getWorkSpace().updateSettings();
                }
                this.getWorkSpace().SendAllLinesToBack();
                if (!bl3) {
                    this.setDirty(bl3);
                }
            }
            finally {
                this.getUndoManager().setLocked(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean bl, ProgressDialog progressDialog) {
        TimeLog.log(MessageFormat.format(Messages.getString("DesignPartView.StartSetVisibleDPV"), this.getName()));
        super.setVisible(bl);
        this.getUndoManager().setLocked(true);
        try {
            boolean bl2 = this.isDirty();
            Iterator iterator = this.topViews.iterator();
            int n = this.topViews.size();
            boolean bl3 = false;
            int n2 = 5;
            int n3 = n / 20;
            if (n3 < 10) {
                n3 = 10;
                n2 = n / 10;
            }
            int n4 = 0;
            int n5 = 0;
            ArrayList<TopView> arrayList = new ArrayList<TopView>();
            while (iterator.hasNext()) {
                TopView topView = (TopView)iterator.next();
                if (topView != null && topView instanceof TVConnector) {
                    arrayList.add(topView);
                    continue;
                }
                if (topView == null || (!this.isMainDiagram() && (this.getMasterDPV() == null || !this.getMasterDPV().isMainDiagram) || !topView.getModel().isVisible()) && this.isMainDiagram() || topView.getCellView() != null) continue;
                this.add(topView, topView.getBounds());
                bl3 = true;
                if (++n4 != n3) continue;
                n4 = 0;
                progressDialog.setNote(MessageFormat.format(Messages.getString("DesignPartView.ShowObjects"), n5 * n2, "%"));
                progressDialog.setProgress(n5 * n2);
                ++n5;
            }
            for (TopView topView : arrayList) {
                if (topView == null || (!this.isMainDiagram() || !topView.getModel().isVisible()) && this.isMainDiagram() || topView.getCellView() != null) continue;
                this.add(topView, topView.getBounds());
                if (topView instanceof TVConnector) {
                    ((TVConnector)topView).resetEdgeParams();
                }
                bl3 = true;
                if (++n4 != n3) continue;
                n4 = 0;
                progressDialog.setNote(MessageFormat.format(Messages.getString("DesignPartView.ShowObjects"), n5 * n2, "%"));
                progressDialog.setProgress(n5 * n2);
                ++n5;
            }
            if (bl3 && this.isAutoRoute()) {
                this.getWorkSpace().updateSettings();
            }
            this.getWorkSpace().SendAllLinesToBack();
            if (!bl2) {
                this.setDirty(bl2);
            }
        }
        finally {
            this.getUndoManager().setLocked(false);
        }
        TimeLog.log(MessageFormat.format(Messages.getString("DesignPartView.EndSetVisibleDPV"), this.getName()));
    }

    public TopView getFirstViewFor(DesignObject designObject) {
        for (TopView topView : this.topViews) {
            if (topView.getModel() != designObject) continue;
            return topView;
        }
        return null;
    }

    public boolean canCreateDisplays() {
        return false;
    }

    public void updateSettings(boolean bl, boolean bl2) {
        if (bl) {
            this.setNotation(this.getApplicationView().getSettings().getNotation());
        }
        if (bl2) {
            this.setBoxInBox(this.getApplicationView().getSettings().isBoxInBox());
            this.updateInheritances(this.isBoxInBox());
        }
        this.updateDiagramSettings();
        if (this.isMasterDPV()) {
            for (DesignPartView designPartView : this.getSubordinateViews()) {
                designPartView.updateSettings(bl, bl2);
            }
        }
    }

    public void updateDiagramSettings() {
        Object[] objectArray = this.getTopviewsList().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            TopView topView = (TopView)objectArray[i];
            if (!topView.isConnection() || !(topView instanceof TVConnector)) continue;
            ((TVConnector)topView).resetEdgeParams();
            ((TVConnector)topView).displayLabels();
        }
        this.getWorkSpace().updateSettings();
        this.getWorkSpace().SendAllLinesToBack();
    }

    public void clearAllTopViews() {
        CellView[] cellViewArray = this.getWorkSpace().getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            TopView topView = ((DefaultDiagramCell)cellViewArray[i].getCell()).getTopView();
            if (topView == null) continue;
            topView.setCellView(null);
            if (topView.isConnection()) {
                ((ConnectionInterface)((Object)topView.getModel())).removeTopView(topView);
                continue;
            }
            if (topView instanceof ContainerView) {
                ((ContainerView)topView).remove(false);
                continue;
            }
            throw new RuntimeException(MessageFormat.format(Messages.getString("DesignPartView.TopViewCanNotBeProcessed"), topView.getClass()));
        }
        if (this.topViews.size() > 0) {
            this.topViews.clear();
        }
        this.modelToView.clear();
        this.workSpace.removeCells(this.workSpace.getRoots());
    }

    public void removeFromDisplays() {
        if (!this.isMasterDPV() && this.getMasterDPV() != null) {
            this.fireDeleted();
            this.getMasterDPV().subordinateViews.remove(this);
            this.getMasterDPV().displays.removePlaceHolderFor(this);
            this.getMasterDPV().getTabbedPane().remove(this);
            this.masterSubview = null;
            this.clearAllTopViews();
            this.getDesignPart().removeDesignPartListener(this);
            this.getDesign().removeDesignPartView(this);
            this.setDirty(true);
        }
    }

    public DesignPartView getDisplayByName(String string) {
        Object[] objectArray = this.subordinateViews.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignPartView designPartView = (DesignPartView)objectArray[i];
            if (!designPartView.getName().equalsIgnoreCase(string)) continue;
            return designPartView;
        }
        return null;
    }

    public DesignPartView getDisplayByID(String string) {
        Object[] objectArray = this.subordinateViews.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignPartView designPartView = (DesignPartView)objectArray[i];
            if (!designPartView.getDPVId().equalsIgnoreCase(string)) continue;
            return designPartView;
        }
        return null;
    }

    public void removeDisplay(DesignPartView designPartView) {
        if (designPartView.isDisplay()) {
            designPartView.removeFromDisplays();
        }
    }

    public void clearDPV() {
        if (this.isMasterDPV()) {
            Object[] objectArray = this.subordinateViews.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                DesignPartView designPartView = (DesignPartView)objectArray[i];
                designPartView.removeFromDisplays();
                this.subordinateViews.remove(designPartView);
            }
            this.clearAllTopViews();
        } else {
            this.removeFromDisplays();
        }
        this.setVisible(false);
        this.getWorkSpace().removeDiagramSelectionListener(this);
        this.undoManager.discardAllEdits();
    }

    public SubViewObjectSet getDisplays() {
        return this.displays;
    }

    public boolean isAutoRoute() {
        return this.autoRoute;
    }

    public void setAutoRoute(boolean bl) {
        this.autoRoute = bl;
    }

    public int getNotation() {
        return this.notation;
    }

    public void setNotation(int n) {
        if (this.notation != n) {
            this.notation = n;
            this.setDirty(true);
        }
    }

    public boolean isShowNamesOnly() {
        return this.showNamesOnly;
    }

    public void setShowNamesOnly(boolean bl) {
        this.showNamesOnly = bl;
    }

    public void setIsMainDiagram(boolean bl) {
        this.isMainDiagram = bl;
    }

    public abstract TopView createTopViewFor(DesignObject var1);

    public boolean showElements() {
        return this.showElements;
    }

    public void setShowElements(boolean bl) {
        this.showElements = bl;
    }

    public boolean showKeyElements() {
        return this.showKeyElements;
    }

    public void setShowKeyElements(boolean bl) {
        this.showKeyElements = bl;
    }

    public boolean showKeys() {
        return this.showKeys;
    }

    public void setShowKeys(boolean bl) {
        this.showKeys = bl;
    }

    public boolean showIndexes() {
        return this.showIndexes;
    }

    public void setShowIndexes(boolean bl) {
        this.showIndexes = bl;
    }

    public boolean showKeyAndIndexColumns() {
        return this.showKeyAndIndexColumns;
    }

    public void setShowKeyAndIndexColumns(boolean bl) {
        this.showKeyAndIndexColumns = bl;
    }

    public boolean showDatatype() {
        return this.showDatatype;
    }

    public void setShowDatatype(boolean bl) {
        this.showDatatype = bl;
    }

    public boolean showAllDetails() {
        return this.showAllDetails;
    }

    public void setShowAllDetails(boolean bl) {
        this.showAllDetails = bl;
    }

    public boolean showSchemaName() {
        return this.showSchemaName;
    }

    public void setShowSchemaName(boolean bl) {
        this.showSchemaName = bl;
    }

    public boolean canPaste() {
        return this.getController().canPaste();
    }

    public abstract JPopupMenu getPopupMenu();

    public abstract JMenu getDetailsMenu();

    public boolean isBoxInBox() {
        return this.boxInBox;
    }

    public void setBoxInBox(boolean bl) {
        this.boxInBox = bl;
    }

    public void addDiagramViewListener(DiagramViewListener diagramViewListener) {
        this.dvListeners.add(diagramViewListener);
    }

    public void removeDiagramViewListener(DiagramViewListener diagramViewListener) {
        this.dvListeners.remove(diagramViewListener);
    }

    public void fireDeleted() {
        DiagramViewListener[] diagramViewListenerArray = this.dvListeners.toArray(new DiagramViewListener[0]);
        for (int i = 0; i < diagramViewListenerArray.length; ++i) {
            DiagramViewListener diagramViewListener = diagramViewListenerArray[i];
            diagramViewListener.designPartViewDeleted(this);
        }
    }

    public DesignPartView getLastContainerDiagram() {
        return this.lastContainerDiagram;
    }

    public void setLastContainerDiagram(DesignPartView designPartView) {
        String string = designPartView.isMasterDPV() ? designPartView.getDPVId() : designPartView.getMasterDPV().getDPVId();
        this.backLinksMap.put(string, designPartView);
        this.lastContainerDiagram = designPartView;
    }

    private void getDigramListeners(List list) {
        for (Object e : this.dvListeners) {
            if (list.contains(e)) continue;
            list.add(e);
        }
    }

    private List getDiagramListenersForAllDisplays() {
        if (!this.isMasterDPV()) {
            return this.getMasterDPV().getDiagramListenersForAllDisplays();
        }
        ArrayList arrayList = new ArrayList();
        this.getDigramListeners(arrayList);
        for (DesignPartView designPartView : this.getSubordinateViews()) {
            designPartView.getDigramListeners(arrayList);
        }
        return arrayList;
    }

    private List getMainContainerDiagrams() {
        Object object2;
        ArrayList<DesignPartView> arrayList = new ArrayList<DesignPartView>();
        for (Object object2 : this.getDiagramListenersForAllDisplays()) {
            if (!(object2 instanceof DiagramView)) continue;
            List list = ((DiagramView)object2).getAllViewsWithCellViews();
            for (int i = 0; i < list.size(); ++i) {
                TopView topView = (TopView)list.get(i);
                DesignPartView designPartView = topView.getDesignPartView();
                if (!designPartView.isMasterDPV()) {
                    designPartView = designPartView.getMasterDPV();
                }
                if (arrayList.contains(designPartView)) continue;
                arrayList.add(designPartView);
            }
        }
        object2 = this.getLastAccomodatingDiagram(arrayList);
        if (object2 != null && arrayList.remove(object2)) {
            arrayList.add(0, (DesignPartView)object2);
        }
        return arrayList;
    }

    private Object getLastAccomodatingDiagram(List list) {
        if (this.lastContainerDiagram == null && !this.isMasterDPV()) {
            this.lastContainerDiagram = this.getMasterDPV().lastContainerDiagram;
        }
        if (this.lastContainerDiagram != null && list.size() > 0) {
            DesignPartView designPartView = this.lastContainerDiagram;
            if (!this.lastContainerDiagram.isMasterDPV()) {
                designPartView = this.lastContainerDiagram.getMasterDPV();
            }
            for (DesignPartView designPartView2 : list) {
                if (designPartView2 != designPartView) continue;
                return designPartView2;
            }
        }
        return null;
    }

    public JMenu getGoToDiagramMenu() {
        JMenu jMenu = new JMenu(GO_TO_MENU);
        List list = this.getMainContainerDiagrams();
        if (list.size() > 0) {
            Collections.sort(list, DPV_NAME_COMPARATOR);
            for (DesignPartView designPartView : list) {
                DesignPartView designPartView2 = (DesignPartView)this.backLinksMap.get(designPartView.getDPVId());
                if (designPartView2 == null) {
                    designPartView2 = designPartView;
                }
                jMenu.add(new GoToAction(designPartView.getName(), designPartView2));
            }
        } else {
            jMenu.setEnabled(false);
        }
        return jMenu;
    }

    public JMenuItem getStraightenLinesItem() {
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction(DefaultDiagramCell.STRAIGHT_LINE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DesignPartView.this.straightenLines();
            }
        });
        return jMenuItem;
    }

    public void straightenLines(boolean bl) {
        this.straightenLines(bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void straightenLines(boolean bl, boolean bl2) {
        if (bl) {
            this.startAutoLayoutEdit(DefaultDiagramCell.STRAIGHT_LINE + " of " + this.getName());
        }
        try {
            Object[] objectArray = this.getWorkSpace().getEdges();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof DefaultEdge)) continue;
                ((DefaultEdge)objectArray[i]).straightLine(false, bl2);
            }
        }
        finally {
            if (bl) {
                this.stopAutoLayoutEdit();
            }
        }
    }

    public void straightenLines() {
        this.straightenLines(true);
    }

    protected boolean isEditable() {
        if (this.isReadOnly()) {
            return false;
        }
        if (ApplicationView.IS_VIEWER && !this.getDesign().isNewDesign()) {
            return false;
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            return this instanceof DPVLogical;
        }
        return true;
    }

    public String getImportedId() {
        return this.importedId;
    }

    public void setImportedId(String string) {
        if (string != null && string.equals(this.importedId)) {
            return;
        }
        this.importedId = string;
    }

    public void setZeroLayout() {
    }

    public boolean clearDetails() {
        return this.workSpace.clearDetails();
    }

    @Override
    public void valueChanged(DiagramSelectionEvent diagramSelectionEvent) {
        Object[] objectArray = diagramSelectionEvent.getCells();
        for (int i = 0; i < objectArray.length; ++i) {
            DefaultDiagramCell defaultDiagramCell;
            Object object = objectArray[i];
            if (object instanceof DefaultEdge) {
                defaultDiagramCell = (DefaultEdge)object;
                if (diagramSelectionEvent.isAddedCell(i)) {
                    ((TVConnector)defaultDiagramCell.getTopView()).connectLabels();
                } else {
                    ((TVConnector)defaultDiagramCell.getTopView()).disconnectLabels();
                }
            } else if (object instanceof LabelDiagramCell) {
                defaultDiagramCell = (LabelDiagramCell)object;
                if (diagramSelectionEvent.isAddedCell(i)) {
                    ((EdgeView)((LabelDiagramCell)defaultDiagramCell).getLabel().getTVConnector().getCellView()).setWiderLine(true);
                } else {
                    ((EdgeView)((LabelDiagramCell)defaultDiagramCell).getLabel().getTVConnector().getCellView()).setWiderLine(false);
                }
            }
            this.selectDelegate.fireSelectionChanged();
        }
    }

    public static void copyDisplayDrawingProperties(DesignPartView designPartView, DesignPartView designPartView2) {
        if (designPartView2.getTopviewsList().size() == 0) {
            designPartView2.setAutoRoute(designPartView.isAutoRoute());
            designPartView2.setBoxInBox(designPartView.isBoxInBox());
            designPartView2.setShowAllDetails(designPartView.showAllDetails());
            designPartView2.setShowNamesOnly(designPartView.isShowNamesOnly());
            designPartView2.setShowDatatype(designPartView.showDatatype());
            designPartView2.setShowElements(designPartView.showElements());
            designPartView2.setShowKeyElements(designPartView.showKeyElements());
            designPartView2.setShowKeys(designPartView.showKeys());
            designPartView2.setNotation(designPartView.getNotation());
        }
    }

    public static void copyConnectionPoints(TVConnector tVConnector, TVConnector tVConnector2) {
        block4: {
            if (tVConnector2 == null || tVConnector == null || tVConnector2.getDesignPartView().isAutoRoute()) break block4;
            tVConnector2.removeConnection();
            if (tVConnector.getEdge() != null) {
                EdgeView edgeView = (EdgeView)tVConnector.getEdge().getCellView();
                List list = edgeView.getPoints();
                List list2 = tVConnector2.getEdgePoints();
                list2.clear();
                for (int i = 0; i < list.size(); ++i) {
                    Point2D point2D = edgeView.getPoint(i);
                    list2.add(DiagramConstants.createPoint(point2D.getX(), point2D.getY()));
                }
            } else {
                List list = tVConnector.getEdgePoints();
                List list3 = tVConnector2.getEdgePoints();
                list3.clear();
                for (int i = 0; i < list.size(); ++i) {
                    Point2D point2D = (Point2D)list.get(i);
                    list3.add(DiagramConstants.createPoint(point2D.getX(), point2D.getY()));
                }
            }
        }
    }

    protected List getCellsFromObjects(List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (DesignObject designObject : list) {
            Object object;
            TopView topView = designObject.getFirstViewForDPV(this);
            if (topView == null || topView.getCellView() == null || (object = topView.getCellView().getCell()) == null || arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    protected void addUndoRedo(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = new JMenuItem(this.getUndoManager().getUndoPresentationName());
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DesignPartView.this.getUndoManager().undo();
            }
        });
        jPopupMenu.add(jMenuItem);
        jMenuItem.setEnabled(this.getUndoManager().canUndo());
        JMenuItem jMenuItem2 = new JMenuItem(this.getUndoManager().getRedoPresentationName());
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DesignPartView.this.getUndoManager().redo();
            }
        });
        jPopupMenu.add(jMenuItem2);
        jMenuItem2.setEnabled(this.getUndoManager().canRedo());
        JMenu jMenu = new JMenu(Messages.getString("DesignPartView.UndoTo"));
        jPopupMenu.add(jMenu);
        List<UndoableEdit> list = this.getUndoManager().getUndoList();
        if (list.size() > 0) {
            for (final UndoableEdit object : list) {
                jMenuItem = new JMenuItem(object.getUndoPresentationName());
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DesignPartView.this.getUndoManager().undoToEdit(object);
                    }
                });
                jMenu.add(jMenuItem);
            }
        } else {
            jMenu.setEnabled(false);
        }
        JMenu jMenu2 = new JMenu(Messages.getString("DesignPartView.RedoTo"));
        jPopupMenu.add(jMenu2);
        list = this.getUndoManager().getRedoList();
        if (list.size() > 0) {
            for (final UndoableEdit undoableEdit : list) {
                jMenuItem2 = new JMenuItem(undoableEdit.getRedoPresentationName());
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DesignPartView.this.getUndoManager().redoToEdit(undoableEdit);
                    }
                });
                jMenu2.add(jMenuItem2);
            }
        } else {
            jMenu2.setEnabled(false);
        }
    }

    public DP_UndoManager getUndoManager() {
        return this.undoManager;
    }

    public boolean isCommandInProgress() {
        return this.commandInProgress;
    }

    public void setCommandInProgress(boolean bl) {
        this.commandInProgress = bl;
    }

    public void restoreTopview(TopView topView, DesignObject designObject) {
        this.registerTopView(topView);
        topView.setModel(designObject);
        this.registerForTreemodel(topView);
        if (this.modelToView.get(designObject) == null) {
            this.modelToView.put(designObject, topView);
        }
        if (topView.getCellView() != null && topView.getCellView().getCell() != null && !topView.isConnection()) {
            this.getWorkSpace().addContainer((DefaultDiagramCell)topView.getCellView().getCell(), topView.getBounds());
            if (designObject instanceof FKArc || designObject instanceof Arc) {
                this.getWorkSpace().getDiagramLayoutCache().toBack(new Object[]{topView.getCellView().getCell()});
            }
        }
    }

    public List getTVConnectorsFor(TopView topView) {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.topViews) {
            TVConnector tVConnector;
            if (!(e instanceof TVConnector) || (tVConnector = (TVConnector)e).getSourceTopView() != topView && tVConnector.getTargetTopView() != topView) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public void postTopViewRemove(TopView topView) {
        TopViewRemoveEdit topViewRemoveEdit = new TopViewRemoveEdit(topView);
        topViewRemoveEdit.end();
        this.getUndoManager().addEdit(topViewRemoveEdit);
    }

    @Override
    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    public void startAutoLayoutEdit(String string) {
        this.inLayoutEdit = true;
        this.autoLayoutEdit = new AutoLayoutEdit(string);
    }

    public void stopAutoLayoutEdit() {
        this.inLayoutEdit = false;
        this.autoLayoutEdit.end();
        this.getUndoManager().addEdit(this.autoLayoutEdit);
        this.autoLayoutEdit = null;
    }

    public void removeTopViewsWithUndo(Object[] objectArray) {
        List list = this.filterObjects(objectArray);
        DesignObject designObject = this.getFirstDesignObject(list);
        Object[] objectArray2 = list.toArray();
        if (objectArray2.length > 0 && designObject != null) {
            GroupRemoveEdit groupRemoveEdit = new GroupRemoveEdit(designObject, "Redo Delete of " + objectArray2.length + " Views", "Undo Delete of " + objectArray2.length + " Views");
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object = objectArray2[i];
                if (!(object instanceof ContainerView)) continue;
                ContainerView containerView = (ContainerView)object;
                TopViewRemoveEdit.addUndoableRemoveEditForObject((CompoundEdit)groupRemoveEdit, containerView);
                containerView.remove(false);
            }
            groupRemoveEdit.end();
            if (groupRemoveEdit.getNumberOfEdits() > 0) {
                designObject.getDesignPart().postUndoableEdit(groupRemoveEdit);
            }
        }
    }

    private List filterObjects(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Object object2 = objectArray[i];
            if (object instanceof DefaultDiagramCell) {
                object2 = ((DefaultDiagramCell)object).getTopView();
            }
            if (object2 == null || !(object2 instanceof ContainerView) || object2 instanceof TVNote || !((ContainerView)object2).canRemove() || arrayList.contains(object2)) continue;
            arrayList.add(object2);
        }
        return arrayList;
    }

    private DesignObject getFirstDesignObject(List list) {
        for (Object e : list) {
            if (e instanceof DesignObject) {
                return (DesignObject)e;
            }
            if (!(e instanceof TopView)) continue;
            return ((TopView)e).getModel();
        }
        return null;
    }

    @Override
    public void setRepositoryOID(String string) {
        this.repositoryOID = string;
    }

    @Override
    public String getRepositoryOVID() {
        return this.repositoryOVID;
    }

    @Override
    public void setRepositoryOVID(String string) {
        this.repositoryOVID = string;
    }

    @Override
    public boolean isCheckedOut() {
        DesignPartView designPartView = this.getMasterDPV();
        if (designPartView != null) {
            return designPartView.isCheckedOut();
        }
        return this.checkedOut;
    }

    public boolean isReadOnly() {
        if (this.getRepositoryOID() != null && this.getDesignPart().getDesign().isLoadFromDB()) {
            return !this.isCheckedOutByMe();
        }
        return false;
    }

    @Override
    public void setCheckedOut(boolean bl) {
        this.checkedOut = bl;
    }

    @Override
    public String getCheckedOutBy() {
        DesignPartView designPartView = this.getMasterDPV();
        if (designPartView != null) {
            return designPartView.getCheckedOutBy();
        }
        return this.checkedOutBy;
    }

    @Override
    public void setCheckedOutBy(String string) {
        this.checkedOutBy = string;
    }

    @Override
    public boolean isCheckedOutByMe() {
        DesignPartView designPartView = this.getMasterDPV();
        if (designPartView != null) {
            return designPartView.isCheckedOutByMe();
        }
        return this.checkedOutByMe;
    }

    @Override
    public void setCheckedOutByMe(boolean bl) {
        this.checkedOutByMe = bl;
        Diagram diagram = this.getWorkSpace();
        diagram.setMoveable(bl);
        diagram.setSizeable(bl);
        for (DesignPartView designPartView : this.getSubordinateViews()) {
            diagram = designPartView.getWorkSpace();
            diagram.setMoveable(bl);
            diagram.setSizeable(bl);
        }
    }

    @Override
    public boolean isDirty() {
        for (DesignPartView designPartView : this.getSubordinateViews()) {
            if (!designPartView.isDirty()) continue;
            return true;
        }
        return this.dirty;
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
        if (!bl && this.isMasterDPV()) {
            for (DesignPartView designPartView : this.getSubordinateViews()) {
                designPartView.setDirty(false);
            }
        }
        if (bl) {
            this.getSummaryInfoObject().getChange().setTimeNow();
            this.getSummaryInfoObject().getChange().setUser(MDUserFactory.getInstance().getCurrentUser());
        }
    }

    @Override
    public boolean canBedeleted() {
        if (this.getDesign().isRepositoryRelated()) {
            return this.getDesignPart().isCheckedOutByMe();
        }
        return true;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        return this.pac_Element;
    }

    @Override
    public boolean isPAC_Element() {
        return true;
    }

    @Override
    public void setPAC_Element(RepositoryObject repositoryObject) {
        this.pac_Element = repositoryObject;
    }

    public boolean isStorable() {
        return true;
    }

    public boolean isDisplay() {
        return this.display;
    }

    public void setDisplay(boolean bl) {
        this.display = bl;
    }

    public void closeEditor() {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                if (this.context != null) {
                    List list = EditorManager.getEditorManager().findEditors(this.context);
                    EditorManager.getEditorManager().closeEditors(list);
                    this.context = null;
                    if (this.tabbedPane != null) {
                        this.tabbedPane.removeAll();
                        this.tabbedPane.setDesignPartView(null);
                    }
                    this.tabbedPane = null;
                    EditorManager.getEditorManager().activateCurrentEditorFrame();
                }
            }
            catch (Exception exception) {
                LOGGER.warn(exception.getMessage(), exception);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (DesignPartView.this.context != null) {
                            List list = EditorManager.getEditorManager().findEditors(DesignPartView.this.context);
                            EditorManager.getEditorManager().closeEditors(list);
                            DesignPartView.this.context = null;
                            if (DesignPartView.this.tabbedPane != null) {
                                DesignPartView.this.tabbedPane.removeAll();
                                DesignPartView.this.tabbedPane.setDesignPartView(null);
                            }
                            DesignPartView.this.tabbedPane = null;
                            EditorManager.getEditorManager().activateCurrentEditorFrame();
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn(exception.getMessage(), exception);
                    }
                }
            });
        }
    }

    public boolean isEditorVisible() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.context != null) {
                List list = EditorManager.getEditorManager().findEditors(this.context);
                return list.size() > 0;
            }
        } else if (this.context != null) {
            FindEditorRunner findEditorRunner = new FindEditorRunner(this.context);
            SwingUtilities.invokeLater(findEditorRunner);
            while (!findEditorRunner.isFinished()) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            }
            return findEditorRunner.editorsFound();
        }
        return false;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean activateEditor() {
        if (SwingUtilities.isEventDispatchThread()) {
            List list;
            if (this.getContext() != null && (list = EditorManager.getEditorManager().findEditors(this.getContext())).size() > 0) {
                DMDiagramEditor dMDiagramEditor = (DMDiagramEditor)((Object)list.get(0));
                for (EditorInfo editorInfo : EditorManager.getEditorManager().getEditorsInfo()) {
                    if (editorInfo._getEditor() != dMDiagramEditor) continue;
                    EditorManager.getEditorManager().activateEditor(editorInfo);
                    this.getApplicationView().editorChanged(this);
                    return true;
                }
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    List list;
                    if (DesignPartView.this.getContext() != null && (list = EditorManager.getEditorManager().findEditors(DesignPartView.this.getContext())).size() > 0) {
                        DMDiagramEditor dMDiagramEditor = (DMDiagramEditor)((Object)list.get(0));
                        for (EditorInfo editorInfo : EditorManager.getEditorManager().getEditorsInfo()) {
                            if (editorInfo._getEditor() != dMDiagramEditor) continue;
                            EditorManager.getEditorManager().activateEditor(editorInfo);
                            DesignPartView.this.getApplicationView().editorChanged(DesignPartView.this);
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public Design getDesign() {
        if (this.designPart != null) {
            return this.designPart.getDesign();
        }
        return super.getDesign();
    }

    public String getComment() {
        if (this.getPlaceHolder() != null) {
            return this.getPlaceHolder().getComment();
        }
        return "";
    }

    public void setComment(String string) {
        if (this.getPlaceHolder() != null) {
            this.getPlaceHolder().setComment(string);
        }
    }

    public String getNotes() {
        if (this.getPlaceHolder() != null) {
            return this.getPlaceHolder().getNotes();
        }
        return "";
    }

    public void setNotes(String string) {
        if (this.getPlaceHolder() != null) {
            this.getPlaceHolder().setNotes(string);
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "subviews/" + this.getDPVId() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getStoragePath() {
        return null;
    }

    public TopView createTopViewForGlobal(DesignObject designObject) {
        return this.createTopViewFor(designObject);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    protected void addSubViewAndDisplayMenus(JPopupMenu jPopupMenu) {
        jPopupMenu.add(new AbstractAction(MI_CREATE_SUBVIEW){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DesignPartView.this.getApplicationView().createSubview(DesignPartView.this);
            }
        });
        jPopupMenu.addSeparator();
        if (!this.isMainDiagram()) {
            jPopupMenu.add(new AbstractAction(MI_DELETE_SUBVIEW){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DesignPartView.this.isMasterDPV()) {
                        DesignPartView.this.getDesignPart().deleteSubview(DesignPartView.this);
                    } else {
                        DesignPartView.this.getDesignPart().deleteSubview(DesignPartView.this.getMasterDPV());
                    }
                }
            });
            jPopupMenu.addSeparator();
        }
        if (this.isMasterDPV()) {
            jPopupMenu.add(new AbstractAction(MI_CREATE_DISPLAY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DesignPartView designPartView = DesignPartView.this.addSubordinateView();
                    DesignPartView.this.copyToDPV(designPartView);
                    DesignPartView.this.getTabbedPane().setSelectedComponent(designPartView);
                }
            });
            jPopupMenu.addSeparator();
        } else {
            jPopupMenu.add(new AbstractAction(MI_CREATE_DISPLAY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DesignPartView designPartView = DesignPartView.this.getMasterDPV().addSubordinateView();
                    DesignPartView.this.copyToDPV(designPartView);
                    DesignPartView.this.getMasterDPV().getTabbedPane().setSelectedComponent(designPartView);
                }
            });
            jPopupMenu.addSeparator();
            jPopupMenu.add(new AbstractAction(MI_DELETE_DISPLAY){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DesignPartView.this.removeFromDisplays();
                }
            });
            jPopupMenu.addSeparator();
        }
    }

    @Override
    public void designChanged(DesignEvent designEvent) {
        if (designEvent.isType(DesignEvent.NAME_CHANGED) && this.context != null) {
            RenameMessage.fireObjectRenamed((Node)this.getContext().getNode(), (URL)this.getContext().getNode().getURL(), (Node)this.getContext().getNode(), (Context)this.context);
        }
    }

    public LegendSet getLegendSet() {
        if (this.legendSet == null) {
            this.legendSet = new LegendSet(this.getDesignPart());
            this.legendSet.setDesign(this.getDesign());
            this.legendSet.setName("LegendSet");
            this.legendSet.setParent(this.getDesignPart());
            this.legendSet.addSetListener(this.getDesignPart());
        }
        return this.legendSet;
    }

    public boolean showLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean bl) {
        this.showLegend = bl;
        if (bl) {
            if (this.legend == null) {
                this.legend = this.getLegendSet().createLegend(this);
                TopView topView = this.legend.getFirstViewForDPV(this);
                if (topView == null) {
                    topView = this.createTopViewFor(this.legend);
                }
                if (topView != null && topView.getCellView() != null) {
                    topView.getCellView().setNewBounds(new Rectangle(new Point(this.legendPosX, this.legendPosY), this.legend.getSize()), false);
                }
            }
        } else if (this.legend != null) {
            this.legend.remove();
            this.legend = null;
        }
    }

    public void updateLegendPosition() {
        try {
            TopView topView;
            if (this.legend != null && (topView = this.legend.getFirstViewForDPV(this)) != null && topView.getCellView() != null) {
                this.legendPosX = topView.getCellView().getBounds().getBounds().x;
                this.legendPosY = topView.getCellView().getBounds().getBounds().y;
            }
        }
        catch (Exception exception) {
            LOGGER.warn(exception.getMessage(), exception);
        }
    }

    public void updateLegendSize() {
        try {
            TopView topView;
            if (this.legend != null && (topView = this.legend.getFirstViewForDPV(this)) != null && topView.getCellView() != null) {
                Dimension dimension = this.legend.getSize();
                double d = topView.getCellView().getBounds().getX();
                double d2 = topView.getCellView().getBounds().getY();
                topView.getCellView().setNewBounds(new Rectangle((int)d, (int)d2, dimension.width, dimension.height));
            }
        }
        catch (Exception exception) {
            LOGGER.warn(exception.getMessage(), exception);
        }
    }

    public int getLegendPosX() {
        return this.legendPosX;
    }

    public void setLegendPosX(int n) {
        this.legendPosX = n;
    }

    public int getLegendPosY() {
        return this.legendPosY;
    }

    public void setLegendPosY(int n) {
        this.legendPosY = n;
    }

    private ModelIDObject getSummaryInfoObject() {
        if (this.isMainDiagram() && this.isMasterDPV()) {
            return this.getDesignPart().getMainDPVPlaceHolder();
        }
        return this.getPlaceHolder();
    }

    public String getCreatedBy() {
        return this.getSummaryInfoObject().getCreator().getName();
    }

    public void setCreatedBy(String string) {
        if (string == null || string.length() == 0) {
            this.getSummaryInfoObject().getCreation().setUser(MDUserFactory.getInstance().getUser(this.getDesignPart().getCreatedBy()));
        } else {
            this.getSummaryInfoObject().getCreation().setUser(MDUserFactory.getInstance().getUser(string));
        }
    }

    public String getChangedBy() {
        return this.getSummaryInfoObject().getChanger().getName();
    }

    public void setChangedBy(String string) {
        if (string == null || string.length() == 0) {
            this.getSummaryInfoObject().getChange().setUser(MDUserFactory.getInstance().getUser(this.getDesignPart().getChangedBy()));
        } else {
            this.getSummaryInfoObject().getChange().setUser(MDUserFactory.getInstance().getUser(string));
        }
    }

    public String getCreatedTime() {
        return this.getSummaryInfoObject().getCreation().getTimeString("UTC");
    }

    public void setCreatedTime(String string) {
        if (string == null || string.length() == 0) {
            this.getSummaryInfoObject().getCreation().setTimeString(this.getDesignPart().getCreatedTime());
        } else {
            this.getSummaryInfoObject().getCreation().setTimeString(string);
        }
    }

    public String getChangedTime() {
        return this.getSummaryInfoObject().getChange().getTimeString("UTC");
    }

    public void setChangedTime(String string) {
        if (string == null || string.length() == 0) {
            this.getSummaryInfoObject().getChange().setTimeString(this.getDesignPart().getChangedTime());
        } else {
            this.getSummaryInfoObject().getChange().setTimeString(string);
        }
    }

    public boolean showLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean bl) {
        this.showLabels = bl;
        this.updateDiagramSettings();
    }

    public void clearLables() {
        Object[] objectArray = this.getWorkSpace().getEdges();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof DefaultEdge)) continue;
            ((DefaultEdge)objectArray[i]).clearLabels();
        }
    }

    public boolean isShowLabelsChanging() {
        return this.showLabelsChanging;
    }

    public void setShowLabelsChanging(boolean bl) {
        this.showLabelsChanging = bl;
    }

    public boolean showGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean bl) {
        this.showGrid = bl;
        this.getWorkSpace().updateSettings();
    }

    public Color getDiagramColor() {
        return this.diagramColor;
    }

    public void setDiagramColor(Color color) {
        this.diagramColor = color;
        this.getWorkSpace().updateSettings();
    }

    protected void changeDiagramColor() {
        Color color = new ColorChooserDialog((Dialog)new JDialog((Frame)Ide.getMainWindow(), Messages.getString("DesignPartView.SelectColor"), true), Messages.getString("DesignPartView.SelectColor"), this.getDiagramColor()).showDialog();
        if (color != null) {
            this.setDiagramColor(color);
        }
    }

    public FontMetrics getFontMetrics(TopView topView) {
        try {
            if (topView.getModel() instanceof EditableFonts) {
                Font font = ((EditableFonts)((Object)topView.getModel())).getFontObject(EditableFonts.FO_TITLE).getFont();
                return this.getFontMetrics(font);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getWorkSpace().getGraphics().getFontMetrics();
    }

    public void clearCellRefsToObjects() {
        EdgeView.renderer = new EdgeRenderer();
        CellView[] cellViewArray = this.getWorkSpace().getDiagramLayoutCache().getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            Object object = cellViewArray[i];
            ((DefaultDiagramCell)object.getCell()).setTopView(null);
        }
        this.getWorkSpace().setDPVtoNull();
        if (this.isMasterDPV()) {
            for (Object object : this.getSubordinateViews()) {
                ((DesignPartView)object).clearCellRefsToObjects();
            }
        }
    }

    public int getLegendAttributes() {
        return this.legendAttributes;
    }

    public void setLegendAttributes(int n) {
        this.legendAttributes = n;
    }

    public void sync(boolean bl, Object[] objectArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObject designObject = (DesignObject)objectArray[i];
            if (!(designObject instanceof Table) && !(designObject instanceof TableView)) continue;
            hashMap.put(designObject.getObjectID(), designObject.getObjectID());
        }
        if (hashMap.size() > 0) {
            SyncUtils.syncDataDictionary((RelationalDesign)this.getDesignPart(), bl, hashMap);
        }
    }

    public SchemaObject getSchemaObject() {
        return this.schemaObject;
    }

    public void setSchemaObject(SchemaObject schemaObject) {
        this.schemaObject = schemaObject;
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        Design design = this.getDesign();
        if (design != null) {
            DesignObject designObject = design.getDesignObject(string2);
            if (designObject == null) {
                Map map = design.getCorrespondenceMap();
                if (map != null) {
                    return map.get(string2);
                }
            } else {
                return designObject;
            }
        }
        return null;
    }

    @Override
    public String translateObjectToID(String string, Object object) {
        if (object != null && object instanceof ModelIDObject) {
            return ((ModelIDObject)object).getObjectID();
        }
        return null;
    }

    static class TopViewObIDComparator
    implements Comparator {
        TopViewObIDComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof TopView && object2 instanceof TopView) {
                TopView topView = (TopView)object;
                TopView topView2 = (TopView)object2;
                String string = topView.getModel().getObjectID() + topView.getViewNumber();
                String string2 = topView2.getModel().getObjectID() + topView2.getViewNumber();
                return string.compareTo(string2);
            }
            return 0;
        }
    }

    static class DesignPartViewNameComparator
    implements Comparator {
        DesignPartViewNameComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((DesignPartView)object).getName().compareToIgnoreCase(((DesignPartView)object2).getName());
        }
    }

    class AutoLayoutEdit
    extends CompoundEdit {
        boolean auto = false;
        String name = "AutoLayout";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            DesignPartView.this.getUndoManager().setLocked(true);
            try {
                DesignPartView.this.straightenLines(false, false);
            }
            finally {
                DesignPartView.this.getUndoManager().setLocked(false);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
        }

        AutoLayoutEdit(String string) {
            if (string != null && !"".equals(string)) {
                this.name = string;
            }
            this.auto = DesignPartView.this.isAutoRoute();
        }

        @Override
        public String getRedoPresentationName() {
            return MessageFormat.format(Messages.getString("DesignPartView.Redo"), this.name);
        }

        @Override
        public String getUndoPresentationName() {
            return MessageFormat.format(Messages.getString("DesignPartView.Undo"), this.name);
        }
    }

    class GoToAction
    extends AbstractAction {
        DesignPartView dpv;

        GoToAction(String string, DesignPartView designPartView2) {
            super(string);
            this.dpv = designPartView2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dpv != null && this.dpv.getDesignPart().isLoaded()) {
                DesignPartView designPartView;
                NamedTabbedPane namedTabbedPane;
                if (this.dpv.isMasterDPV()) {
                    namedTabbedPane = this.dpv.getTabbedPane();
                    designPartView = this.dpv;
                } else {
                    namedTabbedPane = this.dpv.getMasterDPV().getTabbedPane();
                    designPartView = this.dpv.getMasterDPV();
                }
                if (designPartView.getContext() != null) {
                    if (designPartView.activateEditor()) {
                        if (namedTabbedPane != null) {
                            namedTabbedPane.setSelectedComponent(this.dpv);
                        }
                        return;
                    }
                } else if (designPartView == this.dpv.getDesignPart().getMainView()) {
                    this.dpv.getDesignPart().setMainViewVisible(true);
                } else {
                    designPartView.getPlaceHolder().setVisible(true);
                }
                if (namedTabbedPane.indexOfComponent(this.dpv) > -1 && namedTabbedPane.indexOfComponent(designPartView) > -1) {
                    namedTabbedPane.setSelectedComponent(designPartView);
                    namedTabbedPane.setSelectedComponent(this.dpv);
                }
            }
        }
    }

    public class NamedTabbedPane
    extends JSelectedTabbedPane {
        String tname;
        DesignPartView designPartView;

        public NamedTabbedPane(int n) {
            super(n);
            this.tname = "";
        }

        @Override
        public String getName() {
            return this.tname;
        }

        @Override
        public void setName(String string) {
            this.tname = string;
        }

        @Override
        public String toString() {
            return this.getName();
        }

        public DesignPartView getDesignPartView() {
            return this.designPartView;
        }

        public void setDesignPartView(DesignPartView designPartView) {
            this.designPartView = designPartView;
        }
    }

    private class TopViewInitializer
    implements PointsEnteredCallback {
        private TopView view;
        private boolean done = false;

        protected TopViewInitializer(TopView topView) {
            this.view = topView;
            DesignPartView.this.getGlassPane().getSinglePoint(this);
            DesignPartView.this.getGlassPane().getRectangle(this);
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
            this.view.setSize(DesignPartView.this.insureMinimal(rectangle.getSize()));
            this.view.setLocation(rectangle.getLocation());
            this.done = true;
        }

        @Override
        public void pointSelected(Point point) {
            this.view.setLocation(point);
            this.done = true;
        }

        public void addAnyWay() {
        }

        public boolean isDone() {
            return this.done;
        }

        @Override
        public void pointsSelected(Point[] pointArray) {
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return DesignPartView.this.getWorkSpace();
        }
    }

    private class UndoAdapter
    implements UndoableEditListener {
        private UndoAdapter() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            UndoableEdit undoableEdit = undoableEditEvent.getEdit();
            if (!DesignPartView.this.getUndoManager().isInUndoRedoMode()) {
                if (undoableEdit instanceof DesignObjectEdit) {
                    if (DesignPartView.this.inLayoutEdit && DesignPartView.this.autoLayoutEdit != null) {
                        DesignPartView.this.autoLayoutEdit.addEdit(undoableEdit);
                    } else {
                        DesignPartView.this.getUndoManager().addEdit(undoableEdit);
                    }
                } else if (undoableEdit instanceof DefaultDiagramModel.DiagramModelEdit) {
                    DefaultDiagramModel.DiagramModelEdit diagramModelEdit;
                    if (DesignPartView.this.inLayoutEdit && DesignPartView.this.autoLayoutEdit != null) {
                        DesignPartView.this.autoLayoutEdit.addEdit(undoableEdit);
                    } else if (undoableEdit instanceof DefaultDiagramModel.DiagramModelEdit && (diagramModelEdit = (DefaultDiagramModel.DiagramModelEdit)undoableEdit).getRemoved() == null && diagramModelEdit.getInserted() == null) {
                        DesignPartView.this.getUndoManager().addEdit(undoableEdit);
                    }
                }
            }
        }
    }
}

