/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JMenuBar;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuStructure;

public class ControllerSet {
    private Map controllers = new TreeMap();
    private JMenuBar menuBar;
    private MenuStructure menuStructure;
    private ApplicationView appView;

    public ControllerSet(ApplicationView applicationView) {
        this.appView = applicationView;
    }

    public void add(AbstractController abstractController) {
        this.controllers.put(abstractController.getName(), abstractController);
    }

    public void remove(AbstractController abstractController) {
        this.controllers.remove(abstractController.getName());
    }

    public AbstractController getController(String string) {
        return (AbstractController)this.controllers.get(string);
    }

    public Collection getControllers() {
        return this.controllers.values();
    }

    public JMenuBar getJMenuBar() {
        if (this.menuBar == null) {
            this.createMenuBar();
        }
        return this.menuBar;
    }

    private void createMenuBar() {
        String[] stringArray = new String[]{AbstractController.FILE_CAPTION, AbstractController.EDIT_CAPTION, AbstractController.VIEW_CAPTION, AbstractController.DESIGN_CAPTION, AbstractController.OBJECT_CAPTION, AbstractController.RELATIONAL_CAPTION, AbstractController.STORAGE_CAPTION, AbstractController.PROCESS_MODELLING_CAPTION, AbstractController.TOOLS_CAPTION};
        String string = AbstractController.HELP_CAPTION;
        this.menuStructure = new MenuStructure(this.appView, stringArray, string);
        for (AbstractController abstractController : this.controllers.values()) {
            abstractController.addActionsToMenu(this.menuStructure);
        }
        this.menuBar = this.menuStructure.getJMenuBar();
    }

    public MDBAction getActionByName(String string) {
        for (AbstractController abstractController : this.controllers.values()) {
            if (!abstractController.hasActionWithName(string)) continue;
            return abstractController.getActionByName(string);
        }
        return null;
    }

    public void updateMenu() {
        for (AbstractController abstractController : this.controllers.values()) {
            this.updateMenu(abstractController);
        }
    }

    public void updateMenu(AbstractController abstractController) {
        this.getJMenuBar();
        abstractController.addActionsToMenu(this.menuStructure);
    }

    public void remove(MDBAction mDBAction) {
        this.menuStructure.remove(mDBAction);
    }

    public void add(MDBAction mDBAction) {
        this.menuStructure.add(mDBAction);
    }

    public MenuStructure getMenuStructure() {
        return this.menuStructure;
    }

    public void updateObjectMenu(DesignPartView designPartView) {
        if (this.menuStructure != null) {
            this.menuStructure.clearObjectActions();
            if (designPartView != null) {
                designPartView.getController().addObjectActionsToMenu(this.menuStructure);
            } else {
                this.menuStructure.showObjectMenu(false);
            }
        }
    }
}

