/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.SelectCSVExportDialog;
import oracle.dbtools.crest.exports.cubeviews.CubeViewsExporter;
import oracle.dbtools.crest.exports.oracleaw.OracleAWExporter;
import oracle.dbtools.crest.exports.reports.ReportsHandler;
import oracle.dbtools.crest.exports.xmla.XMLAExporter;
import oracle.dbtools.crest.fcp.FileNavigatorWrapper;
import oracle.dbtools.crest.fcp.vcs.MergeConflictsDialog;
import oracle.dbtools.crest.fcp.vcs.svn.SVNChangeListWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNHistoryWindow;
import oracle.dbtools.crest.fcp.vcs.svn.SVNViewPropertiesWindow;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNMergeWindow;
import oracle.dbtools.crest.fcp.vcs.svn.commands.SVNStatusCommand;
import oracle.dbtools.crest.imports.cubeviews.CubeViewsHandler;
import oracle.dbtools.crest.imports.ddl.DDLFilesCollector;
import oracle.dbtools.crest.imports.ddl.DDLHandler;
import oracle.dbtools.crest.imports.erwin.ERwinHandler;
import oracle.dbtools.crest.imports.var.ImportTypeSelector;
import oracle.dbtools.crest.imports.var.MappedVarsCollector;
import oracle.dbtools.crest.imports.var.VARParser;
import oracle.dbtools.crest.imports.xmla.XMLAHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.logical.RestoreMappings;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.xml.WXMLRelationalDesign;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.admin.domains.DomainAdmin;
import oracle.dbtools.crest.swingui.admin.rdbms.RDBMSSiteEditor;
import oracle.dbtools.crest.swingui.admin.types.TypesAdmin;
import oracle.dbtools.crest.swingui.compare.ModelChooserDialog;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.domains.ImportDomainsDialog;
import oracle.dbtools.crest.swingui.editor.SelectExportDialog;
import oracle.dbtools.crest.swingui.glossary.GlossaryDialog;
import oracle.dbtools.crest.swingui.logical.ControllerLogical;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.printing.DesignPrintModule;
import oracle.dbtools.crest.swingui.printing.ImageExporter;
import oracle.dbtools.crest.swingui.printing.PDFExporter;
import oracle.dbtools.crest.swingui.printing.SVGExporter;
import oracle.dbtools.crest.swingui.relational.ControllerRelational;
import oracle.dbtools.crest.swingui.transformations.NamesStandardizationDialog;
import oracle.dbtools.crest.swingui.wizards.Table2ViewDialog;
import oracle.dbtools.crest.swingui.wizards.TypesToDomainsDialog;
import oracle.dbtools.crest.swingui.wizards.View2TableDialog;
import oracle.dbtools.crest.swingui.wizards.cwddesigner.CWDExtractionWizard;
import oracle.dbtools.crest.swingui.wizards.metadata.DBMExtractionWizard;
import oracle.dbtools.crest.swingui.wizards.oracledesigner.ODExtractionWizard;
import oracle.dbtools.crest.swingui.wizards.reports.ExportReportsDialog;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerationDialog;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.gui.swing.JListDialog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class ControllerApplication
extends AbstractController {
    private OpenDesign openDesign;
    private CloseDesign closeDesign;
    private CloseAllDesigns closeAllDesigns;
    private PrintDialog printDialog;
    private ExportToImage exportToImage;
    private ExportToPDF exportToPDF;
    private ExportToSVG exportToSVG;
    private ShowDDLFileEditor ddlEditor;
    private ImportDDL importDDL;
    private ImportCubeViewsXML importCubeViews;
    private ImportVar importVAR;
    private ImportXMLA importXMLA;
    private ImportERwin4 importERwin4;
    private ImportERwin7 importERwin7;
    private ImportDBMetadata importMD;
    private ImportOracleDesigner importOD;
    private ImportCWD4ALLDesigner importCWD;
    private ImportDomainFile importDomains;
    private ExportToCWD exportToCWD;
    private ExportToCSV exportToCSV;
    private ExportToReportsSchema exportToReports;
    private ExportToOracleAW exportOracleAW;
    private ExportXMLA exportXMLA;
    private Undo undoAction;
    private Redo redoAction;
    private Copy copyAction;
    private Paste pasteAction;
    private Delete deleteAction;
    private AlignLeft alignLeft;
    private AlignTop alignTop;
    private EqualWidth equalWidth;
    private EqualHeight equalHeight;
    private ExitApplication exitAction;
    private SaveAll saveAll;
    private SaveAs saveAs;
    private NamesStandardization namesStandardization;
    private GlossaryEditor glossaryEditor;
    private ShowEditor showEditor;
    private ShowDDL showDDL;
    private DomainsAdministration domainsAdmin;
    private TypesAdministration typesAdmin;
    private RDBMSSiteAdministration rdbmsAdmin;
    private Table2ViewWizard t2vWizard;
    private View2TableWizard v2tWizard;
    private TypesToDomainsWizard typesToDomainsWizard;
    private CompareModels compareModels;
    private Recent emptyRecent = new Recent();
    private ShowDesignRules designRules;
    private ShowCustomDesignRules customDesignRules;
    private ShowCustomLibrariesManager customLibraries;
    private ShowTransformationsManager customTransformations;
    private ExportDDLFile exportDDL;
    private ExportCubeViewsXML exportCubeViews;
    private ViewDetails viewDetails;
    private ShowBarkerNotation showBarkerNotation;
    private ShowBachmanNotation showBachmanNotation;
    private ShowIENotation showIENotation;
    private OpenStorageDesign openStorageDesign;
    private CloseStorageDesign closeStorageDesign;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;
    private FitScreen fitScreen;
    private ActualSize actualSize;
    private Search search;
    private ShowReports showReports;
    private PendingChanges pendingChanges;
    private FileNavigator fileNavigator;
    private static final Logger LOGGER = new Logger(ControllerApplication.class);
    private static final String[] FILE_PATH = new String[]{FILE_CAPTION};
    private static final String[] IMPORT_PATH = new String[]{FILE_PATH[0], IMPORT_CAPTION};
    private static final String[] EXPORT_PATH = new String[]{FILE_PATH[0], EXPORT_CAPTION};
    private static final String[] REPORTS_PATH = new String[]{FILE_PATH[0], REPORTS_CAPTION};
    private static final String[] EXPORT_DIAGRAM_PATH = new String[]{FILE_PATH[0], PRINT_DIAGRAM_CAPTION};
    private static final String[] VIEW_PATH = new String[]{VIEW_CAPTION};
    private static final String[] TOOLS_PATH = new String[]{TOOLS_CAPTION};
    private static final String[] RECENT_PATH = new String[]{FILE_PATH[0], RECENT_FILES_CAPTION};
    private static final String[] EDIT_PATH = new String[]{EDIT_CAPTION};
    private static final String[] STORAGE_PATH = new String[]{STORAGE_CAPTION};
    private static final String[] LOGICAL_DIAGRAM_NOTATION_PATH = new String[]{VIEW_PATH[0], LOGICAL_DIAGRAM_NOTATION_CAPTION};
    private static final int PERCENTAGE_SAVING_RELATIONAL_DESIGNS = 70;
    private static final int PERCENTAGE_SAVING_DESIGN = 10;
    public static final String SAVE_OLD_DESIGN_WARNING = "This design is saved in an old format and can't be overwritten!\nPlease use \"Save As..\" option to save it as new design.";

    public ControllerApplication(ApplicationView applicationView) {
        super(applicationView);
    }

    @Override
    public void initializeActions() {
        this.openDesign = new OpenDesign();
        this.add(this.openDesign);
        this.closeDesign = new CloseDesign();
        this.add(this.closeDesign);
        this.closeAllDesigns = new CloseAllDesigns();
        this.add(this.closeAllDesigns);
        if (!ApplicationView.IS_VIEWER) {
            this.saveAll = new SaveAll();
            this.add(this.saveAll);
            this.saveAs = new SaveAs();
            this.add(this.saveAs);
        }
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            this.importVAR = new ImportVar();
            this.add(this.importVAR);
            this.importCWD = new ImportCWD4ALLDesigner();
            this.add(this.importCWD);
            this.importDomains = new ImportDomainFile();
            this.add(this.importDomains);
            this.exportToCWD = new ExportToCWD();
            this.add(this.exportToCWD);
            this.add(new ExportDDLFile());
            this.exportToCSV = new ExportToCSV();
            this.add(this.exportToCSV);
        } else if (!ApplicationView.IS_VIEWER) {
            this.importDDL = new ImportDDL();
            this.add(this.importDDL);
            this.importCubeViews = new ImportCubeViewsXML();
            this.add(this.importCubeViews);
            this.importVAR = new ImportVar();
            this.add(this.importVAR);
            this.importXMLA = new ImportXMLA();
            this.add(this.importXMLA);
            this.importERwin4 = new ImportERwin4();
            this.add(this.importERwin4);
            this.importERwin7 = new ImportERwin7();
            this.add(this.importERwin7);
            this.importMD = new ImportDBMetadata();
            this.add(this.importMD);
            this.importOD = new ImportOracleDesigner();
            this.add(this.importOD);
            this.importCWD = new ImportCWD4ALLDesigner();
            this.add(this.importCWD);
            this.importDomains = new ImportDomainFile();
            this.add(this.importDomains);
            this.exportToCWD = new ExportToCWD();
            this.add(this.exportToCWD);
            this.exportDDL = new ExportDDLFile();
            this.add(this.exportDDL);
            this.exportCubeViews = new ExportCubeViewsXML();
            this.add(this.exportCubeViews);
            this.exportXMLA = new ExportXMLA();
            this.add(this.exportXMLA);
            this.exportOracleAW = new ExportToOracleAW();
            this.add(this.exportOracleAW);
            this.exportToCSV = new ExportToCSV();
            this.add(this.exportToCSV);
            this.exportToReports = new ExportToReportsSchema();
            this.add(this.exportToReports);
        }
        this.printDialog = new PrintDialog();
        this.add(this.printDialog);
        this.exportToImage = new ExportToImage();
        this.add(this.exportToImage);
        this.exportToPDF = new ExportToPDF();
        this.add(this.exportToPDF);
        this.exportToSVG = new ExportToSVG();
        this.add(this.exportToSVG);
        this.emptyRecent.setEnabled(false);
        this.emptyRecent.setIcon(null);
        this.add(this.emptyRecent);
        this.exitAction = new ExitApplication();
        this.add(this.exitAction);
        if (!ApplicationView.IS_VIEWER) {
            this.add(this.getUndoAction());
            this.add(this.getRedoAction());
            this.copyAction = new Copy();
            this.add(this.copyAction);
            this.pasteAction = new Paste();
            this.add(this.pasteAction);
            this.deleteAction = new Delete();
            this.add(this.deleteAction);
            this.alignLeft = new AlignLeft();
            this.add(this.alignLeft);
            this.alignTop = new AlignTop();
            this.add(this.alignTop);
            this.equalWidth = new EqualWidth();
            this.add(this.equalWidth);
            this.equalHeight = new EqualHeight();
            this.add(this.equalHeight);
        }
        this.showEditor = new ShowEditor();
        this.add(this.showEditor);
        if (!ApplicationView.IS_VIEWER) {
            this.viewDetails = new ViewDetails();
            this.add(this.viewDetails);
            this.showBarkerNotation = new ShowBarkerNotation();
            this.add(this.showBarkerNotation);
            this.showBachmanNotation = new ShowBachmanNotation();
            this.add(this.showBachmanNotation);
            this.showIENotation = new ShowIENotation();
            this.add(this.showIENotation);
        }
        this.showDDL = new ShowDDL();
        this.add(this.showDDL);
        this.ddlEditor = new ShowDDLFileEditor();
        this.add(this.ddlEditor);
        this.zoomIn = new ZoomIn();
        this.add(this.zoomIn);
        this.zoomOut = new ZoomOut();
        this.add(this.zoomOut);
        this.fitScreen = new FitScreen();
        this.add(this.fitScreen);
        this.actualSize = new ActualSize();
        this.add(this.actualSize);
        this.search = new Search();
        this.add(this.search);
        if (ApplicationView.LOGICAL_MODEL_ONLY) {
            this.domainsAdmin = new DomainsAdministration();
            this.add(this.domainsAdmin);
            this.namesStandardization = new NamesStandardization();
            this.add(this.namesStandardization);
            this.glossaryEditor = new GlossaryEditor();
            this.add(this.glossaryEditor);
        } else if (!ApplicationView.IS_VIEWER) {
            this.domainsAdmin = new DomainsAdministration();
            this.add(this.domainsAdmin);
            this.typesAdmin = new TypesAdministration();
            this.add(this.typesAdmin);
            this.rdbmsAdmin = new RDBMSSiteAdministration();
            this.add(this.rdbmsAdmin);
            this.t2vWizard = new Table2ViewWizard();
            this.add(this.t2vWizard);
            this.v2tWizard = new View2TableWizard();
            this.add(this.v2tWizard);
            this.typesToDomainsWizard = new TypesToDomainsWizard();
            this.add(this.typesToDomainsWizard);
            this.namesStandardization = new NamesStandardization();
            this.add(this.namesStandardization);
            this.glossaryEditor = new GlossaryEditor();
            this.add(this.glossaryEditor);
            if (ApplicationView.debugMode) {
                this.add(new RestoreLostMappings());
            }
        }
        this.designRules = new ShowDesignRules();
        this.add(this.designRules);
        this.customDesignRules = new ShowCustomDesignRules();
        this.add(this.customDesignRules);
        this.customLibraries = new ShowCustomLibrariesManager();
        this.add(this.customLibraries);
        this.customTransformations = new ShowTransformationsManager();
        this.add(this.customTransformations);
        this.showReports = new ShowReports();
        this.add(this.showReports);
        if (!ApplicationView.IS_VIEWER) {
            this.compareModels = new CompareModels();
            this.add(this.compareModels);
        }
        this.openStorageDesign = new OpenStorageDesign();
        this.add(this.openStorageDesign);
        this.closeStorageDesign = new CloseStorageDesign();
        this.add(this.closeStorageDesign);
        this.pendingChanges = new PendingChanges();
        this.fileNavigator = new FileNavigator();
    }

    @Override
    public DesignPartView getDesignPartView() {
        return null;
    }

    @Override
    public void setDesignPartView(DesignPartView designPartView) {
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerApplication.Global");
    }

    public boolean designIsEmpty() {
        return this.getDesign().isNewDesign() && this.getApplicationView().getDirtyDesigns(true).length <= 0;
    }

    public Object[] getAvailableDesignNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = this.getApplicationView().getPersistenceManager().getAvailableDesigns();
        if (objectArray != null) {
            if (objectArray.length < 1) {
                return objectArray;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                arrayList.add(string);
            }
            return arrayList.toArray();
        }
        return arrayList.toArray();
    }

    public Object getDesignNameChoice(Object[] objectArray) {
        if (objectArray.length < 1) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.NoDesignsToOpen"), Messages.getString("ControllerApplication.OpenDesign"), 1, this.getConfiguration().getIcon("OPEN_ICON", this.getPreferredIconSize()));
            return null;
        }
        return JOptionPane.showInputDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ChooseDesign"), Messages.getString("ControllerApplication.OpenDesign"), 3, this.getConfiguration().getIcon("OPEN_ICON", this.getPreferredIconSize()), objectArray, objectArray[0]);
    }

    public JMenu getRecentsMenu() {
        return this.getApplicationView().getControllerSet().getMenuStructure().get(RECENT_PATH);
    }

    public void centerOnScreen(JDialog jDialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jDialog.getSize();
        Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 3);
        jDialog.setLocation(point);
    }

    public Undo getUndoAction() {
        if (this.undoAction == null) {
            this.undoAction = new Undo(this.getDesign().getUndoManager());
        }
        return this.undoAction;
    }

    public Redo getRedoAction() {
        if (this.redoAction == null) {
            this.redoAction = new Redo(this.getDesign().getUndoManager());
        }
        return this.redoAction;
    }

    private Design findDesign(String string) {
        Iterator iterator = this.getApplicationView().getDesigns().iterator();
        while (iterator.hasNext()) {
            Design design = (Design)iterator.next();
            if (design.getStoragePath() == null || !FileUtils.fixPath(design.getStoragePath()).equalsIgnoreCase(FileUtils.fixPath(string))) continue;
            return design;
        }
        return null;
    }

    public void openDesign(String string) {
        String string2 = ".dmd";
        File file = new File(string);
        if (file != null && file.exists()) {
            String string3 = file.getParent();
            String string4 = file.getName();
            String string5 = FileUtils.removeExt(string4);
            int n = string4.lastIndexOf(".");
            if (n > -1) {
                string2 = string4.substring(n);
            }
            this.doOpenDesign(string5, string3, string2, true);
        }
    }

    private void doOpenDesign(final String string, final String string2, final String string3, boolean bl) {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block17: {
                    try {
                        String string4 = string;
                        if (string4 != null) {
                            TimeLog.log();
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                            try {
                                Design design;
                                if (ControllerApplication.this.getApplicationView().getDesigns().size() > 1 || !ControllerApplication.this.designIsEmpty()) {
                                    design = ControllerApplication.this.getApplicationView().addDesign(true);
                                    ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                                }
                                ControllerApplication.this.getApplicationView().getCurrentDesign().setFileName(string4);
                                ControllerApplication.this.getApplicationView().getCurrentDesign().setDesignPath(string2);
                                ControllerApplication.this.getApplicationView().getCurrentDesign().setOldRepositoryType(".xml".equalsIgnoreCase(string3));
                                ControllerApplication.this.getApplicationView().getCurrentDesign().setCompressedDesign(".dmdz".equalsIgnoreCase(string3));
                                ControllerApplication.this.getApplicationView().setDesignName(string4);
                                ApplicationView.loading = true;
                                try {
                                    ControllerApplication.this.getApplicationView().enableControls(false);
                                    try {
                                        ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.OpenDesignP"), string4));
                                        ApplicationView.canLogging = false;
                                        design = ControllerApplication.this.getDesign();
                                        if (design.openDesign(string4, string3)) {
                                            ControllerApplication.this.getApplicationView().getCurrentDesign().selectLastOpenDPV();
                                            ControllerApplication.this.getApplicationView().synchronizeTitle();
                                            ControllerApplication.this.getApplicationView().getBrowserPanel().expandToPath(ControllerApplication.this.getDesign().getPath());
                                            if (Extension.isSVNExtensionLoaded() && !design.isOldRepositoryType()) {
                                                SVNClientHelper.getInstance().checkVersioned(design);
                                                SVNChangeListWindow.addToScope(design);
                                            }
                                        }
                                        ApplicationView.canLogging = true;
                                        ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.OpenDesignP"), Messages.getString("OpenDesignDialog.OK")));
                                    }
                                    finally {
                                        ControllerApplication.this.getApplicationView().enableControls(true);
                                        ApplicationView.canLogging = true;
                                    }
                                }
                                finally {
                                    ApplicationView.loading = false;
                                }
                            }
                            finally {
                                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                                TimeLog.log();
                            }
                            if (Extension.isSVNExtensionLoaded()) {
                                MergeConflictsDialog.getInstance().checkForConflicts(ControllerApplication.this.getDesign());
                            }
                            break block17;
                        }
                        ApplicationView.log(Messages.getString("ControllerApplication.OpenDesignCanceled"));
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error Opening Design!", exception);
                    }
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void saveDesign(Design design) {
        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
        try {
            ApplicationView.log(Messages.getString("ControllerApplication.SavingDesignAndPhysicalModels"));
            if (design.getLoadedVersion() < design.getVersion() && design.canUpgradeInPlace()) {
                design.loadAllRDandSD();
                this.getApplicationView().getXMLTransformationManager().setCheckDirty(false);
            } else {
                this.getApplicationView().getXMLTransformationManager().setCheckDirty(true);
            }
            this.saveAll();
            design.setReadOnly(false);
            design.setDirty(false);
            this.getApplicationView().getXMLTransformationManager().setCheckDirty(true);
        }
        finally {
            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAsDesign(int n) {
        block44: {
            try {
                Object object;
                if (n == 5) {
                    object = new SelectExportDialog(this.getApplicationView(), Messages.getString("ControllerApplication.SelectModelsSubviewsToExport"));
                    boolean bl = ((SelectExportDialog)object).showDialog();
                    if (!bl) {
                        return;
                    }
                    this.getDesign().buildExporMaps(((SelectExportDialog)object).getDesignParts());
                }
                object = this.getApplicationView().getCurrentDesign().getDesignPath();
                String string = null;
                if (!this.getDesign().isNewDesign()) {
                    string = this.getDesign().getName();
                }
                String string2 = this.getApplicationView().selectDesignName(string);
                String string3 = this.getApplicationView().getCurrentDesign().getDesignPath();
                ProgressDialog progressDialog = null;
                if (string2 != null) {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        boolean bl = this.getApplicationView().overwriteDesign(string2);
                        if (!bl) {
                            while (string2 != null && !bl) {
                                string2 = this.getApplicationView().selectDesignName(string2);
                                if (string2 != null) {
                                    bl = this.getApplicationView().overwriteDesign(string2);
                                    continue;
                                }
                                bl = false;
                            }
                        }
                        if (bl) {
                            try {
                                int n2;
                                progressDialog = new ProgressDialog(this.getApplicationView(), Messages.getString("ControllerApplication.SaveAs"), 0, 100);
                                if (!"".equals(object)) {
                                    this.getApplicationView().getCurrentDesign().setDesignPath((String)object);
                                    ApplicationView.loading = true;
                                    int n3 = this.getDesign().getRelationalDesigns().size();
                                    if (n3 == 0) {
                                        n3 = 2;
                                    }
                                    n2 = 70 / n3;
                                    progressDialog.setNote(Messages.getString("ControllerApplication.OpenRelationalAndPhysicalModels"));
                                    progressDialog.setProgress(0);
                                    Thread.sleep(100L);
                                    progressDialog.setNote(Messages.getString("ControllerApplication.OpenRelationalAndPhysicalModels"));
                                    progressDialog.setProgress(1);
                                    Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
                                    while (iterator.hasNext()) {
                                        Object object2;
                                        RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
                                        if (!relationalDesign.isLoaded()) {
                                            progressDialog.setNote(Messages.getString("ControllerApplication.Open") + relationalDesign.getName());
                                            if (relationalDesign.getDesign().isOldRepositoryType()) {
                                                relationalDesign.load();
                                            } else {
                                                relationalDesign.getAppView().getXMLTransformationManager().openDesignPart(relationalDesign);
                                                object2 = relationalDesign.getRMExtendedMap();
                                                relationalDesign.getAppView().getXMLTransformationManager().transformFromXMLToObject(object2, new File(((RMExtendedMap)object2).getStorageName()), relationalDesign.getDesign().isCompressedDesign());
                                            }
                                            relationalDesign.getDesign().getExtendedMap().distributenMappings(relationalDesign);
                                            this.getApplicationView().getBrowserPanel().getNavigationTreeDesign().updateSubtree(relationalDesign);
                                        }
                                        StringBuffer stringBuffer = new StringBuffer();
                                        stringBuffer.append(this.getApplicationView().getCurrentDesign().getDesignPath());
                                        if (this.getDesign().getLoadedVersion() < 3.2f) {
                                            stringBuffer.append(WXMLRelationalDesign.getRelativePath(relationalDesign)).append('/').append(relationalDesign.getObjectID()).append("/storage");
                                        } else if (this.getDesign().getLoadedVersion() < 3.4f) {
                                            stringBuffer.append(WXMLRelationalDesign.getRelativePath(relationalDesign)).append('/').append(relationalDesign.getPathIDString()).append("/phys");
                                        } else {
                                            stringBuffer.append(WXMLRelationalDesign.getRelativePath(relationalDesign)).append('/').append(relationalDesign.getShortObjectID()).append("/phys");
                                        }
                                        object2 = stringBuffer.toString();
                                        File file = new File((String)object2);
                                        File[] fileArray = file.listFiles();
                                        if (fileArray != null) {
                                            for (int i = 0; i < fileArray.length; ++i) {
                                                StorageDesign storageDesign;
                                                if (!fileArray[i].isDirectory()) continue;
                                                String string4 = fileArray[i].getName();
                                                RDBMSSite rDBMSSite = null;
                                                rDBMSSite = this.getDesign().getLoadedVersion() < 3.2f ? relationalDesign.getStorageDesignFactory().getRDBMSSiteSet().getByObjectID(string4) : relationalDesign.getStorageDesignFactory().getRDBMSSiteSet().getByShortObjectIDString(string4);
                                                if (rDBMSSite == null || (storageDesign = relationalDesign.getStorageDesignFactory().getStorageDesign(rDBMSSite)) == null || storageDesign.isOpen()) continue;
                                                progressDialog.setNote(Messages.getString("ControllerApplication.Open") + storageDesign.getName());
                                                if (storageDesign.getDesign().isOldRepositoryType()) {
                                                    storageDesign.load();
                                                } else {
                                                    this.getApplicationView().getXMLTransformationManager().openPhysicalModel(storageDesign);
                                                }
                                                storageDesign.setOpen(true);
                                            }
                                        }
                                        progressDialog.increaseProgress(n2);
                                    }
                                    ApplicationView.loading = false;
                                }
                                progressDialog.setProgress(70);
                                if (n == 4) {
                                    this.getApplicationView().getCurrentDesign().setFileName(string2);
                                    this.getApplicationView().getBrowserPanel().getNavigationTreeDesign().updateSubtree(this.getApplicationView().getCurrentDesign());
                                    this.getApplicationView().synchronizeTitle();
                                    this.getApplicationView().getCurrentDesign().setNewDesign(false);
                                    this.getApplicationView().getCurrentDesign().setCurrentOperation(4);
                                    this.getDesign().resetDomains();
                                } else if (n == 5) {
                                    this.getApplicationView().getCurrentDesign().setCurrentOperation(n);
                                    this.getApplicationView().setCurrentOperation(n);
                                    this.getApplicationView().getCurrentDesign().setExportFileName(string2);
                                    this.getApplicationView().getCurrentDesign().setExportDesignPath(string3);
                                }
                                this.getApplicationView().getCurrentDesign().setDesignPath(string3);
                                this.getApplicationView().deleteDesign(this.getApplicationView().getCurrentDesign().getFileName());
                                this.getApplicationView().getXMLTransformationManager().setCheckDirty(false);
                                progressDialog.setNote(Messages.getString("ControllerApplication.SaveAs"));
                                Design design = this.getDesign();
                                int n4 = n2 = !string3.equals(object) ? 1 : 0;
                                if (n2 != 0) {
                                    design.setVersioned(false);
                                }
                                this.saveAll();
                                this.getApplicationView().getPersistenceManager().setCheckDirty(true);
                                design.setReadOnly(false);
                                if (n2 != 0) {
                                    int n5 = 10;
                                    progressDialog.setNote(Messages.getString("ControllerApplication.CheckingProperties"));
                                    if (Extension.isSVNExtensionLoaded()) {
                                        SVNClientHelper.getInstance().checkProperties(design, false);
                                    }
                                    progressDialog.increaseProgress(n5);
                                    progressDialog.setNote(Messages.getString("ControllerApplication.AddingToVCS"));
                                    progressDialog.getDialog().setVisible(false);
                                    try {
                                        this.addToVCS(design, string3, string2);
                                    }
                                    finally {
                                        progressDialog.getDialog().setVisible(true);
                                    }
                                }
                                progressDialog.setProgress(100);
                                break block44;
                            }
                            catch (Exception exception) {
                                LOGGER.error("Error loading design during Save As...!", exception);
                                ApplicationView.log(Messages.getString("ControllerApplication.ErrorLoadingDesignDuringSaveAs"));
                                MessageDialogs.showErrorMessage((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ErrorInSaveAsOperation"));
                                break block44;
                            }
                            finally {
                                ApplicationView.loading = false;
                                this.getApplicationView().getPersistenceManager().setCheckDirty(true);
                                this.getDesign().setReadOnly(false);
                            }
                        }
                        this.getApplicationView().getCurrentDesign().setDesignPath((String)object);
                        ApplicationView.log(Messages.getString("ControllerApplication.SaveDesignAsCanceled"));
                        break block44;
                    }
                    finally {
                        if (progressDialog != null) {
                            progressDialog.close();
                        }
                        if (n == 5) {
                            this.getDesign().clearExportMaps();
                            this.getApplicationView().getCurrentDesign().setDesignPath((String)object);
                            this.getApplicationView().getCurrentDesign().setExportFileName("");
                            MessageDialogs.showMessage((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ExportedOk"));
                        }
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                        this.getApplicationView().getCurrentDesign().setCurrentOperation(-1);
                        this.getApplicationView().setCurrentOperation(-1);
                    }
                }
                ApplicationView.log(Messages.getString("ControllerApplication.SaveDesignAsCanceled"));
            }
            catch (Exception exception) {
                LOGGER.error("Error Saving Design as...!", exception);
            }
        }
    }

    private void addToVCS(Design design, String string, String string2) {
        SVNClientHelper sVNClientHelper;
        if (Extension.isSVNExtensionLoaded() && (sVNClientHelper = SVNClientHelper.getInstance()).isVersioned(string) && JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.AddToVCSConfirmation"), Messages.getString("ControllerApplication.AddToVCS"), 0) == 0) {
            boolean bl = design.isCompressedDesign();
            String string3 = bl ? ".dmdz" : ".dmd";
            File file = new File(string, string2 + string3);
            File file2 = new File(string, string2);
            this.addToVCSSystemTypesFolder(string);
            ApplicationView.log("Start adding files");
            TimeLog.log("Start adding files");
            sVNClientHelper.doAdd(file);
            sVNClientHelper.doAdd(file2);
            ApplicationView.log("End adding files");
            TimeLog.log("End adding files");
            design.setVersioned(true);
            sVNClientHelper.checkProperties(design, false, false);
            sVNClientHelper.doCommit(new File[]{file, file2}, null, true, false);
            SVNChangeListWindow.addToScope(design);
        }
    }

    private void addToVCSSystemTypesFolder(String string) {
        String string2;
        SVNClientHelper sVNClientHelper = SVNClientHelper.getInstance();
        if (!sVNClientHelper.isVersioned(string2 = XMLTransformationManager.getDefaultSystemTypesPath())) {
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setSelectionScope(1);
            uRLChooser.setSelectionMode(0);
            uRLChooser.setShowJarsAsDirs(false);
            int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.SaveSystemTypes"));
            if (n == 0) {
                File file = new File(uRLChooser.getSelectedURL().getPath());
                ApplicationView.getInstance().getSettings().setDefaultSystemTypesPath(file.getPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() {
        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
        try {
            TimeLog.log("start save operation");
            int n = 0x100000;
            Runtime runtime = Runtime.getRuntime();
            System.out.println("begin memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
            Design design = this.getDesign();
            ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.SaveDesign"), design.getFileName()));
            design.saveAll();
            if (this.getApplicationView().getCurrentOperation() != 5) {
                if (Extension.isSVNExtensionLoaded()) {
                    SVNChangeListWindow.getSVNOutgoingChangesChangeList().refresh();
                }
                this.getApplicationView().addRecent(this.getApplicationView().getDesignName(), this.getApplicationView().getCurrentDesign().getDesignPath());
            }
            TimeLog.log("End save operation");
            System.out.println("END memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
            ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.DesignSaved"), design.getFileName()));
        }
        finally {
            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void updateMenus() {
        if (!ApplicationView.IS_VIEWER) {
            this.saveAll.setEnabled(!this.getDesign().isReadOnly());
            this.namesStandardization.setEnabled(!this.getDesign().isReadOnly());
            this.alignLeft.setEnabled(this.canAlign());
            this.alignTop.setEnabled(this.alignLeft.isEnabled());
            this.equalWidth.setEnabled(this.alignLeft.isEnabled());
            this.equalHeight.setEnabled(this.alignLeft.isEnabled());
            this.copyAction.setEnabled(this.canCopy());
            this.pasteAction.setEnabled(this.canPaste());
            this.deleteAction.setEnabled(this.canDelete());
            this.updateViewDetailsMenu();
            this.showBarkerNotation.setEnabled(this.isBarkerNotationEnabled());
            this.showBachmanNotation.setEnabled(this.isBachmanNotationEnabled());
            this.showIENotation.setEnabled(this.isIENotationEnabled());
            this.updateUndoRedoMenu();
        } else {
            this.setEnabled(this.namesStandardization, false);
            this.setEnabled(this.alignLeft, false);
            this.setEnabled(this.alignTop, false);
            this.setEnabled(this.equalWidth, false);
            this.setEnabled(this.equalHeight, false);
            this.setEnabled(this.copyAction, false);
            this.setEnabled(this.pasteAction, false);
            this.setEnabled(this.deleteAction, false);
            this.updateViewDetailsMenu();
            this.setEnabled(this.showBarkerNotation, this.isBarkerNotationEnabled());
            this.setEnabled(this.showBachmanNotation, this.isBachmanNotationEnabled());
            this.setEnabled(this.showIENotation, this.isIENotationEnabled());
            this.updateUndoRedoMenu();
        }
        this.setEnabled(this.showEditor, this.checkSelected());
        this.setEnabled(this.showDDL, this.hasDDL());
        this.setEnabled(this.ddlEditor, this.hasRelationalModels());
        this.setEnabled(this.exportDDL, this.hasRelationalModels());
        this.getApplicationView().updateDesignRules(!this.getDesign().isReadOnly());
        AbstractRepositoryManager abstractRepositoryManager = this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
        boolean bl = abstractRepositoryManager.isConnected() || this.getDesign().isLoadFromDB();
        this.setEnabled(this.openDesign, !bl);
        this.setEnabled(this.saveAll, !bl && !ApplicationView.IS_VIEWER);
        this.setEnabled(this.saveAs, !bl && !ApplicationView.IS_VIEWER);
    }

    public void updateUndoRedoMenu() {
        if (this.undoAction != null) {
            this.undoAction.setEnabled(this.getDesign().getUndoManager().canUndo());
            this.undoAction.setName(this.getDesign().getUndoManager().getUndoPresentationName());
        }
        if (this.redoAction != null) {
            this.redoAction.setEnabled(this.getDesign().getUndoManager().canRedo());
            this.redoAction.setName(this.getDesign().getUndoManager().getRedoPresentationName());
        }
    }

    private void updateViewDetailsMenu() {
        if (this.isEditable() && this.viewDetails != null && this.viewDetails.getMenu() != null && this.getApplicationView().getCurrentDPV() != null) {
            this.viewDetails.getMenu().removeAll();
            JMenu jMenu = this.getApplicationView().getCurrentDPV().getDetailsMenu();
            this.viewDetails.getMenu().setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ViewDetails")));
            Component[] componentArray = jMenu.getMenuComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (component instanceof JMenuItem) {
                    this.viewDetails.getMenu().add(component);
                    continue;
                }
                if (!(component instanceof JSeparator)) continue;
                this.viewDetails.getMenu().addSeparator();
            }
        }
    }

    private boolean isBarkerNotationEnabled() {
        if (this.getApplicationView().getCurrentDPV() != null) {
            return this.getApplicationView().getCurrentDPV() instanceof DPVLogical && this.getApplicationView().getCurrentDPV().getNotation() != 1;
        }
        return false;
    }

    private boolean isBachmanNotationEnabled() {
        if (this.getApplicationView().getCurrentDPV() != null) {
            return this.getApplicationView().getCurrentDPV() instanceof DPVLogical && this.getApplicationView().getCurrentDPV().getNotation() != 0;
        }
        return false;
    }

    private boolean isIENotationEnabled() {
        if (this.getApplicationView().getCurrentDPV() != null) {
            return this.getApplicationView().getCurrentDPV() instanceof DPVLogical && this.getApplicationView().getCurrentDPV().getNotation() != 2;
        }
        return false;
    }

    public ExitApplication getExitAction() {
        return this.exitAction;
    }

    public MDBAction getOpenDesignAction() {
        return this.openDesign;
    }

    public MDBAction getCloseDesignAction() {
        return this.closeDesign;
    }

    public MDBAction getCloseAllDesignsAction() {
        return this.closeAllDesigns;
    }

    public MDBAction getSaveDesignAction() {
        return this.saveAll;
    }

    public MDBAction getSaveAsAction() {
        return this.saveAs;
    }

    public MDBAction getPrintAction() {
        return this.printDialog;
    }

    public MDBAction getExportToImageAction() {
        return this.exportToImage;
    }

    public MDBAction getExportToPDFAction() {
        return this.exportToPDF;
    }

    public MDBAction getExportToSVGAction() {
        return this.exportToSVG;
    }

    public MDBAction getExportToReportingSchemaAction() {
        return this.exportToReports;
    }

    public MDBAction getShowDDLAction() {
        return this.showDDL;
    }

    public MDBAction getDDLEditorAction() {
        return this.ddlEditor;
    }

    public MDBAction getImportDDLAction() {
        return this.importDDL;
    }

    public MDBAction getImportCubeViewsAction() {
        return this.importCubeViews;
    }

    public MDBAction getImportVARAction() {
        return this.importVAR;
    }

    public MDBAction getImportXMLAAction() {
        return this.importXMLA;
    }

    public MDBAction getImportERwin4Action() {
        return this.importERwin4;
    }

    public MDBAction getImportERwin7Action() {
        return this.importERwin7;
    }

    public MDBAction getImportMDAction() {
        return this.importMD;
    }

    public MDBAction getImportODAction() {
        return this.importOD;
    }

    public MDBAction getImportOSDMAction() {
        return this.importCWD;
    }

    public MDBAction getImportDomainsAction() {
        return this.importDomains;
    }

    public MDBAction getExportToOracleAWAction() {
        return this.exportOracleAW;
    }

    public MDBAction getExportToCWD4ALL() {
        return this.exportToCWD;
    }

    public MDBAction getExportToCSV() {
        return this.exportToCSV;
    }

    public MDBAction getExportAsXMLAAction() {
        return this.exportXMLA;
    }

    public MDBAction getExportCubeViewsAction() {
        return this.exportCubeViews;
    }

    public MDBAction getExportDDLAction() {
        return this.exportDDL;
    }

    public MDBAction geDesignRulesAction() {
        return this.designRules;
    }

    public MDBAction getCustomDesignRulesAction() {
        return this.customDesignRules;
    }

    public MDBAction getCustomLibrariesAction() {
        return this.customLibraries;
    }

    public MDBAction getTransformationsAction() {
        return this.customTransformations;
    }

    public MDBAction getCompareAction() {
        return this.compareModels;
    }

    public MDBAction getDomainsAdminAction() {
        return this.domainsAdmin;
    }

    public MDBAction getTypesAdminAction() {
        return this.typesAdmin;
    }

    public MDBAction getRDBMSAdminAction() {
        return this.rdbmsAdmin;
    }

    public MDBAction getT2VWizardAction() {
        return this.t2vWizard;
    }

    public MDBAction getV2TWizardAction() {
        return this.v2tWizard;
    }

    public MDBAction getTypesToDomainsWizardAction() {
        return this.typesToDomainsWizard;
    }

    public MDBAction getNamesStandardizationAction() {
        return this.namesStandardization;
    }

    public MDBAction getGlossaryEditorAction() {
        return this.glossaryEditor;
    }

    public MDBAction getCopyAction() {
        return this.copyAction;
    }

    public MDBAction getPasteAction() {
        return this.pasteAction;
    }

    public MDBAction getDeleteAction() {
        return this.deleteAction;
    }

    public MDBAction getShowEditorAction() {
        return this.showEditor;
    }

    public OpenStorageDesign getOpenStorageDesignAction() {
        return this.openStorageDesign;
    }

    public CloseStorageDesign getCloseStorageDesignAction() {
        return this.closeStorageDesign;
    }

    public MDBAction getAlignLeftAction() {
        return this.alignLeft;
    }

    public MDBAction getAlignTopAction() {
        return this.alignTop;
    }

    public MDBAction getEqualWidthAction() {
        return this.equalWidth;
    }

    public MDBAction getEqualHeightAction() {
        return this.equalHeight;
    }

    public MDBAction getShowBarkerNotationAction() {
        return this.showBarkerNotation;
    }

    public MDBAction getShowBachmanNotationAction() {
        return this.showBachmanNotation;
    }

    public MDBAction getShowIENotationAction() {
        return this.showIENotation;
    }

    public MDBAction getZoomInAction() {
        return this.zoomIn;
    }

    public MDBAction getZoomOutAction() {
        return this.zoomOut;
    }

    public MDBAction getFitScreenAction() {
        return this.fitScreen;
    }

    public MDBAction getActualSizeAction() {
        return this.actualSize;
    }

    public MDBAction getSearchAction() {
        return this.search;
    }

    public MDBAction getViewDetails() {
        return this.viewDetails;
    }

    public ShowReports getShowReports() {
        return this.showReports;
    }

    public PendingChanges getPendingChanges() {
        return this.pendingChanges;
    }

    public FileNavigator getFileNavigator() {
        return this.fileNavigator;
    }

    private boolean canAlign() {
        boolean bl = false;
        if (this.getApplicationView().getCurrentDPV() != null) {
            if (this.getApplicationView().getCurrentDPV().getRepositoryOID() != null) {
                if (!this.getApplicationView().getCurrentDPV().getDesignPart().isCheckedOutByMe()) {
                    return false;
                }
                bl = ApplicationView.LOGICAL_MODEL_ONLY && !(this.getApplicationView().getCurrentDPV() instanceof DPVLogical) ? false : this.getApplicationView().getCurrentDPV().getWorkSpace().canAlign();
            } else {
                bl = this.getApplicationView().getCurrentDPV().getWorkSpace().canAlign();
            }
        }
        return bl;
    }

    private boolean canCopy() {
        if (this.getApplicationView().getCurrentDPV() != null) {
            if (this.getApplicationView().getCurrentDPV().getRepositoryOID() != null) {
                if (!this.getApplicationView().getCurrentDPV().getDesignPart().isCheckedOutByMe()) {
                    return false;
                }
                if (ApplicationView.LOGICAL_MODEL_ONLY && !(this.getApplicationView().getCurrentDPV() instanceof DPVLogical)) {
                    return false;
                }
                SelectableObject selectableObject = this.getApplicationView().getCurrentDPV().getCurrentSelection();
                return selectableObject != null && selectableObject.getSelectedDesignObject() != null && selectableObject.getSelectedDesignObject().canCopy();
            }
            SelectableObject selectableObject = this.getApplicationView().getCurrentDPV().getCurrentSelection();
            return selectableObject != null && selectableObject.getSelectedDesignObject() != null && selectableObject.getSelectedDesignObject().canCopy();
        }
        return false;
    }

    private boolean canDelete() {
        if (this.getApplicationView().getCurrentDPV() != null) {
            if (this.getApplicationView().getCurrentDPV().getRepositoryOID() != null) {
                if (!this.getApplicationView().getCurrentDPV().getDesignPart().isCheckedOutByMe()) {
                    return false;
                }
                if (ApplicationView.LOGICAL_MODEL_ONLY && !(this.getApplicationView().getCurrentDPV() instanceof DPVLogical)) {
                    return false;
                }
                SelectableObject selectableObject = this.getApplicationView().getCurrentDPV().getCurrentSelection();
                return selectableObject != null && selectableObject.getSelectedDesignObject() != null;
            }
            SelectableObject selectableObject = this.getApplicationView().getCurrentDPV().getCurrentSelection();
            return selectableObject != null && selectableObject.getSelectedDesignObject() != null;
        }
        return false;
    }

    @Override
    public boolean canPaste() {
        if (this.getApplicationView().getCurrentDPV() != null) {
            if (this.getApplicationView().getCurrentDPV().getRepositoryOID() != null) {
                if (!this.getApplicationView().getCurrentDPV().getDesignPart().isCheckedOutByMe()) {
                    return false;
                }
                if (ApplicationView.LOGICAL_MODEL_ONLY && !(this.getApplicationView().getCurrentDPV() instanceof DPVLogical)) {
                    return false;
                }
                return this.getApplicationView().getCurrentDPV().getController().canPaste();
            }
            return this.getApplicationView().getCurrentDPV().getController().canPaste();
        }
        return false;
    }

    private boolean checkSelected() {
        Object object;
        Object object2;
        boolean bl = false;
        if (this.getApplicationView().getCurrentDPV() != null && this.getApplicationView().getCurrentDPV().getCurrentSelection() != null && (object2 = this.getApplicationView().getCurrentDPV().getCurrentSelection().getSelectedObject()) instanceof DesignObject) {
            bl = true;
        }
        if (!bl && this.getApplicationView().getBrowserPanel() != null && (object2 = this.getApplicationView().getBrowserPanel().getJTree().getSelectionPath()) != null && (object = ((TreePath)object2).getLastPathComponent()) instanceof DesignObject) {
            bl = true;
        }
        return bl;
    }

    private boolean hasRelationalModels() {
        return this.getDesign().getRelationalDesigns().size() > 0;
    }

    private boolean hasDDL() {
        Object object;
        boolean bl = false;
        if (this.getApplicationView().getCurrentDPV() != null && this.getApplicationView().getCurrentDPV().getCurrentSelection() != null && ((object = this.getApplicationView().getCurrentDPV().getCurrentSelection().getSelectedObject()) instanceof Table || object instanceof TableView || object instanceof Index && !((Index)object).isPK())) {
            bl = true;
        }
        return bl;
    }

    public Recent getEmptyRecent() {
        return this.emptyRecent;
    }

    class FileNavigator
    extends MDBAction {
        private FileNavigator() {
            super(AbstractController.FILE_NAVIGATOR_CAPTION, ControllerApplication.this.getConfiguration().getIcon("FILES_ICON", ControllerApplication.this.getPreferredIconSize()));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            FileNavigatorWrapper.getInstance().showWindow();
        }
    }

    class PendingChanges
    extends MDBAction {
        private PendingChanges() {
            super(MenuUtils.getMnemonicStr(AbstractController.PENDING_CHANGES_CAPTION));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.PENDING_CHANGES_CAPTION));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            SVNStatusCommand.showSvnChangeListWindow();
        }
    }

    class ShowReports
    extends MDBAction {
        private ReportsGenerationDialog exportToMSWord;

        private ShowReports() {
            super(MenuUtils.getMnemonicStr(AbstractController.REPORTS_CAPTION));
            this.setMenuPath(REPORTS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.REPORTS_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(82, 576, false));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            this.execute();
        }

        public void execute() {
            try {
                this.exportToMSWord = new ReportsGenerationDialog(ControllerApplication.this.getApplicationView());
                this.exportToMSWord.showDialog();
            }
            catch (Exception exception) {
                LOGGER.error("Error in Reports Export", exception);
            }
        }
    }

    class GlossaryEditor
    extends MDBAction {
        private GlossaryEditor() {
            super(MenuUtils.getMnemonicStr(AbstractController.GLOSSARY_CAPTION), ControllerApplication.this.getConfiguration().getIcon("NAMES_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.GLOSSARY_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(89, 576, false));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            block10: {
                try {
                    URLFilter uRLFilter = new URLFilter(){

                        public boolean accept(URL uRL) {
                            File file = new File(uRL.getPath());
                            return file.getName().toLowerCase().endsWith(".glossary") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("ControllerApplication.GlossaryFiles");
                        }
                    };
                    URLChooser uRLChooser = DialogUtil.newURLChooser();
                    uRLChooser.clearChooseableURLFilters();
                    uRLChooser.setSelectionScope(0);
                    uRLChooser.setSelectionMode(0);
                    uRLChooser.setShowJarsAsDirs(false);
                    uRLChooser.setURLFilter(uRLFilter);
                    String string = ControllerApplication.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (string != null) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                    } else {
                        URL uRL = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                        if (uRL != null) {
                            uRLChooser.setSelectedURL(uRL);
                        }
                    }
                    int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.SelectGlossaryFile"));
                    if (n != 0) break block10;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        Glossary glossary;
                        File file = new File(uRLChooser.getSelectedURL().getPath());
                        String string2 = file.getName().toLowerCase();
                        if (!string2.endsWith(".glossary") && !string2.endsWith(".glossary")) {
                            file = new File(file.getPath() + ".glossary");
                        }
                        if ((glossary = new Glossary(file)).getLoadError() == 0) {
                            GlossaryDialog glossaryDialog = new GlossaryDialog(ControllerApplication.this.getApplicationView(), glossary);
                            glossaryDialog.showDialog();
                        }
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error Importing XMI File!", exception);
                }
            }
        }
    }

    class ExportDDLFile
    extends MDBAction {
        private ExportDDLFile() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.DDLFile")), ControllerApplication.this.getConfiguration().getIcon("DDL_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.DDLFile")));
            this.setAccelerator(KeyStroke.getKeyStroke(69, 64, false));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            RelationalDesign relationalDesign = ControllerApplication.this.getApplicationView().selectRelationalDesign();
            if (relationalDesign != null) {
                ControllerApplication.this.getDesign().setRelationalDesign(relationalDesign);
                ControllerApplication.this.getApplicationView().setDDLFileMakerEditorVisible(true);
            }
        }
    }

    class ShowIENotation
    extends MDBAction {
        public ShowIENotation() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.IENotation")));
            this.setMenuPath(LOGICAL_DIAGRAM_NOTATION_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.IENotation")));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView;
            if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null && (designPartView = ControllerApplication.this.getApplicationView().getCurrentDPV()).getNotation() != 2) {
                designPartView.setNotation(2);
                designPartView.updateDiagramSettings();
            }
        }
    }

    class ShowBachmanNotation
    extends MDBAction {
        public ShowBachmanNotation() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.BachmanNotation")));
            this.setMenuPath(LOGICAL_DIAGRAM_NOTATION_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.BachmanNotation")));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView;
            if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null && (designPartView = ControllerApplication.this.getApplicationView().getCurrentDPV()).getNotation() != 0) {
                designPartView.setNotation(0);
                designPartView.updateDiagramSettings();
            }
        }
    }

    class ShowBarkerNotation
    extends MDBAction {
        public ShowBarkerNotation() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.BarkerNotation")));
            this.setMenuPath(LOGICAL_DIAGRAM_NOTATION_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.BarkerNotation")));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView;
            if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null && (designPartView = ControllerApplication.this.getApplicationView().getCurrentDPV()).getNotation() != 1) {
                designPartView.setNotation(1);
                designPartView.updateDiagramSettings();
            }
        }
    }

    class ViewDetails
    extends MDBAction {
        public ViewDetails() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ViewDetails")));
            this.setMenuPath(VIEW_PATH);
        }

        @Override
        public boolean isPopupMenu() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
        }
    }

    public class Recent
    extends MDBAction {
        private String designName;
        private String designPath;

        public Recent() {
            super("EMPTY", ControllerApplication.this.getConfiguration().getIcon("RECENT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(RECENT_PATH);
        }

        public void setDesignName(String string) {
            this.designName = string;
            this.setName(string);
        }

        public void setDesignPath(String string) {
            this.designPath = string;
        }

        public String getDesignName() {
            return this.designName;
        }

        public String getDesignPath() {
            return this.designPath;
        }

        @Override
        public String getToolTipText() {
            return this.designPath;
        }

        private String getFileExt() {
            for (int i = 0; i < XMLConstants.DESIGN_EXTENSIONS.length; ++i) {
                String string = XMLConstants.DESIGN_EXTENSIONS[i];
                File file = new File(this.designPath, this.designName + string);
                if (!file.exists()) continue;
                return string;
            }
            return null;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int n = 0x100000;
                    Runtime runtime = Runtime.getRuntime();
                    System.out.println("open design begin memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
                    if (Recent.this.designName != null && Recent.this.designPath != null) {
                        Design design = ControllerApplication.this.findDesign(Recent.this.designPath + "/" + Recent.this.designName);
                        if (design != null) {
                            MessageDialogs.showWarningMessage("Design: '" + Recent.this.designName + "' is already opened.");
                            ControllerApplication.this.getApplicationView().getBrowserPanel().expandToPath(design.getPath());
                            return;
                        }
                        String string = Recent.this.getFileExt();
                        if (string != null) {
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                            try {
                                if (ControllerApplication.this.getApplicationView().getDesigns().size() > 1 || !ControllerApplication.this.designIsEmpty()) {
                                    design = ControllerApplication.this.getApplicationView().addDesign(true);
                                    ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                                }
                                ControllerApplication.this.getApplicationView().getCurrentDesign().setDesignPath(Recent.this.designPath);
                                ControllerApplication.this.getApplicationView().getCurrentDesign().setFileName(Recent.this.designName);
                                ControllerApplication.this.getApplicationView().getCurrentDesign().setOldRepositoryType(".xml".equalsIgnoreCase(string));
                                ControllerApplication.this.getApplicationView().getCurrentDesign().setCompressedDesign(".dmdz".equalsIgnoreCase(string));
                                ApplicationView.loading = true;
                                try {
                                    ControllerApplication.this.getApplicationView().enableControls(false);
                                    try {
                                        ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.OpenDesignP"), Recent.this.designName));
                                        ApplicationView.canLogging = false;
                                        design = ControllerApplication.this.getDesign();
                                        if (design.openDesign(Recent.this.designName, string)) {
                                            if (Extension.isSVNExtensionLoaded() && !design.isOldRepositoryType()) {
                                                SVNClientHelper.getInstance().checkVersioned(design);
                                                SVNChangeListWindow.addToScope(design);
                                            }
                                            ControllerApplication.this.getApplicationView().synchronizeTitle();
                                            ControllerApplication.this.getApplicationView().getSettings().removeRecent(Recent.this);
                                            ControllerApplication.this.getApplicationView().getSettings().addRecent(Recent.this);
                                            ControllerApplication.this.getApplicationView().getBrowserPanel().expandToPath(ControllerApplication.this.getDesign().getPath());
                                        }
                                        ApplicationView.canLogging = true;
                                        ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.OpenDesignP"), Messages.getString("OpenDesignDialog.OK")));
                                    }
                                    finally {
                                        System.out.println("open design END memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
                                        ControllerApplication.this.getApplicationView().enableControls(true);
                                        ApplicationView.canLogging = true;
                                    }
                                }
                                finally {
                                    ApplicationView.loading = false;
                                }
                            }
                            finally {
                                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                            }
                            if (Extension.isSVNExtensionLoaded()) {
                                MergeConflictsDialog.getInstance().checkForConflicts(ControllerApplication.this.getDesign());
                            }
                        } else {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ControllerApplication.DesignDoNotExist"), Recent.this.designName));
                        }
                    }
                }
            };
            thread.start();
        }
    }

    class TypesToDomainsWizard
    extends MDBAction {
        TypesToDomainsWizard() {
            super(MenuUtils.getMnemonicStr(AbstractController.TYPES_TO_DOMAINS_WIZARD_CAPTION), ControllerApplication.this.getConfiguration().getIcon("TYPES_TO_DOMAINS_WIZARD_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.TYPES_TO_DOMAINS_WIZARD_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(80, 576, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return false;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            new TypesToDomainsDialog(ControllerApplication.this.getApplicationView(), MenuUtils.getMnemonicStr(AbstractController.TYPES_TO_DOMAINS_WIZARD_CAPTION)).showDialog();
        }
    }

    class View2TableWizard
    extends MDBAction {
        private View2TableDialog view2TableDialog;

        View2TableWizard() {
            super(MenuUtils.getMnemonicStr(AbstractController.V2TW_CAPTION), ControllerApplication.this.getConfiguration().getIcon("VIEW_2_TABLE_WIZARD_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.V2TW_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(86, 576, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                if (this.view2TableDialog == null) {
                    this.view2TableDialog = new View2TableDialog(ControllerApplication.this.getApplicationView(), MenuUtils.getMnemonicStr(AbstractController.V2TW_CAPTION));
                }
                this.view2TableDialog.showDialog();
            }
            catch (Exception exception) {
                LOGGER.error("Error in View2TableWizard", exception);
            }
        }
    }

    class Table2ViewWizard
    extends MDBAction {
        private Table2ViewDialog table2ViewDialog;

        Table2ViewWizard() {
            super(MenuUtils.getMnemonicStr(AbstractController.T2VW_CAPTION), ControllerApplication.this.getConfiguration().getIcon("TABLE_2_VIEW_WIZARD_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.T2VW_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(65, 576, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                if (this.table2ViewDialog == null) {
                    this.table2ViewDialog = new Table2ViewDialog(ControllerApplication.this.getApplicationView(), MenuUtils.getMnemonicStr(AbstractController.T2VW_CAPTION));
                }
                this.table2ViewDialog.showDialog();
            }
            catch (Exception exception) {
                LOGGER.error("Error in Table2ViewWizard", exception);
            }
        }
    }

    class Search
    extends MDBAction {
        private Search() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.Find")), ControllerApplication.this.getConfiguration().getIcon("SEARCH_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.Find")));
            this.setAccelerator(KeyStroke.getKeyStroke(70, 128, false));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            MDBAction mDBAction;
            if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null && (mDBAction = ControllerApplication.this.getApplicationView().getCurrentDPV().getController().getSearch()) != null) {
                mDBAction.doActionPerformed(null);
            }
        }
    }

    class ActualSize
    extends MDBAction {
        private ActualSize() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.DefaultSize")), ControllerApplication.this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.DefaultSize")));
            this.setAccelerator(KeyStroke.getKeyStroke(116, 0, false));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            try {
                if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null) {
                    ControllerLogical.ActualSize actualSize = ((ControllerLogical)ControllerApplication.this.getApplicationView().getDPVLogical().getController()).getActualSize();
                    ControllerRelational.ActualSize actualSize2 = ((ControllerRelational)ControllerApplication.this.getApplicationView().getDPVRelational().getController()).getActualSize();
                    if (ControllerApplication.this.getApplicationView().getCurrentDPV() == ControllerApplication.this.getApplicationView().getDPVLogical()) {
                        ((MDBAction)actualSize).doActionPerformed(null);
                    } else {
                        ((MDBAction)actualSize2).doActionPerformed(null);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error setting Actual Size!", exception);
            }
        }
    }

    class FitScreen
    extends MDBAction {
        private FitScreen() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.FitScreen")), ControllerApplication.this.getConfiguration().getIcon("FIT_SCREEN_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.FitScreen")));
            this.setAccelerator(KeyStroke.getKeyStroke(119, 0, false));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            try {
                if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null) {
                    ControllerLogical.FitScreen fitScreen = ((ControllerLogical)ControllerApplication.this.getApplicationView().getDPVLogical().getController()).getFitScreen();
                    ControllerRelational.FitScreen fitScreen2 = ((ControllerRelational)ControllerApplication.this.getApplicationView().getDPVRelational().getController()).getFitScreen();
                    if (ControllerApplication.this.getApplicationView().getCurrentDPV() == ControllerApplication.this.getApplicationView().getDPVLogical()) {
                        ((MDBAction)fitScreen).doActionPerformed(null);
                    } else {
                        ((MDBAction)fitScreen2).doActionPerformed(null);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error Fit Screen!", exception);
            }
        }
    }

    class ZoomOut
    extends MDBAction {
        private ZoomOut() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ZoomOut")), ControllerApplication.this.getConfiguration().getIcon("ZOOM_OUT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ZoomOut")));
            this.setAccelerator(KeyStroke.getKeyStroke(118, 0, false));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            try {
                if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null) {
                    ControllerLogical.ZoomOut zoomOut = ((ControllerLogical)ControllerApplication.this.getApplicationView().getDPVLogical().getController()).getZoomOut();
                    ControllerRelational.ZoomOut zoomOut2 = ((ControllerRelational)ControllerApplication.this.getApplicationView().getDPVRelational().getController()).getZoomOut();
                    if (ControllerApplication.this.getApplicationView().getCurrentDPV() == ControllerApplication.this.getApplicationView().getDPVLogical()) {
                        ((MDBAction)zoomOut).doActionPerformed(null);
                    } else {
                        ((MDBAction)zoomOut2).doActionPerformed(null);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error Zooming out!", exception);
            }
        }
    }

    class ZoomIn
    extends MDBAction {
        private ZoomIn() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ZoomIn")), ControllerApplication.this.getConfiguration().getIcon("ZOOM_IN_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ZoomIn")));
            this.setAccelerator(KeyStroke.getKeyStroke(117, 0, false));
            this.setAllowedInToolbar(true);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            try {
                if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null) {
                    ControllerLogical.ZoomIn zoomIn = ((ControllerLogical)ControllerApplication.this.getApplicationView().getDPVLogical().getController()).getZoomIn();
                    ControllerRelational.ZoomIn zoomIn2 = ((ControllerRelational)ControllerApplication.this.getApplicationView().getDPVRelational().getController()).getZoomIn();
                    if (ControllerApplication.this.getApplicationView().getCurrentDPV() == ControllerApplication.this.getApplicationView().getDPVLogical()) {
                        ((MDBAction)zoomIn).doActionPerformed(null);
                    } else {
                        ((MDBAction)zoomIn2).doActionPerformed(null);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error Zooming in!", exception);
            }
        }
    }

    class SaveAs
    extends MDBAction {
        protected int operation;

        private SaveAs() {
            super(MenuUtils.getMnemonicStr(AbstractController.SAVE_AS_CAPTION), ControllerApplication.this.getConfiguration().getIcon("SAVE_AS_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.operation = 4;
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SAVE_AS_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(83, 192, false));
        }

        private SaveAs(String string, Icon icon) {
            super(string, icon);
            this.operation = 4;
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    ControllerApplication.this.saveAsDesign(SaveAs.this.operation);
                }
            };
            thread.start();
        }
    }

    class ExportToCWD
    extends SaveAs {
        private ExportToCWD() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ToDataModelerDesign")), ControllerApplication.this.getConfiguration().getIcon("APPLICATION_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.operation = 5;
            this.setMenuPath(EXPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ToDataModelerDesign")));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }
    }

    class Delete
    extends MDBAction {
        private Delete() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.Delete")), ControllerApplication.this.getConfiguration().getIcon("DELETE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.Delete")));
            this.setAccelerator(KeyStroke.getKeyStroke(127, 0, false));
            this.setEnabled(false);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerApplication.this.getApplicationView().getCurrentDPV().getWorkSpace().deleteAllSelected();
        }
    }

    class Paste
    extends MDBAction {
        private Paste() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.Paste")), ControllerApplication.this.getConfiguration().getIcon("PASTE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.Paste")));
            this.setAccelerator(KeyStroke.getKeyStroke(86, 128, false));
            this.setEnabled(false);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null) {
                ControllerApplication.this.getApplicationView().getCurrentDPV().getController().paste(null);
            }
        }
    }

    class Copy
    extends MDBAction {
        private Copy() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.Copy")), ControllerApplication.this.getConfiguration().getIcon("COPY_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.Copy")));
            this.setAccelerator(KeyStroke.getKeyStroke(67, 128, false));
            this.setEnabled(false);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerApplication.this.getApplicationView().clearCopiedObjects();
            Object[] objectArray = ControllerApplication.this.getApplicationView().getCurrentDPV().getSelectedObjects();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof DesignObject)) continue;
                ControllerApplication.this.getApplicationView().addCopiedObject((DesignObject)objectArray[i]);
            }
        }
    }

    class ExportToSVG
    extends MDBAction {
        ExportToSVG() {
            super(MenuUtils.getMnemonicStr(AbstractController.TO_SVG_CAPTION), ControllerApplication.this.getConfiguration().getIcon("EXPORT_TO_IMAGE", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_DIAGRAM_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.TO_SVG_CAPTION));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Diagram diagram = (Diagram)ControllerApplication.this.getApplicationView().getSelectedWorkSpaceComponent();
                        Object[] objectArray = diagram.getSelectionCells();
                        try {
                            diagram.clearSelection();
                            diagram.setCursor(Cursor.getPredefinedCursor(3));
                            try {
                                Dimension dimension = diagram.getPreferredScrollableViewportSize();
                                if (dimension.height <= 0 || dimension.width <= 0) {
                                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("ControllerApplication.NoPrintableArea")}, Messages.getString("ControllerApplication.Information"), 2);
                                    return;
                                }
                                new SVGExporter(ControllerApplication.this.getApplicationView()).export(diagram);
                            }
                            finally {
                                diagram.setCursor(Cursor.getPredefinedCursor(0));
                            }
                        }
                        finally {
                            diagram.setSelectionCells(objectArray);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error Printing to SVG File!", exception);
                    }
                }
            };
            thread.setPriority(10);
            thread.start();
        }
    }

    class ExportToPDF
    extends MDBAction {
        ExportToPDF() {
            super(MenuUtils.getMnemonicStr(AbstractController.TO_PDF_CAPTION), ControllerApplication.this.getConfiguration().getIcon("EXPORT_TO_IMAGE", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_DIAGRAM_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.TO_PDF_CAPTION));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Diagram diagram = (Diagram)ControllerApplication.this.getApplicationView().getSelectedWorkSpaceComponent();
                        Object[] objectArray = diagram.getSelectionCells();
                        try {
                            diagram.clearSelection();
                            diagram.setCursor(Cursor.getPredefinedCursor(3));
                            try {
                                Dimension dimension = diagram.getPreferredScrollableViewportSize();
                                if (dimension.height <= 0 || dimension.width <= 0) {
                                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("ControllerApplication.NoPrintableArea")}, Messages.getString("ControllerApplication.Information"), 2);
                                    return;
                                }
                                new PDFExporter(ControllerApplication.this.getApplicationView()).export(diagram);
                            }
                            finally {
                                diagram.setCursor(Cursor.getPredefinedCursor(0));
                            }
                        }
                        finally {
                            diagram.setSelectionCells(objectArray);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error Printing to PDF File!", exception);
                    }
                }
            };
            thread.setPriority(10);
            thread.start();
        }
    }

    class ExportToImage
    extends MDBAction {
        ExportToImage() {
            super(MenuUtils.getMnemonicStr(AbstractController.TO_IMAGE_CAPTION), ControllerApplication.this.getConfiguration().getIcon("EXPORT_TO_IMAGE", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_DIAGRAM_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.TO_IMAGE_CAPTION));
        }

        @Override
        public boolean addSeparatorAfterInRoot() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Diagram diagram = (Diagram)ControllerApplication.this.getApplicationView().getSelectedWorkSpaceComponent();
                        Object[] objectArray = diagram.getSelectionCells();
                        try {
                            diagram.clearSelection();
                            diagram.setCursor(Cursor.getPredefinedCursor(3));
                            try {
                                Dimension dimension = diagram.getPreferredScrollableViewportSize();
                                if (dimension.height <= 0 || dimension.width <= 0) {
                                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("ControllerApplication.NoPrintableArea")}, Messages.getString("ControllerApplication.Information"), 2);
                                    return;
                                }
                                new ImageExporter(ControllerApplication.this.getApplicationView()).export(diagram);
                            }
                            finally {
                                diagram.setCursor(Cursor.getPredefinedCursor(0));
                            }
                        }
                        finally {
                            diagram.setSelectionCells(objectArray);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error Printing to Image File!", exception);
                    }
                }
            };
            thread.setPriority(10);
            thread.start();
        }
    }

    class CompareModels
    extends MDBAction {
        CompareModels() {
            super(MenuUtils.getMnemonicStr(AbstractController.CM_CAPTION), ControllerApplication.this.getConfiguration().getIcon("COMPARE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.CM_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(77, 576, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        URLFilter uRLFilter = new URLFilter(){

                            public boolean accept(URL uRL) {
                                File file = new File(uRL.getPath());
                                return file.getName().toLowerCase().endsWith(".dmd") || file.getName().toLowerCase().endsWith(".dmdz") || file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                            }

                            public String toString() {
                                return Messages.getString("ControllerApplication.OracleSQLDeveloperModelingDesigns");
                            }
                        };
                        URLChooser uRLChooser = DialogUtil.newURLChooser();
                        uRLChooser.clearChooseableURLFilters();
                        uRLChooser.setSelectionScope(0);
                        uRLChooser.setSelectionMode(0);
                        uRLChooser.setShowJarsAsDirs(false);
                        uRLChooser.setURLFilter(uRLFilter);
                        String string = ControllerApplication.this.getApplicationView().getSettings().getDefaultDesignsPath();
                        if (string != null) {
                            uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                        } else {
                            URL uRL = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                            if (uRL != null) {
                                uRLChooser.setSelectedURL(uRL);
                            }
                        }
                        int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ImportDesign"));
                        if (n == 0) {
                            File file = new File(uRLChooser.getSelectedURL().getPath());
                            if (file != null && file.isFile()) {
                                try {
                                    ModelChooserDialog modelChooserDialog = new ModelChooserDialog(ControllerApplication.this.getApplicationView(), file);
                                    modelChooserDialog.setVisible(true);
                                }
                                catch (Exception exception) {
                                    LOGGER.error("Error in Engineering status", exception);
                                }
                            }
                        } else {
                            ApplicationView.log(Messages.getString("ControllerApplication.CompareModelsCanceled"));
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error Importing Oracle SQL Developer Modeling Designer!", exception);
                    }
                }
            };
            thread.start();
        }
    }

    class RDBMSSiteAdministration
    extends MDBAction {
        private RDBMSSiteEditor rdbmsSiteEditor;

        RDBMSSiteAdministration() {
            super(MenuUtils.getMnemonicStr(AbstractController.RDBMS_SITE_CAPTION), ControllerApplication.this.getConfiguration().getIcon("RDBMS_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.RDBMS_SITE_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(66, 576, false));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                this.rdbmsSiteEditor = new RDBMSSiteEditor(ControllerApplication.this.getApplicationView());
                if (!this.rdbmsSiteEditor.isDialogVisible()) {
                    this.rdbmsSiteEditor.showDialog();
                    this.rdbmsSiteEditor.refreshCurrentRDBMSSiteList();
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error in RDBMSSiteEditor", exception);
            }
        }
    }

    class TypesAdministration
    extends MDBAction {
        private TypesAdmin typesAdmin;

        TypesAdministration() {
            super(MenuUtils.getMnemonicStr(AbstractController.TA_CAPTION), ControllerApplication.this.getConfiguration().getIcon("TYPES_ADMIN_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.TA_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(84, 576, false));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            try {
                this.typesAdmin = new TypesAdmin(ControllerApplication.this.getApplicationView());
                this.typesAdmin.showDialog();
            }
            catch (Exception exception) {
                LOGGER.error("Error in Types Administration", exception);
            }
        }
    }

    class DomainsAdministration
    extends MDBAction {
        private DomainAdmin domainAdmin;

        DomainsAdministration() {
            super(MenuUtils.getMnemonicStr(AbstractController.DA_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DOMAIN_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DA_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(68, 576, false));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                this.domainAdmin = new DomainAdmin(ControllerApplication.this.getApplicationView());
                this.domainAdmin.showDialog();
            }
            catch (Exception exception) {
                LOGGER.error("Error in Domains Administration", exception);
            }
        }
    }

    class NamesStandardization
    extends MDBAction {
        NamesStandardization() {
            super(MenuUtils.getMnemonicStr(AbstractController.NS_CAPTION), ControllerApplication.this.getConfiguration().getIcon("NAMES_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NS_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(78, 576, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                NamesStandardizationDialog namesStandardizationDialog = new NamesStandardizationDialog(ControllerApplication.this.getApplicationView());
                namesStandardizationDialog.showDialog();
            }
            catch (Exception exception) {
                LOGGER.error("Error in Names Standardization!", exception);
            }
        }
    }

    class RestoreLostMappings
    extends MDBAction {
        RestoreLostMappings() {
            super(Messages.getString("ControllerApplication.RestoreMappings"), ControllerApplication.this.getConfiguration().getIcon("NAMES_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                RestoreMappings restoreMappings = new RestoreMappings(ControllerApplication.this.getDesign());
                restoreMappings.restore();
            }
            catch (Exception exception) {
                LOGGER.error("Error in Restore Mappings!", exception);
            }
        }
    }

    public class SaveAll
    extends MDBAction {
        public SaveAll() {
            super(MenuUtils.getMnemonicStr(AbstractController.SAVE_DESIGN_CAPTION), ControllerApplication.this.getConfiguration().getIcon("SAVE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SAVE_DESIGN_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(83, 128, false));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                if (design.isOldRepositoryType() || design.getLoadedVersion() < design.getVersion() && !design.canUpgradeInPlace()) {
                    JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), oracle.dbtools.crest.model.Messages.getString("Design.ThisDesignIsInOldFormat"), oracle.dbtools.crest.model.Messages.getString("Design.Warning"), 0, 1, null, new String[]{oracle.dbtools.crest.model.Messages.getString("Design.OK")}, oracle.dbtools.crest.model.Messages.getString("Design.OK"));
                } else {
                    ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                    this.execute();
                }
            }
        }

        public void execute() {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        Design design = ControllerApplication.this.getDesign();
                        if (design.isNewDesign() || "".equalsIgnoreCase(ControllerApplication.this.getApplicationView().getCurrentDesign().getDesignPath())) {
                            ControllerApplication.this.saveAsDesign(4);
                        } else {
                            ControllerApplication.this.saveDesign(design);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error Save All!", exception);
                    }
                }
            };
            thread.start();
        }
    }

    class CloseStorageDesign
    extends MDBAction {
        private CloseStorageDesign() {
            super(MenuUtils.getMnemonicStr(AbstractController.CLOSE_STORAGE_DESIGN_CAPTION), ControllerApplication.this.getConfiguration().getIcon("CLOSE_STORAGE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(STORAGE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.CLOSE_STORAGE_DESIGN_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(67, 576, false));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            try {
                RelationalDesign relationalDesign = ControllerApplication.this.getApplicationView().selectRelationalDesign();
                if (relationalDesign != null) {
                    StorageDesign[] storageDesignArray = relationalDesign.getStorageDesignFactory().getOpenStorageDesigns();
                    for (int i = 0; i < storageDesignArray.length; ++i) {
                        StorageDesign storageDesign = storageDesignArray[i];
                        if (!ControllerApplication.this.getApplicationView().closeStorageDesign(storageDesign)) continue;
                        ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.ClosePhysicalModel"), storageDesign.getName()));
                        storageDesign.close();
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error Closing Storage Design!", exception);
            }
        }
    }

    class OpenStorageDesign
    extends MDBAction {
        private OpenStorageDesign() {
            super(MenuUtils.getMnemonicStr(AbstractController.OPEN_STORAGE_DESIGN_CAPTION), ControllerApplication.this.getConfiguration().getIcon("OPEN_STORAGE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(STORAGE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.OPEN_STORAGE_DESIGN_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(79, 576, false));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block13: {
                        try {
                            RelationalDesign relationalDesign = ControllerApplication.this.getApplicationView().selectRelationalDesign();
                            if (relationalDesign == null) break block13;
                            ControllerApplication.this.getDesign().setRelationalDesign(relationalDesign);
                            Object[] objectArray = ControllerApplication.this.getApplicationView().getCurrentDesign().getRDBMSSiteSet().toSiteArray();
                            RDBMSSite rDBMSSite = null;
                            rDBMSSite = (RDBMSSite)JListDialog.showDialog(ControllerApplication.this.getApplicationView().getFrame(), Messages.getString("ControllerApplication.SelectSite"), Messages.getString("ControllerApplication.DatabaseSites"), objectArray, relationalDesign.getSelectedRDBMSSite());
                            if (rDBMSSite == null) {
                                ApplicationView.log(Messages.getString("ControllerApplication.OpenPhysicalModelCanceled"));
                                break block13;
                            }
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                            try {
                                ProgressDialog progressDialog = new ProgressDialog(ControllerApplication.this.getApplicationView(), "", 0, 100);
                                try {
                                    ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.OpenPhysicalModel"), rDBMSSite));
                                    ApplicationView.canLogging = false;
                                    progressDialog.setNote(MessageFormat.format(Messages.getString("ControllerApplication.OpenDesignP"), String.valueOf(rDBMSSite)));
                                    progressDialog.setProgress(50);
                                    StorageDesign storageDesign = relationalDesign.getStorageDesign(rDBMSSite);
                                    if (ControllerApplication.this.getApplicationView().getCurrentDesign().isLoadFromDB()) {
                                        AbstractRepositoryManager abstractRepositoryManager = ControllerApplication.this.getApplicationView().getDBPersistenceManager().getDBRepositoryManager();
                                        abstractRepositoryManager.readPhysicalModel(storageDesign);
                                    } else if (relationalDesign.getDesign().isOldRepositoryType()) {
                                        storageDesign.load();
                                    } else {
                                        ControllerApplication.this.getApplicationView().getXMLTransformationManager().openPhysicalModel(storageDesign);
                                    }
                                    progressDialog.setProgress(100);
                                    storageDesign.setOpen(true);
                                }
                                finally {
                                    progressDialog.close();
                                    ApplicationView.canLogging = true;
                                    ApplicationView.log(Messages.getString("ControllerApplication.OpenPhysicalModelFinished"));
                                }
                            }
                            finally {
                                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                            }
                        }
                        catch (Exception exception) {
                            LOGGER.error("Error Opening Storage Design!", exception);
                        }
                    }
                }
            };
            thread.start();
        }
    }

    public class ExitApplication
    extends MDBAction {
        private ExitApplication() {
            super(MenuUtils.getMnemonicStr(AbstractController.EXIT_CAPTION), ControllerApplication.this.getConfiguration().getIcon("EXIT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.EXIT_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(115, 512, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerApplication.this.getApplicationView().exitApplication();
        }
    }

    public class CloseAllDesigns
    extends MDBAction {
        public CloseAllDesigns() {
            super(MenuUtils.getMnemonicStr(AbstractController.CLOSE_ALL_DESIGNS_CAPTION), ControllerApplication.this.getConfiguration().getIcon("CLOSE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.CLOSE_ALL_DESIGNS_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(65, 128, false));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerApplication.this.getApplicationView().closeAllDesigns();
            if (Extension.isSVNExtensionLoaded()) {
                SVNChangeListWindow.removeAllDesignsFromScope();
                SVNHistoryWindow.getInstance().clear();
                SVNMergeWindow.getInstance().clear();
                SVNViewPropertiesWindow.getInstance().clear();
            }
        }
    }

    public class CloseDesign
    extends MDBAction {
        public CloseDesign() {
            super(MenuUtils.getMnemonicStr(AbstractController.CLOSE_DESIGN_CAPTION), ControllerApplication.this.getConfiguration().getIcon("CLOSE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.CLOSE_DESIGN_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(87, 128, false));
        }

        @Override
        public boolean addSeparatorAfter() {
            return false;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            int n = 0x100000;
            Runtime runtime = Runtime.getRuntime();
            System.out.println("close before execute end memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
            System.gc();
            System.runFinalization();
            System.out.println("close after execute end memory  total  " + runtime.totalMemory() / (long)n + "  /memory  fre  " + runtime.freeMemory() / (long)n + "  /used memory  " + (runtime.totalMemory() - runtime.freeMemory()) / (long)n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block27: {
                try {
                    ControllerApplication.this.getApplicationView().cancel = false;
                    Design design = ControllerApplication.this.getApplicationView().getCurrentDesign();
                    if (!ApplicationView.IS_VIEWER) {
                        if (!ControllerApplication.this.getDesign().isLoadFromDB() && (ControllerApplication.this.getDesign().isNewDesign() || "".equalsIgnoreCase(ControllerApplication.this.getApplicationView().getCurrentDesign().getDesignPath()))) {
                            Object[] objectArray = ControllerApplication.this.getApplicationView().whatToSave(true);
                            if (objectArray != null && objectArray.length > 0) {
                                objectArray = ApplicationView.checkAndAddDesign(ControllerApplication.this.getDesign(), objectArray);
                            }
                            if (objectArray != null && objectArray.length > 0) {
                                String string;
                                String string2 = ControllerApplication.this.getApplicationView().getCurrentDesign().getDesignPath();
                                String string3 = null;
                                if (!ControllerApplication.this.getDesign().isNewDesign()) {
                                    string3 = ControllerApplication.this.getDesign().getName();
                                }
                                if ((string = ControllerApplication.this.getApplicationView().selectDesignName(string3)) != null) {
                                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                                    try {
                                        boolean bl = ControllerApplication.this.getApplicationView().overwriteDesign(string);
                                        if (!bl) {
                                            while (string != null && !bl) {
                                                string = ControllerApplication.this.getApplicationView().selectDesignName(string);
                                                if (string != null) {
                                                    bl = ControllerApplication.this.getApplicationView().overwriteDesign(string);
                                                    continue;
                                                }
                                                bl = false;
                                            }
                                        }
                                        if (bl) {
                                            design.setFileName(string);
                                            ControllerApplication.this.getApplicationView().setDesignName(string);
                                            ControllerApplication.this.getApplicationView().synchronizeTitle();
                                            ControllerApplication.this.getApplicationView().getXMLTransformationManager().setCheckDirty(!ControllerApplication.this.getDesign().isNewDesign());
                                            ApplicationView.log(Messages.getString("ControllerApplication.SavingDesignAndPhysicalModels"));
                                            ControllerApplication.this.getApplicationView().doSave(objectArray);
                                            ControllerApplication.this.getApplicationView().getCurrentDesign().setNewDesign(false);
                                            ControllerApplication.this.getApplicationView().addRecent(ControllerApplication.this.getApplicationView().getDesignName(), ControllerApplication.this.getApplicationView().getCurrentDesign().getDesignPath());
                                            ControllerApplication.this.getApplicationView().getCurrentDesign().setReadOnly(false);
                                            ControllerApplication.this.getApplicationView().getCurrentDesign().setDirty(false);
                                        }
                                        ControllerApplication.this.getApplicationView().getCurrentDesign().setDesignPath(string2);
                                        ApplicationView.log(Messages.getString("ControllerApplication.SaveDesignAsCanceled"));
                                    }
                                    finally {
                                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                                    }
                                } else {
                                    ApplicationView.log(Messages.getString("ControllerApplication.SaveDesignAsCanceled"));
                                    ControllerApplication.this.getApplicationView().cancel = true;
                                }
                            }
                        } else {
                            Object[] objectArray = ControllerApplication.this.getApplicationView().whatToSave(false);
                            if (objectArray != null && objectArray.length > 0) {
                                try {
                                    objectArray = ApplicationView.checkAndAddDesign(ControllerApplication.this.getDesign(), objectArray);
                                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                                    ControllerApplication.this.getApplicationView().doSave(objectArray);
                                }
                                finally {
                                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                                }
                            }
                        }
                    }
                    if (ControllerApplication.this.getApplicationView().cancel) break block27;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        ApplicationView.log(Messages.getString("ControllerApplication.CloseDesign") + ControllerApplication.this.getApplicationView().getDesignName());
                        if (Extension.isSVNExtensionLoaded()) {
                            SVNChangeListWindow.removeFromScope(design);
                            SVNHistoryWindow.getInstance().clearForDesign(design);
                            SVNMergeWindow.getInstance().clearForDesign(design);
                            SVNViewPropertiesWindow.getInstance().clearForDesign(design);
                        }
                        ControllerApplication.this.getApplicationView().removeDesign(design);
                        if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null) {
                            ControllerApplication.this.getApplicationView().getCurrentDPV().setCurrentSelection(null, null);
                        }
                        design = ControllerApplication.this.getApplicationView().getCurrentDesign();
                        ControllerApplication.this.getApplicationView().clearTitle();
                        design.setSelectedRDBMSSite(null);
                        design.setDirty(false);
                        ControllerApplication.this.getApplicationView().getCurrentDesign().setDirty(false);
                        ControllerApplication.this.getApplicationView().getBrowserPanel().expandToPath(ControllerApplication.this.getDesign().getPath());
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error Closing Design!", exception);
                }
            }
        }
    }

    class OpenDesign
    extends MDBAction {
        private String ext;
        private String designPath;

        private OpenDesign() {
            super(MenuUtils.getMnemonicStr(AbstractController.OPEN_DESIGN_CAPTION), ControllerApplication.this.getConfiguration().getIcon("OPEN_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.ext = ".dmd";
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.OPEN_DESIGN_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(79, 128, false));
        }

        private String selectDesign() {
            URLFilter uRLFilter = new URLFilter(){

                public boolean accept(URL uRL) {
                    File file = new File(uRL.getPath());
                    return file.getName().toLowerCase().endsWith(".dmd") || file.getName().toLowerCase().endsWith(".dmdz") || file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("ControllerApplication.OracleSQLDeveloperModelingDesigns");
                }
            };
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.clearChooseableURLFilters();
            uRLChooser.setSelectionScope(0);
            uRLChooser.setSelectionMode(0);
            uRLChooser.setShowJarsAsDirs(false);
            uRLChooser.setURLFilter(uRLFilter);
            String string = ControllerApplication.this.getApplicationView().getSettings().getDefaultDesignsPath();
            if (string != null) {
                uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
            } else {
                URL uRL = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                if (uRL != null) {
                    uRLChooser.setSelectedURL(uRL);
                }
            }
            int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.OpenDesign"));
            if (n == 0) {
                File file = new File(uRLChooser.getSelectedURL().getPath());
                if (file != null && file.exists()) {
                    this.designPath = file.getParent();
                    String string2 = file.getName();
                    String string3 = FileUtils.removeExt(string2);
                    Design design = ControllerApplication.this.findDesign(this.designPath + "/" + string3);
                    if (design != null) {
                        MessageDialogs.showWarningMessage("Design: '" + string3 + "' is already opened.");
                        ControllerApplication.this.getApplicationView().getBrowserPanel().expandToPath(design.getPath());
                        return null;
                    }
                    int n2 = string2.lastIndexOf(".");
                    if (n2 > -1) {
                        this.ext = string2.substring(n2);
                    }
                    return string3;
                }
                MessageDialogs.showWarningMessage("Selected Design does not exists.");
                return null;
            }
            return null;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerApplication.this.doOpenDesign(this.selectDesign(), this.designPath, this.ext, false);
        }
    }

    class ImportDomainFile
    extends MDBAction {
        private ImportDomainFile() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_DOMAINS_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DOMAIN_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_DOMAINS_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(77, 192, false));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            ImportDomainsDialog importDomainsDialog = new ImportDomainsDialog(ControllerApplication.this.getApplicationView(), ControllerApplication.this.getDesign().getLogicalDesign());
            importDomainsDialog.show();
        }
    }

    class ImportCWD4ALLDesigner
    extends MDBAction {
        private ImportCWD4ALLDesigner() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.DataModelingDesign")), ControllerApplication.this.getConfiguration().getIcon("APPLICATION_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.DataModelingDesign")));
            this.setAccelerator(KeyStroke.getKeyStroke(87, 192, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return !ApplicationView.LOGICAL_MODEL_ONLY;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        URLFilter uRLFilter = new URLFilter(){

                            public boolean accept(URL uRL) {
                                File file = new File(uRL.getPath());
                                return file.getName().toLowerCase().endsWith(".dmd") || file.getName().toLowerCase().endsWith(".dmdz") || file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                            }

                            public String toString() {
                                return Messages.getString("ControllerApplication.OracleSQLDeveloperModelingDesigns");
                            }
                        };
                        URLChooser uRLChooser = DialogUtil.newURLChooser();
                        uRLChooser.clearChooseableURLFilters();
                        uRLChooser.setSelectionScope(0);
                        uRLChooser.setSelectionMode(0);
                        uRLChooser.setShowJarsAsDirs(false);
                        uRLChooser.setURLFilter(uRLFilter);
                        String string = ControllerApplication.this.getApplicationView().getSettings().getDefaultDesignsPath();
                        if (string != null) {
                            uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                        } else {
                            URL uRL = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                            if (uRL != null) {
                                uRLChooser.setSelectedURL(uRL);
                            }
                        }
                        int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ImportDesign"));
                        if (n == 0) {
                            File file = new File(uRLChooser.getSelectedURL().getPath());
                            if (file != null) {
                                CWDExtractionWizard cWDExtractionWizard = new CWDExtractionWizard(ControllerApplication.this.getApplicationView(), file);
                                cWDExtractionWizard.setVisible(true);
                            }
                        } else {
                            ApplicationView.log(Messages.getString("ControllerApplication.ImportDesignCanceled"));
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error Importing Oracle SQL Developer Modeling Designer!", exception);
                    }
                }
            };
            thread.start();
        }
    }

    class ExportToReportsSchema
    extends MDBAction {
        private ExportToReportsSchema() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ToReportModel")), ControllerApplication.this.getConfiguration().getIcon("REPORTS_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ToReportModel")));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        try {
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                            ApplicationView.log("Exporting to Reports Schema");
                            ExportReportsDialog exportReportsDialog = new ExportReportsDialog(ControllerApplication.this.getApplicationView());
                            if (exportReportsDialog.showDialog()) {
                                ReportsHandler reportsHandler = new ReportsHandler(ControllerApplication.this.getApplicationView(), exportReportsDialog.getConnection(), exportReportsDialog.getComments(), exportReportsDialog.exportDiagramsAsPDF());
                                reportsHandler.export();
                            }
                        }
                        finally {
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.error("Error in Export to Reports Schema.", exception);
                    }
                }
            };
            thread.start();
        }
    }

    class ExportToCSV
    extends MDBAction {
        private ExportToCSV() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ToCSV")), ControllerApplication.this.getConfiguration().getIcon("CSV_FILE", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ToCSV")));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                SelectCSVExportDialog selectCSVExportDialog = new SelectCSVExportDialog(ControllerApplication.this.getApplicationView());
                boolean bl = selectCSVExportDialog.showDialog();
                if (!bl) {
                    ApplicationView.log(Messages.getString("ControllerApplication.ExportToCSVCanceled"));
                    return;
                }
                FileFilter fileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getName().toLowerCase().endsWith(".csv");
                    }
                };
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setSelectionScope(1);
                uRLChooser.setSelectionMode(0);
                uRLChooser.setShowJarsAsDirs(false);
                String string = ControllerApplication.this.getApplicationView().getSettings().getLastExportFolder();
                if (string != null) {
                    uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                } else {
                    URL uRL = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                    if (uRL != null) {
                        uRLChooser.setSelectedURL(uRL);
                    }
                }
                int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.SelectFolder"));
                if (n == 0) {
                    File file = new File(uRLChooser.getSelectedURL().getPath());
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    if (file.exists()) {
                        Object object;
                        ControllerApplication.this.getApplicationView().getSettings().setLastExportFolder(file.getPath());
                        if (file.exists() && ((File[])(object = file.listFiles(fileFilter))).length > 0) {
                            int n2 = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.FolderContainsCSVfilesDeleted"), Messages.getString("ControllerApplication.Warning"), 0, 3);
                            if (n2 == 1) {
                                ApplicationView.log(Messages.getString("ControllerApplication.ExportToCSVCanceled"));
                                return;
                            }
                            for (int i = ((Object)object).length - 1; i >= 0; --i) {
                                Object object2 = object[i];
                                ((File)object2).delete();
                            }
                        }
                        object = new CSVExporter(ControllerApplication.this.getApplicationView());
                        ((CSVExporter)object).setExportFolder(file.getPath());
                        ((CSVExporter)object).setDesignPartObjects(selectCSVExportDialog.getDesignPartObjects());
                        ((CSVExporter)object).execute();
                        ApplicationView.log(MessageFormat.format(Messages.getString("ControllerApplication.ExportToCSV"), file.getPath()));
                    } else {
                        ApplicationView.log(Messages.getString("ControllerApplication.ExportToCSVFailed"));
                    }
                } else {
                    ApplicationView.log(Messages.getString("ControllerApplication.ExportToCSVCanceled"));
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error in Export to CSV!", exception);
            }
        }
    }

    class ExportXMLA
    extends MDBAction {
        private ExportXMLA() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ToMicrosoftXMLA")), ControllerApplication.this.getConfiguration().getIcon("XMLA_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ToMicrosoftXMLA")));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            try {
                try {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    ApplicationView.log(Messages.getString("ControllerApplication.ExportAsXMLAFile"));
                    XMLAExporter xMLAExporter = new XMLAExporter(ControllerApplication.this.getApplicationView());
                    xMLAExporter.export();
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error in Export as XMLA File!", exception);
            }
        }
    }

    class ExportToOracleAW
    extends MDBAction {
        private ExportToOracleAW() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.ToOracleAW")), ControllerApplication.this.getConfiguration().getIcon("XML_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.ToOracleAW")));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            try {
                try {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    ApplicationView.log(Messages.getString("ControllerApplication.ExportToOracleAW"));
                    OracleAWExporter oracleAWExporter = new OracleAWExporter(ControllerApplication.this.getApplicationView());
                    oracleAWExporter.export();
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error in Export to Oracle AW!", exception);
            }
        }
    }

    class ExportCubeViewsXML
    extends MDBAction {
        private ExportCubeViewsXML() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.CubeViewsMetadata")), ControllerApplication.this.getConfiguration().getIcon("XML_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EXPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.CubeViewsMetadata")));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            try {
                try {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    ApplicationView.log(Messages.getString("ControllerApplication.ExportCubeViewsMetaData"));
                    CubeViewsExporter cubeViewsExporter = new CubeViewsExporter(ControllerApplication.this.getApplicationView());
                    cubeViewsExporter.export();
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            catch (Exception exception) {
                LOGGER.error("Error Exporting Cube Views Meta Data!", exception);
            }
        }
    }

    class ImportOracleDesigner
    extends MDBAction {
        private ImportOracleDesigner() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_OD_CAPTION), ControllerApplication.this.getConfiguration().getIcon("OD_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_OD_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(79, 192, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                boolean bl = !ControllerApplication.this.getDesign().isNewDesign();
                ODExtractionWizard oDExtractionWizard = new ODExtractionWizard(ControllerApplication.this.getApplicationView(), bl);
                oDExtractionWizard.setVisible(true);
            }
            catch (Exception exception) {
                LOGGER.error("Error Importing Oracle Designer!", exception);
            }
        }
    }

    class ImportDBMetadata
    extends MDBAction {
        private ImportDBMetadata() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_MD_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DBM_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_MD_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(66, 192, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        public void execute() {
            try {
                DBMExtractionWizard dBMExtractionWizard = new DBMExtractionWizard(ControllerApplication.this.getApplicationView());
                dBMExtractionWizard.setVisible(true);
            }
            catch (Exception exception) {
                LOGGER.error("Error Importing DB Metadata!", exception);
            }
        }
    }

    class ImportERwin7
    extends MDBAction {
        private ImportERwin7() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_ERWIN7_CAPTION), ControllerApplication.this.getConfiguration().getIcon("XML_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_ERWIN7_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(82, 192, false));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectFirstDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block10: {
                try {
                    Object object;
                    if (!ControllerApplication.this.designIsEmpty()) {
                        object = ControllerApplication.this.getApplicationView().addDesign(false);
                        ControllerApplication.this.getApplicationView().setCurrentDesign((Design)object);
                    }
                    object = new URLFilter(){

                        public boolean accept(URL uRL) {
                            File file = new File(uRL.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("ControllerApplication.ERwin7xFiles");
                        }
                    };
                    URLChooser uRLChooser = DialogUtil.newURLChooser();
                    uRLChooser.clearChooseableURLFilters();
                    uRLChooser.setSelectionScope(0);
                    uRLChooser.setSelectionMode(0);
                    uRLChooser.setShowJarsAsDirs(false);
                    uRLChooser.setURLFilter((URLFilter)object);
                    String string = ControllerApplication.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (string != null) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                    } else {
                        URL uRL = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                        if (uRL != null) {
                            uRLChooser.setSelectedURL(uRL);
                        }
                    }
                    int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ImportERwinFileTitle"));
                    if (n != 0) break block10;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        File file = new File(uRLChooser.getSelectedURL().getPath());
                        if (file != null) {
                            ApplicationView.log(Messages.getString("ControllerApplication.ImportERwinFileTitle"));
                            ERwinHandler eRwinHandler = new ERwinHandler(ControllerApplication.this.getApplicationView(), false);
                            eRwinHandler.parse(file, 7);
                        }
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error Importing ERwin 7.x File", exception);
                }
            }
        }
    }

    class ImportERwin4
    extends MDBAction {
        private ImportERwin4() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_ERWIN4_CAPTION), ControllerApplication.this.getConfiguration().getIcon("XML_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_ERWIN4_CAPTION));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block10: {
                try {
                    Object object;
                    if (!ControllerApplication.this.designIsEmpty()) {
                        object = ControllerApplication.this.getApplicationView().addDesign(false);
                        ControllerApplication.this.getApplicationView().setCurrentDesign((Design)object);
                    }
                    object = new URLFilter(){

                        public boolean accept(URL uRL) {
                            File file = new File(uRL.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("ControllerApplication.ERwin4xFiles");
                        }
                    };
                    URLChooser uRLChooser = DialogUtil.newURLChooser();
                    uRLChooser.clearChooseableURLFilters();
                    uRLChooser.setSelectionScope(0);
                    uRLChooser.setSelectionMode(0);
                    uRLChooser.setShowJarsAsDirs(false);
                    uRLChooser.setURLFilter((URLFilter)object);
                    String string = ControllerApplication.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (string != null) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                    } else {
                        URL uRL = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                        if (uRL != null) {
                            uRLChooser.setSelectedURL(uRL);
                        }
                    }
                    int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ImportERwinFileTitle"));
                    if (n != 0) break block10;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        File file = new File(uRLChooser.getSelectedURL().getPath());
                        if (file != null) {
                            ApplicationView.log(Messages.getString("ControllerApplication.ImportERwinFileTitle"));
                            ERwinHandler eRwinHandler = new ERwinHandler(ControllerApplication.this.getApplicationView(), false);
                            eRwinHandler.parse(file, 4);
                        }
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error Importing ERwin 4.x File", exception);
                }
            }
        }
    }

    class ImportXMLA
    extends MDBAction {
        private ImportXMLA() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_XMLA_CAPTION), ControllerApplication.this.getConfiguration().getIcon("XMLA_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_XMLA_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(65, 192, false));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block11: {
                try {
                    Object object;
                    if (!ControllerApplication.this.designIsEmpty()) {
                        object = ControllerApplication.this.getApplicationView().addDesign(false);
                        ControllerApplication.this.getApplicationView().setCurrentDesign((Design)object);
                    }
                    object = new URLFilter(){

                        public boolean accept(URL uRL) {
                            File file = new File(uRL.getPath());
                            return file.getName().toLowerCase().endsWith(".xmla") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("ControllerApplication.XMLAFiles");
                        }
                    };
                    URLChooser uRLChooser = DialogUtil.newURLChooser();
                    uRLChooser.clearChooseableURLFilters();
                    uRLChooser.setSelectionScope(0);
                    uRLChooser.setSelectionMode(0);
                    uRLChooser.setShowJarsAsDirs(false);
                    uRLChooser.setURLFilter((URLFilter)object);
                    String string = ControllerApplication.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (string != null) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                    } else {
                        URL uRL = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                        if (uRL != null) {
                            uRLChooser.setSelectedURL(uRL);
                        }
                    }
                    int n = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ImportXMLAFileTitle"));
                    if (n != 0) break block11;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        File file = new File(uRLChooser.getSelectedURL().getPath());
                        if (file != null) {
                            String string2 = file.getName();
                            int n2 = string2.lastIndexOf(46);
                            if (n2 > -1) {
                                string2 = string2.substring(0, n2);
                            }
                            ApplicationView.log(Messages.getString("ControllerApplication.ImportXMLAFileTitle"));
                            boolean bl = !ControllerApplication.this.getDesign().isNewDesign();
                            XMLAHandler xMLAHandler = new XMLAHandler(ControllerApplication.this.getApplicationView(), bl);
                            xMLAHandler.parse(file);
                        }
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error Importing XMLA File!", exception);
                }
            }
        }
    }

    class ImportCubeViewsXML
    extends MDBAction {
        private ImportCubeViewsXML() {
            super(MenuUtils.getMnemonicStr(Messages.getString("ControllerApplication.CubeViewsMetadata")), ControllerApplication.this.getConfiguration().getIcon("XML_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(Messages.getString("ControllerApplication.CubeViewsMetadata")));
            this.setAccelerator(KeyStroke.getKeyStroke(67, 192, false));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block13: {
                String string;
                Object object;
                Object object2;
                int n = ControllerApplication.this.getLogicalDesign().getEntitySet().size();
                int n2 = 0;
                int n3 = 0;
                boolean bl = false;
                Iterator iterator = ControllerApplication.this.getDesign().getRelationalDesigns().iterator();
                while (iterator.hasNext()) {
                    object2 = (RelationalDesign)iterator.next();
                    n2 += ((RelationalDesign)object2).getTableSet().size();
                    ++n3;
                }
                if (!ControllerApplication.this.getDesign().isNewDesign() || n + n2 > 0) {
                    object2 = MessageFormat.format(Messages.getString("ControllerApplication.LogicalModelEntities"), String.valueOf(n));
                    object = MessageFormat.format(Messages.getString("ControllerApplication.TablesInrelationalModel"), String.valueOf(n2), String.valueOf(n3));
                    string = Messages.getString("ControllerApplication.ImportToCurrentDesign");
                    int n4 = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), (String)object2 + (String)object + string, Messages.getString("ControllerApplication.CubeViewsImportToExistingDesign"), 0);
                    if (n4 != 0) {
                        return;
                    }
                    bl = true;
                }
                try {
                    object2 = new URLFilter(){

                        public boolean accept(URL uRL) {
                            File file = new File(uRL.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("ControllerApplication.CubeViewsMetadataFiles");
                        }
                    };
                    object = DialogUtil.newURLChooser();
                    object.clearChooseableURLFilters();
                    object.setSelectionScope(0);
                    object.setSelectionMode(0);
                    object.setShowJarsAsDirs(false);
                    object.setURLFilter((URLFilter)object2);
                    string = ControllerApplication.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (string != null) {
                        object.setSelectedURL(URLFactory.newDirURL((String)string));
                    } else {
                        URL uRL = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                        if (uRL != null) {
                            object.setSelectedURL(uRL);
                        }
                    }
                    int n5 = object.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.ImportCubeViewsMetadata"));
                    if (n5 != 0) break block13;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        File file = new File(object.getSelectedURL().getPath());
                        if (file != null) {
                            String string2 = file.getName();
                            int n6 = string2.lastIndexOf(46);
                            if (n6 > -1) {
                                string2 = string2.substring(0, n6);
                            }
                            ApplicationView.log(Messages.getString("ControllerApplication.ImportCubeViewsMetadata"));
                            ControllerApplication.this.getDesign().setImportToCurrent(bl);
                            CubeViewsHandler cubeViewsHandler = new CubeViewsHandler(ControllerApplication.this.getApplicationView());
                            cubeViewsHandler.parse(file);
                        }
                    }
                    finally {
                        ControllerApplication.this.getDesign().setImportToCurrent(false);
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error Importing Cube Views Meta Data!", exception);
                }
            }
        }
    }

    class ImportDDL
    extends MDBAction {
        private ImportDDL() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_DDL_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DDL_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_DDL_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(68, 192, false));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Design design = ControllerApplication.this.getApplicationView().selectDesign();
            if (design != null) {
                ControllerApplication.this.getApplicationView().setCurrentDesign(design);
                this.execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block6: {
                try {
                    DDLFilesCollector dDLFilesCollector = new DDLFilesCollector(ControllerApplication.this.getApplicationView());
                    if (!dDLFilesCollector.showDialog() || dDLFilesCollector.getDDLFiles().length <= 0) break block6;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        File file = (File)dDLFilesCollector.getDDLFiles()[0];
                        String string = file.getName();
                        int n = string.lastIndexOf(46);
                        if (n > -1) {
                            string = string.substring(0, n);
                        }
                        String string2 = ControllerApplication.this.getApplicationView().getCurrentDesign().getDesignPath();
                        ApplicationView.log(Messages.getString("ControllerApplication.ImportingDDLFile"));
                        DDLHandler dDLHandler = new DDLHandler(ControllerApplication.this.getApplicationView(), dDLFilesCollector.getSelectedModel(), dDLFilesCollector.swapTargetModel(), dDLFilesCollector.skipMergeDialog());
                        dDLHandler.parse(dDLFilesCollector.getDDLFiles(), string, string2);
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error Importing DDL File!", exception);
                }
            }
        }
    }

    class ImportVar
    extends MDBAction {
        ImportTypeSelector typeSelector;

        private ImportVar() {
            super(MenuUtils.getMnemonicStr(AbstractController.IMPORT_VAR_CAPTION), ControllerApplication.this.getConfiguration().getIcon("VAR_FILE_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.typeSelector = null;
            this.setMenuPath(IMPORT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.IMPORT_VAR_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(86, 192, false));
        }

        public ImportTypeSelector getImportTypeSelector() {
            if (this.typeSelector == null) {
                this.typeSelector = new ImportTypeSelector(ControllerApplication.this.getApplicationView());
            }
            return this.typeSelector;
        }

        private int getImportType() {
            this.getImportTypeSelector().showDialog();
            return this.getImportTypeSelector().getResult();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            block22: {
                Object object;
                if (!ControllerApplication.this.designIsEmpty()) {
                    object = ControllerApplication.this.getApplicationView().addDesign(false);
                    ControllerApplication.this.getApplicationView().setCurrentDesign((Design)object);
                }
                try {
                    File file;
                    object = null;
                    if (this.getImportType() == 2) {
                        return;
                    }
                    int n = this.getImportTypeSelector().getdbType();
                    boolean bl = this.getImportTypeSelector().importProcessModel();
                    if (n == 2) {
                        MappedVarsCollector mappedVarsCollector = new MappedVarsCollector(ControllerApplication.this.getApplicationView());
                        boolean bl2 = mappedVarsCollector.showDialog(ControllerApplication.this.getApplicationView());
                        if (!bl2) break block22;
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            VARParser vARParser = new VARParser();
                            ApplicationView.log(Messages.getString("ControllerApplication.ImportMultiMappedVARFiles"));
                            vARParser.parse(null, ControllerApplication.this.getApplicationView(), mappedVarsCollector, null, bl);
                            break block22;
                        }
                        finally {
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                    if (n != 1) break block22;
                    URLFilter uRLFilter = new URLFilter(){

                        public boolean accept(URL uRL) {
                            File file = new File(uRL.getPath());
                            return file.getName().toLowerCase().endsWith(".var") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("ControllerApplication.VARFiles");
                        }
                    };
                    URLChooser uRLChooser = DialogUtil.newURLChooser();
                    uRLChooser.clearChooseableURLFilters();
                    uRLChooser.setSelectionScope(0);
                    uRLChooser.setSelectionMode(0);
                    uRLChooser.setShowJarsAsDirs(false);
                    uRLChooser.setURLFilter(uRLFilter);
                    String string = ControllerApplication.this.getApplicationView().getSettings().getDefaultImportPath();
                    if (string != null) {
                        uRLChooser.setSelectedURL(URLFactory.newDirURL((String)string));
                    } else {
                        URL uRL = ControllerApplication.this.getApplicationView().getUserHomeDirectory();
                        if (uRL != null) {
                            uRLChooser.setSelectedURL(uRL);
                        }
                    }
                    int n2 = uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerApplication.SelectAFile"));
                    if (n2 != 0 || (file = new File(uRLChooser.getSelectedURL().getPath())) == null) break block22;
                    object = file;
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        VARParser vARParser = new VARParser();
                        ApplicationView.loading = true;
                        try {
                            String string2;
                            int n3 = this.getImportTypeSelector().getComboIndex();
                            switch (n3) {
                                case 0: {
                                    string2 = "Sterling COOL:DBA V2.1";
                                    break;
                                }
                                case 1: {
                                    string2 = "Sterling Bsnteam V7.2";
                                    break;
                                }
                                case 2: {
                                    string2 = "Cayenne Bsnteam V7.2";
                                    break;
                                }
                                default: {
                                    string2 = "Sterling COOL:DBA V2.1";
                                }
                            }
                            ApplicationView.log(Messages.getString("ControllerApplication.ImportVARFile"));
                            vARParser.parse((File)object, ControllerApplication.this.getApplicationView(), null, string2, bl);
                        }
                        finally {
                            ApplicationView.loading = false;
                        }
                    }
                    finally {
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error Importing VAR File!", exception);
                }
            }
        }
    }

    class EqualHeight
    extends MDBAction {
        private EqualHeight() {
            super(MenuUtils.getMnemonicStr(AbstractController.EQUAL_HEIGHT_CAPTION), ControllerApplication.this.getConfiguration().getIcon("EQUAL_HEIGHT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.EQUAL_HEIGHT_CAPTION));
            this.setEnabled(false);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerApplication.this.getApplicationView().getCurrentDPV().getWorkSpace().alignSelected(4);
        }
    }

    class EqualWidth
    extends MDBAction {
        private EqualWidth() {
            super(MenuUtils.getMnemonicStr(AbstractController.EQUAL_WIDTH_CAPTION), ControllerApplication.this.getConfiguration().getIcon("EQUAL_WIDTH_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.EQUAL_WIDTH_CAPTION));
            this.setEnabled(false);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerApplication.this.getApplicationView().getCurrentDPV().getWorkSpace().alignSelected(3);
        }
    }

    class AlignTop
    extends MDBAction {
        private AlignTop() {
            super(MenuUtils.getMnemonicStr(AbstractController.ALIGN_TOP_CAPTION), ControllerApplication.this.getConfiguration().getIcon("ALIGN_TOP_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ALIGN_TOP_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(84, 128, false));
            this.setEnabled(false);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerApplication.this.getApplicationView().getCurrentDPV().getWorkSpace().alignSelected(1);
        }
    }

    class AlignLeft
    extends MDBAction {
        private AlignLeft() {
            super(MenuUtils.getMnemonicStr(AbstractController.ALIGN_LEFT_CAPTION), GUIConfiguration.getInstance().getIcon("ALIGN_LEFT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ALIGN_LEFT_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(76, 128, false));
            this.setEnabled(false);
        }

        @Override
        public boolean addSeparatorBefore() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerApplication.this.getApplicationView().getCurrentDPV().getWorkSpace().alignSelected(0);
        }
    }

    class Redo
    extends MDBAction {
        private Redo(UndoManager undoManager) {
            super(MenuUtils.getMnemonicStr(AbstractController.REDO_CAPTION), ControllerApplication.this.getConfiguration().getIcon("REDO_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.REDO_CAPTION));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        private UndoManager getUndoManager() {
            return ControllerApplication.this.getApplicationView().getCurrentDesign().getUndoManager();
        }

        @Override
        public String getName() {
            return this.getUndoManager().getRedoPresentationName();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            this.getUndoManager().redo();
        }

        protected void updateRedoState() {
        }
    }

    class Undo
    extends MDBAction {
        private Undo(UndoManager undoManager) {
            super(MenuUtils.getMnemonicStr(AbstractController.UNDO_CAPTION), ControllerApplication.this.getConfiguration().getIcon("UNDO_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(EDIT_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.UNDO_CAPTION));
        }

        @Override
        public String getName() {
            return this.getUndoManager().getUndoPresentationName();
        }

        private UndoManager getUndoManager() {
            return ControllerApplication.this.getApplicationView().getCurrentDesign().getUndoManager();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            this.getUndoManager().undo();
        }

        protected void updateUndoState() {
        }
    }

    class ShowTransformationsManager
    extends MDBAction {
        private ShowTransformationsManager() {
            super(MenuUtils.getMnemonicStr(AbstractController.DESIGN_RULES_TRANSFORMATIONS_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DESIGN_RULES_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DESIGN_RULES_TRANSFORMATIONS_CAPTION));
        }

        @Override
        public boolean addSeparatorBefore() {
            return ControllerApplication.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerApplication.this.getApplicationView().setTransformationsManagerVisible(true);
        }
    }

    class ShowCustomLibrariesManager
    extends MDBAction {
        private ShowCustomLibrariesManager() {
            super(MenuUtils.getMnemonicStr(AbstractController.DESIGN_RULES_LIBRARIES_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DESIGN_RULES_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DESIGN_RULES_LIBRARIES_CAPTION));
        }

        @Override
        public boolean addSeparatorBefore() {
            return ControllerApplication.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerApplication.this.getApplicationView().setCustomLibrariesManagerVisible(true);
        }
    }

    class ShowCustomDesignRules
    extends MDBAction {
        private ShowCustomDesignRules() {
            super(MenuUtils.getMnemonicStr(AbstractController.DESIGN_RULES_CUSTOM_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DESIGN_RULES_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DESIGN_RULES_CUSTOM_CAPTION));
        }

        @Override
        public boolean addSeparatorBefore() {
            return ControllerApplication.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerApplication.this.getApplicationView().setCustomDesignRulesManagerVisible(true);
        }
    }

    class ShowDesignRules
    extends MDBAction {
        private ShowDesignRules() {
            super(MenuUtils.getMnemonicStr(AbstractController.DESIGN_RULES_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DESIGN_RULES_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(TOOLS_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DESIGN_RULES_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(82, 576, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return ControllerApplication.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerApplication.this.getApplicationView().setDesignRuleViewVisible(true);
        }
    }

    class PrintDialog
    extends MDBAction {
        DesignPrintModule printer;

        private PrintDialog() {
            super(MenuUtils.getMnemonicStr(AbstractController.PRINT_CAPTION), ControllerApplication.this.getConfiguration().getIcon("PRINT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.printer = null;
            this.setMenuPath(FILE_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.PRINT_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(80, 128, false));
        }

        @Override
        public boolean addSeparatorBefore() {
            return ControllerApplication.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block16: {
                        try {
                            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                            try {
                                String[] stringArray;
                                if (PrintDialog.this.printer == null) {
                                    PrintDialog.this.printer = new DesignPrintModule();
                                }
                                if ((stringArray = PrintDialog.this.printer.connect()) != null) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    Component component = ControllerApplication.this.getApplicationView().getSelectedWorkSpaceComponent();
                                    Dimension dimension = ControllerApplication.this.getApplicationView().getSelectedWorkSpaceSize();
                                    if (dimension.height <= 20 || dimension.width <= 20) {
                                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("ControllerApplication.NoPrintableArea")}, Messages.getString("ControllerApplication.Information"), 2);
                                        return;
                                    }
                                    boolean bl = true;
                                    if (component instanceof Diagram) {
                                        bl = ((Diagram)component).isGridVisible();
                                        ((Diagram)component).setGridVisible(false);
                                    }
                                    try {
                                        PrintDialog.this.printer.setComponentToPrint(component, dimension);
                                        JPanel jPanel = new JPanel(new BorderLayout());
                                        jPanel.add(PrintDialog.this.printer.getButtonPanel(), "North");
                                        JScrollPane jScrollPane = new JScrollPane(PrintDialog.this.printer.getViewComponent());
                                        jScrollPane.getVerticalScrollBar().setUnitIncrement(50);
                                        jPanel.add((Component)jScrollPane, "Center");
                                        JDialog jDialog = new JDialog(ControllerApplication.this.getApplicationView().getFrame(), Messages.getString("ControllerApplication.Print"), false);
                                        jDialog.setContentPane(jPanel);
                                        PrintDialog.this.printer.setDialog(jDialog);
                                        jDialog.pack();
                                        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                                        jDialog.setSize((int)(dimension2.getWidth() / 1.5), (int)(dimension2.getHeight() - 150.0));
                                        ControllerApplication.this.centerOnScreen(jDialog);
                                        jDialog.setModal(true);
                                        jDialog.setVisible(true);
                                        break block16;
                                    }
                                    finally {
                                        if (component instanceof Diagram) {
                                            ((Diagram)component).setGridVisible(bl);
                                        }
                                    }
                                }
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), stringArray, Messages.getString("ControllerApplication.PrintError"), 0);
                            }
                            finally {
                                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                            }
                        }
                        catch (Exception exception) {
                            LOGGER.error("Error Printing Design!", exception);
                        }
                    }
                }
            };
            thread.start();
        }
    }

    class ShowDDLFileEditor
    extends MDBAction {
        private ShowDDLFileEditor() {
            super(MenuUtils.getMnemonicStr(AbstractController.DDL_FILE_EDITOR_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DDL_EDITOR_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DDL_FILE_EDITOR_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(76, 576, false));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            RelationalDesign relationalDesign = ControllerApplication.this.getApplicationView().selectRelationalDesign();
            if (relationalDesign != null) {
                ControllerApplication.this.getDesign().setRelationalDesign(relationalDesign);
                ControllerApplication.this.getApplicationView().setDDLFileMakerEditorVisible(true);
            }
        }
    }

    class ShowDDL
    extends MDBAction {
        @Override
        public boolean addSeparatorBefore() {
            return ControllerApplication.this.isEditable();
        }

        private ShowDDL() {
            super(MenuUtils.getMnemonicStr(AbstractController.DDL_PREVIEW_CAPTION), ControllerApplication.this.getConfiguration().getIcon("DDL_PREVIEW_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DDL_PREVIEW_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(73, 576, false));
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerApplication.this.getApplicationView().setDDLViewerVisible(true);
        }
    }

    class ShowEditor
    extends MDBAction {
        private ShowEditor() {
            super(MenuUtils.getMnemonicStr(AbstractController.EDITOR_CAPTION), ControllerApplication.this.getConfiguration().getIcon("EDIT_ICON", ControllerApplication.this.getPreferredIconSize()));
            this.setMenuPath(VIEW_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.EDITOR_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(10, 512, false));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerApplication.this.getApplicationView().getCurrentDPV() != null && ControllerApplication.this.getApplicationView().getCurrentDPV().getCurrentSelection() != null) {
                SelectableObject selectableObject = ControllerApplication.this.getApplicationView().getCurrentDPV().getCurrentSelection();
                if (selectableObject.getSelectedDesignObject() != null) {
                    selectableObject.getSelectedDesignObject().showPropertyDialog();
                }
            } else {
                Object object;
                TreePath treePath = ControllerApplication.this.getApplicationView().getBrowserPanel().getJTree().getSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof DesignObject) {
                    ((DesignObject)object).showPropertyDialog();
                }
            }
        }
    }
}

