/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignObjectView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectableObjectMultiple;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.TopViewListener;
import oracle.ide.Ide;

public abstract class ContainerView
extends TopView
implements DesignObjectView,
ContainerObjectListener {
    public static final int BORDER_N = 8;
    public static final int BORDER_NE = 7;
    public static final int BORDER_E = 11;
    public static final int BORDER_SE = 5;
    public static final int BORDER_S = 9;
    public static final int BORDER_SW = 4;
    public static final int BORDER_W = 10;
    public static final int BORDER_NW = 6;
    private static final int LEFT = 0;
    private static final int UPPER = 0;
    private static final int MIDDLE = 1;
    private static final int RIGHT = 2;
    private static final int LOWER = 2;
    Object selectedObject = null;
    private Set cvlisteners = new HashSet();
    private final SelectableObject CONTAINER_FOCUS;
    private SelectableObject currentSelection = this.CONTAINER_FOCUS = new SelectionWrapper();

    public ContainerView(ApplicationView applicationView, DesignPartView designPartView) {
        super(applicationView, designPartView);
    }

    @Override
    public ContainerView createViewSynonim(DesignPartView designPartView) {
        return this.createViewSynonim(designPartView, true);
    }

    public ContainerView createViewSynonim(DesignPartView designPartView, boolean bl) {
        ContainerView containerView;
        if (this.getApplicationView() == null) {
            this.applicationView = designPartView.getApplicationView();
        }
        if ((containerView = this.createViewSynonim(this.getApplicationView(), designPartView)) != null) {
            Rectangle rectangle = this.getCellView() != null ? this.getCellView().getBounds().getBounds() : this.getBounds();
            if (bl) {
                rectangle.x += 30;
                rectangle.y += 30;
            }
            containerView.setModel(this.getModel());
            containerView.setBounds(rectangle);
            designPartView.registerForTreemodel(containerView);
            if (designPartView.isVisible()) {
                designPartView.add(containerView, rectangle, null);
            }
        }
        return containerView;
    }

    protected abstract ContainerView createViewSynonim(ApplicationView var1, DesignPartView var2);

    public boolean shouldShowLongNameContained() {
        return false;
    }

    @Override
    public void setModel(DesignObject designObject) {
        ContainerObject containerObject = (ContainerObject)this.getModel();
        super.setModel(designObject);
        if (containerObject != null) {
            containerObject.removeContainerListener(this);
        }
        ((ContainerObject)designObject).addContainerListener(this);
        this.selectedObject = designObject;
    }

    @Override
    public void changed(ContainerObject containerObject, ContainerObjectEvent containerObjectEvent) {
        if (this.getCellView() != null && this.getCellView().getDiagram() != null) {
            this.getCellView().getDiagram().repaint();
        }
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (!designObject.getDesign().isClosing()) {
            if (objectChangeEvent.isType(ObjectChangeEvent.OBJECT_REMOVED) && this.getCellView() != null && this.getCellView().getCell() != null) {
                this.getDesignPartView().getWorkSpace().getModel().remove(new Object[]{this.getCellView().getCell()});
            }
            if (this.getCellView() != null && this.getCellView().getDiagram() != null) {
                this.getCellView().getDiagram().repaint();
            }
        }
    }

    protected int pointInBorder(Point point) {
        int n = 10;
        Rectangle rectangle = this.getBounds();
        int n2 = this.beginMiddleEnd(point.x, n, rectangle.width);
        int n3 = this.beginMiddleEnd(point.y, n, rectangle.height);
        switch (n2 + 7 * n3) {
            case 0: {
                return 6;
            }
            case 7: {
                return 10;
            }
            case 14: {
                return 4;
            }
            case 2: {
                return 7;
            }
            case 9: {
                return 11;
            }
            case 16: {
                return 5;
            }
            case 1: {
                return 8;
            }
            case 15: {
                return 9;
            }
        }
        return 6;
    }

    private int beginMiddleEnd(int n, int n2, int n3) {
        if (n < n2) {
            return 0;
        }
        if (n > n3 - n2) {
            return 2;
        }
        return 1;
    }

    public int minimumComponentSize() {
        return 50;
    }

    protected void setCurrentSelection(SelectableObject selectableObject) {
        boolean bl = this.getDesignPartView().getDesignPart().isDirty();
        boolean bl2 = this.getDesign().isDirty();
        this.currentSelection = selectableObject;
        this.selectedObject = this.currentSelection.getSelectedObject();
        this.getDesignPartView().setCurrentSelection(this.currentSelection, this);
        this.selectedObject = this.currentSelection.getSelectedObject();
        this.getDesignPartView().setCurrentSelection(this.currentSelection, this);
        this.getDesignPartView().getDesignPart().setDirty(bl);
        this.getDesign().setDirty(bl2);
    }

    public void setCurrentSelectionToContainer() {
        this.setCurrentSelection(this.CONTAINER_FOCUS);
    }

    public boolean isSelected() {
        SelectableObject selectableObject = this.getDesignPartView().getCurrentSelection();
        if (selectableObject == null) {
            return false;
        }
        return selectableObject.getSelectedObject() == this.getModel();
    }

    @Override
    public SelectableObject getSelectableObject() {
        return this.currentSelection;
    }

    public void remove() {
        this.remove("");
    }

    public void remove(String string) {
        String string2 = "";
        if (this.hasRelations()) {
            string2 = "\n" + Messages.getString("ContainerView.ContainverView.HasRelationshipsToBeRemoved");
        }
        if (this.canRemove()) {
            int n = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ContainerView.HasMoreThan1GraphicalRepresentation") + string2, this.getModel().getName()), Messages.getString("ContainerView.WhatWouldYouLikeToDo"), 1, 3, null, new String[]{Messages.getString("ContainerView.RemoveObject"), Messages.getString("ContainerView.RemoveView"), Messages.getString("ContainerView.Cancel")}, Messages.getString("ContainerView.RemoveView"));
            if (n == 0) {
                this.getModel().getDesignPart().postUndoableRemoveEditForObject(this.getModel());
                this.remove(true);
                if (!"".equals(string)) {
                    ApplicationView.log(string);
                }
            }
            if (n == 1) {
                DesignPartView designPartView = this.getDesignPartView();
                designPartView.unregisterFromTreemodel(this);
                this.remove(false);
                if (!"".equals(string)) {
                    ApplicationView.log(string);
                }
            }
        } else {
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ContainerView.SureYouWantToDelete") + string2, this.getModel().getName()), Messages.getString("ContainerView.ConfirmObjectDelete"), 0);
            if (n == 0) {
                this.getModel().getDesignPart().postUndoableRemoveEditForObject(this.getModel());
                this.remove(true);
                if (!"".equals(string)) {
                    ApplicationView.log(string);
                }
            }
        }
    }

    protected boolean hasRelations() {
        if (this.getModel() instanceof Entity) {
            Entity entity = (Entity)this.getModel();
            return entity.getRelationConnections().length > 0;
        }
        return false;
    }

    protected int getPreferredIconSize() {
        return 24;
    }

    protected abstract void doPrivateActions();

    public void remove(boolean bl) {
        if (bl) {
            this.getModel().remove();
            this.getDesignPartView().setDirty(true);
            this.getDesignPartView().getWorkSpace().repaint();
        } else {
            if (this.getCellView() != null) {
                Object[] objectArray = new Object[]{this.getCellView().getCell()};
                this.getDesignPartView().getWorkSpace().removeCells(objectArray);
                this.getDesignPartView().setDirty(true);
            }
            this.doPrivateActions();
            this.getDesignPartView().removeView(this);
            this.getDesignPartView().getWorkSpace().repaint();
        }
    }

    public void removeNoneCascade(boolean bl) {
        if (bl) {
            this.getModel().remove();
            this.getDesignPartView().getWorkSpace().repaint();
        } else {
            if (this.getCellView() != null) {
                Object[] objectArray = new Object[]{this.getCellView().getCell()};
                this.getDesignPartView().getWorkSpace().removeCells(objectArray);
            }
            this.doPrivateActions();
            this.getDesignPartView().removeViewNoneCascade(this);
            this.getDesignPartView().getWorkSpace().repaint();
        }
    }

    public void addTopViewListener(TopViewListener topViewListener) {
        this.cvlisteners.add(topViewListener);
    }

    protected void fireChange(ObjectChangeEvent objectChangeEvent) {
        TopViewListener[] topViewListenerArray = this.cvlisteners.toArray(new TopViewListener[0]);
        for (int i = 0; i < topViewListenerArray.length; ++i) {
            try {
                topViewListenerArray[i].changed(this, objectChangeEvent);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Listener caused exception: ContainerView");
            }
        }
    }

    public void addTVTypeSubstitutions() {
        ContainerObject containerObject = (ContainerObject)this.getModel();
        DesignPartView designPartView = this.getDesignPartView();
        TypeSubstitution typeSubstitution = containerObject.getTypeSubstitution();
        if (typeSubstitution != null && typeSubstitution.getChildCV(designPartView) == null) {
            typeSubstitution.setChildCV(this);
        }
        for (TypeSubstitution typeSubstitution2 : containerObject.getSubTypeSubstitutions()) {
            if (typeSubstitution2.getParentCV(designPartView) != null) continue;
            typeSubstitution2.setParentCV(this);
        }
    }

    public void removeTopViewListener(TopViewListener topViewListener) {
        this.cvlisteners.remove(topViewListener);
    }

    protected abstract void hideRelations();

    @Override
    public boolean canRemove() {
        DesignPartView designPartView = this.getDesignPartView();
        int n = this.getModel().getViewsCountForDPV(designPartView);
        if (n > 1) {
            return true;
        }
        DesignPartView designPartView2 = designPartView.getMasterDPV();
        if (designPartView2 == null) {
            designPartView2 = designPartView;
        }
        return designPartView2 != this.getModel().getDesignPart().getMainView();
    }

    public Rectangle getActualBounds() {
        Rectangle rectangle = this.getCellView() != null ? this.getCellView().getBounds().getBounds() : this.getBounds();
        return rectangle;
    }

    public void setActualBoundsRect(Rectangle rectangle) {
        if (this.getCellView() != null) {
            this.getCellView().setNewBounds(rectangle);
        }
        this.location.x = rectangle.x;
        this.location.y = rectangle.y;
        this.size.width = rectangle.width;
        this.size.height = rectangle.height;
    }

    public void setActualBounds(int n, int n2, int n3, int n4) {
        if (this.getCellView() != null) {
            this.getCellView().setNewBounds(new Rectangle(n, n2, n3, n4));
        }
        this.location.x = n;
        this.location.y = n2;
        this.size.width = n3;
        this.size.height = n4;
    }

    class SelectionWrapper
    implements SelectableObject {
        SelectionWrapper() {
        }

        @Override
        public Object[] getSelectedContainedObject() {
            return null;
        }

        @Override
        public boolean hasContainedArray() {
            return false;
        }

        public ContainerView getContainerView() {
            return ContainerView.this;
        }

        @Override
        public Object getSelectedObject() {
            return this.getSelectedDesignObject();
        }

        @Override
        public DesignObject getSelectedDesignObject() {
            return ContainerView.this.getModel();
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public SelectableObjectMultiple asMultiple() {
            throw new ClassCastException("Not a SelectableObjectMultiple");
        }
    }
}

