/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.xtdmapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;

public class XtdMapping
implements RepositoryObject {
    public static final int TYPE_ENTITY = 0;
    public static final int TYPE_ATTRIBUTE = 1;
    public static final int TYPE_KEY = 2;
    public static final int TYPE_RELATION = 3;
    public static final int TYPE_TABLE = 4;
    public static final int TYPE_COLUMN = 5;
    public static final int TYPE_INDEX = 6;
    public static final int TYPE_PKEY = 7;
    public static final int TYPE_FKEY = 8;
    public static final int TYPE_INHERITANCE = 9;
    public static final int TYPE_SUBVIEW = 10;
    public static final int TYPE_TABLE_VIEW = 11;
    public static final int TYPE_ENTITY_VIEW = 12;
    public static final int TYPE_FKARC = 13;
    public static final int TYPE_ARC = 14;
    public static final int INH_TYPE_UNKNOWN = -1;
    public static final int INH_TYPE_NONE = 0;
    public static final int INH_TYPE_SINGLE_TABLE = 1;
    public static final int INH_TYPE_LEAFS_ONLLY = 2;
    public static final int INH_TYPE_ALL = 3;
    public static final int INH_TYPE_ALL_FKINH_FKEY = 4;
    public static final int INH_TYPE_ALL_FKINH_COLUMN = 5;
    private static final char SEPARATOR = '@';
    private String deletedID = null;
    private boolean propagateName;
    private DesignObject owner;
    private DesignObject target;
    private String ownerID;
    private String targetID;
    private String targetDesignPartID;
    private String ownerDesignPartID;
    private DesignPart targetDesignPart;
    private DesignPart ownerDesignPart;
    private String ownerName = "";
    private String targetName = "";
    private String targetDesignPartName = "";
    private String ownerDesignPartName = "";
    private int ownerType = -1;
    private int targetType = -1;
    private int inheritanceType = 0;
    private long creationTime;
    private String realSourceEntityID;
    private String realTargetEntityID;
    private Design design;
    private String recreatedContainerID = "";
    private boolean fwEngineer = true;
    private boolean revEngineer = true;
    private List columns;
    private List attributes;
    private List indexes;
    private List keys;
    private String repositoryOID = null;
    private String repositoryOVID = null;
    private String ownerRepOID = null;
    private String targetRepOID = null;
    private String targetContainerID = null;
    private String ownerContainerID = null;
    private boolean dirty = true;
    private boolean checkedOut = false;
    private String checkedOutBy = "";
    private boolean checkedOutByMe = false;
    private RepositoryObject pac_Element;
    private String id;

    public XtdMapping(DesignObject designObject, DesignObject designObject2) {
        this.creationTime = System.currentTimeMillis();
        this.owner = designObject;
        this.target = designObject2;
        this.ownerID = designObject.getObjectID();
        this.targetID = designObject2.getObjectID();
        this.ownerName = designObject.getName();
        this.targetName = designObject2.getName();
        this.targetDesignPart = designObject2.getDesignPart();
        this.ownerDesignPart = designObject.getDesignPart();
        this.ownerDesignPartName = this.ownerDesignPart.getName();
        this.targetDesignPartName = this.targetDesignPart.getName();
        this.ownerType = XtdMapping.getTypeFor(designObject);
        this.targetType = XtdMapping.getTypeFor(designObject2);
        this.ownerRepOID = designObject.getRepositoryOID();
        this.targetRepOID = designObject2.getRepositoryOID();
        if (designObject instanceof ContainedObject) {
            this.ownerContainerID = ((ContainedObject)designObject).getContainer().getObjectID();
        }
        if (designObject2 instanceof ContainedObject) {
            this.targetContainerID = ((ContainedObject)designObject2).getContainer().getObjectID();
        }
        if (designObject instanceof KeyObject) {
            this.ownerContainerID = ((KeyObject)designObject).getContainerObject().getObjectID();
        }
        if (designObject2 instanceof KeyObject) {
            this.targetContainerID = ((KeyObject)designObject2).getContainerObject().getObjectID();
        }
        this.design = designObject.getDesign();
        this.setMappingID(designObject, designObject2);
    }

    public XtdMapping(DesignObject designObject, DesignObject designObject2, boolean bl) {
        this(designObject, designObject2);
        if (bl) {
            if (designObject instanceof Entity) {
                this.addContainedForEntity((Entity)designObject);
            } else if (designObject instanceof Table) {
                this.addContainedForTable((Table)designObject);
            }
            if (designObject2 instanceof Table) {
                this.addContainedForTable((Table)designObject2);
            } else if (designObject2 instanceof Entity) {
                this.addContainedForEntity((Entity)designObject2);
            }
        }
    }

    public XtdMapping(String string, String string2, Design design) {
        this.targetID = string2;
        this.ownerID = string;
        this.design = design;
    }

    @Override
    public Design getDesign() {
        if (this.owner != null) {
            return this.owner.getDesign();
        }
        if (this.target != null) {
            return this.target.getDesign();
        }
        return this.design;
    }

    private DesignPart getDesignPart(String string) {
        if (this.getDesign().getLogicalDesign().getObjectID().equalsIgnoreCase(string)) {
            return this.getDesign().getLogicalDesign();
        }
        Iterator iterator = this.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!relationalDesign.getObjectID().equalsIgnoreCase(string)) continue;
            return relationalDesign;
        }
        return null;
    }

    public DesignPart getTargetDesignPart() {
        if (this.targetDesignPart == null && this.targetDesignPartID != null) {
            this.targetDesignPart = this.getDesignPart(this.targetDesignPartID);
        }
        return this.targetDesignPart;
    }

    public DesignPart getOwnerDesignPart() {
        if (this.ownerDesignPart == null && this.ownerDesignPartID != null) {
            this.ownerDesignPart = this.getDesignPart(this.ownerDesignPartID);
        }
        return this.ownerDesignPart;
    }

    public boolean isTargetDesignPartLoaded() {
        DesignPart designPart = this.getTargetDesignPart();
        if (designPart == null) {
            return false;
        }
        return this.getTargetDesignPart().isLoaded();
    }

    public boolean isOwnerDesignPartLoaded() {
        if (this.getOwnerDesignPart() != null) {
            return this.getOwnerDesignPart().isLoaded();
        }
        return false;
    }

    public DesignObject getTargetObject() {
        if (this.target == null) {
            if (this.isTargetDesignPartLoaded()) {
                DesignPartView designPartView;
                this.target = this.getDesign().getDesignObject(this.targetID);
                if (this.target == null && this.getTargetType() == 10 && this.getTargetDesignPart() != null && (designPartView = this.getTargetDesignPart().getSubViewByID(this.targetID)) != null) {
                    this.target = designPartView.getPlaceHolder();
                }
                return this.target;
            }
            return null;
        }
        return this.target;
    }

    public DesignObject getOwnerObject() {
        if (this.owner == null && this.isOwnerDesignPartLoaded()) {
            DesignPartView designPartView;
            this.owner = this.getDesign().getDesignObject(this.ownerID);
            if (this.owner == null && this.getTargetType() == 10 && this.getOwnerDesignPart() != null && (designPartView = this.getOwnerDesignPart().getSubViewByID(this.ownerID)) != null) {
                this.owner = designPartView.getPlaceHolder();
            }
            return this.owner;
        }
        return this.owner;
    }

    public boolean isPropagateName() {
        return this.propagateName;
    }

    public void setPropagateName(boolean bl) {
        this.propagateName = bl;
    }

    public String getTargetID() {
        if (this.target != null) {
            this.targetID = this.target.getObjectID();
        }
        return this.targetID;
    }

    public String getTargetShortID() {
        if (this.target != null) {
            this.targetID = this.target.getShortObjectID();
        }
        return this.targetID;
    }

    public String getOwnerID() {
        if (this.owner != null) {
            this.ownerID = this.owner.getObjectID();
        }
        return this.ownerID;
    }

    public String getOwnerShortID() {
        if (this.owner != null) {
            this.ownerID = this.owner.getShortObjectID();
        }
        return this.ownerID;
    }

    public String getOwnerDesignPartID() {
        int n;
        if (this.owner != null) {
            return this.owner.getDesignPart().getObjectID();
        }
        if (this.ownerDesignPartID == null && this.ownerID != null && (n = this.ownerID.indexOf(64)) > -1) {
            this.ownerDesignPartID = this.ownerID.substring(0, n);
        }
        return this.ownerDesignPartID;
    }

    public String getTargetDesignPartID() {
        int n;
        if (this.target != null) {
            return this.target.getDesignPart().getObjectID();
        }
        if (this.targetDesignPartID == null && this.targetID != null && (n = this.targetID.indexOf(64)) > -1) {
            this.targetDesignPartID = this.targetID.substring(0, n);
        }
        return this.targetDesignPartID;
    }

    public String getOwnerName() {
        if (this.owner != null) {
            this.ownerName = this.owner.getName();
        }
        return this.ownerName;
    }

    public void setOwnerName(String string) {
        this.ownerName = string;
    }

    public String getTargetName() {
        if (this.target != null) {
            this.targetName = this.target.getName();
        }
        return this.targetName;
    }

    public void setTargetName(String string) {
        this.targetName = string;
    }

    public String getOwnerDesignPartName() {
        if (this.ownerDesignPart != null) {
            this.ownerDesignPartName = this.ownerDesignPart.getName();
        }
        return this.ownerDesignPartName;
    }

    public void setOwnerDesignPartName(String string) {
        this.ownerDesignPartName = string;
    }

    public String getTargetDesignPartName() {
        if (this.targetDesignPart != null) {
            this.targetDesignPartName = this.targetDesignPart.getName();
        }
        return this.targetDesignPartName;
    }

    public void setTargetDesignPartName(String string) {
        this.targetDesignPartName = string;
    }

    public int getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(int n) {
        this.ownerType = n;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public void setTargetType(int n) {
        this.targetType = n;
    }

    public static int getTypeFor(DesignObject designObject) {
        if (designObject instanceof Entity) {
            return 0;
        }
        if (designObject instanceof Attribute) {
            return 1;
        }
        if (designObject instanceof CandidateKey) {
            return 2;
        }
        if (designObject instanceof EntityView) {
            return 12;
        }
        if (designObject instanceof Arc) {
            return 14;
        }
        if (designObject instanceof InheritanceRelation) {
            return 9;
        }
        if (designObject instanceof Relation) {
            return 3;
        }
        if (designObject instanceof Table) {
            return 4;
        }
        if (designObject instanceof Column) {
            return 5;
        }
        if (designObject instanceof FKIndexAssociation) {
            return 8;
        }
        if (designObject instanceof Index) {
            if (((Index)designObject).isPK()) {
                return 7;
            }
            if (designObject instanceof FKIndexAssociation) {
                return 8;
            }
            return 6;
        }
        if (designObject instanceof TableView) {
            return 11;
        }
        if (designObject instanceof FKArc) {
            return 13;
        }
        if (designObject instanceof DesignPartViewPlaceHolder) {
            return 10;
        }
        return -1;
    }

    public DesignObject getObjectMappedTo(DesignObject designObject) {
        if (this.deletedID != null) {
            return null;
        }
        if (this.getOwnerObject() == designObject) {
            return this.getTargetObject();
        }
        return this.getOwnerObject();
    }

    public int getTypeOfObjectMappedTo(DesignObject designObject) {
        if (this.getOwnerObject() == designObject) {
            return this.getTargetType();
        }
        return this.getOwnerType();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long l) {
        this.creationTime = l;
    }

    public void setOwnerDesignPartID(String string) {
        this.ownerDesignPartID = string;
    }

    public void setTargetDesignPartID(String string) {
        this.targetDesignPartID = string;
    }

    public int getInheritanceType() {
        return this.inheritanceType;
    }

    public void setInheritanceType(int n) {
        this.inheritanceType = n;
    }

    public String getRealSourceEntityID() {
        return this.realSourceEntityID;
    }

    public void setRealSourceEntityID(String string) {
        this.realSourceEntityID = string;
    }

    public String getRealTargetEntityID() {
        return this.realTargetEntityID;
    }

    public void setRealTargetEntityID(String string) {
        this.realTargetEntityID = string;
    }

    public String getOtherID(String string) {
        if (this.targetID != null && this.targetID.equals(string)) {
            return this.ownerID;
        }
        if (this.ownerID != null && this.ownerID.equals(string)) {
            return this.targetID;
        }
        throw new RuntimeException("Wrong input ID in method getOtherID(id) - input ID " + String.valueOf(string));
    }

    public String getNameFor(String string) {
        if (this.targetID != null && this.targetID.equals(string)) {
            if (this.target != null) {
                return this.target.getName();
            }
            return this.targetName;
        }
        if (this.ownerID != null && this.ownerID.equals(string)) {
            if (this.owner != null) {
                return this.owner.getName();
            }
            return this.ownerName;
        }
        throw new RuntimeException("Wrong input ID in method getOtherID(id) - input ID " + String.valueOf(string));
    }

    public String getNameForOtherID(String string) {
        if (this.targetID != null && this.targetID.equals(string)) {
            if (this.owner != null) {
                return this.owner.getName();
            }
            return this.ownerName;
        }
        if (this.ownerID != null && this.ownerID.equals(string)) {
            if (this.target != null) {
                return this.target.getName();
            }
            return this.targetName;
        }
        throw new RuntimeException("Wrong input ID in method getOtherID(id) - input ID " + String.valueOf(string));
    }

    public DesignObject getNoneDeletedObject() {
        if (this.deletedID != null) {
            if (this.targetID != null && this.targetID.equals(this.deletedID)) {
                return this.owner;
            }
            if (this.ownerID != null && this.ownerID.equals(this.deletedID)) {
                return this.target;
            }
            throw new RuntimeException("Wrong input ID in method getOtherID(id) - input ID " + String.valueOf(this.deletedID));
        }
        return null;
    }

    public boolean isDeleted() {
        return this.deletedID != null;
    }

    public String getDeletedID() {
        return this.deletedID;
    }

    public void setDeletedID(String string) {
        this.deletedID = string;
    }

    void clearDeletedID() {
        this.deletedID = null;
    }

    void restoreObject(DesignObject designObject) {
        if (designObject.getObjectID().equalsIgnoreCase(this.owner.getObjectID())) {
            this.owner = designObject;
        } else if (designObject.getObjectID().equalsIgnoreCase(this.target.getObjectID())) {
            this.target = designObject;
        }
    }

    public void setDesign(Design design) {
        this.design = design;
    }

    public String getRecreatedContainerID() {
        return this.recreatedContainerID;
    }

    public void setRecreatedContainerID(String string) {
        this.recreatedContainerID = string;
    }

    void nulifyObjects() {
        this.owner = null;
        this.target = null;
    }

    public String getOtherName(String string) {
        if (string.equalsIgnoreCase(this.targetID)) {
            return this.ownerName;
        }
        if (string.equalsIgnoreCase(this.ownerID)) {
            return this.targetName;
        }
        return "";
    }

    public boolean isFwEngineer() {
        return this.fwEngineer;
    }

    public void setFwEngineer(boolean bl) {
        this.fwEngineer = bl;
    }

    public boolean isRevEngineer() {
        return this.revEngineer;
    }

    public void setRevEngineer(boolean bl) {
        this.revEngineer = bl;
    }

    private void addContainedForTable(Table table) {
        for (DesignObject designObject : table.getElementsCollection()) {
            if (!designObject.shouldBeEngineered()) continue;
            this.getColumns().add(designObject.getObjectID());
        }
        for (DesignObject designObject : table.getPKandUKConstraints()) {
            if (!designObject.shouldBeEngineered()) continue;
            this.getIndexes().add(designObject.getObjectID());
        }
    }

    private void addContainedForEntity(Entity entity) {
        for (DesignObject designObject : entity.getElementsCollection()) {
            if (!designObject.shouldBeEngineered()) continue;
            this.getAttributes().add(designObject.getObjectID());
        }
        Iterator iterator = entity.getKeySet().iterator();
        while (iterator.hasNext()) {
            DesignObject designObject;
            designObject = (DesignObject)iterator.next();
            if (!designObject.shouldBeEngineered()) continue;
            this.getKeys().add(designObject.getObjectID());
        }
    }

    public void initializeContained() {
        if (this.owner != null && this.target != null) {
            if (this.owner instanceof Entity) {
                this.addContainedForEntity((Entity)this.owner);
            } else if (this.owner instanceof Table) {
                this.addContainedForTable((Table)this.owner);
            }
            if (this.target instanceof Table) {
                this.addContainedForTable((Table)this.target);
            } else if (this.target instanceof Entity) {
                this.addContainedForEntity((Entity)this.target);
            }
        }
    }

    @Override
    public boolean canBedeleted() {
        return true;
    }

    @Override
    public String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    @Override
    public String getName() {
        if (this.owner != null) {
            return this.owner.getName();
        }
        return "noName";
    }

    @Override
    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    @Override
    public String getRepositoryOVID() {
        return this.repositoryOVID;
    }

    @Override
    public boolean isCheckedOut() {
        return this.checkedOut;
    }

    @Override
    public boolean isCheckedOutByMe() {
        return this.checkedOutByMe;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setCheckedOut(boolean bl) {
        this.checkedOut = bl;
    }

    @Override
    public void setCheckedOutBy(String string) {
        this.checkedOutBy = string;
    }

    @Override
    public void setCheckedOutByMe(boolean bl) {
        this.checkedOutByMe = bl;
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    @Override
    public void setRepositoryOID(String string) {
        this.repositoryOID = string;
    }

    @Override
    public void setRepositoryOVID(String string) {
        this.repositoryOVID = string;
    }

    public String getOwnerRepOID() {
        if (this.owner != null) {
            return this.owner.getRepositoryOID();
        }
        return this.ownerRepOID;
    }

    public void setOwnerRepOID(String string) {
        this.ownerRepOID = string;
    }

    public String getTargetRepOID() {
        if (this.target != null) {
            return this.target.getRepositoryOID();
        }
        return this.targetRepOID;
    }

    public void setTargetRepOID(String string) {
        this.targetRepOID = string;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        return this.pac_Element;
    }

    @Override
    public boolean isPAC_Element() {
        return true;
    }

    @Override
    public void setPAC_Element(RepositoryObject repositoryObject) {
        if (!this.isPAC_Element()) {
            this.pac_Element = repositoryObject;
        }
    }

    public boolean isMappingForContainer(String string) {
        if (this.ownerContainerID != null && this.ownerContainerID.equals(string)) {
            return true;
        }
        if (this.targetContainerID != null && this.targetContainerID.equals(string)) {
            return true;
        }
        if (this.deletedID != null && this.deletedID.equals(string)) {
            return true;
        }
        return this.recreatedContainerID != null && this.recreatedContainerID.equals(string);
    }

    public String getTargetContainerID() {
        if (this.targetContainerID == null) {
            if (this.target == null && this.getDesign() != null) {
                this.target = this.getDesign().getDesignObject(this.targetID);
            }
            if (this.target != null) {
                if (this.target instanceof ContainedObject) {
                    this.targetContainerID = ((ContainedObject)this.target).getContainer().getObjectID();
                }
                if (this.target instanceof KeyObject) {
                    this.targetContainerID = ((KeyObject)this.target).getContainerObject().getObjectID();
                }
            }
        }
        return this.targetContainerID;
    }

    public void setTargetContainerID(String string) {
        this.targetContainerID = string;
    }

    public String getOwnerContainerID() {
        if (this.ownerContainerID == null) {
            if (this.owner == null && this.getDesign() != null) {
                this.owner = this.getDesign().getDesignObject(this.ownerID);
            }
            if (this.owner != null) {
                if (this.owner instanceof ContainedObject) {
                    this.ownerContainerID = ((ContainedObject)this.owner).getContainer().getObjectID();
                }
                if (this.owner instanceof KeyObject) {
                    this.ownerContainerID = ((KeyObject)this.owner).getContainerObject().getObjectID();
                }
            }
        }
        return this.ownerContainerID;
    }

    public void setOwnerContainerID(String string) {
        this.ownerContainerID = string;
    }

    public String getID() {
        if ("nullnull".equals(this.id)) {
            this.id = null;
        }
        if (this.id == null) {
            String string = this.getOwnerShortID();
            if (string == null) {
                string = this.getDeletedID();
            }
            if (string == null) {
                String string2 = this.getTargetShortID();
                if (string2 == null) {
                    return "";
                }
                return string2;
            }
            String string3 = this.getTargetShortID();
            if (string3 == null) {
                string3 = this.getDeletedID();
            }
            DesignObject designObject = null;
            DesignObject designObject2 = null;
            try {
                designObject = this.getOwnerObject();
                designObject2 = this.getTargetObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (designObject != null && designObject2 != null) {
                this.setMappingID(designObject, designObject2);
            } else if (designObject != null) {
                if (designObject.getDesignPart() instanceof LogicalDesign) {
                    this.id = designObject.getShortObjectID() + string3;
                } else if (string3 != null) {
                    this.id = string3 + designObject.getShortObjectID();
                }
            } else if (designObject2 != null) {
                if (designObject2.getDesignPart() instanceof LogicalDesign) {
                    this.id = designObject2.getShortObjectID() + string;
                } else if (string != null) {
                    this.id = string + designObject2.getShortObjectID();
                }
            } else {
                this.id = string3 != null ? string + string3 : string;
            }
        }
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    private void setMappingID(DesignObject designObject, DesignObject designObject2) {
        this.id = designObject.getDesignPart() instanceof LogicalDesign || !(designObject2.getDesignPart() instanceof RelationalDesign) ? designObject.getShortObjectID() + designObject2.getShortObjectID() : designObject2.getShortObjectID() + designObject.getShortObjectID();
    }

    public void setTargetID(String string) {
        this.targetID = string;
    }

    public void setOwnerID(String string) {
        this.ownerID = string;
    }

    public String getOtherContainerID(String string) {
        if (string != null) {
            this.getOwnerContainerID();
            this.getTargetContainerID();
            if (string.equals(this.ownerContainerID) && !string.equals(this.targetContainerID)) {
                return this.targetContainerID;
            }
            if (!string.equals(this.ownerContainerID) && string.equals(this.targetContainerID)) {
                return this.ownerContainerID;
            }
        }
        return "null";
    }

    public List getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList();
        }
        return this.columns;
    }

    public List getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        return this.attributes;
    }

    public List getIndexes() {
        if (this.indexes == null) {
            this.indexes = new ArrayList();
        }
        return this.indexes;
    }

    public List getKeys() {
        if (this.keys == null) {
            this.keys = new ArrayList();
        }
        return this.keys;
    }

    public DesignObject getLogicalObject() {
        DesignObject designObject = this.getOwnerObject();
        if (designObject != null && designObject.getDesignPart() instanceof LogicalDesign) {
            return designObject;
        }
        designObject = this.getTargetObject();
        if (designObject != null && designObject.getDesignPart() instanceof LogicalDesign) {
            return designObject;
        }
        return null;
    }

    public DesignObject getRelationalObject() {
        DesignObject designObject = this.getTargetObject();
        if (designObject != null && designObject.getDesignPart() instanceof RelationalDesign) {
            return designObject;
        }
        designObject = this.getOwnerObject();
        if (designObject != null && designObject.getDesignPart() instanceof RelationalDesign) {
            return designObject;
        }
        return null;
    }
}

