/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.xtdmapping;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.xtdmapping.ContainerMapping;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMapBase;
import oracle.dbtools.crest.model.xtdmapping.MappingCollector;
import oracle.dbtools.crest.model.xtdmapping.RelMapping;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class RMExtendedMap
extends ExtendedMapBase {
    public static final String NAME = "ExtendedMap_RM";

    public RMExtendedMap(Design design, RelationalDesign relationalDesign) {
        super(design);
        this.relationalModel = relationalDesign;
    }

    @Override
    public String getStorageName() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "mapping/ExtendedMap_RM" + this.relationalModel.getObjectID() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public MappingCollector getOrCreateCollector(DesignObject designObject) {
        if (designObject.getDesignPart() instanceof LogicalDesign) {
            return this.getDesign().getExtendedMap().getOrCreateCollector(designObject);
        }
        String string = designObject.getObjectID();
        MappingCollector mappingCollector = (MappingCollector)this.collectorMap.get(string);
        if (mappingCollector == null) {
            mappingCollector = new MappingCollector(this.getDesign(), string);
            this.collectorMap.put(string, mappingCollector);
        }
        return mappingCollector;
    }

    @Override
    protected MappingCollector getOrCreateCollector(String string) {
        MappingCollector mappingCollector = (MappingCollector)this.collectorMap.get(string);
        if (mappingCollector == null && (mappingCollector = this.getDesign().getExtendedMap().getCollector(string)) == null) {
            mappingCollector = new MappingCollector(this.getDesign(), string);
            this.collectorMap.put(string, mappingCollector);
        }
        return mappingCollector;
    }

    public RelationalDesign getRelationalModel() {
        return this.relationalModel;
    }

    public LogicalDesign getLogicalModel() {
        return this.getDesign().getLogicalDesign();
    }

    public List getRelMappings() {
        ArrayList<RelMapping> arrayList = new ArrayList<RelMapping>();
        for (XtdMapping xtdMapping : this.mappings.values()) {
            if (xtdMapping == null) continue;
            RelMapping relMapping = new RelMapping(xtdMapping, this);
            arrayList.add(relMapping);
        }
        return arrayList;
    }

    public RelMapping createRelMapping() {
        XtdMapping xtdMapping = this.createMapping();
        xtdMapping.setTargetDesignPartID(this.getRelationalModel().getObjectID());
        xtdMapping.setOwnerDesignPartID(this.getRelationalModel().getDesign().getLogicalDesign().getObjectID());
        return new RelMapping(xtdMapping, this);
    }

    public ContainerMapping createContainerMapping() {
        XtdMapping xtdMapping = this.createMapping();
        xtdMapping.setTargetDesignPartID(this.getRelationalModel().getObjectID());
        xtdMapping.setOwnerDesignPartID(this.getRelationalModel().getDesign().getLogicalDesign().getObjectID());
        return new ContainerMapping(xtdMapping, this);
    }

    public void addRelMapping(RelMapping relMapping) {
        XtdMapping xtdMapping = relMapping.getXtdMapping();
        this.addMapping(xtdMapping);
    }

    public void addContainerMapping(ContainerMapping containerMapping) {
        XtdMapping xtdMapping = containerMapping.getXtdMapping();
        this.addMapping(xtdMapping);
        for (RelMapping relMapping : containerMapping.getContainedMappings()) {
            this.addRelMapping(relMapping);
        }
    }

    public RelMapping getRelMappingByID(String string) {
        XtdMapping xtdMapping = this.getMappingByID(string);
        if (xtdMapping != null) {
            return new RelMapping(xtdMapping, this);
        }
        return null;
    }

    public ContainerMapping getContainerMappingByID(String string) {
        XtdMapping xtdMapping = this.getMappingByID(string);
        if (xtdMapping != null) {
            return new ContainerMapping(xtdMapping, this);
        }
        return null;
    }

    public List getContainerMappings() {
        RepositoryObject repositoryObject;
        Object object;
        Object object2;
        ArrayList<ContainerMapping> arrayList = new ArrayList<ContainerMapping>();
        ArrayList arrayList2 = new ArrayList();
        HashMap<String, ArrayList<XtdMapping>> hashMap = new HashMap<String, ArrayList<XtdMapping>>();
        ArrayList arrayList3 = new ArrayList();
        for (XtdMapping object3 : this.mappings.values()) {
            ContainerObject containerObject;
            if (object3 == null || (object2 = object3.getRelationalObject()) == null) continue;
            if (!(object2 instanceof ContainedObject || object2 instanceof ContainerWithKeyObject || object2 instanceof KeyObject)) {
                object = new ContainerMapping(object3, this);
                arrayList3.add(object);
                continue;
            }
            if (object2 instanceof ContainerWithKeyObject) {
                object = new ContainerMapping(object3, this);
                arrayList2.add(object);
                continue;
            }
            object = RelMapping.getContainer((DesignObject)object2);
            if (object == null || (repositoryObject = object3.getLogicalObject()) == null || (containerObject = RelMapping.getContainer(repositoryObject)) == null) continue;
            ArrayList<XtdMapping> arrayList4 = (ArrayList<XtdMapping>)hashMap.get(((ModelIDObject)object).getObjectID() + containerObject.getObjectID());
            if (arrayList4 == null) {
                arrayList4 = new ArrayList<XtdMapping>();
                hashMap.put(((ModelIDObject)object).getObjectID() + containerObject.getObjectID(), arrayList4);
            }
            arrayList4.add(object3);
        }
        for (ContainerMapping containerMapping : arrayList2) {
            arrayList.add(containerMapping);
            object2 = (List)hashMap.get(containerMapping.getRelID() + containerMapping.getLogID());
            if (object2 == null) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                repositoryObject = (XtdMapping)object.next();
                containerMapping.addXtdMapping((XtdMapping)repositoryObject);
            }
        }
        arrayList.addAll(arrayList3);
        return arrayList;
    }

    @Override
    public XtdMapping createMapping(DesignObject designObject, DesignObject designObject2) {
        String string;
        String string2 = designObject.getObjectID();
        XtdMapping xtdMapping = this.getMapping(string2, string = designObject2.getObjectID());
        if (xtdMapping == null && (xtdMapping = this.getMapping(string, string2)) == null) {
            if (designObject.getDesignPart() instanceof LogicalDesign) {
                xtdMapping = new XtdMapping(designObject, designObject2);
                this.addMapping(designObject, designObject2, xtdMapping);
            } else {
                xtdMapping = new XtdMapping(designObject2, designObject);
                this.addMapping(designObject2, designObject, xtdMapping);
            }
            this.dirty = true;
        }
        return xtdMapping;
    }

    @Override
    public void clearMappings() {
        Object[] objectArray = this.mappings.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            XtdMapping xtdMapping = (XtdMapping)objectArray[i];
            this.removeMapping(xtdMapping);
            this.getDesign().getExtendedMap().removeMapping(xtdMapping);
        }
        this.deletedMappings.clear();
    }
}

