/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.xtdmapping;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DesignPartListener;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.xtdmapping.MappingCollector;
import oracle.dbtools.crest.model.xtdmapping.RMExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;

public class ExtendedMapBase
implements DesignPartListener,
RepositoryObject,
StorableObject {
    public static final String NAME = "ExtendedMap";
    protected Map collectorMap = new TreeMap();
    protected Map mappings = new TreeMap();
    private Design design;
    protected Map deletedMappings = new TreeMap();
    private String repositoryOID = null;
    private String repositoryOVID = null;
    private RepositoryObject pac_Element;
    public boolean dirty = false;
    protected RelationalDesign relationalModel;

    public ExtendedMapBase(Design design) {
        this.design = design;
    }

    @Override
    public Design getDesign() {
        return this.design;
    }

    public void clearMappings() {
        this.collectorMap.clear();
        this.mappings.clear();
        this.deletedMappings.clear();
    }

    public void clearMappingsMaps() {
        this.mappings.clear();
        this.deletedMappings.clear();
    }

    public XtdMapping getMapping(String string, String string2) {
        return (XtdMapping)this.mappings.get(string + string2);
    }

    public XtdMapping getMapping(DesignObject designObject, DesignObject designObject2) {
        String string = designObject.getObjectID();
        String string2 = designObject2.getObjectID();
        return (XtdMapping)this.mappings.get(string + string2);
    }

    private void addMapping(String string, String string2, XtdMapping xtdMapping) {
        DesignPartView designPartView;
        RepositoryObject repositoryObject;
        this.mappings.put(xtdMapping.getID(), xtdMapping);
        DesignObject designObject = this.getDesign().getDesignObject(string);
        if (designObject == null && (repositoryObject = this.getDesign().getLogicalDesign().getSubViewByID(string)) != null) {
            designObject = ((DesignPartView)repositoryObject).getPlaceHolder();
        }
        if ((repositoryObject = this.getDesign().getDesignObject(string2)) == null && this.relationalModel != null && (designPartView = this.relationalModel.getSubViewByID(string2)) != null) {
            repositoryObject = designPartView.getPlaceHolder();
        }
        if (designObject != null && repositoryObject != null) {
            this.getOrCreateCollector(designObject).addMapping(xtdMapping);
            this.getOrCreateCollector((DesignObject)repositoryObject).addMapping(xtdMapping);
        } else {
            this.getOrCreateCollector(string).addMapping(xtdMapping);
            this.getOrCreateCollector(string2).addMapping(xtdMapping);
        }
    }

    public void restoreDeletedMapping(XtdMapping xtdMapping, DesignObject designObject) {
        xtdMapping.clearDeletedID();
        xtdMapping.restoreObject(designObject);
        this.addMapping(xtdMapping.getOwnerID(), xtdMapping.getTargetID(), xtdMapping);
    }

    private void addMapping(String string, String string2, String string3, XtdMapping xtdMapping) {
        this.deletedMappings.put(xtdMapping.getID(), xtdMapping);
        this.getOrCreateCollector(xtdMapping.getOtherID(string3)).addMapping(xtdMapping);
    }

    protected void addMapping(DesignObject designObject, DesignObject designObject2, XtdMapping xtdMapping) {
        this.mappings.put(xtdMapping.getID(), xtdMapping);
        this.getOrCreateCollector(designObject).addMapping(xtdMapping);
        this.getOrCreateCollector(designObject2).addMapping(xtdMapping);
    }

    public MappingCollector getOrCreateCollector(DesignObject designObject) {
        if (designObject.getDesignPart() instanceof RelationalDesign) {
            return ((RelationalDesign)designObject.getDesignPart()).getRMExtendedMap().getOrCreateCollector(designObject);
        }
        String string = designObject.getObjectID();
        MappingCollector mappingCollector = (MappingCollector)this.collectorMap.get(string);
        if (mappingCollector == null) {
            mappingCollector = new MappingCollector(this.getDesign(), string);
            this.collectorMap.put(string, mappingCollector);
        }
        return mappingCollector;
    }

    protected MappingCollector getOrCreateCollector(String string) {
        MappingCollector mappingCollector = (MappingCollector)this.collectorMap.get(string);
        if (mappingCollector == null) {
            mappingCollector = new MappingCollector(this.getDesign(), string);
            this.collectorMap.put(string, mappingCollector);
        }
        return mappingCollector;
    }

    protected MappingCollector getCollector(String string) {
        return (MappingCollector)this.collectorMap.get(string);
    }

    public XtdMapping createMapping(String string, String string2) {
        XtdMapping xtdMapping = this.getMapping(string, string2);
        if (xtdMapping == null) {
            xtdMapping = new XtdMapping(string, string2, this.design);
            this.addMapping(string, string2, xtdMapping);
        }
        return xtdMapping;
    }

    public XtdMapping createMapping(String string, String string2, String string3) {
        XtdMapping xtdMapping = this.getMapping(string, string2);
        if (xtdMapping == null) {
            xtdMapping = new XtdMapping(string, string2, this.design);
            xtdMapping.setDeletedID(string3);
            this.addMapping(string, string2, string3, xtdMapping);
        }
        return xtdMapping;
    }

    public XtdMapping createMapping(DesignObject designObject, DesignObject designObject2) {
        String string;
        String string2 = designObject.getObjectID();
        XtdMapping xtdMapping = this.getMapping(string2, string = designObject2.getObjectID());
        if (xtdMapping == null && (xtdMapping = this.getMapping(string, string2)) == null) {
            if (designObject.getDesignPart() instanceof LogicalDesign) {
                xtdMapping = new XtdMapping(designObject, designObject2);
                this.addMapping(designObject, designObject2, xtdMapping);
            } else {
                xtdMapping = new XtdMapping(designObject2, designObject);
                this.addMapping(designObject2, designObject, xtdMapping);
            }
            this.dirty = true;
        }
        return xtdMapping;
    }

    private void removeAllMappingsFor(String string) {
        if (string != null) {
            MappingCollector mappingCollector = (MappingCollector)this.collectorMap.get(string);
            if (mappingCollector == null && this.getDesign().getExtendedMap() != this) {
                mappingCollector = this.getDesign().getExtendedMap().getCollector(string);
            }
            if (mappingCollector != null) {
                Object[] objectArray = mappingCollector.getAllMappings().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    XtdMapping xtdMapping = (XtdMapping)objectArray[i];
                    if (!xtdMapping.isDeleted()) {
                        xtdMapping.setDeletedID(string);
                        this.mappings.remove(xtdMapping.getID());
                        this.deletedMappings.put(xtdMapping.getID(), xtdMapping);
                    } else {
                        this.deletedMappings.remove(xtdMapping.getID());
                    }
                    this.setDirty(true);
                }
                mappingCollector.clearAllMappings();
                this.collectorMap.remove(string);
            }
        }
    }

    private void removeAllMappingsFor_NoDeletedTracking(String string) {
        MappingCollector mappingCollector;
        if (string != null && (mappingCollector = (MappingCollector)this.collectorMap.get(string)) != null) {
            Object[] objectArray = mappingCollector.getAllMappings().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                XtdMapping xtdMapping = (XtdMapping)objectArray[i];
                if (!xtdMapping.isDeleted()) {
                    this.mappings.remove(xtdMapping.getOwnerID() + xtdMapping.getTargetID());
                    continue;
                }
                this.deletedMappings.remove(xtdMapping.getID());
            }
            mappingCollector.clearAllMappings();
            this.collectorMap.remove(string);
        }
    }

    private void removeMappingsFor(String string, String string2) {
        MappingCollector mappingCollector;
        MappingCollector mappingCollector2 = (MappingCollector)this.collectorMap.get(string);
        if (mappingCollector2 != null) {
            mappingCollector2.removeMappingFor(string2);
            if (mappingCollector2.isEmpty()) {
                this.collectorMap.remove(string);
            }
        }
        if ((mappingCollector = (MappingCollector)this.collectorMap.get(string2)) != null) {
            mappingCollector.removeMappingFor(string);
            if (mappingCollector.isEmpty()) {
                this.collectorMap.remove(string2);
            }
        }
        this.mappings.remove(string2 + string);
        this.mappings.remove(string + string2);
    }

    public void removeMapping(XtdMapping xtdMapping) {
        DesignObject designObject = xtdMapping.getRelationalObject();
        if (xtdMapping.isDeleted()) {
            String string = xtdMapping.getOtherID(xtdMapping.getDeletedID());
            if (string != null) {
                MappingCollector mappingCollector = (MappingCollector)this.collectorMap.get(string);
                if (mappingCollector != null) {
                    mappingCollector.removeMapping(xtdMapping);
                }
                this.deletedMappings.remove(xtdMapping.getID());
            }
        } else {
            MappingCollector mappingCollector;
            String string = xtdMapping.getOwnerID();
            String string2 = xtdMapping.getTargetID();
            MappingCollector mappingCollector2 = (MappingCollector)this.collectorMap.get(string);
            if (mappingCollector2 != null) {
                mappingCollector2.removeMapping(xtdMapping);
                if (mappingCollector2.isEmpty()) {
                    this.collectorMap.remove(string);
                }
            }
            if ((mappingCollector = (MappingCollector)this.collectorMap.get(string2)) != null) {
                mappingCollector.removeMapping(xtdMapping);
                if (mappingCollector.isEmpty()) {
                    this.collectorMap.remove(string2);
                }
            }
            this.mappings.remove(xtdMapping.getID());
            this.mappings.remove(string2 + string);
            this.mappings.remove(string + string2);
            if (designObject != null && !(this instanceof RMExtendedMap)) {
                ((RelationalDesign)designObject.getDesignPart()).getRMExtendedMap().removeMapping(xtdMapping);
            }
        }
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject designObject) {
    }

    @Override
    public void objectRemoved(DesignPart designPart, DesignObject designObject) {
        MappingCollector mappingCollector;
        if (!designPart.getDesign().isCleaning() && this.isLM_RM_Object(designObject)) {
            if (designPart.isDeleting()) {
                this.removeAllMappingsFor_NoDeletedTracking(designObject.getObjectID());
            } else {
                this.removeAllMappingsFor(designObject.getObjectID());
            }
        } else if (designPart.getDesign().isCleaning() && this.isLM_RM_Object(designObject) && (mappingCollector = (MappingCollector)this.collectorMap.get(designObject.getObjectID())) != null) {
            mappingCollector.nullifyObjects();
        }
    }

    private boolean isLM_RM_Object(DesignObject designObject) {
        if (designObject.getDesignPart() instanceof LogicalDesign) {
            return true;
        }
        return designObject.getDesignPart() instanceof RelationalDesign;
    }

    public List getMappingsForDesignPart(DesignObject designObject, String string) {
        MappingCollector mappingCollector = this.getOrCreateCollector(designObject);
        return mappingCollector.getMappingsForDesignPart(string);
    }

    public List getDeletedMappingsForDesignPart(DesignObject designObject, String string) {
        MappingCollector mappingCollector = this.getOrCreateCollector(designObject);
        return mappingCollector.getDeletedMappingsForDesignPart(string);
    }

    public Map getMappings() {
        return this.mappings;
    }

    public void load() {
        XMLPersistenceManager xMLPersistenceManager = this.design.getAppView().getPersistenceManager();
        this.design.getAppView().setCurrentDesign(this.design);
        AbstractXMLReader abstractXMLReader = xMLPersistenceManager.getExtendedMapReader();
        abstractXMLReader.recreateDesign(NAME, null, false);
    }

    public List getDeletedMappings() {
        if (this.deletedMappings.size() > 0) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.deletedMappings.values());
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    @Override
    public void setRepositoryOID(String string) {
        this.repositoryOID = string;
    }

    @Override
    public String getRepositoryOVID() {
        return this.repositoryOVID;
    }

    @Override
    public void setRepositoryOVID(String string) {
        this.repositoryOVID = string;
    }

    public List getAllMappings() {
        if (this.mappings.size() > 0 || this.deletedMappings.size() > 0) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.mappings.values());
            arrayList.addAll(this.deletedMappings.values());
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean canBedeleted() {
        return false;
    }

    @Override
    public String getCheckedOutBy() {
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isCheckedOut() {
        return false;
    }

    @Override
    public boolean isCheckedOutByMe() {
        return false;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setCheckedOut(boolean bl) {
    }

    @Override
    public void setCheckedOutBy(String string) {
    }

    @Override
    public void setCheckedOutByMe(boolean bl) {
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        return this.pac_Element;
    }

    @Override
    public boolean isPAC_Element() {
        return true;
    }

    @Override
    public void setPAC_Element(RepositoryObject repositoryObject) {
        this.pac_Element = repositoryObject;
    }

    @Override
    public String getStorageName() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "mapping/ExtendedMap.xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStoragePath() {
        String string = this.getDesign().getStoragePath();
        if (string != null && string.length() > 0) {
            try {
                return new File(string, "mapping").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public XtdMapping createMapping() {
        XtdMapping xtdMapping = new XtdMapping(null, null, this.getDesign());
        return xtdMapping;
    }

    public void addMapping(XtdMapping xtdMapping) {
        if (xtdMapping.isDeleted()) {
            this.addMapping(xtdMapping.getOwnerID(), xtdMapping.getTargetID(), xtdMapping.getDeletedID(), xtdMapping);
        } else {
            this.addMapping(xtdMapping.getOwnerID(), xtdMapping.getTargetID(), xtdMapping);
        }
    }

    public XtdMapping getMappingByID(String string) {
        XtdMapping xtdMapping = (XtdMapping)this.mappings.get(string);
        if (xtdMapping == null) {
            return (XtdMapping)this.deletedMappings.get(string);
        }
        return xtdMapping;
    }

    public void removeAllMappingsForDesignPart(String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (string != null && !"".equals(string)) {
            for (Object object : this.mappings.keySet()) {
                XtdMapping xtdMapping = (XtdMapping)this.mappings.get(object);
                if (xtdMapping == null || !string.equalsIgnoreCase(xtdMapping.getTargetDesignPartID()) && !string.equalsIgnoreCase(xtdMapping.getOwnerDesignPartID())) continue;
                arrayList.add(xtdMapping);
            }
            for (Object object : arrayList) {
                if (object == null) continue;
                this.removeMapping((XtdMapping)object);
            }
            arrayList.clear();
            for (Object object : this.deletedMappings.values()) {
                if (object == null || !string.equalsIgnoreCase(((XtdMapping)object).getTargetDesignPartID()) && !string.equalsIgnoreCase(((XtdMapping)object).getOwnerDesignPartID())) continue;
                arrayList.add(object);
            }
            for (Object object : arrayList) {
                if (object == null) continue;
                this.removeMapping((XtdMapping)object);
            }
        }
    }

    public void checkAndCleanMappings() {
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        for (XtdMapping xtdMapping : this.mappings.values()) {
            if (xtdMapping == null || xtdMapping.getOwnerDesignPart() != null && xtdMapping.getTargetDesignPart() != null) continue;
            arrayList.add(xtdMapping);
        }
        for (XtdMapping xtdMapping : arrayList) {
            if (xtdMapping == null) continue;
            this.removeMapping(xtdMapping);
        }
        arrayList.clear();
        for (XtdMapping xtdMapping : this.deletedMappings.values()) {
            if (xtdMapping == null || xtdMapping.getOwnerDesignPart() != null && xtdMapping.getTargetDesignPart() != null) continue;
            arrayList.add(xtdMapping);
        }
        for (XtdMapping xtdMapping : arrayList) {
            if (xtdMapping == null) continue;
            this.removeMapping(xtdMapping);
        }
    }
}

