/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.xtdmapping;

import java.util.ArrayList;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMapBase;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class ExtendedMap
extends ExtendedMapBase {
    public ExtendedMap(Design design) {
        super(design);
    }

    @Override
    public XtdMapping createMapping(DesignObject designObject, DesignObject designObject2) {
        DesignPart designPart = designObject2.getDesignPart();
        if (designPart instanceof RelationalDesign) {
            return ((RelationalDesign)designPart).getRMExtendedMap().createMapping(designObject, designObject2);
        }
        return ((RelationalDesign)designObject.getDesignPart()).getRMExtendedMap().createMapping(designObject2, designObject);
    }

    @Override
    public void checkAndCleanMappings() {
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        for (XtdMapping xtdMapping : this.mappings.values()) {
            if (xtdMapping == null || xtdMapping.getOwnerDesignPart() != null && xtdMapping.getTargetDesignPart() != null) continue;
            arrayList.add(xtdMapping);
        }
        for (XtdMapping xtdMapping : arrayList) {
            if (xtdMapping == null) continue;
            this.removeMapping(xtdMapping);
        }
        arrayList.clear();
        for (XtdMapping xtdMapping : this.deletedMappings.values()) {
            if (xtdMapping == null || xtdMapping.getOwnerDesignPart() != null && xtdMapping.getTargetDesignPart() != null) continue;
            arrayList.add(xtdMapping);
        }
        for (XtdMapping xtdMapping : arrayList) {
            if (xtdMapping == null) continue;
            this.removeMapping(xtdMapping);
        }
    }

    public void distributenMappings() {
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        for (XtdMapping xtdMapping : this.mappings.values()) {
            DesignObject designObject;
            DesignObject designObject2;
            if (xtdMapping == null || (designObject2 = xtdMapping.getRelationalObject()) == null || (designObject = xtdMapping.getLogicalObject()) == null) continue;
            XtdMapping xtdMapping2 = ((RelationalDesign)designObject2.getDesignPart()).getRMExtendedMap().createMapping(designObject, designObject2);
            xtdMapping2.setInheritanceType(xtdMapping.getInheritanceType());
            ((RelationalDesign)designObject2.getDesignPart()).getRMExtendedMap().removeMapping(xtdMapping);
            arrayList.add(xtdMapping);
        }
        for (XtdMapping xtdMapping : arrayList) {
            if (xtdMapping == null) continue;
            this.removeMapping(xtdMapping);
        }
        arrayList.clear();
    }

    public void distributenMappings(RelationalDesign relationalDesign) {
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        for (XtdMapping xtdMapping : this.mappings.values()) {
            DesignObject designObject;
            DesignObject designObject2;
            if (xtdMapping == null || (designObject2 = xtdMapping.getRelationalObject()) == null || (designObject = xtdMapping.getLogicalObject()) == null || designObject2.getDesignPart() != relationalDesign) continue;
            ((RelationalDesign)designObject2.getDesignPart()).getRMExtendedMap().createMapping(designObject, designObject2);
            arrayList.add(xtdMapping);
        }
        for (XtdMapping xtdMapping : arrayList) {
            if (xtdMapping == null) continue;
            this.removeMapping(xtdMapping);
        }
        arrayList.clear();
    }
}

