/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.reference;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.reference.AbstractReference;
import oracle.dbtools.crest.model.reference.Reference;

public class CompositeReference
extends AbstractReference {
    private Reference mainReference = null;
    private List children;

    public CompositeReference(int n, String string) {
        super(n);
        this.setDesignPartId(string);
    }

    public void setMainReference(Reference reference) {
        if (reference != null) {
            this.add(reference);
        }
        this.mainReference = reference;
    }

    public Reference getMainReference() {
        return this.mainReference;
    }

    public boolean isMainReference(Reference reference) {
        if (this.getMainReference() != null) {
            return this.getMainReference().equals(reference);
        }
        return reference == null;
    }

    public void add(Reference reference) {
        if (reference.refersTo(this)) {
            throw new IllegalArgumentException("The argument reference is an ancestor of the this reference");
        }
        if (!this.getChildren().contains(reference)) {
            this.getChildren().add(reference);
        }
    }

    public void remove(Reference reference) {
        this.getChildren().remove(reference);
    }

    protected List getChildren() {
        if (this.children == null) {
            this.children = new ArrayList(2);
        }
        return this.children;
    }

    public int getNumberOfChildReferences() {
        return this.getChildren().size();
    }

    public Iterator getChildReferences() {
        return this.getChildren().iterator();
    }

    public boolean contains(Reference reference) {
        return this.getChildren().contains(reference);
    }

    @Override
    public boolean isCompositeReference() {
        return true;
    }

    @Override
    public CompositeReference asCompositeReference() {
        return this;
    }

    @Override
    public boolean refersTo(Reference reference) {
        return this.equals(reference) || this.contains(reference);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[REF composite: ").append(this.getReferenceId()).append(" { ");
        this.appendStringProps("\n    ", stringBuffer);
        Iterator iterator = this.getChildReferences();
        int n = 0;
        while (iterator.hasNext()) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(iterator.next());
            ++n;
        }
        return stringBuffer.append("}]").toString();
    }

    @Override
    public Iterator getSingleTargetReferences() {
        return new ReferenceIterator();
    }

    @Override
    public boolean containsReferenceWithProperty(String string, String string2) {
        boolean bl = super.containsReferenceWithProperty(string, string2);
        if (!bl) {
            Reference[] referenceArray = this.getChildren().toArray(Reference.PROTOTYPE);
            for (int i = 0; i < referenceArray.length && !bl; ++i) {
                Reference reference = referenceArray[i];
                bl = reference.containsReferenceWithProperty(string, string2);
            }
            return bl;
        }
        return true;
    }

    @Override
    public void removeReferenceWithProperty(String string, String string2) {
        Reference[] referenceArray = this.getChildren().toArray(Reference.PROTOTYPE);
        for (int i = 0; i < referenceArray.length; ++i) {
            Reference reference = referenceArray[i];
            if (reference.hasProperty(string) && (string2 == null || string2.equals(reference.getProperty(string)))) {
                this.remove(reference);
                continue;
            }
            reference.removeReferenceWithProperty(string, string2);
        }
    }

    private class ReferenceIterator
    implements Iterator {
        private Iterator childrenIt;
        private Iterator child;

        private ReferenceIterator() {
            this.childrenIt = CompositeReference.this.getChildReferences();
            this.child = null;
        }

        @Override
        public boolean hasNext() {
            if ((this.child == null || !this.child.hasNext()) && this.childrenIt.hasNext()) {
                Reference reference = (Reference)this.childrenIt.next();
                this.child = reference.getSingleTargetReferences();
                return this.child.hasNext();
            }
            if (this.child != null) {
                return this.child.hasNext();
            }
            return false;
        }

        public Object next() {
            return this.child.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("only allowed to read target reference");
        }
    }
}

