/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.propertyholder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.propertyholder.PVAcceptAll;
import oracle.dbtools.crest.model.propertyholder.PVAcceptNone;
import oracle.dbtools.crest.model.propertyholder.PVClass;
import oracle.dbtools.crest.model.propertyholder.PropertyVerifier;
import oracle.dbtools.crest.model.propertyholder.PropertyWrapper;

public class PropertyHolder {
    private static final String[] PROTO_STRING_ARRAY = new String[0];
    private Map keyMap = new TreeMap();
    private MapEntry nullEntry = new MapEntry();
    private boolean allowStructureChange = this.initialize();
    private List children = null;
    private String name = "unnamed object";

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public void addChild(PropertyHolder propertyHolder) {
        this.getChildList().add(propertyHolder);
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    protected List getChildList() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public int getNumberOfChildren() {
        if (this.hasChildren()) {
            return this.getChildList().size();
        }
        return 0;
    }

    public int getIndexFor(PropertyHolder propertyHolder) {
        if (this.hasChildren()) {
            return this.getChildList().indexOf(propertyHolder);
        }
        return -1;
    }

    public PropertyHolder getChild(int n) {
        if (this.hasChildren()) {
            return (PropertyHolder)this.getChildList().get(n);
        }
        return null;
    }

    public Iterator iteratorDirectChildren() {
        if (this.hasChildren()) {
            return this.getChildList().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected boolean initialize() {
        return true;
    }

    public Object getValue(String string) {
        return this.getEntry(string).getValue();
    }

    public boolean setValue(String string, Object object) {
        return this.getEntry(string).setValue(object);
    }

    public String getErrorFor(String string, Object object) {
        return this.getEntry(string).getPropertyVerifier().getErrorMessage(object);
    }

    private MapEntry getEntry(String string) {
        MapEntry mapEntry = (MapEntry)this.keyMap.get(string);
        if (mapEntry == null) {
            return this.nullEntry;
        }
        return mapEntry;
    }

    public String[] getPropertyNamesArray() {
        return this.keyMap.keySet().toArray(PROTO_STRING_ARRAY);
    }

    public void addProperty(String string, Object object, Class clazz) {
        if (this.allowStructureChange) {
            this.keyMap.put(string, new MapEntryReadWrite(new PVClass(clazz), object, clazz));
        }
    }

    public void addProperty(String string, PropertyVerifier propertyVerifier, Object object, Class clazz) {
        if (this.allowStructureChange) {
            this.keyMap.put(string, new MapEntryReadWrite(propertyVerifier, object, clazz));
        }
    }

    public void addProperty(String string, PropertyVerifier propertyVerifier, PropertyWrapper propertyWrapper, Class clazz) {
        if (this.allowStructureChange) {
            this.keyMap.put(string, new MapEntryWrapped(propertyVerifier, propertyWrapper, clazz));
        }
    }

    public void addProperty(String string, PropertyWrapper propertyWrapper, Class clazz) {
        if (this.allowStructureChange) {
            this.keyMap.put(string, new MapEntryWrapped(propertyWrapper.getPropertyVerifier(), propertyWrapper, clazz));
        }
    }

    static class MapEntryWrapped
    extends MapEntryVerified {
        private PropertyWrapper wrapper;

        private MapEntryWrapped(PropertyVerifier propertyVerifier, PropertyWrapper propertyWrapper, Class clazz) {
            super(propertyVerifier, clazz);
            this.wrapper = propertyWrapper;
        }

        @Override
        public boolean setValue(Object object) {
            if (this.acceptValue(object)) {
                return this.wrapper.setValue(object);
            }
            return false;
        }

        @Override
        public Object getValue() {
            return this.wrapper.getValue();
        }

        @Override
        public PropertyWrapper getPropertyWrapper() {
            return this.wrapper;
        }
    }

    static class MapEntryReadWrite
    extends MapEntryVerified {
        private Object value;

        private MapEntryReadWrite(PropertyVerifier propertyVerifier, Object object, Class clazz) {
            super(propertyVerifier, clazz);
            this.value = object;
        }

        @Override
        public boolean setValue(Object object) {
            if (this.acceptValue(object)) {
                this.value = object;
                return true;
            }
            return false;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    static abstract class MapEntryVerified
    extends MapEntry {
        private PropertyVerifier verifier;
        private Class propertyClass;

        private MapEntryVerified(PropertyVerifier propertyVerifier, Class clazz) {
            this.verifier = propertyVerifier;
            this.propertyClass = clazz;
        }

        @Override
        public boolean acceptValue(Object object) {
            return this.verifier.accept(object);
        }

        @Override
        public Class getPropertyClass() {
            return this.propertyClass;
        }

        @Override
        public PropertyVerifier getPropertyVerifier() {
            if (this.verifier == null) {
                return PVAcceptAll.getInstance();
            }
            return this.verifier;
        }
    }

    static class MapEntry
    implements PropertyWrapper {
        private static PropertyVerifier nullverifier = PVAcceptNone.createInstance("Non existant property");

        MapEntry() {
        }

        @Override
        public boolean setValue(Object object) {
            return false;
        }

        @Override
        public Object getValue() {
            return null;
        }

        public boolean acceptValue(Object object) {
            return false;
        }

        public Class getPropertyClass() {
            return Object.class;
        }

        @Override
        public boolean hasChoices() {
            return false;
        }

        @Override
        public Object[] getChoices() {
            return null;
        }

        public PropertyWrapper getPropertyWrapper() {
            return this;
        }

        @Override
        public PropertyVerifier getPropertyVerifier() {
            return nullverifier;
        }
    }
}

